/*********************************************************************
*                                                                    *
*                                                                    *
*                                                                    *
*             D R A W   -   C L I E N T   L I B R A R Y              *
*                                                                    *
*                 (Main Control Graphic Directives)                  *
*                     (Multi-Language Support)                       *
*                                                                    *
*                     version 2.4 31-jan-2009                        *
*                                                                    *
*                               by                                   *
*                                                                    *
*          Pierre Wolfers, Laboratoire de Cristallographie           *
*                                                                    *
*          CNRS GRENOBLE,  25 Avenue des Martyrs, B.P. 166           *
*                                                                    *
*                     F 38042 GRENOBLE CEDEX 9                       *
*                                                                    *
*                           F R A N C E                              *
*                                                                    *
*                                                                    *
*                                                                    *
*********************************************************************/



/*///////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
///////////////////////////////////////////////////////////////////////*/




#include <draw/draw_common.h>
#include <draw/draw_env.h>      /* Load the DRAW library Environment */




/*********************************************************************/

int  DRW_API( new_seg )( int *n )
{ /* Open a new segment */
  return Draw_New_Seg( *n );
} /* draw_new_seg */


/*********************************************************************/

void DRW_API( seg_end )()
{ /* End of current segment */
  Draw_Seg_End();
} /* draw_seg_end */


/*********************************************************************/

void DRW_API( del_seg )( int *n )
{ /* Delete the specified Segment */
  return Draw_Del_Seg( *n );
} /* draw_del_seg */


/*********************************************************************/

int DRW_API( update_seg )( int *n, int *fapp )
{ /* Update a specified existing segment */
  return Draw_Update_Seg( *n, *fapp );
} /* draw_update_seg */


/*********************************************************************/

void DRW_API( include_seg )( int *n )
{ /* Include a specified existing segment */
  Draw_Include_Seg( *n );
} /* draw_include_seg */


/*********************************************************************/

void DRW_API( seg_attr )( int *seg_id, int *det, int *hli, int *vis, float *prior )
{ /* Set specified attributs to the specified segment */
  Draw_Seg_Attr( *seg_id, *det, *hli, *vis, *prior );
} /* draw_seg_attr */


/*********************************************************************/

void DRW_API( set_pickid )( int *pic_id )
{ /* Set the specified pick identifier to the following part
     of current seg. */
  Draw_Set_Pickid( *pic_id );
} /* draw_set_pickid */


/*********************************************************************/

int  DRW_API( detectable )( int *det_flg )
{ /* Set the specified pick identifier to the following part
     of current seg. */
  return Draw_Detectable( *det_flg );
} /* draw_detectable */


/*********************************************************************/

int  DRW_API( seg_inquire )( )
{ /* Set the specified pick identifier to the following part
     of current seg. */
  return Draw_Seg_Inquire();
} /* draw_seg_inquire */


/*********************************************************************/

int  DRW_API( push_matrix )()
{ /* Open a new segment */
  return Draw_Push_Matrix();
} /* draw_push_matrix */


/*********************************************************************/

void DRW_API( pop_matrix )()
{ /* Open a new segment */
  Draw_Pop_Matrix();
} /* draw_pop_matrix */


/*********************************************************************/

void DRW_API( seg_unit_transf )( int *iseg, int *upd )
{ /* Set Segment Matrix Translation to unit Matrix */
  Draw_Seg_Unit_Transf( *iseg, *upd );
} /* draw_seg_unit_transf */


/*********************************************************************/

void DRW_API( mat_unit_transf )( int *imat, int *upd )
{ /* Set Matrix Translation to unit Matrix */
  Draw_Mat_Unit_Transf( *imat, *upd );
} /* draw_mat_unit_transf */


/*********************************************************************/

void DRW_API( transf_seg )( int  *iseg, float  *tx, float    *ty,
                            float  *px, float  *py, float *theta,
                            float *scx, float *scy )
{ /* Perform a specified Segment transformation */
  Draw_Transf_Seg( *iseg, *tx, *ty, *px, *py, *theta, *scx, *scy );
} /* draw_transf_seg */


/*********************************************************************/

void DRW_API( transf_mat )( int  *imat, float  *tx, float    *ty,
                            float  *px, float  *py, float *theta,
                            float *scx, float *scy )
{ /* Perform a specified Segment transformation */
  Draw_Transf_Mat( *imat, *tx, *ty, *px, *py, *theta, *scx, *scy );
} /* draw_transf_mat */


/*********************************************************************/

void DRW_API( transf_seg3 )( int *iseg, float  *tx, float  *ty, float  *tz,
                                        float  *px, float  *py, float  *pz,
                                        float *ome, float *chi, float *psi,
                                        float *scx, float *scy, float *scz )
{ /* Perform a specified Segment transformation */
  Draw_Transf_Seg3( *iseg, *tx, *ty, *tz, *px, *py, *pz, *ome, *chi, *psi,
                            *scx, *scy, *scz );
} /* draw_transf_seg3 */


/*********************************************************************/

void DRW_API( transf_mat3 )( int *imat, float  *tx, float  *ty, float  *tz,
                                        float  *px, float  *py, float  *pz,
                                        float *ome, float *chi, float *psi,
                                        float *scx, float *scy, float *scz )
{ /* Perform a specified Segment transformation */
  Draw_Transf_Mat3( *imat, *tx, *ty, *tz, *px, *py, *pz, *ome, *chi, *psi,
                           *scx, *scy, *scz );
  Draw_AnmSSt = Sdrw_Get_Char();
} /* draw_transf_mat3 */


/*********************************************************************/

void DRW_API( move_seg )( int *iseg, float *tx, float *ty )
{ /* Perform a Segment Translation */
  Draw_Move_Seg( *iseg, *tx, *ty );
} /* draw_move_seg */


/*********************************************************************/

void DRW_API( move_mat )( int *imat, float *tx, float *ty )
{ /* Perform a Segment Translation */
  Draw_Move_Mat( *imat, *tx, *ty );
} /* draw_move_mat */


/*********************************************************************/

void DRW_API( move_seg3 )( int *iseg, float *tx, float *ty, float *tz )
{ /* Perform a Segment Translation */
  Draw_Move_Seg3( *iseg, *tx, *ty, *tz );
} /* draw_move_seg3 */


/*********************************************************************/

void DRW_API( move_mat3 )( int *imat, float *tx, float *ty, float *tz )
{ /* Perform a Segment Translation */
  Draw_Move_Mat3( *imat, *tx, *ty, *tz );
} /* draw_move_mat3 */


/*********************************************************************/

void DRW_API( rotate_seg )( int *iseg, float *px, float *py, float *theta )
{ /* Perform a Segment Rotation */
  Draw_Rotate_Seg( *iseg, *px, *py, *theta );
} /* draw_rotate_seg */


/*********************************************************************/

void DRW_API( rotate_mat )( int *imat, float *px, float *py, float *theta )
{ /* Perform a Segment Rotation */
  Draw_Rotate_Mat( *imat, *px, *py, *theta );
} /* draw_rotate_mat */


/*********************************************************************/

void DRW_API( urot_seg3 )( int *iseg, float  *px, float  *py, float  *pz,
                                      float  *th, float  *ph, float  *an )
{ /* Perform a Segment Rotation */
  Draw_URot_Seg3( *iseg, *px, *py, *pz, *th, *ph, *an );
} /* draw_urot_seg3 */


/*********************************************************************/

void DRW_API( urot_mat3 )( int *imat, float  *px, float  *py, float  *pz,
                                      float  *th, float  *ph, float  *an )
{ /* Perform a Segment Rotation */
  Draw_URot_Mat3( *imat, *px, *py, *pz, *th, *ph, *an );
} /* draw_urot_mat3 */


/*********************************************************************/

void DRW_API( rotate_seg3 )( int *iseg, float  *px, float  *py, float  *pz,
                                        float *ome, float *chi, float *psi )
{ /* Perform a Segment Rotation */
  Draw_Rotate_Seg3( *iseg, *px, *py, *pz, *ome, *chi, *psi );
} /* draw_rotate_seg3 */


/*********************************************************************/

void DRW_API( rotate_mat3 )( int *imat, float  *px, float  *py, float  *pz,
                                        float *ome, float *chi, float *psi )
{ /* Perform a Segment Rotation */
  Draw_Rotate_Mat3( *imat, *px, *py, *pz, *ome, *chi, *psi );
} /* draw_rotate_mat3 */


/*********************************************************************/

void DRW_API( scale_seg )( int *iseg, float *px, float *py, float *scx, float *scy )
{ /* Perform a Segment scalling 2D */
  Draw_Scale_Seg( *iseg, *px, *py, *scx, *scy );
} /* draw_scale_seg */


/*********************************************************************/

void DRW_API( scale_mat )( int *imat, float *px, float *py, float *scx, float *scy )
{ /* Perform a Segment scalling 2D */
  Draw_Scale_Mat( *imat, *px, *py, *scx, *scy );
} /* draw_scale_mat */


/*********************************************************************/

void DRW_API( scale_seg3 )( int *iseg, float  *px, float  *py, float  *pz,
                                       float *scx, float *scy, float *scz )
{ /* Perform a Segment Scalling 3D */
  Draw_Scale_Seg3( *iseg, *px, *py, *pz, *scx, *scy, *scz );
} /* draw_scale_seg3 */


/*********************************************************************/

void DRW_API( scale_mat3 )( int *imat, float  *px, float  *py, float  *pz,
                                       float *scx, float *scy, float *scz )
{ /* Perform a Segment Scalling 3D */
  Draw_Scale_Mat3( *imat, *px, *py, *pz, *scx, *scy, *scz );
  Sdrw_Put_Int( *imat );
} /* draw_scale_mat3 */


/*********************************************************************/

int  DRW_API( get_seg_mat )( int *iseg, float *mat )
{
  return Draw_Get_Seg_Mat( *iseg, mat );
}

/*********************************************************************/

int  DRW_API( get_matrix )( int *imat, float *mat )
{
  return Draw_Get_Matrix( *imat, mat );
}

/*********************************************************************/

int  DRW_API( seg_orient )( int *iseg, float *px, float *py, float *pz, int *immed )
{
  return Draw_Seg_Orient( *iseg, *px, *py, *pz, *immed );
}

/*********************************************************************/


int  DRW_API( mat_orient )( int *imat, float *px, float *py, float *pz, int *immed )
{
  return Draw_Mat_Orient( *imat, *px, *py, *pz, *immed );
}

/*********************************************************************/

int  DRW_API( seg_move )( int *iseg, int *immed )
{
  return Draw_Seg_Move( *iseg, *immed );
}

/*********************************************************************/


int  DRW_API( mat_Move )( int *imat, int *immed )
{
  return Draw_Mat_Move( *imat, *immed );
}

/****************************    E N D    ****************************/
