/*********************************************************************
*                                                                    *
*                                                                    *
*                                                                    *
*             D R A W   -   C L I E N T   L I B R A R Y              *
*                                                                    *
*                 (Main Control Graphic Directives)                  *
*                     (Multi-Language Support)                       *
*                                                                    *
*                    Draw Library Version V 2.4                      *
*                                                                    *
*                               by                                   *
*                                                                    *
*          Pierre Wolfers, Laboratoire de Cristallographie           *
*                                                                    *
*          CNRS GRENOBLE,  25 Avenue des Martyrs, B.P. 166           *
*                                                                    *
*                     F 38042 GRENOBLE CEDEX 9                       *
*                                                                    *
*                           F R A N C E                              *
*                                                                    *
*                                                                    *
*                                                                    *
*********************************************************************/



/*///////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
///////////////////////////////////////////////////////////////////////*/




#include <draw/draw_common.h>
#include <draw/draw_env.h>      /* Load the DRAW library Environment */





void DRW_API( color )( int *color )
{ /* Set a color for following Drawing primitives */
  Draw_Color_Index( *color );
} /* draw_color */


/*********************************************************************/

void DRW_API( set_color )( float *r, float *g, float *b )
{ /* Set a color for following Drawing primitives */
  Draw_Set_Color( *r, *g, *b );
} /* draw_set_color */


void DRW_API( set_colora )( float *r, float *g, float *b, float *a )
{ /* Set a color for following Drawing primitives */
  Draw_Set_ColorA( *r, *g, *b, *a );
} /* draw_set_colora */


/*********************************************************************/

void DRW_API( define_color )( int *icol, float *r, float *g, float *b )
{ /* Set the Icol# color definition (in RGB) */
  Draw_Define_Color( *icol, *r, *g, *b );
} /* draw_define_color */


void DRW_API( define_colora )( int *icol, float *r, float *g, float *b, float *a )
{ /* Set the Icol# color definition (in RGB) */
  Draw_Define_ColorA( *icol, *r, *g, *b, *a );
} /* draw_define_color */



/*********************************************************************/

int DRW_API( inquire_color )( int *icol, float *r, float *g, float *b, float *a )
{ /* Get the Icol# color definition (in RGB) */
  return Draw_Inquire_Color( *icol, r, g, b, a );
} /* draw_inquire_color */



/*********************************************************************/

void DRW_API( line_attr )( int *n, float *r )
{ /* Set Line Attributs */
  Draw_Line_Attr( *n, *r );
} /* draw_line_attr */



/*********************************************************************/

void DRW_API( marker_attr )( int *n, float *r )
{ /* set the Marker Attributs */
  Draw_Marker_Attr( *n, *r );
} /* draw_marker_attr */



/*********************************************************************/

void DRW_API( fill_attr )( int *n1, int *n2 )
{ /* Set The Fill Area Attribute */
  Draw_Fill_Attr( *n1, *n2 );
} /* draw_fill_attr */



/*********************************************************************/

void DRW_API( text_font )( int *n, int *tp )
{ /* To select a specified Font */
  Draw_Text_Font( *n, *tp );
} /* draw_text_font */



/*********************************************************************/

void DRW_API( _install_font )( int *n, int *tp, char * fn, int * sz )
{ /* To select a specified Font */
  Draw_Install_Font( *n, *tp, fn, *sz );
} /* draw__install_font */



/*********************************************************************/

int  DRW_API( _font_info )( int *ifnt, char *fnm, int *cap, int *len, int *stl )
{ /* To select a specified Font */
  return Draw_Font_Info( *ifnt, fnm, *cap, len, stl );
} /* draw__font_info */



/*********************************************************************/

int  DRW_API( _get_string_box )( int *ifnt, char *fnm, int *len, float *hg, float *bx, float *by )
{
  return Draw_Get_String_Box( *ifnt, fnm, *len, *hg, bx, by );
}


/*********************************************************************/

void DRW_API( text_attr )( int *n1, int *n2, int *n3, float *re, float *rs, float *rd )
{ /* Set text Attributs*/
  Draw_Text_Attr( *n1, *n2, *n3, *re, *rs, *rd );
} /* draw_text_attr */


/*********************************************************************/

void DRW_API( push_attr )()
{ /* Set text Attributs*/
  Draw_Push_Attr();
} /* draw_push_attr */


void DRW_API( pop_attr )()
{ /* Set text Attributs*/
  Draw_Pop_Attr();
} /* draw_pop_attr */




/****************************    E N D    ****************************/

