/**********************************************�*************************
*                                                                       *
*                                                                       *
*                                                                       *
*               D R A W   -   C L I E N T   L I B R A R Y               *
*                                                                       *
*                   (Main Control Graphic Directives)                   *
*                       (Multi-Language Support)                        *
*                                                                       *
*                     Draw Library Version V 2.5                        *
*                                                                       *
*                            31-Mar-2012                                *
*                                                                       *
*                                by                                     *
*                                                                       *
*                   Pierre Wolfers,  Institut Neel                      *
*                                                                       *
*           CNRS GRENOBLE,  25 Avenue des Martyrs, B.P. 166             *
*                                                                       *
*                      F 38042 GRENOBLE CEDEX 9                         *
*                                                                       *
*                            F R A N C E                                *
*                                                                       *
*                                                                       *
*                                                                       *
************************************************************************/



/*///////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
///////////////////////////////////////////////////////////////////////*/


#define _DRAWLIB_BASE_

#include <draw/draw_common.h>
#include <draw/draw_env.h>              /* Load the DRAW library Environment */



/*********************************************************************/
/*                                                                   */
/*                                                                   */
/*                                                                   */
/*         Three kind of Procedure names :                           */
/*                                                                   */
/*       1/  API form (Directly Callable by Fortran)                 */
/*                all parameter are passed by reference.             */
/*                                                                   */
/*       2/  Draw_<name> form (C compatible form).                   */
/*                                                                   */
/*       3/  Draw__<name> form (Intermediary C compatible form).     */
/*                Used as intermediary between the dedicated         */
/*                language procedures for special parameter          */
/*                management.                                        */
/*                                                                   */
/*                                                                   */
/*                                                                   */
/*********************************************************************/



/*********************************************************************/
/**                                                                 **/
/**                   L O C A L       T Y P E S                     **/
/**                                                                 **/
/*********************************************************************/

typedef struct Mdir_Rec * Mdir_Ptr;

typedef struct Mdir_Rec {
                 Mdir_Ptr mdir_nxt;
                 Char     mdir_cod;
                 Char     mdir_len;
                 char *   mdir_nam;
                 int      mdir_ide;
                 int      mdir_key;
               } Mdir_Rec;




/*********************************************************************/
/**                                                                 **/
/**               L O C A L       V A R I A B L E S                 **/
/**                                                                 **/
/*********************************************************************/

/* Logical Name of Graphic Server */
static char * server_envv = "DRAW_SERVER";
static char * server_name = "Draw_Server";

int          Plt_Idx = 0,           /* Filling index of Draw_plot point table */
             Plt_Cnt = 0,           /* Vertex/Dot Plot Count */
             Plt_Lnk = 0;           /* Link Flag for large Curve tracing */

float        Plt_Tab[PLOT_TAB_LEN]; /* Draw_Plot table */

int          Pannel_Init = 0;       /* Flag to force pannel init execution */

static Mdir_Ptr mdir_frs = NULL;    /* Menu Entry List Header */
static Mdir_Ptr mdir_lst = NULL;

static int   mdir_idtb[256];        /* Menu Identifier table */
static int   mdir_cnt        = 0;   /* Menu Identifier Fill index */

static int   blk_count       = 0;   /* Block transmit count */
static int   blk_size        = 0;   /* Block size to transmit */



/*********************************************************************/
/**                                                                 **/
/**        M U L T I   L A N G U A G E   P R O C E D U R E S        **/
/**                                                                 **/
/*********************************************************************/



void Draw_End()
{
  Sdrw_Put_Code( cd_end );    /* STOP Server request */
  Draw_Inp_Size = Sdrw_Dialog_Request();
  Sdrw_Connection_Release();  /* Wait for server exit */
  Draw_Status = 0;            /* Set to "server does not run" state */
  Pannel_Init = 0;            /* Disable any Pannel Init */
} /* Draw_End */



/*********************************************************************/

void Draw_Error( char *mdname, int ierr )
{
  fprintf( stderr, " DRAW-LIB : Error '%s' %3d.\n", mdname, abs(ierr) );
  if (Draw_Srv_Flg) {
    Draw_End();
    if (ierr < 0) exit( 1 );
  } else
    if ((ierr < 0)&&(!(Draw_SrvMod&SERVER_DIS_INIERR))) exit( 1 );
} /* Draw_Error */



/*********************************************************************/

void Sdrw_Server_Request()
{ /* Send a request with General Error message on no request error */
  Draw_Inp_Size = Sdrw_Dialog_Request();
  if (Draw_Inp_Size <= 0)
    Draw_Error( "No Server Answerd on a request.", -3 );
} /* Sdrw_Server_Request */



/*********************************************************************/

void Draw_Set_Menu_Spc( int cd, int id, char* name, int len, int key )
{ /* To specify a User Menu Directive */
  char*   st;
  Mdir_Ptr p;
  int      i;

  p = (Mdir_Ptr) malloc( sizeof( Mdir_Rec ) );
  p->mdir_nxt = NULL;
  if (cd&(~15)) { name = NULL; len = (cd&(~15))/16; cd = cd&15; }
  p->mdir_cod =   cd;
  p->mdir_len =  len;
  p->mdir_ide =   id;
  p->mdir_key =  key;
  if (name&&(len > 0)) {
    p->mdir_nam = st = (char*) malloc( len );
    for (i = 0; i < len; i++) st[i] = name[i];
  } else p->mdir_nam = NULL;
  if (mdir_frs) mdir_lst->mdir_nxt = p;
           else mdir_frs = p;
  mdir_lst = p;
} /* Draw__Set_Menu_Spc */



/*********************************************************************/

static void Erase__Menu_Spc()
{ /* Destroy the Menu Directive List when Existing */
  Mdir_Ptr p;

  while (mdir_frs) {
    p = mdir_frs;
    mdir_frs = p->mdir_nxt;
    if (p->mdir_nam) free( p->mdir_nam );
    free( p );
  }
}



/*********************************************************************/

static void Send__Menu_Spc()
{ /* To send the User menu specification */
  int      icp;
  Mdir_Ptr   p;

  if (mdir_frs) {
    icp = 1;                      /* Simule the open of Menu Barre */
    while (mdir_frs&&(icp > 0)) { /* Loop on all directives */
      Sdrw_Server_Request();      /* Send Server Acknowledge and wait for ready message */
      p = mdir_frs;               /* Get the current directive */
      mdir_frs = p->mdir_nxt;     /* Update mdir_frs to the next directive (or NULL) */

      switch (p->mdir_cod) {      /* Get the directive code */
        case 0: /* Close Menu */     Sdrw_Put_Char( 0 ); icp--; break;

        case 1: /* Open Std Menu */  Sdrw_Put_Char( 1 ); icp++; break;

        case 2: /* Skip Std entry */
          Sdrw_Put_Char( 2 );
          Sdrw_Put_Char( p->mdir_len );
        break;

        case 3: /* Open New Menu */
        case 4: /* New Entry */
        case 5: /* New Barre */
          Sdrw_Put_Char( p->mdir_cod );
          Sdrw_Put_String( p->mdir_nam, p->mdir_len );
          if (p->mdir_cod == 3) icp++; /* Open Menu */
          if (p->mdir_cod == 4) {      /* New Entry */
            Sdrw_Put_Int( p->mdir_key );        /* Send the key code for shortcut */
            if (mdir_cnt < 256) {      /* Set the Identifier Translation Table */
              mdir_idtb[mdir_cnt] = (p->mdir_ide>=0)?p->mdir_ide:mdir_cnt+1;
              mdir_cnt++;
            }
          }
        break;

        default: /* Illegal Code Ignored */ 
          ;
      }
      /* Free the Directive node */
      if (p->mdir_nam) free( p->mdir_nam );
      free( p );
    }
    mdir_lst = NULL;
    while (icp) { /* Append all Close to go out of all opened menu */
      Sdrw_Server_Request();      /* Send Server Acknowledge and wait for ready message */
      Sdrw_Put_Char( 0 ); icp--;  /* Generate a Close menu Directive */
    }
    if (icp||mdir_frs) { /* Menu Description Error => Stop Task */
      fprintf( stderr, "Draw_Init: Menu Description Error => Stop Task." );
      exit( 2 );
    }
  }
}



/*********************************************************************/

Char Draw_Init( float *x_paper, float *y_paper, Char *unit,
                Char *usr_id, int usr_len )
{
  int  conn, i, slen;
  char usr_nam[256], *nmpt;
  Char r;

#ifdef VMS
  /* Initialization of C Run_Time Library */
  if (Draw_Status < 0) { C_CRTL_INIT(); Draw_Status = 0; }
#endif

  mdir_cnt     = 0;                   /* Clear Menu Identifier Fill index */
  Draw_Srv_Flg = 0;                   /* Clear the FLag word to flag graphic support disable */
  r            = 0;                   /* Assume Plot disable until shown otherwise */

  if (Draw_Status == 0)
  {
    if ((usr_id != NULL)&&(usr_len > 0))
    { /* Copy optional character in a temporary buffer */
      for (i=0; i<usr_len; i++) usr_nam[i] = usr_id[i];
      usr_nam[usr_len] = 0; /* Put the final 0 */
      nmpt = usr_nam;
    }
    else nmpt = NULL;

    /* Alloc inbuf and outbuf then open way for dialog */
    Draw_Buf_Size = Sdrw_Open_Gate(); /* Keep the Used Buffer size */
    /* Start the Draw_Server program */
    Draw_Status = Sdrw_Establish_Connection( server_envv, server_name ); /* Start Server */
  }

  if (Draw_Status >= 1)
  { /* start the server and establish the server connection */
    /* Send cd_init Aknowledge with INIT information */
    /* \\\ Sdrw_Put_Code( cd_init ); \\\ */
    /* \\\ Draw_Inp_Size = Sdrw_Dialog_Request(); \\\ */

    Draw_Inp_Size = Sdrw_Read();        /* Get Initial Identification Message */

    if (Draw_Inp_Size > 0)
    {
      Draw_Srv_Ide = Sdrw_Get_Int();    /* Get the Server Type Identity Word */
      Draw_Srv_Flg = Sdrw_Get_Int();    /* Get the Server Capability Flags Word */
      /* Get the Server Name Identifier string */
      Draw_Srv_NameLength = Sdrw_Get_String_SP( &Draw_Srv_Name, 1 );

      if (Draw_Srv_Flg&SERVER_DO_USER_MENUS) {
        /* Get the Dialog Menu Support Flag and set Menu_Valid Fl=ag */
        i = (mdir_frs)?1:0;             /* Set the Menu Use Flag */
      }
      else {
        if (mdir_frs) Erase__Menu_Spc();/* Destroy the Menu directive list if not used */
        i = 0;
      }
      if (i) Draw_SrvMod |= SERVER_DO_USER_MENUS;
        else Draw_SrvMod &= ~SERVER_DO_USER_MENUS;

#ifdef __CYGWIN__
      if (Draw_Srv_Flg&SERVER_DO_WIN32_FS) Draw_SrvMod |= SERVER_DO_WIN32_FS; /* Set convertion POSIX <-> WIN32 Conv. flag */
#endif

      Sdrw_Put_Int( Draw_SrvMod );      /* Put the User Requested Capability Flags word */
      Sdrw_Put_String( (char *) usr_id, usr_len ); /* ... and also the User Task Name */
      if (i) Send__Menu_Spc();          /* Send User menu SPC and wait for Init Graphic */
      Sdrw_Server_Request();            /* Send Info to the Server and wait for Answerd */
      *x_paper = Sdrw_Get_Float();      /* Get the Drawing size in Raster or cm */
      *y_paper = Sdrw_Get_Float();
      if ( Sdrw_Get_Char() == 0 ) *unit = 0; /* raster     */
                             else *unit = 1; /* centimeter */
      r = 1;                           /* Set the Draw_Init sucess flag */
    } else {
      Draw_Error( "Draw_Init Do not receive Server Identification.", -1 );
      exit( 2 );
    }
  } else Draw_Error( "Draw_Init: Start DRAW Server failure",
                     (Draw_SrvMod&SERVER_DIS_INIERR)?abs( Draw_Status ):Draw_Status );
  Plt_Cnt     = 0;                      /* Init for Plot Routine */
  Pannel_Init = 1;                      /* Flag to force a pannel init at first use */
  return r;
} /* Draw__Init */



/*********************************************************************/


Char Draw_Picture( char  *title, int len,       /* Title string */
                   float x_size,                /* Plot Surface Length */
                   float y_size,
                   float z_size,
                   Char   scale,                /* Scale flags */
                   Char  margin                 /* Margin/Title flag*/
                 )
{
  Draw_Currx = 0.0;  /* Initialize the Current Pen coordinates */
  Draw_Curry = 0.0;
  Draw_Currz = 0.0;

  /* Send The Picture Request */

  Sdrw_Put_Code( cd_picture );
  Sdrw_Put_String( title, len );
  Sdrw_Put_Float( x_size );
  Sdrw_Put_Float( y_size );
  Sdrw_Put_Float( z_size );
  Sdrw_Put_Char( scale );
  Sdrw_Put_Char( margin );
  Sdrw_Server_Request();
  /* Get the Scale Respect Flag */
  Draw_Status = 2;            /* Set the Plot Enable State */
  Plt_Cnt = 0;                /* Init for Plot Routine */
  return Sdrw_Get_Char();
} /* Draw_Picture */



/*********************************************************************/

void Draw_Picture_Scales( int cd, float* scx, float* scy )
{ /* Call to get the current Window scale for x and y, (in cm/pixel unit) */
  Sdrw_Put_Code( cd_picture_scales );
  Sdrw_Put_Int( cd );
  Sdrw_Server_Request();
  *scx = Sdrw_Get_Float();
  *scy = Sdrw_Get_Float();
}



/*********************************************************************/

int  Draw_Dialog( int flags )
{ /* Call standard Dialog Server Routine */
  int status;

  Sdrw_Put_Code( cd_dialog );
  Sdrw_Put_Int( flags );
  Sdrw_Server_Request();
  status = Sdrw_Get_Int();                    /* Get the draw_Dialog status */
  Draw_PanIde = Sdrw_Get_Int();               /* Set the identifier of last modified Pannel */
  if (status == -10) DRW_API( end )();
  if ((status > 0) && (status <= mdir_cnt)) status = mdir_idtb[status - 1];
  return status;
} /* Draw_Dialog */



/*********************************************************************/

void Draw_Out_Mode( int mode )
{ /* To Switch between PolyLine, Polymarker and fill Arrea */
  Sdrw_Put_Code( cd_out_mode );
  Sdrw_Put_Int( mode );
  Sdrw_Server_Request();
} /* Draw_Out_Mode */


/*********************************************************************/

void Draw_Send_Block( float* vtb )
{ /* To Send a large block by line */
int ik;
  Sdrw_Write_Block( (Char*) vtb, blk_size );
  blk_count--;
  if (!blk_count) {
    Sdrw_Server_Request();
    Draw_AnmSSt = Sdrw_Get_Char();
  }
} /* Draw_Send_Block */



/*********************************************************************/

int Draw_Time_Anim( int per )
{ /* To Set a new Timer Period for Animation Refresh (in ms) */
  Sdrw_Put_Code( cd_tim_anim );
  Sdrw_Put_Int( per );
  Sdrw_Server_Request();
  return Sdrw_Get_Int();
} /* Draw_Time_Anim */


/*********************************************************************/

void Draw_Set_Stop_Anim( int mod )
{ /* To Set a new Timer Period for Animation Refresh (in ms) */
  Sdrw_Put_Code( cd_anim_stop );
  Sdrw_Put_Int( mod );
  Sdrw_Server_Request();
} /* Draw_Time_Anim */


/*********************************************************************/

static void Draw__Plt_Block( int dim, float *pt, int flg )
{ /* Direct Block plot order limited to PLOT_TAB_LEN float */
  int sz;

  sz = dim*((flg&cdf_3D)?3:2);
  if (flg&cdf_UNRM) sz *= 2;
  Sdrw_Put_Code( cd_mplot );
  Sdrw_Put_Int( dim );
  Sdrw_Put_Int( flg );
  Sdrw_Write();
  Sdrw_Write_Block( (Char *) pt, sz*sizeof( float ) );
  Sdrw_Read();
}



void Draw_Mplot( int dim, float* pt, int flg )
{ /* Block plot order */
  int nblk, room, tot;

  room = PLOT_TAB_LEN/((flg&cdf_3D)?3:2);
  if (flg&cdf_UNRM) room /= 2;        /* When the Normal of each point are specified */
  dim  = abs( dim );
  tot  = 0;
  while (tot < dim) { /* ** Loop on the Mplot block(s) ** */
    nblk = dim - tot;
    if (nblk > room) {
      /* To large for Buffer, Split in records */
      nblk = room;                    /* Output Only the head/2D-3D for first record */
      Draw__Plt_Block( nblk, pt, flg&cdf_3DST );
      flg = flg&cdf_3DND;             /* Suppress the head mode for next record */
    } else /* Last record Output */
      Draw__Plt_Block( nblk, pt, flg );
    tot += nblk;                      /* Update the Point count */
    pt  += nblk;                      /* Update table address */
  }
  Draw_AnmSSt = Sdrw_Get_Char();
}




/*********************************************************************/

void Draw_Progplot( float x, float y )
{
  Sdrw_Put_Code( cd_progplot );
  Sdrw_Put_Float( x );
  Sdrw_Put_Float( y );
  Sdrw_Server_Request();
  Draw_AnmSSt = Sdrw_Get_Char();
}



/*********************************************************************/

void Draw_ProgSetting( int seg, int ide )
{
  Sdrw_Put_Code( cd_progsetting );
  Sdrw_Put_Int( seg );
  Sdrw_Put_Int( ide );
  Sdrw_Server_Request();
}



/*********************************************************************/

void Draw_Plot( float x, float y, Char pen )
{ /* Basic Pen move in Up or Down state - Always Translated to
     Block of point (or Curve) Drawing primitive Draw_Mplot */
  int okey;

  okey = pen&cdf_AB;
  if (Plt_Cnt == 0) { /* The point Table is Empty */
    if (pen) { /* Required Pen state is Down */
      /* The First Point is always stored in Plt_Tab */
      Plt_Tab[0] = Draw_Currx;
      Plt_Tab[1] = Draw_Curry;
      Plt_Tab[2] = x;
      Plt_Tab[3] = y;
      Plt_Idx    = 4;
      Plt_Cnt    = 2;
    }
  }
  else { /* The pointgrenoble.cnrs.fr/fr/ table was not empty */
    if (pen) { /* Required Pen state is Down */
      if (Plt_Idx >= PLOT_TAB_LEN) {   /* The Plot Table was already Full */
        /* We Output The table to Server */
        if (Plt_Lnk) /* Set Continuous mode for multi Table Overflow */
          Draw_Mplot(  PLOT_TAB_LEN/2, Plt_Tab, okey );
        else {       /* Set Plt_Lnk for the next Mplot order */
          Draw_Mplot(  PLOT_TAB_LEN/2, Plt_Tab, cdf_ST|okey );
          Plt_Lnk = 1;
        }
        Plt_Idx = 0;                  /* Set the Plot Table at Zero point */
        Plt_Cnt = 0;
      }
      Plt_Tab[Plt_Idx++] = x;         /* Put the new point in the Plot Table */
      Plt_Tab[Plt_Idx++] = y;
      Plt_Cnt++;
    }
    else { /* Required Pen state is Up */
      if (Plt_Lnk) /* Set final mode for Plot Table Overflow */
        Draw_Mplot( Plt_Cnt, Plt_Tab, cdf_ND|okey );
      else /* Set Complet mode for the next Mplot order */
        Draw_Mplot( Plt_Cnt, Plt_Tab, cdf_STND|okey );
      Plt_Lnk = 0; /* Set to no Plot coordinates in Table */
      Plt_Cnt = 0;
      Plt_Idx = 0;
    }
  }
  Draw_Currx = x;                    /* Keep the current position */
  Draw_Curry = y;
  Draw_Currz = 0.0;
} /* Draw_Plot */



/*********************************************************************/

void Draw_Plot3( float x, float y, float z, Char pen )
{ /* Basic Pen move in Up or Down state - Always Translated to
     Block of point (or Curve) Drawing primitive Draw_Mplot */
  int okey;

  okey = (pen&cdf_AB)|cdf_3D;
  if (Plt_Cnt == 0) { /* The point Table is Empty */
    if (pen) { /* Required Pen state is Down */
      /* The First Point is always stored in Plt_Tab */
      Plt_Tab[0] = Draw_Currx;
      Plt_Tab[1] = Draw_Curry;
      Plt_Tab[2] = Draw_Currz;
      Plt_Tab[3] = x;
      Plt_Tab[4] = y;
      Plt_Tab[5] = z;
      Plt_Idx    = 6;
      Plt_Cnt    = 2;
    }
  }
  else { /* The point table was not empty */
    if (pen) { /* Required Pen state is Down */
      if (Plt_Idx >= PLOT_TAB_LEN) {   /* The Plot Table was already Full */
        /* We Output The table to Server */
        if (Plt_Lnk) /* Set Continuous mode for multi Table Overflow */
          Draw_Mplot(  PLOT_TAB_LEN/3, Plt_Tab, okey );
        else {       /* Set Plt_Lnk for the next Mplot order */
          Draw_Mplot(  PLOT_TAB_LEN/3, Plt_Tab, cdf_3DST|okey );
          Plt_Lnk = 1;
        }
        Plt_Idx = 0;                  /* Set the Plot Table at Zero point */
        Plt_Cnt = 0;
      }
      Plt_Tab[Plt_Idx++] = x;         /* Put the new point in the Plot Table */
      Plt_Tab[Plt_Idx++] = y;
      Plt_Tab[Plt_Idx++] = z;
      Plt_Cnt++;
    }
    else { /* Required Pen state is Up */
      if (Plt_Lnk) /* Set final mode for Plot Table Overflow */
        Draw_Mplot( Plt_Cnt, Plt_Tab, cdf_ND|okey );
      else /* Set Complet mode for the next Mplot order */
        Draw_Mplot( Plt_Cnt, Plt_Tab, cdf_STND|okey );
      Plt_Lnk = 0; /* Set to no Plot coordinates in Table */
      Plt_Idx = 0;
      Plt_Cnt = 0;
    }
  }
  Draw_Currx = x;                    /* Keep the current position */
  Draw_Curry = y;
  Draw_Currz = z;
} /* Draw_Plot3 */



/*********************************************************************/

void Draw_Org( float ox, float oy, int irel )
{ /* Set a new origine for following Draw_Plot */
  Sdrw_Put_Code( cd_org );
  Sdrw_Put_Float( ox );
  Sdrw_Put_Float( oy );
  Sdrw_Put_Float( 0.0 );
  Sdrw_Put_Int( irel );
  Sdrw_Server_Request();
  Draw_Currx = 0.0;
  Draw_Curry = 0.0;
  Draw_Currz = 0.0;
} /* Draw_Org */



/*********************************************************************/

void Draw_Org3( float ox, float oy, float oz, int irel )
{ /* Set a new origine for following Draw_Plot */
  Sdrw_Put_Code( cd_org );
  Sdrw_Put_Float( ox );
  Sdrw_Put_Float( oy );
  Sdrw_Put_Float( oz );
  Sdrw_Put_Int( irel );
  Sdrw_Server_Request();
  Draw_Currx = 0.0;
  Draw_Curry = 0.0;
  Draw_Currz = 0.0;
} /* Draw_Org3 */



/*********************************************************************/

void Draw_Rplot( float dx, float dy, Char pen )
{ /* Relative (to current Pen position) Plot */
  Draw_Plot( Draw_Currx + dx, Draw_Curry + dy, pen );
} /* Draw_Rplot */



/*********************************************************************/

void Draw_Rplot3( float dx, float dy, float dz, Char pen )
{ /* Relative (to current Pen position) Plot */
  Draw_Plot3( Draw_Currx + dx, Draw_Curry + dy, Draw_Currz + dz, pen );
} /* Draw_Rplot3 */



/*********************************************************************/

void Draw_Where( float *x, float *y )
{ /* Return the Current Pen Position to the User */
  *x = Draw_Currx;
  *y = Draw_Curry;
} /* Draw_Where */



/*********************************************************************/

void Draw_Where3( float *x, float *y, float *z )
{ /* Return the Current Pen Position to the User */
  *x = Draw_Currx;
  *y = Draw_Curry;
  *z = Draw_Currz;
} /* Draw_Where3 */


/*********************************************************************/

void Draw_String( float x, float y, float theta, float hgt,
                  char * str, int len, int flg )
{ /* To plot a String in a specified line arientation */
  Sdrw_Put_Code( cd_string );
  Sdrw_Put_Char( flg );
  Sdrw_Put_Float( x );
  Sdrw_Put_Float( y );
  Sdrw_Put_Float( theta );
  Sdrw_Put_Float( hgt );
  Sdrw_Put_String( str, len );
  Sdrw_Server_Request();
  Draw_AnmSSt = Sdrw_Get_Char();
} /* Draw__String */



/*********************************************************************/

void Draw_Text_In_Box( float x, float y, float bx, float by, char * txt, int len,
                       int hal, int flg, float hgt, float lgs )
{ /* To plot a String in a specified line arientation */
  Sdrw_Put_Code( cd_text_in_box );              /* Send the Text_In_Box Operator code */
  Sdrw_Put_Char( flg );                         /* Send the absolute/user_origine relative flag */
  Sdrw_Put_Char( hal );                         /* Send the Required Alignement */
  Sdrw_Put_Float( x );                          /* Send the box position */
  Sdrw_Put_Float( y );
  Sdrw_Put_Float( bx );                         /* Send the box sizes */
  Sdrw_Put_Float( by );
  Sdrw_Put_Float( hgt );                        /* Send the chraccter height */
  Sdrw_Put_Float( lgs );                        /* Send the relative line spacing */
  Sdrw_Put_Int( len );                          /* Send the text size */
  Sdrw_Write();                                 /* Send the head message */
  Sdrw_Write_Block( (Char*) txt, len );         /* Send the text. */
  Sdrw_Read();                                  /* Wait server for answerd */
  Draw_AnmSSt = Sdrw_Get_Char();
} /* Draw__Text_In_Box */



/*********************************************************************/

void Draw_Circle( float x_c, float y_c, float r, float st_a, float nd_a, float prec, int flg )
{ /* To plot an Arc of Circle */
  Sdrw_Put_Code( cd_circle );
  Sdrw_Put_Int( flg );
  Sdrw_Put_Float( x_c );
  Sdrw_Put_Float( y_c );
  Sdrw_Put_Float( r );
  Sdrw_Put_Float( st_a );
  Sdrw_Put_Float( nd_a );
  Sdrw_Put_Float( prec );
  Sdrw_Server_Request();
  Draw_AnmSSt = Sdrw_Get_Char();
} /* Draw_Circle */



/*********************************************************************/

void Draw_Sphere( float x_c, float y_c, float z_c, float r, int plg, int plt, int flg )
{ /* To plot one sphere */
  Sdrw_Put_Code( cd_sphere );
  Sdrw_Put_Int( flg );
  Sdrw_Put_Float( x_c );
  Sdrw_Put_Float( y_c );
  Sdrw_Put_Float( z_c );
  Sdrw_Put_Float( r );
  Sdrw_Put_Int( plg );
  Sdrw_Put_Int( plt );
  Sdrw_Server_Request();
  Draw_AnmSSt = Sdrw_Get_Char();
} /* Draw_Sphere */



/*********************************************************************/

void Draw_Cylinder( float xb, float yb, float zb, float th, float ph,
                    float lg, float rb, float rt, int px, int pz, int flg )
{ /* To plot a cylinder */
  Sdrw_Put_Code( cd_cylinder );
  Sdrw_Put_Int( flg );
  Sdrw_Put_Float( xb ); Sdrw_Put_Float( yb ); Sdrw_Put_Float( zb );
  Sdrw_Put_Float( th ); Sdrw_Put_Float( ph );
  Sdrw_Put_Float( lg ); Sdrw_Put_Float( rb ); Sdrw_Put_Float( rt );
  Sdrw_Put_Int( px ); Sdrw_Put_Int( pz );
  Sdrw_Server_Request();
  Draw_AnmSSt = Sdrw_Get_Char();
} /* Draw_Cylinder */



/*********************************************************************/

void Draw_Disk( float xc, float yc, float zc, float th, float ph,
                float ri, float re, float sa, float ea, int pt, int pr, int flg )
{ /* To plot a disk */
  Sdrw_Put_Code( cd_disk );
  Sdrw_Put_Int( flg );
  Sdrw_Put_Float( xc ); Sdrw_Put_Float( yc ); Sdrw_Put_Float( zc );
  Sdrw_Put_Float( th ); Sdrw_Put_Float( ph );
  Sdrw_Put_Float( ri ); Sdrw_Put_Float( re ); Sdrw_Put_Float( sa ); Sdrw_Put_Float( ea );
  Sdrw_Put_Int( pt ); Sdrw_Put_Int( pr );
  Sdrw_Server_Request();
  Draw_AnmSSt = Sdrw_Get_Char();
} /* Draw_Disk */



/*********************************************************************/

void Draw_Surface( int nraw, int ncol, int flg, float* vtb )
{ /* To plot a surface */
  if (!nraw||!ncol) return;
  ncol = abs( ncol ); nraw = abs( nraw );
  Sdrw_Put_Code( cd_surface );
  Sdrw_Put_Int( flg );
  Sdrw_Put_Int( (vtb)?nraw:-nraw );
  Sdrw_Put_Int( ncol );
  Sdrw_Write();
  if (vtb) {
    Sdrw_Write_Block( (Char*) vtb, nraw*ncol*3*sizeof( float ) );
    Sdrw_Server_Request();
    Draw_AnmSSt = Sdrw_Get_Char();
  } else {
    blk_count = nraw;
    blk_size  = ncol*3*sizeof( float );
  }
} /* Draw_Surface */



/*********************************************************************/

void Draw_Surface2( int nraw, int ncol, int flg, float xo, float yo, float xs, float ys, float* vtb )
{ /* To plot a surface */
  if (!nraw||!ncol) return;
  ncol = abs( ncol ); nraw = abs( nraw );
  Sdrw_Put_Code( cd_surface2 );
  Sdrw_Put_Int( flg );
  Sdrw_Put_Int( (vtb)?nraw:-nraw );
  Sdrw_Put_Int( ncol );
  Sdrw_Put_Float( xo ); Sdrw_Put_Float( yo );
  Sdrw_Put_Float( xs ); Sdrw_Put_Float( ys );
  Sdrw_Write();
  if (vtb) {
    Sdrw_Write_Block( (Char*) vtb, nraw*ncol*sizeof( float ) );
    Sdrw_Server_Request();
    Draw_AnmSSt = Sdrw_Get_Char();
  } else {
    blk_count = nraw;
    blk_size  = ncol*sizeof( float );
  }
} /* Draw_Surface2 */



/*********************************************************************/

void Draw_Polyhedral( int nfc, int nvt, int flg, int* fctb, float* vtb )
{ /* To plot a surface */
  if (!nfc||!nvt) return;
  Sdrw_Put_Code( cd_polyhedral );
  Sdrw_Put_Int( flg );
  Sdrw_Put_Int( nfc );
  Sdrw_Put_Int( nvt );
  Sdrw_Write();
  Sdrw_Write_Block( (Char*) fctb, nfc*sizeof( int ) );
  Sdrw_Write_Block( (Char*) vtb, nvt*3*sizeof( float ) );
  Sdrw_Server_Request();
  Draw_AnmSSt = Sdrw_Get_Char();
} /* Draw_Polyhedral */



/*********************************************************************/

void Draw_Wplane3( float * mat )
{ /* Set a new coordinate system for following Draw_Plot */
  int i;

  Sdrw_Put_Code( cd_wplane3 );
  for (i = 0; i < 12; i++) Sdrw_Put_Float( *(mat++) );
  Sdrw_Server_Request();
} /* Draw_Wplane3 */



/*********************************************************************/

void Draw_Nplane3()
{ /* Return to normal cm. work space coordinates */
  Sdrw_Put_Code( cd_nplane3 );
  Sdrw_Server_Request();
} /* Draw_Nplane3 */




/****************************    E N D    ****************************/
