/*********************************************************************
*                                                                    *
*                                                                    *
*                                                                    *
*                      D R A W   -   C O D E S                       *
*                                                                    *
*                               for                                  *
*                                                                    *
*                    Draw Library Version V 2.4 A                    *
*                                                                    *
*                           30-Sep-2009                              *
*                                                                    *
*                               by                                   *
*                                                                    *
*                  Pierre Wolfers,  Institut Neel                    *
*                                                                    *
*          CNRS GRENOBLE,  25 Avenue des Martyrs, B.P. 166           *
*                                                                    *
*                     F 38042 GRENOBLE CEDEX 9                       *
*                                                                    *
*                           F R A N C E                              *
*                                                                    *
*                                                                    *
*                                                                    *
*                                                                    *
*                                                                    *
*********************************************************************/



/**************************************/
/* DRAW Server Constantes definitions */
/**************************************/

#ifndef _DRAW_MSG_CTE
# define  DRAW_MSG_CTE             0


/* General definitions for exchange between client and server task */

# define  SERVER_NAME    "FLTK-GL_DRAW_SERVER"
# define  SERVER_VERSION "1.4 C"
# define  SERVER_DATE    "30-SEP-2009"


/* Server Type Numeric Identifier { FLTK+GL = 7,
                                    Advanced Graphic function = 1,
                                    Version 12 (=1.2*10) }. */

# define  SERVER_IDENT   (7 + 256*(1 + 256*12))

# if !defined( _WIN32 ) || defined( __CYGWIN__ )
#   define _BINARY       0
# else
#   define _BINARY       _O_BINARY
# endif


/* This server provieded functionalities : 
        The User Input interraction management (1),
        the 3D directives                      (2),
        the Animation Directives               (4),
        the Blending/Alpha Directives          (8),
        the Light Support (4 ligths)          (16),
        No Extended Light Support (8 ligths)  (32),
        the User Menu Management              (64).
*/
# define SERVER_DO_INPUT          1
# define SERVER_DO_3D             2
# define SERVER_DO_ANIMATION      4
# define SERVER_DO_BLEND_ALPHA    8
# define SERVER_DO_LIGHTING      16
# define SERVER_DO_WIN32_FS      32
# define SERVER_DO_USER_MENUS    64

# define SERVER_ENA_LIGHT0      256
# define SERVER_ENA_LIGHT1      512
# define SERVER_ENA_LIGHT2     1024
# define SERVER_ENA_LIGHT3     2048

# define SERVER_DIS_INIERR 0x40000000


# define LIGHT_NUMBER             4

# define SERVER_ENA_LIGHT_MSK   (SERVER_ENA_LIGHT0*15)

# define SERVER_FUNCT       ( SERVER_DO_INPUT       | SERVER_DO_3D          |\
                              SERVER_DO_ANIMATION   | SERVER_DO_BLEND_ALPHA |\
                              SERVER_DO_LIGHTING    |\
                              SERVER_DO_USER_MENUS )

# define  MAXINT         2147483647
# define  RMAXINT      2147483647.0

  /* Size of point table for Draw_Plot */

# define  PLOT_TAB_LEN         4096*6  /* Set for 3D et 2D plot. */

  /* Size of Segment/transformation retrivial cache table table */
# define  SEG_CACHE_SIZE        128
# define  TRF_CACHE_SIZE        256

# define  ten                  10.0
# define  one                   1.0
# define  true                    1
# define  false                   0

# define  col_size               64
# define  row_size               64
# define  MAXIDSIZE              32
# define  MAXLINESZ             132


/* Exchange function code to adapt with the current system */

#if defined( _WIN32 ) || defined( WIN32 )
    /* All Windows system. */
#   ifdef __CYGWIN__
      /* Cygwin: a unix like inside Windows */
#     define _PIPE_CNTFLOW 0   /* When define, systematic control flow messages are used to read or write
                                * data block (This mode is automaticaly set when a socket channel is used).
                                */
#   endif
#   define BUF_SIZE  4096
# else
    /* All Unix Like */
#   define BUF_SIZE  4096
# endif


/* Pannel Codes */

# define ITM_B                    0
# define ITM_E                    1
# define ITM_S                    2
# define ITM_I                    3
# define ITM_F                    4
# define ITM_STR                  8
# define ITM_TXT                  9
# define ITM_FRM                 10
# define ITM_BUT                 16



/* DRAW Server codes */

# define  cd_continue             0

# define  cd_end                  1
# define  cd_init                 2
# define  cd_picture              3
# define  cd_pic_view             4
# define  cd_pic_reset            5
# define  cd_clipon               6
# define  cd_clipoff              7
# define  cd_org                  8
# define  cd_color                9
# define  cd_view                10
# define  cd_wplane3             11
# define  cd_nplane3             12

# define  cd_picture_scales      14

# define  cd_tim_anim            15
# define  cd_anim_stop           16

# define  cd_exec_seg            20
# define  cd_out_mode            21

# define  cd_mplot               22
# define  cd_string              23
# define  cd_circle              24

# define  cd_sphere              25
# define  cd_cylinder            26
# define  cd_disk                27

# define  cd_text_in_box         30
# define  cd_get_string_box      31
# define  cd_font_map            32
# define  cd_font_info           33

# define  cd_surface             40
# define  cd_surface2            41

# define  cd_polyhedral          45

# define  cd_progplot            48
# define  cd_progsetting         49

# define  cd_gen_tmat            50
# define  cd_init_trans_mat      51
# define  cd_move_mat            52
# define  cd_urotate_mat         53
# define  cd_rotate_mat          54
# define  cd_scale_mat           55
# define  cd_transform_mat       56
# define  cd_get_transf_mat      57
# define  cd_put_transf_mat      58

# define  cd_alpha_set           60
# define  cd_light_set           61
# define  cd_light_def           62
# define  cd_matp_light          63

# define  cd_push_pop_attr       70

# define  cd_define_color        72
# define  cd_inquire_color       73

# define  cd_line_attr           74
# define  cd_marker_attr         75
# define  cd_fill_area_attr      76
# define  cd_text_font           77
# define  cd_text_attr           78
# define  cd_install_font        79

# define  cd_new_seg             81
# define  cd_seg_end             82
# define  cd_del_seg             83
# define  cd_update_seg          84
# define  cd_seg_attr            85
# define  cd_seg_picid           86
# define  cd_seg_inquire         87

# define  cd_init_trans_seg      90
# define  cd_move_seg            91
# define  cd_urotate_seg         92
# define  cd_rotate_seg          93
# define  cd_scale_seg           94
# define  cd_transform_seg       95
# define  cd_get_transf_seg      96
# define  cd_put_transf_seg      97

# define  cd_message            101
# define  cd_get_choice         102
# define  cd_get_answerd        103
# define  cd_get_position       104
# define  cd_get_window         105
# define  cd_get_string         106
# define  cd_get_value          107
# define  cd_get_line           108
# define  cd_get_stroke         109
# define  cd_get_file           110
# define  cd_seg_pick           111
# define  cd_seg_pdetf          112
# define  cd_get_color          113

# define  cd_seg_orient         115
# define  cd_mat_orient         116
# define  cd_seg_move           117
# define  cd_mat_move           118

# define  cd_echo_get_pos       121
# define  cd_echo_get_line      122

# define  cd_text_display       139


/* #  define  cd_rpmatrix         140 */


# define  cd_new_axis           151
# define  cd_new_box            152
# define  cd_free_box           153
# define  cd_free_all_box       154
# define  cd_set_values         155
# define  cd_get_values         156

# define  cd_box_info           157
# define  cd_easy_box           158

# define  cd_plot_axis          161
# define  cd_plot_box           162
# define  cd_open_box           163
# define  cd_close_box          164
# define  cd_box_to_cm          165
# define  cd_cm_to_box          166

# define  cd_box_update         168

# define  cd_dialog             201
# define  cd_zoom               202
# define  cd_scale              203
# define  cd_reload             204
# define  cd_refresh            205
# define  cd_grid               206
# define  cd_print              207

/* The pannel order is defined is relation with the Server_Proceed code - Do not Change ordering */

# define  cd_pannel_attr        220
# define  cd_pannel_create      221
# define  cd_pannel_add         222
# define  cd_pannel_enadis      223
# define  cd_pannel_change      224
# define  cd_pannel_open        225
# define  cd_pannel_close       226
# define  cd_pannel_get         227
# define  cd_pannel_put         228
# define  cd_pannel_del         229
# define  cd_pannel_req         230


/* DRAW Server cd_mplot flag bits definitions */

/* Flag of cd_plot directive :
     cdf_ST           Start Point Block,
     cdf_ND           End Point Block,
     cdf_3D           Block of 3D point,
     cdf_AB           Block of matrix relative coordinates,
     cdf_NRM          Normal Vectors must be generated (Only active for 3D Triangle/quad/polygone),
     cdf_UNMR         Normal vectors are given by the user (when set cdf_NRM is disabled).
*/

# define  cdf_ST                  1
# define  cdf_ND                  2
# define  cdf_3D                  4
# define  cdf_AB                  8
# define  cdf_NRM                32
# define  cdf_UNRM              128

# define  cdf_3DMSK         (cdf_3D|cdf_NRM|cdf_UNRM)

# define  cdf_STND          (cdf_ST|cdf_ND)
# define  cdf_3DST          (cdf_3DMSK|cdf_ST)
# define  cdf_3DND          (cdf_3DMSK|cdf_ND)
# define  cdf_3DSTND        (cdf_3DMSK|cdf_ST|cdf_ND)

# define  FNT_RELOAD          16384

#endif
