/*  P A S - P. WOLFERS SOFTWARE: V2.0-4 OF 15-OCT-2006 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long
#include <draw/draw_apientry.h>

/* Include the PAS environment file. */
#include "/usr/local/cpas/cpas_defs.h"

/* Define the local data section. */
static Blk( Rd, 400 ) = {
  3,   0,   0,   0,   3,   0,   0,   0,   3,   0,   0,   0,   3,   0,   0,   0,
 15,  15, 100, 105, 115, 112, 108,  97, 121,  95, 115, 117, 114, 102,  97,  99,
101,  70,  70,  47, 104, 111, 109, 101,  47, 119, 111, 108, 102, 101, 114, 115,
 47,  83, 111, 102, 116,  47,  68, 114,  97, 119,  95,  70,  76,  84,  75,  95,
115, 114,  99,  95,  86,  49,  46,  52,  67,  45,  98,  97, 115, 101,  47,  68,
114,  97, 119,  95,  69, 120,  97, 109, 112, 108, 101, 115,  47,  46,  47,  47,
101, 115, 118, 111, 108,  46, 112,  97, 115,   0,   0,   0,   0,   0, 128,  63,
  0,   0, 128,  63,   0,   0, 128,  63, 154, 153,  25,  62,   0,   0, 200,  66,
  0,   0, 200,  66,   0,   0,   0,   0,   0,   0,  72,  66, 154, 153,  25,  63,
154, 153,  25,  63, 154, 153,  25,  63,   0,   0, 128,  63,   0,   0, 128,  63,
  0,   0, 128,  63,   0,   0, 128,  63,   0,   0, 128,  63,   0,   0, 128,  63,
  0,   0, 128,  63,   0,   0, 128,  63,   0,   0, 128,  63,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 128,  63,   0,   0, 128,  63,
102, 102, 102,  63, 205, 204,  76,  62,   0,   0, 128,  63,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 128,  63,   0,   0,  64,  63,
  0,   0,  64,  63,   0,   0,   0,   0,   0,   0, 128,  63,   0,   0,   0,   0,
154, 153, 153,  62, 154, 153, 153,  62, 154, 153,  25,  63, 205, 204,  76,  62,
205, 204,  76,  63, 205, 204,  76,  63, 205, 204, 204,  62,  13,  13, 101, 115,
115,  97, 105,  95, 115, 121, 115,  95, 118, 111, 108,  13,  13,  69, 115, 115,
 97, 105,  32,  71, 114,  97, 112, 104, 105,  99,   5,   5, 120, 115,  32,  61,
 32,   8,   8,  32,  32,  32, 121, 115,  32,  61,  32,  10,  10,  32,  32,  32,
117, 110, 105, 116,  32,  61,  32,  16,  16,  32,  83, 101, 114, 118, 101, 114,
 32,  78,  97, 109, 101,  32,  61,  32,  34,   2,   2,  34,  46,   7,   7,  79,
 98, 106, 101,  99, 116, 115,  19,  19,  32,  70, 105, 110,  32,  69, 115, 115,
 97, 105,  32,  86, 111, 108, 117, 109, 101, 115,  46,   0,   0,   0,   0,   0
};

/* Define the local static Initialized section. */
static Blk( Ri, 336 ) = {
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 128,  63,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 128,  63,
  0,   0,   0,   0,   0,   0, 128,  63,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  63,   0,   0,   0,  63,
  0,   0,   0, 191,   0,   0,   0, 191,   0,   0,   0,  63,   0,   0,   0,  63,
  0,   0,   0,  63,   0,   0,   0, 191,   0,   0,   0,  63,   0,   0,   0, 191,
  0,   0,   0, 191,   0,   0,   0, 191,   0,   0,   0,  63,   0,   0,   0, 191,
  0,   0,   0,  63,   0,   0,   0, 191,   0,   0,   0,  63,   0,   0,   0,  63,
  0,   0,   0,  63,   0,   0,   0, 191,   0,   0,   0,  63,   0,   0,   0, 191,
  0,   0,   0, 191,   0,   0,   0, 191,   0,   0,   0,  63,   0,   0,   0,  63,
  0,   0,   0, 191,   0,   0,   0, 191,   0,   0,   0,  63,   0,   0,   0,  63,
  0,   0,   0,  63,   0,   0,   0,  63,   0,   0,   0, 191,   0,   0,   0, 191,
  0,   0,   0, 191,   0,   0,   0, 191, 128,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
};

/* Define the local static section. */
static Blk( Rs, 40 );

/* Declaration of external variables. */
extern SL Draw_SrvMod;
extern V PAS__f_output;


/* Function/procedure prototypes. */
void Draw_End();
SL Draw_Pas_Init(F *F_x, F *F_y, UB *F_unit, V F_usrid);
void Draw_Pas_Get_Server_Name(V F_s);
UB Draw_Pas_Picture_3D(V F_title, F F_px, F F_py, F F_pz, UB F_bscale, UB F_blimit)
;
SL Draw_Dialog(SL F_flags);
void Draw_Out_Mode(SL F_n);
void Draw_Set_Stop_Anim(SL F_md);
void Draw_Sphere(F F_xc, F F_yc, F F_zc, F F_r, SL F_plg, SL F_plt, SL F_flg);
void Draw_Cylinder(F F_xb, F F_yb, F F_zb, F F_th, F F_ph, F F_lg, F F_rb, F F_rt
, SL F_px, SL F_pz, SL F_flg);
void Draw_Disk(F F_xc, F F_yc, F F_zc, F F_th, F F_ph, F F_ri, F F_re, F F_sa, F
F_ea, SL F_pt, SL F_pr, SL F_flg);
void Draw_Pas_Polyhedral(V F_ftb, SL F_nfc, V F_vtb, SL F_nvt, SL F_oflg);
void Draw_Set_ColorA(F F_r, F F_v, F F_b, F F_a);
void Draw_Define_ColorA(SL F_icol, F F_r, F F_g, F F_b, F F_a);
void Draw_Line_Attr(SL F_n, F F_r);
void Draw_Fill_Attr(SL F_n1, SL F_n2);
SL Draw_New_Seg(SL F_n);
void Draw_Seg_End();
SL Draw_Push_Matrix();
void Draw_Pop_Matrix();
void Draw_Move_Mat3(SL F_imat, F F_tx, F F_ty, F F_tz);
void Draw_Rotate_Mat3(SL F_imat, F F_px, F F_py, F F_pz, F F_ome, F F_chi, F F_psi)
;
void Draw_Scale_Mat3(SL F_imat, F F_px, F F_py, F F_pz, F F_scx, F F_scy, F F_scz)
;
SL Draw_Put_Seg_Mat(SL F_iseg, V F_m);
void Draw_Alpha_Set(SL F_flg);
void Draw_Light_OnOff(SL F_light, SL F_flg);
void Draw_Light_Define(SL F_light, SL F_kind, V F_fparm, SL F_sz);
void Draw_Mat_Light_Prop(SL F_face, SL F_kind, V F_fparm, SL F_sz);
void Draw_View(F F_dist);


/* Procedure/Function : " display_surface "  */
void ESSAI_S_VOL_display_surface(){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );


  /* Code of procedure/function */
  memcpy(Ra.s,Rd.s,16);
  Ra.v[2]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+16;
  Ra.v[3]=Rd.s+16;
  Ra.v[4]=Rd.s+33;
  Ra.sl[10]=70; /* line # 70 */
  Ri.sl[0]=Draw_New_Seg(1);
  Ra.sl[10]=71; /* line # 71 */
  Draw_Put_Seg_Mat(Ri.sl[0],Ri.s+4);
  Ra.sl[10]=73; /* line # 73 */
  Draw_Mat_Light_Prop(0,3, Rd.s+108,4);
  Ra.sl[10]=74; /* line # 74 */
  Draw_Mat_Light_Prop(0,4, Rd.s+124,1);
  Ra.sl[10]=76; /* line # 76 */
  Draw_Light_Define(0,0, Rd.s+128,3);
  Ra.sl[10]=78; /* line # 78 */
  Draw_Light_Define(0,1, Rd.s+140,4);
  Ra.sl[10]=79; /* line # 79 */
  Draw_Light_Define(0,2, Rd.s+156,4);
  Ra.sl[10]=80; /* line # 80 */
  Draw_Light_Define(0,3, Rd.s+172,4);
  Ra.sl[10]=82; /* line # 82 */
  Draw_Set_ColorA((F)6.000000E-01, (F)6.000000E-01, (F)3.000000E-01, (F)1.000000E+00);
  Ra.sl[10]=84; /* line # 84 */
  Draw_Mat_Light_Prop(0,5, Rd.s+188,4);
  Ra.sl[10]=87; /* line # 87 */
  Draw_Define_ColorA(0, (F)7.000000E-01, (F)7.000000E-01, (F)7.000000E-01, (F)1.000000E+00);
  Ra.sl[10]=88; /* line # 88 */
  Draw_Light_OnOff(0,0);
  Ra.sl[10]=89; /* line # 89 */
  Draw_Light_OnOff(0,1);
  Ra.sl[10]=92; /* line # 92 */
  Draw_View((F)0.000000E-01);
  Ra.sl[10]=94; /* line # 94 */
  Rs.f[0]=(F)9.000000E+01;
  Rs.f[1]=(F)0.000000E-01;
  Ra.sl[10]=102; /* line # 102 */
  Draw_Mat_Light_Prop(0,2, Rd.s+204,4);
  Ra.sl[10]=104; /* line # 104 */
  Draw_Sphere((F)0.000000E-01, (F)-2.000000E+01, (F)0.000000E-01, (F)5.000000E+00,32,32,4);
  Ra.sl[10]=106; /* line # 106 */
  Draw_Set_ColorA((F)2.000000E-01, (F)4.000000E-01, (F)9.000000E-01, (F)1.000000E+00);
  Ra.sl[10]=111; /* line # 111 */
  Draw_Cylinder((F)0.000000E-01, (F)0.000000E-01, (F)0.000000E-01, (F)9.000000E+01,
  (F)4.500000E+01, (F)4.000000E+00, (F)1.500000E+00, (F)4.500000E+00,32,32,4);
  Ra.sl[10]=117; /* line # 117 */
  Draw_Set_ColorA((F)9.000000E-01, (F)9.000000E-01, (F)0.000000E-01, (F)1.000000E+00);
  Ra.sl[10]=118; /* line # 118 */
  Draw_Disk((F)0.000000E-01, (F)0.000000E-01, (F)0.000000E-01, (F)9.000000E+01, (F)
3.000000E+01, (F)0.000000E-01, (F)1.000000E+00, (F)0.000000E-01, (F)3.600000E+02,32,32,4);
  Ra.sl[10]=120; /* line # 120 */
  Draw_Mat_Light_Prop(0,5, Rd.s+220,4);
  Ra.sl[10]=121; /* line # 121 */
  Draw_Mat_Light_Prop(0,2, Rd.s+236,4);
  Ra.sl[10]=125; /* line # 125 */
  Draw_Sphere((F)-1.500000E+01, (F)2.200000E+01, (F)0.000000E-01, (F)1.000000E+01,32,32,4);
  Ra.sl[10]=127; /* line # 127 */
  Ri.sl[13]=Draw_Push_Matrix();
  Ra.sl[10]=129; /* line # 129 */
  Draw_Move_Mat3(Ri.sl[13],(F)0.000000E-01, (F)1.500000E+01, (F)0.000000E-01);
  Ra.sl[10]=130; /* line # 130 */
  Draw_Rotate_Mat3(Ri.sl[13],(F)0.000000E-01, (F)0.000000E-01, (F)0.000000E-01, (F)
-4.000000E+01, (F)0.000000E-01, (F)2.000000E+01);
  Ra.sl[10]=131; /* line # 131 */
  Draw_Scale_Mat3(Ri.sl[13],(F)0.000000E-01, (F)0.000000E-01, (F)0.000000E-01, (F)
1.000000E+01, (F)1.000000E+01, (F)1.000000E+01);
  Ra.sl[10]=133; /* line # 133 */
  Draw_Fill_Attr(1,0);
  Ra.sl[10]=134; /* line # 134 */
  Draw_Line_Attr(1, (F)2.500000E+00);
  Ra.sl[10]=135; /* line # 135 */
  Draw_Set_ColorA((F)1.000000E-01, (F)1.000000E-01, (F)8.000000E-01, (F)1.000000E+00);
  Ra.sl[10]=138; /* line # 138 */
  Draw_Pas_Polyhedral(Ra.s,4, Ri.s+56,12,0);
  Ra.sl[10]=140; /* line # 140 */
  Draw_Set_ColorA((F)0.000000E-01, (F)0.000000E-01, (F)0.000000E-01, (F)1.000000E+00);
  Ra.sl[10]=141; /* line # 141 */
  Draw_Mat_Light_Prop(0,5, Rd.s+252,4);
  Ra.sl[10]=142; /* line # 142 */
  Draw_Mat_Light_Prop(0,2, Rd.s+268,4);
  Ra.sl[10]=144; /* line # 144 */
  Draw_Alpha_Set(2);
  Ra.sl[10]=145; /* line # 145 */
  Draw_Fill_Attr(2,512);
  Ra.sl[10]=147; /* line # 147 */
  Draw_Set_ColorA((F)1.500000E-01, (F)3.500000E-01, (F)8.500000E-01, (F)6.500000E-01);
  Ra.sl[10]=152; /* line # 152 */
  Draw_Out_Mode(4);
  Ra.sl[10]=154; /* line # 154 */
  Draw_Pas_Polyhedral(Ra.s,4, Ri.s+56,12,16);
  Ra.sl[10]=155; /* line # 155 */
  Draw_Fill_Attr(0,1);
  Ra.sl[10]=156; /* line # 156 */
  Draw_Alpha_Set(0);
  Ra.sl[10]=158; /* line # 158 */
  Draw_Pop_Matrix();
  Ra.sl[10]=160; /* line # 160 */
  Draw_Seg_End();
  PAS__curr_cntx=Ra.v[2];
}


/* Procedure/Function : " essai_sys_vol "  */
main( int argc, C * argv[], C * env[] ) {
  /* Local variable stored in C variable */
  F Rv0;
  F Rv1;
  UB Rv2;
  UB Rv3;
  SL Rv4;

  /* Code of procedure/function */
  PAS__INIT( argc, argv, env );
  Rs.v[1]=PAS__curr_cntx;
  PAS__curr_cntx=Rs.s+8;
  Rs.v[2]=Rd.s+284;
  Rs.v[3]=Rd.s+33;
  Rs.sl[8]=172; /* line # 172 */
  Draw_SrvMod=16;
  Rs.sl[8]=174; /* line # 174 */
  Draw_Pas_Init(&Rv0, &Rv1, &Rv2, Rd.s+299);
  Rs.sl[8]=175; /* line # 175 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+314,-1,-1,32);
  PAS__WRITE_SNGL(Rv0,16,-6,0);
  PAS__WRITE_STR(Rd.s+321,-1,-1,32);
  PAS__WRITE_SNGL(Rv1,16,-6,0);
  PAS__WRITE_STR(Rd.s+331,-1,-1,32);
  PAS__WRITE_INT(Rv2,12,0);
  PAS__WRITE_EOLN();
  Rs.sl[8]=177; /* line # 177 */
  Draw_Pas_Get_Server_Name(Ri.s+200);
  Rs.sl[8]=179; /* line # 179 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+343,-1,-1,32);
  PAS__WRITE_STR(Ri.s+200,-1,-1,32);
  PAS__WRITE_STR(Rd.s+361,-1,-1,32);
  PAS__WRITE_EOLN();
  Rs.sl[8]=181; /* line # 181 */
  Rv3=Draw_Pas_Picture_3D(Rd.s+365,(F)6.000000E+01, (F)6.000000E+01, (F)6.000000E+01,1,1);
  Rs.sl[8]=186; /* line # 186 */
  ESSAI_S_VOL_display_surface();
  Rs.sl[8]=190; /* line # 190 */
  Draw_Set_Stop_Anim(0);
  Rs.sl[8]=192; /* line # 192 */
  Rv4=Draw_Dialog(1);
  Rs.sl[8]=214; /* line # 214 */
  Draw_End();
  Rs.sl[8]=215; /* line # 215 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+374,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Rs.v[1];
  PAS__EXIT( 0 );
}
