// ****************************************************************************
// *                                                                          *
// *                                                                          *
// *                                                                          *
// *    D R A W   -   S E R V E R   C O N N E C T I O N   M A N A G E R       *
// *                                                                          *
// *          (Kernel to Open/close the bidirectional IO Channel)             *
// *                                                                          *
// *                                 by                                       *
// *                                                                          *
// *           Pierre Wolfers, Laboratoire de Cristallographie                *
// *                                                                          *
// *           CNRS GRENOBLE,  25 Avenue des Martyrs, B.P. 166                *
// *                                                                          *
// *                      F 38042 GRENOBLE CEDEX 9                            *
// *                                                                          *
// *                             F R A N C E                                  *
// *                                                                          *
// *                                                                          *
// *                                                                          *
// ****************************************************************************

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////




#if !defined( _WIN32 ) || defined( __CYGWIN__ )
/*
 *       For any Unix like Operating Systems.
 *
*/

# include <stdio.h>
# include <sys/types.h>
# include <sys/socket.h>
# include <netinet/in.h>
# include <string.h>
# include <netdb.h>
# include <unistd.h>
# include <errno.h>



static int sock, iosock;

int Srv_Sock_Open( int port )
{
  struct sockaddr_in srv_addr, cli_addr;
  int cli_len;

  char* argu[3] = { "cli", "20000", NULL };

  if ((sock = socket( AF_INET, SOCK_STREAM, 0 )) < 0) { printf( " Server err -2:%d\n", errno ); return -2; }
  bzero( (char*) &srv_addr, sizeof( srv_addr ) );
  srv_addr.sin_family      =       AF_INET;
  srv_addr.sin_port        = htons( port );
  srv_addr.sin_addr.s_addr =    INADDR_ANY;
  if (bind( sock, (struct sockaddr*) &srv_addr, sizeof( srv_addr ) ) < 0) { printf( " Binding err -3:%d\n", errno ); return -3; }

  if ((spawnv( "cli", argu )) == -1) { /* Direct Call of Socket Client */
     printf( " Spawnv error.\n" ); return -10;
  }

  if (listen( sock, 5 ) < 0); /* {
    close( sock );
    printf( " Listen err -4:%d\n", errno ); return -4;
  } */
  cli_len = sizeof( cli_addr );
  if ((iosock = accept( sock, (struct sockaddr*) &cli_addr, (socklen_t*)&cli_len )) < 0) {
    close( sock );
    printf( " Accept err -5:%d\n", errno ); return -5;
  }
printf( "  iosock = %d\n", iosock );
  return 0;
}



void Srv_Sock_Close( void )
{
  close( iosock );
  close( sock );
}



int Srv_Sock_Read( char* buf, int buflen )
{
  bzero( buf, buflen );
  return read( iosock, buf, buflen );
}


int Srv_Sock_Write( char* buf, int buflen )
{
  return write( iosock, buf, buflen );
}






#else
/*
 *       For Windows Operating Systems.
 *
*/

# include <stdio.h>
# include <winsock2.h>
# include <string.h>

static SOCKET            sock, iosock;
static WSADATA                wsaData;
static struct sockaddr_in    srv_addr,
                             cli_addr;

# define Do_Exit( ierr ) { WSACleanup(); return ierr; }


int Srv_Sock_Open( int port )
{
  int    addr_len = sizeof( srv_addr );

  WSAStartup( 0x0101, &wsaData );

  if ((sock = socket( AF_INET, SOCK_STREAM, 0 )) < 0) Do_Exit( -2 );
  memset( &srv_addr, 0, sizeof( srv_addr ) );
  srv_addr.sin_family      =             AF_INET;
  srv_addr.sin_port        =       htons( port );
  srv_addr.sin_addr.s_addr = htonl( 0x7F000001 );
  if (bind( sock, (struct sockaddr*) &srv_addr, sizeof( srv_addr ) ) != 0) Do_Exit( -3 );
  if (listen( sock, 5 ) < 0) {
    shutdown( sock, 2 );
    closesocket( sock );
    Do_Exit( -4 );
  }
  if ((iosock = accept( sock, (struct sockaddr*) &cli_addr, &addr_len )) < 0) {
    shutdown( sock, 2 );
    closesocket( sock );
    Do_Exit( -5 );
  }
  return 0;
}



void Sock_Close( void )
{
  closesocket( iosock );
  closesocket( sock );
  WSACleanup();
}



int Sock_Read( char* buf, int buflen )
{
  return recv( iosock, buf, buflen, 0 );
}


int Sock_Write( char* buf, int buflen )
{
  return send( iosock, buf, buflen, 0 );
}



#endif


/*************************     E N D    ******************************/
