// simple OpenGL / FlTk program
// program simple2.cpp
// written 10/16/99, Michael L Gleicher

#include <fltk/GlWindow.h>
#include <fltk/run.h>
#include <GL/gl.h>
#include <fltk/DoubleBufferWindow.h>
#include <fltk/Button.h>

// make a Gl window that draws something:
class MyGlWindow : public fltk::GlWindow {
public:
  float r,g,b;
  MyGlWindow(int x, int y, int w, int h);

private:
  void draw();

};


MyGlWindow::MyGlWindow(int x, int y, int w, int h) : fltk::GlWindow( x, y, w, h, "My GL Window" )
{
    r = g = 1;
    b = 0;
}



MyGlWindow* gl;




void MyGlWindow::draw() {         // the draw method must be private
    glMatrixMode(GL_PROJECTION);        // set up coord system
    glLoadIdentity();                   // reset it
    glOrtho(-1,1,-1,1,-1,1);            // set it to be -1 to 1 in each axis
    glMatrixMode(GL_MODELVIEW);         // back to normal mode
    glLoadIdentity();                   // clear what anyone else did

    glClearColor(0,0,0,0);              // clear the window to black
    glClear(GL_COLOR_BUFFER_BIT);       // clear the window

    glColor3f(r,g,b);                   // draw in yellow
    glRectf(-.5,-.5,.5,.5);             // draw a filled rectangle
  };


// a simple callback to do something
void changeColor( fltk::Widget* /*button*/, MyGlWindow* myWind )
{
  myWind->r = 1 - myWind->r;
  myWind->g = 1 - myWind->g;
  myWind->b = 1 - myWind->b;
  myWind->damage( 1 );
}

// the main routine makes the window, and then runs an even loop
// until the window is closed
main( int argc, char** argv )
{
  fltk::DoubleBufferWindow* wind = new fltk::DoubleBufferWindow( 400, 300, "GL Sample" );

  wind->begin();                        // Put widgets inside of the window
    MyGlWindow* gl = new MyGlWindow( 10, 10, 280, 280 );
    fltk::Button* bt = new fltk::Button( 300, 10, 70, 25, "Color" );
    bt->callback((fltk::Callback*) changeColor, gl);
  wind->end();

  wind->show();                         // This actually opens the window

  fltk::run();
  delete gl;

  return 0;
}
