%pragma trace 1;
program Essai_Sys_Sol( input, output );

%include 'DRAWENV:draw_defs.pas' {, list_on};


const

  max_nbc = 2;
  pi      = 4.0*ARCTAN( 1.0 );
  inrd    = pi/180.0;
  dim     = 25;

  stp     =  0.5;
  sts     =  2.5;

var

  bstatus: boolean;
  unit: unit_type;
  i, j, k, irep: integer;
  xs, ys, xx, yy: Dfloat;

  status: Dint;
  dview: Dfloat := 100.0;
  xc, yc, xd, yd: Dfloat;

  iseg, imatp, imatpr, imats: [static] Dint := 0;

  php, phs: Dfloat;


procedure DISPLAY_SURFACE;
var
  xx, yy, zz: Dfloat;
  i, j, k, l, m: integer;

begin { DISPLAY_SURFACE }
  (* DRAW$VIEW( dview ); *)
  iseg := DRAW$NEW_SEG( 1 );
  php := 90.0; phs := 0.0;
  DRAW$COLOR( 2 );
  DRAW$SPHERE( 0.0, 0.0, 0.0, 5.0, 32, 32 );
  imatp := DRAW$PUSH_MATRIX;
  { DRAW$ROTATE_MAT3 Parameters: imat, px,py,pz, Ome,Chi,Phi }
  { with : p=(px,py,pz), Trsf = T(tx,ty,tz)*R(p,Ome,Chi,Phi)*Mscale(Sx,Sy,Sz) }
  DRAW$ROTATE_MAT3( imatp,  0.0,  0.0,  0.0,   { px, py, pz }
                           90.0, 80.0,  php ); { Ome, Chi, Phi }
  DRAW$COLOR( 3 );
  DRAW$SPHERE( 20.0, 0.0, 0.0, 1.0, 32, 32 );
  imats := DRAW$PUSH_MATRIX;
  { DRAW$TRANSF_MAT3 Parameters: imat, tx,ty,tz, px,py,pz, Ome,Chi,Phi, Sx,Sy,Sz }
  { with : p=(px,py,pz), Trsf = T(tx,ty,tz)*R(p,Ome,Chi,Phi)*Mscale(Sx,Sy,Sz) }
  DRAW$TRANSF_MAT3( imats, 20.0,  0.0,  0.0,   { tx, ty, tz }
                            0.0,  0.0,  0.0,   { px, py, pz }
                            0.0,  0.0,  phs,   { Ome, Chi, Phi }
                            1.0,  1.0,  1.0 ); { Sx, Sy, Sz }
  DRAW$COLOR( 1 );
  DRAW$SPHERE( 5.0, 0.0, 0.0, 0.25, 32, 32 );
  DRAW$POP_MATRIX;
  DRAW$POP_MATRIX;
  DRAW$SEG_END;
  WRITELN( ' im planet # ', imatp, ' im satellite # ', imats );
end DISPLAY_SURFACE;



begin { MAIN }

  {****************************************************}
  {          INITIALYSE THE DRAWING SYSTEM             }
  {****************************************************}

  DRAW$INIT( xs, ys, unit, 'Essai Graphic' );
  WRITELN( 'xs = ', xs, '   ys = ', ys, '   unit = ', unit );

  bstatus := DRAW$PICTURE3( 'Planetes', 60.0, 30.0, 60.0, true, true );

  DRAW$PIC_VIEW( 0 );
  DRAW$TIME_ANIM( 25 );

  DISPLAY_SURFACE;


stop_anim:
  DRAW$SET_STOP_ANIM( 0 );   { Clear any stop mode }

  irep := DRAW$DIALOG( 1 );
  if irep >= 0 then
  begin { Does not stop }
    DRAW$SET_STOP_ANIM( 1 ); { Set the single stop mode }
    for i := 0 to 4 do
      for j := 1 to 720 do
      begin
        php := stp*j + 90.0;
        phs := sts*j + 90.0;
(*      DRAW$MAT_UNIT_TRANSF( imatp );
        DRAW$ROTATE_MAT3( imatp,  0.0,  0.0,  0.0,   { px, py, pz }
                                 90.0, 80.0,  php ); { Ome, Chi, Phi }
*)
        DRAW$ROTATE_MAT3( imatp,  0.0,  0.0,  0.0,   { px, py, pz }
                                  0.0,  0.0,  stp ); { 0.0, 0.0, Delta_Phi }
(*      DRAW$MAT_UNIT_TRANSF( imats );
        DRAW$TRANSF_MAT3( imats, 20.0,  0.0,  0.0,   { tx, ty, tz }
                                  0.0,  0.0,  0.0,   { px, py, pz }
                                  0.0,  0.0,  phs,   { Ome, Chi, Phi }
                                  1.0,  1.0,  1.0 ); { Sx, Sy, Sz }
*)
        DRAW$ROTATE_MAT3( imats,  0.0,  0.0,  0.0,   { px, py, pz }
                                  0.0,  0.0,  sts ); { 0.0, 0.0, Delta_Phi }

        if Draw_Anim_State > 0 then goto stop_anim;

        (* WRITELN( ' Php = ', php:12:2, ', Phs = ', phs:12:2 ); *)
        SLEEP( 0.025 ); 
      end;
    goto stop_anim
  end;
  DRAW$END;
  WRITELN( ' Fin Essai System Solaire.' )
end Essai_Sys_Sol.
