%pragma trace 1;
program Essai_Sys_Include( input, output );

%include 'DRAWENV:draw_defs.pas' {, list_on};


const

  max_nbc = 2;
  pi      = 4.0*ARCTAN( 1.0 );
  inrd    = pi/180.0;
  dim     = 25;

  stp     =  2.0;
  sts     = 10.0;

var

  bstatus: boolean;
  unit: unit_type;
  i, j, k, irep, ipsg, ipid: integer;
  xs, ys, xx, yy: Dfloat;

  status: Dint;
  dview: Dfloat := 100.0;
  xc, yc, xd, yd: Dfloat;

  iarrow, ipar_ab, ipar_c, iseg, ia1, ia2, im_a, im_b, im_c,
  imatp, imatpr, imats: [static] Dint := 0;

  php, phs: Dfloat;

  spec_color:  array[1..4] of Dfloat := [0.8, 0.8, 0.8, 1.0];
  light_color: array[1..4] of Dfloat := [0.0, 1.0, 1.0, 1.0];
  light_pos:   array[1..3] of Dfloat := [0.0, 50.0,  25.0];



function Arrow_Seg( m: real; rd: real := 0.35; flg: boolean := false ): integer;
var
  iseg: dint;
  rdc, rfc, rar, pdz, pfz, paz: Dfloat;
  nb_seg: [static] integer := 100;

begin
  iseg := DRAW$NEW_SEG; {( nb_seg ); nb_seg := nb_seg + 1;}
  if flg then
  begin
    rar := rd; rdc := 0.3*rar; rfc := rdc;
    pdz := 0.0; pfz := m; paz := m - 0.5;
    DRAW$SET_PICKID( 0 )
  end
  else
  begin
    rdc := rd; rfc := rdc*(0.20/0.35); rar := rdc*(0.45/0.35);
    pfz := m*0.5; pdz := - pfz; paz := 0.6*pfz
  end;
  DRAW$SEG_ATTR( iseg, 0, 0, 0, 0.0 ); { Not detectable, Not HighLight, Not Visible, Priority }
    if not flg then DRAW$SET_PICKID( 1 );
    DRAW$DISK(     0.0,  0.0,  pdz, 180.0, 0.0, 0.00,  rdc,  0.0, 360.0, 32, 8, 4 );
    if not flg then DRAW$SET_PICKID( 2 );
    DRAW$CYLINDER( 0.0,  0.0,  pdz,   0.0, 0.0, paz - pdz, rdc, rfc, 32, 8, 4 );
    if not flg then DRAW$SET_PICKID( 3 );
    DRAW$DISK(     0.0,  0.0,  paz, 180.0, 0.0, rfc, rar, 0.0, 360.0, 32, 8, 4 );
    if not flg then DRAW$SET_PICKID( 4 );
    DRAW$CYLINDER( 0.0,  0.0,  paz,   0.0, 0.0, pfz - paz, rar, 0.0, 32, 8, 4 );
  DRAW$SEG_END;
  Arrow_Seg := iseg
end Arrow_Seg;


function Arrow( imom: integer; x, y, z, th, ph: Dfloat ): integer;
var
  imat: integer;

begin
  imat := DRAW$PUSH_MATRIX;
  DRAW$MOVE_MAT3( imat, x, y, z );
  DRAW$ROTATE_MAT3( imat, 0.0, 0.0, 0.0, ph, th, 0.0 );
  DRAW$INCLUDE_SEG( imom );
  DRAW$POP_MATRIX;
  Arrow := imat
end Arrow;



procedure DISPLAY_SURFACE;
var
  xx, yy, zz: Dfloat;
  i, j, k, l, m: integer;

  faces_tb:  array[1..4] of Dint := ( 3, 3, 3, 3 );
  vertex_tb: [static] array[1..12] of Dpoint3 := [
    [ 0.5, 0.5,-0.5], [-0.5, 0.5, 0.5], [ 0.5,-0.5, 0.5],
    [-0.5,-0.5,-0.5], [ 0.5,-0.5, 0.5], [-0.5, 0.5, 0.5],
    [ 0.5,-0.5, 0.5], [-0.5,-0.5,-0.5], [ 0.5, 0.5,-0.5],
    [-0.5, 0.5, 0.5], [ 0.5, 0.5,-0.5], [-0.5,-0.5,-0.5] ];

 ref_mat: [static] Dmatrix := [ [0.0, 1.0, 0.0, 0.0],
                                [0.0, 0.0, 1.0, 0.0],
                                [1.0, 0.0, 0.0, 0.0] ];
 tst_mat: Dmatrix;

  {
     GL_POINTS,         /*  0  for  GL Codes */
     GL_LINES,          /* -1 */
     GL_LINE_STRIP,     /* -2, Use by draw_out 1 */
     GL_LINE_LOOP,      /* -3 */
     GL_TRIANGLES,      /* -4 */
     GL_TRIANGLE_STRIP, /* -5 */
     GL_TRIANGLE_FAN,   /* -6 */
     GL_QUADS,          /* -7 */
     GL_QUAD_STRIP,     /* -8 */
     GL_POLYGON         /* -9, Use by draw_out 3 */
  }


begin { DISPLAY_SURFACE }
  ipar_ab := Arrow_Seg( 12.0, 0.2, true );
  ipar_c  := Arrow_Seg( 16.0, 0.2, true );
  iarrow  := Arrow_Seg(  5.0 );

  iseg := DRAW$NEW_SEG{ ( 1 ) };
  DRAW$SEG_ATTR( iseg, 2, 0, 2, 0.5 ); { Detectable, Not HighLight, Visible, Priority }
  DRAW$ROTATE_SEG3( iseg,  0.0,  0.0,  0.0,   { px, py, pz }
                          90.0, 80.0,-80.0 ); { Ome, Chi, Phi }
  DRAW$MOVE_SEG3( iseg, -8.0, -8.0, -8.0 );
  DRAW$SEG_ORIENTATION( iseg, 0.0, 0.0, 0.0 );
(*DRAW$PUT_SEG_MAT( iseg, ref_mat );*)

  DRAW$GET_SEG_MAT( iseg, tst_mat );
  for ii := 1 to 3 do
  begin
    for jj := 1 to 4 do
      write( tst_mat[ii,jj]:12:2 );
    writeln
  end;
  writeln;

(*
  for ii := 1 to 3 do
  begin
    for jj := 1 to 4 do
      write( ref_mat[ii,jj]:12:2 );
    writeln
  end;
*)

  DRAW$LIGHT_DEFINE( 0,      LIGHT_POSITION, Dpoint3[ 50.0,  0.0,  50.0] );
  DRAW$LIGHT_DEFINE( 0, LIGHT_AMBIENT_COLOR, Dcolor[ 0.6, 0.6, 0.6, 1.0] );
  DRAW$LIGHT_DEFINE( 0, LIGHT_DIFFUSE_COLOR, Dcolor[ 1.0, 1.0, 1.0, 1.0] );
  DRAW$LIGHT_DEFINE( 0, LIGHT_SPECULAR_COLOR, Dcolor[ 1.0, 1.0, 1.0, 1.0] );

  DRAW$MAT_LIGHT_PROP( MAT_FRONT_FACE, MAT_SHININESS, Dvalue[100.0] );
  DRAW$MAT_LIGHT_PROP( MAT_FRONT_FACE, MAT_EMISSION_COLOR, Dcolor[0.0, 0.0, 0.0, 1.0] );

  DRAW$VIEW( 0.0 );

  php := 90.0; phs := 0.0;


  DRAW$SET_PICKID ( 1000 );
  DRAW$DETECTABLE( 0 );

  DRAW$COLOR( 0.7, 0.0, 0.0, 1.0 );
  im_a := Arrow( ipar_ab, 0.0, 0.0, 0.0, 90.0,  0.0 ); (* a = b = 12 *)
  DRAW$COLOR( 0.0, 0.7, 0.0, 1.0 );
  im_b := Arrow( ipar_ab, 0.0, 0.0, 0.0, 90.0, 90.0 );
  DRAW$COLOR( 0.0, 0.0, 0.7, 1.0 );
  im_c := Arrow(  ipar_c, 0.0, 0.0, 0.0,  0.0,  0.0 ); (* c = 16 *)

  DRAW$COLOR( 1 );
  DRAW$PLOT3( 12.0,  0.0,  0.0, false );
  DRAW$PLOT3( 12.0, 12.0,  0.0, true  );
  DRAW$PLOT3(  0.0, 12.0,  0.0, true  );
  DRAW$PLOT3(  0.0,  0.0, 16.0, false );
  DRAW$PLOT3( 12.0,  0.0, 16.0, true  );
  DRAW$PLOT3( 12.0, 12.0, 16.0, true  );
  DRAW$PLOT3(  0.0, 12.0, 16.0, true  );
  DRAW$PLOT3(  0.0, 12.0, 16.0, true  );
  DRAW$PLOT3(  0.0,  0.0, 16.0, true  );
  DRAW$PLOT3( 12.0,  0.0, 16.0, false );
  DRAW$PLOT3( 12.0,  0.0,  0.0, true  );
  DRAW$PLOT3( 12.0, 12.0, 16.0, false );
  DRAW$PLOT3( 12.0, 12.0,  0.0, true  );
  DRAW$PLOT3(  0.0, 12.0, 16.0, false );
  DRAW$PLOT3(  0.0, 12.0,  0.0, true  );
  DRAW$PLOT3(  0.0,  0.0,  0.0, false );

  DRAW$DETECTABLE( 1 );

{ function Arrow( iseg_mom, r, x, y, z, th, ph: Dfloat ): integer; }

  { Plan z = 0 }
  DRAW$SET_PICKID( 10 );
  DRAW$COLOR( 0.2, 0.6, 0.2, 1.0 );
  ia1 := Arrow(  iarrow,  8.0,  8.0,  0.0, 22.0, 45.0 );
  DRAW$COLOR( 0.8, 0.5, 0.2, 1.0 );
  DRAW$SET_PICKID( 19 );
  DRAW$SPHERE(  8.0,  8.0,  0.0,  0.7, 32, 32, 4 );

  DRAW$SET_PICKID( 20 );
  DRAW$COLOR( 0.2, 0.2, 0.6, 1.0 );
  ia2 := Arrow( iarrow,  4.0,  4.0,  0.0, 48.0, 45.0 );
  DRAW$COLOR( 0.8, 0.5, 0.2, 1.0 );
  DRAW$SET_PICKID( 29 );
  DRAW$SPHERE(  4.0,  4.0,  0.0,  0.7, 32, 32, 4 );

  { Plan z = 1/2 }
  DRAW$SET_PICKID( 30 );
  DRAW$COLOR( 0.2, 0.6, 0.2, 1.0 );
  ia1 := Arrow(  iarrow,  2.0, 10.0,  8.0, 35.0, 25.0 );
  DRAW$COLOR( 0.8, 0.5, 0.2, 1.0 );
  DRAW$SET_PICKID( 39 );
  DRAW$SPHERE(  2.0, 10.0,  8.0,  0.7, 32, 32, 4 );

  DRAW$SET_PICKID( 40 );
  DRAW$COLOR( 0.2, 0.2, 0.6, 1.0 );
  ia2 := Arrow( iarrow,  10.0,  2.0,  8.0, 35.0, 65.0 );
  DRAW$COLOR( 0.8, 0.5, 0.2, 1.0 );
  DRAW$SET_PICKID( 49 );
  DRAW$SPHERE( 10.0,  2.0,  8.0,  0.7, 32, 32, 4 );

  { Plan z = 1 }
  DRAW$SET_PICKID( 50 );
  DRAW$COLOR( 0.2, 0.6, 0.2, 1.0 );
  ia1 := Arrow(  iarrow,  8.0,  8.0, 16.0, 22.0, 45.0 );
  DRAW$COLOR( 0.8, 0.5, 0.2, 1.0 );
  DRAW$SET_PICKID( 59 );
  DRAW$SPHERE(  8.0,  8.0, 16.0,  0.7, 32, 32, 4 );

  DRAW$SET_PICKID( 60 );
  DRAW$COLOR( 0.2, 0.2, 0.6, 1.0 );
  ia2 := Arrow( iarrow,  4.0,  4.0, 16.0, 48.0, 45.0 );
  DRAW$COLOR( 0.8, 0.5, 0.2, 1.0 );
  DRAW$SET_PICKID( 69 );
  DRAW$SPHERE(  4.0,  4.0, 16.0,  0.7, 32, 32, 4 );

  DRAW$SEG_END;
end DISPLAY_SURFACE;


begin { MAIN }

  {****************************************************}
  {          INITIALYSE THE DRAWING SYSTEM             }
  {****************************************************}

  Draw_Server_Mode := DrwSrv_Do_Lighting + DrwSrv_Enable_Light0;

  DRAW$INIT( xs, ys, unit, 'Essai Graphic' );
  WRITELN( 'xs = ', xs, '   ys = ', ys, '   unit = ', unit );

  bstatus := DRAW$PICTURE3( ' Complex Objects', 30.0, 30.0, 30.0, true, true );

  DRAW$LIGHT_ON_OFF( 0, 1 );                      { Allume la lampe # 0 }

  DISPLAY_SURFACE;

  loop
    irep := DRAW$DIALOG( 1 );
  exit if irep < 0;
    repeat
      status := DRAW$SEG_PICK( ipsg, ipid );
      WRITELN( ' Status = ', status, ' Pick of seg #', ipsg, ' with pick_id = ', ipid );
    until status < 0;
  end;

  DRAW$END;

  WRITELN( ' Fin Essai Include Objects.' )
end Essai_Sys_Include.
