// ****************************************************************************
// *                                                                          *
// *                                                                          *
// *                                                                          *
// *            F L T K / D R A W   -   S E R V E R   M O D U L E             *
// *                                                                          *
// *              Version  1.4-C for Draw Library Level V 2.4 A               *
// *                                                                          *
// *        (Draw interface for FLTK/OPENGL function and procedures)          *
// *                                                                          *
// *                                                                          *
// *          (procedures to process the Draw Client directives)              *
// *                                                                          *
// *                                                                          *
// *                                 by                                       *
// *                                                                          *
// *                                                                          *
// *            Pierre Wolfers, Laboratoire de Cristallographie               *
// *                                                                          *
// *            CNRS GRENOBLE,  25 Avenue des Martyrs, B.P. 166               *
// *                                                                          *
// *                       F 38042 GRENOBLE CEDEX 9                           *
// *                                                                          *
// *                             F R A N C E                                  *
// *                                                                          *
// *                                                                          *
// *                                                                          *
// *                                                                          *
// ****************************************************************************

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



/* include the environment SERVER */

#include "Server_DrawGL.h"
#include "Server_Env.h"
#include "Server_AxisBox.h"

/* The Maximum popup menu entry number is 32  */
/* The Maximum number of entry in one popup menu is 63 characters (+ the "\n" character) */
#define Menu_Max    32
#define Menu_ItmSz  63

/* The menu table can be used as a single string array */
#define Menu_BfSize Menu_Max*(Menu_ItmSz+1)

#  define _Inp_Req_Display( upd ) \
     DrwGL_Inp_Req_Display( upd ); \
     goto Sequence_Continue;


#  define _Srv_Call_Request \
     DrwGL_Update_Display(); \
     DrwSrv_Wait_For_Req(); \
     goto Sequence_Continue;


/****  Local Variables  ****/

static char *      menu[Menu_Max+1];            /* Pointer table for menu strings + (End NULL pointer). */
static char   menu_buf[Menu_BfSize];            /* table of menu entry/filter strings charaters */
static int     menu_topn, menu_tops;

static char draw_pvw = 0;                       /* Flag for DRAW$PIC_VIEW. */



void Draw_Exchange_Init( void )
{ int i;
  /* Send to User the Server capability word. */
  Sdrw_Put_Int( SERVER_IDENT );                 /* Send the server Identity. */

#if (!defined( _WIN32)) || defined(__CYGWIN__)
  Sdrw_Put_Int( SERVER_FUNCT );                         /* Send the Capability Word for Unix like server. */
#else
  Sdrw_Put_Int( SERVER_FUNCT | SERVER_DO_WIN32_FS );    /* Send the Capability Word for Windows natif server. */
#endif

  sprintf( menu_buf, "%s %s %s", SERVER_NAME, SERVER_VERSION, SERVER_DATE );
  Sdrw_Put_String( menu_buf, 0 );

  i =    Sdrw_Dialog_Request();                 /* Write to Client and wait for Answerd. */
  Drwgl_usr_request = Sdrw_Get_Int();           /* Get the User Requested Funct. */
  Drwgl_taskname = Sdrw_Get_String_Tmp();       /* Get the User task Name. */
}



void Draw_Extern_Init( void )
{ /* */
  Char    b0;
  float x, y;

  fprintf( fmsg, " Auto Init Process.\n" );
  fflush( fmsg );

  status = Draw_Init( &x, &y, &b0 );
  /* Return the Server and Display Specifications to client Application. */
  Sdrw_Put_Float( x );                          /* Send to Client the Display size ... */
  Sdrw_Put_Float( y );
  Sdrw_Put_Char( b0 );                          /* and the unit Flag (1 = cm., 0 = Raster U. */
  Sdrw_Write();                                 /* Write the last Client Answerd. */
  reqnxt          = 0;                          /* Turn to User Task Command Mode. */
  Drwgl_exitmd    = 0;                          /* Set the None Defined Exit node mode. */
}


extern void Tree_Dump( Draw_Ptr );

void * Draw_Sequence_Exec( void * pp )
{ /* ***  Main DRAW code Processor  *** */
  Char  b0, b1, b2, bupd;
  int   code, flg, i, i0, i1, i2, len, n, m;
  float r, v0, v1, v2, x, x0, x1, y, y0, y1, z, z0, z1;
  float        * f1;
  float     ftb[64];
  int       itb[16];
  char         * ps;
  Draw_Ptr        p;
  Draw_Box_Ptr   pb;

  static char s0[256];

/*
  fprintf( fmsg, " Start Draw Sequence.\n" );
  fflush( fmsg ); */

  while (1)
  { /* Loop on Pipe User Program Requests. */
    bupd = 0;                                                   /* Assume no update. */
    len = Sdrw_Read();                                          /* Wait for Read Buffer from User Application. */
    code = Sdrw_Get_Code();                                     /* Get the Draw Operator code. */
/*
    fprintf( fmsg, " Draw msg of %d bytes.\n", len );
    fprintf( fmsg, " Draw Code %d, len = %d\n", code, len );
    fflush( fmsg );
*/
    reqnxt = 0;

    DrwSrv_Lock();                                              /* Lock the User Directive Execution Graph. */
/*
fprintf( fmsg, " exec code %d\n", code ); fflush( fmsg );
*/
    switch (code) {                                             /* Dispatch to the related DRAW routine. */

    case cd_picture:
      Sdrw_Get_String( sv_title, 128 );
      x  = Sdrw_Get_Float();                                    /* Get the Required space */
      y  = Sdrw_Get_Float();
      z  = Sdrw_Get_Float();
      b1 = Sdrw_Get_Char();
      b2 = Sdrw_Get_Char();
      fprintf( fmsg, " Draw Code Init(%f, %f, %f, %d, %d);\n", x, y, z, b1, b2 );
      fflush( fmsg );
      b0 = Draw_Picture( sv_title, x, y, z, b1, b2 );
      bupd = draw_pvw;
      Sdrw_Put_Char( b0 );
    break;


    case cd_picture_scales:
      n = Sdrw_Get_Int();
      switch (n) {
        case -1:       /* Sizes of the GL window in pixels */
          x = (float) dt_rx; y = (float) dt_ry;
        break;
        case -2:       /* Sizes of the GL window in Cm */
          x = ds_rx; y =    ds_ry;
        break;
        case -3:       /* Sizes of the Screen in Cm */
          x = d_width; y =  d_height;
        break;
        case  1:       /* Scale in Pixel/Cm on the Screen */
          x = d_xscale; y = d_yscale;
        break;
        default:       /* By default, put the Current and Saved Scale (in screen_cm/user_cm) */
          x = cxy_scale; y = sxy_scale;
        break;
      }
/*    fprintf( fmsg, " Get Scales %d -> (%8.2f %8.2f)\n", n, x, y );
      fflush( fmsg ); */
      Sdrw_Put_Float( x );
      Sdrw_Put_Float( y );
    break;

    case cd_pic_view:
      flg = Sdrw_Get_Char();
      draw_pvw = 1;
      bupd = draw_pvw;
      Sdrw_Put_Char( 0 );
    break;

    case cd_pic_reset:
      flg = Sdrw_Get_Char();
      draw_pvw = 0;
      Sdrw_Put_Char( 0 );
    break;

    case cd_tim_anim:
      i = Drwgl_time_period;
      i0 = Sdrw_Get_Int();
      if ((i0 >= 1) || (i0 <= 500)) Drwgl_period_set = i0;
      Sdrw_Put_Int( i );
    break;

    case cd_anim_stop:
      Drwgl_astpmod   = Sdrw_Get_Char();
      Drwgl_astpstate = 0;
      Sdrw_Put_Char( 0 );
    break;

    case cd_clipon:
      Draw_Gen_Box_Ref( 1 );
      Sdrw_Put_Char( 0 );
    break;

    case cd_clipoff:
      Draw_Gen_Box_Ref( 0 );
      Sdrw_Put_Char( 0 );
    break;

    case cd_org:
      x = Sdrw_Get_Float();
      y = Sdrw_Get_Float();
      z = Sdrw_Get_Float();
      i = Sdrw_Get_Int();
      if (i == 0) {    /* Relative To previous Origine */
        orgx += x;
        orgy += y;
        orgz += z;
      } else {         /* Absolute (as after Picture Call) Origine */
        orgx = org_orgx + x;
        orgy = org_orgy + y;
        orgz = org_orgz + z;
      }
      Sdrw_Put_Char( 0 );
    break;

    case cd_color:
      x  = Sdrw_Get_Float();
      if (sdrw_read_left) {
        y  = Sdrw_Get_Float();
        z  = Sdrw_Get_Float();
        v0 = (sdrw_read_left)?Sdrw_Get_Float():1.0;
      } else {
        i  = (int)( fabs( x ) + 0.5);
        x  = draw_srccoltb[i][0];
        y  = draw_srccoltb[i][1];
        z  = draw_srccoltb[i][2];
        v0 = draw_srccoltb[i][3];
      }
      Draw_Gen_Color( x, y, z, v0 );
      Sdrw_Put_Char( 0 );
    break;

    case cd_out_mode:
      draw_out_mode = Sdrw_Get_Int();
      Sdrw_Put_Char( 0 );
    break;

    case cd_mplot:
      n  = Sdrw_Get_Int();
      i0 = Sdrw_Get_Int();
/*    fprintf( fmsg, "  Create/read Mplot %d, %d.\n", n, i0 );
      fflush( fmsg ); */
      if (Draw_Opened_Box) Draw_Gen_SMplot( n, i0, NULL );
                      else Draw_Gen_Mplot( n, i0, NULL );
      bupd = draw_pvw;
      Sdrw_Anim_acq( Drwgl_astpstate );
    break;

    case cd_progsetting:
      n  = Sdrw_Get_Int();              /* Get segment identifier */
      i0 = Sdrw_Get_Int();              /* Get Pick identifier (or 0) */
      i1 = 0;
      if (n>0) {
        p  = Draw_Locate_Seg( n );      /* Get the Segment Pointer */
        if (p) i1 = Draw_ProgPlot_Set( p->seg.seg_fdir, i0 );
        if (!i0) Draw_Error( "Cannot Locate 2D Plot (in segment) to set as progressive one.", (char*)(&n) );

      }
      else
        if (n = 0) Draw_Set_MaxPPlot( i0 );     /* Set a maximum limit of points */
              else Draw_ProgPlot_End();         /* Return the current progressive plot as a std. plot */
      Sdrw_Put_Char( 0 );
    break;

    case cd_progplot:
      x = Sdrw_Get_Float();
      y = Sdrw_Get_Float();
      if (!Draw_Opened_Box) {
        ftb[0] = x + orgx;
        ftb[1] = y + orgy;
      } else {
        f1 = ftb;
        Draw_Scale( x, y, f1, 0);
      }
      Draw_ProgPlot( ftb[0], ftb[1] );
      bupd = draw_pvw;
      Sdrw_Anim_acq( Drwgl_astpstate );
    break;

    case cd_circle:
      i0 = Sdrw_Get_Int();
      x  = Sdrw_Get_Float();
      y  = Sdrw_Get_Float();
      r  = Sdrw_Get_Float();
      v0 = Sdrw_Get_Float();
      v1 = Sdrw_Get_Float();
      v2 = Sdrw_Get_Float();
      if (!((i0&cdf_AB)||draw_mat_cnt)) { x += orgx; y += orgy; }
      Draw_Gen_Circle( x, y, r, v0, v1, v2 );
      bupd = draw_pvw;
      Sdrw_Anim_acq( Drwgl_astpstate );
    break;

    case cd_string:
      i0 = Sdrw_Get_Char();
      x  = Sdrw_Get_Float();
      y  = Sdrw_Get_Float();
/*    fprintf( fmsg, " => At (%f,%f) Draw String .\n", x, y ); */
      if (!((i0&cdf_AB)||draw_mat_cnt)) { x += orgx; y += orgy; }
      v0 = Sdrw_Get_Float();
      v1 = Sdrw_Get_Float();
      i  = Sdrw_Get_String( s0, 256 );
/*    fprintf( fmsg, " => At (%f,%f) %d:String %s .\n", x, y, i, s0 );
      fflush( fmsg ); */
      Draw_Gen_Text( x, y, v0, v1, i, s0 );
      bupd = draw_pvw;
      Sdrw_Anim_acq( Drwgl_astpstate );
    break;

    case cd_text_in_box:
      Draw_Gen_Text_Box();
      bupd = draw_pvw;
      Sdrw_Anim_acq( Drwgl_astpstate );
    break;

    case cd_sphere:
      i0 = Sdrw_Get_Int();
      x  = Sdrw_Get_Float();
      y  = Sdrw_Get_Float();
      z  = Sdrw_Get_Float();
      r  = Sdrw_Get_Float();
      i1 = Sdrw_Get_Int();
      i2 = Sdrw_Get_Int();
      if (!((i0&cdf_AB)||draw_mat_cnt)) { x += orgx; y += orgy; z += orgz; }
      Draw_Gen_Sphere( x, y, z, r, i1, i2, i0%cdf_AB );
      bupd = draw_pvw;
      Sdrw_Anim_acq( Drwgl_astpstate );
    break;

    case cd_cylinder:
      i0 = Sdrw_Get_Int();
      for (i = 0; i < 8; i++) ftb[i] = Sdrw_Get_Float();
      i1 = Sdrw_Get_Int();
      i2 = Sdrw_Get_Int();
      if (!((i0&cdf_AB)||draw_mat_cnt)) { ftb[0] += orgx; ftb[1] += orgy; ftb[2] += orgz; }
      Draw_Gen_Cylinder( ftb, i1, i2, i0%cdf_AB );
      bupd = draw_pvw;
      Sdrw_Anim_acq( Drwgl_astpstate );
    break;

    case cd_disk:
      i0 = Sdrw_Get_Int();
      for (i = 0; i < 9; i++) ftb[i] = Sdrw_Get_Float();
      i1 = Sdrw_Get_Int();
      i2 = Sdrw_Get_Int();
      if (!((i0&cdf_AB)||draw_mat_cnt)) { ftb[0] += orgx; ftb[1] += orgy; ftb[2] += orgz; }
      Draw_Gen_Disk( ftb, i1, i2, i0%cdf_AB );
      bupd = draw_pvw;
      Sdrw_Anim_acq( Drwgl_astpstate );
    break;

    case cd_surface:
      i0 = Sdrw_Get_Int();
      i1 = Sdrw_Get_Int();
      i2 = Sdrw_Get_Int();
      if (Draw_Opened_Box) Draw_Gen_MSurface( i1, i2, i0 );
                      else Draw_Gen_Surface( i1, i2, i0 );
      bupd = draw_pvw;
      Sdrw_Anim_acq( Drwgl_astpstate );
    break;

    case cd_surface2:
      i0 = Sdrw_Get_Int();
      i1 = Sdrw_Get_Int();
      i2 = Sdrw_Get_Int();
      x0 = Sdrw_Get_Float();
      y0 = Sdrw_Get_Float();
      x1 = Sdrw_Get_Float();
      y1 = Sdrw_Get_Float();
      if (Draw_Opened_Box) Draw_Gen_MSurface2( i1, i2, i0, x0, y0, x1, y1 );
                      else Draw_Gen_Surface2( i1, i2, i0, x0, y0, x1, y1 );
      bupd = draw_pvw;
      Sdrw_Anim_acq( Drwgl_astpstate );
    break;

    case cd_polyhedral:
      i0 = Sdrw_Get_Int();
      i1 = Sdrw_Get_Int();
      i2 = Sdrw_Get_Int();
      Draw_Gen_Polyhedral( i1, i2, i0 );
      bupd = draw_pvw;
      Sdrw_Anim_acq( Drwgl_astpstate );
    break;

    case cd_view:
      Draw_Dist = Sdrw_Get_Float();
      if (Draw_Dist <= 0.1*draw_uzmax) Draw_Dist = 0.0;
      bupd = draw_pvw;
      Sdrw_Anim_acq( Drwgl_astpstate );
    break;

    case cd_wplane3:   /* Define a plot plane for next drawing directive */
      for (i = 0; i < 12; i++) ftb[i] = Sdrw_Get_Float();
      Draw_Gen_Eplane( ftb );
      Sdrw_Put_Char( 0 );
    break;

    case cd_nplane3:   /* Release a plot plane for next drawing directive */
      Draw_Gen_Eplane( NULL );
      Sdrw_Put_Char( 0 );
    break;

    case cd_alpha_set:
      Draw_Gen_BlendSet( Sdrw_Get_Int() );
      Sdrw_Put_Char( 0 );
    break;

    case cd_light_set:
      i0 = Sdrw_Get_Int();
      i1 = Sdrw_Get_Int();
      Draw_Light_On_Off( i0, i1 );
      bupd = draw_pvw;
      Sdrw_Put_Char( 0 );
    break;

    case cd_matp_light:
      i0 = Sdrw_Get_Int();
      i1 = Sdrw_Get_Int();
      i = 0;
      while (sdrw_read_left&&(i < 4)) ftb[i++] = Sdrw_Get_Float();
      Draw_Gen_MatLight( i0, i1, i, ftb );
      Sdrw_Put_Char( 0 );
    break;

    case cd_light_def:
      i0 = Sdrw_Get_Int();                      /* DRAW Light # start from 0 as in GL */
      i1 = Sdrw_Get_Int();
      i = 0;
      while (sdrw_read_left&&(i < 4)) ftb[i++] = Sdrw_Get_Float();
      if ((i1 == 0)&&(!draw_mat_cnt)) { ftb[0] += orgx; ftb[0] += orgy; ftb[0] += orgz; }
      Draw_Gen_LightDef( i0, i1, i, ftb );
      bupd = draw_pvw;
      Sdrw_Put_Char( 0 ); 
    break;

    case cd_define_color:
      n  = Sdrw_Get_Int();
      x  = Sdrw_Get_Float();
      y  = Sdrw_Get_Float();
      z  = Sdrw_Get_Float();
      v0 = (sdrw_read_left)?Sdrw_Get_Float():1.0;
      Draw_Set_Color_Def( n, x, y, z, v0 );
      bupd = draw_pvw;
      Sdrw_Put_Char( 0 );
    break;

    case cd_inquire_color:
      Draw_Get_Color_Def( Sdrw_Get_Int(), &x, &y, &z, &v0 );
      Sdrw_Put_Int( status );
      Sdrw_Put_Float( x );
      Sdrw_Put_Float( y );
      Sdrw_Put_Float( z );
      Sdrw_Put_Float( v0 );
    break;

    case cd_push_pop_attr:
      Draw_Gen_PP_Attr( Sdrw_Get_Int() );
      Sdrw_Put_Char( 0 );
    break;

    case cd_line_attr:
      n = Sdrw_Get_Int();
      r = Sdrw_Get_Float();
      Draw_Gen_Lattr( n, r );
      Sdrw_Put_Char( 0 );
    break;

    case cd_marker_attr:
      n = Sdrw_Get_Int();
      r = Sdrw_Get_Float();
      Draw_Gen_Mattr( n, r );
      Sdrw_Put_Char( 0 );
    break;

    case cd_fill_area_attr:
      i0 = Sdrw_Get_Int();
      i1 = Sdrw_Get_Int();
      Draw_Gen_Fattr( i0, i1 );
      Sdrw_Put_Char( 0 );
    break;

    case cd_text_font: /* Font Selection */
      n  = Sdrw_Get_Int();
      i  = Draw_Gen_SelectFont( n );
      Sdrw_Put_Char( i );
    break;

    case cd_text_attr:
      i0 = Sdrw_Get_Int();
      i1 = Sdrw_Get_Int();
      i2 = Sdrw_Get_Int();
      v0 = Sdrw_Get_Float();
      v1 = Sdrw_Get_Float();
      v2 = Sdrw_Get_Float();
      Draw_Gen_Tattr( i0, i1, i2, v0, v1, v2 );
      Sdrw_Put_Char( 0 );
    break;

    case cd_install_font:
      i0 = Sdrw_Get_Int();
      i1 = Sdrw_Get_Int();
      i  = Sdrw_Get_String( s0, 256 );
      i0 = Draw_Install_Font( i0, i1, i, s0 );
      Sdrw_Put_Int( i0 );
    break;

    case cd_font_info:
      i0 = Sdrw_Get_Int();
      i0 = Draw_Font_Info( i0, &i1, &ps );
      Sdrw_Put_Int( i0 );
      if (i0>=0) {
        Sdrw_Put_Int( i1 );
        Sdrw_Put_String( ps, 0 );
      }
    break;

    case cd_gen_tmat:
      draw_mat_cnt++;
      i0 = Sdrw_Get_Char();
      i1 = Draw_Gen_TMat( i0 );
      if (i0) draw_mat_cnt++; else draw_mat_cnt--;
      Sdrw_Put_Int( i1 );
      break;

    case cd_init_trans_mat:
      n  = Sdrw_Get_Int();
      p  = Draw_Locate_TMat( n );                               /* Get the Matrix Pointer */
      i  = Sdrw_Get_Char();
      if (p) DrwGL_Seg_Unit_Transform( p->tmat.trsf_mat );
        else Draw_Error( "Cannot Reset to Identity the Not Existing Matrix", (char*)(&n) );
      if (i) bupd = draw_pvw;
      Sdrw_Anim_acq( Drwgl_astpstate );
    break;

    case cd_move_mat:
      n  = Sdrw_Get_Int();
      p  = Draw_Locate_TMat( n );                               /* Get the Matrix Pointer */
      x  = Sdrw_Get_Float();
      y  = Sdrw_Get_Float();
      z  = Sdrw_Get_Float();
      if (p) DrwGL_Move_Seg( p->tmat.trsf_mat, x, y, z );
        else Draw_Error( "Cannot Change(Move) the Not Existing Matrix", (char*)(&n) );
      bupd = draw_pvw;
      Sdrw_Anim_acq( Drwgl_astpstate );
    break;

    case cd_urotate_mat:
      n  = Sdrw_Get_Int();
      p  = Draw_Locate_TMat( n );                               /* Get the Matrix Pointer */
      x  = Sdrw_Get_Float();                                    /* Do not translate from Origine, the */
      y  = Sdrw_Get_Float();                                    /* translation is performed from VGL base */
      z  = Sdrw_Get_Float();
      v0 = Sdrw_Get_Float();
      v1 = Sdrw_Get_Float();
      v2 = Sdrw_Get_Float();
      if (p) DrwGL_URot_Seg( p->tmat.trsf_mat, x, y, z, v0, v1, v2 );
        else Draw_Error( "Cannot Change(URot) the Not Existing Matrix", (char*)(&n) );
      bupd = draw_pvw;
      Sdrw_Anim_acq( Drwgl_astpstate );
    break;

    case cd_rotate_mat:
      n  = Sdrw_Get_Int();
      p  = Draw_Locate_TMat( n );                               /* Get the Matrix Pointer */
      x  = Sdrw_Get_Float();                                    /* Do not translate from Origine, the */
      y  = Sdrw_Get_Float();                                    /* translation is performed from VGL base */
      z  = Sdrw_Get_Float();
      v0 = Sdrw_Get_Float();
      v1 = Sdrw_Get_Float();
      v2 = Sdrw_Get_Float();
      if (p) DrwGL_Rotate_Seg( p->tmat.trsf_mat, x, y, z, v0, v1, v2 );
        else Draw_Error( "Cannot Change(Rotate) the Not Existing Matrix", (char*)(&n) );
      bupd = draw_pvw;
      Sdrw_Anim_acq( Drwgl_astpstate );
    break;

    case cd_scale_mat:
      n  = Sdrw_Get_Int();
      p  = Draw_Locate_TMat( n );                               /* Get the Matrix Pointer */
      x  = Sdrw_Get_Float();                                    /* Do not translate from Origine, the */
      y  = Sdrw_Get_Float();                                    /* translation is performed from VGL base */
      z  = Sdrw_Get_Float();
      x1 = Sdrw_Get_Float();
      y1 = Sdrw_Get_Float();
      z1 = Sdrw_Get_Float();
      if (p) DrwGL_Scale_Seg( p->tmat.trsf_mat, x, y, z, x1, y1, z1 );
        else Draw_Error( "Cannot Change(Scale) the Not Existing Matrix", (char*)(&n) );
      bupd = draw_pvw;
      Sdrw_Anim_acq( Drwgl_astpstate );
    break;

    case cd_transform_mat:
      n  = Sdrw_Get_Int();
      p  = Draw_Locate_TMat( n );                               /* Get the Matrix Pointer */
      x  = Sdrw_Get_Float();                                    /* Get the Translation */
      y  = Sdrw_Get_Float();
      z  = Sdrw_Get_Float();
      x0 = Sdrw_Get_Float();                                    /* Get the fixed point */
      y0 = Sdrw_Get_Float();                                    /* Do not translate from Origine, the */
      z0 = Sdrw_Get_Float();                                    /* translation is performed from VGL base */
      v0 = Sdrw_Get_Float();                                    /* Get the rotation angles */
      v1 = Sdrw_Get_Float();
      v2 = Sdrw_Get_Float();
      x1 = Sdrw_Get_Float();                                    /* Get the x,y,z Scaling */
      y1 = Sdrw_Get_Float();
      z1 = Sdrw_Get_Float();
      if (p) DrwGL_Transf_Seg( p->tmat.trsf_mat, x, y, z, x0, y0, z0, v0, v1, v2, x1, y1, z1 );
        else Draw_Error( "Cannot Change(Transform) the Not Existing Matrix", (char*)(&n) );
      bupd = draw_pvw;
      Sdrw_Anim_acq( Drwgl_astpstate );
    break;

    case cd_get_transf_mat:
      n  = Sdrw_Get_Int();
      p  = Draw_Locate_TMat( n );                               /* Get the Matrix Pointer */
      if (p) {
        Sdrw_Put_Int( 12 );
        for (i1 = 0; i1 < 3; i1++ )
          for (i2 = 0; i2 < 4; i2++)
            Sdrw_Put_Float( p->tmat.trsf_mat[i2*4+i1] );
      } else {
        Draw_Error( "Cannot Get the Not Existing Matrix", (char*)(&n) );
        Sdrw_Put_Int( -1 );
      }
    break;

    case cd_put_transf_mat:
      n  = Sdrw_Get_Int();
      p  = Draw_Locate_TMat( n );                               /* Get the Matrix Pointer */
      if (p) {
        for (i1 = 0; i1 < 3; i1++ )
          for (i2 = 0; i2 < 4; i2++)
            p->tmat.trsf_mat[i2*4+i1] = Sdrw_Get_Float();
        Sdrw_Put_Int( 0 );
      } else {
        Draw_Error( "Cannot Put the Not Existing Matrix", (char*)(&n) );
        Sdrw_Put_Int( -1 );
      }
    break;

    case cd_new_seg:
      draw_mat_cnt = 0;
      i0 = Sdrw_Get_Int();
      p = Draw_New_Segment( i0, 0 );
      Sdrw_Put_Int( p->seg.seg_ide );
/*    fprintf( fmsg, " New Seg #%d\n", p->seg.seg_ide );
      fflush( fmsg ); */
    break;

    case cd_seg_end:
      /* Tree_Dump( draw_curseg ); */
      draw_mat_cnt = 0;
      draw_curseg = NULL;
      bupd = draw_pvw;
      Sdrw_Put_Char( 0 );
    break;

    case cd_del_seg:
      n = Sdrw_Get_Int();
      p = Draw_Locate_Seg( n );
      if (p) Draw_Destroye( p );
      bupd = draw_pvw;
      Sdrw_Put_Char( 0 );
    break;

    case cd_exec_seg:
      n = Sdrw_Get_Int();
      Draw_Gen_Exec_Seg( n );
      bupd = draw_pvw;
      Sdrw_Put_Char( 0 );
    break;

    case cd_update_seg:
      draw_mat_cnt = 0;
      i0 = Sdrw_Get_Int();
      p = Draw_New_Segment( i0, Sdrw_Get_Int() );
      if (p) Sdrw_Put_Int( p->seg.seg_ide );
        else Sdrw_Put_Int( -1 );
    break;

    case cd_seg_attr:
      n  = Sdrw_Get_Int();
      i0 = Sdrw_Get_Int();
      i1 = Sdrw_Get_Int();
      i2 = Sdrw_Get_Int();
      r  = Sdrw_Get_Float();
      if (Draw_Set_Seg_Attr( n, i0, i1, i2, r )) bupd = draw_pvw;
      Sdrw_Put_Char( 0 );
    break;

    case cd_seg_picid:
      i0 = Sdrw_Get_Int();
      if (i0 > 0) { draw_curr_pid = i0; draw_curr_detf = 1; }
      if (i0 < 0) draw_curr_detf = 0;
      Sdrw_Put_Char( 0 );
    break;

    case cd_seg_pdetf:
      i0 = Sdrw_Get_Int();
      i1 = draw_curr_detf;
      if (i0>=0) draw_curr_detf = (i0 > 0);
      Sdrw_Put_Int( i1 );
    break;

    case cd_seg_inquire:
      if (draw_curseg) Sdrw_Put_Int( draw_curseg->seg.seg_ide );
                  else Sdrw_Put_Int( -1 );
    break;

    case cd_init_trans_seg:
      n  = Sdrw_Get_Int();
      p  = Draw_Locate_Seg( n );                                /* Get the Segment Pointer */
      i  = Sdrw_Get_Char();
      if (p) DrwGL_Seg_Unit_Transform( p->seg.seg_mat );
        else Draw_Error( "Cannot Reset to Identity the Matrix of Not Existing Segment", (char*)(&n) );
      if (i) bupd = draw_pvw;
      Sdrw_Anim_acq( Drwgl_astpstate );
    break;

    case cd_move_seg:
      n  = Sdrw_Get_Int();
      p  = Draw_Locate_Seg( n );                                /* Get the Segment Pointer */
      x  = Sdrw_Get_Float();
      y  = Sdrw_Get_Float();
      z  = Sdrw_Get_Float();
      if (p) DrwGL_Move_Seg( p->seg.seg_mat, x, y, z );
        else Draw_Error( "Cannot Change(Move) the Matrix of Not Existing Segment", (char*)(&n) );
      bupd = draw_pvw;
      Sdrw_Anim_acq( Drwgl_astpstate );
    break;

    case cd_urotate_seg:
      n  = Sdrw_Get_Int();
      p  = Draw_Locate_Seg( n );                                /* Get the Segment Pointer */
      x  = Sdrw_Get_Float();
      y  = Sdrw_Get_Float();
      z  = Sdrw_Get_Float();
      if (!draw_mat_cnt) { x += orgx; y += orgy; z += orgz; }
      v0 = Sdrw_Get_Float();
      v1 = Sdrw_Get_Float();
      v2 = Sdrw_Get_Float();
      if (p) DrwGL_URot_Seg( p->seg.seg_mat, x, y, z, v0, v1, v2 );
        else Draw_Error( "Cannot Change(Urot) the Matrix of Not Existing Segment", (char*)(&n) );
      bupd = draw_pvw;
      Sdrw_Anim_acq( Drwgl_astpstate );
    break;

    case cd_rotate_seg:
      n  = Sdrw_Get_Int();
      p  = Draw_Locate_Seg( n );                                /* Get the Segment Pointer */
      x  = Sdrw_Get_Float();
      y  = Sdrw_Get_Float();
      z  = Sdrw_Get_Float();
      if (!draw_mat_cnt) { x += orgx; y += orgy; z += orgz; }
      v0 = Sdrw_Get_Float();
      v1 = Sdrw_Get_Float();
      v2 = Sdrw_Get_Float();
      if (p) DrwGL_Rotate_Seg( p->seg.seg_mat, x, y, z, v0, v1, v2 );
        else Draw_Error( "Cannot Change(Rotate) the Matrix of Not Existing Segment", (char*)(&n) );
      bupd = draw_pvw;
      Sdrw_Anim_acq( Drwgl_astpstate );
    break;

    case cd_scale_seg:
      n  = Sdrw_Get_Int();
      p  = Draw_Locate_Seg( n );                                /* Get the Segment Pointer */
      x  = Sdrw_Get_Float();
      y  = Sdrw_Get_Float();
      z  = Sdrw_Get_Float();
      if (!draw_mat_cnt) { x += orgx; y += orgy; z += orgz; }
      x1 = Sdrw_Get_Float();
      y1 = Sdrw_Get_Float();
      z1 = Sdrw_Get_Float();
      if (p) DrwGL_Scale_Seg( p->seg.seg_mat, x, y, z, x1, y1, z1 );
        else Draw_Error( "Cannot Change(Scale) the Matrix of Not Existing Segment", (char*)(&n) );
      bupd = draw_pvw;
      Sdrw_Anim_acq( Drwgl_astpstate );
    break;

    case cd_transform_seg:
      n  = Sdrw_Get_Int();
      p  = Draw_Locate_Seg( n );                                /* Get the Segment Pointer */
      x  = Sdrw_Get_Float();                                    /* Get the Translation */
      y  = Sdrw_Get_Float();
      z  = Sdrw_Get_Float();
      x0 = Sdrw_Get_Float();                                    /* Get the fixed point */
      y0 = Sdrw_Get_Float();
      z0 = Sdrw_Get_Float();
      if (!draw_mat_cnt) { x0 += orgx; y0 += orgy; z0 += orgz; }      
      v0 = Sdrw_Get_Float();                                    /* Get the rotation angles */
      v1 = Sdrw_Get_Float();
      v2 = Sdrw_Get_Float();
      x1 = Sdrw_Get_Float();                                    /* Get the x,y,z Scaling */
      y1 = Sdrw_Get_Float();
      z1 = Sdrw_Get_Float();
      if (p) DrwGL_Transf_Seg( p->seg.seg_mat, x, y, z, x0, y0, z0, v0, v1, v2, x1, y1, z1 );
        else Draw_Error( "Cannot Change(Transform) the Matrix of Not Existing Segment", (char*)(&n) );
      bupd = draw_pvw;
      Sdrw_Anim_acq( Drwgl_astpstate );
    break;

    case cd_get_transf_seg:
      n  = Sdrw_Get_Int();
      p  = Draw_Locate_Seg( n );                                /* Get the Segment Pointer */
      if (p) {
        Sdrw_Put_Int( 12 );
        for (i1 = 0; i1 < 3; i1++ )
          for (i2 = 0; i2 < 4; i2++)
            Sdrw_Put_Float( p->seg.seg_mat[i2*4+i1] );
      } else {
        Draw_Error( "Cannot Get the Matrix of Not Existing Segment", (char*)(&n) );
        Sdrw_Put_Int( -1 );
      }
    break;

    case cd_put_transf_seg:
      n  = Sdrw_Get_Int();
      p  = Draw_Locate_Seg( n );                                /* Get the Segment Pointer */
      if (p) {
        for (i1 = 0; i1 < 3; i1++ )
          for (i2 = 0; i2 < 4; i2++)
            p->seg.seg_mat[i2*4+i1] = Sdrw_Get_Float( );
        Sdrw_Put_Int( 0 );
      } else {
        Draw_Error( "Cannot Put the Matrix of Not Existing Segment", (char*)(&n) );
        Sdrw_Put_Int( -1 );
      }
    break;

    case cd_mat_orient:
    case cd_seg_orient:
    case cd_mat_move:
    case cd_seg_move:
      n = abs( Sdrw_Get_Int() );
      if ((code == cd_mat_orient)||(code == cd_seg_orient)) {
        Drwgl_FixX  = Sdrw_Get_Float();
        Drwgl_FixY  = Sdrw_Get_Float();
        Drwgl_FixZ  = Sdrw_Get_Float();
        if (!draw_mat_cnt) { Drwgl_FixX += orgx; Drwgl_FixY += orgy; Drwgl_FixZ += orgz; }
      }
      i0 = Sdrw_Get_Char();                     /* Get the Immediat Flag */
      if (n > 0) {
        if ((code == cd_mat_orient)||(code == cd_mat_move)) {
          p = Draw_Locate_TMat( n );            /* Get the node pointer */
          if (p) Drwgl_ViewMat = p->tmat.trsf_mat;
            else Drwgl_ViewMat = NULL;
        } else {
          p = Draw_Locate_Seg( n );             /* Get the Segment Matrix Pointer */
          if (p) Drwgl_ViewMat = p->seg.seg_mat;
            else Drwgl_ViewMat = NULL;
        }
      } else Drwgl_ViewMat = NULL;
      if (Drwgl_ViewMat||(code == cd_seg_move)) { /* Segment move can be used on anonymous detectable segment */
        /* if i1 is true, we must generate a user orientation call Here */
        if (i0) {
          switch (code) {
            case cd_mat_move:   Drwgl_Input = drwgl_usr_move; break;
            case cd_seg_move:   Drwgl_Input = (Drwgl_ViewMat)?drwgl_usr_move:drwgl_usr_anmv; break;
            case cd_seg_orient:
            case cd_mat_orient: Drwgl_Input = drwgl_usr_view; break;
            default: ;
          }
          Drwgl_zoomview =  0;
          DrwGL_Inp_Req_Display( &bupd );       /* Send the Request immediatly to GL Server */
        } else {
          switch (code) {
            case cd_mat_move:   Drwgl_viewflg = drwgl_move; break;
            case cd_seg_move:   Drwgl_viewflg = (Drwgl_ViewMat)?drwgl_move:drwgl_anmv; break;
            case cd_seg_orient:
            case cd_mat_orient: Drwgl_viewflg = drwgl_view; break;
            default: ;
          }
          Drwgl_zoomview =  1;
          Sdrw_Put_Int( 0 );
        }
      } else {
        Drwgl_zoomview = 0;                     /* Set implicite Zoom */
        Sdrw_Put_Int( -1 );
      }
    break;

    case cd_new_axis:
      for (i = 0; i < 6; i++) ftb[i] = Sdrw_Get_Float();
      x  = Sdrw_Get_Float();
      y  = Sdrw_Get_Float();
      z  = Sdrw_Get_Float();
      i0 = Sdrw_Get_Int();
      i1 = Sdrw_Get_Int();
      Sdrw_Put_Int( Draw_Gen_Axis( ftb, ftb+3, x, y, z, i0, i1 ) );
    break;

    case cd_new_box:
      for (i = 0; i < 3; i++) ftb[i] = Sdrw_Get_Float();
      i0 = Sdrw_Get_Int();
      i1 = Sdrw_Get_Int();
      i2 = Sdrw_Get_Int();
      n  = Sdrw_Get_Int();
      if (n > 16) n = 16;
      for (i = 0; i < n; i++) itb[i] = Sdrw_Get_Int();
      m = Sdrw_Get_Int();
      if (m > 0) {
        if (m > 48) m = 48;
        for (i = 0; i < m; i++) ftb[i+3] = Sdrw_Get_Float();
        m = Draw_Gen_Box( ftb, i0, i1, i2, n, itb, m, ftb+3 );
      }
      else m = Draw_Gen_Box( ftb, i0, i1, i2, n, itb, 0, NULL );
      Sdrw_Put_Int( m );
    break;

    case cd_easy_box:
      x  = Sdrw_Get_Float();                                    /* Get the lower left corner of Box */
      y  = Sdrw_Get_Float();
      x0 = Sdrw_Get_Float();                                    /* Get the axis sizes */
      y0 = Sdrw_Get_Float();
      for (i = 0; i < 4; i++) ftb[i] = Sdrw_Get_Float();        /* Get XY mini_maxi */
      i0 = Sdrw_Get_String( Drwgl_strmsg, DRWSTRBUF_LENGTH );   /* Get the Units names */
      i1 = Sdrw_Get_String( Drwgl_strdef, DRWSTRBUF_LENGTH );
      m = Sdrw_Get_Int();
      i = Draw_Easy_Box_2D( x, y, x0, y0, ftb, Drwgl_strmsg, Drwgl_strdef, m );
      Sdrw_Put_Int( i );
    break;

    case cd_free_box:
      pb  = Draw_Locate_Box( Sdrw_Get_Int() );                  /* Get the Segment Number */
      m   = Sdrw_Get_Char();
      Draw_Free_Box( pb, m );
      Sdrw_Put_Char( 0 );
    break;

    case cd_free_all_box:
      Draw_Free_Box_List();
      Sdrw_Put_Char( 0 );
    break;

    case cd_set_values:
      i0 = Sdrw_Get_Int();
      i1 = Sdrw_Get_Int();
      Draw_Axis_Setv( Draw_Locate_Axis( i0 ), i1 );
      Sdrw_Put_Char( 0 );
    break;

    case cd_get_values:
      i0 = Sdrw_Get_Int();
      i1 = Sdrw_Get_Int();
      Draw_Axis_Getv( Draw_Locate_Axis( i0 ), i1 );
    break;

    case cd_box_info:
      i0 = Sdrw_Get_Int();                                      /* Get the Box ident */
      i1 = Sdrw_Get_Int();                                      /* Get the Box GEt Key */
      Draw_Box_Getv( Draw_Locate_Box( i0 ), i1 );
    break;

    case cd_plot_axis:
      i0 = Sdrw_Get_Int();
      i1 = Sdrw_Get_Int();
      /* Get the World Axis Origine */
      for (i = 0; i < 3; i++) ftb[i] = Sdrw_Get_Float();
      Draw_Plot_Axis( Draw_Locate_Axis( i0 ), ftb, i1, NULL );
      bupd = draw_pvw;
      Sdrw_Anim_acq( Drwgl_astpstate );
    break;

    case cd_plot_box:
      i0 = Sdrw_Get_Int();                                      /* Get the Box ident */
      Draw_Plot_Box( Draw_Locate_Box( i0 ) );
      bupd = draw_pvw;
      Sdrw_Anim_acq( Drwgl_astpstate );
    break;

    case cd_open_box:
      pb  = Draw_Locate_Box( Sdrw_Get_Int() );                  /* Get the Box Reference */
      Draw_Open_Box( pb );
      Sdrw_Put_Char( 0 );
    break;

    case cd_close_box:
      Draw_Close_Box();
      Sdrw_Put_Char( 0 );
    break;

    case cd_box_update:
      pb  = Draw_Locate_Box( Sdrw_Get_Int() );                  /* Get the Box Reference */
      Draw_Update_Box( pb );
    break;

    case cd_cm_to_box:
      if (Draw_Opened_Box) {
        x = Sdrw_Get_Float() + orgx;
        y = Sdrw_Get_Float() + orgy;
        z = Sdrw_Get_Float() + orgz;
        Draw_UnScale( ftb, ftb+1, ftb+2, x, y, z );
        Sdrw_Put_Int( 0 );
        Sdrw_Put_Float( ftb[0] );
        Sdrw_Put_Float( ftb[1] );
        Sdrw_Put_Float( ftb[2] );
      }
      else  Sdrw_Put_Int( -1 );
    break;


    case cd_box_to_cm:
      if (Draw_Opened_Box) {
        x = Sdrw_Get_Float();
        y = Sdrw_Get_Float();
        z = Sdrw_Get_Float();
        Draw_Scale3( x, y, z, ftb, 0 );
        Sdrw_Put_Int( 0 );
        Sdrw_Put_Float( ftb[0] - orgx );
        Sdrw_Put_Float( ftb[1] - orgy );
        Sdrw_Put_Float( ftb[2] - orgz );
      }
      else  Sdrw_Put_Int( -1 );
    break;

    case cd_continue:
      /* Send a 2D/3D Plot Data block to Client */
      Draw_Send_Points( Sdrw_Get_Char() );
    break;

    case cd_text_display:                                       /* Get the string to display */
    case cd_message:
      Sdrw_Get_String( Drwgl_strmsg, DRWSTRBUF_LENGTH );        /* Set the Message String */
      if (code == cd_message) Drwgl_Input = drwgl_message;      /* Set The Request Kind */
                         else Drwgl_Input = drwgl_dsplmsg;
      DrwGL_Inp_Req_Display( &bupd );                           /* Send the Request to FLTK-GL */
      Sdrw_Put_Int( 1 );                                        /* Return the success status */
    break;

       Sdrw_Get_String( Drwgl_strmsg, DRWSTRBUF_LENGTH );
      Sdrw_Put_Char( 0 );
    break;

    case cd_get_choice:
      n = Sdrw_Get_Int();                                       /* Get the number of menu entries */
      if ((n < 1)||(n > Menu_Max))
      {
        Sdrw_Put_Int( -2 );
        break;
      }
      Sdrw_Get_String( Drwgl_strmsg, DRWSTRBUF_LENGTH );        /* Get the menu title */
      menu_tops = 0;
/*    fprintf( fmsg, " *** Get Choice Request \"%s\".\n", Drwgl_strmsg );
      fflush( fmsg ); */
      for (menu_topn = 0; menu_topn < n; menu_topn++) {         /* Loop one all menu entries */
        menu[menu_topn] = menu_buf+menu_tops;                   /* Set the menu entry address */
        len = Sdrw_Get_Char();                                  /* Get the menu entry string size */
        for (i=0;i<len;i++)                                     /* loop on all menu entry characters */
          if (i<Menu_ItmSz)                                     /* Copy the character as possible */
            menu_buf[menu_tops++] = Sdrw_Get_Char();            /* On overflow we troncate the entry label */
        menu_buf[menu_tops++] = 0;                              /* append the null character */
/*      fprintf( fmsg, " Choice %2d / \"%s\"\n", menu_buf[menu_tops-1] );
        fflush( fmsg ); */
      }
      menu[n] = NULL;                                           /* Append NULL after the last menu entry */
      Drwgl_strtab = menu;
      Drwgl_Input = drwgl_choice;                               /* Set The Request Kind */
      _Inp_Req_Display( &bupd );                                /* Send the Request to FLTK-GL */
    break;

    case cd_get_answerd:
      Sdrw_Get_String( Drwgl_strmsg, DRWSTRBUF_LENGTH );
      Drwgl_Input = drwgl_answerd;                              /* Set The Request Kind */
      _Inp_Req_Display( &bupd );                                /* Send the Request to FLTK-GL */
    break;

    case cd_get_string:
      i = Sdrw_Get_String( Drwgl_strmsg, DRWSTRBUF_LENGTH );
      n = Sdrw_Get_String( Drwgl_strdef, DRWSTRBUF_LENGTH );
      Drwgl_strcap = Sdrw_Get_Char();
      Drwgl_Input = drwgl_string;                               /* Set The Request Kind */
      _Inp_Req_Display( &bupd );                                /* Send the Request to FLTK-GL */
    break;

    case cd_get_string_box:
      Drwgl_ifont   =   Sdrw_Get_Int();                          /* Get the font number */
      Drwgl_valdef  = Sdrw_Get_Float();                          /* Get the character height */
      Drwgl_gptmax  = Sdrw_Get_String( Drwgl_strdef, DRWSTRBUF_LENGTH ); /* Get the string */
      Drwgl_srvcall = DRWGL_GET_BOXSZ;                           /* Select the service number */
      _Srv_Call_Request;                                         /* Send the Request to FLTK-GL */
//    bupd = 1;
//    _Inp_Req_Display( &bupd );
    break;

    case cd_get_file:
/*    fprintf( fmsg, " *** Get File Request 0.\n" );
      fflush( fmsg ); */
      Drwgl_newmd = Sdrw_Get_Char();                            /* Get the Create New File Flag */
      n = Sdrw_Get_Char();                                      /* Get number of filter entries */
      Sdrw_Get_String( Drwgl_strmsg, DRWSTRBUF_LENGTH );        /* Get the Title */
      menu_tops = 0;

      for (menu_topn = 0; menu_topn < n; menu_topn++) {         /* Loop one all filter entries */
        menu[menu_topn] = menu_buf+menu_tops;                   /* Set the menu entry address */
        len = Sdrw_Get_Char();                                  /* Get the filter element string size */
        for (i=0;i<len;i++)                                     /* loop on all filter entry characters */
          if (i<Menu_ItmSz)                                     /* Copy the character as possible */
            menu_buf[menu_tops++] = Sdrw_Get_Char();            /* On overflow we troncate the entry label */
        menu_buf[menu_tops++] = '\t';                           /* Append the FLTK filter entry separator */
/*      fprintf( fmsg, " Choice %2d / \"%s\"\n", menu_buf[menu_tops-1] );
        fflush( fmsg ); */
      }
      menu_buf[menu_tops-1] = 0;                                /* Set the final string null character */
      menu[n] = NULL;
/*    fprintf( fmsg, " *** Get File Request 2.\n" );
      fflush( fmsg ); */
      Drwgl_strtab = menu;
      Drwgl_fidx = Sdrw_Get_Char();                             /* Get the filter index */
      Sdrw_Get_String( Drwgl_strdef, DRWSTRBUF_LENGTH );        /* Get the Default file spc. */
      Drwgl_strcap = Sdrw_Get_Char();                           /* ... and the target string capacity */
      Drwgl_Input = drwgl_file;                                 /* Set The Request Kind */
/*    fprintf( fmsg, " *** Get File Request.\n" );
     fflush( fmsg ); */
      _Inp_Req_Display( &bupd );                                /* Send the Request to FLTK-GL */
    break;

    case cd_get_color:
      Sdrw_Get_String( Drwgl_strmsg, DRWSTRBUF_LENGTH );        /* Get the request title */
      Drwgl_Rcolor = Sdrw_Get_Float();                          /* Get the default color */
      Drwgl_Gcolor = Sdrw_Get_Float();
      Drwgl_Bcolor = Sdrw_Get_Float();
      Drwgl_Input = drwgl_color;
      _Inp_Req_Display( &bupd );                                /* Send the Request to FLTK-GL */
    break;

    case cd_get_position:
      Drwgl_Input = drwgl_position;                             /* Set The Request Kind */
      _Inp_Req_Display( &bupd );                                /* Send the Request to GL Server */
    break;

    case cd_get_window:
      Drwgl_Input = drwgl_window;                               /* Set The Request Kind */
      _Inp_Req_Display( &bupd );                                /* Send the Request to GL Server */
    break;

    case cd_get_value:
      Sdrw_Get_String( Drwgl_strmsg, DRWSTRBUF_LENGTH );
      Drwgl_valdef = Sdrw_Get_Float();
      Drwgl_valmin = Sdrw_Get_Float();
      Drwgl_valmax = Sdrw_Get_Float();
      Drwgl_Input  = drwgl_value;                               /* Set The Request Kind */
      _Inp_Req_Display( &bupd );                                /* Send the Request to GL server */
    break;

    case cd_get_stroke:
    case cd_get_line:
      Drwgl_gptmax = Sdrw_Get_Int();                            /* Get Application Capacity */
      Drwgl_gptins = Sdrw_Get_Char();                           /* Get the Plot insertion flag */
      Drwgl_gptcnt = 0;
      if (code == cd_get_line)                                  /* Set The Request Kind */
        Drwgl_Input  = drwgl_line;
      else
        Drwgl_Input  = drwgl_stroke;
/*    fprintf( fmsg, " => Enter in Get_Line/Stroke_Req.\n" );
      fflush( fmsg ); */
      _Inp_Req_Display( &bupd );                                /* Send the Request to GL server */
    break;

    case cd_echo_get_pos:
      Drwgl_egpos_pcurs = Sdrw_Get_Int();
      Sdrw_Put_Char( 0 );
    break;

    case cd_echo_get_line:
      Drwgl_eglin_col = Sdrw_Get_Int();
      Drwgl_eglin_mod = Sdrw_Get_Int();
      Drwgl_eglin_knd = Sdrw_Get_Int();
      Drwgl_eglin_siz = Sdrw_Get_Float();
      Sdrw_Put_Char( 0 );
    break;

    case cd_seg_pick:
      Drwgl_segment = Sdrw_Get_Int();
      Drwgl_ident   = Sdrw_Get_Int();
      Drwgl_Input   = drwgl_pick;                               /* Set The Request Kind */
      _Inp_Req_Display( &bupd );                                /* Send the Request to GL Server */
    break;

    case cd_pannel_attr:
    case cd_pannel_create:                                      /* Define a setup panel of values */
    case cd_pannel_add:
    case cd_pannel_enadis:
    case cd_pannel_change:
    case cd_pannel_open:
    case cd_pannel_close:
    case cd_pannel_put:                                         /* User progr. Put_to/Set_in the pannel values of Draw Server */
    case cd_pannel_get:                                         /* User progr. Get the pannel values from the Draw server */
    case cd_pannel_del:
      Drwgl_ident = code;                                       /* Set the pannel relative code */
      Drwgl_Input = drwgl_pannelreq;                            /* Set The Request Kind */
//    DrwGL_Inp_Req_Display( &bupd );                           /* Send the Request to GL Server */
      _Inp_Req_Display( &bupd );                                /* Send the Request to GL Server */
    break;

    case cd_pannel_req:
      Drwgl_ident = code;                                       /* Set the pannel relative code */
      Drwgl_Input = drwgl_pannelreq;                            /* Set The Request Kind */
      _Inp_Req_Display( &bupd );                                /* Send the Request to GL Server */
    break;

    case cd_dialog:
/*    fprintf( fmsg, " => Enter in Dialog_Req.\n" );
      fflush( fmsg ); */
      /* draw__dialog(); */
      Drwgl_exitmd  = Sdrw_Get_Int();                           /* Get the Dialog Flag Word */
      Drwgl_Dstatus = 0;                                        /* Set the Initial Dialog Status */
      Drwgl_Input   = drwgl_dialog;                             /* Set The Request Kind */
      DrwGL_Inp_Req_Display( &bupd );                           /* Send the Request to GL Server */
      Sdrw_Put_Int( Drwgl_Dstatus );                            /* Return the account code to client */
      Sdrw_Put_Int( Drwgl_PanChg );                             /* Return the Last Changed Pannel # or 0 */
    break;

    case cd_zoom:
      Drwgl_Input = drwgl_usr_zoom;                             /* Set The Request Kind */
/*    fprintf( fmsg, " => Enter in Zoom_Req.\n" );
      fflush( fmsg ); */
      _Inp_Req_Display( &bupd );                                /* Send the Request to GL Server */
    break;

    case cd_scale:
      Drwgl_Input = drwgl_usr_scale;                            /* Set The Request Kind */
/*    fprintf( fmsg, " => Enter in Zoom_Req.\n" );
      fflush( fmsg ); */
      _Inp_Req_Display( &bupd );                                /* Send the Request to GL server */
    break;

    case cd_reload:
      Drwgl_Input = drwgl_reload;                               /* Set The Request Kind */
/*    fprintf( fmsg, " => Enter in Zoom_Req.\n" );
      fflush( fmsg ); */
      _Inp_Req_Display( &bupd );                                /* Send the Request to GL Server */
    break;

    case cd_refresh:
      Drwgl_Input = drwgl_refresh;                              /* Set The Request Kind */
/*    fprintf( fmsg, " => Enter in Zoom_Req.\n" );
      fflush( fmsg ); */
      _Inp_Req_Display( &bupd );                                /* Send the Request to GL Server */
    break;

    case cd_grid:
      Drwgl_Input = drwgl_usr_grid;                             /* Set The Request Kind */
/*    fprintf( fmsg, " => Enter in Zoom_Req.\n" );
      fflush( fmsg ); */
      _Inp_Req_Display( &bupd );                                /* Send the Request to GL Server */
    break;

    case cd_print:
      Drwgl_Input = drwgl_usr_print;                            /* Set The Request Kind */
/*    fprintf( fmsg, " => Enter in Zoom_Req.\n" );
      fflush( fmsg ); */
      _Inp_Req_Display( &bupd );                                /* Send the Request to GL Server */
    break;

    default:
      /* Normal Draw_End and Illegal or Unsupported Draw Code */
      i0 = (code == cd_end)?-1:-2;
      Draw_End();                                               /* Close All Draw Display. */
      Sdrw_Put_Int( i0 + 1 );                                   /* Return the account code to client */
      Sdrw_Write();
      Sdrw_Close_Gate();                                        /* Used for debug in reverse mode. */
//    fprintf( fmsg, " Close Gate OK.\n" );
//    fflush( fmsg );
      /* Return the value -1 on Normal Draw_End call and ... */
      /* ... -2 on ERROR Draw_End call. */
      reqnxt = i0;
      goto Sequence_Exit;
    }

    DrwSrv_Unlock();                                            /* Unlock the User Directive Execution Graph. */

Sequence_Continue:
    if (bupd) DrwGL_Update_Display();
    Sdrw_Write();                                               /* Write the answerd to the user. */
    reqnxt = 0;                                                 /* Return to continue pipe input. */
  }

Sequence_Exit:                                                  /* Exit form proceed routine. */
  DrwSrv_Unlock();                                              /* UnLock the User Directive Execution Graph. */
  DrwSrv_Exit( 0 );
  return NULL;                                                  /* Requested by pthread management. */
}
