// ****************************************************************************
// *                                                                          *
// *                                                                          *
// *                                                                          *
// *            F L T K / D R A W   -   S E R V E R   M O D U L E             *
// *                                                                          *
// *              Version  1.4-C for Draw Library Level V 2.4 A               *
// *                                                                          *
// *        (Draw interface for FLTK/OPENGL function and procedures)          *
// *                                                                          *
// *                                                                          *
// *                  (to manage the FLTK/OPENGL Interface)                   *
// *                                                                          *
// *                                                                          *
// *                                  by                                      *
// *                                                                          *
// *            Pierre Wolfers, Laboratoire de Cristallographie               *
// *                                                                          *
// *            CNRS GRENOBLE,  25 Avenue des Martyrs, B.P. 166               *
// *                                                                          *
// *                       F 38042 GRENOBLE CEDEX 9                           *
// *                                                                          *
// *                             F R A N C E                                  *
// *                                                                          *
// *                                                                          *
// *                                                                          *
// ****************************************************************************

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////


//
// Routine to get a Double value by using a FLTK ValueSlider in a child window.
//

#include <stdio.h>

#include <fltk/Window.h>
#include <fltk/ValueSlider.h>
#include <fltk/ReturnButton.h>
#include <fltk/Item.h>
#include <fltk/MenuBar.h>
#include <fltk/FileChooser.h>
#include <fltk/FileIcon.h>
#include <fltk/SharedImage.h>
#include <fltk/pnmImage.h>
#include <fltk/ColorChooser.h>

#include <fltk/file_chooser.h>

#include "Server_DrawGL.h"



#define W_WIDTH 100
#define W_HIGH  470
#define V_X      25
#define V_Y      25
#define V_WIDTH  50
#define V_HIGH  400
#define V_LABSZ  16
#define V_LINESZ  2
#define B_X      10
#define B_Y     430
#define B_WIDTH  80
#define B_HIGH   30
#define B_LABSZ  20




using namespace fltk;




static double vdef;
static int  instat,
            inslct;

static int  chkflg = 0;



static Window *wind = (Window *)0;
static ValueSlider *valu = (ValueSlider*)0;

// static FileChooser *flch;



SharedImage	*pdf_check(const char *, uchar *, int);
SharedImage	*ps_check(const char *, uchar *, int);



static void cb_win( Window*, void* )
{
  wind->make_exec_return( 0 );
}

static void cb_OK_GetVal( ReturnButton* btn, void* )
{
  vdef = valu->value();
  wind->make_exec_return( 1 );
}

int Draw_GetVal( const double min, const double max, const double stp,
                 double& def, const char* name, const int lgflg )
{ Group* saved_context = Group::current();
  load_theme();
  Window win( W_WIDTH, W_HIGH );
  wind = &win;
  vdef = def;
  win.callback( (Callback*)cb_win );

  win.begin();
    ValueSlider val( V_X, V_Y, V_WIDTH, V_HIGH );
    valu = &val;
    val.type(ValueSlider::TICK_BOTH);
    val.set_vertical();
    val.labeltype( EMBOSSED_LABEL );
    val.labelsize( V_LABSZ );
    val.label( name );
    val.step( stp );
    val.range( min, max );
    val.linesize( V_LINESZ );
    val.value( vdef );
    val.align( ALIGN_TOP );
    val.when( WHEN_CHANGED );

    if (lgflg) val.type(ValueSlider::LOG|Slider::TICK_BOTH);
  win.end();
  win.layout();

  win.begin();


  ReturnButton btn( B_X, B_Y, B_WIDTH, B_HIGH, "OK" );
    btn.labelsize( B_LABSZ );
    btn.shortcut(0xff0d);
    btn.callback( (Callback*)cb_OK_GetVal );

  win.end();
  win.layout();

//win.show();
  instat = win.exec();
  Group::current( saved_context );
  def = vdef;
  return instat;
}



static void cb_OK_GetChoice( Window* w, void* dat )
{
  inslct = *((int*)dat);
  wind->make_exec_return( 1 );
}






int Draw_GetChoice( const char* title, char** menu )
{ Group* saved_context = Group::current();
  Item*     itm;
  int  ncp =  0;
  int  ww  =  0;
  int  wh  =  0;
  int   tab[32];

  instat = 0;
  Window win( 100, 300 );
  wind = &win;
  win.callback( (Callback*)cb_win );
  win.begin();
    Widget  box( 0,  0, 100, 20, title );
    box.labelfont( HELVETICA_BOLD_ITALIC ); 
    box.box( UP_BOX );
    box.labelsize( 12 );
    box.measure_label( ww, wh );
    ww += 5; wh += 10;
    box.h( wh );
    MenuBar itg( 0, wh, 100, 300 );
    itg.set_vertical();
    itg.begin();
      while (menu[ncp]&&(ncp <32)) {
        itm = new Item( menu[ncp], 0, (Callback*)cb_OK_GetChoice, (void*)&(tab[ncp]), 0 );
        itm->layout();
        if (itm->w()>ww) ww = itm->w();
        wh += itm->h();
        tab[ncp] = ncp + 1;
        ncp++;
      }
    itg.end();
    itg.w( ww );                        // Set the correct size of the menu.
    itg.h( wh );
    box.w( ww ); 
  win.end();
  win.w( ww );                          // Set the correct size of the window.
  win.h( wh );
  if (win.exec()) instat = inslct;      // Execute the Menu request.
  Group::current( saved_context );      // Restore the original FLTK Context.
  return instat;
}






////////////////////////////////////////////////////////////////
//                                                            //
//       The next routine are take or inspired from the       //
//       "test/file_chooser;cxx" FLTK test program that       //
//       is a part of the FLTK distribution kit.              //
//                                                            //
////////////////////////////////////////////////////////////////


//
// 'pdf_check()' - Check for and load the first page of a PDF file.
//

SharedImage *                                   // O - Page image or NULL
                pdf_check( const char *name,    // I - Name of file
                           uchar      *header,  // I - Header data
                           int        headerlen)// I - Length of header data
{
  const char    *home;                          // Home directory
  char          preview[1024],                  // Preview filename
                command[1024];                  // Command


  if (memcmp( header, "%PDF", 4 ) != 0)
    return 0;

  home = getenv( "HOME" );
  sprintf( preview, "%s/.preview.ppm", home ? home : "" );

  sprintf( command,
           "gs -r100 -dFIXED -sDEVICE=ppmraw -dQUIET -dNOPAUSE -dBATCH "
           "-sstdout=\"%%stderr\" -sOUTPUTFILE=\'%s\' "
           "-dFirstPage=1 -dLastPage=1 \'%s\' 2>/dev/null", preview, name );

  if (system( command )) return 0;

  return new pnmImage( preview );
}



//
// 'ps_check()' - Check for and load the first page of a PostScript file.
//

SharedImage *                                   // O - Page image or NULL
                ps_check( const char *name,     // I - Name of file
                          uchar      *header,   // I - Header data
                          int        headerlen) // I - Length of header data
{
  const char    *home;                          // Home directory
  char          preview[1024],                  // Preview filename
                outname[1024],                  // Preview PS file
                command[1024];                  // Command
  FILE          *in,                            // Input file
                *out;                           // Output file
  int           page;                           // Current page
  char          line[256];                      // Line from file


  if (memcmp( header, "%!", 2 ) != 0) return 0;

  home = getenv( "HOME" );
  sprintf( preview, "%s/.preview.ppm", home ? home : "" );

  if (memcmp( header, "%!PS", 4 ) == 0) {
    // PS file has DSC comments; extract the first page...
    sprintf( outname, "%s/.preview.ps", home ? home : "");

    if (strcmp( name, outname ) != 0) {
      in   = fopen( name, "rb" );
      out  = fopen( outname, "wb" );
      page = 0;

      while (fgets( line, sizeof( line ), in ) != NULL) {
        if (strncmp( line, "%%Page:", 7 ) == 0) {
          page ++;
          if (page > 1) break;
        }
        fputs( line, out );
      }

      fclose( in );
      fclose( out );
    }
  } else {
    // PS file doesn't have DSC comments; do the whole file...
    strncpy( outname, name, sizeof( outname ) - 1 );
    outname[sizeof(outname) - 1] = '\0';
  }

  sprintf( command,
           "gs -r100 -dFIXED -sDEVICE=ppmraw -dQUIET -dNOPAUSE -dBATCH "
           "-sstdout=\"%%stderr\" -sOUTPUTFILE=\'%s\' \'%s\' 2>/dev/null",
           preview, outname );

  if (system(command)) return 0;

  return new pnmImage( preview );
}



//
//    Routine to Request the User by using a FLTK File Chooser Widget.
//
char* Draw_GetFile( const char* title,  // Request title.
                    const char* filter, // File Filter list ("\t" is the separator).
                    const char* def,    // Default File selection.
                    const int   mod,    // Request mode .
                          int&  fidx )  // File index used (output parameter).
{
  char* rep;

//switch (Drwgl_newmd) {
//  case 1:  mod = CREATE; break;
//  case 2:  mod = DIRECTORY; break;
//  default: mod = SINGLE;
//}
// The first menu entry is the complete string of filter (separate by '\t' character in FLTK).
// The Drwgl_fidx parameter is not used -- in this FLTK server first version.
//      fltk::file_chooser_callback( cb_get_file );

  if (!chkflg) { // Install the pdf and ps file checker }
    FileIcon::load_system_icons();
    SharedImage::add_handler( pdf_check );
    SharedImage::add_handler(  ps_check );
    chkflg = 1;
  }

  rep = (char*)fltk::file_chooser( title, filter, def );
  return rep;
}




//
//  Routine to Request the User to get a color selection.
//
int Draw_Get_Color( const char* str, float& r, float& g, float& b )
{
  if (fltk::color_chooser( str, r, g, b )) return  1;
                                      else return -1;
}


