/************************************************************************
*                                                                       *
*                                                                       *
*          F L T K / D R A W   -   S E R V E R   M O D U L E            *
*                                                                       *
*           Version  1.4-C for Draw Library Level V 2.4 A               *
*                                                                       *
*      (Draw interface for FLTK/OPENGL function and procedures)         *
*                                                                       *
*                                                                       *
*              (Environment/Header File for DRAW Library)               *
*                                                                       *
*                                                                       *
*                               by                                      *
*                                                                       *
*          Pierre Wolfers, Laboratoire de Cristallographie              *
*                                                                       *
*          CNRS GRENOBLE,  25 Avenue des Martyrs, B.P. 166              *
*                                                                       *
*                     F 38042 GRENOBLE CEDEX 9                          *
*                                                                       *
*                           F R A N C E                                 *
*                                                                       *
*                                                                       *
*                                                                       *
************************************************************************/


/*///////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
///////////////////////////////////////////////////////////////////////*/




#ifndef _SRV_ENV                                /* To avoid Multi-definitions */
#  define _SRV_ENV    0



/***********************************************************************/
/**                                                                   **/
/**           C O N S T A N T E S    D E F I N I T I O N S            **/
/**                                                                   **/
/***********************************************************************/




/* Reference all the external common objects created by server_gbldef.c */

/* Include the type definitions */


#  include <stdio.h>
#  include <math.h>
#  include <string.h>
#  include <stdlib.h>

#  include <draw/draw_constantes.h>


// OpenGL/FLTK stuff here
#include <fltk/gl.h>
#include <GL/glu.h>



#define DRWSEG_VISIBLE      1
#define DRWSEG_DETECT       2
#define DRWSEG_HLIGHT       4

#define DRWSEG_SYSTEM    1024

#define DRW_POINTS          0  /* Plot Single Dots */
#define DRW_LINES           1  /* Plot Single Lines */
#define DRW_LINE_STRIP      2  /* Plot a Poly_Line */
#define DRW_LINE_LOOP       3  /* Plot a Loop Poly_line */
#define DRW_TRIANGLES       4  /* Plot Single Triangles */
#define DRW_TRIANGLE_STRIP  5  /* Plot a Rubber of triangles */
#define DRW_TRIANGLE_FAN    6  /* Plot a Fan of Triangles */
#define DRW_QUADS           7  /* Plot Single Quads */
#define DRW_QUAD_STRIP      8  /* Plot a Rubber of Quads */
#define DRW_POLYGON         9  /* Plot a Contour with Fill Area */
#define DRW_MARKERS        10  /* Plot Markers */

#define word  short            /* MACHINE DEPENDENT */

/* Define the various styles of Font (in agreement with FTGL library) */

#define FTGL_BITMAP         1
#define FTGL_PIXMAP         2
#define FTGL_OUTLINE        3
#define FTGL_POLYGON        4
#define FTGL_EXTRUDE        5
#define FTGL_TEXTURE        6

/* Define the default style of font */

#define FTGL_DEF_STYLE FTGL_POLYGON

/* Define the path and alignement value for string formating */

# define TXT_PATH_RIGHT     1
# define TXT_PATH_LEFT      2
# define TXT_PATH_UP        3
# define TXT_PATH_DOWN      4

# define TXT_HALN_NORMAL    1
# define TXT_HALN_LEFT      2
# define TXT_HALN_CENTRE    3
# define TXT_HALN_RIGHT     4
# define TXT_HALN_JUSTIFY   5

# define TXT_VALN_NORMAL    1
# define TXT_VALN_TOP       2
# define TXT_VALN_CAP       3
# define TXT_VALN_HALF      4
# define TXT_VALN_BASE      5
# define TXT_VALN_BOTTOM    6

#define SIZE_DEF_FONT       8  /* Number of Default font table */



/***********************************************************************/
/**                                                                   **/
/**                T Y P E S    D E F I N I T I O N S                 **/
/**                                                                   **/
/***********************************************************************/


typedef unsigned char             Char;         /* UNsigned char named Char */


typedef struct q_req {                          /* Queued Request Definition */
                        struct q_req *next;     /* Pointer to next queued request */
                        int         length;     /* Length of the request */
                        Char*      request;     /* binary Request string */
                     } Draw_Q_Request;



typedef enum    {       raster,
                        centimeter }    unt_ty; /* Selected unit capacity */



/* Draw Object Definitions */

typedef enum    {       Draw_Segment,           /*  0 Segment Head */
                        Draw_Plot,              /*  1 Polyline/Polymarker/Polygone/...Directives */
                        Draw_Text,              /*  2 Text Directive */
                        Draw_TBox,              /*  3 Text in Box Directive  */
                        Draw_Circle,            /*  4 To Plot a Circle */
                        Draw_Sphere,            /*  5 To Plot a Sphere */
                        Draw_Cylinder,          /*  6 To Plot a Cylinder */
                        Draw_Disk,              /*  7 To Plot a Disk */
                        Draw_Line_Attr,         /*  8 To set the Line Attributes */
                        Draw_Marker_Attr,       /*  9 To set the Marker Attributes */
                        Draw_Fill_Attr,         /* 10 To set the Fill Area Attributes */
                        Draw_Text_Attr,         /* 11 To set the Text Attributes */
                        Draw_Font,              /* 12 To select a Font */
                        Draw_Color,             /* 13 To set the Current Color */
                        Draw_PP_Attr,           /* 14 To Push or Pop Current attributes */
                        Draw_Ena_Plane,         /* 15 To Enable a Plot plane */
                        Draw_Dis_Plane,         /* 16 To Disable a Plot Plane */
                        Draw_Box_Ref,           /* 17 To set a Box reference */
                        Draw_Box_Pop,           /* 18 To Pop a Box reference */
                        Draw_Exec_Seg,          /* 19 To Exec a previously defined segment */
                        Draw_PushTrfMat,        /* 20 To Push a Transformation Matrix */
                        Draw_PopTrfMat,         /* 21 To Pop Transformation Matrix */
                        Draw_Blend_Set,         /* 22 Blending Setting Node */
                        Draw_Light_Def,         /* 23 Light Definition/prop. Node */
                        Draw_Mat_Light_Prop,    /* 24 Materials Light Prop. */
                        Draw_Light_OnOff        /* 25 Lighting set on/off */
               } Draw_Dir_Types;


typedef GLfloat          Draw_Point[2];         /* 2D Point/Vertex */

typedef GLfloat         Draw_Point3[3];         /* 3D Point/Vertex */

typedef GLfloat           Draw_RGBA[4];         /* Color in RGBA */

typedef union Draw_Dir *      Draw_Ptr;         /* Define a pointer to a Draw Directive */


typedef struct { /* Draw Directive Common */
                 Draw_Ptr          dir_nxt,     /* Link to next Directive of the same level */
                                   dir_prv;     /* Link to previous directive */
                 Draw_Dir_Types    dir_knd;     /* Directive Kind */
                 int               dir_pid;     /* Current pick identifier */
               } Dir_Common;


typedef struct { /* Draw Segment Drawing Directive */
                 Dir_Common           dcom;     /* Common Directive Part */
                 int               seg_ide,     /* Segment Identifier Number */
                                  seg_stat;     /* Segment Status */
                 Draw_Ptr         seg_fdir,     /* Link to first Directive of the segment */
                                  seg_ldir,     /* Link to last Directive of the Segment */
                                   seg_ref,     /* Link to segment reference list */
                                   seg_prv,     /* Link to previous segment */
                                   seg_nxt;     /* Link to next segment */
                 GLfloat       seg_mat[16],     /* Segment Transformation Matrix */
                                   seg_pri;     /* Segment priority */
               } Draw_Segm_Dir;

typedef struct { /* Draw General Plot Directive (PolyLine/PolyMarker/Fill_Area/...) */
                 Dir_Common           dcom;     /* Common Directive Part */
                 char              plo_knd,     /* Type of plot Line/Marker/Fill... */
                                   plo_flg;     /* Bit flags */
                 short unsigned    plo_cap;     /* Actual capacity (used for progressive plot) */
                 int               plo_npt;     /* Number of point to plot */
                 float     *       plo_tab;     /* The List of Point (in World Coordinates) */
                 void      *       plo_box;     /* Link to related box reference (for curve/surface) in box */
               } Draw_Plot_Dir;

typedef struct { /* Draw String Directive */
                 Dir_Common           dcom;     /* Common Directive Part */
                 float               txt_x,     /* Coordinate of the text. */
                                     txt_y,
                                  txt_high,     /* High of character */
                                   txt_ang;     /* Angle of the line */
                 int               txt_len;     /* Size of the string */
                 char *            txt_str;     /* String to plot */
               } Draw_Text_Dir;

typedef struct { /* Draw Text in Box Directive */
                 Dir_Common           dcom;     /* Common Directive Part */
                 float               txb_x,     /* Coordinate of the text box. */
                                     txb_y,
                                   txb_box,     /* Box Line length */
                                   txb_boy,
                                  txb_high,     /* Height of character */
                                  txb_lnsz;     /* Line Spacing */
                 int               txb_hal,     /* Horizontal Alignement for text inside */
                                   txb_len;     /* Size of the string */
                 char *            txb_txt;     /* Text to plot */
               } Draw_TBox_Dir;

typedef struct { /* Draw Circle Directive */
                 Dir_Common           dcom;     /* Common Directive Part */
                 float             circl_x,     /* Position of Circle Centre */
                                   circl_y,
                                   circl_r,     /* Radius of circle */
                                  circl_sa,     /* Start Circle Arc angle */
                                  circl_ea,     /* End Arc Circle Angle */
                                  circl_ac;     /* Accuracy */
                 int              circl_li;     /* Related Circle GL List */
                 char             circl_kn;     /* type of plot Line/Marker/Fill... */
               } Draw_Circle_Dir;

typedef struct { /* Draw Sphere Directive */
                 Dir_Common           dcom;     /* Common Directive Part */
                 float            sphere_x,     /* Position of Circle Centre */
                                  sphere_y,
                                  sphere_z,
                                  sphere_r;     /* Radius of sphere */
                 int             sphere_px,     /* Sphere Accuracy longitude */
                                 sphere_pz,     /* Sphere Accuracy latitude */
                                 sphere_li;     /* Related Sphere GL List */
                 char             sphere_k;     /* Type of plot Line/Fill/With_Normal... */
               } Draw_Sphere_Dir;

typedef struct { /* Draw Cylinder Directive */
                 Dir_Common           dcom;     /* Common Directive Part */
                 float               cyl_x,     /* Position Of Base centre of cylinder */
                                     cyl_y,
                                     cyl_z,
                                    cyl_th,     /* Spherical orientation of cylinder axis */
                                    cyl_ph,
                                    cyl_lg,     /* Cylinder Length */
                                    cyl_rb,     /* Radius of base */
                                    cyl_rt;     /* Radius of top */
                 int                cyl_px,     /* Cylinder Accuracy longitude */
                                    cyl_pz,     /* Cylinder Accuracy latitude(z) */
                                    cyl_li;     /* Related Cylinder GL List */
                 char                cyl_k;     /* Type of plot Line/Fill/With_Normal... */
               } Draw_Cylinder_Dir;

typedef struct { /* Draw Disk Directive */
                 Dir_Common           dcom;     /* Common Directive Part */
                 float               dsk_x,     /* Position Of Disk centre */
                                     dsk_y,
                                     dsk_z,
                                    dsk_th,     /* Spherical orientation of disk axis */
                                    dsk_ph,
                                    dsk_ri,     /* Internal Disk Radius */
                                    dsk_re,     /* External Disk Radius */
                                    dsk_sa,     /* Start angle for part of disk */
                                    dsk_ea;     /* Stop angle or <= 0.0 (Complet disk) */
                 int                dsk_pt,     /* Disk Accuracy (as part of cake) */
                                    dsk_pr,     /* Disk Accuracy (along the radius) */
                                    dsk_li;     /* Related disk GL List */
                 char                dsk_k;     /* Type of plot Line/Fill/With_Normal... */
               } Draw_Disk_Dir;

typedef struct { /* Draw Line Attributes Directive */
                 Dir_Common           dcom;     /* Common Directive Part */
                 int             plia_kind;     /* Kind of line and related ... */
                 float           plia_size;     /* Thickness of line */
               } Draw_LAttr_Dir;

typedef struct { /* Draw Marker Attributes Directive */
                 Dir_Common           dcom;     /* Common Directive Part */
                 int             mrka_kind;     /* Kind of marker */
                 float           mrka_size;     /* Size of marker */
               } Draw_MAttr_Dir;

typedef struct { /* Draw Fill Attributes Directive */
                 Dir_Common           dcom;     /* Common Directive Part */
                 int             fila_kind,     /* Kind of fill area */
                                 fila_styl;     /* Style of fill area */
               } Draw_FAttr_Dir;

typedef struct { /* Draw Text Attributes Directive */
                 Dir_Common           dcom;     /* Common Directive Part */
                 int             txta_haln,     /* Horizontal Alignement */
                                 txta_valn,     /* Vertical Alignement */
                                 txta_path;     /* String Path */
                 float           txta_expf,     /* Width to High Ratio */
                                 txta_spcf,     /* Spacing */
                                 txta_dept;     /* Depth for extruded character */
               } Draw_TAttr_Dir;

typedef struct { /* Draw Select Font Directive */
                 Dir_Common           dcom;     /* Common Directive Part */
                 int              fnt_font;     /* Font Number (identifier) */
               } Draw_Font_Dir;

typedef struct { /* Draw Select Color Directive */
                 Dir_Common           dcom;     /* Common Directive Part */
                 Draw_RGBA        col_rgba;     /* <0 => color index, >0 R, */
               } Draw_Color_Dir;

typedef struct { /* Push or Pop Attribute Directive */
                 Dir_Common           dcom;     /* Common Directive Part */
                 int              ppa_code;     /* Code for Push or Pop Attribute Directive */
               } Draw_PPAttr_Dir;

typedef struct { /* Open a Plot Plane Reference Directive */
                 Dir_Common           dcom;     /* Common Directive Part */
                 Draw_Ptr         epl_prev;     /* Pointer to previous box */
                 GLfloat       epl_mat[16];     /* Coordinate Transf. Matrix */
               } Draw_EPlane_Dir;

typedef struct { /* Close a Plot Plane Reference Directive */
                 Dir_Common           dcom;     /* Common Directive Part */
               } Draw_DPlane_Dir;

typedef struct { /* Open a Box Reference Directive */
                 Dir_Common           dcom;     /* Common Directive Part */
                 Draw_Ptr         bxr_prev;     /* Pointer to previous box */
                 float         bxr_lim[24];     /* Coordinate limits (6 clip planes )*/
                 Char           bxr_mod[3];     /* Coordinate mode for each dimension */
                                                /* 2 for log10(x), Linear otherwise */
               } Draw_Boxref_Dir;

typedef struct { /* Close a Box Reference Directive */
                 Dir_Common           dcom;     /* Common Directive Part */
               } Draw_Popbxr_Dir;

typedef struct { /* Exec the specified Segment */
                 Dir_Common           dcom;     /* Common Directive Part */
                 Draw_Ptr         exec_seg,     /* Segment to exec */
                                  exec_lst;     /* Link to other segment reference(s) */
               } Draw_ExecSeg_Dir;

typedef struct { /* Push a Transformation Matrix */
                 Dir_Common           dcom;     /* Common Directive Part */
                 int              trsf_ide;     /* Segment to exec */
                 Draw_Ptr         trsf_nxt,     /* Link to other transformation(s) */
                                  trsf_prv;
                 GLfloat      trsf_mat[16];     /* Related Transformation matrix */
               } Draw_PushMat_Dir;

typedef struct { /* Pop a Transformation Matrix */
                 Dir_Common           dcom;     /* Common Directive Part */
               } Draw_PopMat_Dir;

typedef struct { /* Blending Set Directive */
                 Dir_Common           dcom;     /* Common Directive Part */
                 int             bld_flags;     /* Blending Flag Word */
                 GLenum            bld_src,     /* Blending Source Factor code */
                                   bld_dst;     /* Blending Detination Factor code */
               } Draw_Blend_Dir;

typedef struct { /* Light Definition/prop. Directive */
                 Dir_Common           dcom;     /* Common Directive Part */
                 GLenum            lig_spc,     /* Light Number */
                                  lig_kind;     /* Light Kind */
                 GLfloat        lig_prm[4];     /* Parameters */
               } Draw_LgtDf_Dir;

typedef struct { /* Materials Light Prop. Directive */
                 Dir_Common           dcom;     /* Common Directive Part */
                 GLenum          lmat_face,     /* Face Specification */
                                 lmat_kind;     /* Kind of Properties */
                 GLfloat       lmat_prm[4];     /* Parameters */
               } Draw_MLPrp_Dir;


typedef struct { /* Lights ON/OFF Directive */
                 Dir_Common           dcom;     /* Common Directive Part */
                 GLenum            lgs_sta;     /* 0,1 for Disable/Enable Lighting */
               } Draw_Light_Dir;

typedef union  Draw_Dir { /* Draw Elementary Directive Definition */
                 Draw_Segm_Dir         seg;     /* Segment Head */
                 Draw_Plot_Dir         tab;     /* Coordinates Table */
                 Draw_Text_Dir         txt;     /* String of text */
                 Draw_TBox_Dir        tbox;     /* Text in a box */
                 Draw_Circle_Dir      circ;     /* Circle */
                 Draw_Sphere_Dir    sphere;     /* Sphere */
                 Draw_Cylinder_Dir     cyl;     /* Cylinder */
                 Draw_Disk_Dir        disk;     /* Disk or part of disk */
                 Draw_LAttr_Dir    linattr;     /* Set Line Attribute*/
                 Draw_MAttr_Dir    mrkattr;     /* Set Marker Attribute */
                 Draw_FAttr_Dir    filattr;     /* Set Fill Attribute */
                 Draw_TAttr_Dir    txtattr;     /* Set text Attribute */
                 Draw_Font_Dir        font;     /* Set a font */
                 Draw_Color_Dir      color;     /* Set a Color */
                 Draw_PPAttr_Dir    ppattr;     /* Push/Pop current Attribute */
                 Draw_EPlane_Dir    eplane;     /* Enable a new plot plane */
                 Draw_DPlane_Dir    dplane;     /* disable current plot plane */
                 Draw_Boxref_Dir    boxref;     /* Set a Box reference */
                 Draw_Popbxr_Dir    popbxr;     /* Release a Box reference */
                 Draw_ExecSeg_Dir   exeseg;     /* Exec the specified segment */
                 Draw_PushMat_Dir     tmat;     /* Push Transformation Matrix */
                 Draw_PopMat_Dir    popmat;     /* Pop Transformation Matrix */
                 Draw_Blend_Dir      blend;     /* Blending Set */
                 Draw_LgtDf_Dir      light;     /* Light Define */
                 Draw_MLPrp_Dir      lmatp;     /* Material Light Properties */
                 Draw_Light_Dir      lig01;     /* Lighting Off/On */
               } Draw_Directive;


typedef struct { /* Draw Segment Cache Reference */
                 Draw_Ptr      ref_ref;         /* Pointer to the segment */
                 int          ref_idnt;         /* Segment identifier Copy */
               } Draw_Cache_Ref;


typedef union  { struct { unsigned char ch0, ch1, ch2, ch3; } ct;       /* 4 chars */
                 struct { unsigned short i0, i1; } it;                  /* or 2 shorts */
                 int   i;                                               /* or one int */
                 float f;                                               /* or one float */
               } eqv_if;                        /* Define an equivalent type for conversion  */


typedef enum   { car, entier, reel } le_type;


typedef struct { eqv_if   nb;                   /* A Binary Number */
                 le_type typ;                   /* ... or an ennumerated */
               } teqv_if;                       /* Define the generalized equ type */


typedef float color_tab[16][4];                 /* Color table definition */






/***********************************************************************/
/**                                                                   **/
/**            V A R I A B L E S    D E F I N I T I O N S             **/
/**                                                                   **/
/***********************************************************************/

#  ifdef _DEF_GLOBAL
#    define extref
#    define gblv
#  else
#    define extref extern
#    define gblv( v ) = v
#  endif

extref  FILE * fmsg;                            /* Error message File */

extref  char *         draw_pic_title;          /* Picture title */
extref  int            draw_pic_emarg,          /* Picture margin Enable Flag */
                       draw_noscalech;          /* Flag to lock the scale change during a window size change */

/*********    Whole Plot Tree Pointer and Segment number recovery   **********/

extref  Draw_Ptr       draw_root,               /* Root of the plot */
                       draw_fsegm,              /* First Segment */
                       draw_lsegm,              /* Last segment */
                       draw_usrseg,             /* Current Saved User Segment */
                       draw_curseg,             /* Current Segment */
                       draw_fsysseg,            /* First System Segment */
                       draw_lsysseg,            /* Last System Segment */
                       draw_ftrmat,             /* First Transformation Ref. */
                       draw_ltrmat;             /* Last Transformation Ref. */

extref  int            draw_seg_count,          /* Segment Creator Count */
                       draw_trf_count,          /* Transformation Count */
                       draw_curr_pid,           /* Current Pick identifier */
                       draw_curr_detf,          /* Current Pick Detection Flag */
                       draw_curr_color,         /* Current color number */
                       draw_out_mode,           /* Current Output mode */
                       draw_lock_flag,          /* Lock Draw/Redraw Flag */
                       draw_mat_cnt;            /* Transformation Matrix Count */

extref  float          cx_pen,                  /* Current Pen position for plotter simulation */
                       cy_pen,
                       cz_pen,
                       orgx,                    /* Current Plot Origine */
                       orgy,
                       orgz,
                       org_orgx,                /* Default Plot Origine */
                       org_orgy,
                       org_orgz,
                       Draw_pic_xx,             /* MiniMaxi of the user Space */
                       Draw_pic_yy,
                       Draw_pic_zz,
                       Draw_pic_yx,             /* Current Picture Y/X ration and total size */
                       Draw_pic_sx,
                       Draw_pic_sy,
                       Draw_Dist;               /* View Distance for perspective */

extref  int            Plot_Size,               /* Local Plot Size */
                       Plot_Index,              /* Local Plot Fill Index */
                       Plot_Flag;               /* Local Plot Large Move Flag */

extref  float     Plot_Tab[PLOT_TAB_LEN];       /* Local Plot table */


extref  Draw_Cache_Ref draw_sgtb[SEG_CACHE_SIZE],       /* Cache of Segment Reference */
                       draw_trtb[TRF_CACHE_SIZE];       /* Cache of Transformation Reference */


/* Definitions of Parameter to set by INSYMBOL Processing */

extref  int                 d_id,          bclearws;                    /* Work-Station flag */

extref  int                dr_rx,             dr_ry,                    /* Screen Display size in raster */
                           d_hc_resolution;                             /* Save resolution in pixel/inch. */

extref  float                       d_mult_linesize;                    /* Effective line thickness multiplicator */

extref  float            d_width,          d_height,                    /* Screen Display Size (in cm). */
                     d_borders_x,       d_borders_y,                    /* Screen Window Display Position (in cm). */
                           ds_rx,             ds_ry;                    /* Screen Window Display Size (in cm). */


extref  int           pet_string,        pet_choice,      pet_answerd,  /* Prompt Echo Type for each kind of input interaction */
                    pet_position,          pet_line,       pet_stroke,
                      pet_window,         pet_value,         pet_pick;

extref  float       d_ch_area[4],      d_st_area[4],     d_an_area[4],  /* Screen Echo Arrea for each user input prompt : choice, string, answerd, ... */
                    d_va_area[4];                                       /* ... and input numeric value. */


extref color_tab   draw_srccoltb;                                       /* Define the parametrized color tables */

extref  char   *   draw_fontnamtb[SIZE_DEF_FONT];                       /* Filenames of each predefined font */

extref  int        draw_fontstyle[SIZE_DEF_FONT];                       /* Style of each predefined font */

extref  char   *   draw_fontpath;                                       /* Font Path default to use */



/**************************************************************************************/
/***                  End of Parametrized Varioable declarations                    ***/
/**************************************************************************************/







/*       Definition of Standard Draw Colors      */

#  ifdef _DEF_GLOBAL

  /* Default Color Table */
  color_tab draw_defcoltb = { { 1.0, 1.0, 1.0, 1.0 },   /* Color 0 = White   */
                              { 0.0, 0.0, 0.0, 1.0 },   /* Color 1 = Black   */
                              { 1.0, 0.0, 0.0, 1.0 },   /* Color 2 = Red     */
                              { 0.0, 0.0, 1.0, 1.0 },   /* Color 3 = Blue    */
                              { 0.0, 1.0, 0.0, 1.0 },   /* Color 4 = Green   */
                              { 1.0, 1.0, 0.0, 1.0 },   /* Color 5 = Yellow  */
                              { 0.0, 1.0, 1.0, 1.0 },   /* Color 6 = Cyan    */
                              { 1.0, 0.0, 1.0, 1.0 },   /* Color 7 = Magenta */
                              { 0.7, 0.7, 0.7, 1.0 },   /* Color 8 = W. Grey */
                              { 0.3, 0.3, 0.3, 1.0 },   /* Color 9 = B. Grey */
                              { 0.5, 0.0, 0.0, 1.0 },   /* Color A = B. Red  */
                              { 0.0, 0.0, 0.5, 1.0 },   /* Color B = B. Blue */
                              { 0.0, 0.5, 0.0, 1.0 },   /* Color C = B.Green */
                              { 0.5, 0.5, 0.0, 1.0 },   /* Color D = B.Yellow*/
                              { 0.0, 0.5, 0.5, 1.0 },   /* Color E = B. Cyan */
                              { 0.5, 0.0, 0.5, 1.0 }    /* Color F = B.Magenta*/
                            };

  color_tab draw_savsrcctb;

#else

  extref color_tab   draw_defcoltb, draw_savsrcctb;

#endif


/* Common buffer */

//extref  int             bclearws;


extref  char    * draw_dis_conid,  * draw_pap_conid,  * draw_col_name;

extref  char    *      ds_griena,  *      ds_gridis,  *    menutb[15];


extref  int               insize,            inread,          outsize,
                      server_flg,            status,             itry;

extref  int                essai,            b_ieee,           b_conv;

extref  int              i_dummy,          bpicture,             ndot,
                        fac_size,           wstmask,
               default_echo_type,
                      state_size,               /* Non def. */
                          errind;               /* Definit */

extref  int            sys_segnb,         usr_segnb,    sys_segtb[20];

extref  int               d_stat,     d_color_flags,  d_one_page_flag;

extref  int               w_indx;

extref  int          w_plt_state,         w_pens_ok,           e_font,
                         g_flags,         scur_draw,
                     scur_addopt,          scur_pan,       scur_color,
                    start_dialog,           nb_cell,
                        xup_cell,          yup_cell,
                       xlow_cell,         ylow_cell,        ncol_cell,
                       nrow_cell;

extref  int               b_stop,
                        b_panusr,
                       b_plotted,
                          b_grid,               /* Grid Flag Enable/Disable */
                     color_flags,
                         w_color,
                    w_complement,
                   one_page_flag,
                      cpen_state;

extref  int    col_tab[col_size*row_size];

extref  int    b_edit, b_usr, bstat,            /* Boolean */
               size_menu, iseg, ii, jj, wp_st, wp_sho, msgpl,
               plt_wtype, perrind, pconid, punit,
               pnum_colors, pcolor_flag, pnum_indexes,
               user_d_stat, inpch, inpch1;

extref  int    minx_cadre, maxx_cadre, miny_cadre, maxy_cadre;



extref  int    dummy_int;                       /* Dummy int used by insymbol. */
extref  float  dummy_flt;                       /* Dummy float used by insymbol. */



extref  float  twndx1, twndx2, twndy1, twndy2, lstox, lstoy,
               xg1, xg2, yg1, yg2, r, xysca, rv, rmin, rmax, orggx, orggy;





/*********    Screen Work Station Canvas definitions    **********/

extref     int                  draw_print;     /* Flag for Hard Copy Printing */

extref     float   draw_cxmin,  draw_cymin,     /* World window station */
                   draw_cxmax,  draw_cymax,
                   draw_zwxmi,  draw_zwymi,     /* World window previous zoom saved */
                   draw_zwxma,  draw_zwyma,
                   draw_swxmi,  draw_swymi,     /* World window station saved */
                   draw_swxma,  draw_swyma,
                   draw_iwxmi,  draw_iwymi,     /* World window station Initial (pic) */
                   draw_iwxma,  draw_iwyma;

extref     double  draw_uxmin,  draw_uxmax,     /* Minimaxi in x, y ... */
                   draw_uymin,  draw_uymax,     /* ... and z (cm). */
                   draw_uzmin,  draw_uzmax,
                   draw_suxmi,  draw_suxma,     /* and, all corresponding save values */
                   draw_suymi,  draw_suyma,
                   draw_suzmi,  draw_suzma,

                   cxy_scale,  efcxy_scale,     /* Global Draw Display Scale and 1/cxy_scale */
                   zxy_scale,  efzxy_scale,     /* Global Draw Display Scale and 1/cxy_scale */
                   sxy_scale,  efsxy_scale,     /* Saved cxy_scale (Output scale) */
                   ixy_scale,  efixy_scale;     /* Saved initial sxy_scale (Output scale), change with window size */


extref     double  dw_cwpx,        dw_cwpy,     /* Current Position (origine at center) and Size (User Cm) */
                   dw_cwsx,        dw_cwsy,
                   dw_zwpx,        dw_zwpy,     /* Saved Position and Size from Last Zoomed View */
                   dw_zwsx,        dw_zwsy,
                   dw_swpx,        dw_swpy,     /* Saved Position and Size (User Cm) */
                   dw_swsx,        dw_swsy,
                   dw_iwpx,        dw_iwpy,     /* Saved Initial Position and Size (User Cm) */
                   dw_iwsx,        dw_iwsy,
                   dw_cxmin,      dw_cymin,     /* Screen Word Coordinates Minimaxi */
                   dw_cxmax,      dw_cymax,
                   dw_zxmin,      dw_zymin,     /* Screen Word Coordinates Minimaxi */
                   dw_zxmax,      dw_zymax,
                   dw_sxmin,      dw_symin,     /* Screen Saved Word Coordinates Minimaxi */
                   dw_sxmax,      dw_symax,
                   dw_ixmin,      dw_iymin,     /* Screen Saved Initial Word Coord. Minimaxi */
                   dw_ixmax,      dw_iymax;

extref     unt_ty                   d_unit;     /* Kind of metric for the Screen. */

extref     int     dt_rx,            dt_ry,     /* (used) Window Display Size in raster. */
                   dp_rx,            dp_ry,     /* Screen Window Display Position in raster. */
                   dsv_px,          dsv_py,     /* System ViewPort Display position in raster */
                   dsv_sx,          dsv_sy,     /* System ViewPort Display size in raster */
                   s_dt_rx,        s_dt_ry,     /* Saved dt_rx and dt_ry. */
                   s_dsv_px,      s_dsv_py,     /* Saved dsv_px and dsv_py. */
                   s_dsv_sx,      s_dsv_sy,     /* Saved dsv_sx and dsv_sy. */

                   d_vpxp,          d_vpyp,     /* User ViewPort in raster */
                   d_vpsx,          d_vpsy,
                   s_d_vpxp,      s_d_vpyp,     /* Saves User ViewPort in raster */
                   s_d_vpsx,      s_d_vpsy;

extref     float   d_xscale,      d_yscale;     /* Screen Window Display View Scales (pixels/station_cm). */



/*********      Other Draw definitions       **********/


extref     int                  reqflg,         /* Flag (1/0) to Enable/Disable Request */
                                reqnxt,         /* Flag (1/0) to Ena./Dis. the after dialog mode */
                                                /* In dialog mode reqflg = 0, reqnxt = 1 */
                          draw_3D_init,         /* Flag for 3D Picture Init */
                           draw_3D_flg,         /* Flag for 3D Picture use */
                      draw_3D_fill_flg;         /* Flag for 3D Picture with fill area */

extref     float    emarginx, emarginy;         /* Picture Margin Size (cm) */



/*********     Draw <--> GL Interface Definitions     **********/

extref     int                  npoint,         /* Number of point in nptab */
                          cur_out_kind,         /* Current V DRAW Output type */
                          cur_out_mode,         /* Current Output mode */
                          sdrw_pen_cnt,         /* Pen table count for local PLOT */
                        sdrw_read_left;         /* Byte left count for exchange input */

extref     char          prc_name[512],         /* User Program Name */
                         sv_title[512];


extref     float     sdrw_pen_tab[128],         /* Pen table for local PLOT */
                             pen_speed;         /* Plotter Pen Speed (for printer -> Plotter). */

extref     GLfloat*       Draw_ViewMat;         /* Pointer to view matrix to edit by drwgl_view */

extref     Draw_Q_Request  *Draw_Qfirst,        /* Queue Request Header */
                           *Draw_Qlast;





/************************************************************************/
/**                                                                    **/
/**  P R O C E D U R E S / F U N C T I O N S    D E F I N I T I O N S  **/
/**                                                                    **/
/************************************************************************/

/****  All DRAW-LIB Connection management routines  ****/

void          Sdrw_Open_Gate(int, char** );
int           Sdrw_Read( void );
void          Sdrw_Write( void );
int           Sdrw_Read_Block( Char*, int );
void          Sdrw_Write_Block( Char*, int );
void          Sdrw_Close_Gate( void );          /* End of Client-Server relation for reverse mode */

int           Sdrw_Dialog_Request( void );
void          Sdrw_Put_Char( Char );
Char *        Sdrw_Put_Address( int );
void          Sdrw_Put_Int( int );
void          Sdrw_Put_Int_Direct( int, int );
void          Sdrw_Put_Float( float );
void          Sdrw_Put_Code( int );
void          Sdrw_Put_String( const char*, int );
Char          Sdrw_Get_Char( void );
Char *        Sdrw_Get_Address( int );
int           Sdrw_Get_Int( void );
float         Sdrw_Get_Float( void );
int           Sdrw_Get_String( char*, int );
char *        Sdrw_Get_String_Tmp( void );
void          Sdrw_String_Free_Tmp( char* );
Char*         Sdrw_Get_Buffer( void );
int           Sdrw_Get_Code( void );
void          Sdrw_Anim_acq( int );

void          Sdrw_Resume_User_Manager( void ); /* To start the user Manager */

void          Sdrw_read_lock( void );           /* To Lock and Unlock for critical section */
void          Sdrw_read_unlock(void );

void          Sdrw_Params_Setting( void );
void          Sdrw_Pre_Init( void );
void          Sdrw_Init( void );


void          Sdrw_Start_User_Exchange( void );         /* Start the User Exchange Dialog */
void          Sdrw_Resume_User_Exchange( void );        /* Resume the User Exchange Dialog */
void          Sdrw_Wait_For_Request( void );            /* To synchronous with standard */

int           Sdrw_Build_Filename( const char * fspc, char * buf );
int           Sdrw_Search_In_Path( const char *, const char *, char * );

/*        * * *     D R A W   S E R V I C E S    R O U T I N E S     * * *        */

void          Draw_Queue_Request( int );
void          Draw_Process_Seq( Draw_Q_Request*, int );

int           Draw_Init( float*, float*, Char* );
int           Draw_Picture( char*, float, float, float, Char, Char );
void          Draw_End();

void          Draw_Exchange_Init( void );
void          Draw_Extern_Init( void );
void *        Draw_Sequence_Exec( void * );
void          Draw_Set_Picture_Scale( float, float, float, float );


Draw_Ptr      Draw_Locate_Seg( int );
Draw_Ptr      Draw_Locate_Sys_Seg( int );
Draw_Ptr      Draw_New_Segment( int, int );
Draw_Ptr      Draw_New_Sys_Seg( int, int );
Draw_Ptr      Draw_New_Node( Draw_Dir_Types );
void          Draw_Link_Node( Draw_Ptr );

void          Draw_Ini_Sys_Seg();

void          Draw_Destroye( Draw_Ptr );
void          Draw_Draw_Clear();
Draw_Ptr      Draw_User_Append( Draw_Ptr );
void          Draw_Send_Points( int );

void          Draw_Gen_Clip( float, float, float, float, float, float );
void          Draw_Gen_Mplot( int, int, float * );
void          Draw_Gen_Text( float, float, float, float, int, char * );
void          Draw_Gen_Text_Box();
void          Draw_Gen_Circle( float, float, float, float, float, float );
void          Draw_Gen_Sphere( float, float, float, float, int, int, int );
void          Draw_Gen_Cylinder( float*, int, int, int );
void          Draw_Gen_Disk( float*, int, int, int );
void          Draw__G_Surface( int nraw, int ncol, int flg, float* buf );
void          Draw_Gen_Surface( int, int, int );
void          Draw_Gen_Surface2( int, int, int, float, float, float, float );
void          Draw_Gen_Polyhedral( int, int, int );

void          Draw_Gen_Exec_Seg( int );

int           Draw_Set_Seg_Attr( int, int, int, int, float );

int           Draw_Gen_TMat( int );
Draw_Ptr      Draw_Locate_TMat( int id );

void          Draw_Gen_Lattr( int, float );
void          Draw_Gen_Mattr( int, float );
void          Draw_Gen_Fattr( int, int );
void          Draw_Gen_Tattr( int, int, int, float, float, float );
int           Draw_Gen_SelectFont( int );
void          Draw_Gen_Color( float, float, float, float );
void          Draw_Gen_Def_Color( int );
void          Draw_Gen_PP_Attr( int );
void          Draw_Gen_Box_Ref( int );
void          Draw_Gen_Eplane( float* );
void          Draw_Gen_BlendSet( int );
void          Draw_Light_On_Off( int, int );
void          Draw_Gen_LightDef( int, int, int, float* );
void          Draw_Gen_MatLight( int, int, int, float* );
void          Draw_Gen_Normal( float*, int, int );

int           Draw_Check_Font( int );
int           Draw_Install_Font( int, int, int, char* );
int           Draw_Font_Info( int, int*, char ** );

void          Draw_ProgPlot_End( void );
void          Draw_ProgPlot( float, float );
int           Draw_ProgPlot_Set( Draw_Ptr, int );
void          Draw_Set_MaxPPlot( int );

void          Draw_GPlots( void );
void          Draw_GPlot1( void );
void          Draw_GPlot( float, float, int );
void          Draw_GPlot3( float, float, float, int );
void          Draw_GPlot2D( Draw_Point, int );
void          Draw_GPlot3D( Draw_Point3, int );
void          Draw_GPlot_Rect( float, float, float, float );
Draw_Ptr      Draw_GPlot_Grid();

void          Draw_Get_Color_Def( int, float*, float*, float*, float* );
void          Draw_Set_Color_Def( int, float, float, float, float );

void          Show_Vwp( const char*, const int* );
void          Show_clplan( const char*, const GLdouble* );
void          Show_Mat( const char*, const GLdouble* );
void          Show_Matf( const char*, const GLfloat* );
void          Draw_Error( const char*, const char* );

int           Draw_Pannel_Attr();
int           Draw_Create_Pannel();
int           Draw_Pannel_Add();
int           Draw_Pannel_Change();
int           Draw_Pannel_EnaDis();
int           Draw_Open_Pannel();
int           Draw_Close_Pannel();
int           Draw_Get_Pannel_Values();
int           Draw_Put_Pannel_Values();
int           Draw_Pannel_Request( int );
int           Draw_Pannel_Destroy( int );
int           Draw_Pannel_Destroy_All();
int           Draw_Pannel_Dispatch( int );

#endif


