#
# Makefile for cube test.
#
configfile=./fltk_config.make

include	$(configfile)

BIN	=	../bin
OBJ	=	../obj
SRC	=	.

EXES	=	$(BIN)/Draw_Server$(EXETYP)

OBJS	=	$(OBJ)/Server_Main.o \
		$(OBJ)/Server_UI.o \
		$(OBJ)/Server_GL.o \
		$(OBJ)/Server_Init.o \
		$(OBJ)/Server_Insymbol.o \
		$(OBJ)/Server_ExchMan.o \
		$(OBJ)/Server_ConnectMan.o \
		$(OBJ)/Server_MenuMan.o \
		$(OBJ)/Server_GetVal.o \
		$(OBJ)/Server_Pannel_UI.o \
		$(OBJ)/Server_Process.o \
		$(OBJ)/Server_DrawBase.o \
		$(OBJ)/Server_AxisBox.o \
		$(OBJ)/Server_DrawGL.o \
		$(OBJ)/Server_MapIO.o \
		$(OBJ)/Server_NumCV.o

SRCS	=	$(SRC)/Server_Main.cxx \
		$(SRC)/Server_UI.cxx \
		$(SRC)/Server_GL.cxx \
		$(SRC)/Server_Init.cxx \
		$(SRC)/Server_Insymbol.cxx \
		$(SRC)/Server_ExchMan.cxx \
		$(SRC)/Server_ConnectMan.cxx \
		$(SRC)/Server_MenuMan.cxx \
		$(SRC)/Server_GetVal.cxx \
		$(SRC)/Server_Pannel_UI.cxx \
		$(SRC)/Server_Process.cxx \
		$(SRC)/Server_DrawBase.cxx \
		$(SRC)/Server_AxisBox.cxx \
		$(SRC)/Server_DrawGL.cxx \
		$(OBJ)/Server_MapIO.cxx \
		$(SRC)/Server_NumCV.cxx


all:	$(EXES)

$(BIN)/Draw_Server$(EXETYP):	$(OBJS)
	$(CXX) $(CXXFLG) $(OBJS) $(LDFLG) -o $@ -Wl,-M > Draw_Server.map
#
$(OBJ)/Server_Main.o:	$(SRC)/Server_Main.cxx $(SRC)/Server_UI.h $(SRC)/Server_GL.h $(SRC)/Server_Env.h
	$(CXX) -I../include $(CXXFLG) -c $< -o $@
#
$(OBJ)/Server_UI.o:	$(SRC)/Server_UI.cxx $(SRC)/Server_UI.h $(SRC)/Server_GL.h $(SRC)/Server_Env.h
	$(CXX) -I../include $(CXXFLG) -c $< -o $@
#
$(OBJ)/Server_GL.o:	$(SRC)/Server_GL.cxx $(SRC)/Server_UI.h $(SRC)/Server_GL.h $(SRC)/Server_Env.h \
	$(SRC)/Server_UsrInput.h
	$(CXX) -I../include $(CXXFLG) -c $< -o $@
#
$(OBJ)/Server_Init.o:	$(SRC)/Server_Init.cxx $(SRC)/Server_Env.h
	$(CXX) -I../include $(CXXFLG) -c $< -o $@
#
$(OBJ)/Server_Insymbol.o: $(SRC)/Server_Insymbol.cxx $(SRC)/Server_Env.h
	$(CXX) -I../include $(CXXFLG) -c $< -o $@
#
$(OBJ)/Server_ExchMan.o: $(SRC)/Server_ExchMan.cxx $(SRC)/Server_UI.h $(SRC)/Server_GL.h \
	$(SRC)/Server_Env.h
	$(CXX) -I../include $(CXXFLG) -c $< -o $@
#
$(OBJ)/Server_ConnectMan.o: $(SRC)/Server_ConnectMan.cxx $(SRC)/Server_Env.h
	$(CXX) -I../include $(CXXFLG) -c $< -o $@
#
$(OBJ)/Server_MenuMan.o: $(SRC)/Server_MenuMan.cxx $(SRC)/Server_Env.h
	$(CXX) -I../include $(CXXFLG) -c $< -o $@
#
$(OBJ)/Server_GetVal.o: $(SRC)/Server_GetVal.cxx $(SRC)/Server_UsrInput.h
	$(CXX) $(CXXFLG) -c $< -o $@
#
$(OBJ)/Server_Pannel_UI.o: $(SRC)/Server_Pannel_UI.cxx $(SRC)/Server_Pannel_UI.h $(SRC)/Server_Env.h $(SRC)/Server_DrawGL.h
	$(CXX) -I../include $(CXXFLG) -c $< -o $@
#
$(OBJ)/Server_Process.o: $(SRC)/Server_Process.cxx $(SRC)/Server_Env.h $(SRC)/Server_DrawGL.h
	$(CXX) -I../include $(CXXFLG) -c $< -o $@
#
$(OBJ)/Server_DrawBase.o: $(SRC)/Server_DrawBase.cxx $(SRC)/Server_Env.h
	$(CXX) -I../include $(CXXFLG) -c $< -o $@
#
$(OBJ)/Server_AxisBox.o: $(SRC)/Server_AxisBox.cxx $(SRC)/Server_Env.h
	$(CXX) -I../include $(CXXFLG) -c $< -o $@
#
$(OBJ)/Server_DrawGL.o: $(SRC)/Server_DrawGL.cxx $(SRC)/Server_Env.h $(SRC)/Server_DrawGL.h
	$(CXX) -I../include $(CXXFLG) -c $< -o $@
#
$(OBJ)/Server_MapIO.o: $(SRC)/Server_MapIO.cxx $(SRC)/Server_Env.h $(SRC)/Server_DrawGL.h
	$(CXX) -I../include $(CXXFLG) -c $< -o $@
#
$(OBJ)/Server_NumCV.o: $(SRC)/Server_NumCV.cxx $(SRC)/Server_Env.h $(SRC)/Server_DrawGL.h
	$(CXX) -I../include $(CXXFLG) -c $< -o $@
#

clean:
	rm $(OBJS) $(EXES)
#
