INS	=	-I/usr/include/freetype2

LIBS	=	-lglut -lftgl

SRC	=	.
OBJ	=	.
EXE	=	.

CC	=	gcc

CFLG	=	-O2 -c

LFLG	=


SRCS	=	$(SRC)/c-demo.c \
		$(SRC)/simple.cpp \
		$(SRC)/FTGLDemo.cpp \
		$(SRC)/FTGLMFontDemo.cpp \
		$(SRC)/tb.c \
		$(SRC)/trackball.c

OBJS	=	$(OBJ)/c-demo.o \
		$(OBJ)/simple.o \
		$(OBJ)/FTGLDemo.o \
		$(OBJ)/FTGLMFontDemo.o \
		$(OBJ)/tb.o \
		$(OBJ)/trackball.o

EXES	=	$(EXE)/c-demo \
		$(EXE)/simple \
		$(EXE)/FTGLDemo \
		$(EXE)/FTGLMFontDemo


all: $(EXES)

clean:
	rm $(OBJS) $(EXES)


$(EXE)/c-demo: $(OBJ)/c-demo.o
	$(CC) $(LFLG) -o $(EXE)/c-demo $(OBJ)/c-demo.o $(LIBS)

$(EXE)/simple: $(OBJ)/simple.o
	$(CC) $(LFLG) -o $(EXE)/simple $(OBJ)/simple.o $(LIBS)

$(EXE)/FTGLDemo: $(OBJ)/FTGLDemo.o $(OBJ)/tb.o $(OBJ)/trackball.o
	$(CC) $(LFLG) -o $(EXE)/FTGLDemo $(OBJ)/FTGLDemo.o  $(OBJ)/tb.o $(OBJ)/trackball.o $(LIBS)

$(EXE)/FTGLMFontDemo: $(OBJ)/FTGLMFontDemo.o $(OBJ)/tb.o $(OBJ)/trackball.o
	$(CC) $(LFLG) -o $(EXE)/FTGLMFontDemo $(OBJ)/FTGLMFontDemo.o $(OBJ)/tb.o $(OBJ)/trackball.o $(LIBS)



$(OBJ)/c-demo.o: $(SRC)/c-demo.c $(SRC)/config.h
	$(CC) $(CFLG) -o $(OBJ)/c-demo.o $(CFLG) $(INS) $(SRC)/c-demo.c

$(OBJ)/simple.o: $(SRC)/simple.cpp $(SRC)/config.h
	$(CC) $(CFLG) -o $(OBJ)/simple.o $(CFLG) $(INS) $(SRC)/simple.cpp

$(OBJ)/tb.o: $(SRC)/tb.c $(SRC)/config.h $(SRC)/tb.h $(SRC)/trackball.h
	$(CC) $(CFLG) -o $(OBJ)/tb.o $(CFLG) $(INS) $(SRC)/tb.c

$(OBJ)/trackball.o: $(SRC)/trackball.c $(SRC)/config.h $(SRC)/trackball.h
	$(CC) $(CFLG) -o $(OBJ)/trackball.o $(CFLG) $(INS) $(SRC)/trackball.c

$(OBJ)/FTGLDemo.o: $(SRC)/FTGLDemo.cpp $(SRC)/config.h $(SRC)/tb.h
	$(CC) $(CFLG) -o $(OBJ)/FTGLDemo.o $(INS) $(SRC)/FTGLDemo.cpp

$(OBJ)/FTGLMFontDemo.o: $(SRC)/FTGLMFontDemo.cpp $(SRC)/config.h $(SRC)/tb.h
	$(CC) $(CFLG) -o $(OBJ)/FTGLMFontDemo.o $(INS) $(SRC)/FTGLMFontDemo.cpp

#gcc -o FTGLMFontDemo -I/usr/include/freetype2 FTGLMFontDemo.cpp tb.c trackball.c -lglut -lftgl
#gcc -o FTGLDemo -I/usr/include/freetype2 FTGLDemo.cpp tb.c trackball.c -lglut -lftgl
#gcc -o simple -I/usr/include/freetype2 simple.cpp -lglut -lftgl