#
# File to generate a binary kit
#
#
echo " Install for DRAW System V 1.3C -  31-Oct-2009"
#
#
kernel=$(uname)
processor=$(arch)
exetyp=
exenty=".exe"
#
case $kernel in
  CYGWIN*)
    addrwidth="WIN32"
    processor="32"
    dir_bld="Windows_bin_kit"
    exetyp=".exe"
    exenty=
    ;;
  Linux)
    kernel="LINUX"
    case $processor in
      x86_64)
        addrwidth="64"
        dir_bld="Linux_x86-64_bin_kit"
        ;;
      *)
        dir_bld="Linux_i386_bin_kit"
        addrwidth="32"
        ;;
    esac
    ;;
  *)
    echo " Not identified Operating system \"${kernel}\" ==> Assume unknown UNIX."
    kernel="UNIX"
    addrwidth="32"
    ;;
esac
#
# Check for g77 or gfortran or nothing.
for="gfortran"
gfortran -c check_empty.f 2> /dev/null
if test "$?" != "0"
then
  for="g77"
  g77 -c check_empty.f 2> /dev/null
  if test "$?" != "0"
  then
    for="ifort"
    ifort -c check_empty.f 2> /dev/null
    if test "$?" != "0"
    then
      for="0"
    fi
  fi
fi
#
echo " We run with the System $kernel on the processor $processor (mode $addrwidth bits)."
#
if test "$for" != "0"
then
  export FOR=$for
  rm -f check_empty.o
  echo " The $FOR compiler is set for use."
else
  echo " We do not use a fortran compiler."
  export FOR=0
fi
#
# Create the FLTK Configuration file.
#
./make_fltk_config.sh -vl 2 -gl -img
#
# Build our FTGL Library version.
#
cd our_ftgl
make clean
make
cd ..
#
# Continue by the Server Compilation.
#
cd server
#
make clean
make
cd ..
#
# Copy the version file
#
cp server/draw_version.dat $dir_bld/
#
# Copy the DRAW_SERVER_SETTING File
#
cp server/draw_server_org.draw_setting $dir_bld/draw_server.draw_setting
#
# Copy the install.sh File
#
cp server/install.sh $dir_bld/
#
# Compile the DRAW Library
#
cd Draw_Library
make clean
if test "$FOR" != "0"
then
  make
else
  make -f Makefile_nf
fi
cd ..
#
# Compile the DRAW Examples files
#
cd Draw_Examples
export DRAWENV=../include/draw/
export EXETYP=$exetyp
export EXENTY=$exenty
make clean
make
export DRAWENV=
export EXETYP=
cd ..
#
# Make the DRAW Library
#
tar -czvf $dir_bld/Draw_Examples.tgz Draw_Examples/
cd include
tar -czvf ../$dir_bld/include_draw.tgz draw/
cd ..
#
# Copy the file in the appropriate target directory.
#
cp include/draw/*_defs.* $dir_bld/
# cp include/draw/*_defs.pas /usr/local/cpas/
cp bin/* $dir_bld/
cp Fonts/*.ttf $dir_bld/
cp lib/* $dir_bld/
# cp lib/* /usr/local/lib/
#
# Build the ivp program.
#
cp server/draw_ivp.pas $dir_bld/
cd $dir_bld
export DRAWENV=../include/draw/
if test -f draw_ivp.exe
then
  echo " Delete old draw_ivp.exe executable"
  rm -f draw_ivp.exe
fi
if test -f draw_ivp
then
  echo " Delete old draw_ivp executable"
  rm -f draw_ivp
fi
echo
echo *** Build new draw_ivp program ***
echo
pcmp draw_ivp
gcc -o draw_ivp draw_ivp.c -I../include -L../lib -lcpas -ldraw -lm
export DRAWENV=
cd ..
#
echo
echo "  ***  Built of Binary images for FLTK DRAW kit Procedure end ***"
echo
#