(*

*************************************************************************
*                                                                       *
*                                                                       *
*                                                                       *
*             D R A W   -   C L I E N T   L I B R A R Y                 *
*                                                                       *
*                P A S C A L (C P A S)   M O D U L E                    *
*                                                                       *
*                (Pannel Control Graphic Directives)                    *
*                    (Pascal Adaptation Support)                        *
*                                                                       *
*                    Draw Library Version V 2.4                         *
*                                                                       *
*                           31-Jan-2009                                 *
*                                                                       *
*                               by                                      *
*                                                                       *
*                  Pierre Wolfers,  Institut Neel                       *
*                                                                       *
*          CNRS GRENOBLE,  25 Avenue des Martyrs, B.P. 166              *
*                                                                       *
*                     F 38042 GRENOBLE CEDEX 9                          *
*                                                                       *
*                           F R A N C E                                 *
*                                                                       *
*                                                                       *
*                                                                       *
*************************************************************************



/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////

*)
%pragma trace 1;
module DRAW$PASCAL_PANNEL;

type
  Dfloat = single;
  Dint   = cc__int;
  Dbool  = boolean;

  Choice_List( dim, cap: byte ) = array[1..dim] of string( cap );   { Define the item liste for Enum/Literal type }



procedure Pannel_Font( id, lbf: Dint; nm: $wild_pointer; len, opt: Dint ); external 'Draw_Pannel_Font';

[global 'Draw_Pas_Pannel_Font']
procedure DRAW$PANNEL_FONT( id: Dint; blb: Dbool; in_var nam: string; opt: Dint := 0 );
begin
  Pannel_Font( id, ORD( blb ), nam.body"address, nam.length, opt )
end DRAW$PANNEL_FONT;




function Create_Pannel( w, h: Dfloat; t: $wild_pointer; l: Dint ): Dint; external 'Draw_Pannel_Create';

[global 'Draw_Pas_Pannel_Create']
function DRAW$PANNEL_CREATE( w, h: Dfloat; in_var title: string ): Dint;
begin
  DRAW$PANNEL_CREATE := Create_Pannel( w, h, title.body"address, title.length )
end DRAW$PANNEL_CREATE;



function Bool_To_Pannel( ide: Dint; x, y, w, h: Dfloat; t: $wild_pointer; l: Dint; var bv: Dbool ): Dint; external 'Draw_Bool_To_Pannel';

[global 'Draw_Pas_Pannel_B_Item']
function DRAW$PANNEL_ADD_B( ide: Dint; x, y, w, h: Dfloat; in_var lab: string;
                            var bv: Dbool ): Dint;
begin
  DRAW$PANNEL_ADD_B := Bool_To_Pannel( ide, x, y, w, h, lab.body"address, lab.length, bv )
end DRAW$PANNEL_ADD_B;



function Enum_To_Pannel( ide: Dint; x, y, w, h: Dfloat; t: $wild_pointer; l: Dint; var ev: Dint;
                         sz: Dint; var ptst: $wild_pointer; var ptl: integer; min: Dint ): Dint; external 'Draw_Enum_To_Pannel';

[global 'Draw_Pas_Pannel_E_Item']
function DRAW$PANNEL_ADD_E( ide: Dint; x, y, w, h: Dfloat; in_var lab: string;
                            var ev: Dint; in_var stb: Choice_List; min: Dint := 1 ): Dint;
type
  tbl( sz: integer ) = array[1..sz] of Dint;
  tbs( sz: integer ) = array[1..sz] of $wild_pointer;

var
  ptl: ^tbl;
  pts: ^tbs;

begin { DRAW$PANNEL_ADD_E }
  NEW( ptl, stb.dim ); NEW( pts, stb.dim );
  for i := 1 to stb.dim do
  begin  pts^[i] := stb[i].body"address; ptl^[i] := stb[i].length  end;
  DRAW$PANNEL_ADD_E := Enum_To_Pannel( ide, x, y, w, h, lab.body"address, lab.length, ev,
                                       stb.dim, pts^[1], ptl^[1], min );
  DISPOSE( pts ); DISPOSE( ptl )
end DRAW$PANNEL_ADD_E;



[global 'Draw_Pas_Pannel_E1_Item']
function DRAW$PANNEL_ADD_E1( ide: Dint; x, y, w, h: Dfloat; in_var lab: string;
                             var ev: Dint;
                             in_var choice: array[dim: integer, cap: integer] of char;
                             nsz: Dint; min: Dint := 1 ): Dint;
type
  tbl( sz: integer ) = array[1..sz] of Dint;
  tbs( sz: integer ) = array[1..sz] of $wild_pointer;

var
  ptl: ^tbl;
  pts: ^tbs;

begin
  if nsz > dim then nsz := dim;
  NEW( ptl, nsz ); NEW( pts, nsz );
  for i := 1 to nsz do
  begin  pts^[i] := choice[i,2]"address; ptl^[i] := ORD( choice[i,1] )  end;
  DRAW$PANNEL_ADD_E1 := Enum_To_Pannel( ide, x, y, w, h, lab.body"address, lab.length, ev,
                                        nsz, pts^[1], ptl^[1], min );
  DISPOSE( pts ); DISPOSE( ptl )
end DRAW$PANNEL_ADD_E1;



function Str_To_Pannel( ide: Dint; x, y, w, h: Dfloat; t: $wild_pointer; len: Dint;
                        sv, sz: $wild_pointer; cap: Dint; edi: Dbool ): Dint; external 'Draw_Str_To_Pannel';

[global 'Draw_Pas_Pannel_S_Item']
function DRAW$PANNEL_ADD_S( ide: Dint; x, y, w, h: Dfloat; in_var lab: string;
                            var sv: string; edi: Dbool := true ): Dint;
begin
  DRAW$PANNEL_ADD_S := Str_To_Pannel( ide, x, y, w, h, lab.body"address, lab.length,
                                      sv.body"address, sv.length"address, sv.capacity, edi )
end DRAW$PANNEL_ADD_S;



function Int_To_Pannel( ide: Dint; x, y, w, h: Dfloat; t: $wild_pointer; l: Dint; var iv: Dint;
                        min, max: Dint ): Dint; external 'Draw_Int_To_Pannel';

[global 'Draw_Pas_Pannel_I_Item']
function DRAW$PANNEL_ADD_I( ide: Dint; x, y, w, h: Dfloat; in_var lab: string;
                            var iv: Dint; min, max: Dint ): Dint;
begin
  DRAW$PANNEL_ADD_I := Int_To_Pannel( ide, x, y, w, h, lab.body"address, lab.length, iv, min, max )
end DRAW$PANNEL_ADD_I;



function Flt_To_Pannel( ide: Dint; x, y, w, h: Dfloat; t: $wild_pointer; l: Dint; var fv: Dfloat;
                        min, max, step: Dfloat ): Dint; external 'Draw_Flt_To_Pannel';

[global 'Draw_Pas_Pannel_F_Item']
function DRAW$PANNEL_ADD_F( ide: Dint; x, y, w, h: Dfloat; in_var lab: string;
                            var fv: Dfloat; min, max, step: Dfloat ): Dint;
begin
  DRAW$PANNEL_ADD_F := Flt_To_Pannel( ide, x, y, w, h, lab.body"address, lab.length, fv, min, max, step )
end DRAW$PANNEL_ADD_F;


function Text_To_Pannel( ide: Dint; x, y, w, h: Dfloat; t: $wild_pointer; l: Dint;
                        ptxt: $wild_pointer; len: integer ): Dint; external 'Draw_Text_To_Pannel';

[global 'Draw_Pas_Pannel_Text_Item']
function DRAW$PANNEL_ADD_TEXT( ide: Dint; x, y, w, h: Dfloat; in_var lab: string;
                               in_var txt: array[sz: integer] of char ): Dint;
begin
  DRAW$PANNEL_ADD_TEXT := Text_To_Pannel( ide, x, y, w, h, lab.body"address, lab.length, txt"address, sz )
end DRAW$PANNEL_ADD_TEXT;


function Frame_To_Pannel( ide: Dint; x, y, w, h: Dfloat; t: $wild_pointer; l: Dint; lw: Dfloat; st: Dint ): Dint;
external 'Draw_Frame_To_Pannel';

[global 'Draw_Pas_Pannel_Frame_Item']
function DRAW$PANNEL_ADD_FRAME( ide: Dint; x, y, w, h: Dfloat; in_var lab: string;
                                flw: Dfloat := 0.0; stl: Dint := 0 ): Dint;
begin
  DRAW$PANNEL_ADD_FRAME := Frame_To_Pannel( ide, x, y, w, h, lab.body"address, lab.length, flw, stl )
end DRAW$PANNEL_ADD_FRAME;



function New_Text_To_Pannel( ide, itm: Dint; ptxt: $wild_pointer; len: integer ): Dint; external 'Draw_Pannel_New_Text';

[global 'Draw_Pas_Pannel_New_Text']
function DRAW$PANNEL_NEW_TEXT( ide, itm: Dint; in_var txt: array[sz: integer] of char ): Dint;
begin
  DRAW$PANNEL_NEW_TEXT := New_Text_To_Pannel( ide, itm, txt"address, sz )
end DRAW$PANNEL_NEW_TEXT;



end DRAW$PASCAL_PANNEL.
