/*  P A S - P. WOLFERS SOFTWARE: V2.1-E OF 31-AUG-2009 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ long long int

/* Include the PAS environment file. */
#include "/usr/local/cpas/cpas_defs.h"

/* Define the local data section. */
static Blk( Rd, 304 ) = {
 16,  16, 100, 114,  97, 119,  36, 112,  97, 110, 110, 101, 108,  95, 102, 111,
110, 116,  81,  81,  47, 104, 111, 109, 101,  47, 119, 111, 108, 102, 101, 114,
115,  47,  83, 111, 102, 116,  47,  68, 114,  97, 119,  95,  70,  76,  84,  75,
 95, 115, 114,  99,  95,  86,  49,  46,  52,  67,  45,  98,  97, 115, 101,  47,
 68, 114,  97, 119,  95,  76, 105,  98, 114,  97, 114, 121,  47,  46,  47, 100,
114,  97, 119, 108, 105,  98,  95, 112,  97, 115,  95, 112,  97, 110, 110, 101,
108,  46, 112,  97, 115,  18,  18, 100, 114,  97, 119,  36, 112,  97, 110, 110,
101, 108,  95,  99, 114, 101,  97, 116, 101,  17,  17, 100, 114,  97, 119,  36,
112,  97, 110, 110, 101, 108,  95,  97, 100, 100,  95,  98,  17,  17, 100, 114,
 97, 119,  36, 112,  97, 110, 110, 101, 108,  95,  97, 100, 100,  95, 101,  18,
 18, 100, 114,  97, 119,  36, 112,  97, 110, 110, 101, 108,  95,  97, 100, 100,
 95, 101,  49,  17,  17, 100, 114,  97, 119,  36, 112,  97, 110, 110, 101, 108,
 95,  97, 100, 100,  95, 115,  17,  17, 100, 114,  97, 119,  36, 112,  97, 110,
110, 101, 108,  95,  97, 100, 100,  95, 105,  17,  17, 100, 114,  97, 119,  36,
112,  97, 110, 110, 101, 108,  95,  97, 100, 100,  95, 102,  20,  20, 100, 114,
 97, 119,  36, 112,  97, 110, 110, 101, 108,  95,  97, 100, 100,  95, 116, 101,
120, 116,  21,  21, 100, 114,  97, 119,  36, 112,  97, 110, 110, 101, 108,  95,
 97, 100, 100,  95, 102, 114,  97, 109, 101,  20,  20, 100, 114,  97, 119,  36,
112,  97, 110, 110, 101, 108,  95, 110, 101, 119,  95, 116, 101, 120, 116,   0
};


/* Function/procedure prototypes. */
void Draw_Pannel_Font(SL F_id, SL F_lbf, V F_nm, SL F_len, SL F_opt);
SL Draw_Pannel_Create(F F_w, F F_h, V F_t, SL F_l);
SL Draw_Bool_To_Pannel(SL F_ide, F F_x, F F_y, F F_w, F F_h, V F_t, SL F_l, UB *
F_bv);
SL Draw_Enum_To_Pannel(SL F_ide, F F_x, F F_y, F F_w, F F_h, V F_t, SL F_l, SL *
F_ev, SL F_sz, V *F_ptst, SL *F_ptl, SL F_min);
SL Draw_Str_To_Pannel(SL F_ide, F F_x, F F_y, F F_w, F F_h, V F_t, SL F_len, V F_sv
, V F_sz, SL F_cap, UB F_edi);
SL Draw_Int_To_Pannel(SL F_ide, F F_x, F F_y, F F_w, F F_h, V F_t, SL F_l, SL *F_iv
, SL F_min, SL F_max);
SL Draw_Flt_To_Pannel(SL F_ide, F F_x, F F_y, F F_w, F F_h, V F_t, SL F_l, F *F_fv
, F F_min, F F_max, F F_step);
SL Draw_Text_To_Pannel(SL F_ide, F F_x, F F_y, F F_w, F F_h, V F_t, SL F_l, V F_ptxt
, SL F_len);
SL Draw_Frame_To_Pannel(SL F_ide, F F_x, F F_y, F F_w, F F_h, V F_t, SL F_l, F F_lw
, SL F_st);
SL Draw_Pannel_New_Text(SL F_ide, SL F_itm, V F_ptxt, SL F_len);


/* Procedure/Function : " draw_Pannel_font "  */
void Draw_Pas_Pannel_Font(SL F_id, UB F_blb, V F_nam, SL F_opt){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+18;
  Ra.sl[3]=75; /* line # 75 */
  Draw_Pannel_Font(F_id,(SL)F_blb, F_nam+2,((UB *)F_nam)[1],F_opt);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " draw_Pannel_create "  */
SL Draw_Pas_Pannel_Create(F F_w, F F_h, V F_title){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+101;
  Ra.v[2]=Rd.s+18;
  Ra.sl[3]=86; /* line # 86 */
  Ret=Draw_Pannel_Create(F_w, F_h, F_title+2,((UB *)F_title)[1]);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " draw_Pannel_add_b "  */
SL Draw_Pas_Pannel_B_Item(SL F_ide, F F_x, F F_y, F F_w, F F_h, V F_lab, UB *F_bv)
{
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+121;
  Ra.v[2]=Rd.s+18;
  Ra.sl[3]=97; /* line # 97 */
  Ret=Draw_Bool_To_Pannel(F_ide, F_x, F_y, F_w, F_h, F_lab+2,((UB *)F_lab)[1],F_bv);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " draw_Pannel_add_e "  */
SL Draw_Pas_Pannel_E_Item(SL F_ide, F F_x, F F_y, F F_w, F F_h, V F_lab, SL *F_ev
, V F_stb, SL F_min){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register SL Rv0;
  V Rv1;
  register SL Rv2;
  V Rv3;
  SL Rv4;
  register int Rf0;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+140;
  Ra.v[2]=Rd.s+18;
  Ra.sl[3]=117; /* line # 117 */
  Rv0=((UB *)F_stb)[0];
  Rv1=PAS__NEW(Rv0*4+4);
  ((SL *)Rv1)[0]=Rv0;
  Rv2=((UB *)F_stb)[0];
  Rv3=PAS__NEW(Rv2*4+4);
  ((SL *)Rv3)[0]=Rv2;
  Ra.sl[3]=118; /* line # 118 */
  Rv4=1;
  for( Rf0=((UB *)F_stb)[0];Rf0>0;Rf0-- ) {
    Ra.sl[3]=119; /* line # 119 */
    ((V *)Rv3)[Rv4]=(((S *)F_stb)+(Rv4-1)*((SL)((UB *)F_stb)[1]+2)+4);
    ((SL *)Rv1)[Rv4]=((UB *)F_stb)[(Rv4-1)*((SL)((UB *)F_stb)[1]+2)+3];
    Rv4++;
  }
  Ra.sl[3]=120; /* line # 120 */
  Ret=Draw_Enum_To_Pannel(F_ide, F_x, F_y, F_w, F_h, F_lab+2,((UB *)F_lab)[1],F_ev,(
  (UB *)F_stb)[0],((V *)Rv3)+1,((SL *)Rv1)+1,F_min);
  Ra.sl[3]=122; /* line # 122 */
  PAS__DISPOSE(&Rv3);
  PAS__DISPOSE(&Rv1);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " draw_Pannel_add_e1 "  */
SL Draw_Pas_Pannel_E1_Item(SL F_ide, F F_x, F F_y, F F_w, F F_h, V F_lab, SL *F_ev
, V F_choice, SL F_dim, SL F_cap, SL F_nsz, SL F_min){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register SL Rv0;
  V Rv1;
  register SL Rv2;
  V Rv3;
  SL Rv4;
  register int Rf0;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+159;
  Ra.v[2]=Rd.s+18;
  Ra.sl[3]=141; /* line # 141 */
  if (F_nsz>F_dim) F_nsz=F_dim;
  Ra.sl[3]=142; /* line # 142 */
  Rv0=F_nsz;
  Rv1=PAS__NEW(Rv0*4+4);
  ((SL *)Rv1)[0]=Rv0;
  Rv2=F_nsz;
  Rv3=PAS__NEW(Rv2*4+4);
  ((SL *)Rv3)[0]=Rv2;
  Ra.sl[3]=143; /* line # 143 */
  Rv4=1;
  for( Rf0=F_nsz;Rf0>0;Rf0-- ) {
    Ra.sl[3]=144; /* line # 144 */
    ((V *)Rv3)[Rv4]=(((C *)F_choice)+(Rv4-1)*F_cap+1);
    ((SL *)Rv1)[Rv4]=(SL)((C *)F_choice)[(Rv4-1)*F_cap];
    Rv4++;
  }
  Ra.sl[3]=145; /* line # 145 */
  Ret=Draw_Enum_To_Pannel(F_ide, F_x, F_y, F_w, F_h, F_lab+2,((UB *)F_lab)[1],F_ev,
  F_nsz,((V *)Rv3)+1,((SL *)Rv1)+1,F_min);
  Ra.sl[3]=147; /* line # 147 */
  PAS__DISPOSE(&Rv3);
  PAS__DISPOSE(&Rv1);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " draw_Pannel_add_s "  */
SL Draw_Pas_Pannel_S_Item(SL F_ide, F F_x, F F_y, F F_w, F F_h, V F_lab, V F_sv, 
UB F_edi){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+179;
  Ra.v[2]=Rd.s+18;
  Ra.sl[3]=159; /* line # 159 */
  Ret=Draw_Str_To_Pannel(F_ide, F_x, F_y, F_w, F_h, F_lab+2,((UB *)F_lab)[1],F_sv+
2,((UB *)F_sv)+1,((UB *)F_sv)[0],F_edi);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " draw_Pannel_add_i "  */
SL Draw_Pas_Pannel_I_Item(SL F_ide, F F_x, F F_y, F F_w, F F_h, V F_lab, SL *F_iv
, SL F_min, SL F_max){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+198;
  Ra.v[2]=Rd.s+18;
  Ra.sl[3]=172; /* line # 172 */
  Ret=Draw_Int_To_Pannel(F_ide, F_x, F_y, F_w, F_h, F_lab+2,((UB *)F_lab)[1],F_iv,
  F_min, F_max);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " draw_Pannel_add_f "  */
SL Draw_Pas_Pannel_F_Item(SL F_ide, F F_x, F F_y, F F_w, F F_h, V F_lab, F *F_fv
, F F_min, F F_max, F F_step){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+217;
  Ra.v[2]=Rd.s+18;
  Ra.sl[3]=184; /* line # 184 */
  Ret=Draw_Flt_To_Pannel(F_ide, F_x, F_y, F_w, F_h, F_lab+2,((UB *)F_lab)[1],F_fv,
  F_min, F_max, F_step);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " draw_Pannel_add_text "  */
SL Draw_Pas_Pannel_Text_Item(SL F_ide, F F_x, F F_y, F F_w, F F_h, V F_lab, V F_txt
, SL F_sz){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+236;
  Ra.v[2]=Rd.s+18;
  Ra.sl[3]=195; /* line # 195 */
  Ret=Draw_Text_To_Pannel(F_ide, F_x, F_y, F_w, F_h, F_lab+2,((UB *)F_lab)[1],F_txt,
  F_sz);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " draw_Pannel_add_frame "  */
SL Draw_Pas_Pannel_Frame_Item(SL F_ide, F F_x, F F_y, F F_w, F F_h, V F_lab, F F_flw
, SL F_stl){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+258;
  Ra.v[2]=Rd.s+18;
  Ra.sl[3]=206; /* line # 206 */
  Ret=Draw_Frame_To_Pannel(F_ide, F_x, F_y, F_w, F_h, F_lab+2,((UB *)F_lab)[1],F_flw,
  F_stl);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " draw_Pannel_new_text "  */
SL Draw_Pas_Pannel_New_Text(SL F_ide, SL F_itm, V F_txt, SL F_sz){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+281;
  Ra.v[2]=Rd.s+18;
  Ra.sl[3]=216; /* line # 216 */
  Ret=Draw_Pannel_New_Text(F_ide, F_itm, F_txt,F_sz);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}
