(*

**********************************************************************
*                                                                    *
*                                                                    *
*                                                                    *
*             D R A W   -   C L I E N T   L I B R A R Y              *
*                                                                    *
*                P A S C A L (C P A S)   M O D U L E                 *
*                                                                    *
*                  (Basic Input Graphic Directives)                  *
*                    (Pascal Adaptation Support)                     *
*                                                                    *
*                    Draw Library Version V 2.4                      *
*                                                                    *
*                           28-Feb-2009                              *
*                                                                    *
*                               by                                   *
*                                                                    *
*                  Pierre Wolfers,  Institut Neel                    *
*                                                                    *
*          CNRS GRENOBLE,  25 Avenue des Martyrs, B.P. 166           *
*                                                                    *
*                     F 38042 GRENOBLE CEDEX 9                       *
*                                                                    *
*                           F R A N C E                              *
*                                                                    *
*                                                                    *
*                                                                    *
**********************************************************************



/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////

*)

%pragma code_option c_code '#include <draw/draw_apientry.h>';
module DRAW$PASCAL_INPUT;

const
  max_menu   = 32;                        { 32 entries Max / menu }


type
  Dfloat =  single;
  Dint   = cc__int;
  Dbool  = boolean;

  Draw_Menu( dim, cap: byte ) = array[1..dim] of string( cap ); { Define the menu type }



{*********************************************************************}

procedure draw_message( pt: $wild_pointer; l: Dint );
external 'Draw_Message';

[global 'Draw_Pas_Message']
procedure Draw$Message( in_var str: string );
begin
  draw_message( str.body"address, str.length )
end Draw$Message;


{*********************************************************************}

procedure draw_string_display( pt: $wild_pointer; l: Dint );
external 'Draw_String_Display';

[global 'Draw_Pas_Str_Dspl']
procedure Draw$String_Display( in_var str: string );
begin
  draw_string_display( str.body"address, str.length )
end Draw$String_Display;


{*********************************************************************}

function  draw_get_choice( len: Dint; ptstb, ptsln: $wild_pointer ): Dint;
external 'Draw_Get_Choice';


[global 'Draw_Pas_Get_Arr_Choice']
function Draw$Get_Choice( in_var title: string;
                          in_var  menu: array[dim: integer, cap: integer] of char;
                                   nsz: Dint := 0 ): Dint;
var
  stb: array[0..max_menu] of $wild_pointer;
  ltb: array[0..max_menu] of Dint;
  len: integer;

begin
  stb[0] := title.body"address;
  ltb[0] := title.length;
  if dim > max_menu then len := max_menu
                    else len := dim;
  if (nsz > 0) and (nsz < len) then len := nsz;
  for i := 1 to len do
  begin
    stb[i] := menu[i,2]"address;
    ltb[i] := ORD( menu[i,1] );
  end;
  Draw$Get_Choice := draw_get_choice( len, stb"address, ltb"address )
end Draw$Get_Choice;



[global 'Draw_Pas_Get_Str_Choice']
function Draw$Get_Choice( in_var title: string;
                          in_var menu: array[dim: integer] of ^string;
                                 nsz: Dint := 0 ): Dint;
var
  stb: array[0..max_menu] of $wild_pointer;
  ltb: array[0..max_menu] of Dint;
  len: integer;

begin
  stb[0] := title.body"address;
  ltb[0] := title.length;
  if dim > max_menu then len := max_menu
                    else len := dim;
  if (nsz > 0) and (nsz < len) then len := nsz;
  for i := 1 to len do
    with menu[i]^ do
    begin
      stb[i] := body"address;
      ltb[i] := length
    end;
  Draw$Get_Choice := draw_get_choice( len, stb"address, ltb"address )
end Draw$Get_Choice;



[global 'Draw_Pas_Get_M_Choice']
function Draw$Get_Choice( in_var title: string;
                          in_var  menu: Draw_menu; nsz: integer := 0 ): Dint;
var
  stb: array[0..max_menu] of $wild_pointer;
  ltb: array[0..max_menu] of Dint;
  len: integer;

begin
  stb[0] := title.body"address;
  ltb[0] := title.length;
  if menu.dim > max_menu then len := max_menu
                         else len := menu.dim;
  if (nsz > 0) and (nsz < len) then len := nsz;
  for i := 1 to len do
  with menu[i] do
  begin
    stb[i] := body"address;
    ltb[i] := length
  end;
  Draw$Get_Choice := draw_get_choice( len, stb"address, ltb"address )
end Draw$Get_Choice;



{*********************************************************************}

function draw_get_answerd( pt: $wild_pointer; len: Dint ): Dint;
external 'Draw_Get_Answerd';

[global 'Draw_Pas_Get_Answerd']
function Draw$Get_Answerd( in_var title: string ): Dint;
{ Result No Answed => -1, No => 0, Yes => 1 }
var
  len: Dint;

begin
  len := title.length; 
  Draw$Get_Answerd := draw_get_answerd( title.body"address, len )
end Draw$Get_Answerd;



{*********************************************************************}

function draw_get_string( pti: $wild_pointer; lti: Dint;
                          pdf: $wild_pointer; ldf: Dint;
                          pva: $wild_pointer; cap: Dint ): Dint;
external 'Draw_Get_String';

[global 'Draw_Pas_Get_String']
function Draw$Get_String( in_var title, defst: string; var resul: string ): Dint;
var
  tlen, dlen, rcap: Dint;

begin
  tlen := title.length;
  dlen := defst.length;
  rcap := resul.capacity;
  resul.length := draw_get_string( title.body"address, tlen,
                                   defst.body"address, dlen,
                                   resul.body"address, rcap );
  Draw$Get_String := resul.length
end Draw$Get_String;



{*********************************************************************}

function draw_get_value( pti: $wild_pointer; lti: Dint;
                         var val: single; lw, up: Dfloat ): Dint;
external 'Draw_Get_Value';

[global 'Draw_Pas_Get_Value']
function Draw$Get_Value( in_var title: string; var val: Dfloat; lw, up: Dfloat ): Dint;
var
  tlen: dint;

begin
  tlen := title.length;
  Draw$Get_Value := draw_get_value( title.body"address, tlen, val, lw, up )
end Draw$Get_Value;



{*********************************************************************}

function draw_get_color( pti: $wild_pointer; lti: Dint; var r, g, b: Dfloat ): Dint;
external 'Draw_Get_Color';

[global 'Draw_Pas_Get_Color']
function Draw$Get_Color( in_var title: string; var r, g, b: Dfloat ): Dint;
var
  tlen: dint;

begin
  tlen := title.length;
  Draw$Get_Color := draw_get_color( title.body"address, tlen, r, g, b )
end Draw$Get_Color;



{*********************************************************************}

function draw_select_file(      pti: $wild_pointer; lti: Dint;
                                pfs: $wild_pointer; pfl: $wild_pointer; len: Dint;
                           var  fdx: Dint;
                                pdf: $wild_pointer; ldf: Dint;
                                res: $wild_pointer; rec, wf: Dint ): Dint;
external 'Draw_Select_File';


[global 'Draw_Pas_Select_File']
function Draw$Select_File( in_var title: string;
                           in_var filtr: array[dim: integer] of ^string;
                           in_var defst: string;
                              var resul: string;
                              var flidx: integer;
                                  nwflg, nszfl: Dint := 0 ): Dint;
var
  fltrs: array[1..max_menu] of $wild_pointer;
  fltrl: array[1..max_menu] of Dint;
  len, fidx: Dint;
  tlen, rcap, rlen, dlen: Dint;

begin
  if dim > max_menu then len := max_menu
                    else len := dim;
  tlen := title.length;
  rcap := resul.capacity;
  dlen := defst.length;
  if (nszfl > 0) and (nszfl < len) then len := nszfl;
  for i := 1 to len do
    with filtr[i]^ do
    begin
      fltrs[i] := body"address;
      fltrl[i] := length
    end;
  fidx := flidx - 1;
  if (fidx < 0) or (fidx >= len) then fidx := 0;  

  resul.length := draw_select_file( title.body"address, tlen,
                                    fltrs"address,      fltrl"address,    len,
                                    fidx,
                                    defst.body"address, dlen,
                                    resul.body"address, rcap, nwflg );
  flidx := fidx + 1;
  Draw$Select_File := resul.length
end Draw$Select_File;



[global 'Draw_Pas_Select_MFile']
function Draw$Select_File( in_var title: string;
                           in_var filtr: Draw_menu;
                           in_var defst: string;
                              var resul: string;
                              var flidx: integer;
                                  nwflg, nszfl: Dint := 0 ): Dint;
var
  fltrs: array[1..max_menu] of $wild_pointer;
  fltrl: array[1..max_menu] of Dint;
  len, fidx: Dint;
  tlen, rcap, rlen, dlen: Dint;

begin
  if filtr.dim > max_menu then len := max_menu
                          else len := filtr.dim;
  tlen := title.length;
  rcap := resul.capacity;
  dlen := defst.length;
  if (nszfl > 0) and (nszfl < len) then len := nszfl;
  for i := 1 to len do
    with filtr[i] do
    begin
      fltrs[i] := body"address;
      fltrl[i] := length
    end;
  fidx := flidx - 1;
  if (fidx < 0) or (fidx >= len) then fidx := 0;  

  resul.length := draw_select_file( title.body"address, tlen,
                                    fltrs"address,      fltrl"address,    len,
                                    fidx,
                                    defst.body"address, dlen,
                                    resul.body"address, rcap, nwflg );
  flidx := fidx + 1;
  Draw$Select_File := resul.length
end Draw$Select_File;



{*********************************************************************}



end.

