/*  P A S - P. WOLFERS SOFTWARE: V2.1-E OF 31-AUG-2009 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ long long int
#include <draw/draw_apientry.h>

/* Include the PAS environment file. */
#include "/usr/local/cpas/cpas_defs.h"

/* Define the local data section. */
static Blk( Rd, 272 ) = {
 12,  12, 100, 114,  97, 119,  36, 109, 101, 115, 115,  97, 103, 101,  78,  78,
 47, 104, 111, 109, 101,  47, 119, 111, 108, 102, 101, 114, 115,  47,  83, 111,
102, 116,  47,  68, 114,  97, 119,  95,  70,  76,  84,  75,  95, 115, 114,  99,
 95,  86,  49,  46,  52,  67,  45,  98,  97, 115, 101,  47,  68, 114,  97, 119,
 95,  76, 105,  98, 114,  97, 114, 121,  47, 100, 114,  97, 119, 108, 105,  98,
 95, 112,  97, 115,  95, 105, 110, 112, 117, 116,  46, 112,  97, 115,  19,  19,
100, 114,  97, 119,  36, 115, 116, 114, 105, 110, 103,  95, 100, 105, 115, 112,
108,  97, 121,  15,  15, 100, 114,  97, 119,  36, 103, 101, 116,  95,  99, 104,
111, 105,  99, 101,  15,  15, 100, 114,  97, 119,  36, 103, 101, 116,  95,  99,
104, 111, 105,  99, 101,  15,  15, 100, 114,  97, 119,  36, 103, 101, 116,  95,
 99, 104, 111, 105,  99, 101,  16,  16, 100, 114,  97, 119,  36, 103, 101, 116,
 95,  97, 110, 115, 119, 101, 114, 100,  15,  15, 100, 114,  97, 119,  36, 103,
101, 116,  95, 115, 116, 114, 105, 110, 103,  14,  14, 100, 114,  97, 119,  36,
103, 101, 116,  95, 118,  97, 108, 117, 101,  14,  14, 100, 114,  97, 119,  36,
103, 101, 116,  95,  99, 111, 108, 111, 114,  16,  16, 100, 114,  97, 119,  36,
115, 101, 108, 101,  99, 116,  95, 102, 105, 108, 101,  16,  16, 100, 114,  97,
119,  36, 115, 101, 108, 101,  99, 116,  95, 102, 105, 108, 101,   0,   0,   0
};


/* Function/procedure prototypes. */
void Draw_Message(V F_pt, SL F_l);
void Draw_String_Display(V F_pt, SL F_l);
SL Draw_Get_Choice(SL F_len, V F_ptstb, V F_ptsln);
SL Draw_Get_Answerd(V F_pt, SL F_len);
SL Draw_Get_String(V F_pti, SL F_lti, V F_pdf, SL F_ldf, V F_pva, SL F_cap);
SL Draw_Get_Value(V F_pti, SL F_lti, F *F_val, F F_lw, F F_up);
SL Draw_Get_Color(V F_pti, SL F_lti, F *F_r, F *F_g, F *F_b);
SL Draw_Select_File(V F_pti, SL F_lti, V F_pfs, V F_pfl, SL F_len, SL *F_fdx, V F_pdf
, SL F_ldf, V F_res, SL F_rec, SL F_wf);


/* Procedure/Function : " draw_Message "  */
void Draw_Pas_Message(V F_str){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=83; /* line # 83 */
  Draw_Message(F_str+2,((UB *)F_str)[1]);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " draw_String_display "  */
void Draw_Pas_Str_Dspl(V F_str){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+94;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=95; /* line # 95 */
  Draw_String_Display(F_str+2,((UB *)F_str)[1]);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " draw_Get_choice "  */
SL Draw_Pas_Get_Arr_Choice(V F_title, V F_menu, SL F_dim, SL F_cap, SL F_nsz){
  /* Define the automatic variable space. */
  Blk( Ra, 280 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  register int Rf0;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+115;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=115; /* line # 115 */
  Ra.v[4]=F_title+2;
  Ra.sl[37]=((UB *)F_title)[1];
  if (F_dim>32) Rv0=32;
  else Rv0=F_dim;
  if (F_nsz>0&&F_nsz<Rv0) Rv0=F_nsz;
  Ra.sl[3]=120; /* line # 120 */
  Rv1=1;
  for( Rf0=Rv0;Rf0>0;Rf0-- ) {
    Ra.v[Rv1+4]=(((C *)F_menu)+(Rv1-1)*F_cap+1);
    Ra.sl[Rv1+37]=(SL)((C *)F_menu)[(Rv1-1)*F_cap];
    Rv1++;
  }
  Ra.sl[3]=125; /* line # 125 */
  Ret=Draw_Get_Choice(Rv0, Ra.s+16,Ra.s+148);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " draw_Get_choice "  */
SL Draw_Pas_Get_Str_Choice(V F_title, V F_menu, SL F_dim, SL F_nsz){
  /* Define the automatic variable space. */
  Blk( Ra, 280 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  register V Rv2;
  register int Rf0;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+132;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=140; /* line # 140 */
  Ra.v[4]=F_title+2;
  Ra.sl[37]=((UB *)F_title)[1];
  if (F_dim>32) Rv0=32;
  else Rv0=F_dim;
  if (F_nsz>0&&F_nsz<Rv0) Rv0=F_nsz;
  Ra.sl[3]=145; /* line # 145 */
  Rv1=1;
  for( Rf0=Rv0;Rf0>0;Rf0-- ) {
    Rv2=((V *)F_menu)[Rv1-1];
    Ra.v[Rv1+4]=Rv2+2;
    Ra.sl[Rv1+37]=((UB *)Rv2)[1];
    Rv1++;
  }
  Ra.sl[3]=151; /* line # 151 */
  Ret=Draw_Get_Choice(Rv0, Ra.s+16,Ra.s+148);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " draw_Get_choice "  */
SL Draw_Pas_Get_M_Choice(V F_title, V F_menu, SL F_nsz){
  /* Define the automatic variable space. */
  Blk( Ra, 280 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  register V Rv2;
  register int Rf0;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+149;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=165; /* line # 165 */
  Ra.v[4]=F_title+2;
  Ra.sl[37]=((UB *)F_title)[1];
  if (((UB *)F_menu)[0]>32) Rv0=32;
  else Rv0=((UB *)F_menu)[0];
  if (F_nsz>0&&F_nsz<Rv0) Rv0=F_nsz;
  Ra.sl[3]=170; /* line # 170 */
  Rv1=1;
  for( Rf0=Rv0;Rf0>0;Rf0-- ) {
    Rv2=(((S *)F_menu)+(Rv1-1)*((SL)((UB *)F_menu)[1]+2)+2);
    Ra.v[Rv1+4]=Rv2+2;
    Ra.sl[Rv1+37]=((UB *)Rv2)[1];
    Rv1++;
  }
  Ra.sl[3]=176; /* line # 176 */
  Ret=Draw_Get_Choice(Rv0, Ra.s+16,Ra.s+148);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " draw_Get_answerd "  */
SL Draw_Pas_Get_Answerd(V F_title){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+166;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=193; /* line # 193 */
  Rv0=((UB *)F_title)[1];
  Ret=Draw_Get_Answerd(F_title+2,Rv0);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " draw_Get_string "  */
SL Draw_Pas_Get_String(V F_title, V F_defst, V F_resul){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+184;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=212; /* line # 212 */
  Rv0=((UB *)F_title)[1];
  Rv1=((UB *)F_defst)[1];
  Rv2=((UB *)F_resul)[0];
  ((UB *)F_resul)[1]=Draw_Get_String(F_title+2,Rv0, F_defst+2,Rv1, F_resul+2,Rv2);
  Ra.sl[3]=218; /* line # 218 */
  Ret=((UB *)F_resul)[1];
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " draw_Get_value "  */
SL Draw_Pas_Get_Value(V F_title, F *F_val, F F_lw, F F_up){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+201;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=235; /* line # 235 */
  Rv0=((UB *)F_title)[1];
  Ret=Draw_Get_Value(F_title+2,Rv0, F_val,F_lw, F_up);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " draw_Get_color "  */
SL Draw_Pas_Get_Color(V F_title, F *F_r, F *F_g, F *F_b){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+217;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=252; /* line # 252 */
  Rv0=((UB *)F_title)[1];
  Ret=Draw_Get_Color(F_title+2,Rv0, F_r,F_g,F_b);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " draw_Select_file "  */
SL Draw_Pas_Select_File(V F_title, V F_filtr, SL F_dim, V F_defst, V F_resul, SL
*F_flidx, SL F_nwflg, SL F_nszfl){
  /* Define the automatic variable space. */
  Blk( Ra, 272 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;
  register V Rv5;
  SL Rv6;
  register int Rf0;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+233;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=282; /* line # 282 */
  if (F_dim>32) Rv0=32;
  else Rv0=F_dim;
  Rv1=((UB *)F_title)[1];
  Rv2=((UB *)F_resul)[0];
  Rv3=((UB *)F_defst)[1];
  Ra.sl[3]=287; /* line # 287 */
  if (F_nszfl>0&&F_nszfl<Rv0) Rv0=F_nszfl;
  Rv4=1;
  for( Rf0=Rv0;Rf0>0;Rf0-- ) {
    Rv5=((V *)F_filtr)[Rv4-1];
    Ra.v[Rv4+3]=Rv5+2;
    Ra.sl[3]=292; /* line # 292 */
    Ra.sl[Rv4+35]=((UB *)Rv5)[1];
    Rv4++;
  }
  Rv6=(*F_flidx)-1;
  if (Rv6<0||Rv6>=Rv0) Rv6=0;
  Ra.sl[3]=297; /* line # 297 */
  ((UB *)F_resul)[1]=Draw_Select_File(F_title+2,Rv1, Ra.s+16,Ra.s+144,Rv0, &Rv6,
  F_defst+2,Rv3, F_resul+2,Rv2, F_nwflg);
  Ra.sl[3]=302; /* line # 302 */
  (*F_flidx)=Rv6+1;
  Ret=((UB *)F_resul)[1];
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " draw_Select_file "  */
SL Draw_Pas_Select_MFile(V F_title, V F_filtr, V F_defst, V F_resul, SL *F_flidx
, SL F_nwflg, SL F_nszfl){
  /* Define the automatic variable space. */
  Blk( Ra, 272 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;
  register V Rv5;
  SL Rv6;
  register int Rf0;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+251;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=322; /* line # 322 */
  if (((UB *)F_filtr)[0]>32) Rv0=32;
  else Rv0=((UB *)F_filtr)[0];
  Rv1=((UB *)F_title)[1];
  Rv2=((UB *)F_resul)[0];
  Rv3=((UB *)F_defst)[1];
  Ra.sl[3]=327; /* line # 327 */
  if (F_nszfl>0&&F_nszfl<Rv0) Rv0=F_nszfl;
  Rv4=1;
  for( Rf0=Rv0;Rf0>0;Rf0-- ) {
    Rv5=(((S *)F_filtr)+(Rv4-1)*((SL)((UB *)F_filtr)[1]+2)+2);
    Ra.v[Rv4+3]=Rv5+2;
    Ra.sl[3]=332; /* line # 332 */
    Ra.sl[Rv4+35]=((UB *)Rv5)[1];
    Rv4++;
  }
  Rv6=(*F_flidx)-1;
  if (Rv6<0||Rv6>=Rv0) Rv6=0;
  Ra.sl[3]=337; /* line # 337 */
  ((UB *)F_resul)[1]=Draw_Select_File(F_title+2,Rv1, Ra.s+16,Ra.s+144,Rv0, &Rv6,
  F_defst+2,Rv3, F_resul+2,Rv2, F_nwflg);
  Ra.sl[3]=342; /* line # 342 */
  (*F_flidx)=Rv6+1;
  Ret=((UB *)F_resul)[1];
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}
