/*  P A S - P. WOLFERS SOFTWARE: V2.1-E OF 31-AUG-2009 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ long long int
#include <draw/draw_apientry.h>

/* Include the PAS environment file. */
#include "/usr/local/cpas/cpas_defs.h"

/* Define the local data section. */
static Blk( Rd, 248 ) = {
 19,  19, 100, 114,  97, 119,  36, 115, 101, 116,  95,  97, 120, 105, 115,  95,
116, 105,  99, 107, 115,  84,  84,  47, 104, 111, 109, 101,  47, 119, 111, 108,
102, 101, 114, 115,  47,  83, 111, 102, 116,  47,  68, 114,  97, 119,  95,  70,
 76,  84,  75,  95, 115, 114,  99,  95,  86,  49,  46,  52,  67,  45,  98,  97,
115, 101,  47,  68, 114,  97, 119,  95,  76, 105,  98, 114,  97, 114, 121,  47,
 46,  47, 100, 114,  97, 119, 108, 105,  98,  95, 112,  97, 115,  95,  97, 120,
105, 115,  95,  98,  97, 115, 101,  46, 112,  97, 115,  19,  19, 100, 114,  97,
119,  36, 103, 101, 116,  95,  97, 120, 105, 115,  95, 116, 105,  99, 107, 115,
 18,  18, 100, 114,  97, 119,  36, 115, 101, 116,  95,  97, 120, 105, 115,  95,
117, 110, 105, 116,  18,  18, 100, 114,  97, 119,  36, 103, 101, 116,  95,  97,
120, 105, 115,  95, 117, 110, 105, 116,  19,  19, 100, 114,  97, 119,  36, 115,
101, 116,  95,  97, 120, 105, 115,  95, 102, 108,  97, 103, 115,  19,  19, 100,
114,  97, 119,  36, 103, 101, 116,  95,  97, 120, 105, 115,  95, 102, 108,  97,
103, 115,  16,  16, 100, 114,  97, 119,  36, 101,  97, 115, 121,  95,  98, 111,
120,  95,  50, 100,  18,  18, 100, 114,  97, 119,  36, 103, 101, 116,  95,  98,
111, 120,  95, 118,  97, 108, 117, 101
};


/* Function/procedure prototypes. */
void Draw_Set_Axis_Value(SL F_ia, SL F_cd, SL F_n, V F_p1, V F_p2, V F_p3, V F_p4
, V F_p5, V F_p6, V F_p7);
SL Draw_Get_Axis_Value(SL F_ia, SL F_cd, SL F_n, V F_p1, V F_p2, V F_p3, V F_p4, 
V F_p5, V F_p6, V F_p7);
SL Draw__Easy_Box_2D(F F_ox, F F_oy, F F_sx, F F_sy, V F_pmm, V F_pux, V F_puy, 
SL F_lx, SL F_ly, SL F_ns);
SL Draw_Get_Box_Value(SL F_box, SL F_cd, SL F_n, V F_ptb);


/* Procedure/Function : " draw_Set_axis_ticks "  */
void Draw_Set_Axis_Ticks(SL F_ia, SL F_n, SL F_k, V F_tfre, SL F__Sf, V F_tknd, 
SL F__Sk, V F_tsiz, SL F__Sl){
  /* Define the automatic variable space. */
  Blk( Ra, 24 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+21;
  Ra.sl[3]=89; /* line # 89 */
  if (F_k>F__Sf) F_k=F__Sf;
  if (F_k>F__Sk) F_k=F__Sk;
  if (F_k>F__Sl) F_k=F__Sl;
  Ra.sl[4]=F_n;
  Draw_Set_Axis_Value(F_ia,1, F_k, Ra.s+16,F_tfre,F_tknd,F_tsiz,NULL,NULL,NULL);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " draw_Get_axis_ticks "  */
SL Draw_Get_Axis_Ticks(SL F_ia, SL *F_n, SL F_k, V F_tfre, SL F__Sf, V F_tknd, SL
F__Sk, V F_tsiz, SL F__Sl){
  /* Define the automatic variable space. */
  Blk( Ra, 24 );

  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+107;
  Ra.v[2]=Rd.s+21;
  Ra.sl[3]=112; /* line # 112 */
  if ((*F_n)>F__Sf) F_k=F__Sf;
  if ((*F_n)>F__Sk) F_k=F__Sk;
  if ((*F_n)>F__Sl) F_k=F__Sl;
  Ret=Draw_Get_Axis_Value(F_ia,1, (*F_n),Ra.s+16,F_tfre,F_tknd,F_tsiz,NULL,NULL,
  NULL);
  Ra.sl[3]=118; /* line # 118 */
  if (((V) F_n)!=NULL) (*F_n)=Ra.sl[4];
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " draw_Set_axis_unit "  */
void Draw_Set_Axis_Unit(SL F_ia, V F_unit){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+128;
  Ra.v[2]=Rd.s+21;
  Ra.sl[3]=125; /* line # 125 */
  Draw_Set_Axis_Value(F_ia,3,((UB *)F_unit)[1],F_unit+2,NULL,NULL,NULL,NULL,NULL,
  NULL);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " draw_Get_axis_unit "  */
SL Draw_Get_Axis_Unit(SL F_ia, V F_unit){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+148;
  Ra.v[2]=Rd.s+21;
  Ra.sl[3]=134; /* line # 134 */
  Rv0=Draw_Get_Axis_Value(F_ia,3,((UB *)F_unit)[0]-1, F_unit+2,NULL,NULL,NULL,NULL,
  NULL,NULL);
  if (Rv0>=((UB *)F_unit)[0]) ((UB *)F_unit)[1]=((UB *)F_unit)[0]-1;
  else((UB *)F_unit)[1]=Rv0;
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " draw_Set_axis_flags "  */
void Draw_Set_Axis_Flags(SL F_ia, SL F_flg){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+168;
  Ra.v[2]=Rd.s+21;
  Ra.sl[3]=145; /* line # 145 */
  Draw_Set_Axis_Value(F_ia,0, F_flg,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " draw_Get_axis_flags "  */
SL Draw_Get_Axis_Flags(SL F_ia){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+189;
  Ra.v[2]=Rd.s+21;
  Ra.sl[3]=152; /* line # 152 */
  Ret=Draw_Get_Axis_Value(F_ia,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " draw_Easy_box_2d "  */
SL Draw_Easy_Box_2D(F F_ox, F F_oy, F F_sx, F F_sy, F F_mx1, F F_mx2, F F_my1, F
F_my2, V F_ux, V F_uy, SL F_ns){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  SL Rv1;
  V Rv2;
  SL Rv3;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+210;
  Ra.v[2]=Rd.s+21;
  Ra.sl[3]=170; /* line # 170 */
  Ra.f[4]=F_mx1;
  Ra.f[5]=F_mx2;
  Ra.f[6]=F_my1;
  Ra.f[7]=F_my2;
  if (F_ux!=NULL) {
    Rv0=F_ux+2;
    Rv1=((UB *)F_ux)[1];
  }
  else {
    Rv0=NULL;
    Rv1=0;
  }
  if (F_uy!=NULL) {
    Rv2=F_uy+2;
    Rv3=((UB *)F_uy)[1];
  }
  else {
    Rv2=NULL;
    Rv3=0;
  }
  Ra.sl[3]=176; /* line # 176 */
  Ret=Draw__Easy_Box_2D(F_ox, F_oy, F_sx, F_sy, Ra.s+16,Rv0, Rv2, Rv1, Rv3, F_ns);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " draw_Get_box_value "  */
SL Draw_Pas_Get_Box_Value(SL F_box, SL F_cd, V F_itb, SL F_n){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+228;
  Ra.v[2]=Rd.s+21;
  Ra.sl[3]=186; /* line # 186 */
  Ret=Draw_Get_Box_Value(F_box, F_cd, F_n, F_itb);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}
