C
C**********************************************************************
C*                                                                    *
C*                                                                    *
C*                                                                    *
C*             D R A W   -   C L I E N T   L I B R A R Y              *
C*                                                                    *
C*                   F O R T R A N     M O D U L E                    *
C*                                                                    *
C*                 (Main Control Graphic Directives)                  *
C*                   (fortran Adaptation Support)                     *
C*                                                                    *
C*                    Draw Library Version V 2.4                      *
C*                                                                    *
C*                               by                                   *
C*                                                                    *
C*          Pierre Wolfers, Laboratoire de Cristallographie           *
C*                                                                    *
C*          CNRS GRENOBLE,  25 Avenue des Martyrs, B.P. 166           *
C*                                                                    *
C*                     F 38042 GRENOBLE CEDEX 9                       *
C*                                                                    *
C*                           F R A N C E                              *
C*                                                                    *
C*                                                                    *
C*                                                                    *
C**********************************************************************
C
C
C
C/////////////////////////////////////////////////////////////////////////
C//                                                                     //
C//                                                                     //
C// This license described in this file overrides all other licenses    //
C// that might be specified in other files for this library.            //
C//                                                                     //
C// This library is free software; you can redistribute it and/or       //
C// modify it under the terms of the GNU Lesser General Public          //
C// License as published by the Free Software Foundation; either        //
C// version 2.1 of the License, or (at your option) any later version.  //
C//                                                                     //
C// This library is distributed in the hope that it will be useful,     //
C// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
C// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
C// Library General Public License for more details.                    //
C//                                                                     //
C// You should have received a copy of the GNU Lesser General Public    //
C// License along with this library (see COPYING.LIB); if not, write to //
C// the Free Software Foundation :                                      //
C//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
C//                                                                     //
C/////////////////////////////////////////////////////////////////////////
C
C
	SUBROUTINE DRAW_SET_MENU_SPC( CD, ID, NAME, KEY )
	IMPLICIT NONE
	INTEGER       CD, ID, KEY
	CHARACTER*(*) NAME

	EXTERNAL DRAW__SET_MENU_SPC

	CALL DRAW__SET_MENU_SPC( CD, ID, NAME, LEN( NAME ), KEY )

	END
C
C================================================================================
C
	SUBROUTINE DRAW_INIT( XP, YP, UNIT, PRGNAM )
	IMPLICIT NONE
	REAL          XP, YP
	INTEGER       UNIT, L
	CHARACTER*(*) PRGNAM

	EXTERNAL DRAW__INIT

	INTEGER  I

	CALL DRAW__INIT( XP, YP, UNIT, PRGNAM, LEN( PRGNAM ) )

	RETURN
	END
C
C================================================================================
C
	LOGICAL FUNCTION DRAW_PICTURE3( TITLE, X, Y, Z, SCALE, MARGIN )
	IMPLICIT NONE
	CHARACTER*(*) TITLE
	REAL          X, Y, Z
	LOGICAL*1     SCALE, MARGIN

	EXTERNAL DRAW__PICTURE
	LOGICAL  DRAW__PICTURE

	DRAW_PICTURE3 = DRAW__PICTURE( TITLE, LEN( TITLE ),
     &                                 X, Y, Z, SCALE, MARGIN )

	RETURN
	END
C
C================================================================================
C
	LOGICAL FUNCTION DRAW_PICTURE( TITLE, X, Y, SCALE, MARGIN )
	IMPLICIT NONE
	CHARACTER*(*) TITLE
	REAL          X, Y
	LOGICAL*1     SCALE, MARGIN

	EXTERNAL DRAW__PICTURE
	LOGICAL  DRAW__PICTURE

	DRAW_PICTURE = DRAW__PICTURE( TITLE, LEN( TITLE ),
     &                                X, Y, 0.0, SCALE, MARGIN )

	RETURN
	END
C
C================================================================================
C
	SUBROUTINE DRAW_SERVER_ID_NAME( STR, X, Y, SCALE, MARGIN )
	IMPLICIT NONE
	CHARACTER*(*) STR
	REAL          X, Y
	LOGICAL*1     SCALE, MARGIN

	EXTERNAL DRAW__SERVER_ID_NAME

	CALL DRAW__SERVER_ID_NAME( STR, LEN( STR ) )

	RETURN
	END
C
C================================================================================
C
	SUBROUTINE DRAW_STRING( X, Y, THETA, HGT, STRG, FLG )
	IMPLICIT NONE
	REAL          X, Y, THETA, HGT
        INTEGER       FLG
	CHARACTER*(*) STRG

	EXTERNAL DRAW__STRING

	CALL DRAW__STRING( X, Y, THETA, HGT, STRG, LEN( STRG ), FLG )
	RETURN

	END

C
C================================================================================
C
	SUBROUTINE DRAW_TEXT_IN_BOX( X, Y, BX, BY, HC, STRG, HAL, FLG )
	IMPLICIT NONE
	REAL          X, Y, BX, BY, HC
        INTEGER       HAL, FLG
	CHARACTER*(*) STRG

	EXTERNAL DRAW__TEXT_IN_BOX

	CALL DRAW__TEXT_IN_BOX( X, Y, BX, BY, HC, STRG, LEN( STRG ),
     &                          HAL, FLG )
	RETURN

	END

C
C================================================================================
C
	INTEGER FUNCTION DRAW_INSTALL_FONT( IFNT, ISTL, FNAM )
	IMPLICIT NONE
        INTEGER       IFNT, ISTL
	CHARACTER*(*) FNAM

	EXTERNAL DRAW__INSTALL_FONT
	INTEGER  DRAW__INSTALL_FONT

	DRAW_INSTALL_FONT = DRAW__INSTALL_FONT( IFNT, ISTL,
     &                                          FNAM, LEN( FNAM ) )

	END

C
C================================================================================
C
	INTEGER FUNCTION DRAW_FONT_INFO( IFNT, ISTL, FNAM, ILN )
	IMPLICIT NONE
        INTEGER       IFNT, ISTL, ILN
	CHARACTER*(*) FNAM

	EXTERNAL DRAW__FONT_INFO
	INTEGER  DRAW__FONT_INFO

	DRAW_FONT_INFO = DRAW__FONT_INFO( IFNT, ISTL, FNAM,
     &                                    LEN( FNAM ), ILN )

	END

C
C================================================================================
C
	INTEGER FUNCTION DRAW_GET_STRING_BOX( IFNT, STR, HG, BX, BY )
	IMPLICIT NONE
        INTEGER       IFNT
	CHARACTER*(*) STR
	REAL          HG, BX, BY

	EXTERNAL DRAW__GET_STRING_BOX
	INTEGER  DRAW__GET_STRING_BOX

	DRAW_GET_STRING_BOX =
     &     DRAW__GET_STRING_BOX( IFNT, STR, LEN( STR ), HG, BX, BY )

	END

C
C================================================================================
C
