/************************************************************************
*                                                                       *
*                                                                       *
*                                                                       *
*               D R A W   -   C L I E N T   L I B R A R Y               *
*                                                                       *
*               (Fortran Pannel Input Graphic Directives)               *
*                     (Fortran Language Support)                        *
*                                                                       *
*                     Draw Library Version V 2.4                        *
*                                                                       *
*                            31-Jan-2009                                *
*                                                                       *
*                                by                                     *
*                                                                       *
*                   Pierre Wolfers,  Institut Neel                      *
*                                                                       *
*           CNRS GRENOBLE,  25 Avenue des Martyrs, B.P. 166             *
*                                                                       *
*                      F 38042 GRENOBLE CEDEX 9                         *
*                                                                       *
*                            F R A N C E                                *
*                                                                       *
*                                                                       *
*                                                                       *
************************************************************************/



/*///////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
///////////////////////////////////////////////////////////////////////*/




#include <draw/draw_common.h>
#include <draw/draw_env.h>      /* Load the DRAW library Environment */



void DRW_API( pannel_align )( int *ide, int *aln )
{
  Draw_Pannel_Align( *ide, *aln );
}



void DRW_API( pannel_fsize )( int *ide, int *lbf, float *sz )
{
  Draw_Pannel_Fsize( *ide, *lbf, *sz );
}


void DRW_API( _pannel_font )( int *ide, int *lbf, char *nam, int *len, int *opt )
{
  Draw_Pannel_Font( *ide, *lbf, nam, *len, *opt );
}


int DRW_API( _pannel_create )( float *w, float *h, char* title, int *len )
{
  return Draw_Pannel_Create( *w, *h, title, *len );
}



int DRW_API( _pannel_add_b )( int *ide, float *x, float *y, float *w, float *h, char* lab, int *len,
                              char* bv )
{
  return Draw_Bool_To_Pannel( *ide, *x, *y, *w, *h, lab, *len, bv );
}



int DRW_API( _pannel_add_e )( int *ide, float *x, float *y, float *w, float *h, char* lab, int *len,
                             int *ev, int *sz, int *nch, char* choice, int *min )
{
  int*                     tbl;
  char**                   tbs;
  char*           pch = choice;
  int        i, l0, l1, r, siz;

  siz = *sz; l0 = *nch;
  tbl = (int*)malloc( siz*sizeof( int* ) );
  tbs = (char**) malloc( siz*sizeof( char* ) );
  for (i = 0; i < siz; i++) {
    l1 = l0;
    while ((l1>1)&&(pch[l1-1] == ' ')) l1--;    /* Loop to find the real end of string */
    tbl[i] = l1;                                /* Set the string length */
    tbs[i] = pch; pch += l0;                    /* Set each choice string address */
  }
  r = Draw_Enum_To_Pannel( *ide, *x, *y, *w, *h, lab, *len, ev, siz, tbs, tbl, *min );
  free( tbs );
  free( tbl );
  return r;
}



int DRW_API( _pannel_add_s )( int *ide, float *x, float *y, float *w, float *h, char* lab, int *len,
                              Char* sv, int *cap, Char* fed )
{
  Char siz = *cap;
  int     istatus;

  if (cap) while ((siz>1)&&(sv[siz-1] == ' ')) siz--;
  istatus = Draw_Str_To_Pannel( *ide, *x, *y, *w, *h, lab, *len, sv, &siz, *cap, *fed );
  if (istatus >= 0) istatus = siz;
  return istatus;
}



int DRW_API( _pannel_add_i )( int *ide, float *x, float *y, float *w, float *h, char* lab, int *len,
                              int *iv, int *min, int *max )
{
  return Draw_Int_To_Pannel( *ide, *x, *y, *w, *h, lab, *len, iv, *min, *max );
}



int DRW_API( _pannel_add_f )( int *ide, float *x, float *y, float *w, float *h, char* lab, int *len,
                              float *fv, float *min, float *max , float *step )
{
  return Draw_Flt_To_Pannel( *ide, *x, *y, *w, *h, lab, *len, fv, *min, *max , *step );
}



int DRW_API( _pannel_add_text )( int *ide, float *x, float *y, float *w, float *h, char* lab, int *len,
                                 char* txt, int *sz )
{
  return Draw_Text_To_Pannel( *ide, *x, *y, *w, *h, lab, *len, txt, *sz );
}



int DRW_API( _pannel_add_frame )( int *ide, float *x, float *y, float *w, float *h, char* lab, int *len,
                                  float *flw, int *stl )
{
  return Draw_Frame_To_Pannel( *ide, *x, *y, *w, *h, lab, *len, *flw, *stl );
}



int DRW_API( pannel_change )( int *ide, int *itm )
{
  return Draw_Pannel_Change( *ide, *itm );
}



int DRW_API( _pannel_new_text )( int *ide, int *itm, char* txt, int *siz )
{
  return Draw_Pannel_New_Text( *ide, *itm, txt, *siz );
}



int DRW_API( pannel_enadis )( int *ide, int *itm, int *flg )
{
  return Draw_Pannel_EnaDis( *ide, *itm, *flg );
}

void Draw_Pannel_Delete( int ide );

void DRW_API( pannel_delete )( int *ide )
{
  Draw_Pannel_Delete( *ide );
}



void Draw_Pannel_Open( int ide );

void DRW_API( pannel_open )( int *ide )
{
  Draw_Pannel_Open( *ide );
}



void Draw_Pannel_Close( int ide );

void DRW_API( pannel_close )( int *ide )
{
  Draw_Pannel_Close( *ide );
}



int  Draw_Pannel_Get( int ide );

int  DRW_API( pannel_get )( int *ide )
{
  return Draw_Pannel_Get( *ide );
}


int  Draw_Pannel_Put( int ide );

int  DRW_API( pannel_put )( int *ide )
{
  return Draw_Pannel_Put( *ide );
}



int  Draw_Pannel_Request( int ide );

int  DRW_API( pannel_request )( int *ide )
{
  return Draw_Pannel_Request( *ide );
}

