/************************************************************************
*                                                                       *
*                                                                       *
*                                                                       *
*               D R A W   -   C L I E N T   L I B R A R Y               *
*                                                                       *
*                   (Basic Input Graphic Directives)                    *
*                     (Gfortran-Language Support)                       *
*                                                                       *
*                     Draw Library Version V 2.4                        *
*                                                                       *
*                            31-Jan-2009                                *
*                                                                       *
*                                by                                     *
*                                                                       *
*                   Pierre Wolfers,  Institut Neel                      *
*                                                                       *
*           CNRS GRENOBLE,  25 Avenue des Martyrs, B.P. 166             *
*                                                                       *
*                      F 38042 GRENOBLE CEDEX 9                         *
*                                                                       *
*                            F R A N C E                                *
*                                                                       *
*                                                                       *
*                                                                       *
************************************************************************/



/*///////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
///////////////////////////////////////////////////////////////////////*/




#include <draw/draw_common.h>
#include <draw/draw_env.h>      /* Load the DRAW library Environment */





/*********************************************************************/

void DRW_API( message )( char * str, int *len )
{
  Draw_Message( str, *len );
}


/*********************************************************************/

void DRW_API( string_display )( char * str, int* len )
{
  Draw_String_Display( str, *len );
}


/*********************************************************************/

int DRW_API( get_choice )( int *len, char * menu[], int slen[] )
{
  return Draw_Get_choice( *len, menu, slen );
}


/*********************************************************************/

int DRW_API( get_answerd )( char * question, int *len )
{
  return Draw_Get_Answerd( question, *len );
}


/*********************************************************************/

int DRW_API( get_string )( char * stit, int *ltit, char * sdef, int *ldef, char * sval, int *capa )
{
  return Draw_Get_String( stit, *ltit, sdef, *ldef, sval, *capa );
}


/*********************************************************************/

int DRW_API( get_value )( char *stit, int *ltit, float *val, float *lw, float *up )
{
  return Draw_Get_Value( stit, *ltit, val, *lw, *up );
}


/*********************************************************************/

int DRW_API( get_color )( char *stit, int *ltit, float *r, float *g, float *b )
{
  return Draw_Get_Color( stit, *ltit, r, g, b );
}


/*********************************************************************/

int DRW_API( select_file )( char * stit, int  * ltit, char * fltr[], int  fltl[], int  *flen,
                            int  *  fdx, char * sdef, int  *   ldef, char * sval, int  *capa, int  *wflg )
{
  return Draw_Select_File( stit, *ltit, fltr, fltl, *flen, fdx, sdef, *ldef, sval, *capa, *wflg );
}


/*********************************************************************/

int DRW_API( seg_pick )( int *seg_id, int *pick_id )
{
  return Draw_Seg_Pick( seg_id, pick_id );
}


/*********************************************************************/

int DRW_API( get_position )( float *xx, float *yy, Char *in_epure )
{ /* Request to get a Point coordinates */
  return Draw_Get_Position( xx, yy, *in_epure );
} /* draw_get_position */


/*********************************************************************/

int  DRW_API( get_window )( float *x1, float *x2, float *y1, float *y2 )
{
  return Draw_Get_Window( x1, x2, y1, y2 );
}


/*********************************************************************/

int DRW_API( get_line_strocke )( float pt[], int *capa, int *size,
                                 Char *keep, Char *f_stroke )
{
  return Draw_Get_Line_Stroke( pt, *capa, size, *keep, *f_stroke );
}


/*********************************************************************/

void DRW_API( echo_pos )( int *crsk )
{
  Draw_Echo_Pos( *crsk );
}


/*********************************************************************/

void DRW_API( echo_line )( int *col, int *md, int *knd, float *sz )
{
  Draw_Echo_Line( *col, *md, *knd, *sz );
}



/****************************    E N D    ****************************/

