/************************************************************************
*                                                                       *
*                                                                       *
*                                                                       *
*              D R A W   -   C L I E N T   L I B R A R Y                *
*                                                                       *
*                  (Main Control Graphic Directives)                    *
*                     (Fortran Language Support)                        *
*                                                                       *
*                     Draw Library Version V 2.4                        *
*                                                                       *
*                                by                                     *
*                                                                       *
*           Pierre Wolfers, Laboratoire de Cristallographie             *
*                                                                       *
*           CNRS GRENOBLE,  25 Avenue des Martyrs, B.P. 166             *
*                                                                       *
*                      F 38042 GRENOBLE CEDEX 9                         *
*                                                                       *
*                            F R A N C E                                *
*                                                                       *
*                                                                       *
*                                                                       *
************************************************************************/



/*///////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
///////////////////////////////////////////////////////////////////////*/




#include <draw/draw_common.h>
#include <draw/draw_env.h>      /* Load the DRAW library Environment */


/*///////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//     Basic Routines with all formal by reference for FORTRAN         //
//                                                                     //
//                                                                     //
///////////////////////////////////////////////////////////////////////*/



void DRW_API( end )()
{
  Draw_End();
}



void DRW_API( _set_menu_spc )( int *cd, int *id, char* name, int *len, int *key )
{
  Draw_Set_Menu_Spc( *cd, *id, name, *len, *key );
}



/*********************************************************************/

void Draw_Init( float *x_paper, float *y_paper, Char *unit,
                Char *usr_id, int usr_len );

void DRW_API( _init )( float *x_paper, float *y_paper, Char *unit,
                       Char *usr_id, int *usr_len )
{ /* By Reference Call for Fortran */
  Draw_Init( x_paper, y_paper, unit, usr_id, *usr_len );
}



/*********************************************************************/

Char DRW_API( _picture )( char  *title, int *len,    /* Title string */
                          float *x_size,             /* Plot Surface Length */
                          float *y_size,
                          float *z_size,
                          Char  * scale,             /* Scale flags */
                          Char  *margin              /* Margin/Title flag*/
                        )
{
  return Draw_Picture( title, *len, *x_size, *y_size, *z_size, *scale, *margin );
}



/*********************************************************************/

int DRW_API( picture_scales )( int *cd, float* scx, float* scy )
{ /* Call standard Dialog Server Routine */
  Draw_Picture_Scales( *cd, scx, scy );
} /* draw_dialog */


/*********************************************************************/

int DRW_API( dialog )( int *flags )
{ /* Call standard Dialog Server Routine */
  return Draw_Dialog( *flags );
} /* draw_dialog */


/*********************************************************************/

void DRW_API( out_mode )( int *mode )
{
  Draw_Out_Mode( *mode );
} /* draw_out_mode */


/*********************************************************************/

void DRW_API( send_block )( float * blk )
{ /* To send a block of data */
  Draw_Send_Block( blk );
}


/*********************************************************************/

int DRW_API( time_anim )( int *per )
{ /* To Set a new Timer Period for Animation Refresh (in ms) */
  return Draw_Time_Anim( *per );
} /* Draw_Time_Anim */


/*********************************************************************/

void DRW_API( set_stop_anim )( int *mod )
{ /* To Set a Stop mod for animation */
  Draw_Set_Stop_Anim( *mod );
} /* draw_set_stop_anim */


/*********************************************************************/

int DRW_API( anim_state )()
{
  return Draw_AnmSSt;
}

int DRW_API( server_flags )()
{
  return Draw_Srv_Flg;
}

int DRW_API( server_ident )()
{
  return Draw_Srv_Ide;
}



void DRW_API( server_id_name )( char* str, int cap )
{
  int i, l;

  l = (cap >= Draw_Srv_NameLength)?Draw_Srv_NameLength:cap;
  for (i=0;i<l;i++) str[i] = Draw_Srv_Name[i];
  if (l<cap)
    for (i=l;i<cap;i++) str[i] = ' ';
}





/*********************************************************************/

void DRW_API( mplot )( int *dim, float *pt, int *flg )
{
  Draw_Mplot( *dim, pt, *flg );
}


/*********************************************************************/

void DRW_API( progplot )( float *x, float *y )
{
  Draw_Progplot( *x, *y );
}



/*********************************************************************/

void DRW_API( progsetting )( int *seg, int *ide )
{
  Draw_ProgSetting( *seg, *ide );
}


/*********************************************************************/

DRW_API( plot )( float *x, float *y, Char *pen )
{
  Draw_Plot( *x, *y, *pen );
}


/*********************************************************************/

DRW_API( plot3 )( float *x, float *y, float *z, Char *pen )
{
  Draw_Plot3( *x, *y, *z, *pen );
}



/*********************************************************************/

DRW_API( org )( float *x, float *y, Char *pen )
{
  Draw_Org( *x, *y, *pen );
}


/*********************************************************************/

DRW_API( org3 )( float *x, float *y, float *z, Char *pen )
{
  Draw_Org3( *x, *y, *z, *pen );
}



/*********************************************************************/

void DRW_API( rplot )( float *dx, float *dy, Char *pen )
{ /* Relative (to current Pen position) Plot */
  Draw_Plot( Draw_Currx + *dx, Draw_Curry + *dy, *pen );
} /* draw_rplot */



/*********************************************************************/

void DRW_API( rplot3 )( float *dx, float *dy, float *dz, Char *pen )
{ /* Relative (to current Pen position) Plot */
  Draw_Plot3( Draw_Currx + *dx, Draw_Curry + *dy, Draw_Curry + *dz, *pen );
} /* draw_rplot3 */



/*********************************************************************/

void DRW_API( where )( float *x, float *y )
{ /* Return the Current Pen Position to the User */
  *x = Draw_Currx;
  *y = Draw_Curry;
} /* Draw_Where */



/*********************************************************************/

void DRW_API( where3 )( float *x, float *y, float *z )
{ /* Return the Current Pen Position to the User */
  *x = Draw_Currx;
  *y = Draw_Curry;
  *z = Draw_Currz;
} /* Draw_Where3 */


/*********************************************************************/

void DRW_API( _string )( float *x, float *y, float *theta, float *high,
                         char * str, int *len, int *flg )
{
  Draw_String( *x, *y, *theta, *high, str, *len, *flg );
}



/*********************************************************************/

void DRW_API( _text_in_box )( float *x, float *y, float *bx, float *by, char *txt, int *siz,
                              int *hal, int *flg, float *hc, float *ls )
{
  Draw_Text_In_Box( *x, *y, *bx, *by, txt, *siz, *hal, *flg, *hc, *ls );
}



/*********************************************************************/

void DRW_API( circle )( float *x_c, float *y_c, float *r, float *st_a, float *nd_a, float *prec, int *flg )
{
  Draw_Circle( *x_c, *y_c, *r, *st_a, *nd_a, *prec, *flg );
}




/*********************************************************************/

void DRW_API( sphere )( float *x_c, float *y_c, float *z_c, float *r,
                        int *plg, int *plt, int *flg )
{
  Draw_Sphere( *x_c, *y_c, *z_c, *r, *plg, *plt, *flg );
}



/*********************************************************************/

void DRW_API( cylinder )( float *xb, float *yb, float *zb, float *th, float *ph,
                          float *lg, float *rb, float *rt, int *px, int *pz, int *flg )
{
  Draw_Cylinder( *xb, *yb, *zb, *th, *ph, *lg, *rb, *rt, *px, *pz, *flg );
}



/*********************************************************************/

void DRW_API( disk )( float *xc, float *yc, float *zc, float *th, float *ph,
                      float *ri, float *re, float *sa, float *ea, int *pt, int *pr, int *flg )
{
  Draw_Disk( *xc, *yc, *zc, *th, *ph, *ri, *re, *sa, *ea, *pt, *pr, *flg );
}



/*********************************************************************/

void DRW_API( surface )( int *nraw, int *ncol, int *flg, float* vtb )
{
  Draw_Surface( *nraw, *ncol, *flg, vtb );
}


/*********************************************************************/

void DRW_API( surface2 )( int *nraw, int *ncol, int *flg, float *xo, float *yo, float *xs, float *ys, float* vtb )
{
  Draw_Surface2( *nraw, *ncol, *flg, *xo, *yo, *xs, *ys, vtb );
}


/*********************************************************************/

void DRW_API( polyhedral )( int *nfc, int *nvt, int* flg, int* fctb, float* vtb )
{
  Draw_Polyhedral( *nfc, *nvt, *flg, fctb, vtb );
}



/*********************************************************************/

void DRW_API( wplane3 )( float * mat )
{ /* Set a new coordinate system for following Draw_Plot */
  int i;

  Draw_Wplane3( mat );
} /* Draw_Wplane3 */



/*********************************************************************/

void DRW_API( nplane3 )()
{ /* Return to normal cm. work space coordinates */
  Draw_Nplane3();
  Sdrw_Put_Code( cd_nplane3 );
  Sdrw_Server_Request();
} /* Draw_Nplane3 */





/****************************    E N D    ****************************/
