/*********************************************************************
*                                                                    *
*                                                                    *
*                                                                    *
*             D R A W   -   C L I E N T   L I B R A R Y              *
*                                                                    *
*              (Box and Axis Control Graphic Directives)             *
*                    (Fortran-Language Support)                      *
*                                                                    *
*                    Draw Library Version V 2.4                      *
*                                                                    *
*                           31-Jan-2009                              *
*                                                                    *
*                               by                                   *
*                                                                    *
*                  Pierre Wolfers,  Institut Neel                    *
*                                                                    *
*          CNRS GRENOBLE,  25 Avenue des Martyrs, B.P. 166           *
*                                                                    *
*                     F 38042 GRENOBLE CEDEX 9                       *
*                                                                    *
*                           F R A N C E                              *
*                                                                    *
*                                                                    *
*                                                                    *
*********************************************************************/



/*///////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
///////////////////////////////////////////////////////////////////////*/



#define  _DRAWLIB_L4BASE_  0    /* Set the L4 Base Mode of L4 Declaration */

#include <draw/draw_common.h>
#include <draw/draw_axis_env.h>    /* load the DRAW L4 Library environment */




int DRW_API( new_axis )( Draw_Point3 u_axis, Draw_Point3 v_axis,
                         float      *length, float        *vinf,
                         float        *vsup, int          *ntck, int         *flags )
{
  return Draw_New_Axis( u_axis, v_axis, *length, *vinf, *vsup, *ntck, *flags );
} /* draw_new_axis */



int DRW_API( new_box )( Draw_Point3 org, int *ix, int *iy, int *iz,
                        int dtb[], int* dsz, float stb[], int* nfz )
{
  Draw_New_Box( org, *ix, *iy, *iz, dtb, *dsz, stb, *nfz, 0, 0 );
}  /* draw_new_box */



int DRW_API( easy_box_2d )( float *ox, float *oy, float *sx, float *sy, float *mm,
                            char *ux, char *uy, int *lux, int *luy, int *ns )
{
  return Draw_Easy_Box_2D( *ox, *oy, *sx, *sy, mm, ux, uy, *lux, *luy, *ns );
}  /* easy_box_2d */



void DRW_API( free_box ) ( int *ib, int *axflg )
{
  Draw_Free_Box( *ib, *axflg );
} /* draw_free_box */



void DRW_API( free_box_list ) ()
{
  Draw_Free_Box_List();
} /* draw_free_box_list */



void DRW_API( set_axis_value )( int*   ax, int*   cd, int*    n,
                                float* p1, float* p2, float* p3, float* p4,
                                int*   p5, int*   p6, int*   p7 )
{
  Draw__Set_Axis_Value( *ax, *cd, *n, p1, p2, p3, p4, p5, p6, p7 );
}



int  DRW_API( get_axis_value )( int*   ax, int*   cd, int*    n,
                                float* p1, float* p2, float* p3, float* p4,
                                int*   p5, int*   p6, int*   p7 )
{
  return Draw__Get_Axis_Value( *ax, *cd, *n, p1, p2, p3, p4, p5, p6, p7 );
}



int  DRW_API( get_box_value )( int *box, int *cd, int *n, void * tb )
{
  return Draw__Get_Box_Value( *box, *cd, *n, tb );
}



void DRW_API( plot_axis )( int *ia, Draw_Point3 org, int *fvl )
{
  Draw_Plot_Axis( *ia, org, *fvl );
}



void DRW_API( plot_box ) ( int *ib )
{
  Draw_Plot_Box( *ib );
}



void DRW_API( open_box ) ( int *ib )
{
  Draw_Open_Box( *ib );
}



void DRW_API( close_box ) ()
{ /* To select the specified box as the current box */
  Draw_Close_Box();
}



void DRW_API( box_update ) ( int *ib )
{
  Draw_Update_Box( *ib );
}



int  DRW_API( cv_box )( int* flg, float* xx, float* yy, float* zz, float *x, float *y, float *z )
{ /* Convert coordinates between Cm and Box coordinates */
  return Draw_CV_Box( *flg, *xx, *yy, *zz, x, y, z );
}



void DRW_API( axis_inscale )( float *mi, float *ma, int *n,
                              float *inf, float *sup, float *delta, float *ef )
{
  Draw_Axis_Inscale( *mi, *ma, *n, inf, sup, delta, ef );
}



void DRW_API( axis_setvscale )( float *inf, float *sup, float *delta, float *rsiz,
                                float *fsiz, float *eff, float *scale )
{
  Draw_Axis_Setvscale( *inf, *sup, *delta, *rsiz, fsiz, eff, scale );
}



int DRW_API( axis_autoscale )( float *min, float *max, float *szp, int *ani, int *ana,
                               float *inf, float *sup, float *del, float *fsz, float *sca, float *eff )
{
  return Draw_Axis_AutoScale( *min, *max, *szp, *ani, *ana, inf, sup, del, fsz, sca, eff );
}



void DRW_API( axis_viewscale )( float *a_inf, float *a_sup, float *a_del,
                                float *a_vinf, float *a_vsup, float *a_vdel, float *a_sc, float *a_sh )
{
  Draw_Axis_Viewscale( *a_inf, *a_sup, *a_del, a_vinf, a_vsup, a_vdel, a_sc, a_sh );
}

