/*********************************************************************
*                                                                    *
*                                                                    *
*                                                                    *
*             D R A W   -   C L I E N T   L I B R A R Y              *
*                                                                    *
*              (Attributes Graphic Setting Directives)               *
*                     (Multi-Language Support)                       *
*                                                                    *
*                    Draw Library Version V 2.4                      *
*                                                                    *
*                           08-Oct-2009                              *
*                                                                    *
*                               by                                   *
*                                                                    *
*                  Pierre Wolfers,  Institut Neel                    *
*                                                                    *
*          CNRS GRENOBLE,  25 Avenue des Martyrs, B.P. 166           *
*                                                                    *
*                     F 38042 GRENOBLE CEDEX 9                       *
*                                                                    *
*                           F R A N C E                              *
*                                                                    *
*                                                                    *
*                                                                    *
*********************************************************************/



/*///////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
///////////////////////////////////////////////////////////////////////*/




#include <draw/draw_common.h>
#include <draw/draw_env.h>      /* Load the DRAW library Environment */



/*********************************************************************/
/*                                                                   */
/*                                                                   */
/*                                                                   */
/*         Three kind of Procedure names :                           */
/*                                                                   */
/*       1/  API form (Directly Callable by Fortran)                 */
/*                all parameter are passed by reference.             */
/*                                                                   */
/*       2/  Draw_<name> form (C compatible form).                   */
/*                                                                   */
/*       3/  Draw__<name> form (Intermediary C compatible form).     */
/*                Used as intermediary between the dedicated         */
/*                language procedures for special parameter          */
/*                management.                                        */
/*                                                                   */
/*                                                                   */
/*                                                                   */
/*********************************************************************/



#ifdef __CYGWIN__
# define MAX_PATH_LEN 255

void cygwin_win32_to_posix_path_list( const char* win32, char* posix );

 int cygwin_win32_to_posix_path_list_buf_size( const char* path_list );

 int cygwin_posix_to_win32_path_list_buf_size( const char* path_list );

void cygwin_posix_to_win32_path_list( const char* posix, char* win32 );

static char win_tmp[MAX_PATH_LEN+1],
            win_unx[MAX_PATH_LEN+1];

# define _FILE_TRANS
#endif



void Draw_Color_Index( int color )
{ /* Set a color for following Drawing primitives */
  Sdrw_Put_Code( cd_color);
  Sdrw_Put_Float( - abs( color ) );
  Sdrw_Server_Request();
} /* Draw_Color */


/*********************************************************************/

void Draw_Set_Color( float r, float v, float b )
{ /* Set a color for following Drawing primitives */
  Sdrw_Put_Code( cd_color);
  Sdrw_Put_Float( r );
  Sdrw_Put_Float( v );
  Sdrw_Put_Float( b );
  Sdrw_Server_Request();
} /* Draw_Set_Color */


/*********************************************************************/

void Draw_Set_ColorA( float r, float v, float b, float a )
{ /* Set a color for following Drawing primitives */
  Sdrw_Put_Code( cd_color);
  Sdrw_Put_Float( r );
  Sdrw_Put_Float( v );
  Sdrw_Put_Float( b );
  Sdrw_Put_Float( a );
  Sdrw_Server_Request();
} /* Draw_Set_Color */


/*********************************************************************/

void Draw_Define_Color( int icol, float r, float g, float b )
{ /* Set the Icol# color definition (in RGB) */
  Sdrw_Put_Code( cd_define_color );
  Sdrw_Put_Int( icol );
  Sdrw_Put_Float( r );
  Sdrw_Put_Float( g );
  Sdrw_Put_Float( b );
  Sdrw_Server_Request();
} /* Draw_Define_Color */



/*********************************************************************/

void Draw_Define_ColorA( int icol, float r, float g, float b, float a )
{ /* Set the Icol# color definition (in RGB) */
  Sdrw_Put_Code( cd_define_color );
  Sdrw_Put_Int( icol );
  Sdrw_Put_Float( r );
  Sdrw_Put_Float( g );
  Sdrw_Put_Float( b );
  Sdrw_Put_Float( a );
  Sdrw_Server_Request();
} /* Draw_Define_Color */



/*********************************************************************/

int Draw_Inquire_Color( int icol, float *r, float *g, float *b, float *a )
{ /* Get the Icol# color definition (in RGB) */
  int status;

  Sdrw_Put_Code( cd_inquire_color );
  Sdrw_Put_Int( icol );
  Sdrw_Server_Request();
  status = Sdrw_Get_Int();
  *r = Sdrw_Get_Float();
  *g = Sdrw_Get_Float();
  *b = Sdrw_Get_Float();
  if (a) *a = Sdrw_Get_Float();
  return status;
} /* Draw_Inquire_Color */



/*********************************************************************/

void Draw_Line_Attr( int n, float r )
{ /* Set Line Attributs */
  Sdrw_Put_Code( cd_line_attr );
  Sdrw_Put_Int( n );
  Sdrw_Put_Float( r );
  Sdrw_Server_Request();
} /* Draw_Line_Attr */



/*********************************************************************/

void Draw_Marker_Attr( int n, float r )
{ /* set the Marker Attributs */
  Sdrw_Put_Code( cd_marker_attr );
  Sdrw_Put_Int( n );
  Sdrw_Put_Float( r );
  Sdrw_Server_Request();
} /* Draw_Marker_Attr */



/*********************************************************************/

void Draw_Fill_Attr( int n1, int n2 )
{ /* Set The Fill Area Attribute */
  Sdrw_Put_Code( cd_fill_area_attr );
  Sdrw_Put_Int( n1 );
  Sdrw_Put_Int( n2 );
  Sdrw_Server_Request();
} /* Draw_Fill_Attr */



/*********************************************************************/

void Draw_Text_Font( int n, int tp )
{ /* To select a specified Font */
  Sdrw_Put_Code( cd_text_font );
  Sdrw_Put_Int( n );
  Sdrw_Put_Int( tp );
  Sdrw_Server_Request();
} /* Draw_Text_Font */



/*********************************************************************/

int  Draw_Install_Font( int n, int tp, char * fn, int sz )
{ /* To install a specified Font */
  int i;
#ifdef _FILE_TRANS
  int      j;
  char * pwd;
#endif

  Sdrw_Put_Code( cd_install_font );
  Sdrw_Put_Int( n );
  Sdrw_Put_Int( tp );

#ifdef _FILE_TRANS

  if (Draw_SrvMod&SERVER_DO_WIN32_FS) {
	pwd = getenv( "PWD" );
	i = 0;	  
	if (pwd&&pwd[0]) {
	  while ((i<MAX_PATH_LEN-1)&&(pwd[i])) { win_tmp[i] = pwd[i]; i++; }
	  if (win_tmp[i-1] != '/') { win_tmp[i++] = '/'; win_tmp[i] = '\0'; }
    }
    if (fn&&fn[0]) {
	  j = 0;
	  do { win_tmp[i++] = fn[j++]; } while ((i<MAX_PATH_LEN-1)&&(fn[j])&&(j<sz));
	  win_tmp[i++] ='\0';
    }
    j = cygwin_posix_to_win32_path_list_buf_size( win_tmp );
    cygwin_posix_to_win32_path_list( win_tmp, win_unx );
    Sdrw_Put_String( win_unx, j );
  }
  else Sdrw_Put_String( fn, sz );

#else

  Sdrw_Put_String( fn, sz );

#endif

  Sdrw_Server_Request();
  return Sdrw_Get_Int();
} /* Draw_Install_Font */



/*********************************************************************/

int  Draw_Font_Info( int ifnt, char *fnm, int cap, int *len, int *stl )
{ /* To select a specified Font */
  int re, ln;

  Sdrw_Put_Code( cd_font_info );
  Sdrw_Put_Int( ifnt );
  Sdrw_Server_Request();
  re = Sdrw_Get_Int();
  if (re>=0) {
    *stl = Sdrw_Get_Int();

#ifdef _FILE_TRANS

    if (Draw_SrvMod&SERVER_DO_WIN32_FS) {
      Sdrw_Get_String_Lim( win_unx, MAX_PATH_LEN );
      ln = cygwin_win32_to_posix_path_list_buf_size( win_unx );
      if (ln < cap) {
	    cygwin_win32_to_posix_path_list( win_unx, fnm );
	    *len = ln;
      } else re = -1;
    }
    else
      *len = Sdrw_Get_String_Lim( fnm, cap );

#else

    *len = Sdrw_Get_String_Lim( fnm, cap );

#endif

  }
  return re;
} /* Draw_Font_Info */



/*********************************************************************/

int  Draw_Get_String_Box( int ifnt, char *fnm, int len, float hg, float *bx, float *by )
{ /* To select a specified Font */
  int re;

  Sdrw_Put_Code( cd_get_string_box );
  Sdrw_Put_Int( ifnt );
  Sdrw_Put_Float( hg );
  Sdrw_Put_String( fnm, len );
  Sdrw_Server_Request();
  re = Sdrw_Get_Int();
  if (re>=0) {
    *bx = Sdrw_Get_Float();
    *by = Sdrw_Get_Float();
  }
  return re;
} /* Draw_Font_Info */



/*********************************************************************/

void Draw_Text_Attr( int n1, int n2, int n3, float re, float rs, float rd )
{ /* Set text Attributs*/
  Sdrw_Put_Code( cd_text_attr );
  Sdrw_Put_Int( n1 );
  Sdrw_Put_Int( n2 );
  Sdrw_Put_Int( n3 );
  Sdrw_Put_Float( re );
  Sdrw_Put_Float( rs );
  Sdrw_Put_Float( rd );
  Sdrw_Server_Request();
} /* Draw_Text_Attr */


/*********************************************************************/

void Draw_Push_Attr( void )
{ /* Set text Attributs*/
  Sdrw_Put_Code( cd_push_pop_attr );
  Sdrw_Put_Int( 1 );
  Sdrw_Server_Request();
} /* Draw_Push_Attr */


/*********************************************************************/

void Draw_Pop_Attr( void )
{ /* Set text Attributs*/
  Sdrw_Put_Code( cd_push_pop_attr );
  Sdrw_Put_Int( 0 );
  Sdrw_Server_Request();
} /* Draw_Pop_Attr */




/****************************    E N D    ****************************/

