{
}
Program Draw_Example_1( input, output );
{ Complete Program to display a sphere }

%include '/usr/local/include/draw_defs'; { Get the Draw Definitions }

const
  { Define the position of the light }
  Light1_Position = Dpoint3[ 50.0, 50.0, 50.0];

  { Define the specular color of the light (default should be black).
  The Dcolor type as for value in the range 0.0..1.0 :
  Dcolor[ red, green, blue, alpha] where alpha is 0.0 for the
  Transparence and 1.0 for solid. This value is used only when the
  Alpha mode bit is set (not available in the current DRAW version. }
  Specular_Color = Dcolor[ 1.0, 1.0, 1.0, 1.0 ];


var
  xs, ys:  Dfloat;   { Available Graphic surface sizes }
  unit:    byte;     { Used Graphic Unit (1 = cm) }
  status:  Dint;     { Status word, for DRAW function return }
  b_scale: boolean;  { Result of DRAW$INIT: True when the unit scale
                       is obtained }


begin { Begin of Main Procedure Draw_model }
  { Set the Lighting mode bit in the Server Flags Word }
  Draw_Server_Mode := DrwSrv_Do_Lighting;

  { Initialize the DRAW System, Get the display size (with unit)
    and give the name of the application to display. }
  DRAW$INIT( xs, ys, unit, 'Draw_Model' );

  { Create a 3D drawing area of 12*12*12 cm (the normal unit) with
    the origine Dpoint3[0.0, 0.0, 0.0] at centre of area. Put the
    the title “ A Sphere” in the top margin(first boolean), and
    request for a scale of 1.0 on the plot. The returned value
    status is 1 when the request of unit scale is obtained. }
  b_scale := DRAW$PICTURE3( 'A Sphere', 12.0, 12.0, 12.0, true, true );

  { Define the position of the Light #1, the Default light,
  its default diffuse color is white = Dcolor[ 1.0, 1.0, 1.0, 1.0]. }
  DRAW$LIGHT_DEFINE( 1, LIGHT_POSITION, Light1_Position);

  { Define the specular color of the Light #1, the default
    specular color is Black) }
  DRAW$LIGHT_DEFINE( 1, LIGHT_SPECULAR_COLOR, specular_color);

  { Define the shininess value of the subsequent drawing surface }
  DRAW$MAT_LIGHT_PROP( MAT_FRONT_FACE, MAT_SHININESS, Dvalue[100.0] );

{ Set the color of subsequent drawing as a not saturated yellow }
  DRAW$COLOR( 0.8, 0.8, 0.0 );

{ Draw a sphere at origine with a radius of 5cm. The 32, 32 value
    give a good quality of sphere representation. The code 4 is
    required to generate the surgface filling with the normal vector
     computing. }
  DRAW$SPHERE( 0.0, 0.0, 0.0, 5.0, 32, 32, 4 );

  { Now, Show the graphic scene and wait for user action. The returned
    status value are 0 for the resume action in popup “File” menu, or
    -1 for the Exit action (by popup “file” menu or by clic of close
    window (with cross) button. The 1 parameter flags the user
    support of close_window/exit function. }
  status := DRAW$DIALOG( 1 );

  DRAW$END          { Stop the Graphic Draw Server }
end Draw_Example_1.
