/*** Draw internal types definitions ***/

#ifndef _DRW_TYP
#  define _DRW_TYP   0

#  include <draw/draw_common.h>      /* Common C declarations */
#  include <draw/draw_constantes.h>  /* Constantes definitions */


/* string definition */

typedef struct { unsigned char length;
                          char body[255];
               } string;


typedef union	{ struct { unsigned char ch0, ch1, ch2, ch3; } ct;
                           int   i;
                           float f;
		} eqvif;


/* typedef int	unit_type; */

typedef enum   { raster, centimeter } unit_type;

/* selected unit capacity */


/*********************DEFINE the L4 TYPES***************************/

typedef enum   { car, entier, reel } le_type;


typedef struct { eqvif nb;
                 le_type typ;
               } teqvif;

typedef float draw_matrix[2][3]; /* array[0..1,0..2] of real; */
                                 /* transformation matrix */

typedef struct draw_axis_struct
{
    struct draw_axis_struct
          *axis_next;       /* link to next created axix */

    float axis_angle_axe,   /* orientation angle in degrees of the axis */
          axis_angle_tick,  /* orientation angle in degrees of the ticks */
          axis_ef,          /* the efficience */
          axis_inf,         /* the low limit in user coordinate */
          axis_sup,         /* the high limit in user coordinate */
          axis_del,         /* the increment in user coordinate */
          axis_plar,        /* the size of the axis in cm. */
          axis_pdel,        /* the increment in cm. */
          axis_scale;       /* the scale in cm/user_unity */

    int   axis_ni,          /* minimum and ... */
          axis_na,          /* ...maximum number of ticks */
          axis_ntc;         /* the selected number of increment */

    float axis_vinf,        /* origine in display value of the axis */
          axis_vdel,        /* increment in display value */
          axis_vrot,        /* rotation of display value */
          axis_hc,          /* character hight for ticks value. */
          axis_lt1,	    /* length of normal ticks */
          axis_lt2;         /* length of special ticks */
		            /* if lt2 := lt1 all ticks are specials */
    int   axis_firstwanted; /* boolean= first value unit wanted or not */
    float axis_hunit;       /* unit character hight */
    int   axis_alignunit,   /* unit alignment: default is LEFT alignment */
          axis_fontval,     /* font to use for values along of axis. */
          axis_fontunt;     /* font to use for the unit name. */
} draw_axis_rec, *draw_axis_ptr;

typedef struct draw_box_struct
{
    struct draw_box_struct
           *box_next;       /* link to next created box */

    draw_axis_ptr box_x,    /* x and... */
                  box_y;    /* ...y axis for box */

    draw_matrix box_matrix; /* matrix transformation to applied */

    float box_infx,
          box_infy,         /* low limits of each coordinate */
          box_supx,
          box_supy,         /* high limits of each coordinate */
          box_curx,
          box_cury;         /* current pen position on scaled x,y */

    int   box_out;          /* boolean is flag for out of box pen */
} draw_box_rec, *draw_box_ptr;


#endif
