/************************************************************************
*                                                                       *
*                                                                       *
*                                                                       *
*              D R A W   -   C L I E N T   L I B R A R Y                *
*                                                                       *
*              (Environment/Header File for DRAW Library)               *
*                                                                       *
*                               V 2.4                                   *
*                                                                       *
************************************************************************/



#ifndef _DRW_ENV                     /* To avoid Multi-definitions */
#  define _DRW_ENV    0



/***********************************************************************/
/**                                                                   **/
/**           C O N S T A N T E S    D E F I N I T I O N S            **/
/**                                                                   **/
/***********************************************************************/


#  include <draw/draw_constantes.h>  /* Draw Server Constantes definitions */
#  include <draw/draw_apientry.h>    /* Load the Draw API Macro */
/* #  include <draw/draw_l4env.h>    /* load the DRAW L4 Library environment */



# ifdef VMS                          /* Define Init C Run-Time Entry ... */ 
#   ifndef	__DECC                   /* ... Point for VMS VAXC and DECC */
#     define C_CRTL_INIT() VAXC_CRTL_INIT()
#   else
#     define C_CRTL_INIT() DECC_VAXC_CRTL_INIT()
#   endif
#   define DRAW_INI_STAT -1          /* For VMS the Draw_Status is not C init */
# else                               /* For not VMS system, define ... */
#   define DRAW_INI_STAT  0          /* ... normal (Draw_Status) init value */
# endif


/* Define the Allocation size of axis unit string */

#define _USZ_           64

#define  BX_VALU         4
#define  BX_TRVM         8
#define  BX_TSYM        16

#define  BX_XSHEND      32
#define  BX_YSHEND      64
#define  BX_ZSHEND     128
#define  BX_XSHPOS     256
#define  BX_YSHPOS     512
#define  BX_ZSHPOS    1024

#define  AX_LOG          1
#define  AX_LEFT         2
#define  AX_NFRS         4
#define  AX_NFVL         8
#define  AX_NLST        16
#define  AX_NLVL        32
#define  AX_NZER        64
#define  AX_NZVL       128
#define  AX_ARRO       256




/***********************************************************************/
/**                                                                   **/
/**                T Y P E S    D E F I N I T I O N S                 **/
/**                                                                   **/
/***********************************************************************/


typedef unsigned char       Char;   /* UNsigned char named Char */


typedef float  Draw_Point3[3],      /* Define a 3D point */
               Draw_Point[2],       /* Define a 2D point */
               Draw_Color[4];       /* Define a color with alpha */







/***********************************************************************/
/**                                                                   **/
/**            V A R I A B L E S    D E F I N I T I O N S             **/
/**                                                                   **/
/***********************************************************************/

#  ifdef _DRAWLIB_BASE_
#    define extref
#    define extini( val )        = val
#  else
#    define extref extern
#    define extini( val )
#  endif



#ifdef __cplusplus
extern "C" {
#endif


extref  int   Draw_Status extini( DRAW_INI_STAT );  /* Draw Library Status word */

extref  int   Draw_Buf_Size,         /* Used Buffer size */
              Draw_Inp_Size,         /* Buffer Input (read) Size */
              Draw_Srv_Flg,          /* Server Graphic Capabilities Flag */
              Draw_Srv_Ide;          /* Server Identifieur Number */

extref  char* Draw_Srv_Name;         /* Server Name String */
extref  Char  Draw_Srv_NameLength;   /* Server Name String Length */

extref  float Draw_Currx,            /* Last point X coordinate */
              Draw_Curry,            /* Last point Y coordinate */
              Draw_Currz;            /* Last point Z coordinate */

extref  int   Draw_AnmSSt extini(0); /* Stop Animation State Word */

extref  int   Draw_SrvMod extini(0); /* User Requested/Obtained Server Specification */

extref  int   Draw_PanIde extini(0); /* Identifier of modified Pannel during a Draw_Dialog call  */




/***********************************************************************/
/**                                                                   **/
/**  P R O C E D U R E S / F U N C T I O N S   D E F I N I T I O N S  **/
/**                                                                   **/
/***********************************************************************/



/**********************   Basic Pipe Routines   **************************/
/********            (Not here for user direct call)               *******/

int           Sdrw_Open_Gate();
int           Sdrw_Establish_Connection( char*, char* );
void          Sdrw_Connection_Release();
int           Sdrw_Read();
void          Sdrw_Write();
int           Sdrw_Read_Block( Char*, int );
void          Sdrw_Write_Block( Char*, int );
int           Sdrw_Dialog_Request();
void          Sdrw_Put_Char( Char );
void          Sdrw_Put_Int( int );
void          Sdrw_Put_Float( float );
void          Sdrw_Put_String( char*, int );
void          Sdrw_Put_Code( int );
Char          Sdrw_Get_Char();
int           Sdrw_Get_Int();
float         Sdrw_Get_Float();
int           Sdrw_Get_String( char* );
int           Sdrw_Get_String_Lim( char* s,int n );
int           Sdrw_Get_String_SP( char**, int );
int           Sdrw_Get_Code();




/******************    Basic C Draw Routines    ************************/

void Draw_End();

void Draw_Error( char*, int );         /* Not here for user direct call */

void Sdrw_Server_Request();            /* Not here for user direct call */

void Draw_Set_Menu_Spc( int, int, char*, int, int );

void Draw_Init( float*, float*, Char*, Char*, int );

Char Draw_Picture( char*, int, float, float, float, Char, Char );

void Draw_Picture_Scales( int, float*, float* );

int  Draw_Dialog( int );

void Draw_Out_Mode( int );

void Draw_Send_Block( float* );

int  Draw_Time_Anim( int );

void Draw_Set_Stop_Anim( int );

void Draw_Mplot( int, float*, int );

void Draw_Progplot( float, float );

void Draw_ProgSetting( int, int );

void Draw_Plot( float, float, Char );

void Draw_Plot3( float, float, float, Char );

void Draw_Org( float, float, int );

void Draw_Org3( float, float, float, int );

void Draw_Rplot( float, float, Char );

void Draw_Rplot3( float, float, float, Char );

void Draw_Where( float*, float* );

void Draw_Where3( float*, float*, float* );

void Draw_String( float, float, float, float, char*, int, int );

void Draw_Text_In_Box( float, float, float, float, char*, int, int, int, float, float );

void Draw_Circle( float, float, float, float, float, float, int );

void Draw_Sphere( float, float, float, float, int, int, int );

void Draw_Cylinder( float, float, float, float, float, float, float, float, int, int, int );

void Draw_Disk( float, float, float, float, float, float, float, float, float, int, int, int );

void Draw_Surface( int, int, int, float* );

void Draw_Surface2( int, int, int, float, float, float, float, float* );

void Draw_Polyhedral( int, int, int, int*, float* );

void Draw_Wplane3( float* );

void Draw_Nplane3();



/***************    C - Attribute interface Draw Routines     ****************/

void Draw_Color_Index( int );

void Draw_Set_Color( float, float, float );

void Draw_ColorA( float, float, float, float );

void Draw_Define_Color( int, float, float, float );

void Draw_Define_ColorA( int, float, float, float, float );

int  Draw_Inquire_Color( int, float*, float*, float*, float* );

void Draw_Line_Attr( int, float );

void Draw_Marker_Attr( int, float );

void Draw_Fill_Attr( int, int );

void Draw_Text_Font( int, int );

int  Draw_Install_Font( int, int, char*, int );

int  Draw_Font_Info( int, char*, int, int*, int* );

int  Draw_Get_String_Box( int ifnt, char *fnm, int len, float hg, float *bx, float *by );

void Draw_Text_Attr( int, int, int, float, float, float );

void Draw_Push_Attr();

void Draw_Pop_Attr();



/*****************    C - Input interface Draw routines    *******************/

void Draw_Message( char*, int );

void Draw_String_Display( char*, int );

int  Draw_Get_choice( int, char**, int* );

int  Draw_Get_Answerd( char*, int );

int  Draw_Get_String( char*, int, char*, int, char*, int );

int  Draw_Get_Value( char*, int, float*, float, float );

int  Draw_Get_Color( char *stit, int ltit, float *r, float *v, float *b );

int  Draw_Select_File( char*, int, char**, int*, int, int*, char*, int, char*, int, int );

int  Draw_Seg_Pick( int*, int* );

int  Draw_Get_Position( float*, float*, Char );

int  Draw_Get_Window( float*, float*, float*, float* );

int  Draw_Get_Curve( float*, int, int*, Char, Char );

void Draw_Echo_Pos( int );

void Draw_Echo_Line( int col, int md, int knd, float sz );



/************    C - Segment/matrix interface Draw routines    ***************/

int  Draw_New_Seg( int );

void Draw_Seg_End();

void Draw_Del_Seg( int );

int  Draw_Update_Seg( int, int );

void Draw_Include_Seg( int );

void Draw_Seg_Attr( int, int, int, int, float );

void Draw_Set_Pickid( int );

int  Draw_Detectable( int );

int  Draw_Seg_Inquire();

int  Draw_Push_Matrix();

void Draw_Pop_Matrix();

void Draw_Seg_Unit_Transf( int, int );

void Draw_Mat_Unit_Transf( int, int );

void Draw_Transf_Seg( int, float, float, float, float, float, float, float );

void Draw_Transf_Mat( int, float, float,float, float, float, float, float );

void Draw_Transf_Seg3( int, float, float, float, float, float, float, float, float, float, float, float, float );

void Draw_Transf_Mat3( int, float, float, float, float, float, float, float, float, float, float, float, float );

void Draw_Move_Seg( int, float, float );

void Draw_Move_Mat( int, float, float );

void Draw_Move_Seg3( int, float, float, float );

void Draw_Move_Mat3( int, float, float, float );

void Draw_Rotate_Seg( int, float, float, float );

void Draw_Rotate_Mat( int, float, float, float );

void Draw_URot_Seg3( int, float, float, float, float, float, float );

void Draw_URot_Mat3( int, float, float, float, float, float, float );

void Draw_Rotate_Seg3( int, float, float, float, float, float, float );

void Draw_Rotate_Mat3( int, float, float  py, float  pz, float, float, float );

void Draw_Scale_Seg( int, float, float, float, float );

void Draw_Scale_Mat( int, float, float, float, float );

void Draw_Scale_Seg3( int, float, float, float, float, float, float );

void Draw_Scale_Mat3( int, float, float, float, float, float, float );

int  Draw_Get_Seg_Mat( int, float* );

int  Draw_Get_Matrix( int, float* );

int  Draw_Put_Seg_Mat( int, float* );

int  Draw_Put_Matrix( int, float* );

int  Draw_Seg_Orient( int, float, float, float, Char );

int  Draw_Mat_Orient( int, float, float, float, Char );

int  Draw_Seg_Move( int, Char );

int  Draw_Mat_Move( int, Char );



/**************   C - View/Special interface Draw routines    ****************/

void Draw_Pic_View( Char );
void Draw_Pic_Reset( Char );

void Draw_Clipbox( float *limits, Char *md );

int  Draw_Alpha_Set( int );
int  Draw_Light_OnOff( int, int );
void Draw_Light_Define( int, int, float*, int );
void Draw_Mat_Light_Prop( int, int, float*, int );

void Draw_View( float );

void Draw_Zoom();
void Draw_Scale();
void Draw_Reload( Char );
void Draw_Refresh();
void Draw_Grid( Char );
void Draw_Print();



/******************    C - Axis interface Draw Routines    *********************/

int  Draw_New_Axis( Draw_Point3, Draw_Point3, float, float, float, int, int );

int  Draw_New_Box( Draw_Point3, int, int, int, int[], int, float[], int, int, int );

int  Draw_Easy_Box_2D( float, float, float, float, float*, char*, char*, int, int, int );

void Draw_Free_Box( int, Char );

void Draw_Free_Box_List();

void Draw_Set_Axis_Value( int    ax,             /* Axis Identifier */
                          int    cd,             /* Operator Code */
                          int     n,             /* Length Driver Number */
                          float* p1, float* p2,  /* Pointer to the various parameters */
                          float* p3, float* p4,
                          int*   p5, int*   p6, int*   p7 );

int  Draw_Get_Axis_Value( int, int, int, float*, float*, float*, float*, int*, int*, int* );

int  Draw_Get_Box_Value( int box, int cd, int n, void * tb );

void Draw_Plot_Axis( int, Draw_Point3, int );

void Draw_Plot_Box( int );

void Draw_Open_Box( int );

void Draw_Close_Box();

void Draw_Update_Box( int );

int  Draw_CV_Box( int, float, float, float, float*, float*, float* );



/******************    C - Easy-Axis Draw Routines    ************************/

void Draw_Axis_Inscale( float mi, float ma, int n, float*, float*, float*, float* );

void Draw_Axis_Setvscale( float, float, float, float, float*, float*, float* );

int Draw_Axis_AutoScale( float, float, float, int, int, float*, float*, float*, float*, float*, float* );

void Draw_Axis_Viewscale( float, float, float, float*, float*, float*, float*, float* );



/******************    C - Pannel Draw Routines    ************************/

void Draw_Pannel_Align( int, int );

void Draw_Pannel_Fsize( int, int, float );

void Draw_Pannel_Font( int, int, char*, int, int );

int  Draw_Pannel_Create( float, float, char*, int );

int  Draw_Bool_To_Pannel( int, float, float, float, float, char*, int, char* );

int  Draw_Enum_To_Pannel( int, float, float, float, float, char*, int, int*, int, char**, int*, int );

int  Draw_Str_To_Pannel( int, float, float, float, float, char*, int, Char*, Char*, int, Char );

int  Draw_Int_To_Pannel( int, float, float, float, float, char*, int, int*, int, int );

int  Draw_Flt_To_Pannel( int, float, float, float, float, char*, int, float*, float, float, float );

int  Draw_Text_To_Pannel( int, float, float, float, float, char*, int, char*, int );

int  Draw_Frame_To_Pannel( int, float, float, float, float, char*, int, float, int );

int  Draw_Pannel_Change( int, int );

int  Draw_Pannel_New_Text( int, int, char*, int );

int  Draw_Pannel_EnaDis( int, int, Char );

void Draw_Pannel_Delete( int );

void Draw_Pannel_Open( int );

void Draw_Pannel_Close( int );

int  Draw_Pannel_Get( int );

int  Draw_Pannel_Put( int );

int  Draw_Pannel_Request( int );



/******************    C - ionum Draw Routines    ************************/

void Draw__Write_Int( char*, int*, int, int );

void Draw__Write_Float( char*, int*, double  dv, int, int, int, int );

void Draw__Write_Fix( char*, int*, double, int, int, int );



#ifdef __cplusplus
}
#endif

#endif

