/*  P A S - P. WOLFERS SOFTWARE: V3.1-B5 OF 31-JAN-2022 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ long long

/* Include the PAS environment file. */
#include <cpas_defs.h>
static P Lx[6];

/* Define the local data section. */
static Blk( Rd, 1400 ) = {{
 15,  15, 101, 120, 112, 114, 101, 115, 115, 105, 111, 110,  95, 116, 121, 112,
101,  71,  71,  47, 114, 117, 110,  47, 109, 101, 100, 105,  97,  47, 112, 105,
101, 114, 114, 101,  47,  83,  83,  68,  95,  83,  97, 118, 101,  45,  49,  47,
 99, 112, 115, 104,  95, 107, 105, 116, 115,  47,  99, 112,  97, 115,  99,  97,
108,  95, 115, 114,  99,  95,  86,  51,  46,  49,  66,  54,  47, 112,  99, 109,
112,  95,  99, 111, 109, 112,  46, 112,  97, 115,   4,   4,  69,  88,  80,  84,
 10,  10, 101, 120, 112,  95, 103, 101, 110, 110, 117, 109,   4,   4,  69,  71,
 67,  84,   9,   9,  97, 116, 116, 114,  95, 116, 121, 112, 101,   4,   4,  65,
 84,  84,  89,   9,   9,  36, 117, 110, 115, 105, 103, 110, 101, 100,   8,   8,
 36, 105, 110, 116, 101, 103, 101, 114,   7,   7,  36, 115, 105, 110, 103, 108,
101,   7,   7,  36, 100, 111, 117,  98, 108, 101,   6,   6,  36,  97, 116, 116,
114,  95,  14,  14,  98, 117, 105, 108, 100,  95,  97, 114, 103,  95, 108, 105,
115, 116,   4,   4,  66,  65,  82,  71,  16,  16,  99,  97, 108, 108,  95, 102,
111, 114, 109,  97, 108,  95, 112, 114, 111,  99,   4,   4,  70,  67,  65,  76,
 18,  18,  99,  97, 108, 108,  95, 105, 110, 100, 105, 114, 101,  99, 116,  95,
112, 114, 111,  99,  12,  12,  99,  97, 108, 108,  95, 103, 101, 110, 101, 114,
105,  99,   4,   4,  67,  65,  76,  71,   9,   9, 111, 112, 101, 110,  95,  99,
 97, 108, 108,   4,   4,  79,  80,  69,  78,  14,  14, 114, 101,  97, 100, 119,
114, 105, 116, 101,  95,  99,  97, 108, 108,   4,   4,  82,  87,  73,  79,  18,
 18, 103, 101, 116,  95, 115, 116,  97, 116, 101,  95, 101, 102, 102,  95, 108,
105, 115, 116,  15,  15, 117, 115, 101, 114,  95, 115, 116,  97, 116, 101,  95,
 99,  97, 108, 108,   4,   4,  85,  83,  84,  65,   8,   8, 110, 101, 119,  95,
 99,  97, 108, 108,   4,   4,  78,  69,  87,  67,  12,  12, 100, 105, 115, 112,
111, 115, 101,  95,  99,  97, 108, 108,   4,   4,  70,  82,  69,  69,  20,  20,
103, 101, 110,  95, 108, 105, 115, 116,  95,  97, 103, 114, 101, 103,  97, 116,
 95, 115, 101, 116,   4,   4,  83,  65,  71,  82,  20,  20, 103, 101, 110,  95,
108, 105, 115, 116,  95,  97, 103, 114, 101, 103,  97, 116,  95, 116,  97,  98,
  4,   4,  84,  65,  71,  82,  20,  20, 103, 101, 110,  95, 108, 105, 115, 116,
 95,  97, 103, 114, 101, 103,  97, 116,  95, 114, 101,  99,   4,   4,  82,  65,
 71,  82,  12,  12, 103, 101, 116,  95,  97, 103, 114, 101, 103,  97, 116, 101,
  4,   4,  65,  71,  82,  69,  13,  13, 101, 120, 112,  95,  99, 111, 110, 115,
116,  95, 115, 101, 116,   4,   4,  67,  83,  69,  84,  11,  11, 103, 101, 116,
 95, 112, 114, 111,  99, 114, 101, 102,   4,   4,  71,  80,  82,  79,  15,  15,
101, 120, 112,  95, 103, 101, 110, 101, 114, 105,  99,  95, 114, 101, 102,   4,
  4,  69,  88,  71,  69,  14,  14, 101, 120, 112,  95, 105, 100, 101, 110, 116,
105, 102, 105, 101, 114,   4,   4,  82,  70,  79,  66,   9,   9, 101, 120, 112,
 95, 105, 110, 100, 105, 114,   4,   4,  73,  78,  68,  73,   9,   9, 101, 120,
112,  95, 102, 105, 101, 108, 100,   4,   4,  71,  70,  76,  68,   9,   9, 101,
120, 112,  95, 105, 110, 100, 101, 120,   4,   4,  73,  78,  68,  88,   7,   7,
101, 120, 112,  95, 117, 110,  97,   4,   4,  69,  88,  80,  82,   7,   7, 101,
120, 112,  95, 112, 111, 119,   7,   7, 101, 120, 112,  95, 109, 117, 108,   7,
  7, 101, 120, 112,  95,  97, 100, 100,   7,   7, 101, 120, 112,  95, 114, 101,
108,   7,   7, 101, 120, 112,  95, 110, 111, 116,   7,   7, 101, 120, 112,  95,
 97, 110, 100,  10,  10, 101, 120, 112, 114, 101, 115, 115, 105, 111, 110,  14,
 14,  99,  97, 115, 101,  95, 119, 111, 114, 107,  95, 108, 105, 115, 116,   4,
  4,  67,  65,  83,  68,  15,  15,  99,  97, 115, 101,  95, 100, 101, 102, 105,
110, 105, 116, 105, 111, 110,  17,  17, 115, 101, 116,  95,  97, 108, 105, 103,
110, 109, 101, 110, 116,  95, 115, 112,  99,   4,   4,  65,  76,  71,  78,  14,
 14,  99, 111, 110, 102, 111, 114, 109,  97, 110, 116,  95, 100, 101, 102,   4,
  4,  67,  78,  70,  65,   9,   9,  97, 114, 114,  97, 121,  95, 100, 101, 102,
  4,   4,  65,  82,  82,  89,   8,   8, 116, 121, 112, 101,  95, 115, 112,  99,
  4,   4,  84,  89,  80,  83,  18,  18, 115, 101, 116,  95, 100, 101,  99, 108,
 95,  97, 116, 116, 114, 105,  98, 117, 116, 101,   4,   4,  68,  65,  84,  84,
 13,  13, 118,  97, 114,  98, 108,  95, 115, 101, 116, 116, 105, 110, 103,   4,
  4,  86,  65,  82,  66,   9,   9,  99, 111, 110, 115, 116, 100, 101,  99, 108,
  4,   4,  67,  79,  78,  68,   8,   8, 116, 121, 112, 101, 100, 101,  99, 108,
  4,   4,  84,  89,  80,  68,   7,   7, 118,  97, 114, 100, 101,  99, 108,   9,
  9, 108,  97,  98, 101, 108, 100, 101,  99, 108,   4,   4,  76,  65,  66,  68,
 13,  13, 115, 116,  97, 116, 101, 109, 101, 110, 116, 100, 101,  99, 108,   4,
  4,  83,  84,  65,  68,  13,  13,  97, 114, 103, 117, 109, 101, 110, 116,  95,
108, 105, 115, 116,   4,   4,  65,  82,  71,  76,   3,   3,  46, 114, 118,  16,
 16, 102, 111, 114, 109,  97, 108,  95, 112, 114, 111,  99,  95, 100, 101,  99,
108,   4,   4,  70,  80,  68,  69,  15,  15, 102, 111, 114, 109,  97, 108,  95,
112, 114, 111,  99,  95, 112, 116, 114,   4,   4,  70,  80,  68,  69,  18,  18,
105, 110, 115, 101, 114, 116,  95, 110, 101, 119,  95, 103, 101, 110, 101, 114,
105,  99,   4,   4,  73,  71,  69,  78,   9,   9, 112, 114, 111,  99,  95, 100,
101,  99, 108,   4,   4,  68,  80,  82,  79,   4,   4,  80,  82,  67,  95,   4,
  4,  80,  82,  67,  95,   9,   9, 112, 114, 111,  99,  95,  98, 111, 100, 121,
  4,   4,  71,  69,  78,  68,   9,   9, 103, 101, 110, 101,  95, 100, 101,  99,
108,  10,  10, 103, 101, 110,  95,  97, 115, 115, 105, 103, 110,   4,   4,  71,
 65,  83,  83,  11,  11, 114, 101, 116, 117, 114, 110, 115, 116,  97, 116, 101,
  4,   4,  82,  69,  84,  85,  15,  15,  97, 115, 115, 105, 103, 110, 109, 101,
110, 116, 115, 116,  97, 116, 101,   4,   4,  65,  83,  83,  73,  10,  10, 119,
105, 116, 104,  95, 115, 116,  97, 116, 101,   4,   4,  87,  73,  84,  72,   7,
  7, 105, 102, 115, 116,  97, 116, 101,   4,   4,  73,  70,  83,  84,   9,   9,
101, 120, 105, 116, 115, 116,  97, 116, 101,   4,   4,  69,  88,  83,  84,   9,
  9, 108, 111, 111, 112, 115, 116,  97, 116, 101,   4,   4,  76,  79,  79,  80,
  8,   8, 102, 111, 114, 115, 116,  97, 116, 101,   4,   4,  70,  79,  82,  95,
  9,   9, 103, 111, 116, 111, 115, 116,  97, 116, 101,   4,   4,  71,  84,  79,
 76,  10,  10,  98, 101, 103, 105, 110, 115, 116,  97, 116, 101,   4,   4,  66,
 69,  71,  83,  12,  12, 108,  97,  98, 101, 108,  95,  97, 116, 116,  97,  99,
104,   9,   9, 115, 116,  97, 116, 101, 109, 101, 110, 116,   4,   4,  83,  84,
 65,  84,   9,   9, 115, 116,  97, 116, 101, 108, 105, 115, 116,   4,   4,  83,
 84,  76,  73,   9,   9,  99, 109, 112,  95,  98, 108, 111,  99, 107,   4,   4,
 66,  76,  79,  67,   5,   5,  46, 116, 101, 109, 112,   8,   8,  99, 109, 112,
 95, 105, 110, 105, 116,   9,   9,  99, 109, 112,  95, 112,  97, 115, 115,  50,
 11,  11,  99, 109, 112,  95,  99, 111, 109, 112, 105, 108, 101,   4,   4,  67,
 77,  80,  77,   0,   0,   0,   0,   0
}};

/* Define the local static Initialized section. */
static Blk( Ri, 64 ) = {{
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
}};

/* Define the local static section. */
static Blk( Rs, 8 );

/* Declaration of external variables. */
extern Blk(V_typ_std, 248 );
extern UB V_cmp_range;
extern V V_curr_descr;
extern UB V_enm_range;
extern Blk(V_sy_sym, 8 );
extern V V_attr_list;
extern Blk(V_sy_ident, 32 );
extern V V_ima_typ;
extern V V_int_typ;
extern Blk(V_ide_udptr, 120 );
extern V V_iof_std_open;
extern UB V_sy_label_flag;
extern SL V_dst_seti;
extern SL V_dst_seta;
extern SL V_dst_setw;
extern V V_set_entry_proc;
extern SL V_stri_stroffset;
extern UB V_lastsymb;
extern V V_sy_search;
extern Blk(V_lex_ident_tree, 4160 );
extern SL V_ident_disp;
extern SL V_sy_ival;
extern G V_sy_rval;
extern Blk(V_sy_string, 264 );
extern SL V_curr_disp;
extern UB V_sy_casedef;
extern UB V_err_prt;
extern SL V_sy_descr_size;
extern V V_sy_type_gfirst;
extern UB V_sy_init_mod;
extern UB V_sy_fix_range_ctl;
extern SL V_fptr_size;
extern SL V_stri_descrsz;
extern SL V_stri_lengthsz;
extern V V_usi_tab;
extern V V_csi_tab;
extern UB V_cmp_twicedclon;
extern UB V_cmp_twicedcl;
extern SL V_cmp_igenv;
extern V V_all_fglobal;
extern V V_all_lglobal;
extern V V_all_fstatic;
extern V V_all_lstatic;
extern SL V_inte_size;
extern V V_uns_typ;
extern SL V_sngl_size;
extern SL V_dble_size;
extern UB V_tcas_flag;
extern SL V_curr_lex;
extern UB V_error_result;
extern UB V_cmp_dynamic;
extern Blk(V_lex_ident_level, 128 );
extern UB V_sy_generic_qmod;
extern V V_pro_d_first;
extern V V_pro_d_last;
extern Blk(V_opname, 960 );
extern SL V_proc_seq;
extern SL V_cmp_traceopt;
extern SL V_cmp_trace;
extern UB V_cmp_objf;
extern V V_pro_last;
extern V V_pro_first;
extern V V_new_entry_proc;
extern V V_newh_entry_proc;
extern V V_dispose_entry_proc;
extern V V_iof_std_close;
extern V V_inp_std_sel;
extern V V_inp_std_gene;
extern V V_inp_std_eoln;
extern V V_inp_std_bin;
extern V V_out_std_sel;
extern V V_out_std_gene;
extern V V_out_std_eoln;
extern V V_out_std_bin;
extern V V_gen_std_string1;
extern V V_gen_std_cnfardsc;
extern Blk(V_ope_table, 240 );
extern V V_cntx_label;
extern SL V_cntx_lblvl;
extern V V_wildtmp_stk;
extern V V_std_inp_file;
extern V V_std_out_file;
extern V V_src_control;
extern UB V_emergency_stop;
extern V V_pro_current;
extern SL V_cprc_disp;
extern UB V_sy_var_init_mod;
extern V V_cntx_varbl;
extern V V_wildtmp_typ;
extern V V_wildtmp_ide;
extern SL V_wildtmp_psz;
extern Blk(V_wildtmp_pal, 8 );
extern UB V_opt_exec;
extern UB V_cmp_cmpdbg;
extern UB V_cmp_genenv;
extern SL V_cmp_listlvl;
extern UB V_cmp_macf;
extern UB V_cmp_cobj;
extern UB V_cmp_bltt;
extern UB V_cmp_opt;
extern UB V_cmp_debugopt;
extern UB V_cmp_debug;
extern SL V_cmp_tracecount;
extern SL V_cntx_procname;
extern SL V_cntx_srcfname;
extern SL V_cntx_linenbr;
extern SL V_cntx_size;
extern V V_cntx_typ;
extern V V_env_file;
extern V V_env_first;
extern V V_env_last;
extern C V_sy_ch;
extern V V_lst_current;
extern V V_pas_main;


/* Function/procedure prototypes. */
void P_lst_page();
void P_src_error(V F_modnam, SL F_number, UB F_severity);
void P_src_end_of_line();
C P_src_search_char();
void P_src_error_s(V F_modulesy, SL F_number, UB F_severity, V F_id1, V F_id2);
void P_data_format_set(V F_ty);
V P_tab_new(SL F_sz);
void P_val_new(V *F_p, V F_ty);
void P_val_free(V *F_p);
void P_val_copy(V *F_v1, V *F_v2, UB F_bfree);
void P_all_new(V *F_p, V F_ty, V F_id, UB F_kind);
void P_all_free(V F_p);
void P_lgt_new(V *F_p, V F_ty, UB F_knd, V F_prm);
void P_lgt_new_copy(V F_model, V *F_copy);
void P_lgt_copy_tree(V F_src, V *F_dst);
void P_lgt_free(V *F_p);
void P_lgt_free_tree(V *F_p);
V P_lgt_new_econst(V F_ty, SL F_iv);
SL P_lgt_get_econst(V F_lgt, SL F_idf);
V P_lgt_new_code(UB F_pcd, V F_par);
V P_lgt_new_call(V F_pty, V F_pro, V F_par);
V P_lgt_link(V F_lgt);
V P_lgt_new_idref(V F_id, V F_lnk);
V P_lgt_new_addsub(UB F_bsub, UB F_bfree, V F_lgt1, V F_lgt2);
void P_new_disp_level(V F_ow, UB F_kind);
void P_ide_reserve_disp(SL F_prv);
SL P_match(V F_s1, V F_s2);
V P_new_int_name(V F_head, SL *F_nbs);
V P_level_search(V F_fp);
V P_lex_search(SL F_disp);
V P_ide_search(UW F_fs);
void P_ide_new(UB F_fc, V F_ty, V *F_ip);
void P_gen_cntxvar(V F_pr, V F_id);
V P_lgt_new_line(V F_pr, V F_lgp, SL F_icd);
void P_gen_linetrace(V F_pr, V *F_lgh, V *F_lgl, SL F_icd);
void P_label_purge(V *F_prv_cntx);
SL P_typ_alignement(SL F_iaddr, V F_aln);
SL P_ide_typ_align(SL F_iaddr, V F_ty);
void P_cte_allocate(V F_vp, V F_id);
void P_ide_new_typ(UB F_frm, V *F_p);
void P_ide_new_typ_range(SL F_min, SL F_max, V F_parent, V *F_typ);
void P_tmpstk_free(V F_stkp);
void P_free_typ_list(V *F_p);
void P_free_ide_list(V *F_p);
void P_ide_create_name(V F_name);
void P_ide_int_label();
V P_ide_search_from_nameid(V F_ip);
void P_set_gbl_def_nam(V *F_trg, V F_src, C F_ach);
void P_set_env_file_spc(V F_pcur);
V P_new_oper(UB F_pcd, V F_rty, V F_it1, UB F_cv1, UW F_ip1, V F_it2, UB F_cv2, 
UW F_ip2);
void P_compile_set_title();
void P_compile_set_sbttl(V F_prc);
void P_insymbol();
void P_skip_symbol(UB F_tosymbol, UB F_errflg, UB F_rflg);
void P_insy_init();
void P_set_strname(V *F_nam);
void P_set_stdname(V F_pr);
UB P_comp_type(V F_eff, V F_frm, UB F_exact, UB F_sym);
UB P_comp_proc_arg(V F_epr, V F_fpr);
V P_compare_proc_argid(V F_pgc, V F_pgl, V F_ent);
void P_type_parm_cte_init(V F_ty, V *F_lghf, V *F_lghl, SL *F_count);
void P_type_parm_cte_release(V F_ty);
void P_string_in_array(V F_lgt, V F_ty);
void P_string_in_substring(V F_lgt, V F_ty);
void P_call_setting(V *F_lgt);
void P_generic_search(V F_id, SL F_npa, V *F_pg, V F_parm_lst);
V P_exp_genoper(V F_id, V F_p, V F_oblst);
V P_exp_genop(UB F_op, V F_oblst);
V P_lgt_gen_store(V F_prm, UB F_bstd, UB F_bovr);
V P_generate_call(V F_ip, V F_lgp, SL F_np, UB F_bsnsea);
void P_initialize_varbl(V F_ip);
void P_init_d_dyn(V F_ty, V F_trg, V *F_lgth, V *F_lgtl, UB F_bindir, V F_ide);
void P_init_d_varbl(V F_ip);
void P_type_check_parm(V F_lgt);
V P_type_parm_set(V F_ip, V F_lgt);
void P_cmp_block(V F_owner, UB F_bproc, SL F_glicd);
V P_lgt_type_eval(V F_troot, V F_prm_actual, V F_ty, UB F_elm_arr);
void P_lgt_gen_routine(V F_ty);
V P_lgt_type_compute(V F_expr, V F_expe, SL F_dvl, V F_obj);
void P_lgt_extract_simple_cte(V F_lgt);
void P_lgt_all_fparm(V F_pr);
void P_lgt_pass1_complet(V F_pr);
void P_lgt_dump_proc(V F_pr);
void P_lgt_dump_static(V F_pr);
void P_generation_setting();
void P_generate_code_p1(V F_proc);
void P_generate_code_p2();
void P_pas_read_env_file();
void P_pas_write_env_file();
void PAS_COMILER_cmp_pass2(V F_pr);
V PAS_COMILER_PRC_00000000();
V PAS_COMILER_PRC_00000001(UB F_isfunction);
V PAS_COMILER_PRC_00000002(UB F_isfunction);
V PAS_COMILER_PRC_00000019(V F_ty);
V PAS_COMILER_PRC_00000036(UB F_stopper, UB F_seq_flg);
V PAS_COMILER_PRC_00000037(V F_lgp, UB F_bsequ);
void PAS_COMILER_PRC_00000038(UB F_v_class, SL *F_isz, SL *F_aln, V F_ty);
void PAS_COMILER_PRC_00000039(V *F_it, SL F_descr_sz, V F_parm, UB F_bdeforg, UB
F_buseorg);


/* Procedure/Function : " expression_type "  */
V PAS_COMILER_PRC_00000005(V F_it, UB F_exact, UB F_no_def, UB F_no_check){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  C Rv4;
  register V Rv5;
  register V Rv6;
  register V Rv7;
  V Rv8;
  register V Rv9;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=181; /* line # 181 */
  Rv0=0;
  Rv1=PAS_COMILER_PRC_00000000();
  if (Rv1!=NULL) {
    Rv2=Rv1;
    Rv3=F_it;
    if (((V *)Rv2)[3]!=F_it) {
      Ra.sl[6]=187; /* line # 187 */
      if (((UB *)Rv2)[40]==14) {
        if (((V *)Rv2)[3]==V_typ_std.v[13]&&P_comp_type(((V *)Rv2)[3],F_it,0,0))
         {
          ((V *)Rv2)[3]=F_it;
          Rv0=1;
        }
        else {
          Ra.sl[6]=192; /* line # 192 */
          if (P_comp_type(((V *)Rv2)[3],V_typ_std.v[10],0,0)||P_comp_type(((V *)
          Rv2)[3],V_typ_std.v[0],1,0)) {
            if ((((UB *)Rv3)[92]==10&&((UB *)((V *)Rv2)[3])[92]==0)&&P_comp_type((
            (V *)Rv2)[3],F_it, F_exact,0)) {
              Ra.sl[6]=199; /* line # 199 */
              if (((V *)Rv2)[7]!=NULL) Rv4=(C)((SL *)((V *)Rv2)[7])[13];
              else Rv4=32;
              P_val_free(((V *)Rv2)+7);
              P_val_new(((V *)Rv2)+7,V_typ_std.v[10]);
              ((V *)Rv2)[3]=V_typ_std.v[10];
              Rv5=((V *)Rv2)[7];
              Ra.sl[6]=205; /* line # 205 */
              ((UB *)Rv5)[48]=29;
              ((SL *)Rv5)[6]=1;
              ((V *)Rv5)[7]=PAS__NEW(3);
              ((UB *)((V *)Rv5)[7])[0]=1;
              PAS__CHA_TO_STR(((V *)Rv5)[7],Rv4);
              Ra.sl[6]=210; /* line # 210 */
              Rv0=1;
            }
            else {
              if (((UB *)Rv3)[92]==8&&((V *)Rv3)[14]==V_typ_std.v[0]) {
                Ra.sl[6]=216; /* line # 216 */
                P_string_in_array(Rv1, F_it);
                Rv0=1;
              }
              else {
                if (((V *)Rv3)[0]==((V *)Rv2)[3]) {
                  Ra.sl[6]=222; /* line # 222 */
                  P_string_in_substring(Rv1, F_it);
                  Rv0=1;
                }
              }
            }
          }
          else {
            Ra.sl[6]=227; /* line # 227 */
            if (((V *)((V *)Rv2)[3])[0]==F_it) Rv0=1;
            else switch (((UB *)Rv3)[92]) {
              case 0:
              case 1:
              case 2:if (((V *)Rv3)[0]==((V *)Rv2)[3]) {
                Ra.sl[6]=233; /* line # 233 */
                if (((V *)Rv2)[7]!=NULL) {
                  Rv6=((V *)Rv2)[7];
                  if (((UB *)Rv3)[112]) {
                    Ra.sl[6]=238; /* line # 238 */
                    if (((UL *)Rv3)[29]<=((UL *)Rv6)[13]&&((UL *)Rv3)[30]>=((UL *)
                    Rv6)[13]) {
                      ((V *)Rv2)[3]=F_it;
                      ((V *)Rv6)[4]=F_it;
                      Rv0=1;
                    }
                  }
                  else {
                    if (((SL *)Rv3)[29]<=((SL *)Rv6)[13]&&((SL *)Rv3)[30]>=((SL *)
                    Rv6)[13]) {
                      Ra.sl[6]=243; /* line # 243 */
                      ((V *)Rv2)[3]=F_it;
                      ((V *)Rv6)[4]=F_it;
                      Rv0=1;
                    }
                  }
                  if (!Rv0) P_src_error(Rd.s+92,154,2);
                }
              }
              break;
              case 22:Ra.sl[6]=249; /* line # 249 */
              if (((V *)Rv3)[0]==((V *)Rv2)[3]) {
                if (((V *)Rv2)[7]!=NULL) {
                  Rv7=((V *)Rv2)[7];
                  if (((SL *)((V *)Rv2)[3])[11]<=((SL *)Rv3)[11]) {
                    Ra.sl[6]=255; /* line # 255 */
                    ((V *)Rv2)[3]=F_it;
                    ((V *)Rv7)[4]=F_it;
                    if (V_cmp_range&&!F_no_check) {
                      Rv8=P_lgt_type_eval(((V *)Rv3)[13],V_curr_descr,NULL,0);
                      Ra.sl[6]=261; /* line # 261 */
                      ((V *)Rv8)[0]=P_lgt_type_eval(((V *)Rv3)[14],V_curr_descr,
                      NULL,0);
                      ((V *)Rv1)[0]=Rv8;
                      Rv1=P_lgt_new_code(2, Rv1);
                      ((V *)Rv1)[3]=F_it;
                    }
                    Ra.sl[6]=266; /* line # 266 */
                    Rv0=1;
                  }
                }
              }
              break;
              case 3:
              case 4:Rv9=((V *)Rv2)[7];
              Ra.sl[6]=272; /* line # 272 */
              if (((V *)Rv2)[3]!=NULL) switch (((UB *)((V *)Rv2)[3])[92]) {
                case 2:((G *)Rv9)[7]=(double)((SL *)Rv9)[13];
                Rv0=1;
                break;
                case 3:
                case 4:Rv0=1;
                break;
                default:break;
              }
              Ra.sl[6]=278; /* line # 278 */
              if (Rv0) {
                ((UB *)Rv9)[48]=((UB *)Rv3)[92];
                ((V *)Rv9)[4]=F_it;
                ((V *)Rv2)[3]=F_it;
              }
              break;
              default:break;
            }
          }
        }
      }
      Ra.sl[6]=295; /* line # 295 */
      if (!Rv0) {
        if (!P_comp_type(((V *)Rv2)[3],F_it, F_exact,0)) {
          P_src_error(Rd.s+92,109,3);
          ((V *)Rv1)[3]=F_it;
        }
        else {
          Ra.sl[6]=302; /* line # 302 */
          if (V_cmp_range&&!F_no_check) switch (((UB *)Rv3)[92]) {
            case 0:
            case 1:
            case 2:if (V_enm_range) {
              Ra.sl[6]=307; /* line # 307 */
              Rv8=P_lgt_new_econst(((V *)Rv2)[3],((SL *)Rv3)[29]);
              ((V *)Rv8)[0]=P_lgt_new_econst(((V *)Rv2)[3],((SL *)Rv3)[30]);
              ((V *)Rv1)[0]=Rv8;
              Rv1=P_lgt_new_code(2, Rv1);
              ((V *)Rv1)[3]=F_it;
            }
            break;
            case 22:Ra.sl[6]=316; /* line # 316 */
            Rv8=P_lgt_type_eval(((V *)Rv3)[13],V_curr_descr,NULL,0);
            ((V *)Rv8)[0]=P_lgt_type_eval(((V *)Rv3)[14],V_curr_descr,NULL,0);
            ((V *)Rv1)[0]=Rv8;
            Rv1=P_lgt_new_code(2, Rv1);
            ((V *)Rv1)[3]=F_it;
            break;
            default:break;
          }
        }
      }
    }
  }
  Ra.sl[6]=326; /* line # 326 */
  if (F_no_def) {
    if (((UB *)Rv1)[40]==17) P_src_error(Rd.s+92,181,2);
  }
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_gennum "  */
SL PAS_COMILER_PRC_00000006(V *F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+96;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=343; /* line # 343 */
  Rv0=PAS_COMILER_PRC_00000005((*F_ty),0,0,0);
  Rv1=Rv0;
  (*F_ty)=((V *)Rv1)[3];
  if (((UB *)Rv1)[40]==14) {
    Ra.sl[6]=348; /* line # 348 */
    Ret=((SL *)((V *)Rv1)[7])[13];
  }
  else {
    P_src_error(Rd.s+110,853,2);
    Ret=((SL *)(*F_ty))[29];
  }
  Ra.sl[6]=355; /* line # 355 */
  P_lgt_free_tree(&Rv0);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " attr_type "  */
V PAS_COMILER_PRC_00000007(V F_lgt, V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 72 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  V Rv2;
  register V Rv3;
  SL Rv4;
  register V Rv5;
  register V Rv6;
  V Rv7;
  register V Rv8;
  register V Rv9;
  register V Ret;

  /* Code of procedure/function */
  Ra.ub[0]=31;
  Ra.v[5]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+40;
  Ra.v[6]=Rd.s+114;
  Ra.v[7]=Rd.s+17;
  Ra.sl[16]=380; /* line # 380 */
  Rv0=NULL;
  Rv1=F_ty;
  P_insymbol();
  if (V_sy_sym.ub[0]==0) {
    Ra.sl[16]=386; /* line # 386 */
    Rv2=P_level_search(V_attr_list);
    if (Rv2==NULL) P_src_error_s(Rd.s+127,105,3, V_sy_ident.s,NULL);
    else switch (((UB *)Rv2)[57]) {
      case 0:Ra.sl[16]=397; /* line # 397 */
      if (F_lgt==NULL) P_src_error_s(Rd.s+127,161,3, V_sy_ident.s,NULL);
      P_lgt_new(&Rv0, V_typ_std.v[13],4, F_lgt);
      F_lgt=NULL;
      break;
      case 1:Ra.sl[16]=403; /* line # 403 */
      if (((SL *)Rv1)[11]>=0) Rv0=P_lgt_new_econst(V_typ_std.v[2],((SL *)Rv1)[11]
      );
      else {
        Rv0=P_lgt_type_compute(((V *)Rv1)[8],((V *)Rv1)[9],((SL *)Rv1)[11],F_lgt);
        Ra.sl[16]=408; /* line # 408 */
        if (F_lgt!=NULL) {
          if (((UB *)F_lgt)[40]!=14) F_lgt=NULL;
        }
      }
      break;
      case 8:
      case 9:Ra.sl[16]=416; /* line # 416 */
      if (P_comp_type(F_ty, V_typ_std.v[10],1,0)) F_ty=((V *)((V *)F_ty)[13])[4]
      ;
      switch (((UB *)F_ty)[92]) {
        case 8:
        case 9:Rv3=((V *)F_ty)[15];
        Ra.sl[16]=421; /* line # 421 */
        if (((UB *)Rv3)[92]==22) {
          if (((UB *)Rv2)[57]==8) Rv0=((V *)Rv3)[13];
          else Rv0=((V *)Rv3)[14];
          Ra.sl[16]=430; /* line # 430 */
          Rv0=P_lgt_type_compute(NULL,Rv0,1, V_curr_descr);
          ((V *)Rv0)[3]=((V *)Rv3)[0];
        }
        else {
          Ra.sl[16]=435; /* line # 435 */
          if (((UB *)Rv2)[57]==8) Rv4=((SL *)Rv3)[29];
          else Rv4=((SL *)Rv3)[30];
          Rv0=P_lgt_new_econst(((V *)F_ty)[15],Rv4);
        }
        break;
        default:Ra.sl[16]=440; /* line # 440 */
        P_src_error(Rd.s+127,158,3);
        Rv0=P_lgt_new_econst(V_typ_std.v[15],1);
        break;
      }
      break;
      case 2:
      case 3:Ra.sl[16]=447; /* line # 447 */
      if (((UB *)Rv1)[92]<=2) {
        if (((UB *)Rv2)[57]==2) Rv0=P_lgt_new_econst(F_ty,((SL *)Rv1)[29]);
        else Rv0=P_lgt_new_econst(F_ty,((SL *)Rv1)[30]);
      }
      else {
        if (((UB *)Rv1)[92]==22) {
          Ra.sl[16]=453; /* line # 453 */
          if (((UB *)Rv2)[57]==2) Rv0=((V *)Rv1)[13];
          else Rv0=((V *)Rv1)[14];
          Rv0=P_lgt_type_compute(NULL,Rv0,1, V_curr_descr);
        }
      }
      break;
      case 4:Ra.sl[16]=459; /* line # 459 */
      if (F_lgt!=NULL) {
        ((V *)F_lgt)[0]=P_lgt_new_econst(V_typ_std.v[2],1);
        Rv0=P_exp_genop(11, F_lgt);
        F_lgt=NULL;
      }
      break;
      case 5:Ra.sl[16]=466; /* line # 466 */
      if (F_lgt!=NULL) {
        ((V *)F_lgt)[0]=P_lgt_new_econst(V_typ_std.v[2],1);
        Rv0=P_exp_genop(12, F_lgt);
        F_lgt=NULL;
      }
      break;
      case 6:Ra.sl[16]=473; /* line # 473 */
      switch (((UB *)Rv1)[92]) {
        case 1:if (F_lgt==NULL) Rv0=P_lgt_link(((V *)Rv1)[13]);
        else {
          Ra.sl[16]=480; /* line # 480 */
          P_lgt_new(&Rv0,((V *)V_ima_typ)[14],1, P_lgt_link(((V *)Rv1)[13]));
          ((V *)((V *)Rv0)[1])[0]=F_lgt;
          ((V *)F_lgt)[0]=P_lgt_new_econst(V_int_typ,((SL *)((V *)((V *)Rv1)[13]
          )[3])[25]);
        }
        break;
        case 11:
        case 12:Ra.sl[16]=487; /* line # 487 */
        if (((V *)Rv1)[13]!=NULL) {
          Rv5=((V *)Rv1)[13];
          if (F_lgt==NULL) {
            Ra.sl[16]=492; /* line # 492 */
            if (((V *)Rv5)[13]==NULL) Rv0=P_lgt_link(((V *)Rv5)[13]);
          }
        }
        break;
        default:break;
      }
      break;
      case 7:Ra.sl[16]=501; /* line # 501 */
      if (F_ty==V_typ_std.v[7]) Rv4=0;
      else {
        if (((UB *)Rv1)[92]==7&&((V *)Rv1)[12]!=NULL) Rv4=((SL *)((V *)Rv1)[12])
        [11];
        else Rv4=2147483647;
      }
      Rv0=P_lgt_new_econst(V_typ_std.v[2],Rv4);
      break;
      case 10:
      case 11:
      case 12:
      case 13:
      case 14:
      case 15:Ra.sl[16]=514; /* line # 514 */
      Ra.ub[1]=0;
      switch (((UB *)Rv1)[92]) {
        case 2:Ra.sl[16]=521; /* line # 521 */
        if (((UB *)Rv1)[112]) {
          PAS__VWRITE_INIT(Ra.s,1);
          PAS__WRITE_STR(Rd.s+131,-1,-1,32);
          PAS__WRITE_EOLN();
        }
        else {
          PAS__VWRITE_INIT(Ra.s,1);
          PAS__WRITE_STR(Rd.s+142,-1,-1,32);
          PAS__WRITE_EOLN();
        }
        PAS__VWRITE_INIT(Ra.s,0);
        PAS__WRITE_INT(((SL *)Rv1)[11],1,0);
        PAS__WRITE_CHAR(36);
        PAS__WRITE_EOLN();
        break;
        case 3:PAS__VWRITE_INIT(Ra.s,1);
        PAS__WRITE_STR(Rd.s+152,-1,-1,32);
        PAS__WRITE_EOLN();
        break;
        case 4:Ra.sl[16]=526; /* line # 526 */
        PAS__VWRITE_INIT(Ra.s,1);
        PAS__WRITE_STR(Rd.s+161,-1,-1,32);
        PAS__WRITE_EOLN();
        break;
        default:break;
      }
      PAS__VWRITE_INIT(Ra.s,0);
      PAS__WRITE_STR(Rd.s+170,-1,-1,32);
      PAS__WRITE_EOLN();
      Rv6=((V *)Rv2)[0];
      Ra.sl[16]=531; /* line # 531 */
      PAS__VWRITE_INIT(Ra.s,0);
      PAS__WRITE_CHT(Rv6+1,31,((UB *)Rv6)[0],-1,32);
      PAS__WRITE_EOLN();
      P_ide_create_name(Ra.s);
      Rv7=P_lex_search(0);
      if (Rv7!=NULL) {
        Ra.sl[16]=536; /* line # 536 */
        Rv8=Rv7;
        if (((UB *)Rv8)[56]==4) {
          P_lgt_new(&Rv0,((V *)Rv8)[4],14,NULL);
          Rv9=Rv0;
          Ra.sl[16]=542; /* line # 542 */
          ((V *)Rv9)[7]=((V *)Rv8)[8];
          P_val_new(((V *)Rv9)+7,((V *)Rv8)[4]);
        }
      }
      if (Rv0==NULL) {
        Ra.sl[16]=548; /* line # 548 */
        Rv0=P_lgt_new_econst(V_typ_std.v[2],0);
        P_src_error_s(Rd.s+127,164,2,((V *)Rv2)[0],NULL);
      }
      break;
      case 16:Ra.sl[16]=554; /* line # 554 */
      if (((UB *)Rv1)[92]==11||((UB *)Rv1)[92]==12) Rv0=P_lgt_new_econst(V_int_typ,(
      (SL *)Rv1)[24]);
      break;
      default:break;
    }
    Ra.sl[16]=559; /* line # 559 */
    P_insymbol();
  }
  else P_src_error(Rd.s+127,162,2);
  Ra.sl[16]=565; /* line # 565 */
  if (F_lgt!=NULL) P_lgt_free(&F_lgt);
  if (Rv0!=NULL) Ret=Rv0;
  else {
    P_src_error(Rd.s+127,169,2);
    Ra.sl[16]=570; /* line # 570 */
    Ret=P_lgt_new_econst(V_typ_std.v[2],1);
  }
  PAS__curr_cntx=Ra.v[5];
  return(Ret);
}


/* Procedure/Function : " build_arg_list "  */
V PAS_COMILER_PRC_00000008(V F_pr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  UB Rv3;
  V Rv4;
  V Rv5;
  register V Rv6;
  V Rv7;
  register V Rv8;
  V Rv9;
  register V Rv10;
  V Rv11;
  register V Rv12;
  V Rv13;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+178;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=590; /* line # 590 */
  Rv0=F_pr;
  Rv1=NULL;
  Rv2=((V *)Rv0)[8];
  if (((V *)Rv0)[11]!=NULL) {
    Ra.sl[6]=595; /* line # 595 */
    if (!((UB *)((V *)Rv0)[11])[91]) Rv2=((V *)Rv2)[3];
  }
  if (Rv2!=NULL) {
    if (V_sy_sym.ub[0]!=14) P_src_error(Rd.s+196,22,2);
    else P_insymbol();
    Ra.sl[6]=600; /* line # 600 */
    while (Rv2!=NULL){
      if (((UB *)Rv2)[56]==7) {
        Rv3=0;
        Ra.sl[6]=605; /* line # 605 */
        Rv4=((V *)Rv2)[9];
        if (V_sy_sym.ub[0]==0) {
          Rv5=P_ide_search(928);
          if (Rv5!=V_ide_udptr.v[5]) {
            Ra.sl[6]=612; /* line # 612 */
            Rv6=Rv5;
            if (((UB *)Rv6)[56]==5) {
              Rv7=NULL;
              Ra.sl[6]=617; /* line # 617 */
              if (((V *)Rv6)[4]!=NULL) {
                Rv8=((V *)Rv6)[4];
                if (((UB *)Rv8)[92]==6) Rv7=((V *)Rv8)[13];
              }
              if (Rv7!=NULL) {
                Ra.sl[6]=622; /* line # 622 */
                if (((V *)Rv7)[8]!=((V *)Rv4)[8]) {
                  if (P_comp_proc_arg(Rv7, Rv4)) Rv3=1;
                  else P_src_error_s(Rd.s+196,120,3, V_sy_ident.s,NULL);
                }
              }
            }
            else {
              Ra.sl[6]=628; /* line # 628 */
              if (((UB *)Rv6)[56]==7) {
                Rv7=((V *)Rv6)[9];
                if (((V *)Rv7)[8]!=((V *)Rv4)[8]) {
                  Ra.sl[6]=633; /* line # 633 */
                  if (P_comp_proc_arg(Rv7, Rv4)) Rv3=1;
                  else P_src_error_s(Rd.s+196,121,3, V_sy_ident.s,NULL);
                }
              }
              else {
                Ra.sl[6]=639; /* line # 639 */
                Rv9=P_compare_proc_argid(((V *)Rv5)[10],((V *)Rv5)[11],Rv4);
                Ra.sl[6]=644; /* line # 644 */
                Rv9=((V *)Rv5)[10];
                while (Rv9!=NULL&&!Rv3){
                  Rv10=Rv9;
                  Ra.sl[6]=649; /* line # 649 */
                  if (!((UB *)Rv10)[8]) {
                    Rv7=((V *)Rv10)[2];
                    Rv3=P_comp_proc_arg(Rv7, Rv4);
                  }
                  Ra.sl[6]=654; /* line # 654 */
                  Rv9=((V *)Rv10)[0];
                }
                if (!Rv3) P_src_error_s(Rd.s+196,122,3, V_sy_ident.s,((V *)Rv2)[
0]);
              }
            }
          }
          Ra.sl[6]=659; /* line # 659 */
          P_insymbol();
        }
        else {
          Rv7=((V *)Rv2)[8];
          Ra.sl[6]=664; /* line # 664 */
          if (Rv7==NULL) P_src_error_s(Rd.s+196,148,3,((V *)Rv2)[0],NULL);
          else {
            if (Rv4!=NULL) Rv3=P_comp_proc_arg(Rv7, Rv4);
            else P_src_error_s(Rd.s+196,123,3,((V *)Rv2)[0],NULL);
          }
        }
        Ra.sl[6]=670; /* line # 670 */
        if (Rv3) {
          P_lgt_new(&Rv11,((V *)Rv7)[11],11,NULL);
          ((V *)Rv11)[6]=Rv7;
          if (((V *)Rv7)[11]!=((V *)Rv4)[11]&&((V *)Rv4)[11]!=NULL) {
            Ra.sl[6]=675; /* line # 675 */
            if (!P_comp_type(((V *)Rv7)[11],((V *)Rv4)[11],1,0)) P_src_error_s(Rd
            .s+196,124,3,((V *)Rv5)[0],((V *)Rv2)[0]);
          }
        }
      }
      else {
        Ra.sl[6]=681; /* line # 681 */
        Rv11=PAS_COMILER_PRC_00000005(((V *)Rv2)[4],((UB *)Rv2)[94]!=8,0,0);
        Rv12=Rv11;
        if (((UB *)Rv12)[40]==17) {
          if (((V *)Rv2)[8]==NULL) {
            Ra.sl[6]=686; /* line # 686 */
            P_src_error_s(Rd.s+196,854,3,((V *)Rv2)[0],NULL);
          }
          else {
            ((UB *)Rv12)[40]=14;
            ((V *)Rv12)[3]=((V *)Rv2)[4];
            Ra.sl[6]=691; /* line # 691 */
            ((V *)Rv12)[7]=((V *)Rv2)[8];
            P_val_new(((V *)Rv12)+7,NULL);
            ((V *)Rv12)[4]=NULL;
          }
        }
      }
      Ra.sl[6]=698; /* line # 698 */
      if (Rv1!=NULL) ((V *)Rv13)[0]=Rv11;
      else Rv1=Rv11;
      Rv13=Rv11;
      Rv2=((V *)Rv2)[3];
      Ra.sl[6]=703; /* line # 703 */
      if (V_sy_sym.ub[0]==18) P_insymbol();
    }
    if (V_sy_sym.ub[0]==15) P_insymbol();
    else P_src_error(Rd.s+196,23,3);
  }
  Ra.sl[6]=709; /* line # 709 */
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " call_formal_proc "  */
V PAS_COMILER_PRC_00000009(V F_ip, UB F_bfnc){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+200;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=725; /* line # 725 */
  Rv0=F_ip;
  switch (((UB *)Rv0)[56]) {
    case 7:Rv1=((V *)F_ip)[9];
    break;
    case 8:Ra.sl[6]=732; /* line # 732 */
    Rv1=((V *)((V *)Rv0)[10])[2];
    break;
    default:Rv1=NULL;
    break;
  }
  Ra.sl[6]=738; /* line # 738 */
  if (Rv1!=NULL) {
    Rv2=PAS_COMILER_PRC_00000008(Rv1);
    Rv2=P_lgt_new_call(((V *)Rv1)[11],Rv1, Rv2);
    Ra.sl[6]=743; /* line # 743 */
    P_call_setting(&Rv2);
  }
  else {
    P_src_error(Rd.s+220,998,3);
    Ra.sl[6]=748; /* line # 748 */
    Rv2=NULL;
  }
  if (Rv2==NULL) Rv2=P_lgt_new_idref(V_ide_udptr.v[5],NULL);
  else {
    Ra.sl[6]=754; /* line # 754 */
    if (((V *)Rv2)[3]==NULL&&F_bfnc) {
      P_src_error(Rd.s+220,73,3);
      ((V *)Rv2)[3]=V_typ_std.v[21];
    }
  }
  Ra.sl[6]=759; /* line # 759 */
  Ret=Rv2;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " call_indirect_proc "  */
V PAS_COMILER_PRC_00000010(V F_lge){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  V Rv3;
  register V Rv4;
  register V Rv5;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+224;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=773; /* line # 773 */
  Rv0=NULL;
  if (F_lge!=NULL) {
    Rv1=F_lge;
    Rv2=((V *)Rv1)[3];
    Rv3=((V *)Rv2)[13];
    Ra.sl[6]=778; /* line # 778 */
    if (Rv3!=NULL) {
      Rv4=Rv3;
      ((V *)F_lge)[0]=PAS_COMILER_PRC_00000008(Rv3);
      P_lgt_new(&Rv0,((V *)Rv4)[11],7, F_lge);
      Ra.sl[6]=783; /* line # 783 */
      Rv5=Rv0;
      if (((V *)Rv4)[11]!=NULL) {
        if (!((UB *)((V *)Rv4)[11])[91]) {
          Ra.sl[6]=788; /* line # 788 */
          ((UW *)Rv5)[10]=((UW *)Rv5)[10]|4;
        }
      }
      else((V *)Rv0)[3]=V_typ_std.v[28];
      ((V *)Rv5)[6]=Rv3;
    }
  }
  Ra.sl[6]=795; /* line # 795 */
  if (Rv0==NULL) Rv0=P_lgt_new_econst(V_typ_std.v[21],0);
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " call_generic "  */
V PAS_COMILER_PRC_00000011(V F_ip, UB F_bfnc){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  SL Rv1;
  V Rv2;
  V Rv3;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+244;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=813; /* line # 813 */
  Rv0=NULL;
  Rv1=0;
  Ra.sl[6]=818; /* line # 818 */
  if (V_sy_sym.ub[0]==14) {
    while (1){
      P_insymbol();
      Rv2=PAS_COMILER_PRC_00000000();
      Ra.sl[6]=824; /* line # 824 */
      if (Rv0==NULL) Rv0=Rv2;
      else((V *)Rv3)[0]=Rv2;
      Rv3=Rv2;
      Rv1=Rv1+1;
      if (V_sy_sym.ub[0]!=18&&V_sy_sym.ub[0]!=15) P_src_error(Rd.s+260,24,2);
      if (V_sy_sym.ub[0]!=18)  break;
    }
    Ra.sl[6]=830; /* line # 830 */
    P_insymbol();
  }
  Rv2=P_generate_call(F_ip, Rv0, Rv1,0);
  if (Rv2==NULL) {
    Ra.sl[6]=836; /* line # 836 */
    Rv2=P_lgt_new_idref(V_ide_udptr.v[5],NULL);
  }
  else {
    if (((V *)Rv2)[3]==NULL&&F_bfnc) {
      P_src_error(Rd.s+260,73,3);
      Ra.sl[6]=841; /* line # 841 */
      ((V *)Rv2)[3]=V_typ_std.v[21];
    }
  }
  Ret=Rv2;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " open_call "  */
V PAS_COMILER_PRC_00000012(SL F_ifnc){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  V Rv3;
  SL Rv4;
  V Rv5;
  SL Rv6;
  SL Rv7;
  V Rv8;
  V Rv9;
  register V Rv10;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+264;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=864; /* line # 864 */
  Rv0=NULL;
  Rv1=P_ide_search_from_nameid(V_iof_std_open);
  if (Rv1!=NULL) {
    Ra.sl[6]=869; /* line # 869 */
    if (V_sy_sym.ub[0]==14) P_insymbol();
    else P_src_error(Rd.s+277,22,2);
    Rv2=PAS_COMILER_PRC_00000005(V_typ_std.v[16],0,0,0);
    Ra.sl[6]=874; /* line # 874 */
    Rv3=((V *)((V *)Rv2)[3])[12];
    if (((V *)Rv2)[3]==V_typ_std.v[7]) Rv4=0;
    else {
      Ra.sl[6]=879; /* line # 879 */
      if (Rv3!=NULL) Rv4=abs(((SL *)Rv3)[11]);
      if (Rv4==0) Rv4=1;
    }
    Rv5=P_lgt_new_econst(V_typ_std.v[2],Rv4);
    ((V *)Rv2)[0]=Rv5;
    Ra.sl[6]=884; /* line # 884 */
    Rv6=2;
    switch (F_ifnc) {
      case 1:Rv7=1;
      break;
      case 2:Rv7=2;
      break;
      case 3:Ra.sl[6]=889; /* line # 889 */
      Rv7=6;
      break;
      default:Rv7=0;
      break;
    }
    if (Rv7!=0) {
      Ra.sl[6]=895; /* line # 895 */
      if (V_sy_sym.ub[0]==18) {
        P_insymbol();
        Rv8=PAS_COMILER_PRC_00000000();
        Ra.sl[6]=900; /* line # 900 */
        ((V *)Rv5)[0]=Rv8;
        Rv5=Rv8;
        Rv6=Rv6+1;
      }
      Rv8=P_lgt_new_econst(V_typ_std.v[2],Rv7);
      Ra.sl[6]=905; /* line # 905 */
      ((V *)Rv5)[0]=Rv8;
      Rv5=Rv8;
      Rv6=Rv6+1;
    }
    Ra.sl[6]=910; /* line # 910 */
    while (V_sy_sym.ub[0]==18){
      P_insymbol();
      Rv8=PAS_COMILER_PRC_00000000();
      ((V *)Rv5)[0]=Rv8;
      Ra.sl[6]=915; /* line # 915 */
      Rv5=Rv8;
      Rv6=Rv6+1;
    }
    Rv9=((V *)Rv1)[10];
    Ra.sl[6]=920; /* line # 920 */
    P_generic_search(((V *)Rv1)[0],Rv6, &Rv9, Rv2);
    if (Rv9!=NULL) {
      Rv10=Rv9;
      if (((V *)Rv10)[2]!=NULL) {
        Rv0=P_lgt_new_call(((V *)((V *)Rv10)[2])[11],((V *)Rv10)[2],Rv2);
        Ra.sl[6]=925; /* line # 925 */
        P_call_setting(&Rv0);
      }
    }
    if (V_sy_sym.ub[0]==15) P_insymbol();
    else P_src_error(Rd.s+277,23,2);
  }
  Ra.sl[6]=931; /* line # 931 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " readwrite_call "  */
V PAS_COMILER_PRC_00000013(V F_dfi, V F_psel, V F_pio1, V F_pio2, V F_peoln){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  UB Rv2;
  V Rv3;
  UB Rv4;
  UB Rv5;
  V Rv6;
  SL Rv7;
  V Rv8;
  V Rv9;
  V Rv10;
  V Rv11;
  V Rv12;
  register V Rv13;
  register V Rv14;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+281;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=949; /* line # 949 */
  Rv0=NULL;
  Rv1=NULL;
  Rv2=0;
  V_sy_label_flag=0;
  Ra.sl[6]=954; /* line # 954 */
  Rv3=F_pio1;
  if (V_sy_sym.ub[0]==14) {
    Ra.sl[6]=959; /* line # 959 */
    Rv4=0;
    Rv5=1;
    Rv2=1;
    P_insymbol();
    Rv6=PAS_COMILER_PRC_00000000();
    Ra.sl[6]=964; /* line # 964 */
    if (F_dfi==NULL) {
      Rv1=Rv6;
      Rv7=1;
      if (V_sy_sym.ub[0]==22) {
        Ra.sl[6]=970; /* line # 970 */
        Rv8=Rv1;
        while (V_sy_sym.ub[0]==22){
          P_insymbol();
          Rv9=PAS_COMILER_PRC_00000000();
          Ra.sl[6]=975; /* line # 975 */
          ((V *)Rv8)[0]=Rv9;
          Rv8=Rv9;
          Rv7=Rv7+1;
        }
      }
      Ra.sl[6]=980; /* line # 980 */
      if (V_sy_sym.ub[0]==15) {
        Rv2=0;
        P_insymbol();
      }
      else {
        if (V_sy_sym.ub[0]!=18) P_src_error(Rd.s+299,29,2);
      }
      Ra.sl[6]=985; /* line # 985 */
      Rv5=0;
    }
    else {
      if (P_comp_type(((V *)Rv6)[3],V_typ_std.v[16],0,0)) {
        Ra.sl[6]=991; /* line # 991 */
        Rv1=Rv6;
        if (((V *)Rv1)[3]!=V_typ_std.v[7]) Rv3=F_pio2;
        if (V_sy_sym.ub[0]==15) {
          Ra.sl[6]=996; /* line # 996 */
          Rv2=0;
          P_insymbol();
        }
        else {
          if (V_sy_sym.ub[0]!=18) P_src_error(Rd.s+299,29,2);
        }
        Rv5=0;
      }
    }
  }
  else {
    Ra.sl[6]=1005; /* line # 1005 */
    if (F_dfi==NULL) P_src_error(Rd.s+299,22,2);
  }
  if (F_psel!=NULL) F_psel=P_ide_search_from_nameid(F_psel);
  if (Rv3!=NULL) Rv3=P_ide_search_from_nameid(Rv3);
  if (F_peoln!=NULL) F_peoln=P_ide_search_from_nameid(F_peoln);
  Ra.sl[6]=1011; /* line # 1011 */
  if (Rv1==NULL) Rv1=P_lgt_new_idref(F_dfi,NULL);
  Rv0=P_exp_genoper(((V *)F_psel)[0],((V *)F_psel)[10],Rv1);
  Rv8=Rv0;
  Ra.sl[6]=1017; /* line # 1017 */
  if (Rv2) {
    while (Rv5||V_sy_sym.ub[0]==18){
      if (!Rv5) {
        Ra.sl[6]=1023; /* line # 1023 */
        P_insymbol();
        Rv6=PAS_COMILER_PRC_00000000();
      }
      else Rv5=0;
      Rv10=NULL;
      Ra.sl[6]=1028; /* line # 1028 */
      Rv7=1;
      while (V_sy_sym.ub[0]==22){
        P_insymbol();
        Rv9=PAS_COMILER_PRC_00000000();
        Ra.sl[6]=1033; /* line # 1033 */
        if (Rv10==NULL) Rv10=Rv9;
        else((V *)Rv11)[0]=Rv9;
        Rv11=Rv9;
        Rv7=Rv7+1;
      }
      Ra.sl[6]=1038; /* line # 1038 */
      ((V *)Rv6)[0]=Rv10;
      Rv12=((V *)Rv3)[10];
      P_generic_search(((V *)Rv3)[0],Rv7, &Rv12, Rv6);
      if (Rv12!=NULL) {
        Rv13=Rv12;
        Ra.sl[6]=1044; /* line # 1044 */
        if (((V *)Rv13)[2]!=NULL) {
          Rv10=P_lgt_new_call(((V *)((V *)Rv13)[2])[11],((V *)Rv13)[2],Rv6);
          P_call_setting(&Rv10);
        }
        Ra.sl[6]=1049; /* line # 1049 */
        ((V *)Rv8)[0]=Rv10;
        Rv8=Rv10;
      }
    }
    if (V_sy_sym.ub[0]==15) P_insymbol();
    else {
      Ra.sl[6]=1054; /* line # 1054 */
      P_src_error(Rd.s+299,23,2);
    }
  }
  if (F_peoln!=NULL) {
    Ra.sl[6]=1060; /* line # 1060 */
    Rv12=((V *)F_peoln)[10];
    P_generic_search(((V *)F_peoln)[0],0, &Rv12,NULL);
    if (Rv12!=NULL) {
      Rv14=Rv12;
      Ra.sl[6]=1065; /* line # 1065 */
      if (((V *)Rv14)[2]!=NULL) {
        Rv10=P_lgt_new_call(((V *)((V *)Rv14)[2])[11],((V *)Rv14)[2],NULL);
        P_call_setting(&Rv10);
      }
      Ra.sl[6]=1070; /* line # 1070 */
      ((V *)Rv8)[0]=Rv10;
      Rv8=Rv10;
    }
  }
  Ra.sl[6]=1075; /* line # 1075 */
  if (Rv8!=Rv0) {
    P_lgt_new(&Rv0,NULL,0, Rv0);
    ((UB *)Rv0)[41]=2;
  }
  Ra.sl[6]=1080; /* line # 1080 */
  V_sy_label_flag=1;
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " get_state_eff_list "  */
V PAS_COMILER_PRC_00000015(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+303;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=1105; /* line # 1105 */
  Rv0=NULL;
  Rv1=NULL;
  Lx[0].sl[0]=0;
  Ra.sl[6]=1110; /* line # 1110 */
  V_sy_sym.ub[0]=22;
  while (V_sy_sym.ub[0]==22){
    P_insymbol();
    Rv2=PAS_COMILER_PRC_00000000();
    Ra.sl[6]=1115; /* line # 1115 */
    if (Rv1==NULL) Rv0=Rv2;
    else((V *)Rv1)[0]=Rv2;
    Rv1=Rv2;
    Lx[0].sl[0]=Lx[0].sl[0]+1;
  }
  Ra.sl[6]=1121; /* line # 1121 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " user_state_call "  */
V PAS_COMILER_PRC_00000014(V F_ip){
  /* Define the automatic variable space. */
  Blk( Ra, 40 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  V Rv3;
  UB Rv4;
  UB Rv5;
  UB Rv6;
  V Rv7;
  register V Rv8;
  register V Rv9;
  V Rv10;
  V Rv11;
  V Rv12;
  V Rv13;
  register V Ret;
  register P Lx_Sv;
  Lx_Sv=Lx[0];
  Lx[0].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[1]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+8;
  Ra.v[2]=Rd.s+323;
  Ra.v[3]=Rd.s+17;
  Ra.sl[8]=1126; /* line # 1126 */
  Rv0=NULL;
  Rv1=NULL;
  Rv2=NULL;
  Rv3=NULL;
  Rv4=0;
  Ra.sl[8]=1131; /* line # 1131 */
  Rv5=0;
  Rv6=0;
  V_sy_label_flag=0;
  Rv7=((V *)F_ip)[8];
  Ra.sl[8]=1137; /* line # 1137 */
  if (V_sy_sym.ub[0]==14) {
    Rv4=1;
    Rv3=PAS_COMILER_PRC_00000015();
  }
  Ra.sl[8]=1143; /* line # 1143 */
  while (Rv7!=NULL){
    Rv8=Rv7;
    if (((V *)Rv8)[2]==NULL||Rv3==NULL)  break;
    Ra.sl[8]=1149; /* line # 1149 */
    Rv5=P_comp_type(((V *)Rv3)[3],((V *)Rv8)[2],0,0);
    if (Rv5)  break;
    if (((V *)Rv8)[3]!=NULL)  break;
    Rv7=((V *)Rv8)[0];
  }
  Ra.sl[8]=1156; /* line # 1156 */
  if (Rv7==NULL) {
    P_src_error_s(Rd.s+342,41,3,((V *)F_ip)[0],NULL);
    P_skip_symbol(15,0,0);
    Ret=NULL;
  }
  else {
    Ra.sl[8]=1163; /* line # 1163 */
    Rv9=Rv7;
    if (((V *)Rv9)[4]!=NULL) Rv10=P_ide_search_from_nameid(((V *)Rv9)[4]);
    else Rv10=NULL;
    Ra.sl[8]=1168; /* line # 1168 */
    if (((V *)Rv9)[5]!=NULL) Rv11=P_ide_search_from_nameid(((V *)Rv9)[5]);
    else Rv11=NULL;
    if (((V *)Rv9)[6]!=NULL) Rv12=P_ide_search_from_nameid(((V *)Rv9)[6]);
    else Rv12=NULL;
    Ra.sl[8]=1174; /* line # 1174 */
    if (Rv4&&V_sy_sym.ub[0]==15) {
      P_insymbol();
      Rv4=0;
    }
    if (Rv5) {
      Ra.sl[8]=1179; /* line # 1179 */
      Rv2=Rv3;
      Rv13=Rv2;
      Rv3=NULL;
      if (V_sy_sym.ub[0]!=18) P_src_error(Rd.s+342,29,2);
    }
    else {
      Ra.sl[8]=1185; /* line # 1185 */
      if (((V *)Rv9)[3]!=NULL) {
        Ra.sl[0]=1;
        if (((UB *)Rv9)[8]) {
          ((UB *)Rv9)[8]=0;
          Rv13=((V *)Rv9)[3];
        }
        else Rv13=P_lgt_link(((V *)Rv9)[3]);
      }
      else {
        Ra.sl[8]=1192; /* line # 1192 */
        Ra.sl[0]=0;
        Rv13=NULL;
      }
    }
    if (Rv10!=NULL) {
      Rv0=P_generate_call(Rv10, Rv13, Ra.sl[0],0);
      Ra.sl[8]=1197; /* line # 1197 */
      Rv1=Rv0;
      if (Rv5) Rv6=1;
    }
    Ra.sl[8]=1202; /* line # 1202 */
    if (Rv4) {
      while (1){
        if (Rv3==NULL) Rv3=PAS_COMILER_PRC_00000015();
        Ra.sl[8]=1207; /* line # 1207 */
        if (((UB *)Rv9)[9]) {
          if (Rv5) {
            if (Rv6) Rv13=P_lgt_link(Rv2);
            else {
              Rv6=1;
              Rv13=Rv2;
            }
          }
          else {
            Ra.sl[8]=1213; /* line # 1213 */
            if (((UB *)Rv9)[8]) {
              ((UB *)Rv9)[8]=0;
              Rv13=((V *)Rv9)[3];
            }
            else Rv13=P_lgt_link(((V *)Rv9)[3]);
          }
          ((V *)Rv13)[0]=Rv3;
          Rv3=Rv13;
        }
        Ra.sl[8]=1219; /* line # 1219 */
        Rv13=P_generate_call(Rv11, Rv3, Ra.sl[0],0);
        if (Rv13!=NULL) {
          if (Rv1==NULL) Rv0=Rv13;
          else {
            Ra.sl[8]=1224; /* line # 1224 */
            ((V *)Rv1)[0]=Rv13;
          }
          Rv1=Rv13;
        }
        Rv3=NULL;
        if (V_sy_sym.ub[0]!=18)  break;
      }
      Ra.sl[8]=1230; /* line # 1230 */
      if (V_sy_sym.ub[0]!=15) {
        P_src_error(Rd.s+342,34,3);
        P_skip_symbol(19,0,0);
      }
      else P_insymbol();
    }
    Ra.sl[8]=1237; /* line # 1237 */
    if (Rv12!=NULL) {
      if (((UB *)Rv9)[9]) {
        Ra.sl[0]=1;
        Ra.sl[8]=1242; /* line # 1242 */
        if (Rv5) {
          if (Rv6) Rv3=P_lgt_link(Rv2);
          else {
            Rv6=1;
            Rv3=Rv2;
          }
        }
        else {
          if (((UB *)Rv9)[8]) {
            ((UB *)Rv9)[8]=0;
            Rv3=((V *)Rv9)[3];
          }
          else {
            Ra.sl[8]=1247; /* line # 1247 */
            Rv3=P_lgt_link(((V *)Rv9)[3]);
          }
        }
      }
      else {
        Ra.sl[0]=0;
        Rv3=NULL;
      }
      Rv13=P_generate_call(Rv12, Rv3, Ra.sl[0],0);
      Ra.sl[8]=1252; /* line # 1252 */
      if (Rv1==NULL) Rv0=Rv13;
      else((V *)Rv1)[0]=Rv13;
      Rv1=Rv13;
    }
  }
  Ra.sl[8]=1258; /* line # 1258 */
  if (Rv1!=Rv0) {
    P_lgt_new(&Rv0,NULL,0, Rv0);
    ((UB *)Rv0)[41]=2;
  }
  Ra.sl[8]=1264; /* line # 1264 */
  V_sy_label_flag=1;
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[1];
  Lx[0]=Lx_Sv;
  return(Ret);
}


/* Procedure/Function : " new_call "  */
V PAS_COMILER_PRC_00000016(V F_new_fnc){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  V Rv3;
  V Rv4;
  register V Rv5;
  V Rv6;
  register V Rv7;
  register V Rv8;
  SL Rv9;
  V Rv10;
  V Rv11;
  register V Rv12;
  V Rv13;
  V Rv14;
  register V Rv15;
  V Rv16;
  V Rv17;
  SL Rv18;
  register V Rv19;
  register V Rv20;
  register V Rv21;
  register V Rv22;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+346;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=1284; /* line # 1284 */
  Rv0=NULL;
  Rv1=NULL;
  Rv2=NULL;
  Rv3=NULL;
  Ra.sl[6]=1290; /* line # 1290 */
  if (V_sy_sym.ub[0]==14) P_insymbol();
  else P_src_error(Rd.s+358,22,2);
  Rv4=PAS_COMILER_PRC_00000005(V_typ_std.v[5],0,0,0);
  if (Rv4!=NULL) {
    Ra.sl[6]=1295; /* line # 1295 */
    Rv5=Rv4;
    if (2&((UW *)Rv5)[10]) Rv6=((V *)Rv5)[3];
  }
  if (Rv6!=NULL) {
    Rv7=Rv6;
    Ra.sl[6]=1300; /* line # 1300 */
    if (((UB *)Rv7)[92]==5) Rv3=((V *)Rv7)[12];
    else Rv3=NULL;
  }
  if (Rv3!=NULL) {
    Rv8=Rv3;
    Ra.sl[6]=1306; /* line # 1306 */
    Rv9=((SL *)Rv8)[11];
    if (((V *)Rv8)[4]!=NULL||((UB *)Rv8)[90]) {
      Ra.sl[6]=1313; /* line # 1313 */
      if (((V *)Rv8)[4]!=NULL) {
        Rv10=((V *)Rv8)[4];
        while (Rv10!=NULL){
          Ra.sl[6]=1318; /* line # 1318 */
          if (V_sy_sym.ub[0]==18) P_insymbol();
          Rv11=PAS_COMILER_PRC_00000005(((V *)Rv10)[4],0,0,0);
          if (((UB *)Rv11)[40]==17) {
            Rv12=Rv11;
            Ra.sl[6]=1323; /* line # 1323 */
            ((UB *)Rv12)[40]=14;
            ((V *)Rv12)[7]=((V *)Rv10)[11];
            if (((V *)Rv12)[7]==NULL) P_src_error(Rd.s+358,126,3);
            Ra.sl[6]=1328; /* line # 1328 */
            P_val_new(((V *)Rv12)+7,NULL);
            ((V *)Rv12)[4]=NULL;
            ((V *)Rv12)[3]=((V *)Rv10)[4];
          }
          Ra.sl[6]=1333; /* line # 1333 */
          if (((UB *)Rv11)[40]!=14) {
            P_lgt_new(&Rv13,((V *)Rv10)[4],13,NULL);
            ((V *)Rv13)[0]=Rv11;
            P_all_new(((V *)Rv13)+7,((V *)Rv10)[4],NULL,0);
            Ra.sl[6]=1338; /* line # 1338 */
            P_lgt_new(&Rv11,((V *)Rv10)[4],6, Rv13);
            ((UB *)Rv11)[41]=3;
            if (Rv0==NULL) Rv0=Rv11;
            else((V *)Rv14)[0]=Rv11;
            Ra.sl[6]=1343; /* line # 1343 */
            Rv14=Rv11;
          }
          else Rv13=Rv11;
          Rv15=Rv10;
          Ra.sl[6]=1350; /* line # 1350 */
          ((V *)Rv15)[10]=Rv13;
          ((UB *)Rv15)[64]=2;
          P_lgt_new(&Rv16,((V *)Rv15)[4],2, P_lgt_link(Rv4));
          ((SL *)Rv16)[4]=((SL *)Rv15)[15];
          Ra.sl[6]=1355; /* line # 1355 */
          if (((UB *)Rv13)[40]==14) ((V *)Rv16)[0]=Rv13;
          else((V *)Rv16)[0]=P_lgt_link(Rv13);
          P_lgt_new(&Rv13,((V *)Rv15)[4],6, Rv16);
          ((UB *)Rv13)[41]=3;
          if (Rv1==NULL) Rv1=Rv13;
          else {
            Ra.sl[6]=1360; /* line # 1360 */
            ((V *)Rv17)[0]=Rv13;
          }
          Rv17=Rv13;
          Ra.sl[6]=1365; /* line # 1365 */
          if (V_sy_sym.ub[0]!=18&&V_sy_sym.ub[0]!=15) P_src_error(Rd.s+358,34,2);
          Rv10=((V *)Rv10)[3];
        }
      }
      Ra.sl[6]=1370; /* line # 1370 */
      if (V_sy_sym.ub[0]==15) P_insymbol();
      else P_src_error(Rd.s+358,24,2);
      Ra.sl[6]=1378; /* line # 1378 */
      Rv11=P_lgt_type_compute(((V *)Rv8)[8],((V *)Rv8)[9],((SL *)Rv8)[11],NULL);
      Ra.sl[6]=1391; /* line # 1391 */
      if (((UB *)Rv8)[90]) P_init_d_dyn(Rv3, Rv4, &Rv1, &Rv17,1,NULL);
      Rv10=((V *)Rv8)[4];
      while (Rv10!=NULL){
        Ra.sl[6]=1397; /* line # 1397 */
        ((UB *)Rv10)[64]=0;
        ((V *)Rv10)[10]=NULL;
        Rv10=((V *)Rv10)[3];
      }
      Ra.sl[6]=1403; /* line # 1403 */
      Rv2=P_lgt_new_call(Rv6, F_new_fnc, Rv11);
      ((V *)Rv4)[0]=Rv2;
      Ra.sl[6]=1408; /* line # 1408 */
      P_lgt_new(&Rv2, Rv6,6, Rv4);
      ((UB *)Rv2)[41]=3;
      if (Rv0==NULL) Rv0=Rv2;
      else {
        Ra.sl[6]=1413; /* line # 1413 */
        ((V *)Rv14)[0]=Rv2;
      }
      ((V *)Rv2)[0]=Rv1;
      P_lgt_new(&Rv1,NULL,0, Rv0);
      ((UB *)Rv1)[41]=2;
    }
    else {
      Ra.sl[6]=1420; /* line # 1420 */
      Rv9=((SL *)Rv8)[11];
      if (Rv9<=0) P_src_error(Rd.s+358,130,3);
      if (((UB *)Rv8)[92]==10) {
        Rv11=((V *)Rv8)[14];
        Ra.sl[6]=1425; /* line # 1425 */
        if (Rv11!=NULL) {
          if (((UB *)Rv11)[40]==16) Rv11=((V *)Rv11)[1];
        }
        while (V_sy_sym.ub[0]==18&&Rv11!=NULL){
          Rv2=((V *)Rv11)[1];
          Ra.sl[6]=1430; /* line # 1430 */
          Rv16=((V *)Rv2)[0];
          P_insymbol();
          Rv13=PAS_COMILER_PRC_00000005(((V *)((V *)Rv16)[0])[3],0,0,0);
          Rv18=-1;
          Ra.sl[6]=1435; /* line # 1435 */
          Rv19=Rv13;
          if (((UB *)Rv19)[40]==14) Rv18=((SL *)((V *)Rv19)[7])[13];
          else {
            Ra.sl[6]=1440; /* line # 1440 */
            P_src_error(Rd.s+358,181,2);
          }
          P_lgt_free_tree(&Rv13);
          Rv20=Rv2;
          Rv21=((V *)Rv20)[7];
          Ra.sl[6]=1445; /* line # 1445 */
          Rv18=Rv18-((SL *)Rv20)[4];
          if (Rv18>=0&&Rv18<((SL *)Rv21)[6]) {
            Rv18=((SL *)((V *)((V *)Rv2)[7])[7])[Rv18];
            if (Rv18>=0) {
              Ra.sl[6]=1450; /* line # 1450 */
              Rv16=((V *)((V *)Rv16)[0])[0];
            }
            while (Rv18>0&&Rv16!=NULL){
              Rv18=Rv18-1;
              Rv16=((V *)Rv16)[0];
            }
            Ra.sl[6]=1456; /* line # 1456 */
            if (Rv16==NULL) Rv16=((V *)Rv2)[0];
          }
          Rv22=((V *)Rv16)[3];
          Ra.sl[6]=1461; /* line # 1461 */
          Rv11=((V *)Rv22)[14];
          Rv9=((SL *)Rv22)[11];
        }
      }
      Ra.sl[6]=1466; /* line # 1466 */
      if (V_sy_sym.ub[0]==15) P_insymbol();
      else {
        P_src_error(Rd.s+358,23,2);
        P_skip_symbol(15,0,0);
      }
      Ra.sl[6]=1471; /* line # 1471 */
      P_lgt_new(&Rv1, Rv6,6, Rv4);
      ((UB *)Rv1)[41]=3;
      Rv11=P_lgt_new_econst(V_typ_std.v[2],Rv9);
      Rv2=P_lgt_new_call(Rv6, F_new_fnc, Rv11);
      Ra.sl[6]=1476; /* line # 1476 */
      ((V *)Rv4)[0]=Rv2;
    }
  }
  else {
    Ra.sl[6]=1481; /* line # 1481 */
    P_lgt_free_tree(&Rv4);
    P_src_error(Rd.s+358,180,3);
  }
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " dispose_call "  */
V PAS_COMILER_PRC_00000017(V F_free_fnc){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+362;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=1498; /* line # 1498 */
  if (V_sy_sym.ub[0]==14) P_insymbol();
  else P_src_error(Rd.s+378,22,2);
  Ra.sl[6]=1503; /* line # 1503 */
  Rv0=PAS_COMILER_PRC_00000005(V_typ_std.v[5],0,0,0);
  Rv1=P_lgt_new_call(NULL,F_free_fnc, Rv0);
  if (V_sy_sym.ub[0]==18) P_skip_symbol(15,0,0);
  if (V_sy_sym.ub[0]==15) P_insymbol();
  else {
    P_src_error(Rd.s+378,23,2);
    Ra.sl[6]=1508; /* line # 1508 */
    P_skip_symbol(15,0,0);
  }
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " gen_list_agregat_set "  */
V PAS_COMILER_PRC_00000018(V F_ty, UB F_bcte){
  /* Define the automatic variable space. */
  Blk( Ra, 64 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  register V Rv2;
  V Rv3;
  V Rv4;
  UB Rv5;
  SL Rv6;
  SL Rv7;
  V Rv8;
  V Rv9;
  register V Rv10;
  SL Rv11;
  V Rv12;
  register V Rv13;
  SL Rv14;
  SL Rv15;
  SL Rv16;
  SL Rv17;
  UL Rv18;
  register V Rv19;
  register V Rv20;
  SL Rv21;
  register int Rf0;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+382;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=1531; /* line # 1531 */
  Rv0=1;
  P_insymbol();
  if (V_sy_sym.ub[0]==17) {
    Ra.sl[6]=1536; /* line # 1536 */
    P_lgt_new(&Rv1, V_typ_std.v[19],14,NULL);
    if (F_ty!=NULL) ((V *)Rv1)[3]=F_ty;
    P_val_new(((V *)Rv1)+7,((V *)Rv1)[3]);
    Rv2=((V *)Rv1)[7];
    Ra.sl[6]=1541; /* line # 1541 */
    ((SL *)Rv2)[6]=0;
    ((UL *)Rv2)[13]=0;
  }
  else {
    Ra.sl[6]=1547; /* line # 1547 */
    Rv1=NULL;
    Rv3=NULL;
    Rv4=NULL;
    Rv5=0;
    Rv6=-1;
    Ra.sl[6]=1552; /* line # 1552 */
    Rv7=0;
    for( Rf0=(V_dst_seti-1)+1;Rf0>0;Rf0-- ) {
      Ra.ul[Rv7+7]=0;
      Rv7++;
    }
    Rv8=F_ty;
    Rv9=NULL;
    if (F_ty!=NULL) {
      Rv10=F_ty;
      Ra.sl[6]=1558; /* line # 1558 */
      Rv9=((V *)Rv10)[13];
      Rv11=((SL *)Rv10)[24];
    }
    while (1){
      Ra.sl[6]=1564; /* line # 1564 */
      if (Rv0) Rv0=0;
      else P_insymbol();
      if (Rv9==NULL) {
        Ra.sl[6]=1570; /* line # 1570 */
        Rv12=PAS_COMILER_PRC_00000005(V_typ_std.v[15],0,0,0);
        if (((UB *)Rv12)[40]==17) {
          P_src_error(Rd.s+406,137,2);
          P_lgt_free(&Rv12);
        }
        else {
          Ra.sl[6]=1578; /* line # 1578 */
          Rv9=((V *)Rv12)[3];
          if (Rv9!=NULL) {
            Rv11=-1;
            while (Rv9!=NULL&&Rv11<0){
              Ra.sl[6]=1583; /* line # 1583 */
              switch (((UB *)Rv9)[92]) {
                case 0:
                case 1:
                case 2:Rv11=((SL *)Rv9)[30];
                break;
                case 22:Rv9=((V *)Rv9)[0];
                break;
                default:P_src_error(Rd.s+406,110,2);
                Ra.sl[6]=1588; /* line # 1588 */
                Rv9=V_typ_std.v[2];
                Rv11=0;
                break;
              }
            }
            if (Rv11<0) P_src_error(Rd.s+406,110,2);
            else {
              Ra.sl[6]=1594; /* line # 1594 */
              if (Rv11>=V_dst_seta) Rv11=V_dst_seta-1;
            }
          }
          if (Rv11<0) Rv9=NULL;
          Ra.sl[6]=1599; /* line # 1599 */
          if (F_ty==NULL&&Rv9!=NULL) {
            if (Rv11<V_dst_setw) P_ide_new_typ(11, &Rv8);
            else P_ide_new_typ(12, &Rv8);
            Rv13=Rv8;
            Ra.sl[6]=1605; /* line # 1605 */
            ((V *)Rv13)[13]=Rv9;
            ((SL *)Rv13)[24]=Rv11+1;
            if (Rv11<V_dst_setw) memcpy(Rv13+48,V_typ_std.v[17]+48,1);
            else {
              Ra.sl[6]=1610; /* line # 1610 */
              memcpy(Rv13+48,V_typ_std.v[18]+48,1);
            }
            Rv14=((((SL *)Rv13)[24]+V_dst_setw)-1)/V_dst_setw;
            ((SL *)Rv13)[11]=(Rv14*V_dst_setw+7)/8;
          }
        }
      }
      else {
        Ra.sl[6]=1620; /* line # 1620 */
        Rv12=PAS_COMILER_PRC_00000005(Rv9,0,0,0);
      }
      if (((UB *)Rv12)[40]==14) {
        Rv5=1;
        Ra.sl[6]=1625; /* line # 1625 */
        Rv14=P_lgt_get_econst(Rv12,-1);
        P_lgt_free(&Rv12);
        if (V_sy_sym.ub[0]==21) {
          P_insymbol();
          Ra.sl[6]=1630; /* line # 1630 */
          Rv12=PAS_COMILER_PRC_00000005(Rv9,0,0,0);
          if (((UB *)Rv12)[40]!=14) {
            P_src_error(Rd.s+406,53,2);
            Rv15=Rv14;
          }
          else {
            Ra.sl[6]=1636; /* line # 1636 */
            Rv15=P_lgt_get_econst(Rv12, Rv14);
          }
          P_lgt_free(&Rv12);
        }
        else Rv15=Rv14;
        if (((Rv14<0||Rv14>Rv11)||Rv15<Rv14)||Rv15>Rv11) {
          Ra.sl[6]=1641; /* line # 1641 */
          P_src_error(Rd.s+406,138,2);
          Rv15=Rv14-1;
        }
        Rv16=Rv14;
        for( Rf0=(Rv15+1)-Rv14;Rf0>0;Rf0-- ) {
          Ra.sl[6]=1646; /* line # 1646 */
          if (Rv16>Rv6) Rv6=Rv16;
          Rv17=Rv16/V_dst_setw;
          Rv18=Rv16%V_dst_setw;
          if (1<<Rv18&Ra.ul[Rv17+7]) P_src_error(Rd.s+406,139,2);
          else Ra.ul[Rv17+7]=Ra.ul[Rv17+7]|1<<Rv18;
          Rv16++;
        }
      }
      else {
        Ra.sl[6]=1653; /* line # 1653 */
        if (((UB *)Rv12)[40]!=17) {
          if (F_bcte) P_src_error(Rd.s+406,140,3);
          if (((UB *)Rv8)[91]) {
            Ra.sl[6]=1658; /* line # 1658 */
            Rv12=P_lgt_new_code(16, Rv12);
            ((V *)Rv12)[3]=Rv8;
            if (Rv1!=NULL) {
              ((V *)Rv1)[0]=Rv12;
              Ra.sl[6]=1663; /* line # 1663 */
              Rv1=P_lgt_new_code(14, Rv1);
              ((V *)Rv1)[3]=Rv8;
            }
            else Rv1=Rv12;
          }
          else {
            Ra.sl[6]=1670; /* line # 1670 */
            Rv12=P_lgt_new_call(Rv8, V_set_entry_proc, Rv12);
            P_call_setting(&Rv12);
            if (Rv1!=NULL) {
              ((V *)Rv1)[0]=Rv12;
              Ra.sl[6]=1675; /* line # 1675 */
              Rv1=P_exp_genop(11, Rv1);
              ((V *)Rv1)[3]=Rv8;
            }
            else Rv1=Rv12;
          }
        }
        else {
          Ra.sl[6]=1683; /* line # 1683 */
          P_src_error(Rd.s+406,141,2);
          P_lgt_free(&Rv12);
        }
      }
      if (V_sy_sym.ub[0]!=18)  break;
    }
    Ra.sl[6]=1688; /* line # 1688 */
    if (Rv5) {
      if ((Rv1==NULL&&Rv8!=NULL)&&F_ty==NULL) {
        Rv19=Rv8;
        Ra.sl[6]=1693; /* line # 1693 */
        ((SL *)Rv19)[24]=Rv6+1;
        Rv11=Rv6;
        if (Rv6>=V_dst_setw) {
          ((UB *)Rv19)[91]=0;
          Ra.sl[6]=1698; /* line # 1698 */
          ((UB *)Rv19)[92]=12;
          ((SL *)Rv19)[11]=(((((SL *)Rv19)[24]+V_dst_setw)-1)/V_dst_setw)*((SL *)
          V_typ_std.v[17])[11];
          ((UB *)Rv19)[48]=((UB *)V_typ_std.v[18])[48];
        }
        else {
          Ra.sl[6]=1705; /* line # 1705 */
          ((UB *)Rv19)[91]=1;
          ((UB *)Rv19)[92]=11;
          ((SL *)Rv19)[11]=(((SL *)Rv19)[24]+7)/8;
          switch (((SL *)Rv19)[11]) {
            case 1:((UB *)Rv19)[48]=0;
            break;
            case 2:Ra.sl[6]=1710; /* line # 1710 */
            ((UB *)Rv19)[48]=1;
            break;
            default:((SL *)Rv19)[11]=4;
            ((UB *)Rv19)[48]=((UB *)V_typ_std.v[17])[48];
            break;
          }
        }
      }
      Ra.sl[6]=1718; /* line # 1718 */
      if (Rv11<V_dst_setw) Rv12=P_lgt_new_econst(Rv8, Ra.sl[7]);
      else {
        Ra.sl[6]=1724; /* line # 1724 */
        P_lgt_new(&Rv12, Rv8,14,NULL);
        P_val_new(((V *)Rv12)+7,Rv8);
        Rv20=((V *)Rv12)[7];
        ((V *)Rv20)[7]=PAS__NEW(32);
        Ra.sl[6]=1729; /* line # 1729 */
        ((SL *)Rv20)[6]=(Rv6+V_dst_setw)/V_dst_setw;
        Rv21=0;
        for( Rf0=(((SL *)Rv20)[6]-1)+1;Rf0>0;Rf0-- ) {
          ((SL *)((V *)Rv20)[7])[Rv21]=Ra.sl[Rv21+7];
          Rv21++;
        }
      }
    }
    Ra.sl[6]=1736; /* line # 1736 */
    if (Rv6>=0) {
      if (Rv1==NULL) Rv1=Rv12;
      else {
        Ra.sl[6]=1741; /* line # 1741 */
        ((V *)Rv12)[0]=Rv1;
        Rv1=P_exp_genop(11, Rv12);
        ((V *)Rv1)[3]=Rv8;
      }
    }
  }
  Ra.sl[6]=1746; /* line # 1746 */
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " gen_list_agregat_tab "  */
void PAS_COMILER_PRC_00000020(V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  register V Rv3;
  V Rv4;
  register V Rv5;
  SL Rv6;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+410;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=1778; /* line # 1778 */
  Rv0=F_ty;
  Rv1=((V *)Rv0)[15];
  Ra.sl[6]=1783; /* line # 1783 */
  Rv2=((V *)Rv0)[14];
  if (Rv1!=NULL) {
    Rv3=Rv1;
    Ra.sl[6]=1788; /* line # 1788 */
    if (((UB *)Rv3)[92]!=22) {
      if (((UB *)Rv3)[112]) Lx[1].sl[0]=(((UL *)Rv3)[30]+1)-((UL *)Rv3)[29];
      else Lx[1].sl[0]=(((SL *)Rv3)[30]-((SL *)Rv3)[29])+1;
    }
    else {
      Ra.sl[6]=1795; /* line # 1795 */
      Rv4=P_lgt_type_eval(((V *)Rv3)[12],NULL,NULL,0);
      if (((UB *)Rv4)[40]==14) {
        Lx[1].sl[0]=((SL *)((V *)Rv4)[7])[13];
        P_lgt_free(&Rv4);
      }
      else {
        Ra.sl[6]=1801; /* line # 1801 */
        P_src_error(Rd.s+434,142,4);
      }
    }
  }
  else Lx[1].sl[0]=0;
  Rv5=F_ty;
  if (((V *)Rv5)[13]!=NULL) {
    Ra.sl[6]=1807; /* line # 1807 */
    Rv4=P_lgt_type_eval(((V *)Rv5)[13],NULL,NULL,0);
    if (((UB *)Rv4)[40]==14) {
      Lx[1].sl[1]=((SL *)((V *)Rv4)[7])[13];
      P_lgt_free(&Rv4);
    }
    else {
      Ra.sl[6]=1813; /* line # 1813 */
      P_src_error(Rd.s+434,142,4);
    }
  }
  else Lx[1].sl[1]=((SL *)Rv5)[25];
  if (Rv2==NULL) Lx[1].sl[0]=0;
  Ra.sl[6]=1819; /* line # 1819 */
  Rv6=0;
  V_sy_sym.ub[0]=18;
  while (Rv6<Lx[1].sl[0]&&V_sy_sym.ub[0]==18){
    P_insymbol();
    Ra.sl[6]=1824; /* line # 1824 */
    Rv6=Rv6+1;
    if (V_sy_sym.ub[0]==16||V_sy_sym.ub[0]==14) Rv4=PAS_COMILER_PRC_00000019(((V
     *)F_ty)[14]);
    else {
      Ra.sl[6]=1829; /* line # 1829 */
      Rv4=PAS_COMILER_PRC_00000005(((V *)F_ty)[14],0,0,0);
    }
    if (((UB *)Rv4)[40]!=14) Lx[1].ub[8]=0;
    if (Lx[1].v[2]==NULL) Lx[1].v[2]=Rv4;
    else((V *)Lx[1].v[3])[0]=Rv4;
    Ra.sl[6]=1834; /* line # 1834 */
    Lx[1].v[3]=Rv4;
  }
  if (Rv6<Lx[1].sl[0]) P_src_error(Rd.s+434,144,3);
  else {
    Ra.sl[6]=1839; /* line # 1839 */
    if (V_sy_sym.ub[0]!=Lx[1].ub[32]) {
      P_src_error(Rd.s+434,146,2);
      P_skip_symbol(Lx[1].ub[32],0,0);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " gen_list_agregat_rec "  */
void PAS_COMILER_PRC_00000021(V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  V Rv3;
  register V Rv4;
  V Rv5;
  V Rv6;
  V Rv7;
  register V Rv8;
  SL Rv9;
  register V Rv10;
  SL Rv11;
  V Rv12;
  register V Rv13;
  SL Rv14;
  SL Rv15;
  V Rv16;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+438;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=1861; /* line # 1861 */
  Rv0=F_ty;
  V_sy_sym.ub[0]=18;
  Rv1=((V *)Rv0)[12];
  Ra.sl[6]=1866; /* line # 1866 */
  while (V_sy_sym.ub[0]==18&&Rv1!=NULL){
    P_insymbol();
    if (V_sy_sym.ub[0]==16||V_sy_sym.ub[0]==14) {
      Ra.sl[6]=1871; /* line # 1871 */
      Rv2=PAS_COMILER_PRC_00000019(((V *)Rv1)[4]);
    }
    else Rv2=PAS_COMILER_PRC_00000005(((V *)Rv1)[4],0,0,0);
    Ra.sl[6]=1876; /* line # 1876 */
    if (((UB *)Rv2)[40]!=14) Lx[1].ub[8]=0;
    if (Lx[1].v[2]==NULL) Lx[1].v[2]=Rv2;
    else((V *)Lx[1].v[3])[0]=Rv2;
    Lx[1].v[3]=Rv2;
    Ra.sl[6]=1881; /* line # 1881 */
    if (Rv1==((V *)Rv0)[13]) Rv1=NULL;
    else Rv1=((V *)Rv1)[3];
  }
  Ra.sl[6]=1886; /* line # 1886 */
  Rv3=((V *)Rv0)[14];
  if (Rv3!=NULL) {
    if (((UB *)Rv3)[40]==16) Rv3=((V *)Rv3)[1];
  }
  if (Rv3==NULL) {
    Ra.sl[6]=1892; /* line # 1892 */
    if (Rv1!=NULL) P_src_error(Rd.s+462,144,3);
    else {
      if (V_sy_sym.ub[0]!=Lx[1].ub[32]) {
        Ra.sl[6]=1897; /* line # 1897 */
        P_src_error(Rd.s+462,146,2);
        P_skip_symbol(Lx[1].ub[32],0,0);
      }
    }
    goto Ret_Label;
  }
  Ra.sl[6]=1903; /* line # 1903 */
  Rv4=Rv3;
  Rv5=((V *)Rv4)[1];
  Rv6=((V *)Rv5)[0];
  Rv7=((V *)Rv6)[0];
  Ra.sl[6]=1908; /* line # 1908 */
  Rv8=Rv5;
  Rv9=((SL *)Rv8)[4];
  if (((V *)Rv8)[7]!=NULL) {
    Rv10=((V *)Rv8)[7];
    Ra.sl[6]=1914; /* line # 1914 */
    Rv11=(((SL *)Rv10)[6]+Rv9)-1;
    Rv12=((V *)Rv10)[7];
  }
  else Rv12=NULL;
  Ra.sl[6]=1919; /* line # 1919 */
  if (((V *)Rv0)[4]!=NULL) {
    Rv2=P_lgt_type_eval(Rv7,NULL,NULL,0);
    Rv13=Rv2;
    if (((UB *)Rv13)[40]!=14) P_src_error(Rd.s+462,142,3);
    else {
      Ra.sl[6]=1925; /* line # 1925 */
      if (((V *)Rv13)[7]!=NULL) Rv14=((SL *)((V *)Rv13)[7])[13];
      else Rv14=Rv9-1;
    }
    P_lgt_free(&Rv2);
  }
  else {
    Ra.sl[6]=1931; /* line # 1931 */
    if (V_sy_sym.ub[0]==18) P_insymbol();
    else P_src_error(Rd.s+462,29,3);
    Rv14=PAS_COMILER_PRC_00000006(((V *)Rv7)+3);
    if (((V *)Rv7)[4]!=NULL) {
      Ra.sl[6]=1937; /* line # 1937 */
      Rv15=((SL *)((V *)Rv7)[4])[15];
      Rv2=P_lgt_new_econst(((V *)Rv7)[3],Rv14);
      ((SL *)Rv2)[4]=Rv15;
      Ra.sl[6]=1942; /* line # 1942 */
      if (Lx[1].v[2]==NULL) Lx[1].v[2]=Rv2;
      else((V *)Lx[1].v[3])[0]=Rv2;
      Lx[1].v[3]=Rv2;
    }
  }
  Ra.sl[6]=1948; /* line # 1948 */
  Rv16=((V *)Rv7)[0];
  if (Rv14<Rv9||Rv14>Rv11) Rv16=Rv6;
  else {
    Ra.sl[6]=1953; /* line # 1953 */
    Rv14=((SL *)Rv12)[(Rv14-Rv9)];
    if (Rv14<0) Rv16=Rv6;
    else {
      while (Rv14>0&&Rv16!=NULL){
        Ra.sl[6]=1959; /* line # 1959 */
        Rv16=((V *)Rv16)[0];
        Rv14=Rv14-1;
      }
      if (Rv16==NULL) Rv16=Rv6;
    }
  }
  Ra.sl[6]=1964; /* line # 1964 */
  if (Rv16!=NULL) {
    if (((V *)Rv16)[3]!=NULL) PAS_COMILER_PRC_00000021(((V *)Rv16)[3]);
  }
  Ret_Label: ;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " get_agregate "  */
V PAS_COMILER_PRC_00000019(V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 72 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  SL Rv2;
  SL Rv3;
  V Rv4;
  register V Rv5;
  V Rv6;
  V Rv7;
  register V Rv8;
  V Rv9;
  V Rv10;
  register V Rv11;
  register V Rv12;
  V Rv13;
  register V Ret;
  register P Lx_Sv;
  Lx_Sv=Lx[1];
  Lx[1].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[5]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+40;
  Ra.v[6]=Rd.s+466;
  Ra.v[7]=Rd.s+17;
  Ra.sl[16]=1973; /* line # 1973 */
  Rv0=F_ty;
  if (((UB *)Rv0)[92]==11||((UB *)Rv0)[92]==12) {
    if (V_sy_sym.ub[0]!=16) P_src_error(Rd.s+482,25,2);
    Rv1=PAS_COMILER_PRC_00000018(F_ty,0);
    Ra.sl[16]=1978; /* line # 1978 */
    if (V_sy_sym.ub[0]==17) P_insymbol();
    else P_src_error(Rd.s+482,26,2);
  }
  else {
    if (((UB *)Rv0)[91]) {
      Ra.sl[16]=1983; /* line # 1983 */
      P_src_error(Rd.s+482,131,3);
    }
    else {
      Ra.ub[8]=1;
      Rv1=NULL;
      Ra.sl[16]=1988; /* line # 1988 */
      Ra.v[2]=NULL;
      Ra.v[3]=NULL;
      if (V_sy_sym.ub[0]==14) Ra.ub[32]=15;
      else Ra.ub[32]=17;
      Rv2=((SL *)Rv0)[11];
      Ra.sl[16]=1993; /* line # 1993 */
      Rv3=0;
      V_sy_sym.ub[0]=18;
      if (((V *)Rv0)[4]!=NULL) {
        Ra.sl[16]=1998; /* line # 1998 */
        Rv4=((V *)Rv0)[4];
        if (((UB *)Rv0)[89]) P_type_parm_cte_init(F_ty, Ra.v+2,Ra.v+3,&Rv3);
        else while (1){
          Ra.sl[16]=2032; /* line # 2032 */
          P_insymbol();
          Rv5=Rv4;
          Rv6=((V *)Rv5)[4];
          Ra.sl[16]=2037; /* line # 2037 */
          Rv7=PAS_COMILER_PRC_00000005(Rv6,0,0,0);
          Rv8=Rv7;
          if (((UB *)Rv8)[40]==17) {
            Ra.sl[16]=2042; /* line # 2042 */
            ((UB *)Rv8)[40]=14;
            ((V *)Rv8)[7]=((V *)Rv5)[11];
            if (((V *)Rv8)[7]==NULL) P_src_error_s(Rd.s+482,157,3,((V *)Rv4)[0],
            NULL);
            P_val_new(((V *)Rv8)+7,Rv6);
            Ra.sl[16]=2047; /* line # 2047 */
            ((V *)Rv8)[4]=NULL;
            ((V *)Rv8)[3]=Rv6;
          }
          else {
            if (((UB *)Rv8)[40]!=14) P_src_error(Rd.s+482,132,3);
          }
          Ra.sl[16]=2052; /* line # 2052 */
          ((SL *)Rv8)[4]=((SL *)Rv5)[15];
          ((V *)Rv5)[10]=Rv7;
          Ra.sl[16]=2057; /* line # 2057 */
          ((UB *)Rv5)[64]=1;
          if (Ra.v[2]==NULL) Ra.v[2]=Rv7;
          else((V *)Ra.v[3])[0]=Rv7;
          Ra.v[3]=Rv7;
          Ra.sl[16]=2063; /* line # 2063 */
          Rv4=((V *)Rv4)[3];
          Rv3=Rv3+1;
          if (Rv4==NULL||V_sy_sym.ub[0]!=18)  break;
        }
      }
      Ra.sl[16]=2070; /* line # 2070 */
      if (((V *)Rv0)[4]!=NULL&&((V *)Rv0)[9]!=NULL) {
        Rv9=P_lgt_type_eval(((V *)Rv0)[9],NULL,NULL,0);
        if (((UB *)Rv9)[40]==14) {
          Ra.sl[16]=2075; /* line # 2075 */
          Rv2=((SL *)((V *)Rv9)[7])[13];
          P_lgt_free(&Rv9);
        }
        else P_src_error(Rd.s+482,142,3);
      }
      Ra.sl[16]=2081; /* line # 2081 */
      if (V_sy_sym.ub[0]!=18) P_src_error(Rd.s+482,29,2);
      switch (((UB *)Rv0)[92]) {
        case 11:
        case 12:Ra.sl[16]=2086; /* line # 2086 */
        if (V_sy_sym.ub[0]==14) P_src_error(Rd.s+482,133,2);
        Rv7=PAS_COMILER_PRC_00000018(F_ty,0);
        if (((UB *)Rv7)[40]!=14) Ra.ub[8]=0;
        if (Ra.v[2]==NULL) Ra.v[2]=Rv7;
        else {
          Ra.sl[16]=2091; /* line # 2091 */
          ((V *)Ra.v[3])[0]=Rv7;
        }
        Ra.v[3]=Rv7;
        break;
        case 10:
        case 23:Ra.sl[16]=2096; /* line # 2096 */
        PAS_COMILER_PRC_00000021(F_ty);
        break;
        case 8:PAS_COMILER_PRC_00000020(F_ty);
        break;
        default:Ra.sl[16]=2102; /* line # 2102 */
        P_src_error(Rd.s+482,131,3);
        P_skip_symbol(Ra.ub[32],0,0);
        break;
      }
      if (V_sy_sym.ub[0]==Ra.ub[32]) P_insymbol();
      else {
        Ra.sl[16]=2107; /* line # 2107 */
        P_src_error(Rd.s+482,26,2);
      }
      if (((V *)Rv0)[4]!=NULL) P_type_parm_cte_release(F_ty);
      Ra.sl[16]=2125; /* line # 2125 */
      if (Ra.ub[8]) {
        P_lgt_new(&Rv1, F_ty,14,NULL);
        switch (((UB *)F_ty)[92]) {
          case 8:
          case 9:
          case 10:Ra.sl[16]=2131; /* line # 2131 */
          P_val_new(((V *)Rv1)+7,F_ty);
          ((V *)((V *)Rv1)[7])[7]=NULL;
          Rv10=NULL;
          Rv11=Rv1;
          Rv12=((V *)Rv11)[7];
          Ra.sl[16]=2136; /* line # 2136 */
          ((SL *)Rv12)[2]=Rv3;
          ((SL *)Rv12)[6]=Rv2;
          while (Ra.v[2]!=NULL){
            Ra.sl[16]=2141; /* line # 2141 */
            Rv7=Ra.v[2];
            Rv13=NULL;
            P_val_copy(((V *)Rv7)+7,&Rv13,1);
            if (Rv10==NULL) ((V *)((V *)Rv1)[7])[7]=Rv13;
            else((V *)Rv10)[0]=Rv13;
            Ra.sl[16]=2146; /* line # 2146 */
            if (((UB *)F_ty)[92]!=10) {
              if (Rv3>0) Rv3=Rv3-1;
              else {
                if (((UB *)Rv13)[48]==29) ((SL *)Rv13)[6]=Ra.sl[1]-V_stri_stroffset;
                else((SL *)Rv13)[6]=Ra.sl[1];
              }
            }
            Ra.sl[16]=2151; /* line # 2151 */
            Rv10=Rv13;
            Ra.v[2]=((V *)Ra.v[2])[0];
            ((V *)Rv7)[7]=NULL;
            P_lgt_free(&Rv7);
          }
          break;
          default:Ra.sl[16]=2160; /* line # 2160 */
          P_val_copy(((V *)Ra.v[2])+7,((V *)Rv1)+7,1);
          ((SL *)((V *)Rv1)[7])[2]=Rv3;
          break;
        }
      }
      else {
        Ra.sl[16]=2167; /* line # 2167 */
        P_src_error(Rd.s+482,143,3);
        P_lgt_free_tree(Ra.v+2);
        Rv1=P_lgt_new_econst(V_typ_std.v[21],0);
      }
    }
  }
  Ra.sl[16]=2172; /* line # 2172 */
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[5];
  Lx[1]=Lx_Sv;
  return(Ret);
}


/* Procedure/Function : " exp_const_set "  */
V PAS_COMILER_PRC_00000022(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+486;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=2185; /* line # 2185 */
  Rv0=PAS_COMILER_PRC_00000018(NULL,0);
  if (V_sy_sym.ub[0]==17) P_insymbol();
  else P_src_error(Rd.s+503,26,2);
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " get_procref "  */
V PAS_COMILER_PRC_00000023(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+507;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=2201; /* line # 2201 */
  Rv0=NULL;
  Rv1=Lx[5].v[13];
  while (Rv1!=NULL&&Rv0==NULL)
  switch (((UB *)Rv1)[104]) {
    case 5:
    case 8:
    case 9:
    case 10:Ra.sl[6]=2206; /* line # 2206 */
    Rv0=Rv1;
    break;
    case 4:Rv1=((V *)Rv1)[14];
    break;
    default:Ra.sl[6]=2211; /* line # 2211 */
    P_src_error(Rd.s+522,171,3);
    Rv1=NULL;
    break;
  }
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_generic_ref "  */
V PAS_COMILER_PRC_00000024(V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  V Rv3;
  V Rv4;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+526;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=2234; /* line # 2234 */
  Rv0=NULL;
  P_insymbol();
  if (V_sy_sym.ub[0]==0) {
    Ra.sl[6]=2239; /* line # 2239 */
    Rv1=P_ide_search(898);
    if (Rv1!=V_ide_udptr.v[1]) {
      Rv2=Rv1;
      P_insymbol();
      Ra.sl[6]=2244; /* line # 2244 */
      if (V_sy_sym.ub[0]==17) P_insymbol();
      else P_src_error(Rd.s+545,26,2);
      switch (((UB *)Rv2)[56]) {
        case 1:
        case 8:
        case 9:Ra.sl[6]=2249; /* line # 2249 */
        Rv3=((V *)Rv2)[10];
        while (Rv3!=NULL&&!P_comp_proc_arg(((V *)Rv3)[2],((V *)F_ty)[13]))
        Rv3=((V *)Rv3)[0];
        if (Rv3==NULL) Rv0=NULL;
        else Rv0=((V *)Rv3)[2];
        if (((SL *)Rv0)[18]>1) P_src_error_s(Rd.s+545,401,2,((V *)Rv2)[0],NULL);
        break;
        case 7:Ra.sl[6]=2257; /* line # 2257 */
        if (P_comp_proc_arg(((V *)Rv2)[9],((V *)F_ty)[13])) Rv0=((V *)Rv2)[9];
        else Rv0=NULL;
        break;
        default:break;
      }
      Ra.sl[6]=2262; /* line # 2262 */
      if (Rv0!=NULL) {
        P_lgt_new(&Rv4, F_ty,10,NULL);
        ((V *)Rv4)[6]=Rv0;
      }
    }
  }
  Ra.sl[6]=2269; /* line # 2269 */
  if (Rv0==NULL) {
    P_src_error(Rd.s+545,402,3);
    Rv4=P_lgt_new_econst(V_typ_std.v[13],0);
  }
  Ra.sl[6]=2274; /* line # 2274 */
  Ret=Rv4;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_identifier "  */
V PAS_COMILER_PRC_00000025(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  V Rv3;
  register V Rv4;
  register V Rv5;
  register V Rv6;
  register V Rv7;
  register V Rv8;
  register V Rv9;
  register V Rv10;
  register V Rv11;
  V Rv12;
  register V Rv13;
  register V Rv14;
  register V Rv15;
  register V Rv16;
  register UB Rv17;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+549;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=2291; /* line # 2291 */
  if (V_sy_sym.ub[0]==78) {
    Rv0=PAS_COMILER_PRC_00000023();
    Ra.sl[6]=2296; /* line # 2296 */
    if (Rv0!=NULL) {
      if (((V *)Rv0)[11]!=NULL) {
        if (!((UB *)((V *)Rv0)[11])[91]) {
          P_insymbol();
          Ra.sl[6]=2301; /* line # 2301 */
          V_lastsymb=V_sy_sym.ub[0];
          V_sy_search=((V *)Rv0)[8];
          V_sy_sym.ub[0]=0;
        }
      }
    }
    if (V_sy_sym.ub[0]==78) {
      Ra.sl[6]=2307; /* line # 2307 */
      P_src_error(Rd.s+567,190,3);
      P_insymbol();
    }
  }
  Ra.sl[6]=2312; /* line # 2312 */
  if (V_sy_sym.ub[0]==0) {
    if (V_sy_search==NULL) {
      Rv1=P_ide_search(1014);
      Ra.sl[6]=2318; /* line # 2318 */
      P_insymbol();
    }
    else {
      Rv1=V_sy_search;
      Ra.sl[6]=2323; /* line # 2323 */
      V_sy_sym.ub[0]=V_lastsymb;
      V_sy_search=NULL;
    }
    if (Rv1!=NULL) {
      Ra.sl[6]=2329; /* line # 2329 */
      Rv2=Rv1;
      switch (((UB *)Rv2)[56]) {
        case 1:if (Rv1==V_ide_udptr.v[1]) {
          Ra.sl[6]=2335; /* line # 2335 */
          Rv3=P_lgt_new_econst(V_typ_std.v[21],0);
        }
        else switch (V_sy_sym.ub[0]) {
          case 25:Rv3=PAS_COMILER_PRC_00000007(NULL,((V *)Rv2)[4]);
          break;
          case 14:Ra.sl[6]=2340; /* line # 2340 */
          if (((V *)Rv2)[10]!=NULL) Rv3=PAS_COMILER_PRC_00000011(Rv1,1);
          else Rv3=PAS_COMILER_PRC_00000019(((V *)Rv2)[4]);
          break;
          case 16:if (((V *)Rv2)[4]!=NULL) {
            if (((UB *)((V *)Rv2)[4])[92]==6) Rv3=PAS_COMILER_PRC_00000024(((V *)
            Rv2)[4]);
            else {
              Ra.sl[6]=2345; /* line # 2345 */
              Rv3=PAS_COMILER_PRC_00000019(((V *)Rv2)[4]);
            }
          }
          break;
          default:P_src_error(Rd.s+567,36,3);
          break;
        }
        break;
        case 7:
        case 8:Ra.sl[6]=2352; /* line # 2352 */
        Rv3=PAS_COMILER_PRC_00000009(Rv1,1);
        break;
        case 9:Rv3=PAS_COMILER_PRC_00000011(Rv1,1);
        break;
        case 2:Ra.sl[6]=2359; /* line # 2359 */
        switch (((UB *)Rv2)[64]) {
          case 2:if (((V *)Rv2)[11]!=NULL) {
            P_lgt_new(&Rv3,((V *)Rv2)[4],14,NULL);
            Ra.sl[6]=2364; /* line # 2364 */
            Rv4=Rv3;
            ((V *)Rv4)[7]=((V *)Rv2)[11];
            P_val_new(((V *)Rv4)+7,((V *)Rv2)[4]);
          }
          else {
            Ra.sl[6]=2372; /* line # 2372 */
            Rv3=PAS_COMILER_PRC_00000005(((V *)Rv2)[4],0,0,0);
          }
          break;
          case 0:P_lgt_new(&Rv3,((V *)Rv2)[4],13,NULL);
          Ra.sl[6]=2377; /* line # 2377 */
          if (((V *)Rv2)[9]==NULL) ((V *)Rv2)[9]=Rv3;
          ((V *)Rv2)[10]=NULL;
          Ra.sl[6]=2382; /* line # 2382 */
          Rv5=Rv3;
          ((V *)Rv5)[6]=Rv1;
          ((UW *)Rv5)[10]=1;
          break;
          case 3:Ra.sl[6]=2390; /* line # 2390 */
          Rv6=(V_lex_ident_tree.s+V_ident_disp*64);
          if (((UB *)Rv6)[24]==1) {
            P_lgt_new_copy(((V *)Rv6)[2],&Rv3);
            Rv7=Rv3;
            Ra.sl[6]=2396; /* line # 2396 */
            ((V *)Rv7)[3]=((V *)Rv2)[4];
            ((SL *)Rv7)[4]=((SL *)Rv7)[4]+((SL *)Rv2)[15];
          }
          else {
            Ra.sl[6]=2402; /* line # 2402 */
            P_lgt_new_copy(((V *)Rv6)[2],&Rv3);
            P_lgt_new(&Rv3,((V *)Rv2)[4],2, Rv3);
            ((SL *)Rv3)[4]=((SL *)Rv2)[15];
            if (((SL *)Rv6)[13]>=0) ((SL *)Rv6)[13]=((SL *)Rv6)[13]+1;
            else {
              Ra.sl[6]=2408; /* line # 2408 */
              Rv8=(V_lex_ident_tree.s+(V_ident_disp-1)*64);
              ((SL *)Rv8)[13]=((SL *)Rv8)[13]+1;
            }
          }
          break;
          default:break;
        }
        Ra.sl[6]=2414; /* line # 2414 */
        ((V *)Rv3)[4]=Rv1;
        ((UW *)Rv3)[10]=1;
        break;
        case 5:Ra.sl[6]=2421; /* line # 2421 */
        Rv3=P_lgt_new_idref(Rv1,NULL);
        Rv9=Rv3;
        if (((SL *)Lx[5].v[13])[18]>=((SL *)Rv2)[10]) ((UW *)Rv2)[46]=((UW *)Rv2)
        [46]|4;
        Ra.sl[6]=2427; /* line # 2427 */
        switch (((UB *)Rv2)[94]) {
          case 1:
          case 2:
          case 3:
          case 6:Ra.sl[6]=2434; /* line # 2434 */
          if ((((UB *)((V *)Rv2)[4])[89]||((UB *)((V *)Rv2)[4])[90])&&!(16&((UW *)
          Rv2)[46])) P_init_d_varbl(Rv1);
          Ra.sl[6]=2440; /* line # 2440 */
          if (((((UB *)Rv2)[94]==1&&((SL *)Rv2)[10]>1)&&((V *)Rv2)[8]!=NULL)&&!(
8&((UW *)Rv2)[46])) P_initialize_varbl(Rv1);
          break;
          case 10:Ra.sl[6]=2450; /* line # 2450 */
          ((V *)Rv9)[3]=V_typ_std.v[13];
          ((UW *)Rv9)[10]=1;
          break;
          default:break;
        }
        Ra.sl[6]=2458; /* line # 2458 */
        ((V *)Rv3)[4]=Rv1;
        break;
        case 4:Ra.sl[6]=2463; /* line # 2463 */
        Rv3=P_lgt_new_idref(Rv1,NULL);
        ((V *)Rv3)[4]=Rv1;
        break;
        case 6:Ra.sl[6]=2468; /* line # 2468 */
        Rv10=(V_lex_ident_tree.s+V_ident_disp*64);
        P_lgt_new_copy(((V *)Rv10)[2],&Rv3);
        if (((UB *)Rv10)[24]==1) {
          Ra.sl[6]=2473; /* line # 2473 */
          if (((SL *)((V *)Rv3)[3])[10]>0) V_curr_descr=Rv3;
          P_lgt_new(&Rv3,((V *)Rv2)[4],3, Rv3);
          ((SL *)Rv3)[4]=((SL *)Rv2)[15];
        }
        else {
          Ra.sl[6]=2479; /* line # 2479 */
          Rv11=Rv3;
          if (((UB *)((V *)Rv11)[3])[92]==24) {
            Rv12=((V *)((V *)((V *)Rv11)[3])[0])[3];
            ((V *)Rv11)[0]=P_lgt_new_econst(V_typ_std.v[2],((SL *)Rv2)[15]);
            Ra.sl[6]=2484; /* line # 2484 */
            if (Rv12!=NULL) Rv3=P_exp_genoper(((V *)Rv12)[0],((V *)Rv12)[10],Rv3);
            else P_src_error(Rd.s+567,998,3);
            ((V *)Rv3)[3]=((V *)Rv2)[4];
          }
          else {
            Ra.sl[6]=2492; /* line # 2492 */
            P_lgt_new(&Rv3,((V *)((V *)Rv3)[3])[12],2, Rv3);
            if (((SL *)((V *)Rv3)[3])[10]>0) V_curr_descr=Rv3;
            P_lgt_new(&Rv3,((V *)Rv2)[4],3, Rv3);
            ((SL *)Rv3)[4]=((SL *)Rv2)[15];
          }
          Ra.sl[6]=2498; /* line # 2498 */
          if (((SL *)Rv10)[13]>=0) ((SL *)Rv10)[13]=((SL *)Rv10)[13]+1;
          else {
            Rv13=(V_lex_ident_tree.s+(V_ident_disp-1)*64);
            ((SL *)Rv13)[13]=((SL *)Rv13)[13]+1;
          }
        }
        Ra.sl[6]=2504; /* line # 2504 */
        Rv14=Rv3;
        ((UW *)Rv14)[10]=((UW *)((V *)Rv10)[2])[10]|4;
        ((V *)Rv14)[4]=Rv1;
        break;
      }
    }
    else {
      Ra.sl[6]=2514; /* line # 2514 */
      P_src_error(Rd.s+567,107,3);
      Rv3=P_lgt_new_econst(V_typ_std.v[21],0);
    }
  }
  else {
    Ra.sl[6]=2520; /* line # 2520 */
    switch (V_sy_sym.ub[0]) {
      case 28:Rv3=P_lgt_new_econst(V_typ_std.v[13],0);
      break;
      case 2:Rv3=P_lgt_new_econst(V_typ_std.v[2],V_sy_ival);
      break;
      case 3:Ra.sl[6]=2525; /* line # 2525 */
      Rv3=P_lgt_new_econst(V_typ_std.v[3],0);
      ((G *)((V *)Rv3)[7])[7]=V_sy_rval;
      break;
      case 4:Ra.sl[6]=2530; /* line # 2530 */
      Rv3=P_lgt_new_econst(V_typ_std.v[4],0);
      ((G *)((V *)Rv3)[7])[7]=V_sy_rval;
      break;
      case 5:Ra.sl[6]=2535; /* line # 2535 */
      Rv3=P_lgt_new_econst(V_typ_std.v[0],(SL)V_sy_string.c[2]);
      if (V_sy_string.ub[1]!=1) {
        Rv15=Rv3;
        Rv16=((V *)Rv15)[7];
        Ra.sl[6]=2541; /* line # 2541 */
        ((V *)Rv15)[3]=V_typ_std.v[10];
        ((UB *)Rv16)[48]=29;
        ((SL *)Rv16)[6]=V_sy_string.ub[1];
        ((V *)Rv16)[4]=((V *)Rv15)[3];
        if (V_sy_string.ub[1]>0) {
          Ra.sl[6]=2547; /* line # 2547 */
          Rv17=V_sy_string.ub[1];
          ((V *)Rv16)[7]=PAS__NEW((SL)Rv17+2);
          ((UB *)((V *)Rv16)[7])[0]=Rv17;
          PAS__STR_TO_STR(((V *)Rv16)[7],V_sy_string.s);
        }
        else((V *)Rv16)[7]=NULL;
      }
      break;
      default:Ra.sl[6]=2555; /* line # 2555 */
      if (Ri.ub[0]) P_src_error(Rd.s+567,44,2);
      P_lgt_new(&Rv3, V_typ_std.v[21],17,NULL);
      break;
    }
    Ra.sl[6]=2560; /* line # 2560 */
    if (((UB *)Rv3)[40]!=17) P_insymbol();
  }
  Ret=Rv3;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_indir "  */
V PAS_COMILER_PRC_00000026(V F_pobj){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  register V Rv3;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+571;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=2576; /* line # 2576 */
  Rv0=F_pobj;
  Rv1=((V *)F_pobj)[3];
  switch (((UB *)Rv1)[92]) {
    case 7:Ra.sl[6]=2582; /* line # 2582 */
    ((V *)F_pobj)[3]=V_typ_std.v[13];
    P_lgt_new(&Rv0, V_typ_std.v[13],2, F_pobj);
    Rv2=Rv0;
    ((UW *)Rv2)[10]=((UW *)Rv2)[10]|4;
    P_lgt_new(&Rv0,((V *)Rv1)[12],2, Rv0);
    break;
    case 5:Ra.sl[6]=2590; /* line # 2590 */
    P_lgt_new(&Rv0,((V *)Rv1)[12],2, F_pobj);
    break;
    case 6:Ra.sl[6]=2596; /* line # 2596 */
    Rv0=PAS_COMILER_PRC_00000010(F_pobj);
    break;
    default:P_src_error(Rd.s+584,151,3);
    break;
  }
  Ra.sl[6]=2602; /* line # 2602 */
  if (((UB *)Rv1)[92]!=6) {
    Rv3=Rv0;
    ((UW *)Rv3)[10]=((UW *)Rv3)[10]|4;
  }
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_field "  */
V PAS_COMILER_PRC_00000027(V F_pobj){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  SL Rv2;
  register V Rv3;
  register V Rv4;
  register V Rv5;
  register V Rv6;
  register V Rv7;
  register V Rv8;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+588;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=2621; /* line # 2621 */
  Rv0=0;
  Rv1=NULL;
  Rv2=0;
  if (V_sy_sym.ub[0]==0) {
    Ra.sl[6]=2626; /* line # 2626 */
    Rv3=F_pobj;
    Rv4=((V *)Rv3)[3];
    if (((V *)Rv4)[4]!=NULL) {
      Rv1=P_level_search(((V *)Rv4)[4]);
      Ra.sl[6]=2631; /* line # 2631 */
      if (Rv1!=NULL) {
        Rv5=Rv1;
        if (((UB *)Rv3)[40]!=14) ((V *)Rv3)[4]=Rv1;
        Rv2=((SL *)Rv5)[15];
      }
    }
    Ra.sl[6]=2639; /* line # 2639 */
    if (Rv1==NULL) {
      if (((UB *)Rv4)[92]!=10) {
        F_pobj=P_lgt_new_econst(V_typ_std.v[21],0);
        P_src_error(Rd.s+601,152,3);
        Ra.sl[6]=2644; /* line # 2644 */
        Rv0=1;
      }
      else {
        Rv1=P_level_search(((V *)Rv4)[12]);
        Ra.sl[6]=2649; /* line # 2649 */
        if (Rv1!=NULL) {
          Rv6=Rv1;
          if (((UB *)Rv3)[40]!=14) ((V *)Rv3)[4]=Rv1;
          Rv2=((SL *)Rv6)[15];
        }
        else Ra.sl[6]=2656; /* line # 2656 */
      }
    }
    if (Rv1!=NULL) {
      Rv7=Rv1;
      Ra.sl[6]=2661; /* line # 2661 */
      if (Rv2!=0&&V_curr_descr==F_pobj) {
        if (((UB *)Rv3)[40]==14) {
          P_lgt_new_copy(F_pobj, &F_pobj);
          ((V *)F_pobj)[3]=((V *)Rv7)[4];
        }
        else {
          P_lgt_new(&F_pobj,((V *)Rv7)[4],3, F_pobj);
          ((UW *)F_pobj)[10]=((UW *)((V *)F_pobj)[1])[10];
        }
      }
      else {
        Ra.sl[6]=2668; /* line # 2668 */
        Rv2=((SL *)Rv3)[4]+Rv2;
        ((V *)Rv3)[3]=((V *)Rv7)[4];
      }
      ((SL *)F_pobj)[4]=((SL *)Rv3)[4]+Rv2;
    }
    else {
      Ra.sl[6]=2673; /* line # 2673 */
      F_pobj=P_lgt_new_econst(V_typ_std.v[21],0);
      P_src_error_s(Rd.s+601,153,2, V_sy_ident.s,NULL);
      Rv0=1;
    }
    Ra.sl[6]=2678; /* line # 2678 */
    P_insymbol();
  }
  else {
    P_src_error(Rd.s+601,156,3);
    Ra.sl[6]=2683; /* line # 2683 */
    Rv0=1;
  }
  Rv8=F_pobj;
  if (Rv0) ((V *)Rv8)[3]=V_typ_std.v[21];
  else {
    Ra.sl[6]=2690; /* line # 2690 */
    ((SL *)Rv8)[4]=Rv2;
    ((UW *)Rv8)[10]=((UW *)Rv8)[10]|4;
    if (((UB *)Rv8)[40]==14) {
      if (((V *)Rv8)[3]!=NULL) {
        if (((UB *)((V *)Rv8)[3])[91]) P_lgt_extract_simple_cte(F_pobj);
      }
    }
  }
  Ra.sl[6]=2697; /* line # 2697 */
  Ret=F_pobj;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_index "  */
V PAS_COMILER_PRC_00000028(V F_pobj){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  register V Rv3;
  V Rv4;
  SL Rv5;
  V Rv6;
  V Rv7;
  V Rv8;
  register V Rv9;
  SL Rv10;
  SL Rv11;
  SL Rv12;
  register V Rv13;
  V Rv14;
  register V Rv15;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+605;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=2711; /* line # 2711 */
  Rv0=F_pobj;
  if (P_comp_type(((V *)F_pobj)[3],V_typ_std.v[10],1,0)) {
    Ra.sl[6]=2716; /* line # 2716 */
    V_curr_descr=F_pobj;
    P_lgt_new(&Rv0,((V *)((V *)V_typ_std.v[10])[13])[4],3, F_pobj);
    ((SL *)Rv0)[4]=((SL *)((V *)V_typ_std.v[10])[13])[15];
  }
  else {
    Ra.sl[6]=2721; /* line # 2721 */
    Rv1=F_pobj;
    if (((SL *)((V *)F_pobj)[3])[10]>0) {
      V_curr_descr=F_pobj;
      P_lgt_new(&Rv0,((V *)F_pobj)[3],3, F_pobj);
      Ra.sl[6]=2726; /* line # 2726 */
      ((SL *)Rv0)[4]=((SL *)F_pobj)[4]+((SL *)((V *)F_pobj)[3])[10];
    }
    else Rv0=F_pobj;
  }
  Rv2=Rv0;
  Ra.sl[6]=2732; /* line # 2732 */
  Rv3=((V *)Rv2)[3];
  if (((UB *)Rv3)[92]==8||((UB *)Rv3)[92]==9) {
    Rv4=PAS_COMILER_PRC_00000005(((V *)Rv3)[15],0,0,0);
    Ra.sl[6]=2737; /* line # 2737 */
    if (((UB *)Rv4)[40]==14) {
      Rv5=((SL *)((V *)Rv4)[7])[13];
      P_lgt_free(&Rv4);
    }
    Ra.sl[6]=2742; /* line # 2742 */
    Rv6=NULL;
    Rv7=NULL;
    Rv8=NULL;
    Rv9=((V *)Rv3)[15];
    Ra.sl[6]=2747; /* line # 2747 */
    if (((UB *)Rv9)[92]==22) {
      if (((UB *)((V *)Rv9)[13])[40]==14) {
        Rv10=((SL *)((V *)((V *)Rv9)[13])[7])[13];
        Rv7=((V *)Rv9)[14];
      }
      else {
        Ra.sl[6]=2755; /* line # 2755 */
        Rv6=P_lgt_type_eval(((V *)Rv9)[13],V_curr_descr,NULL,0);
        Ra.sl[6]=2762; /* line # 2762 */
        if (((UB *)((V *)Rv9)[14])[40]==14) {
          Rv11=((SL *)((V *)((V *)Rv9)[14])[7])[13];
          Rv7=((V *)Rv9)[14];
        }
      }
    }
    else {
      Ra.sl[6]=2770; /* line # 2770 */
      Rv10=((SL *)Rv9)[29];
      Rv11=((SL *)Rv9)[30];
    }
    if (((SL *)Rv3)[25]>0) Rv12=((SL *)Rv3)[25];
    else {
      Ra.sl[6]=2777; /* line # 2777 */
      Rv8=P_lgt_type_eval(((V *)Rv3)[13],V_curr_descr,NULL,0);
      if (Rv8!=NULL) {
        Rv13=Rv8;
        if (((UB *)Rv13)[40]==14) {
          Ra.sl[6]=2782; /* line # 2782 */
          Rv12=((SL *)((V *)Rv13)[7])[13];
          P_lgt_free(&Rv8);
        }
      }
    }
    Ra.sl[6]=2787; /* line # 2787 */
    if (Rv4==NULL&&Rv6==NULL) {
      if (Rv5<Rv10||Rv7==NULL&&Rv5>Rv11) P_src_error(Rd.s+618,154,2);
      Rv5=Rv5-Rv10;
      Ra.sl[6]=2792; /* line # 2792 */
      if (Rv8==NULL) {
        Rv14=Rv0;
        ((SL *)Rv14)[4]=((SL *)Rv2)[4]+Rv5*Rv12;
        ((V *)Rv14)[3]=((V *)Rv3)[14];
      }
      else {
        Ra.sl[6]=2800; /* line # 2800 */
        Rv4=P_lgt_new_econst(V_int_typ, Rv5);
        ((V *)Rv0)[0]=Rv4;
        ((V *)Rv4)[0]=Rv8;
        P_lgt_new(&Rv14,((V *)Rv3)[14],1, Rv0);
        ((UW *)Rv14)[10]=((UW *)Rv0)[10];
        Ra.sl[6]=2805; /* line # 2805 */
        ((V *)Rv14)[6]=((V *)Rv2)[3];
      }
    }
    else {
      Ra.sl[6]=2810; /* line # 2810 */
      P_lgt_new(&Rv14,((V *)Rv3)[14],1, Rv0);
      ((V *)Rv14)[6]=((V *)Rv2)[3];
      if (Rv8==NULL) {
        if (Rv4==NULL) {
          Ra.sl[6]=2816; /* line # 2816 */
          Rv4=P_lgt_new_code(46, Rv6);
          ((SL *)Rv14)[4]=Rv5*Rv12;
        }
        else {
          Ra.sl[6]=2821; /* line # 2821 */
          if (Rv6==NULL) ((SL *)Rv14)[4]= -Rv10*Rv12;
          else {
            Ra.sl[6]=2826; /* line # 2826 */
            ((V *)Rv4)[0]=Rv6;
            Rv4=P_lgt_new_code(50, Rv4);
          }
        }
        ((V *)Rv4)[0]=P_lgt_new_econst(V_int_typ, Rv12);
      }
      else {
        Ra.sl[6]=2834; /* line # 2834 */
        if (Rv4==NULL) {
          if (Rv5!=0) Rv4=P_lgt_new_econst(V_int_typ, Rv5);
        }
        else {
          Ra.sl[6]=2840; /* line # 2840 */
          if (Rv6==NULL) {
            if (Rv10!=0) Rv6=P_lgt_new_econst(V_int_typ, Rv10);
          }
        }
        if (Rv4==NULL) {
          Ra.sl[6]=2845; /* line # 2845 */
          Rv4=P_lgt_new_code(46, Rv4);
        }
        else {
          if (Rv6!=NULL) {
            ((V *)Rv4)[0]=Rv6;
            Ra.sl[6]=2850; /* line # 2850 */
            Rv4=P_lgt_new_code(50, Rv4);
          }
        }
        ((V *)Rv4)[0]=Rv8;
      }
      ((V *)Rv0)[0]=Rv4;
    }
  }
  else {
    Ra.sl[6]=2859; /* line # 2859 */
    P_src_error(Rd.s+618,155,3);
    ((V *)Rv2)[3]=V_typ_std.v[21];
    ((V *)Rv2)[1]=NULL;
    Rv14=F_pobj;
    P_skip_symbol(17,0,0);
  }
  Ra.sl[6]=2866; /* line # 2866 */
  Rv15=Rv14;
  Ra.sl[6]=2877; /* line # 2877 */
  ((UW *)Rv15)[10]=((UW *)Rv15)[10]|4;
  if (((UB *)Rv15)[40]==14) {
    if (((V *)Rv15)[3]!=NULL) {
      if (((UB *)((V *)Rv15)[3])[91]) P_lgt_extract_simple_cte(Rv14);
    }
  }
  Ra.sl[6]=2883; /* line # 2883 */
  Ret=Rv14;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_una "  */
V PAS_COMILER_PRC_00000035(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  UB Rv2;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+622;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=2933; /* line # 2933 */
  if (V_sy_sym.ub[0]==9&&(V_sy_sym.ub[1]==12||V_sy_sym.ub[1]==11)) V_sy_sym.ub[0]
  =6;
  if (V_sy_sym.ub[0]==6) {
    Ra.sl[6]=2939; /* line # 2939 */
    if (V_sy_sym.ub[1]!=11) Rv0=V_sy_sym.ub[1];
    else Rv0=29;
    P_insymbol();
    Rv1=PAS_COMILER_PRC_00000035();
    if (Rv0!=29) {
      Ra.sl[6]=2944; /* line # 2944 */
      if (((UB *)Rv1)[40]!=17) Rv1=P_exp_genop(Rv0, Rv1);
    }
  }
  else {
    if (V_sy_sym.ub[0]==14) {
      Ra.sl[6]=2950; /* line # 2950 */
      P_insymbol();
      Rv1=PAS_COMILER_PRC_00000000();
      if (V_sy_sym.ub[0]==15) P_insymbol();
      else P_src_error(Rd.s+633,23,3);
    }
    else {
      Ra.sl[6]=2956; /* line # 2956 */
      if (V_sy_sym.ub[0]==16) Rv1=PAS_COMILER_PRC_00000022();
      else {
        Ra.sl[6]=2961; /* line # 2961 */
        Rv1=PAS_COMILER_PRC_00000025();
        Rv2=((UB *)Rv1)[40]!=17;
        if (((SL *)((V *)Rv1)[3])[10]>0) V_curr_descr=Rv1;
        while (Rv2)
        switch (V_sy_sym.ub[0]) {
          case 24:Ra.sl[6]=2968; /* line # 2968 */
          P_insymbol();
          Rv1=PAS_COMILER_PRC_00000026(Rv1);
          if (((SL *)((V *)Rv1)[3])[10]!=0) V_curr_descr=Rv1;
          break;
          case 16:Ra.sl[6]=2975; /* line # 2975 */
          V_sy_sym.ub[0]=18;
          while (V_sy_sym.ub[0]==18){
            P_insymbol();
            Rv1=PAS_COMILER_PRC_00000028(Rv1);
            Ra.sl[6]=2980; /* line # 2980 */
            if (((SL *)((V *)Rv1)[3])[10]!=0) V_curr_descr=Rv1;
          }
          if (V_sy_sym.ub[0]==17) P_insymbol();
          else P_src_error(Rd.s+633,26,2);
          break;
          case 20:Ra.sl[6]=2988; /* line # 2988 */
          P_insymbol();
          Rv1=PAS_COMILER_PRC_00000027(Rv1);
          if (((SL *)((V *)Rv1)[3])[10]!=0) V_curr_descr=Rv1;
          break;
          case 25:Ra.sl[6]=2994; /* line # 2994 */
          Rv1=PAS_COMILER_PRC_00000007(Rv1,((V *)Rv1)[3]);
          break;
          default:Rv2=0;
          break;
        }
      }
    }
  }
  Ra.sl[6]=3002; /* line # 3002 */
  Ri.ub[0]=0;
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_pow "  */
V PAS_COMILER_PRC_00000034(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  UB Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+637;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=3007; /* line # 3007 */
  Rv0=PAS_COMILER_PRC_00000035();
  if (((UB *)Rv0)[40]!=17) {
    if (V_sy_sym.ub[0]==7) {
      Ra.sl[6]=3012; /* line # 3012 */
      Rv1=V_sy_sym.ub[1];
      P_insymbol();
      Ri.ub[0]=1;
      ((V *)Rv0)[0]=PAS_COMILER_PRC_00000035();
      Rv0=P_exp_genop(Rv1, Rv0);
    }
  }
  Ra.sl[6]=3018; /* line # 3018 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_mul "  */
V PAS_COMILER_PRC_00000033(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  UB Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+646;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=3022; /* line # 3022 */
  Rv0=PAS_COMILER_PRC_00000034();
  if (((UB *)Rv0)[40]!=17) while (V_sy_sym.ub[0]==8){
    Ra.sl[6]=3027; /* line # 3027 */
    Rv1=V_sy_sym.ub[1];
    P_insymbol();
    Ri.ub[0]=1;
    ((V *)Rv0)[0]=PAS_COMILER_PRC_00000034();
    Rv0=P_exp_genop(Rv1, Rv0);
  }
  Ra.sl[6]=3033; /* line # 3033 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_add "  */
V PAS_COMILER_PRC_00000032(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  UB Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+655;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=3037; /* line # 3037 */
  Rv0=PAS_COMILER_PRC_00000033();
  if (((UB *)Rv0)[40]!=17) while (V_sy_sym.ub[0]==9){
    Ra.sl[6]=3042; /* line # 3042 */
    Rv1=V_sy_sym.ub[1];
    P_insymbol();
    Ri.ub[0]=1;
    ((V *)Rv0)[0]=PAS_COMILER_PRC_00000033();
    Rv0=P_exp_genop(Rv1, Rv0);
  }
  Ra.sl[6]=3048; /* line # 3048 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_rel "  */
V PAS_COMILER_PRC_00000031(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  UB Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+664;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=3052; /* line # 3052 */
  Rv0=PAS_COMILER_PRC_00000032();
  if (((UB *)Rv0)[40]!=17) while (V_sy_sym.ub[0]==10){
    Ra.sl[6]=3057; /* line # 3057 */
    Rv1=V_sy_sym.ub[1];
    P_insymbol();
    Ri.ub[0]=1;
    ((V *)Rv0)[0]=PAS_COMILER_PRC_00000032();
    Rv0=P_exp_genop(Rv1, Rv0);
  }
  Ra.sl[6]=3063; /* line # 3063 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_not "  */
V PAS_COMILER_PRC_00000030(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+673;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=3067; /* line # 3067 */
  if (V_sy_sym.ub[0]==11) {
    Rv0=V_sy_sym.ub[1];
    P_insymbol();
    Ra.sl[6]=3072; /* line # 3072 */
    Rv1=PAS_COMILER_PRC_00000030();
    Ri.ub[0]=1;
    if (((UB *)Rv1)[40]!=17) Rv1=P_exp_genop(Rv0, Rv1);
  }
  else {
    Ra.sl[6]=3078; /* line # 3078 */
    Rv1=PAS_COMILER_PRC_00000031();
  }
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_and "  */
V PAS_COMILER_PRC_00000029(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  UB Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+682;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=3083; /* line # 3083 */
  Rv0=PAS_COMILER_PRC_00000030();
  if (((UB *)Rv0)[40]!=17) while (V_sy_sym.ub[0]==12){
    Ra.sl[6]=3088; /* line # 3088 */
    Rv1=V_sy_sym.ub[1];
    P_insymbol();
    Ri.ub[0]=1;
    ((V *)Rv0)[0]=PAS_COMILER_PRC_00000030();
    Rv0=P_exp_genop(Rv1, Rv0);
  }
  Ra.sl[6]=3094; /* line # 3094 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " expression "  */
V PAS_COMILER_PRC_00000000(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  UB Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+691;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=3098; /* line # 3098 */
  Rv0=PAS_COMILER_PRC_00000029();
  if (((UB *)Rv0)[40]!=17) while (V_sy_sym.ub[0]==13){
    Ra.sl[6]=3103; /* line # 3103 */
    Rv1=V_sy_sym.ub[1];
    P_insymbol();
    Ri.ub[0]=1;
    ((V *)Rv0)[0]=PAS_COMILER_PRC_00000029();
    Rv0=P_exp_genop(Rv1, Rv0);
  }
  Ra.sl[6]=3109; /* line # 3109 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " case_work_list "  */
V PAS_COMILER_PRC_00000040(UB F_mode, V F_ty, UB F_blist){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  V Rv3;
  register V Rv4;
  SL Rv5;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+703;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=3200; /* line # 3200 */
  Rv0=NULL;
  switch (F_mode) {
    case 2:
    case 30:Ra.sl[6]=3205; /* line # 3205 */
    P_lgt_new(&Rv0,NULL,16,NULL);
    PAS_COMILER_PRC_00000039(((V *)Rv0)+3,0,NULL,0,0);
    if ((V_sy_sym.ub[0]!=19&&V_sy_sym.ub[0]!=73)&&V_sy_sym.ub[0]!=86) P_src_error(
    Rd.s+721,35,2);
    break;
    case 42:Ra.sl[6]=3212; /* line # 3212 */
    Rv2=F_ty;
    if (V_sy_sym.ub[0]==14) P_insymbol();
    else P_src_error(Rd.s+721,22,2);
    P_ide_new_typ(23, &Rv3);
    Ra.sl[6]=3217; /* line # 3217 */
    P_lgt_new(&Rv0, Rv3,16,NULL);
    Rv4=Rv3;
    ((SL *)Rv4)[11]=Lx[2].sl[0];
    ((V *)Rv4)[12]=NULL;
    Ra.sl[6]=3222; /* line # 3222 */
    ((V *)Rv4)[13]=NULL;
    ((V *)Rv4)[14]=NULL;
    PAS_COMILER_PRC_00000038(6,((SL *)Rv4)+11,&Rv5, Rv3);
    if (Lx[2].v[1]==NULL) ((V *)Rv4)[12]=V_lex_ident_tree.v[V_curr_disp*8+1];
    else {
      Ra.sl[6]=3228; /* line # 3228 */
      ((V *)Rv4)[12]=((V *)Lx[2].v[1])[3];
    }
    if (((V *)Rv4)[13]==NULL) ((V *)Rv4)[13]=V_lex_ident_tree.v[V_curr_disp*8+4]
    ;
    Lx[2].v[1]=((V *)Rv4)[13];
    Ra.sl[6]=3234; /* line # 3234 */
    if (((SL *)Rv3)[11]>((SL *)Rv2)[11]) ((SL *)Rv2)[11]=((SL *)Rv3)[11];
    else {
      if (((SL *)Rv3)[11]<0) ((SL *)Rv2)[11]=-1;
    }
    if (Rv5>((UB *)Rv2)[48]) ((UB *)Rv2)[48]=Rv5;
    if (V_sy_sym.ub[0]==15) P_insymbol();
    else {
      Ra.sl[6]=3239; /* line # 3239 */
      P_src_error(Rd.s+721,23,2);
    }
    break;
    case 23:Ra.sl[6]=3244; /* line # 3244 */
    Rv0=PAS_COMILER_PRC_00000005(F_ty,0,0,0);
    if ((V_sy_sym.ub[0]!=18&&V_sy_sym.ub[0]!=73)&&V_sy_sym.ub[0]!=86) P_src_error(
    Rd.s+721,35,2);
    break;
    default:Ra.sl[6]=3250; /* line # 3250 */
    if (F_blist) Rv0=PAS_COMILER_PRC_00000036(73,1);
    else Rv0=PAS_COMILER_PRC_00000037(NULL,1);
    if (Rv0==NULL) {
      P_lgt_new(&Rv0,NULL,16,NULL);
      Ra.sl[6]=3255; /* line # 3255 */
      if (F_blist) {
        Rv1=Rv0;
        ((UW *)Rv1)[10]=((UW *)Rv1)[10]|2048;
      }
    }
    if ((V_sy_sym.ub[0]!=19&&V_sy_sym.ub[0]!=73)&&V_sy_sym.ub[0]!=86) {
      Ra.sl[6]=3260; /* line # 3260 */
      P_src_error(Rd.s+721,35,2);
    }
    break;
  }
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " case_definition "  */
V PAS_COMILER_PRC_00000004(UB F_mode, V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 2096 );

  /* Local variable stored in C variable */
  V Rv0;
  C Rv1;
  V Rv2;
  UB Rv3;
  V Rv4;
  register V Rv5;
  V Rv6;
  V Rv7;
  register V Rv8;
  V Rv9;
  SL Rv10;
  SL Rv11;
  SL Rv12;
  SL Rv13;
  UB Rv14;
  UB Rv15;
  UB Rv16;
  SL Rv17;
  SL Rv18;
  SL Rv19;
  SL Rv20;
  V Rv21;
  register V Rv22;
  register V Rv23;
  register V Rv24;
  SL Rv25;
  register int Rf0;
  register V Ret;
  register P Lx_Sv;
  Lx_Sv=Lx[2];
  Lx[2].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[2]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+16;
  Ra.v[3]=Rd.s+725;
  Ra.v[4]=Rd.s+17;
  Ra.sl[10]=3267; /* line # 3267 */
  if (F_mode==42) Ra.sl[0]=abs(((SL *)F_ty)[11]);
  else {
    Ra.sl[10]=3272; /* line # 3272 */
    Ra.sl[0]=0;
  }
  Rv0=NULL;
  if (F_mode==42) {
    Ra.sl[10]=3277; /* line # 3277 */
    if (F_ty!=NULL) Ra.v[1]=((V *)F_ty)[13];
    V_sy_casedef=1;
    Rv1=P_src_search_char();
    if (Rv1==58) {
      Ra.sl[10]=3283; /* line # 3283 */
      P_ide_new(6,NULL,&Rv2);
      Ra.v[1]=Rv2;
      P_insymbol();
      if (V_sy_sym.ub[0]!=22) P_src_error(Rd.s+721,29,2);
      else P_insymbol();
      Ra.sl[10]=3289; /* line # 3289 */
      Rv3=1;
    }
    else Rv3=0;
    Ra.sl[10]=3294; /* line # 3294 */
    V_err_prt=0;
    Rv4=P_ide_search(2);
    V_err_prt=1;
    if (!Rv3&&Rv4!=NULL) {
      Ra.sl[10]=3299; /* line # 3299 */
      Rv1=P_src_search_char();
      if (Rv1==34||Rv1==40) Rv4=NULL;
    }
    if (Rv4!=NULL) {
      Ra.sl[10]=3304; /* line # 3304 */
      Rv0=((V *)Rv4)[4];
      if (!P_comp_type(Rv0, V_typ_std.v[15],0,0)) {
        P_src_error(Rd.s+721,60,2);
        Ra.sl[10]=3309; /* line # 3309 */
        Rv0=V_typ_std.v[2];
      }
      if (Rv3) {
        Rv5=Rv2;
        Ra.sl[10]=3314; /* line # 3314 */
        ((V *)Rv5)[4]=Rv0;
        ((SL *)Rv5)[15]=P_ide_typ_align(Ra.sl[0],Rv0);
        Ra.sl[0]=((SL *)Rv5)[15]+((SL *)Rv0)[11];
        if (((UB *)Rv0)[48]>((UB *)F_ty)[48]) {
          Ra.sl[10]=3319; /* line # 3319 */
          ((UB *)F_ty)[48]=((UB *)Rv0)[48];
        }
      }
      P_lgt_new(&Rv6, Rv0,16,NULL);
      if (Rv3) ((V *)Rv6)[4]=Rv2;
      Ra.sl[10]=3324; /* line # 3324 */
      P_insymbol();
    }
  }
  if (Rv0==NULL) {
    Ra.sl[10]=3331; /* line # 3331 */
    Rv6=PAS_COMILER_PRC_00000005(V_typ_std.v[15],0,0,0);
    if (F_mode==30||F_mode==42) P_type_check_parm(Rv6);
    else {
      if (F_mode==2) {
        if (((UB *)Rv6)[40]!=14) {
          Ra.sl[10]=3337; /* line # 3337 */
          P_src_error(Rd.s+721,61,3);
        }
      }
    }
    Rv0=((V *)Rv6)[3];
  }
  if (V_sy_sym.ub[0]!=85) P_src_error(Rd.s+721,51,2);
  Ra.sl[10]=3343; /* line # 3343 */
  P_lgt_new(&Rv7,((V *)Rv6)[3],14,NULL);
  Rv8=Rv7;
  ((V *)Rv8)[0]=Rv6;
  P_val_new(((V *)Rv8)+7,NULL);
  Ra.sl[10]=3348; /* line # 3348 */
  ((UB *)((V *)Rv8)[7])[48]=21;
  P_lgt_new(&Rv9,((V *)Rv6)[3],0, Rv7);
  ((UB *)Rv9)[41]=3;
  Rv10=0;
  for( Rf0=512;Rf0>0;Rf0-- ) {
    Ra.sl[Rv10+11]=-1;
    Rv10++;
  }
  Ra.sl[10]=3353; /* line # 3353 */
  Rv11=0;
  Rv12=1;
  Rv13=0;
  Rv14=0;
  Rv15=1;
  Rv16=V_sy_label_flag;
  while (1){
    Ra.sl[10]=3358; /* line # 3358 */
    if (Rv15) V_sy_sym.ub[0]=18;
    V_sy_label_flag=0;
    while (V_sy_sym.ub[0]==18||!Rv15){
      if (Rv15) P_insymbol();
      else {
        Ra.sl[10]=3363; /* line # 3363 */
        Rv15=1;
      }
      Rv17=PAS_COMILER_PRC_00000006(&Rv0);
      if (V_sy_sym.ub[0]==21) {
        Ra.sl[10]=3368; /* line # 3368 */
        P_insymbol();
        Rv18=PAS_COMILER_PRC_00000006(&Rv0);
        if (Rv18<Rv17) {
          Rv18=Rv17;
          P_src_error(Rd.s+721,62,2);
        }
      }
      else {
        Ra.sl[10]=3373; /* line # 3373 */
        Rv18=Rv17;
      }
      while (1){
        if (Rv12>Rv13) {
          Rv12=Rv17;
          Rv13=Rv17;
          Rv19=Rv17;
          Ra.sl[10]=3378; /* line # 3378 */
          Ra.sl[11]=Rv11;
        }
        else {
          if (Rv17>Rv13) Rv13=Rv17;
          else {
            Ra.sl[10]=3383; /* line # 3383 */
            if (Rv17<Rv12) Rv12=Rv17;
          }
          Rv20=Rv17-Rv19;
          if (Rv20<0) Rv20=(Rv20+511)+1;
          if (Rv20<0||Rv20>511) {
            Ra.sl[10]=3388; /* line # 3388 */
            P_src_error(Rd.s+721,63,3);
          }
          else {
            if (Ra.sl[Rv20+11]!=-1) {
              Ra.sl[10]=3393; /* line # 3393 */
              P_src_error(Rd.s+721,64,2);
            }
            else Ra.sl[Rv20+11]=Rv11;
          }
        }
        Ra.sl[10]=3398; /* line # 3398 */
        Rv17=Rv17+1;
        if (Rv17>Rv18)  break;
      }
    }
    if (V_sy_sym.ub[0]==22) P_insymbol();
    else P_src_error(Rd.s+721,31,2);
    V_sy_label_flag=Rv16;
    Ra.sl[10]=3404; /* line # 3404 */
    Rv21=PAS_COMILER_PRC_00000040(F_mode, F_ty,0);
    if (V_sy_sym.ub[0]==19) {
      V_sy_label_flag=0;
      P_insymbol();
      Ra.sl[10]=3409; /* line # 3409 */
      Rv15=0;
    }
    if (Rv21==NULL) P_lgt_new(&Rv21,NULL,16,NULL);
    ((V *)Rv6)[0]=Rv21;
    Rv6=Rv21;
    Ra.sl[10]=3414; /* line # 3414 */
    Rv11=Rv11+1;
    if (((V_sy_sym.ub[0]==86||V_sy_sym.ub[0]==73)||V_sy_sym.ub[0]==15)||V_sy_sym
    .ub[0]==89)  break;
  }
  V_sy_label_flag=Rv16;
  if (V_sy_sym.ub[0]==86) {
    Ra.sl[10]=3419; /* line # 3419 */
    P_insymbol();
    Rv6=PAS_COMILER_PRC_00000040(F_mode, F_ty,1);
  }
  else {
    Ra.sl[10]=3424; /* line # 3424 */
    P_lgt_new(&Rv6,NULL,16,NULL);
    if (F_mode==42) {
      P_ide_new_typ(23,((V *)Rv6)+3);
      Rv22=((V *)Rv6)[3];
      Ra.sl[10]=3430; /* line # 3430 */
      ((V *)Rv22)[12]=NULL;
      ((V *)Rv22)[13]=NULL;
      ((V *)Rv22)[14]=NULL;
      ((SL *)Rv22)[11]=Ra.sl[0];
    }
  }
  Ra.sl[10]=3437; /* line # 3437 */
  Rv21=((V *)Rv7)[0];
  ((V *)Rv6)[0]=Rv21;
  ((V *)Rv7)[0]=Rv6;
  if (F_mode!=42) P_insymbol();
  Ra.sl[10]=3442; /* line # 3442 */
  ((SL *)Rv9)[4]=Rv11;
  Rv23=Rv7;
  Rv24=((V *)Rv23)[7];
  ((SL *)Rv23)[4]=Rv12;
  ((SL *)Rv24)[6]=(Rv13-Rv12)+1;
  Ra.sl[10]=3447; /* line # 3447 */
  ((V *)Rv24)[7]=P_tab_new(((SL *)Rv24)[6]);
  Rv17=Rv12-Rv19;
  if (Rv17<0) Rv17=(Rv17+511)+1;
  Rv25=0;
  for( Rf0=(Rv13-Rv12)+1;Rf0>0;Rf0-- ) {
    Ra.sl[10]=3452; /* line # 3452 */
    ((SL *)((V *)Rv24)[7])[Rv25]=Ra.sl[Rv17+11];
    Rv17=Rv17+1;
    if (Rv17>511) Rv17=0;
    Rv25++;
  }
  Ra.sl[10]=3458; /* line # 3458 */
  V_sy_casedef=0;
  Ret=Rv9;
  PAS__curr_cntx=Ra.v[2];
  Lx[2]=Lx_Sv;
  return(Ret);
}


/* Procedure/Function : " set_alignment_spc "  */
void PAS_COMILER_PRC_00000041(SL *F_sz, SL *F_aln){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+742;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=3473; /* line # 3473 */
  if (Rs.sl[0]>0) {
    Ra.sl[6]=3478; /* line # 3478 */
    (*F_sz)=Rs.sl[0];
    Rv0=(*F_sz);
    Rs.sl[0]=-1;
    if (Rs.sl[1]<0) {
      (*F_aln)=1;
      while ((*F_aln)<Rv0)
      (*F_aln)=2*(*F_aln);
      Ra.sl[6]=3483; /* line # 3483 */
      (*F_aln)=(*F_aln)-1;
    }
  }
  if (Rs.sl[1]>=0) {
    (*F_aln)=Rs.sl[1];
    Rs.sl[1]=-1;
  }
  Ra.sl[6]=3488; /* line # 3488 */
  if (V_sy_sym.ub[0]==74) {
    P_insymbol();
    (*F_sz)=(PAS_COMILER_PRC_00000006(V_typ_std.v+2)+7)/8;
    Ra.sl[6]=3493; /* line # 3493 */
    if ((*F_sz)<1) (*F_sz)=1;
    Rv0=(*F_sz);
    if (V_sy_sym.ub[0]==18) {
      P_insymbol();
      Ra.sl[6]=3498; /* line # 3498 */
      Rv0=(PAS_COMILER_PRC_00000006(V_typ_std.v+2)+7)/8;
      if (Rv0>256) P_src_error(Rd.s+763,231,2);
    }
    if (Rv0<0||Rv0>256) Rv0=((SL *)V_typ_std.v[4])[11];
    if (Rv0<=1) (*F_aln)=0;
    else {
      Ra.sl[6]=3504; /* line # 3504 */
      (*F_aln)=1;
      while ((*F_aln)<Rv0)
      (*F_aln)=2*(*F_aln);
      (*F_aln)=(*F_aln)-1;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " conformant_def "  */
void PAS_COMILER_PRC_00000042(V *F_tr, SL *F_ndim){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  V Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+767;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=3525; /* line # 3525 */
  Rv0=NULL;
  Rv1=NULL;
  P_ide_new_typ(22, F_tr);
  Rv2=(*F_tr);
  if (V_sy_sym.ub[0]==0) P_ide_new(5,NULL,&Rv0);
  else {
    Ra.sl[6]=3530; /* line # 3530 */
    P_src_error(Rd.s+785,232,3);
  }
  P_insymbol();
  if (V_sy_sym.ub[0]==21) {
    P_insymbol();
    Ra.sl[6]=3535; /* line # 3535 */
    if (V_sy_sym.ub[0]==0) P_ide_new(5,NULL,&Rv1);
    else P_src_error(Rd.s+785,232,3);
    P_insymbol();
  }
  if (V_sy_sym.ub[0]==22) {
    Ra.sl[6]=3541; /* line # 3541 */
    P_insymbol();
    PAS_COMILER_PRC_00000039(((V *)Rv2),0,NULL,0,0);
    ((SL *)Rv2)[11]=((SL *)((V *)Rv2)[0])[11];
    memcpy(Rv2+48,((V *)Rv2)[0]+48,1);
    if (Rv0!=NULL) {
      Ra.sl[6]=3547; /* line # 3547 */
      ((V *)Rv0)[4]=((V *)Rv2)[0];
      ((UB *)Rv0)[94]=8;
      ((UW *)Rv0)[46]=32;
      if (Rv1==NULL) {
        Ra.sl[6]=3552; /* line # 3552 */
        ((V *)Rv2)[13]=P_lgt_new_econst(((V *)Rv2)[0],1);
        ((V *)Rv2)[14]=P_lgt_new_idref(Rv0,NULL);
        ((V *)Rv2)[12]=P_lgt_link(((V *)Rv2)[14]);
        ((V *)((V *)Rv2)[12])[3]=V_int_typ;
        (*F_ndim)=(*F_ndim)+1;
      }
      else {
        Ra.sl[6]=3560; /* line # 3560 */
        ((V *)Rv1)[4]=((V *)Rv2)[0];
        ((UB *)Rv1)[94]=8;
        ((UW *)Rv1)[46]=32;
        ((V *)Rv2)[13]=P_lgt_new_idref(Rv0,NULL);
        ((V *)Rv2)[14]=P_lgt_new_idref(Rv1,NULL);
        Ra.sl[6]=3565; /* line # 3565 */
        Rv3=P_lgt_link(((V *)Rv2)[14]);
        ((V *)Rv3)[0]=P_lgt_link(((V *)Rv2)[13]);
        Rv3=P_lgt_new_code(50, Rv3);
        ((V *)Rv3)[0]=P_lgt_new_econst(V_int_typ,1);
        ((V *)Rv2)[12]=P_lgt_new_code(49, Rv3);
        Ra.sl[6]=3570; /* line # 3570 */
        (*F_ndim)=(*F_ndim)+2;
      }
    }
  }
  else P_src_error(Rd.s+785,31,3);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " array_def "  */
void PAS_COMILER_PRC_00000043(V *F_art, UB F_bconf, SL *F_ndim){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  SL Rv2;
  register V Rv3;
  register V Rv4;
  V Rv5;
  SL Rv6;
  V Rv7;
  UB Rv8;
  register V Rv9;
  SL Rv10;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+789;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=3592; /* line # 3592 */
  P_insymbol();
  if (F_bconf) P_ide_new_typ(9, F_art);
  else P_ide_new_typ(8, F_art);
  Rv0=(*F_art);
  Ra.sl[6]=3597; /* line # 3597 */
  ((V *)Rv0)[15]=NULL;
  if (F_bconf) PAS_COMILER_PRC_00000042(((V *)Rv0)+15,F_ndim);
  else {
    Ra.sl[6]=3602; /* line # 3602 */
    PAS_COMILER_PRC_00000039(((V *)Rv0)+15,0,NULL,0,0);
    (*F_ndim)=(*F_ndim)+2;
  }
  Rv1=NULL;
  Rv2=1;
  if (((V *)Rv0)[15]!=NULL) {
    Ra.sl[6]=3607; /* line # 3607 */
    Rv3=((V *)Rv0)[15];
    switch (((UB *)Rv3)[92]) {
      case 0:
      case 1:
      case 2:if (((UB *)Rv3)[112]) Rv2=(((UL *)Rv3)[30]-((UL *)Rv3)[29])+1;
      else {
        Ra.sl[6]=3612; /* line # 3612 */
        Rv2=(((SL *)Rv3)[30]-((SL *)Rv3)[29])+1;
      }
      break;
      case 22:Rv1=P_lgt_link(((V *)Rv3)[12]);
      break;
      default:Ra.sl[6]=3617; /* line # 3617 */
      P_src_error(Rd.s+802,210,3);
      break;
    }
  }
  Ra.sl[6]=3622; /* line # 3622 */
  if (V_sy_sym.ub[0]==18) {
    PAS_COMILER_PRC_00000043(((V *)Rv0)+14,F_bconf, F_ndim);
    ((SL *)Rv0)[24]=(*F_ndim);
  }
  else {
    Ra.sl[6]=3629; /* line # 3629 */
    ((SL *)Rv0)[24]=(*F_ndim);
    if (V_sy_sym.ub[0]==17) P_insymbol();
    else P_src_error(Rd.s+802,26,2);
    if (V_sy_sym.ub[0]==85) P_insymbol();
    else P_src_error(Rd.s+802,51,2);
    Ra.sl[6]=3634; /* line # 3634 */
    PAS_COMILER_PRC_00000039(((V *)Rv0)+14,0,NULL,0,0);
  }
  if (((V *)Rv0)[14]!=NULL) {
    Ra.sl[6]=3641; /* line # 3641 */
    ((UB *)Rv0)[48]=((UB *)((V *)Rv0)[14])[48];
    Rv4=((V *)Rv0)[14];
    Rv5=NULL;
    Ra.sl[6]=3646; /* line # 3646 */
    Rv6=((SL *)Rv4)[11];
    Rv7=((V *)Rv4)[9];
    memcpy(Ra.s+28,Rv4+48,1);
    if (Rv6>0) Rv6=P_typ_alignement(Rv6, Rv4+48);
    if (Rv6>=0) Rv7=NULL;
    Ra.sl[6]=3652; /* line # 3652 */
    if (Rv7!=NULL) {
      if (((UB *)Rv7)[40]==14) Rv6=((SL *)((V *)Rv7)[7])[13];
      else P_lgt_copy_tree(Rv7, &Rv5);
    }
    if ((Rv5!=NULL&&((UB *)Rv0)[48]>0)&&((UB *)((V *)Rv0)[14])[92]!=8) {
      Ra.sl[6]=3658; /* line # 3658 */
      Rv8=1;
      if ((((UB *)Rv5)[40]==6&&((UB *)Rv5)[41]==49)&&((V *)Rv5)[1]!=NULL) {
        if (((V *)((V *)Rv5)[1])[0]!=NULL) {
          Ra.sl[6]=3663; /* line # 3663 */
          Rv9=((V *)((V *)Rv5)[1])[0];
          if (((UB *)Rv9)[40]==14&&((V *)Rv9)[7]!=NULL) {
            Rv10=((SL *)((V *)Rv9)[7])[13]+Ra.ub[28];
            P_val_free(((V *)Rv9)+7);
            Ra.sl[6]=3668; /* line # 3668 */
            P_val_new(((V *)Rv9)+7,V_int_typ);
            ((SL *)((V *)Rv9)[7])[13]=Rv10;
            Rv8=0;
          }
        }
      }
      if (Rv8) {
        Ra.sl[6]=3674; /* line # 3674 */
        ((V *)Rv5)[0]=P_lgt_new_econst(V_int_typ, Ra.ub[28]);
        Rv5=P_lgt_new_code(49, Rv5);
      }
      ((V *)Rv5)[0]=P_lgt_new_econst(V_int_typ, Ra.ub[28]);
      Rv5=P_lgt_new_code(13, Rv5);
    }
    Ra.sl[6]=3681; /* line # 3681 */
    ((V *)Rv0)[13]=Rv5;
    ((SL *)Rv0)[25]=Rv6;
    if (((UB *)((V *)Rv0)[14])[90]||((SL *)((V *)Rv0)[14])[10]>0) {
      Ra.sl[6]=3686; /* line # 3686 */
      ((UB *)Rv0)[90]=1;
    }
    ((SL *)Rv0)[11]=((SL *)Rv0)[25]*Rv2;
    if (Rv1==NULL&&((V *)Rv0)[13]==NULL) {
      Ra.sl[6]=3691; /* line # 3691 */
      ((V *)Rv0)[9]=NULL;
    }
    else {
      if (Rv1==NULL) {
        Ra.sl[6]=3696; /* line # 3696 */
        Rv1=P_lgt_new_econst(V_int_typ, Rv2);
        ((V *)Rv1)[0]=((V *)Rv0)[13];
        ((V *)Rv0)[9]=P_lgt_new_code(51, Rv1);
      }
      else {
        Ra.sl[6]=3701; /* line # 3701 */
        if (((V *)Rv0)[13]==NULL) {
          if (((SL *)Rv0)[25]==1) ((V *)Rv0)[9]=Rv1;
          else {
            Ra.sl[6]=3706; /* line # 3706 */
            ((V *)Rv1)[0]=P_lgt_new_econst(V_int_typ,((SL *)Rv0)[25]);
            ((V *)Rv0)[9]=P_lgt_new_code(51, Rv1);
          }
        }
        else {
          Ra.sl[6]=3711; /* line # 3711 */
          ((V *)Rv1)[0]=((V *)Rv0)[13];
          ((V *)Rv0)[9]=P_lgt_new_code(51, Rv1);
        }
      }
      ((SL *)Rv0)[11]=-1;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " type_spc "  */
void PAS_COMILER_PRC_00000039(V *F_it, SL F_descr_sz, V F_parm, UB F_bdeforg, UB
F_buseorg){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  V Rv1;
  V Rv2;
  register V Rv3;
  V Rv4;
  V Rv5;
  V Rv6;
  V Rv7;
  register V Rv8;
  V Rv9;
  register V Rv10;
  SL Rv11;
  SL Rv12;
  SL Rv13;
  register V Rv14;
  register V Rv15;
  register V Rv16;
  register V Rv17;
  register V Rv18;
  register V Rv19;
  register V Rv20;
  register V Rv21;
  register V Rv22;
  register V Rv23;
  SL Rv24;
  SL Rv25;
  register V Rv26;
  SL Rv27;
  register V Rv28;
  register V Rv29;
  register V Rv30;
  register V Rv31;
  register V Rv32;
  V Rv33;
  register V Rv34;
  register V Rv35;
  V Rv36;
  V Rv37;
  register V Rv38;
  register UB Rv39;
  register V Rv40;
  SL Rv41;
  V Rv42;
  register V Rv43;
  register V Rv44;
  register V Rv45;
  register V Rv46;
  register V Rv47;
  register V Rv48;
  register V Rv49;
  register V Rv50;
  register V Rv51;
  register V Rv52;
  register V Rv53;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+806;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=3742; /* line # 3742 */
  Rv0=V_sy_descr_size;
  V_sy_descr_size=0;
  V_sy_type_gfirst=NULL;
  Ra.sl[6]=3747; /* line # 3747 */
  Rv1=NULL;
  if (V_sy_sym.ub[0]==38) P_insymbol();
  switch (V_sy_sym.ub[0]) {
    case 30:Ra.sl[6]=3752; /* line # 3752 */
    Rv0=0;
    P_insymbol();
    if (V_sy_sym.ub[0]!=57) P_src_error(Rd.s+818,182,2);
    else P_insymbol();
    Ra.sl[6]=3757; /* line # 3757 */
    P_ide_new_typ(27, &Rv1);
    ((V *)Rv1)[9]=PAS_COMILER_PRC_00000004(30,NULL);
    break;
    case 59:Ra.sl[6]=3763; /* line # 3763 */
    P_insymbol();
    Rv2=P_ide_search(2);
    P_insymbol();
    if (Rv2!=V_ide_udptr.v[1]) {
      Rv19=Rv2;
      Ra.sl[6]=3769; /* line # 3769 */
      P_ide_new_typ(((UB *)((V *)Rv2)[4])[92],&Rv1);
      V_sy_type_gfirst=((V *)Rv19)[10];
      Rv20=Rv1;
      ((V *)Rv20)[0]=((V *)Rv19)[4];
      Ra.sl[6]=3774; /* line # 3774 */
      ((V *)Rv20)[4]=((V *)((V *)Rv20)[0])[4];
      ((SL *)Rv20)[11]=((SL *)((V *)Rv20)[0])[11];
      ((SL *)Rv20)[10]=((SL *)((V *)Rv20)[0])[10];
      memcpy(Rv20+48,((V *)Rv20)[0]+48,1);
      ((V *)Rv20)[10]=((V *)((V *)Rv20)[0])[10];
      Ra.sl[6]=3779; /* line # 3779 */
      ((UB *)Rv20)[90]=((UB *)((V *)Rv20)[0])[90];
      if (((V *)Rv20)[9]!=NULL) ((V *)Rv20)[9]=P_lgt_link(((V *)((V *)Rv20)[0])[
9]);
      switch (((UB *)Rv20)[92]) {
        case 0:
        case 1:
        case 2:Ra.sl[6]=3785; /* line # 3785 */
        ((SL *)Rv20)[29]=((SL *)((V *)Rv20)[0])[29];
        ((SL *)Rv20)[30]=((SL *)((V *)Rv20)[0])[30];
        ((UB *)Rv20)[112]=((UB *)((V *)Rv20)[0])[112];
        ((V *)Rv20)[12]=((V *)((V *)Rv20)[0])[12];
        break;
        case 22:Ra.sl[6]=3793; /* line # 3793 */
        ((V *)Rv20)[12]=P_lgt_link(((V *)((V *)Rv20)[0])[12]);
        ((V *)Rv20)[14]=P_lgt_link(((V *)((V *)Rv20)[0])[14]);
        ((V *)Rv20)[13]=P_lgt_link(((V *)((V *)Rv20)[0])[13]);
        break;
        case 3:
        case 4:break;
        case 5:
        case 7:
        case 24:
        case 26:Ra.sl[6]=3802; /* line # 3802 */
        ((V *)Rv20)[12]=((V *)((V *)Rv20)[0])[12];
        break;
        case 11:
        case 12:((V *)Rv20)[13]=((V *)((V *)Rv20)[0])[13];
        break;
        case 8:Ra.sl[6]=3809; /* line # 3809 */
        ((SL *)Rv20)[25]=((SL *)((V *)Rv20)[0])[25];
        if (((V *)((V *)Rv20)[0])[13]!=NULL) ((V *)Rv20)[13]=P_lgt_link(((V *)((
        V *)Rv20)[0])[13]);
        else {
          Ra.sl[6]=3814; /* line # 3814 */
          ((V *)Rv20)[13]=NULL;
        }
        ((V *)Rv20)[14]=((V *)((V *)Rv20)[0])[14];
        ((V *)Rv20)[15]=((V *)((V *)Rv20)[0])[15];
        break;
        case 10:Ra.sl[6]=3821; /* line # 3821 */
        ((V *)Rv20)[12]=((V *)((V *)Rv20)[0])[12];
        ((V *)Rv20)[13]=((V *)((V *)Rv20)[0])[13];
        if (((V *)((V *)Rv20)[0])[14]!=NULL) ((V *)Rv20)[14]=P_lgt_link(((V *)((
        V *)Rv20)[0])[14]);
        else {
          Ra.sl[6]=3826; /* line # 3826 */
          ((V *)Rv20)[14]=NULL;
        }
        break;
        case 14:
        case 15:
        case 19:
        case 21:Ra.sl[6]=3834; /* line # 3834 */
        Rv11=((SL *)Rv20)[11];
        Rv12=((UB *)Rv20)[48];
        PAS_COMILER_PRC_00000041(&Rv11, &Rv12);
        if (Rv11<((SL *)Rv20)[11]) P_src_error(Rd.s+818,214,2);
        else((SL *)Rv20)[11]=Rv11;
        Ra.sl[6]=3839; /* line # 3839 */
        if (Rv12>=0) ((UB *)Rv20)[48]=Rv12;
        break;
        default:Ra.sl[6]=3844; /* line # 3844 */
        P_src_error(Rd.s+818,206,3);
        break;
      }
    }
    break;
    case 44:Ra.sl[6]=3852; /* line # 3852 */
    if (F_parm!=NULL) P_src_error(Rd.s+818,207,2);
    P_insymbol();
    if (V_sy_sym.ub[0]==39) {
      if (F_bdeforg) {
        Ra.sl[6]=3857; /* line # 3857 */
        P_insymbol();
        P_ide_new_typ(24, &Rv1);
        Rv21=Rv1;
        ((V *)Rv21)[12]=NULL;
        Ra.sl[6]=3862; /* line # 3862 */
        ((SL *)Rv21)[11]=V_fptr_size;
        memcpy(Rv21+48,V_typ_std.v[5]+48,1);
        ((V *)Rv21)[9]=NULL;
      }
      else {
        Ra.sl[6]=3868; /* line # 3868 */
        P_src_error(Rd.s+818,208,3);
      }
    }
    else {
      P_ide_new_typ(26, &Rv1);
      Rv22=Rv1;
      Ra.sl[6]=3874; /* line # 3874 */
      ((V *)Rv22)[12]=NULL;
      ((V *)Rv22)[9]=NULL;
      memcpy(Rv22+48,V_typ_std.v[2]+48,1);
      ((SL *)Rv22)[11]=1;
    }
    Ra.sl[6]=3881; /* line # 3881 */
    Rv23=Rv1;
    Rv11=((SL *)Rv23)[11];
    Rv12=((UB *)Rv23)[48];
    Ra.sl[6]=3886; /* line # 3886 */
    PAS_COMILER_PRC_00000041(&Rv11, &Rv12);
    if (V_sy_init_mod&&V_sy_sym.ub[0]==22) P_data_format_set(Rv1);
    if (Rv11<((SL *)Rv23)[11]) P_src_error(Rd.s+818,214,2);
    else((SL *)Rv23)[11]=Rv11;
    if (Rv12>=0) ((UB *)Rv23)[48]=Rv12;
    break;
    case 41:Ra.sl[6]=3896; /* line # 3896 */
    P_insymbol();
    if (V_sy_sym.ub[0]!=16) P_src_error(Rd.s+818,25,2);
    Rv24=0;
    PAS_COMILER_PRC_00000043(&Rv1,0, &Rv24);
    Ra.sl[6]=3901; /* line # 3901 */
    if (V_ima_typ==NULL) V_ima_typ=Rv1;
    break;
    case 42:Ra.sl[6]=3906; /* line # 3906 */
    Rv25=V_curr_disp;
    P_ide_new_typ(10, &Rv1);
    Rv26=Rv1;
    ((SL *)Rv26)[10]=F_descr_sz;
    Ra.sl[6]=3911; /* line # 3911 */
    ((SL *)Rv26)[11]=((SL *)Rv26)[10];
    ((V *)Rv26)[12]=NULL;
    ((V *)Rv26)[13]=NULL;
    ((V *)Rv26)[14]=NULL;
    Rv2=NULL;
    Ra.sl[6]=3916; /* line # 3916 */
    P_insymbol();
    P_new_disp_level(NULL,1);
    Lx[5].ub[0]=0;
    PAS_COMILER_PRC_00000038(6,((SL *)Rv1)+11,&Rv27, Rv1);
    Rv28=Rv1;
    Ra.sl[6]=3922; /* line # 3922 */
    ((UB *)Rv28)[90]=Lx[5].ub[0];
    ((V *)Rv28)[12]=V_lex_ident_tree.v[V_curr_disp*8+1];
    if (((V *)Rv28)[14]==NULL) ((V *)Rv28)[13]=V_lex_ident_tree.v[V_curr_disp*8+
4];
    Ra.sl[6]=3927; /* line # 3927 */
    V_curr_disp=V_curr_disp -1;
    if (V_sy_sym.ub[0]==73) P_insymbol();
    else P_src_error(Rd.s+818,54,2);
    if (V_typ_std.v[10]==NULL) {
      Ra.sl[6]=3933; /* line # 3933 */
      V_typ_std.v[10]=Rv1;
      Rv29=Rv1;
      V_stri_descrsz=((SL *)Rv29)[10];
      V_stri_lengthsz=((SL *)((V *)((V *)Rv29)[12])[4])[11];
      Ra.sl[6]=3938; /* line # 3938 */
      V_stri_stroffset=((SL *)((V *)((V *)Rv29)[12])[3])[15];
    }
    break;
    case 40:Ra.sl[6]=3945; /* line # 3945 */
    P_insymbol();
    if (V_sy_sym.ub[0]==85) P_insymbol();
    else P_src_error(Rd.s+818,51,2);
    P_ide_new_typ(7, &Rv1);
    Rv30=Rv1;
    Ra.sl[6]=3950; /* line # 3950 */
    memcpy(Rv30+48,V_typ_std.v[16]+48,1);
    ((SL *)Rv30)[11]=((SL *)V_typ_std.v[16])[11];
    ((V *)Rv30)[10]=((V *)V_typ_std.v[16])[10];
    ((V *)Rv30)[0]=V_typ_std.v[16];
    Ra.sl[6]=3955; /* line # 3955 */
    PAS_COMILER_PRC_00000039(((V *)Rv30)+12,0,NULL,0,0);
    if (((UB *)((V *)Rv30)[12])[90]||((SL *)((V *)Rv30)[12])[10]>0) ((UB *)Rv30)
    [90]=1;
    Ra.sl[6]=3960; /* line # 3960 */
    if (((SL *)((V *)Rv30)[12])[11]<=0) P_src_error(Rd.s+818,149,3);
    if (V_typ_std.v[7]==NULL) V_typ_std.v[7]=Rv1;
    break;
    case 24:
    case 39:Ra.sl[6]=3970; /* line # 3970 */
    P_insymbol();
    if (V_sy_sym.ub[0]==77||V_sy_sym.ub[0]==78) Rv1=PAS_COMILER_PRC_00000002(V_sy_sym
    .ub[0]==78);
    else {
      Ra.sl[6]=3975; /* line # 3975 */
      P_ide_new_typ(5, &Rv1);
      Rv31=Rv1;
      memcpy(Rv31+48,V_typ_std.v[13]+48,1);
      ((SL *)Rv31)[11]=V_fptr_size;
      Ra.sl[6]=3980; /* line # 3980 */
      ((V *)Rv31)[0]=V_typ_std.v[13];
      V_err_prt=0;
      Rv2=P_ide_search(2);
      V_err_prt=1;
      if (Rv2==NULL) {
        Ra.sl[6]=3986; /* line # 3986 */
        P_ide_new(1, Rv1, &Rv2);
        ((V *)Rv2)[8]=Lx[5].v[1];
        Lx[5].v[1]=Rv2;
      }
      else((V *)Rv31)[12]=((V *)Rv2)[4];
      Ra.sl[6]=3991; /* line # 3991 */
      P_insymbol();
      V_sy_type_gfirst=P_new_oper(0, Rv1, V_typ_std.v[5],0,128,NULL,0,0);
    }
    break;
    case 14:Ra.sl[6]=3999; /* line # 3999 */
    if (V_ima_typ!=NULL) {
      if (((V *)V_ima_typ)[4]!=NULL) {
        P_insymbol();
        if (((SL *)V_typ_std.v[1])[30]==0) {
          Ra.sl[6]=4004; /* line # 4004 */
          Rv1=V_typ_std.v[1];
        }
        else P_ide_new_typ(1, &Rv1);
        Rv32=Rv1;
        Ra.sl[6]=4009; /* line # 4009 */
        ((SL *)Rv32)[11]=((SL *)V_typ_std.v[0])[11];
        ((SL *)Rv32)[29]=0;
        ((SL *)Rv32)[30]=-1;
        ((V *)Rv32)[0]=NULL;
        ((UB *)Rv32)[112]=1;
        memcpy(Rv32+48,V_typ_std.v[0]+48,1);
        Ra.sl[6]=4014; /* line # 4014 */
        Rv25=0;
        Rv33=NULL;
        Rv11=0;
        while (V_sy_sym.ub[0]==0){
          Ra.sl[6]=4019; /* line # 4019 */
          if (V_sy_ident.ub[0]>Rv25) Rv25=V_sy_ident.ub[0];
          P_ide_new(4, Rv1, &Rv2);
          if (((V *)Rv32)[12]==NULL) ((V *)Rv32)[12]=Rv2;
          ((SL *)Rv32)[30]=((SL *)Rv32)[30]+1;
          Ra.sl[6]=4024; /* line # 4024 */
          Rv34=Rv2;
          P_val_new(((V *)Rv34)+8,Rv1);
          Rv35=((V *)Rv34)[8];
          Ra.sl[6]=4030; /* line # 4030 */
          ((UB *)Rv35)[48]=1;
          ((SL *)Rv35)[13]=((SL *)Rv32)[30];
          Rv36=NULL;
          Ra.sl[6]=4035; /* line # 4035 */
          P_val_new(&Rv36,NULL);
          if (Rv33==NULL) Rv33=Rv36;
          else((V *)Rv37)[0]=Rv36;
          Rv37=Rv36;
          Ra.sl[6]=4040; /* line # 4040 */
          Rv38=Rv36;
          ((UB *)Rv38)[48]=29;
          ((SL *)Rv38)[6]=0;
          Rv39=V_sy_ident.ub[0]+1;
          ((V *)Rv38)[7]=PAS__NEW((SL)Rv39+2);
          ((UB *)((V *)Rv38)[7])[0]=Rv39;
          Ra.sl[6]=4045; /* line # 4045 */
          ((V *)Rv38)[4]=((V *)V_ima_typ)[14];
          Rv40=((V *)Rv38)[7];
          ((UB *)Rv40)[1]=V_sy_ident.ub[0]+1;
          ((C *)Rv40)[2]=V_sy_ident.c[0];
          Ra.sl[6]=4050; /* line # 4050 */
          Rv41=1;
          for( Rf0=V_sy_ident.ub[0];Rf0>0;Rf0-- ) {
            ((C *)Rv40)[(Rv41+1)+1]=V_sy_ident.c[Rv41];
            Rv41++;
          }
          Ra.sl[6]=4055; /* line # 4055 */
          P_insymbol();
          if (V_sy_sym.ub[0]==18) P_insymbol();
          else {
            if (V_sy_sym.ub[0]!=15) P_src_error(Rd.s+818,23,2);
          }
          if (V_sy_sym.ub[0]==18) P_src_error(Rd.s+818,27,2);
        }
        Ra.sl[6]=4061; /* line # 4061 */
        P_insymbol();
        Rv6=P_lgt_new_econst(V_typ_std.v[2],Rv25);
        Rv7=P_lgt_new_econst(V_typ_std.v[2],((SL *)Rv32)[30]);
        ((V *)Rv7)[0]=Rv6;
        Ra.sl[6]=4066; /* line # 4066 */
        Rv42=P_type_parm_set(((V *)V_ima_typ)[3],Rv7);
        Rv36=Rv33;
        while (Rv36!=NULL){
          Rv43=Rv36;
          Ra.sl[6]=4072; /* line # 4072 */
          ((SL *)Rv43)[6]=Rv25+1;
          Rv36=((V *)Rv43)[0];
        }
        Ra.sl[6]=4077; /* line # 4077 */
        Rv44=((V *)V_ima_typ)[4];
        if (((V *)Rv44)[3]!=NULL) {
          P_val_new(&Rv36,((V *)((V *)Rv44)[3])[4]);
          Rv45=Rv36;
          Rv46=((V *)Rv44)[3];
          Ra.sl[6]=4083; /* line # 4083 */
          ((SL *)Rv45)[13]=Rv25;
          if (((V *)Rv46)[4]!=NULL) ((SL *)Rv45)[6]=((SL *)((V *)Rv46)[4])[11];
          ((V *)Rv45)[0]=Rv33;
          Rv33=Rv36;
          Ra.sl[6]=4088; /* line # 4088 */
          Rv36=NULL;
          P_val_new(&Rv36,((V *)Rv44)[4]);
          Rv47=Rv36;
          ((SL *)Rv47)[13]=((SL *)Rv32)[30];
          if (((V *)Rv44)[4]!=NULL) ((SL *)Rv47)[6]=((SL *)((V *)Rv44)[4])[11];
          Ra.sl[6]=4093; /* line # 4093 */
          ((V *)Rv47)[0]=Rv33;
          Rv33=Rv36;
        }
        P_lgt_new(((V *)Rv32)+13,Rv42,14,NULL);
        Ra.sl[6]=4098; /* line # 4098 */
        P_val_new(((V *)((V *)Rv32)[13])+7,Rv42);
        Rv48=((V *)Rv32)[13];
        Rv49=((V *)Rv48)[7];
        ((SL *)Rv49)[6]=((SL *)Rv42)[11];
        ((V *)Rv49)[7]=Rv33;
        Ra.sl[6]=4104; /* line # 4104 */
        if (((SL *)Rv32)[30]>255) {
          if (((SL *)Rv32)[30]>65535) ((SL *)Rv32)[11]=4;
          else((SL *)Rv32)[11]=2;
        }
        Ra.sl[6]=4111; /* line # 4111 */
        Rv11=((SL *)Rv32)[11];
        Rv12=Rv11-1;
        PAS_COMILER_PRC_00000041(&Rv11, &Rv12);
        if (V_sy_init_mod&&V_sy_sym.ub[0]==22) P_data_format_set(Rv1);
        if (Rv11<((SL *)Rv32)[11]) P_src_error(Rd.s+818,214,2);
        else {
          Ra.sl[6]=4116; /* line # 4116 */
          ((SL *)Rv32)[11]=Rv11;
        }
        if (Rv12>=0) ((UB *)Rv32)[48]=Rv12;
        V_sy_type_gfirst=P_new_oper(0, Rv1, V_typ_std.v[15],0,0,NULL,0,0);
      }
    }
    break;
    case 43:Ra.sl[6]=4125; /* line # 4125 */
    P_insymbol();
    if (V_sy_sym.ub[0]==85) P_insymbol();
    else P_src_error(Rd.s+818,51,2);
    PAS_COMILER_PRC_00000039(&Rv42,0,NULL,0,0);
    if (((UB *)Rv42)[92]>2) {
      Ra.sl[6]=4130; /* line # 4130 */
      P_src_error(Rd.s+818,215,3);
      Rv42=V_typ_std.v[1];
    }
    Rv13=((SL *)Rv42)[30]+1;
    Ra.sl[6]=4135; /* line # 4135 */
    if (Rv13>V_dst_seta) Rv13=V_dst_seta;
    Rv25=(Rv13+7)/8;
    if (Rv25>2) Rv25=((Rv25+3)/4)*4;
    Ra.sl[6]=4142; /* line # 4142 */
    if (Rv13>V_dst_setw) {
      P_ide_new_typ(12, &Rv1);
      Rv12=((UB *)V_typ_std.v[18])[48];
    }
    else {
      Ra.sl[6]=4149; /* line # 4149 */
      P_ide_new_typ(11, &Rv1);
      Rv11=1;
      switch (Rv25) {
        case 1:Rv12=0;
        break;
        case 2:Rv12=1;
        break;
        case 3:
        case 4:Ra.sl[6]=4154; /* line # 4154 */
        Rv12=3;
        break;
        default:Rv12=((UB *)V_typ_std.v[17])[48];
        break;
      }
    }
    Ra.sl[6]=4159; /* line # 4159 */
    Rv50=Rv1;
    ((SL *)Rv50)[24]=Rv13;
    ((V *)Rv50)[13]=Rv42;
    ((SL *)Rv50)[11]=Rv25;
    Ra.sl[6]=4164; /* line # 4164 */
    Rv11=Rv25;
    PAS_COMILER_PRC_00000041(&Rv11, &Rv12);
    if (Rv25>Rv11) {
      Ra.sl[6]=4169; /* line # 4169 */
      P_src_error(Rd.s+818,214,1);
      Rv11=Rv25;
    }
    ((SL *)Rv50)[11]=Rv11;
    Ra.sl[6]=4174; /* line # 4174 */
    if (Rv12>=0) ((UB *)Rv50)[48]=Rv12;
    if (Rv42!=NULL) {
      Rv51=Rv42;
      if (((UB *)Rv51)[92]==2) {
        Ra.sl[6]=4179; /* line # 4179 */
        Rv52=V_usi_tab;
        P_lgt_new(((V *)Rv51)+13,((V *)Rv52)[4],14,NULL);
        P_val_copy(((V *)Rv52)+8,((V *)((V *)Rv51)[13])+7,0);
      }
      else {
        Ra.sl[6]=4184; /* line # 4184 */
        if (((UB *)Rv51)[92]==0) {
          Rv53=V_csi_tab;
          P_lgt_new(((V *)Rv51)+13,((V *)Rv53)[4],14,NULL);
          P_val_copy(((V *)Rv53)+8,((V *)((V *)Rv51)[13])+7,0);
        }
      }
    }
    break;
    case 45:Ra.sl[6]=4195; /* line # 4195 */
    P_src_error(Rd.s+818,219,2);
    Rv1=NULL;
    break;
    case 57:Ra.sl[6]=4201; /* line # 4201 */
    Rv6=PAS_COMILER_PRC_00000004(2,NULL);
    Rv1=((V *)Rv6)[3];
    P_lgt_free(&Rv6);
    break;
    default:Ra.sl[6]=4207; /* line # 4207 */
    Rv1=NULL;
    if (V_sy_sym.ub[0]==0) {
      Rv2=P_ide_search(534);
      Rv1=((V *)Rv2)[4];
      Ra.sl[6]=4212; /* line # 4212 */
      if (Rv2!=V_ide_udptr.v[1]) {
        if (((UB *)Rv2)[56]==1) {
          Rv1=((V *)Rv2)[4];
          Ra.sl[6]=4217; /* line # 4217 */
          P_insymbol();
          V_sy_type_gfirst=((V *)Rv2)[10];
          if (V_sy_sym.ub[0]==14) {
            Ra.sl[6]=4222; /* line # 4222 */
            Rv3=Rv2;
            if (((V *)((V *)Rv3)[4])[4]==NULL) {
              P_src_error(Rd.s+818,206,2);
              P_skip_symbol(15,0,0);
            }
            else {
              Ra.sl[6]=4230; /* line # 4230 */
              Rv4=NULL;
              Rv5=((V *)((V *)Rv3)[4])[4];
              V_sy_sym.ub[0]=18;
              while (Rv5!=NULL){
                Ra.sl[6]=4235; /* line # 4235 */
                if (V_sy_sym.ub[0]==18) P_insymbol();
                if (V_sy_sym.ub[0]==18||V_sy_sym.ub[0]==15) {
                  if (((V *)Rv5)[11]!=NULL) {
                    P_lgt_new(&Rv6,((V *)Rv5)[4],14,NULL);
                    Ra.sl[6]=4240; /* line # 4240 */
                    ((V *)Rv6)[7]=((V *)Rv5)[11];
                    P_val_new(((V *)Rv5)+11,((V *)Rv5)[4]);
                  }
                  else P_src_error_s(Rd.s+818,228,3,((V *)Rv5)[0],NULL);
                }
                else {
                  Ra.sl[6]=4245; /* line # 4245 */
                  Rv6=PAS_COMILER_PRC_00000005(((V *)Rv5)[4],0,0,0);
                }
                if (Rv4==NULL) Rv4=Rv6;
                else((V *)Rv7)[0]=Rv6;
                Rv7=Rv6;
                Ra.sl[6]=4250; /* line # 4250 */
                Rv5=((V *)Rv5)[3];
              }
              if (V_sy_sym.ub[0]==15) P_insymbol();
              else P_src_error(Rd.s+818,23,2);
              Rv1=P_type_parm_set(Rv2, Rv4);
            }
          }
          else {
            Ra.sl[6]=4258; /* line # 4258 */
            Rv8=Rv2;
            if (((UB *)((V *)Rv8)[4])[92]==24) {
              if (V_sy_sym.ub[0]==85) {
                Ra.sl[6]=4264; /* line # 4264 */
                P_insymbol();
                Rv9=P_ide_search(2);
                P_insymbol();
                if (Rv9!=V_ide_udptr.v[1]) {
                  Ra.sl[6]=4269; /* line # 4269 */
                  P_ide_new_typ(24, &Rv1);
                  Rv10=Rv1;
                  ((V *)Rv10)[0]=((V *)Rv8)[4];
                  ((V *)Rv10)[12]=((V *)Rv9)[4];
                  Ra.sl[6]=4274; /* line # 4274 */
                  ((V *)Rv10)[4]=((V *)((V *)Rv10)[12])[4];
                  ((SL *)Rv10)[10]=0;
                  V_sy_type_gfirst=((V *)Rv8)[10];
                  ((V *)Rv10)[9]=NULL;
                  Ra.sl[6]=4279; /* line # 4279 */
                  ((SL *)Rv10)[11]=((SL *)((V *)Rv8)[4])[11];
                  ((UB *)Rv10)[90]=((UB *)((V *)Rv8)[4])[90];
                }
              }
              else Ra.sl[6]=4288; /* line # 4288 */
            }
            ((UB *)Rv1)[90]=((UB *)((V *)Rv8)[4])[90]||((SL *)((V *)Rv8)[4])[10]
            >0;
          }
        }
        else Rv1=NULL;
      }
    }
    Ra.sl[6]=4295; /* line # 4295 */
    if (Rv1==NULL) {
      Rv6=PAS_COMILER_PRC_00000005(V_typ_std.v[15],0,0,1);
      if (V_sy_sym.ub[0]==21) P_insymbol();
      else P_src_error(Rd.s+818,28,2);
      Ra.sl[6]=4300; /* line # 4300 */
      Rv7=PAS_COMILER_PRC_00000005(((V *)Rv6)[3],0,0,1);
      Rv11=((SL *)((V *)Rv6)[3])[11];
      Rv12=((UB *)((V *)Rv6)[3])[48];
      PAS_COMILER_PRC_00000041(&Rv11, &Rv12);
      if (Rv11<4) Rv13=PAS__IIPOWER(2,8*Rv11);
      else Rv13=2147483647;
      Ra.sl[6]=4305; /* line # 4305 */
      Rv14=Rv6;
      if (((UB *)Rv14)[40]==14&&((UB *)Rv7)[40]==14) {
        P_ide_new_typ_range(((SL *)((V *)Rv14)[7])[13],((SL *)((V *)Rv7)[7])[13]
        ,((V *)Rv14)[3],&Rv1);
        Ra.sl[6]=4311; /* line # 4311 */
        if (V_sy_init_mod&&V_sy_sym.ub[0]==22) P_data_format_set(Rv1);
        P_lgt_free(&Rv6);
        P_lgt_free(&Rv7);
        Rv15=Rv1;
        ((UB *)Rv15)[112]=((SL *)Rv15)[29]>=0;
        Ra.sl[6]=4316; /* line # 4316 */
        if (V_sy_fix_range_ctl) {
          if (((UB *)Rv15)[112]) {
            if (((UL *)Rv15)[29]>((UL *)Rv15)[30]) {
              Ra.sl[6]=4322; /* line # 4322 */
              ((UL *)Rv15)[30]=((UL *)Rv15)[29];
              P_src_error(Rd.s+818,211,2);
            }
          }
          else {
            Ra.sl[6]=4327; /* line # 4327 */
            if (((SL *)Rv15)[29]>((SL *)Rv15)[30]) {
              ((SL *)Rv15)[30]=((SL *)Rv15)[29];
              P_src_error(Rd.s+818,211,2);
            }
          }
          Ra.sl[6]=4332; /* line # 4332 */
          if (((UB *)Rv15)[112]) {
            if (Rv11<4) {
              if (((UL *)Rv15)[30]>=Rv13) {
                Ra.sl[6]=4337; /* line # 4337 */
                Rv11=4;
                P_src_error(Rd.s+818,212,2);
                Rv12=0;
              }
            }
          }
          else {
            Ra.sl[6]=4343; /* line # 4343 */
            if (Rv13!=2147483647) Rv13=Rv13/2;
            if (((SL *)Rv15)[30]>=Rv13||((SL *)Rv15)[29]< -Rv13) {
              Rv11=4;
              P_src_error(Rd.s+818,213,2);
              Rv12=0;
            }
          }
        }
      }
      else {
        Ra.sl[6]=4355; /* line # 4355 */
        P_ide_new_typ(22, &Rv1);
        Rv16=Rv1;
        ((V *)Rv16)[0]=((V *)Rv14)[3];
        if (V_sy_fix_range_ctl) {
          Ra.sl[6]=4361; /* line # 4361 */
          P_type_check_parm(Rv6);
          P_type_check_parm(Rv7);
        }
        if (((UB *)Rv7)[40]!=14) {
          Ra.sl[6]=4366; /* line # 4366 */
          ((V *)Rv16)[14]=P_lgt_new_code(0, Rv7);
        }
        else((V *)Rv16)[14]=Rv7;
        Ra.sl[6]=4371; /* line # 4371 */
        ((V *)((V *)Rv16)[14])[3]=Rv1;
        if (((UB *)Rv6)[40]==14) {
          Rv17=Rv6;
          ((V *)Rv16)[13]=Rv6;
          Ra.sl[6]=4376; /* line # 4376 */
          ((V *)Rv17)[3]=Rv1;
          if (((SL *)((V *)Rv17)[7])[13]==1) ((V *)Rv16)[12]=P_lgt_new_code(0, Rv7);
          else {
            Ra.sl[6]=4383; /* line # 4383 */
            ((V *)((V *)Rv16)[14])[0]=P_lgt_new_econst(V_typ_std.v[2],((SL *)((V
             *)Rv17)[7])[13]-1);
            ((V *)Rv16)[12]=P_lgt_new_code(50,((V *)Rv16)[14]);
          }
        }
        else {
          Ra.sl[6]=4392; /* line # 4392 */
          ((V *)Rv16)[13]=P_lgt_new_code(0, Rv6);
          ((V *)((V *)Rv16)[13])[3]=Rv1;
          if (((UB *)Rv7)[40]==14) {
            Ra.sl[6]=4398; /* line # 4398 */
            Rv13=((SL *)((V *)Rv7)[7])[13]+1;
            if (Rv13==0) ((V *)Rv16)[12]=P_lgt_new_code(46,((V *)Rv16)[14]);
            else {
              Ra.sl[6]=4404; /* line # 4404 */
              Rv6=P_lgt_new_econst(V_typ_std.v[2],Rv13);
              ((V *)Rv6)[0]=((V *)Rv16)[13];
              ((V *)Rv16)[12]=P_lgt_new_code(50, Rv6);
            }
          }
          else {
            Ra.sl[6]=4411; /* line # 4411 */
            ((V *)((V *)Rv16)[14])[0]=((V *)Rv16)[13];
            Rv6=P_lgt_new_code(50,((V *)Rv16)[14]);
            ((V *)Rv16)[12]=P_lgt_new_code(43, Rv6);
          }
        }
      }
      Ra.sl[6]=4420; /* line # 4420 */
      Rv18=Rv1;
      ((SL *)Rv18)[11]=Rv11;
      if (Rv12>=0) ((UB *)Rv18)[48]=Rv12;
    }
    break;
  }
  Ra.sl[6]=4429; /* line # 4429 */
  (*F_it)=Rv1;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " set_decl_attribute "  */
void PAS_COMILER_PRC_00000044(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+822;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=4443; /* line # 4443 */
  P_insymbol();
  switch (V_sy_sym.ub[0]) {
    case 87:Lx[5].ub[16]=2;
    P_insymbol();
    break;
    case 81:
    case 82:
    case 83:Ra.sl[6]=4450; /* line # 4450 */
    if (V_sy_sym.ub[0]==82) Lx[5].ub[16]=3;
    else {
      Lx[5].ub[16]=4;
      if (V_sy_sym.ub[0]==83) {
        Ra.sl[6]=4455; /* line # 4455 */
        if (V_sy_init_mod) Lx[5].ub[16]=5;
        else P_src_error(Rd.s+844,992,2);
      }
    }
    P_insymbol();
    Lx[5].v[3]=NULL;
    Ra.sl[6]=4460; /* line # 4460 */
    P_set_strname(Lx[5].v+3);
    break;
    case 0:Ra.sl[6]=4465; /* line # 4465 */
    Rv0=P_level_search(V_attr_list);
    if (Rv0!=NULL) switch (((UB *)Rv0)[57]) {
      case 27:Rs.sl[0]=1;
      break;
      case 28:Rs.sl[0]=2;
      break;
      case 29:Ra.sl[6]=4470; /* line # 4470 */
      Rs.sl[0]=4;
      break;
      default:P_src_error_s(Rd.s+844,165,2, V_sy_ident.s,NULL);
      break;
    }
    else {
      Ra.sl[6]=4475; /* line # 4475 */
      P_src_error(Rd.s+844,162,2);
    }
    break;
    default:P_src_error(Rd.s+844,163,2);
    Ra.sl[6]=4480; /* line # 4480 */
    P_skip_symbol(17,0,0);
    break;
  }
  if (V_sy_sym.ub[0]==17) P_insymbol();
  else P_src_error(Rd.s+844,26,2);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " varbl_setting "  */
void PAS_COMILER_PRC_00000038(UB F_v_class, SL *F_isz, SL *F_aln, V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  UB Rv1;
  V Rv2;
  SL Rv3;
  V Rv4;
  V Rv5;
  V Rv6;
  V Rv7;
  UW Rv8;
  UB Rv9;
  V Rv10;
  register V Rv11;
  UB Rv12;
  V Rv13;
  V Rv14;
  register V Rv15;
  register V Rv16;
  register V Rv17;
  V Rv18;
  register V Rv19;
  UB Rv20;
  register V Rv21;
  V Rv22;
  register V Rv23;
  register V Rv24;
  register V Rv25;
  V Rv26;
  register V Rv27;
  register V Rv28;
  register V Rv29;
  register V Rv30;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+848;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=4511; /* line # 4511 */
  Rv0=0;
  Rv1=Lx[5].ub[16];
  Rv2=NULL;
  Lx[5].ub[16]=1;
  if (Lx[5].v[3]!=NULL) {
    Ra.sl[6]=4517; /* line # 4517 */
    P_src_error_s(Rd.s+865,166,1, Lx[5].v[3],NULL);
    Lx[5].v[3]=NULL;
  }
  Rv3=0;
  Rv4=NULL;
  Rv5=NULL;
  Ra.sl[6]=4523; /* line # 4523 */
  if (F_v_class==6) ((V *)F_ty)[12]=V_lex_ident_tree.v[V_curr_disp*8+4];
  Ra.sl[6]=4528; /* line # 4528 */
  while (V_sy_sym.ub[0]==0||V_sy_sym.ub[0]==16){
    Rv6=NULL;
    Rv7=NULL;
    Rv8=96;
    while (1){
      Ra.sl[6]=4534; /* line # 4534 */
      switch (F_v_class) {
        case 5:if (V_sy_sym.ub[0]==16) {
          Ra.sl[6]=4539; /* line # 4539 */
          PAS_COMILER_PRC_00000044();
          if (V_sy_sym.ub[0]==0) {
            Rv9=Lx[5].ub[16];
            Rv2=Lx[5].v[3];
            Ra.sl[6]=4544; /* line # 4544 */
            Lx[5].ub[16]=1;
            Lx[5].v[3]=NULL;
          }
          else Rv0=1;
        }
        else {
          Ra.sl[6]=4551; /* line # 4551 */
          Rv9=Rv1;
          Rv2=NULL;
        }
        if (!Rv0) {
          Ra.sl[6]=4556; /* line # 4556 */
          V_cmp_twicedclon=1;
          P_ide_new(5,NULL,&Rv10);
          V_cmp_twicedclon=0;
          if (Rv9!=1&&Rv2!=NULL) {
            Ra.sl[6]=4561; /* line # 4561 */
            Rv11=Rv10;
            if (((V *)Rv11)[9]!=NULL) {
              if (P_match(Rv2,((V *)Rv11)[9])!=0) P_src_error_s(Rd.s+865,218,2,(
              (V *)Rv11)[0],NULL);
            }
            Ra.sl[6]=4566; /* line # 4566 */
            ((V *)Rv11)[9]=Rv2;
          }
        }
        break;
        case 2:P_ide_new(2,NULL,&Rv10);
        break;
        case 1:
        case 6:Ra.sl[6]=4572; /* line # 4572 */
        P_ide_new(6,NULL,&Rv10);
        break;
        default:break;
      }
      if (!Rv0) {
        Ra.sl[6]=4578; /* line # 4578 */
        if (!V_cmp_twicedcl) {
          if (Rv5!=NULL) ((V *)Rv5)[3]=Rv10;
          else {
            if (Rv4==NULL) Rv4=Rv10;
          }
          Ra.sl[6]=4583; /* line # 4583 */
          if (Rv6==NULL) Rv6=Rv10;
          Rv5=Rv10;
        }
        P_insymbol();
        if (V_sy_sym.ub[0]==18) P_insymbol();
        else {
          Ra.sl[6]=4588; /* line # 4588 */
          if (V_sy_sym.ub[0]!=22) P_src_error(Rd.s+865,29,2);
        }
        if (V_sy_sym.ub[0]==18) P_src_error(Rd.s+865,27,2);
      }
      if (V_sy_sym.ub[0]!=0&&V_sy_sym.ub[0]!=16)  break;
    }
    Ra.sl[6]=4593; /* line # 4593 */
    if (!Rv0) {
      P_insymbol();
      Rs.sl[1]=-1;
      Ra.sl[6]=4598; /* line # 4598 */
      Rs.sl[0]=-1;
      Rv12=0;
      if (V_sy_sym.ub[0]==16) {
        V_sy_sym.ub[0]=18;
        Ra.sl[6]=4603; /* line # 4603 */
        while (V_sy_sym.ub[0]==18){
          P_insymbol();
          switch (V_sy_sym.ub[0]) {
            case 87:Rv9=2;
            P_insymbol();
            break;
            case 81:
            case 82:
            case 83:Ra.sl[6]=4610; /* line # 4610 */
            if (V_sy_sym.ub[0]==82) Rv9=3;
            else Rv9=4;
            if (V_sy_sym.ub[0]==83) {
              if (V_sy_init_mod) Rv9=5;
              else P_src_error(Rd.s+865,992,2);
            }
            Ra.sl[6]=4615; /* line # 4615 */
            P_insymbol();
            break;
            case 0:Rv13=P_level_search(V_attr_list);
            Ra.sl[6]=4620; /* line # 4620 */
            P_insymbol();
            if (Rv13!=NULL) switch (((UB *)Rv13)[57]) {
              case 20:Rv9=3;
              break;
              case 21:Rv9=4;
              break;
              case 22:Ra.sl[6]=4625; /* line # 4625 */
              Rv9=2;
              break;
              case 25:Rv12=1;
              break;
              case 26:break;
              case 27:Rs.sl[0]=1;
              break;
              case 28:Rs.sl[0]=2;
              break;
              case 29:Ra.sl[6]=4630; /* line # 4630 */
              Rs.sl[0]=4;
              break;
              default:P_src_error_s(Rd.s+865,165,2, V_sy_ident.s,NULL);
              break;
            }
            else {
              Ra.sl[6]=4635; /* line # 4635 */
              P_src_error_s(Rd.s+865,167,2, V_sy_ident.s,NULL);
            }
            break;
            default:P_src_error(Rd.s+865,163,2);
            P_skip_symbol(17,0,0);
            break;
          }
        }
        Ra.sl[6]=4642; /* line # 4642 */
        if (V_sy_sym.ub[0]==17) P_insymbol();
        else P_src_error(Rd.s+865,26,2);
      }
      if (V_sy_sym.ub[0]==44&&F_v_class==5) {
        P_insymbol();
        Rv12=1;
      }
      Ra.sl[6]=4651; /* line # 4651 */
      if (Rv9==1&&Rv1!=1) {
        Rv9=Rv1;
        Rv2=NULL;
      }
      PAS_COMILER_PRC_00000039(&Rv14,0,NULL,0,0);
      Ra.sl[6]=4656; /* line # 4656 */
      switch (F_v_class) {
        case 5:if (((SL *)Rv14)[11]<0&&((V *)Rv14)[1]!=NULL) {
          Ra.sl[6]=4661; /* line # 4661 */
          Rv14=((V *)Rv14)[1];
        }
        break;
        case 2:if (Rv14!=NULL) {
          Rv15=Rv14;
          Ra.sl[6]=4666; /* line # 4666 */
          switch (((UB *)Rv15)[92]) {
            case 0:
            case 1:
            case 2:break;
            default:P_src_error(Rd.s+865,207,3);
            break;
          }
        }
        break;
        case 6:Ra.sl[6]=4673; /* line # 4673 */
        Rv16=Rv14;
        if (((UB *)Rv16)[90]||((SL *)Rv16)[10]>0) Lx[5].ub[0]=1;
        break;
        default:break;
      }
      Ra.sl[6]=4681; /* line # 4681 */
      Rv17=Rv14;
      if (Rv3<((UB *)Rv17)[48]) Rv3=((UB *)Rv17)[48];
      Rv7=((V *)Rv17)[10];
      Ra.sl[6]=4688; /* line # 4688 */
      if (F_v_class==5) {
        if (Rv9==1) switch (V_sy_sym.ub[0]) {
          case 87:Rv9=2;
          P_insymbol();
          break;
          case 82:Ra.sl[6]=4693; /* line # 4693 */
          Rv9=3;
          P_insymbol();
          break;
          case 81:Rv9=4;
          P_insymbol();
          break;
          default:break;
        }
        if (V_sy_sym.ub[0]==27) {
          Ra.sl[6]=4699; /* line # 4699 */
          Rv8=32;
          P_insymbol();
        }
      }
      Ra.sl[6]=4704; /* line # 4704 */
      if (V_sy_sym.ub[0]==23||V_sy_sym.ub[0]==35) {
        if (F_v_class==6) P_src_error(Rd.s+865,220,2);
        else {
          Ra.sl[6]=4711; /* line # 4711 */
          P_insymbol();
          if (V_sy_sym.ub[0]!=14&&V_sy_sym.ub[0]!=16) Rv18=PAS_COMILER_PRC_00000005(
          Rv14,0,0,0);
          else Rv18=PAS_COMILER_PRC_00000019(Rv14);
          Ra.sl[6]=4717; /* line # 4717 */
          if (((UB *)Rv18)[40]!=14) P_src_error(Rd.s+865,216,3);
          else {
            Rv19=Rv18;
            Ra.sl[6]=4722; /* line # 4722 */
            Rv7=((V *)Rv19)[7];
            ((V *)Rv19)[7]=NULL;
          }
          Rv20=1;
          P_lgt_free_tree(&Rv18);
        }
      }
      else {
        Ra.sl[6]=4728; /* line # 4728 */
        Rv20=0;
      }
      if (V_sy_sym.ub[0]==19) P_insymbol();
      else {
        Ra.sl[6]=4733; /* line # 4733 */
        if (V_sy_sym.ub[0]==0) P_src_error_s(Rd.s+865,52,2, V_sy_ident.s,NULL);
      }
      if (Rv6!=NULL) while (1){
        Ra.sl[6]=4738; /* line # 4738 */
        Rv21=Rv6;
        Rv22=((V *)Rv21)[4];
        ((V *)Rv21)[4]=Rv14;
        if ((*F_isz)>0) (*F_isz)=P_ide_typ_align((*F_isz),Rv14);
        Ra.sl[6]=4743; /* line # 4743 */
        switch (F_v_class) {
          case 5:((UW *)Rv21)[46]=Rv8;
          if (Rv12) ((UW *)Rv21)[46]=((UW *)Rv21)[46]|16384;
          Ra.sl[6]=4749; /* line # 4749 */
          if (((UB *)Rv21)[94]==4||((SL *)Rv21)[22]>0) {
            if (Rv22!=NULL&&Rv22!=Rv14) P_src_error_s(Rd.s+865,217,3,((V *)Rv21)
            [0],NULL);
            ((UB *)Rv21)[94]=Rv9;
          }
          else {
            Ra.sl[6]=4757; /* line # 4757 */
            if (((UB *)Rv21)[94]==0) ((UB *)Rv21)[94]=Rv9;
            switch (((UB *)Rv21)[94]) {
              case 3:
              case 4:
              case 5:if (((V *)Rv21)[9]==NULL) {
                Ra.sl[6]=4762; /* line # 4762 */
                P_set_gbl_def_nam(((V *)Rv21)+9,((V *)Rv21)[0],86);
              }
              ((SL *)Rv21)[22]=-1;
              break;
              default:Ra.sl[6]=4767; /* line # 4767 */
              if (16384&((UW *)Rv21)[46]||V_cmp_igenv!=0) ((SL *)Rv21)[22]=-1;
              break;
            }
          }
          Ra.sl[6]=4772; /* line # 4772 */
          if (Rv7!=NULL) {
            if (((UB *)Rv21)[94]==4||((SL *)Rv21)[22]>0) {
              if (Rv20) P_src_error_s(Rd.s+865,209,2,((V *)Rv21)[0],NULL);
              Ra.sl[6]=4778; /* line # 4778 */
              Rv7=NULL;
            }
            else {
              ((V *)Rv21)[8]=Rv7;
              Ra.sl[6]=4783; /* line # 4783 */
              P_val_new(((V *)Rv21)+8,Rv14);
              Rv23=((V *)Rv21)[8];
              ((UW *)Rv23)[8]=((UW *)Rv10)[46];
              ((SL *)Rv23)[5]=((SL *)Rv21)[22];
            }
          }
          Ra.sl[6]=4791; /* line # 4791 */
          switch (((UB *)Rv21)[94]) {
            case 3:if (((UB *)((V *)Rv21)[4])[89]||((UB *)((V *)Rv21)[4])[90]) P_init_d_varbl(
            Rv6);
            P_all_new(((V *)Rv21)+10,Rv14, Rv6,((UB *)Rv21)[94]);
            Ra.sl[6]=4796; /* line # 4796 */
            ((V *)((V *)Rv21)[10])[13]=((V *)Rv21)[8];
            if (V_all_fglobal==NULL) V_all_fglobal=((V *)Rv21)[10];
            else((V *)V_all_lglobal)[0]=((V *)Rv21)[10];
            ((V *)((V *)Rv21)[10])[1]=V_all_lglobal;
            V_all_lglobal=((V *)Rv21)[10];
            break;
            case 1:
            case 2:Ra.sl[6]=4803; /* line # 4803 */
            if (((SL *)Rv21)[22]==0) {
              if (((UB *)((V *)Rv21)[4])[89]||((UB *)((V *)Rv21)[4])[90]) P_init_d_varbl(
              Rv6);
              P_all_new(((V *)Rv21)+10,Rv14, Rv6,((UB *)Rv21)[94]);
              ((V *)((V *)Rv21)[10])[13]=((V *)Rv21)[8];
              Ra.sl[6]=4808; /* line # 4808 */
              if (V_all_fstatic==NULL) V_all_fstatic=((V *)Rv21)[10];
              else((V *)V_all_lstatic)[0]=((V *)Rv21)[10];
              ((V *)((V *)Rv21)[10])[1]=V_all_lstatic;
              V_all_lstatic=((V *)Rv21)[10];
            }
            break;
            default:break;
          }
          break;
          case 1:
          case 6:Ra.sl[6]=4818; /* line # 4818 */
          ((SL *)Rv21)[15]=(*F_isz);
          if ((*F_isz)<0) {
            Ra.sl[6]=4823; /* line # 4823 */
            P_src_error(Rd.s+865,221,3);
          }
          break;
          case 2:Ra.sl[6]=4828; /* line # 4828 */
          ((UB *)Rv21)[64]=0;
          ((V *)Rv21)[11]=Rv7;
          if (((V *)Rv21)[11]==NULL) {
            Ra.sl[6]=4834; /* line # 4834 */
            P_val_new(((V *)Rv21)+11,Rv14);
            Rv24=((V *)Rv21)[11];
            Rv25=Rv14;
            switch (((UB *)Rv25)[92]) {
              case 0:((SL *)Rv24)[13]=((SL *)Rv25)[30];
              break;
              case 1:
              case 2:Ra.sl[6]=4840; /* line # 4840 */
              if (((SL *)Rv25)[30]>32767) ((SL *)Rv24)[13]=32767;
              else((SL *)Rv24)[13]=((SL *)Rv25)[30];
              break;
              default:break;
            }
          }
          else {
            Ra.sl[6]=4846; /* line # 4846 */
            P_val_new(((V *)Rv21)+11,Rv14);
          }
          ((SL *)Rv21)[15]=(*F_isz);
          break;
        }
        Ra.sl[6]=4852; /* line # 4852 */
        if ((*F_isz)>=0) {
          if (((SL *)Rv14)[11]>=0) (*F_isz)=(*F_isz)+((SL *)Rv14)[11];
          else {
            if ((F_v_class==6||F_v_class==1)&&((V *)Rv14)[9]!=NULL) {
              Ra.sl[6]=4859; /* line # 4859 */
              Rv26=P_lgt_link(((V *)Rv14)[9]);
              if ((*F_isz)>0) {
                ((V *)Rv26)[0]=P_lgt_new_econst(V_typ_std.v[2],(*F_isz));
                ((V *)F_ty)[9]=P_lgt_new_code(49, Rv26);
              }
              else {
                Ra.sl[6]=4865; /* line # 4865 */
                ((V *)F_ty)[9]=Rv26;
              }
              (*F_isz)=-1;
            }
            else {
              Ra.sl[6]=4871; /* line # 4871 */
              P_src_error(Rd.s+865,301,3);
            }
          }
        }
        Rv6=((V *)Rv6)[3];
        if (Rv6==NULL)  break;
      }
      if (Rv20&&Rv7!=NULL) P_val_free(&Rv7);
      Ra.sl[6]=4876; /* line # 4876 */
      Rv20=0;
    }
  }
  if (!Rv0) {
    Ra.sl[6]=4881; /* line # 4881 */
    switch (F_v_class) {
      case 1:
      case 6:Rv27=F_ty;
      switch (V_sy_sym.ub[0]) {
        case 73:Ra.sl[6]=4887; /* line # 4887 */
        if (F_v_class==6&&(*F_isz)>=0) ((V *)Rv27)[9]=P_lgt_new_econst(V_typ_std
        .v[2],(*F_isz));
        break;
        case 15:Ra.sl[6]=4892; /* line # 4892 */
        if (F_v_class==6&&(*F_isz)>=0) ((V *)Rv27)[9]=P_lgt_new_econst(V_typ_std
        .v[2],(*F_isz));
        if (((UB *)F_ty)[92]!=23) {
          P_src_error(Rd.s+865,223,2);
          P_insymbol();
        }
        break;
        case 57:Ra.sl[6]=4901; /* line # 4901 */
        Rv28=F_ty;
        Rv29=(V_lex_ident_tree.s+V_curr_disp*64);
        if (((SL *)Rv28)[11]<0) {
          P_src_error(Rd.s+865,224,3);
          P_insymbol();
          P_skip_symbol(73,0,0);
        }
        else {
          Ra.sl[6]=4909; /* line # 4909 */
          P_insymbol();
          if (F_v_class==6) {
            if (((V *)Rv28)[13]==NULL) ((V *)Rv28)[12]=((V *)Rv29)[1];
            else {
              Ra.sl[6]=4914; /* line # 4914 */
              ((V *)Rv28)[12]=((V *)((V *)Rv28)[13])[3];
            }
          }
          ((V *)Rv28)[13]=((V *)Rv29)[4];
          ((V *)Rv28)[14]=PAS_COMILER_PRC_00000004(42, F_ty);
          ((V *)Rv28)[9]=P_lgt_new_code(0,((V *)Rv28)[14]);
        }
        break;
        default:Ra.sl[6]=4922; /* line # 4922 */
        P_src_error(Rd.s+865,225,2);
        break;
      }
      break;
      case 2:if (V_sy_sym.ub[0]!=15) P_src_error(Rd.s+865,23,2);
      else P_insymbol();
      break;
      default:break;
    }
  }
  Ra.sl[6]=4930; /* line # 4930 */
  (*F_aln)=Rv3;
  if (F_ty!=NULL) {
    Rv30=F_ty;
    if (Rv3>((UB *)Rv30)[48]) ((UB *)Rv30)[48]=Rv3;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " constdecl "  */
void PAS_COMILER_PRC_00000045(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  V Rv2;
  register V Rv3;
  register V Rv4;
  register V Rv5;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+869;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=4948; /* line # 4948 */
  V_ident_disp=V_curr_disp;
  while (V_sy_sym.ub[0]==0||V_sy_sym.ub[0]==44){
    Ra.sl[6]=4953; /* line # 4953 */
    if (V_sy_sym.ub[0]==44) {
      P_insymbol();
      Rv0=1;
    }
    else {
      Ra.sl[6]=4958; /* line # 4958 */
      Rv0=0;
    }
    if (V_sy_sym.ub[0]!=0) {
      P_src_error(Rd.s+882,107,3);
      P_skip_symbol(19,0,0);
    }
    else {
      Ra.sl[6]=4966; /* line # 4966 */
      P_ide_new(4,NULL,&Rv1);
      P_insymbol();
      if (V_sy_sym.ub[0]!=10||V_sy_sym.ub[1]!=19) P_src_error(Rd.s+882,30,2);
      else {
        Ra.sl[6]=4972; /* line # 4972 */
        P_insymbol();
      }
      Rv2=PAS_COMILER_PRC_00000000();
      Rv3=Rv1;
      Rv4=Rv2;
      if (((UB *)Rv4)[40]!=14) P_src_error(Rd.s+882,53,3);
      else {
        Ra.sl[6]=4979; /* line # 4979 */
        ((V *)Rv3)[4]=((V *)Rv4)[3];
        ((V *)Rv3)[8]=((V *)Rv4)[7];
        ((UB *)Rv3)[80]=2;
        ((V *)Rv4)[7]=NULL;
        if ((((V *)Rv3)[8]!=NULL&&!Rv0)&&V_cmp_igenv==0) {
          Ra.sl[6]=4984; /* line # 4984 */
          if (((V *)Rv3)[4]!=NULL) {
            Rv5=((V *)Rv3)[8];
            ((SL *)Rv5)[5]=0;
            ((UW *)Rv5)[8]=((UW *)Rv5)[8]&~16384;
            Ra.sl[6]=4989; /* line # 4989 */
            P_cte_allocate(((V *)Rv3)[8],Rv1);
          }
        }
        if (V_sy_init_mod) {
          if (((UB *)((V *)Rv3)[4])[92]==8) {
            Ra.sl[6]=4994; /* line # 4994 */
            if (V_usi_tab==NULL) V_usi_tab=Rv1;
            else {
              if (V_csi_tab==NULL) V_csi_tab=Rv1;
            }
          }
        }
      }
      if (Rv2!=NULL) P_lgt_free_tree(&Rv2);
    }
    Ra.sl[6]=5000; /* line # 5000 */
    if (V_sy_sym.ub[0]==18||V_sy_sym.ub[0]==19) P_insymbol();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " typedecl "  */
void PAS_COMILER_PRC_00000046(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  SL Rv3;
  SL Rv4;
  UL Rv5;
  SL Rv6;
  SL Rv7;
  V Rv8;
  register V Rv9;
  V Rv10;
  register V Rv11;
  SL Rv12;
  V Rv13;
  V Rv14;
  V Rv15;
  V Rv16;
  V Rv17;
  UB Rv18;
  register V Rv19;
  V Rv20;
  UB Rv21;
  register V Rv22;
  register V Rv23;
  register V Rv24;
  register int Rgi;
  register int Rgj;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+886;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=5022; /* line # 5022 */
  V_ident_disp=V_curr_disp;
  if (V_sy_init_mod) while (V_sy_sym.ub[0]==58){
    Ra.sl[6]=5028; /* line # 5028 */
    P_insymbol();
    if (V_sy_sym.ub[0]==0) {
      Rv0=P_ide_search(2);
      if (Rv0!=NULL) Rv1=((V *)Rv0)[4];
      else {
        Ra.sl[6]=5033; /* line # 5033 */
        Rv1=NULL;
      }
      if (Rv1!=NULL) {
        P_insymbol();
        if (V_sy_sym.ub[0]==74) {
          Ra.sl[6]=5038; /* line # 5038 */
          Rv2=Rv1;
          Rv3=((SL *)Rv2)[11];
          Rv4=0;
          PAS_COMILER_PRC_00000041(&Rv3, &Rv4);
          Ra.sl[6]=5043; /* line # 5043 */
          ((SL *)Rv2)[11]=Rv3;
          ((UB *)Rv2)[48]=Rv4;
          if ((((UB *)Rv2)[92]==2||((UB *)Rv2)[92]==1)||((UB *)Rv2)[92]==0) {
            Ra.sl[6]=5048; /* line # 5048 */
            if (Rv3<4) {
              if (((UB *)Rv2)[112]) {
                ((UL *)Rv2)[29]=0;
                Ra.sl[6]=5053; /* line # 5053 */
                Rv5=PAS__IIPOWER(2,8*Rv3);
                if (((UL *)Rv2)[30]>Rv5) ((UL *)Rv2)[30]=Rv5-1;
              }
              else {
                Ra.sl[6]=5058; /* line # 5058 */
                Rv6=PAS__IIPOWER(2,8*Rv3-1);
                if (((SL *)Rv2)[30]>=Rv6) ((SL *)Rv2)[30]=Rv6-1;
                if (((SL *)Rv2)[29]<= -Rv6) ((SL *)Rv2)[29]= -Rv6;
              }
            }
            else {
              Ra.sl[6]=5064; /* line # 5064 */
              if (((UB *)Rv2)[112]) {
                ((SL *)Rv2)[29]=0;
                ((SL *)Rv2)[30]=-1;
              }
              else {
                ((SL *)Rv2)[30]=2147483647;
                ((SL *)Rv2)[29]= -((SL *)Rv2)[30]-1;
              }
            }
          }
          switch (((UB *)Rv2)[92]) {
            case 2:Ra.sl[6]=5070; /* line # 5070 */
            V_inte_size=((SL *)Rv2)[11];
            ((SL *)V_uns_typ)[11]=((SL *)Rv2)[11];
            ((UB *)V_uns_typ)[48]=((UB *)Rv2)[48];
            break;
            case 5:
            case 13:Ra.sl[6]=5076; /* line # 5076 */
            V_fptr_size=((SL *)Rv2)[11];
            ((SL *)V_typ_std.v[13])[11]=((SL *)Rv2)[11];
            ((UB *)V_typ_std.v[13])[48]=((UB *)Rv2)[48];
            ((SL *)V_typ_std.v[5])[11]=((SL *)Rv2)[11];
            ((UB *)V_typ_std.v[5])[48]=((UB *)Rv2)[48];
            Ra.sl[6]=5081; /* line # 5081 */
            ((SL *)V_typ_std.v[5])[11]=((SL *)Rv2)[11];
            ((UB *)V_typ_std.v[5])[48]=((UB *)Rv2)[48];
            ((SL *)V_typ_std.v[16])[11]=((SL *)Rv2)[11];
            ((UB *)V_typ_std.v[16])[48]=((UB *)Rv2)[48];
            break;
            case 3:Ra.sl[6]=5086; /* line # 5086 */
            V_sngl_size=((SL *)Rv2)[11];
            break;
            case 4:V_dble_size=((SL *)Rv2)[11];
            break;
            case 17:
            case 19:V_dst_setw=((SL *)Rv2)[11]*8;
            Ra.sl[6]=5091; /* line # 5091 */
            V_dst_seti=((V_dst_seta+V_dst_setw)-1)/V_dst_setw;
            ((UB *)V_typ_std.v[18])[48]=((UB *)Rv2)[48];
            ((UB *)V_typ_std.v[19])[48]=((UB *)Rv2)[48];
            ((UB *)V_typ_std.v[17])[48]=((UB *)Rv2)[48];
            ((SL *)V_typ_std.v[19])[11]=((SL *)Rv2)[11];
            Ra.sl[6]=5096; /* line # 5096 */
            ((SL *)V_typ_std.v[17])[11]=((SL *)Rv2)[11];
            break;
            case 18:V_dst_seta=((SL *)Rv2)[11]*8;
            Ra.sl[6]=5101; /* line # 5101 */
            V_dst_seti=((V_dst_seta+V_dst_setw)-1)/V_dst_setw;
            ((UB *)V_typ_std.v[19])[48]=((UB *)Rv2)[48];
            ((UB *)V_typ_std.v[17])[48]=((UB *)Rv2)[48];
            break;
            case 16:Ra.sl[6]=5108; /* line # 5108 */
            Rv7=((UB *)V_typ_std.v[5])[48];
            if (Rv7!=Rv4) ((UB *)Rv2)[48]=Rv7;
            Rv7=((SL *)V_typ_std.v[16])[11];
            if (Rv3!=Rv7) {
              Ra.sl[6]=5114; /* line # 5114 */
              if (Rv3<Rv7) Rv3=Rv7;
              else {
                if (PAS__I_MOD(Rv3,Rv7)!=0) Rv3=Rv7*(Rv3/Rv7+1);
              }
              ((SL *)Rv2)[11]=Rv3;
            }
            break;
            default:break;
          }
          Ra.sl[6]=5122; /* line # 5122 */
          if (V_sy_sym.ub[0]==22) P_data_format_set(Rv1);
          if (V_sy_sym.ub[0]==19) P_insymbol();
          else P_src_error(Rd.s+898,21,2);
        }
        else {
          Ra.sl[6]=5127; /* line # 5127 */
          P_skip_symbol(19,0,0);
        }
      }
      else {
        P_src_error(Rd.s+898,8001,3);
        Ra.sl[6]=5132; /* line # 5132 */
        P_skip_symbol(19,0,0);
      }
    }
    else {
      Ra.sl[6]=5137; /* line # 5137 */
      P_src_error(Rd.s+898,8002,3);
      P_skip_symbol(19,0,0);
    }
  }
  Ra.sl[6]=5144; /* line # 5144 */
  while (V_sy_sym.ub[0]==0){
    Rv0=Lx[5].v[1];
    Rv8=NULL;
    while (Rv0!=NULL&&Rv8==NULL){
      Ra.sl[6]=5149; /* line # 5149 */
      Rv9=Rv0;
      if (P_match(((V *)Rv9)[0],V_sy_ident.s)==0) {
        Rv8=Rv0;
        if (Rv0==Lx[5].v[1]) Lx[5].v[1]=((V *)Lx[5].v[1])[8];
        else {
          Ra.sl[6]=5154; /* line # 5154 */
          ((V *)Rv10)[8]=((V *)Rv0)[8];
        }
      }
      Rv10=Rv0;
      Rv0=((V *)Rv0)[8];
    }
    if (Rv8==NULL) {
      Ra.sl[6]=5161; /* line # 5161 */
      P_ide_new(1,NULL,&Rv8);
      Rv1=NULL;
    }
    else Rv1=((V *)Rv8)[4];
    Rv11=Rv8;
    Ra.sl[6]=5167; /* line # 5167 */
    Rv12=V_curr_disp;
    P_insymbol();
    Rv3=0;
    if (V_sy_sym.ub[0]==14) {
      Ra.sl[6]=5172; /* line # 5172 */
      P_insymbol();
      P_new_disp_level(NULL,4);
      PAS_COMILER_PRC_00000038(2, &Rv3, &Rv7,NULL);
      Rv0=V_lex_ident_tree.v[V_curr_disp*8+1];
      Rv13=Rv0;
      Ra.sl[6]=5177; /* line # 5177 */
      Rv14=NULL;
      while (Rv13!=NULL){
        P_lgt_new(&Rv15,((V *)Rv13)[4],14,NULL);
        ((V *)Rv15)[7]=((V *)Rv13)[11];
        Ra.sl[6]=5182; /* line # 5182 */
        P_val_new(((V *)Rv15)+7,((V *)Rv13)[4]);
        if (Rv14==NULL) Rv14=Rv15;
        else((V *)Rv16)[0]=Rv15;
        Rv16=Rv15;
        Rv13=((V *)Rv13)[3];
      }
    }
    else {
      Ra.sl[6]=5189; /* line # 5189 */
      Rv0=NULL;
    }
    if (V_sy_sym.ub[0]!=10||V_sy_sym.ub[1]!=19) P_src_error(Rd.s+898,30,2);
    else P_insymbol();
    Ra.sl[6]=5194; /* line # 5194 */
    if (V_sy_sym.ub[0]==16) {
      V_sy_sym.ub[0]=18;
      while (V_sy_sym.ub[0]==18){
        Ra.sl[6]=5199; /* line # 5199 */
        P_insymbol();
        if (V_sy_sym.ub[0]==0) {
          Rv17=P_level_search(V_attr_list);
          P_insymbol();
          Ra.sl[6]=5204; /* line # 5204 */
          if (Rv17!=NULL) switch (((UB *)Rv17)[57]) {
            case 25:Rv18=1;
            break;
            case 27:Rs.sl[0]=1;
            break;
            case 28:Rs.sl[0]=2;
            break;
            case 29:Ra.sl[6]=5209; /* line # 5209 */
            Rs.sl[0]=4;
            break;
            default:P_src_error_s(Rd.s+898,161,2, V_sy_ident.s,NULL);
            break;
          }
          else {
            Ra.sl[6]=5214; /* line # 5214 */
            P_src_error_s(Rd.s+898,167,2, V_sy_ident.s,NULL);
          }
        }
        else {
          P_src_error(Rd.s+898,163,2);
          Ra.sl[6]=5219; /* line # 5219 */
          P_skip_symbol(17,0,0);
        }
      }
      if (V_sy_sym.ub[0]==17) P_insymbol();
      else P_src_error(Rd.s+898,26,2);
    }
    Ra.sl[6]=5227; /* line # 5227 */
    PAS_COMILER_PRC_00000039(((V *)Rv11)+4,Rv3, Rv0,1,0);
    V_curr_disp=Rv12;
    ((V *)Rv11)[10]=V_sy_type_gfirst;
    ((V *)Rv11)[11]=NULL;
    Ra.sl[6]=5232; /* line # 5232 */
    V_tcas_flag=0;
    Rv19=((V *)Rv11)[4];
    if (Rv0!=NULL) {
      Ra.sl[6]=5238; /* line # 5238 */
      switch (((UB *)Rv19)[92]) {
        case 8:
        case 10:
        case 11:
        case 12:
        case 22:
        case 27:((SL *)Rv19)[10]=P_ide_typ_align(Rv3,((V *)Rv11)[4]);
        Ra.sl[6]=5243; /* line # 5243 */
        ((V *)Rv19)[4]=Rv0;
        if (Rv7>((UB *)((V *)Rv11)[4])[48]) ((UB *)((V *)Rv11)[4])[48]=Rv7;
        if (((SL *)Rv19)[11]<0) {
          Ra.sl[6]=5248; /* line # 5248 */
          Rv20=P_lgt_type_eval(((V *)Rv19)[9],NULL,NULL,0);
          if (((UB *)Rv20)[40]==14) {
            ((SL *)Rv19)[11]= -((SL *)((V *)Rv20)[7])[13];
            Ra.sl[6]=5253; /* line # 5253 */
            if (((SL *)Rv19)[11]>=0) ((SL *)Rv19)[11]=-1;
            P_lgt_free(&Rv20);
          }
        }
        break;
        default:Ra.sl[6]=5260; /* line # 5260 */
        P_src_error(Rd.s+898,205,3);
        break;
      }
      Rv21=((UB *)Rv19)[92]!=10;
      Ra.sl[6]=5265; /* line # 5265 */
      if (Rv21) {
        if (((V *)Rv19)[9]==NULL) ((SL *)Rv19)[11]=((SL *)Rv19)[11]+((SL *)Rv19)
        [10];
        else {
          Ra.sl[6]=5271; /* line # 5271 */
          if (((UB *)((V *)Rv19)[9])[40]==14) {
            Rv22=((V *)Rv19)[9];
            if (((V *)Rv22)[7]!=NULL) ((SL *)((V *)Rv22)[7])[13]=((SL *)((V *)Rv22)
            [7])[13]+((SL *)Rv19)[10];
          }
          else {
            Ra.sl[6]=5279; /* line # 5279 */
            ((V *)((V *)Rv19)[9])[0]=P_lgt_new_econst(V_typ_std.v[2],((SL *)Rv19)
            [10]);
            ((V *)Rv19)[9]=P_lgt_new_code(49,((V *)Rv19)[9]);
          }
        }
      }
      Ra.sl[6]=5286; /* line # 5286 */
      if (V_tcas_flag) P_lgt_gen_routine(((V *)Rv11)[4]);
    }
    Rv23=((V *)Rv11)[4];
    Ra.sl[6]=5291; /* line # 5291 */
    if (((V *)Rv23)[3]==NULL) {
      if (((V *)Rv23)[0]!=NULL) {
        if (((V *)((V *)Rv23)[0])[3]!=NULL) {
          Ra.sl[6]=5296; /* line # 5296 */
          ((V *)Rv11)[10]=((V *)((V *)((V *)Rv23)[0])[3])[10];
        }
      }
      ((V *)Rv23)[3]=Rv8;
    }
    if (Rv1!=NULL) ((V *)Rv1)[12]=((V *)Rv11)[4];
    Ra.sl[6]=5303; /* line # 5303 */
    if (V_sy_sym.ub[0]==23||V_sy_sym.ub[0]==35) {
      P_insymbol();
      if (V_sy_sym.ub[0]==16||V_sy_sym.ub[0]==14) Rv20=PAS_COMILER_PRC_00000019((
      (V *)Rv11)[4]);
      else Rv20=PAS_COMILER_PRC_00000005(((V *)Rv11)[4],0,0,0);
      Ra.sl[6]=5308; /* line # 5308 */
      if (((UB *)Rv20)[40]!=14) P_src_error(Rd.s+898,53,3);
      else {
        Rv24=Rv20;
        Ra.sl[6]=5314; /* line # 5314 */
        ((V *)((V *)Rv11)[4])[10]=((V *)Rv24)[7];
        ((V *)Rv24)[7]=NULL;
      }
      P_lgt_free_tree(&Rv20);
    }
    Ra.sl[6]=5321; /* line # 5321 */
    if (Rv0!=NULL&&((V *)Rv11)[4]!=NULL) ((V *)((V *)Rv11)[4])[1]=P_type_parm_set(
    Rv8, Rv14);
    if (V_sy_sym.ub[0]==19) P_insymbol();
    else P_src_error(Rd.s+898,21,2);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " vardecl "  */
void PAS_COMILER_PRC_00000047(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+902;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=5346; /* line # 5346 */
  V_ident_disp=V_curr_disp;
  Rv0=0;
  PAS_COMILER_PRC_00000038(5, &Rv0, &Rv1,NULL);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " labeldecl "  */
void PAS_COMILER_PRC_00000048(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+911;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=5363; /* line # 5363 */
  Rv0=0;
  while (1){
    P_insymbol();
    Ra.sl[6]=5368; /* line # 5368 */
    if (V_sy_sym.ub[0]==2) P_ide_int_label();
    if (V_sy_sym.ub[0]!=0) P_src_error(Rd.s+924,69,3);
    else {
      Ra.sl[6]=5373; /* line # 5373 */
      P_ide_new(3,NULL,&Rv1);
      if (Rv1!=NULL) {
        Rv2=Rv1;
        Rv3=Lx[5].v[13];
        Ra.sl[6]=5378; /* line # 5378 */
        if (((V *)Rv3)[20]==NULL) ((V *)Rv3)[20]=Rv1;
        else((V *)Lx[5].v[4])[8]=Rv1;
        Lx[5].v[4]=Rv1;
        ((UB *)Rv2)[57]=1;
      }
    }
    Ra.sl[6]=5384; /* line # 5384 */
    P_insymbol();
    if (V_sy_sym.ub[0]!=18)  break;
  }
  if (V_sy_sym.ub[0]==19) P_insymbol();
  else P_src_error(Rd.s+924,21,2);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " statementdecl "  */
void PAS_COMILER_PRC_00000049(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  SL Rv2;
  V Rv3;
  register V Rv4;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+928;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=5407; /* line # 5407 */
  P_insymbol();
  if (V_sy_sym.ub[0]!=0) {
    Ra.sl[6]=5412; /* line # 5412 */
    P_src_error(Rd.s+945,107,3);
    P_skip_symbol(19,1,0);
  }
  else {
    Ra.sl[6]=5417; /* line # 5417 */
    V_err_prt=0;
    Rv0=P_ide_search(1024);
    V_err_prt=1;
    if (Rv0!=NULL) {
      if (((SL *)Rv0)[10]!=V_curr_lex) Rv1=NULL;
      else {
        Ra.sl[6]=5422; /* line # 5422 */
        Rv1=Rv0;
      }
    }
    else Rv1=NULL;
    if (Rv1==NULL) P_ide_new(10,NULL,&Rv1);
    Ra.sl[6]=5427; /* line # 5427 */
    P_insymbol();
    if (V_sy_sym.ub[0]==58) {
      Ra.sl[6]=5433; /* line # 5433 */
      P_insymbol();
      if (V_sy_sym.ub[0]==38) P_insymbol();
      if (V_sy_sym.ub[0]==41) {
        P_insymbol();
        Ra.sl[6]=5438; /* line # 5438 */
        if (V_sy_sym.ub[0]!=16) P_src_error(Rd.s+945,25,2);
        Rv2=0;
        PAS_COMILER_PRC_00000043(Ri.v+3,1, &Rv2);
      }
      else {
        Ra.sl[6]=5444; /* line # 5444 */
        PAS_COMILER_PRC_00000039(Ri.v+3,0,NULL,0,1);
      }
      if (V_sy_sym.ub[0]==23) {
        P_insymbol();
        Ra.sl[6]=5449; /* line # 5449 */
        Ri.v[4]=PAS_COMILER_PRC_00000005(Ri.v[3],0,0,0);
      }
      if (V_sy_sym.ub[0]==49) {
        Ri.ub[17]=1;
        P_insymbol();
      }
      if (V_sy_sym.ub[0]==54) P_insymbol();
      else {
        Ra.sl[6]=5454; /* line # 5454 */
        P_src_error(Rd.s+945,55,2);
      }
    }
    if (V_sy_sym.ub[0]==0) {
      Ri.v[5]=P_ide_search(514);
      Ra.sl[6]=5459; /* line # 5459 */
      P_insymbol();
    }
    if (V_sy_sym.ub[0]==18) P_insymbol();
    else P_src_error(Rd.s+945,29,2);
    if (V_sy_sym.ub[0]==0) {
      Ra.sl[6]=5465; /* line # 5465 */
      Ri.v[6]=P_ide_search(514);
      P_insymbol();
    }
    else P_src_error_s(Rd.s+945,42,3,((V *)Rv1)[0],NULL);
    if (V_sy_sym.ub[0]==18) {
      Ra.sl[6]=5470; /* line # 5470 */
      P_insymbol();
      if (V_sy_sym.ub[0]==0) {
        Ri.v[7]=P_ide_search(514);
        P_insymbol();
      }
      else {
        Ra.sl[6]=5476; /* line # 5476 */
        P_src_error_s(Rd.s+945,43,2,((V *)Rv1)[0],NULL);
      }
    }
    if (V_error_result<=1) {
      Ra.sl[6]=5482; /* line # 5482 */
      Rv3=PAS__NEW(56);
      memcpy(Rv3,Ri.s+8,56);
      Rv4=Rv1;
      if (((V *)Rv4)[9]==NULL) {
        Ra.sl[6]=5488; /* line # 5488 */
        if (Rv0!=NULL) ((V *)Rv3)[0]=((V *)Rv0)[8];
        ((V *)Rv4)[8]=Rv3;
        ((V *)Rv4)[9]=Rv3;
      }
      else {
        Ra.sl[6]=5495; /* line # 5495 */
        ((V *)Rv3)[0]=((V *)((V *)Rv4)[9])[0];
        ((V *)((V *)Rv4)[9])[0]=Rv3;
        ((V *)Rv4)[9]=Rv3;
      }
    }
  }
  Ra.sl[6]=5502; /* line # 5502 */
  if (V_sy_sym.ub[0]==19) P_insymbol();
  else P_src_error(Rd.s+945,21,2);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " argument_list "  */
UB PAS_COMILER_PRC_00000003(V *F_pr, UB F_isfunct, UB F_no_entry){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  V Rv2;
  SL Rv3;
  register V Rv4;
  UB Rv5;
  V Rv6;
  V Rv7;
  SL Rv8;
  UW Rv9;
  UB Rv10;
  UW Rv11;
  UB Rv12;
  SL Rv13;
  V Rv14;
  V Rv15;
  register V Rv16;
  V Rv17;
  register V Rv18;
  register V Rv19;
  register V Rv20;
  register V Rv21;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+949;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=5541; /* line # 5541 */
  Rv0=0;
  Rv1=Lx[5].v[13];
  Lx[5].v[13]=(*F_pr);
  Rv2=NULL;
  Rv3=0;
  Ra.sl[6]=5546; /* line # 5546 */
  Rv4=(*F_pr);
  if (V_sy_sym.ub[0]==14) {
    V_sy_sym.ub[0]=19;
    while (1){
      Ra.sl[6]=5552; /* line # 5552 */
      P_insymbol();
      if (V_sy_sym.ub[0]==77||V_sy_sym.ub[0]==78) {
        if (F_no_entry) P_src_error(Rd.s+966,125,3);
        Rv0=1;
        Ra.sl[6]=5557; /* line # 5557 */
        Rv5=V_sy_sym.ub[0]==78;
        P_insymbol();
        Rv6=PAS_COMILER_PRC_00000001(Rv5);
        Rv3=Rv3+1;
        Ra.sl[6]=5562; /* line # 5562 */
        if (Rv2==NULL) Rv2=Rv6;
        Rv7=Rv6;
      }
      else {
        Ra.sl[6]=5567; /* line # 5567 */
        Rv8=0;
        Rv9=96;
        Rv10=0;
        Rv11=0;
        Rv12=8;
        while (1){
          Ra.sl[6]=5573; /* line # 5573 */
          switch (V_sy_sym.ub[0]) {
            case 31:Rv12=7;
            break;
            case 36:Rv9=32;
            Rv12=7;
            break;
            case 37:Rv9=64;
            Rv12=7;
            break;
            default:Ra.sl[6]=5578; /* line # 5578 */
            Rv10=1;
            break;
          }
          if (!Rv10) P_insymbol();
          if (Rv10)  break;
        }
        Ra.sl[6]=5583; /* line # 5583 */
        Rv7=NULL;
        while (V_sy_sym.ub[0]==0){
          P_ide_new(5,NULL,&Rv6);
          Rv3=Rv3+1;
          Ra.sl[6]=5588; /* line # 5588 */
          Rv8=Rv8+1;
          if (Rv7==NULL) {
            if (Rv2==NULL) Rv2=Rv6;
            Ra.sl[6]=5593; /* line # 5593 */
            Rv7=Rv6;
          }
          P_insymbol();
          if (V_sy_sym.ub[0]==18) P_insymbol();
          else {
            Ra.sl[6]=5598; /* line # 5598 */
            if (V_sy_sym.ub[0]!=22) P_src_error(Rd.s+966,29,2);
          }
        }
        if (V_sy_sym.ub[0]!=22) P_src_error(Rd.s+966,31,2);
        else P_insymbol();
        Ra.sl[6]=5604; /* line # 5604 */
        if (V_sy_sym.ub[0]==16) {
          while (1){
            P_insymbol();
            if (V_sy_sym.ub[0]==0) {
              Ra.sl[6]=5610; /* line # 5610 */
              Rv6=P_level_search(V_attr_list);
              P_insymbol();
              if (Rv6!=NULL) switch (((UB *)Rv6)[57]) {
                case 17:Rv9=Rv9|2048;
                break;
                case 16:Ra.sl[6]=5615; /* line # 5615 */
                Rv9=Rv9|1024;
                break;
                case 1:Rv9=Rv9|512;
                break;
                case 6:Rv9=Rv9|256;
                break;
                case 24:Ra.sl[6]=5620; /* line # 5620 */
                if (Rv12!=7) P_src_error(Rd.s+966,242,2);
                Rv9=Rv9|8192;
                break;
                case 23:Rv9=(Rv9|32)&~64;
                break;
                case 30:Ra.sl[6]=5625; /* line # 5625 */
                Rv11=Rv11|4;
                break;
                case 31:Rv11=Rv11|8;
                break;
                case 32:Rv11=Rv11|16;
                break;
                case 33:Rv11=Rv11|32;
                break;
                case 34:Rv11=Rv11|64;
                break;
                default:break;
              }
            }
            else {
              Ra.sl[6]=5633; /* line # 5633 */
              P_src_error(Rd.s+966,2,3);
            }
            if (V_sy_sym.ub[0]!=18)  break;
          }
          if (V_sy_sym.ub[0]==17) P_insymbol();
          else P_src_error(Rd.s+966,26,2);
        }
        Ra.sl[6]=5639; /* line # 5639 */
        if (V_sy_sym.ub[0]==38) P_insymbol();
        if (V_sy_sym.ub[0]==41) {
          if (Rv8>1) P_src_error(Rd.s+966,243,3);
          P_insymbol();
          Ra.sl[6]=5644; /* line # 5644 */
          if (V_sy_sym.ub[0]!=16) P_src_error(Rd.s+966,25,2);
          Rv13=0;
          if (!V_sy_init_mod) {
            if (Rv12==8&&!V_cmp_dynamic) {
              Ra.sl[6]=5649; /* line # 5649 */
              Rv12=7;
              Rv9=32;
              P_src_error(Rd.s+966,229,1);
            }
          }
          PAS_COMILER_PRC_00000043(&Rv14,1, &Rv13);
        }
        else {
          Ra.sl[6]=5657; /* line # 5657 */
          PAS_COMILER_PRC_00000039(&Rv14,0,NULL,0,1);
          if (Rv14!=NULL) {
            if (!V_sy_init_mod) {
              if ((((SL *)Rv14)[11]<0&&Rv12==8)&&!V_cmp_dynamic) {
                Ra.sl[6]=5663; /* line # 5663 */
                Rv12=7;
                Rv9=32;
                P_src_error(Rd.s+966,226,1);
              }
            }
          }
        }
        if (V_sy_sym.ub[0]==23) {
          Ra.sl[6]=5669; /* line # 5669 */
          P_insymbol();
          Rv15=PAS_COMILER_PRC_00000005(Rv14,0,0,0);
          Rv16=Rv15;
          if (((UB *)Rv16)[40]!=14) P_src_error(Rd.s+966,53,3);
          else {
            Ra.sl[6]=5676; /* line # 5676 */
            Rv17=((V *)Rv16)[7];
            ((V *)Rv16)[7]=NULL;
          }
          if (Rv12==7&&64&Rv9) P_src_error(Rd.s+966,241,2);
        }
        else {
          Ra.sl[6]=5682; /* line # 5682 */
          Rv17=NULL;
        }
        Rv6=Rv7;
        while (Rv6!=NULL){
          Rv18=Rv6;
          Ra.sl[6]=5687; /* line # 5687 */
          if (((UB *)Rv18)[94]==0) {
            ((V *)Rv18)[4]=Rv14;
            ((UW *)Rv18)[46]=Rv9;
            ((UB *)Rv18)[94]=Rv12;
            Ra.sl[6]=5692; /* line # 5692 */
            ((V *)Rv18)[8]=Rv17;
            ((UW *)Rv18)[48]=Rv11;
            if (Rv17!=NULL) P_val_new(((V *)Rv18)+8,Rv14);
          }
          Rv7=Rv6;
          Rv6=((V *)Rv6)[3];
        }
        Ra.sl[6]=5698; /* line # 5698 */
        if (Rv17!=NULL) P_val_free(&Rv17);
      }
      if (V_sy_sym.ub[0]!=19)  break;
    }
    if (V_sy_sym.ub[0]==15) P_insymbol();
    else P_src_error(Rd.s+966,23,2);
  }
  Ra.sl[6]=5704; /* line # 5704 */
  ((V *)Rv4)[11]=NULL;
  if (F_isfunct) {
    if (V_sy_sym.ub[0]==22) P_insymbol();
    else P_src_error(Rd.s+966,31,2);
    Ra.sl[6]=5709; /* line # 5709 */
    Rv9=97;
    if (V_sy_sym.ub[0]==16) {
      while (1){
        P_insymbol();
        Ra.sl[6]=5714; /* line # 5714 */
        if (V_sy_sym.ub[0]==0) {
          Rv6=P_level_search(V_attr_list);
          P_insymbol();
          if (Rv6!=NULL) {
            Ra.sl[6]=5719; /* line # 5719 */
            switch (((UB *)Rv6)[57]) {
              case 16:Rv9=Rv9|1024;
              break;
              case 1:Rv9=Rv9|512;
              break;
              default:break;
            }
          }
        }
        else {
          Ra.sl[6]=5725; /* line # 5725 */
          P_src_error(Rd.s+966,2,3);
        }
        if (V_sy_sym.ub[0]!=18)  break;
      }
      if (V_sy_sym.ub[0]==17) P_insymbol();
      else P_src_error(Rd.s+966,26,2);
    }
    Ra.sl[6]=5730; /* line # 5730 */
    PAS_COMILER_PRC_00000039(((V *)Rv4)+11,0,NULL,0,1);
    if (((V *)Rv4)[11]==NULL) ((V *)Rv4)[11]=V_typ_std.v[21];
  }
  if (((V *)Rv4)[11]!=NULL) {
    Ra.sl[6]=5735; /* line # 5735 */
    if (!((UB *)((V *)Rv4)[11])[91]) {
      Rv19=((V *)Rv4)[11];
      if (((SL *)Rv19)[11]<0&&((V *)Rv19)[1]!=NULL) ((V *)Rv4)[11]=((V *)Rv19)[1]
      ;
      Ra.sl[6]=5742; /* line # 5742 */
      P_ide_create_name(Rd.s+970);
      P_ide_new(5,((V *)Rv4)[11],&Rv6);
      if (Rv2!=NULL) ((V *)Rv7)[3]=NULL;
      Rv20=Rv6;
      Ra.sl[6]=5748; /* line # 5748 */
      ((V *)Rv20)[3]=Rv2;
      Rv2=Rv6;
      ((UW *)Rv20)[46]=Rv9;
      ((UB *)Rv20)[94]=6;
    }
  }
  Ra.sl[6]=5753; /* line # 5753 */
  ((SL *)Rv4)[20]=Rv3;
  ((V *)Rv4)[8]=Rv2;
  Rv21=(V_lex_ident_tree.s+V_curr_disp*64);
  ((V *)Rv4)[6]=((V *)Rv21)[1];
  Ra.sl[6]=5758; /* line # 5758 */
  ((V *)Rv4)[7]=((V *)Rv21)[4];
  ((V *)Rv4)[12]=((V *)Rv21)[5];
  Lx[5].v[13]=Rv1;
  Ra.sl[6]=5763; /* line # 5763 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " formal_proc_decl "  */
V PAS_COMILER_PRC_00000001(UB F_isfunction){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  SL Rv3;
  SL Rv4;
  UB Rv5;
  V Rv6;
  register V Rv7;
  V Rv8;
  register V Rv9;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+975;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=5781; /* line # 5781 */
  if (V_sy_sym.ub[0]==0) {
    Rv0=P_level_search(V_lex_ident_tree.v[V_curr_disp*8+1]);
    if (Rv0!=NULL) P_src_error(Rd.s+995,101,3);
    Ra.sl[6]=5786; /* line # 5786 */
    P_ide_new(7,NULL,&Rv0);
    Rv1=PAS__NEW(120);
    Rv2=Rv1;
    ((V *)Rv2)[0]=NULL;
    Ra.sl[6]=5791; /* line # 5791 */
    ((V *)Rv2)[1]=NULL;
    ((UW *)Rv2)[8]=0;
    ((V *)Rv2)[3]=NULL;
    ((UB *)Rv2)[32]=29;
    ((V *)Rv2)[5]=NULL;
    Ra.sl[6]=5796; /* line # 5796 */
    ((V *)Rv2)[6]=NULL;
    ((V *)Rv2)[7]=NULL;
    ((V *)Rv2)[8]=NULL;
    ((SL *)Rv2)[18]=V_curr_lex;
    ((SL *)Rv2)[19]=0;
    Ra.sl[6]=5801; /* line # 5801 */
    ((SL *)Rv2)[20]=0;
    ((V *)Rv2)[11]=NULL;
    ((V *)Rv2)[12]=NULL;
    ((UB *)Rv2)[104]=3;
    ((V *)Rv2)[14]=NULL;
    Ra.sl[6]=5807; /* line # 5807 */
    ((V *)Rv0)[9]=Rv1;
    Rv3=V_curr_lex;
    Rv4=V_curr_disp;
    if (V_curr_lex<30) V_curr_lex=V_curr_lex+1;
    else {
      Ra.sl[6]=5812; /* line # 5812 */
      P_src_error(Rd.s+995,1002,3);
    }
    P_new_disp_level(Rv1,4);
    V_lex_ident_level.sl[V_curr_lex]=V_curr_disp;
    P_insymbol();
    Rv5=PAS_COMILER_PRC_00000003(&Rv1, F_isfunction,0);
    Ra.sl[6]=5817; /* line # 5817 */
    V_curr_lex=Rv3;
    V_curr_disp=Rv4;
    if (V_sy_sym.ub[0]==23) {
      Ra.sl[6]=5822; /* line # 5822 */
      P_insymbol();
      if (V_sy_sym.ub[0]==0) {
        Rv6=P_ide_search(898);
        Ra.sl[6]=5827; /* line # 5827 */
        if (Rv6!=V_ide_udptr.v[1]) {
          Rv7=Rv6;
          Rv8=NULL;
          if (((UB *)Rv7)[56]==7) {
            Ra.sl[6]=5833; /* line # 5833 */
            Rv8=((V *)Rv7)[9];
            if (Rv8==Rv1) P_src_error(Rd.s+995,403,3);
          }
          else {
            Ra.sl[6]=5838; /* line # 5838 */
            if (((V *)Rv7)[11]!=((V *)Rv7)[10]&&((V *)Rv7)[11]!=NULL) P_src_error_s(
            Rd.s+995,118,2, V_sy_ident.s,NULL);
            else {
              Rv9=((V *)Rv7)[10];
              if (((UB *)Rv9)[8]) P_src_error(Rd.s+995,998,4);
              else {
                Ra.sl[6]=5843; /* line # 5843 */
                Rv8=((V *)Rv9)[2];
              }
            }
          }
          if (!P_comp_proc_arg(Rv8, Rv1)) P_src_error(Rd.s+995,119,3);
          else((V *)Rv0)[8]=Rv8;
          Ra.sl[6]=5848; /* line # 5848 */
          P_insymbol();
        }
      }
      else P_src_error(Rd.s+995,32,3);
    }
  }
  else {
    Ra.sl[6]=5857; /* line # 5857 */
    Rv0=V_ide_udptr.v[7];
    P_src_error(Rd.s+995,107,3);
  }
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " formal_proc_ptr "  */
V PAS_COMILER_PRC_00000002(UB F_isfunction){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  SL Rv2;
  SL Rv3;
  UB Rv4;
  V Rv5;
  register V Rv6;
  V Rv7;
  register V Rv8;
  V Rv9;
  register V Rv10;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+999;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=5879; /* line # 5879 */
  Rv0=PAS__NEW(120);
  Rv1=Rv0;
  Ra.sl[6]=5884; /* line # 5884 */
  ((V *)Rv1)[0]=NULL;
  ((V *)Rv1)[1]=NULL;
  ((UW *)Rv1)[8]=0;
  ((V *)Rv1)[3]=NULL;
  ((UB *)Rv1)[32]=29;
  Ra.sl[6]=5889; /* line # 5889 */
  ((V *)Rv1)[5]=NULL;
  ((V *)Rv1)[6]=NULL;
  ((V *)Rv1)[7]=NULL;
  ((V *)Rv1)[8]=NULL;
  ((SL *)Rv1)[18]=V_curr_lex;
  Ra.sl[6]=5894; /* line # 5894 */
  ((SL *)Rv1)[19]=0;
  ((SL *)Rv1)[20]=0;
  ((V *)Rv1)[11]=NULL;
  ((V *)Rv1)[12]=NULL;
  ((UB *)Rv1)[104]=3;
  Ra.sl[6]=5899; /* line # 5899 */
  ((V *)Rv1)[14]=NULL;
  Rv2=V_curr_lex;
  Rv3=V_curr_disp;
  if (V_curr_lex<30) V_curr_lex=V_curr_lex+1;
  else {
    Ra.sl[6]=5904; /* line # 5904 */
    P_src_error(Rd.s+1018,1002,3);
  }
  P_new_disp_level(Rv0,4);
  V_lex_ident_level.sl[V_curr_lex]=V_curr_disp;
  P_insymbol();
  Rv4=PAS_COMILER_PRC_00000003(&Rv0, F_isfunction,0);
  Ra.sl[6]=5909; /* line # 5909 */
  V_curr_lex=Rv2;
  V_curr_disp=Rv3;
  if (V_sy_sym.ub[0]==23) {
    P_insymbol();
    Ra.sl[6]=5914; /* line # 5914 */
    if (V_sy_sym.ub[0]==0) {
      Rv5=P_ide_search(898);
      if (Rv5!=V_ide_udptr.v[1]) {
        Ra.sl[6]=5919; /* line # 5919 */
        Rv6=Rv5;
        Rv7=NULL;
        if (((UB *)Rv6)[56]==7) {
          Ra.sl[6]=5924; /* line # 5924 */
          Rv7=((V *)Rv6)[9];
          if (Rv7==Rv0) P_src_error(Rd.s+1018,403,3);
        }
        else {
          Ra.sl[6]=5929; /* line # 5929 */
          if (((V *)Rv6)[11]!=((V *)Rv6)[10]&&((V *)Rv6)[11]!=NULL) P_src_error_s(
          Rd.s+1018,118,2, V_sy_ident.s,NULL);
          else {
            Rv8=((V *)Rv6)[10];
            if (((UB *)Rv8)[8]) P_src_error(Rd.s+1018,998,4);
            else {
              Ra.sl[6]=5934; /* line # 5934 */
              Rv7=((V *)Rv8)[2];
            }
          }
        }
        if (!P_comp_proc_arg(Rv7, Rv0)) P_src_error(Rd.s+1018,119,3);
        else((V *)Rv5)[8]=Rv7;
        Ra.sl[6]=5939; /* line # 5939 */
        P_insymbol();
      }
    }
    else P_src_error(Rd.s+1018,32,3);
  }
  else {
    Ra.sl[6]=5944; /* line # 5944 */
    Rv7=NULL;
  }
  P_ide_new_typ(6, &Rv9);
  Rv10=Rv9;
  Ra.sl[6]=5949; /* line # 5949 */
  ((V *)Rv10)[0]=NULL;
  memcpy(Rv10+48,V_typ_std.v[13]+48,1);
  ((SL *)Rv10)[11]=V_fptr_size;
  ((V *)Rv10)[12]=((V *)Rv0)[11];
  ((V *)Rv10)[13]=Rv0;
  Ra.sl[6]=5955; /* line # 5955 */
  Ret=Rv9;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " insert_new_generic "  */
void PAS_COMILER_PRC_00000050(V *F_pgfirst, V *F_pglast, V F_pg, UB F_bwfent){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1022;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=5966; /* line # 5966 */
  if (F_pg!=NULL) {
    if (F_bwfent&&(*F_pgfirst)!=NULL) P_src_error(Rd.s+1044,114,3);
    Ra.sl[6]=5971; /* line # 5971 */
    if (V_sy_generic_qmod) {
      if ((*F_pgfirst)==NULL) (*F_pgfirst)=F_pg;
      else((V *)(*F_pglast))[0]=F_pg;
      (*F_pglast)=F_pg;
    }
    else {
      Ra.sl[6]=5979; /* line # 5979 */
      ((V *)F_pg)[0]=(*F_pgfirst);
      (*F_pgfirst)=F_pg;
      if ((*F_pglast)==NULL) (*F_pglast)=F_pg;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " proc_decl "  */
void PAS_COMILER_PRC_00000052(V F_pgf, V F_pgl){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  UB Rv3;
  V Rv4;
  V Rv5;
  register V Rv6;
  register V Rv7;
  register V Rv8;
  register V Rv9;
  register V Rv10;
  UB Rv11;
  UB Rv12;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1048;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=6045; /* line # 6045 */
  Lx[3].ub[0]=0;
  Lx[3].v[1]=NULL;
  Rv0=NULL;
  P_insymbol();
  Ra.sl[6]=6050; /* line # 6050 */
  if (V_sy_sym.ub[0]==14) Lx[3].ub[16]=0;
  if (!Lx[3].ub[16]) {
    Lx[3].v[3]=PAS__NEW(245);
    Rv1=Lx[3].v[3];
    Ra.sl[6]=6056; /* line # 6056 */
    ((V *)Rv1)[0]=NULL;
    ((V *)Rv1)[1]=NULL;
    ((UW *)Rv1)[8]=0;
    ((V *)Rv1)[3]=NULL;
    ((UB *)Rv1)[32]=29;
    Ra.sl[6]=6061; /* line # 6061 */
    ((V *)Rv1)[5]=NULL;
    ((V *)Rv1)[6]=NULL;
    ((V *)Rv1)[7]=NULL;
    ((V *)Rv1)[8]=NULL;
    ((SL *)Rv1)[18]=V_curr_lex;
    Ra.sl[6]=6066; /* line # 6066 */
    ((SL *)Rv1)[19]=0;
    ((SL *)Rv1)[20]=0;
    ((V *)Rv1)[11]=NULL;
    ((V *)Rv1)[12]=NULL;
    ((UB *)Rv1)[104]=9;
    Ra.sl[6]=6072; /* line # 6072 */
    ((V *)Rv1)[14]=Lx[5].v[13];
    ((V *)Rv1)[15]=NULL;
    ((V *)Rv1)[16]=NULL;
    ((V *)Rv1)[17]=NULL;
    ((V *)Rv1)[18]=NULL;
    Ra.sl[6]=6077; /* line # 6077 */
    ((V *)Rv1)[19]=NULL;
    ((V *)Rv1)[20]=NULL;
    ((V *)Rv1)[21]=NULL;
    ((V *)Rv1)[22]=NULL;
    ((V *)Rv1)[23]=NULL;
    Ra.sl[6]=6082; /* line # 6082 */
    ((V *)Rv1)[24]=NULL;
    ((V *)Rv1)[25]=NULL;
    ((V *)Rv1)[26]=NULL;
    ((V *)Rv1)[27]=NULL;
    ((SL *)Rv1)[56]=-1;
    Ra.sl[6]=6087; /* line # 6087 */
    ((SL *)Rv1)[57]=0;
    ((SL *)Rv1)[58]=0;
    ((SL *)Rv1)[59]=0;
    ((SL *)Rv1)[60]=0;
    ((UB *)Rv1)[244]=0;
  }
  else {
    Ra.sl[6]=6095; /* line # 6095 */
    Rv2=Lx[3].v[3];
    Rv0=((V *)Rv2)[8];
    if (((V *)Rv2)[11]!=NULL) {
      if (!((UB *)((V *)Rv2)[11])[91]) {
        Ra.sl[6]=6100; /* line # 6100 */
        Rv0=((V *)Rv0)[3];
      }
    }
  }
  if (V_curr_lex<30) V_curr_lex=V_curr_lex+1;
  else {
    Ra.sl[6]=6105; /* line # 6105 */
    P_src_error(Rd.s+1061,1002,3);
  }
  P_new_disp_level(Lx[3].v[3],4);
  V_lex_ident_tree.v[V_curr_disp*8+1]=Rv0;
  V_lex_ident_level.sl[V_curr_lex]=V_curr_disp;
  Lx[3].sl[8]=V_curr_disp;
  Lx[3].sl[9]=V_curr_lex;
  Ra.sl[6]=6111; /* line # 6111 */
  if (!Lx[3].ub[16]) {
    Lx[3].ub[40]=PAS_COMILER_PRC_00000003(Lx[3].v+3,Lx[3].ub[41],Lx[3].ub[42]);
    Ra.sl[6]=6117; /* line # 6117 */
    if (V_sy_sym.ub[0]==19) P_insymbol();
    else P_src_error(Rd.s+1061,21,2);
    Ra.sl[6]=6122; /* line # 6122 */
    if (Lx[3].sl[11]!=0) {
      if (Lx[3].sl[11]>0) {
        if (((SL *)Lx[3].v[3])[20]!=Lx[3].sl[11]) P_src_error_s(Rd.s+1061,127,2,
        Lx[3].s+48,NULL);
        else {
          if (((SL *)Lx[3].v[3])[20]!=1&&((SL *)Lx[3].v[3])[20]!=2) {
            Ra.sl[6]=6127; /* line # 6127 */
            P_src_error_s(Rd.s+1061,127,2, Lx[3].s+48,NULL);
          }
        }
      }
    }
    Lx[3].v[1]=P_compare_proc_argid(F_pgf, F_pgl, Lx[3].v[3]);
    Rv3=Lx[3].v[1]==NULL;
    Ra.sl[6]=6132; /* line # 6132 */
    if (!Rv3) {
      Rv4=Lx[3].v[3];
      Lx[3].v[3]=((V *)Lx[3].v[1])[2];
      Rv0=((V *)Lx[3].v[3])[8];
      Ra.sl[6]=6137; /* line # 6137 */
      Rv5=((V *)Rv4)[8];
      while (Rv0!=NULL&&Rv5!=NULL){
        PAS__DISPOSE(((V *)Rv0));
        ((V *)Rv0)[0]=((V *)Rv5)[0];
        Ra.sl[6]=6142; /* line # 6142 */
        Rv0=((V *)Rv0)[3];
        Rv5=((V *)Rv5)[3];
      }
      Rv6=(V_lex_ident_tree.s+V_curr_disp*64);
      Rv7=Lx[3].v[3];
      P_free_ide_list(((V *)Rv4)+8);
      Ra.sl[6]=6147; /* line # 6147 */
      P_free_typ_list(((V *)Rv4)+12);
      ((V *)Rv6)[0]=Lx[3].v[3];
      ((V *)Rv6)[1]=((V *)Rv7)[6];
      Ra.sl[6]=6152; /* line # 6152 */
      ((V *)Rv6)[4]=((V *)Rv7)[7];
      ((V *)Rv6)[5]=((V *)Rv7)[12];
      Ra.sl[6]=6158; /* line # 6158 */
      Lx[3].v[1]=NULL;
      switch (((UB *)Lx[3].v[3])[104]) {
        case 2:if (Lx[3].ub[80]!=8) P_src_error_s(Rd.s+1061,100,2, Lx[3].s+48,NULL);
        break;
        case 7:Ra.sl[6]=6164; /* line # 6164 */
        if (Lx[3].ub[80]!=9) P_src_error_s(Rd.s+1061,100,2, Lx[3].s+48,NULL);
        break;
        default:P_src_error_s(Rd.s+1061,102,2, Lx[3].s+48,NULL);
        Lx[3].ub[80]=8;
        break;
      }
      Ra.sl[6]=6169; /* line # 6169 */
      PAS__DISPOSE(&Rv4);
      ((UB *)Lx[3].v[3])[104]=9;
    }
    else {
      Ra.sl[6]=6174; /* line # 6174 */
      Lx[3].v[1]=PAS__NEW(32);
      Rv8=Lx[3].v[1];
      ((V *)Rv8)[0]=NULL;
      ((UB *)Rv8)[8]=0;
      Ra.sl[6]=6179; /* line # 6179 */
      ((V *)Rv8)[2]=Lx[3].v[3];
      if (V_pro_d_first==NULL) V_pro_d_first=Lx[3].v[3];
      else((V *)V_pro_d_last)[1]=Lx[3].v[3];
      Ra.sl[6]=6184; /* line # 6184 */
      V_pro_d_last=Lx[3].v[3];
    }
  }
  else {
    Rv9=Lx[3].v[3];
    Ra.sl[6]=6190; /* line # 6190 */
    if (V_sy_sym.ub[0]==19) P_insymbol();
    else P_src_error(Rd.s+1061,21,2);
    if (((UB *)Rv9)[104]==2) Lx[3].ub[80]=8;
    ((UB *)Rv9)[104]=9;
  }
  Ra.sl[6]=6197; /* line # 6197 */
  Rv10=Lx[3].v[3];
  if (V_sy_sym.ub[0]==80) {
    if (Lx[3].ub[16]||((UB *)Rv10)[104]!=9) P_src_error_s(Rd.s+1061,128,2, Lx[3]
    .s+48,NULL);
    else {
      Ra.sl[6]=6202; /* line # 6202 */
      ((UB *)Rv10)[104]=7;
    }
    P_insymbol();
    if (V_sy_sym.ub[0]==5) P_set_stdname(Lx[3].v[3]);
    else {
      if (Lx[3].ub[81]&&((SL *)Rv10)[18]<=1) {
        Ra.sl[6]=6208; /* line # 6208 */
        ((UB *)Rv10)[32]=Lx[3].ub[82];
        ((V *)Rv10)[3]=PAS__NEW(32);
        if (((UB *)Rv10)[32]==29) memcpy(((V *)Rv10)[3],Lx[3].s+48,32);
        else {
          Ra.sl[6]=6213; /* line # 6213 */
          memcpy(((V *)Rv10)[3],(V_opname.s+Lx[3].ub[82]*32),32);
        }
      }
      else((V *)Rv10)[3]=P_new_int_name(Rd.s+1067,&V_proc_seq);
    }
    Ra.sl[6]=6218; /* line # 6218 */
    if (V_sy_sym.ub[0]==19) P_insymbol();
    else P_src_error(Rd.s+1061,21,2);
  }
  else {
    if (V_sy_sym.ub[0]==81||V_sy_sym.ub[0]==83&&V_sy_init_mod) {
      Ra.sl[6]=6224; /* line # 6224 */
      if (((UB *)Rv10)[104]!=9) P_src_error_s(Rd.s+1061,108,2, Lx[3].s+48,NULL);
      if (V_sy_sym.ub[0]==81) {
        Ra.sl[6]=6229; /* line # 6229 */
        ((UB *)Rv10)[104]=2;
        ((SL *)Rv10)[18]=1;
      }
      else {
        Ra.sl[6]=6235; /* line # 6235 */
        ((UB *)Rv10)[104]=1;
        ((SL *)Rv10)[18]=0;
      }
      P_insymbol();
      Ra.sl[6]=6240; /* line # 6240 */
      if (V_sy_sym.ub[0]==5) P_set_stdname(Lx[3].v[3]);
      else {
        if (Lx[3].ub[80]==((UB *)Rv10)[104]&&Lx[3].v[11]!=NULL) {
          Ra.sl[6]=6245; /* line # 6245 */
          ((V *)Rv10)[3]=Lx[3].v[11];
        }
        else {
          ((UB *)Rv10)[32]=Lx[3].ub[82];
          if (((UB *)Rv10)[32]==29) {
            Ra.sl[6]=6250; /* line # 6250 */
            P_set_gbl_def_nam(((V *)Rv10)+3,Lx[3].s+48,80);
          }
          else P_set_gbl_def_nam(((V *)Rv10)+3,(V_opname.s+Lx[3].ub[82]*32),80);
        }
      }
      Ra.sl[6]=6255; /* line # 6255 */
      if (V_sy_sym.ub[0]==19) P_insymbol();
      else P_src_error(Rd.s+1061,21,2);
    }
    else {
      Ra.sl[6]=6260; /* line # 6260 */
      Lx[3].ub[0]=1;
      if (Lx[3].ub[80]!=9) {
        ((UB *)Rv10)[104]=Lx[3].ub[80];
        Ra.sl[6]=6265; /* line # 6265 */
        ((SL *)Rv10)[18]=1;
        if (Lx[3].v[11]!=NULL) {
          if (Rv3) ((V *)Rv10)[3]=Lx[3].v[11];
          else {
            Ra.sl[6]=6270; /* line # 6270 */
            if (((V *)Rv10)[3]!=NULL) {
              if (P_match(((V *)Rv10)[3],Lx[3].v[11])!=0) P_src_error(Rd.s+1061,129,1);
            }
          }
        }
        else {
          Ra.sl[6]=6277; /* line # 6277 */
          if (((UB *)Rv10)[32]==29) P_set_gbl_def_nam(((V *)Rv10)+3,Lx[3].s+48,80);
          else P_set_gbl_def_nam(((V *)Rv10)+3,(V_opname.s+Lx[3].ub[82]*32),80);
        }
        Ra.sl[6]=6283; /* line # 6283 */
        switch (Lx[3].ub[80]) {
          case 2:Lx[3].ub[0]=0;
          break;
          case 8:if (Lx[3].sl[24]>1) P_src_error(Rd.s+1061,404,2);
          break;
          default:break;
        }
      }
      Ra.sl[6]=6292; /* line # 6292 */
      Rv11=0;
      Rv12=0;
      while (1){
        switch (V_sy_sym.ub[0]) {
          case 84:Ra.sl[6]=6298; /* line # 6298 */
          P_insymbol();
          ((UW *)Rv10)[8]=1;
          Rv12=1;
          break;
          case 5:
          case 82:Ra.sl[6]=6305; /* line # 6305 */
          if (V_sy_sym.ub[0]==82) {
            ((UB *)Rv10)[104]=8;
            P_insymbol();
          }
          if (V_sy_sym.ub[0]==5) P_set_stdname(Lx[3].v[3]);
          else P_src_error(Rd.s+1061,58,2);
          Rv12=1;
          break;
          default:Ra.sl[6]=6313; /* line # 6313 */
          Rv11=1;
          if (Rv12) {
            if (V_sy_sym.ub[0]==19) P_insymbol();
            else P_src_error(Rd.s+1061,21,2);
          }
          break;
        }
        if (Rv11)  break;
      }
      Ra.sl[6]=6320; /* line # 6320 */
      if (((V *)Rv10)[3]==NULL) {
        if (Lx[3].ub[81]&&((SL *)Rv10)[18]<=1) {
          ((UB *)Rv10)[32]=Lx[3].ub[82];
          Ra.sl[6]=6325; /* line # 6325 */
          ((V *)Rv10)[3]=PAS__NEW(32);
          if (((UB *)Rv10)[32]==29) memcpy(((V *)Rv10)[3],Lx[3].s+48,32);
          else memcpy(((V *)Rv10)[3],(V_opname.s+Lx[3].ub[82]*32),32);
        }
        else {
          Ra.sl[6]=6330; /* line # 6330 */
          ((V *)Rv10)[3]=P_new_int_name(Rd.s+1073,&V_proc_seq);
        }
      }
    }
  }
  V_curr_lex=Lx[3].sl[24];
  V_curr_disp=Lx[3].sl[25];
  Ra.sl[6]=6335; /* line # 6335 */
  Lx[5].v[1]=Lx[3].v[13];
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " proc_body "  */
void PAS_COMILER_PRC_00000053(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1077;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=6349; /* line # 6349 */
  V_curr_disp=Lx[3].sl[8];
  V_curr_lex=Lx[3].sl[9];
  Rv0=Lx[3].v[3];
  if (V_cmp_traceopt>0) {
    Ra.sl[6]=6355; /* line # 6355 */
    if (V_cmp_trace>=0) Rv1=3;
    else Rv1=5;
    V_cmp_trace=V_cmp_traceopt;
    P_gen_cntxvar(Lx[3].v[3],Lx[3].v[14]);
  }
  else {
    Ra.sl[6]=6362; /* line # 6362 */
    if (V_cmp_trace>0) V_cmp_trace=0;
  }
  P_lgt_all_fparm(Lx[3].v[3]);
  P_cmp_block(Lx[3].v[3],1, Rv1);
  Ra.sl[6]=6368; /* line # 6368 */
  if (V_sy_sym.ub[0]==73) P_insymbol();
  else P_src_error(Rd.s+1090,54,3);
  if (V_sy_sym.ub[0]==0) {
    if (Lx[3].ub[82]==29) {
      Ra.sl[6]=6373; /* line # 6373 */
      if (V_sy_sym.ub[0]==0&&P_match(Lx[3].s+48,V_sy_ident.s)==0) P_insymbol();
      else P_src_error_s(Rd.s+1090,71,2, V_sy_ident.s,NULL);
    }
    else {
      Ra.sl[6]=6379; /* line # 6379 */
      if (V_sy_sym.ub[0]==23&&Lx[3].ub[82]==28||V_sy_sym.ub[1]==Lx[3].ub[82]) P_insymbol();
      else P_src_error(Rd.s+1090,72,2);
    }
  }
  if (V_sy_sym.ub[0]!=19) P_src_error(Rd.s+1090,21,2);
  P_compile_set_sbttl(Lx[5].v[13]);
  Ra.sl[6]=6384; /* line # 6384 */
  if (V_sy_sym.ub[0]==19) P_insymbol();
  if (V_cmp_objf&&V_error_result<=1) {
    Ra.sl[6]=6390; /* line # 6390 */
    if (V_cmp_trace>0&&((V *)Rv0)[16]!=NULL) P_gen_linetrace(Lx[3].v[3],((V *)Rv0)
    +16,((V *)Rv0)+17,4);
    if (((V *)Rv0)[16]!=((V *)Rv0)[17]) {
      Ra.sl[6]=6395; /* line # 6395 */
      P_lgt_new(((V *)Rv0)+16,NULL,0,((V *)Rv0)[16]);
      ((UB *)((V *)Rv0)[16])[41]=2;
      ((V *)Rv0)[17]=((V *)Rv0)[16];
    }
    Ra.sl[6]=6400; /* line # 6400 */
    if (((UB *)Rv0)[104]==10) ((UW *)Rv0)[8]=((UW *)Rv0)[8]|129;
    else((UW *)Rv0)[8]=((UW *)Rv0)[8]|128;
    Ra.sl[6]=6406; /* line # 6406 */
    if (V_pro_last==NULL) V_pro_first=Lx[3].v[3];
    else((V *)V_pro_last)[0]=Lx[3].v[3];
    V_pro_last=Lx[3].v[3];
    Ra.sl[6]=6411; /* line # 6411 */
    PAS_COMILER_cmp_pass2(Lx[3].v[3]);
  }
  Ra.sl[6]=6416; /* line # 6416 */
  V_curr_lex=Lx[3].sl[24];
  V_curr_disp=Lx[3].sl[25];
  Lx[5].v[1]=Lx[3].v[13];
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " gene_decl "  */
void PAS_COMILER_PRC_00000051(){
  /* Define the automatic variable space. */
  Blk( Ra, 184 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  SL Rv4;
  register V Rv5;
  UB Rv6;
  register V Rv7;
  UB Rv8;
  register V Rv9;
  SL Rv10;
  V Rv11;
  UB Rv12;
  register V Rv13;
  V Rv14;
  register V Rv15;
  register int Rf0;
  register P Lx_Sv;
  Lx_Sv=Lx[3];
  Lx[3].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[15]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+120;
  Ra.v[16]=Rd.s+1094;
  Ra.v[17]=Rd.s+17;
  Ra.sl[36]=6424; /* line # 6424 */
  Ra.ub[16]=0;
  Ra.ub[42]=1;
  Ra.ub[40]=0;
  Ra.v[3]=NULL;
  Ra.ub[82]=29;
  Ra.sl[36]=6429; /* line # 6429 */
  Ra.ub[81]=0;
  Rv0=NULL;
  Rv1=NULL;
  Ra.sl[11]=0;
  Ra.v[13]=Lx[5].v[1];
  Ra.sl[36]=6434; /* line # 6434 */
  Ra.sl[24]=V_curr_lex;
  Ra.sl[25]=V_curr_disp;
  Ra.sl[36]=6439; /* line # 6439 */
  Ra.ub[80]=9;
  Ra.v[11]=NULL;
  if (Lx[5].ub[16]!=1) {
    switch (Lx[5].ub[16]) {
      case 3:
      case 4:Ra.sl[36]=6446; /* line # 6446 */
      if (Lx[5].ub[16]==3) Ra.ub[80]=8;
      else Ra.ub[80]=2;
      if (Lx[5].v[3]!=NULL) {
        Ra.v[11]=Lx[5].v[3];
        Lx[5].v[3]=NULL;
      }
      break;
      default:Ra.sl[36]=6452; /* line # 6452 */
      P_src_error(Rd.s+1090,81,2);
      break;
    }
    Lx[5].ub[16]=1;
    Lx[5].v[3]=NULL;
  }
  Ra.sl[36]=6458; /* line # 6458 */
  Ra.ub[41]=V_sy_sym.ub[0]==78;
  P_insymbol();
  switch (V_sy_sym.ub[0]) {
    case 0:Ra.sl[36]=6463; /* line # 6463 */
    memcpy(Ra.s+48,V_sy_ident.s,32);
    V_err_prt=0;
    Rv1=P_ide_search(770);
    V_err_prt=1;
    if (Rv1!=NULL) {
      Ra.sl[36]=6468; /* line # 6468 */
      if (((SL *)Rv1)[10]!=V_curr_lex) Rv0=NULL;
      else Rv0=Rv1;
    }
    else Rv0=NULL;
    if (Rv0!=NULL) {
      Ra.sl[36]=6473; /* line # 6473 */
      Rv2=Rv0;
      Ra.v[14]=((V *)Rv2)[0];
      switch (((UB *)Rv2)[56]) {
        case 1:
        case 8:
        case 9:Ra.sl[36]=6478; /* line # 6478 */
        if (((V *)Rv2)[9]!=NULL) {
          Ra.ub[16]=1;
          Ra.v[3]=((V *)Rv2)[9];
          Rv3=Ra.v[3];
          Ra.sl[36]=6483; /* line # 6483 */
          if (((UB *)Rv3)[104]==7||((UB *)Rv3)[104]==2) Ra.ub[42]=0;
        }
        break;
        default:Ra.sl[36]=6489; /* line # 6489 */
        P_src_error_s(Rd.s+1090,101,3,((V *)Rv2)[0],NULL);
        break;
      }
      PAS_COMILER_PRC_00000052(((V *)Rv2)[10],((V *)Rv2)[11]);
      Ra.sl[36]=6494; /* line # 6494 */
      PAS_COMILER_PRC_00000050(((V *)Rv2)+10,((V *)Rv2)+11,Ra.v[1],((UB *)Rv2)[56]
      ==8);
    }
    else {
      Ra.sl[36]=6518; /* line # 6518 */
      Ra.ub[42]=0;
      Ra.v[14]=PAS__NEW(32);
      ((UB *)Ra.v[14])[0]=V_sy_ident.ub[0];
      Ra.sl[36]=6523; /* line # 6523 */
      Rv4=1;
      for( Rf0=V_sy_ident.ub[0];Rf0>0;Rf0-- ) {
        ((C *)Ra.v[14])[Rv4]=V_sy_ident.c[Rv4];
        Rv4++;
      }
      Ra.ub[81]=Rv1==NULL;
      PAS_COMILER_PRC_00000052(NULL,NULL);
      Ra.sl[36]=6528; /* line # 6528 */
      memcpy(Ra.s+148,V_sy_ident.s,32);
      memcpy(V_sy_ident.s,Ra.s+48,32);
      if (Ra.ub[40]) {
        P_ide_new(8,((V *)Ra.v[3])[11],&Rv0);
        Ra.sl[36]=6533; /* line # 6533 */
        Rv5=Rv0;
        ((V *)Rv5)[10]=Ra.v[1];
        ((V *)Rv5)[11]=NULL;
        Ra.sl[36]=6538; /* line # 6538 */
        if (((UB *)Ra.v[3])[104]==7||((UB *)Ra.v[3])[104]==2) ((V *)Rv5)[9]=Ra.v[
3];
        else((V *)Rv5)[9]=NULL;
      }
      else {
        Ra.sl[36]=6546; /* line # 6546 */
        if (Rv1!=NULL) {
          Rv6=((UB *)Rv1)[56];
          ((V *)Ra.v[1])[0]=((V *)Rv1)[10];
        }
        else {
          Ra.sl[36]=6553; /* line # 6553 */
          Rv6=9;
          ((V *)Ra.v[1])[0]=NULL;
        }
        P_ide_new(Rv6,((V *)Ra.v[3])[11],&Rv0);
        Ra.sl[36]=6561; /* line # 6561 */
        Rv7=Rv0;
        ((V *)Rv7)[10]=Ra.v[1];
        ((V *)Rv7)[11]=Ra.v[1];
        if (((UB *)Ra.v[3])[104]==7) ((V *)Rv7)[9]=Ra.v[3];
        else {
          Ra.sl[36]=6566; /* line # 6566 */
          ((V *)Rv7)[9]=NULL;
        }
      }
      memcpy(V_sy_ident.s,Ra.s+148,32);
    }
    Ra.sl[36]=6573; /* line # 6573 */
    if (V_sy_init_mod) {
      Rv8=1;
      switch (V_sy_sym.ub[0]) {
        case 59:V_new_entry_proc=((V *)Ra.v[1])[2];
        break;
        case 60:Ra.sl[36]=6578; /* line # 6578 */
        V_newh_entry_proc=((V *)Ra.v[1])[2];
        break;
        case 61:V_dispose_entry_proc=((V *)Ra.v[1])[2];
        break;
        case 43:V_set_entry_proc=((V *)Ra.v[1])[2];
        break;
        case 62:V_iof_std_open=Rv0;
        break;
        case 40:Ra.sl[36]=6583; /* line # 6583 */
        V_iof_std_close=Rv0;
        break;
        case 63:V_inp_std_sel=Rv0;
        break;
        case 66:V_inp_std_gene=Rv0;
        break;
        case 67:V_inp_std_eoln=Rv0;
        break;
        case 36:V_inp_std_bin=Rv0;
        break;
        case 64:Ra.sl[36]=6588; /* line # 6588 */
        V_out_std_sel=Rv0;
        break;
        case 69:V_out_std_gene=Rv0;
        break;
        case 70:V_out_std_eoln=Rv0;
        break;
        case 37:V_out_std_bin=Rv0;
        break;
        case 42:Ra.sl[36]=6593; /* line # 6593 */
        V_gen_std_string1=Rv0;
        break;
        case 41:V_gen_std_cnfardsc=Rv0;
        break;
        default:Rv8=0;
        break;
      }
      Ra.sl[36]=6599; /* line # 6599 */
      if (Rv8) {
        P_insymbol();
        if (V_sy_sym.ub[0]==19) P_insymbol();
        else P_src_error(Rd.s+1090,21,2);
      }
    }
    Ra.sl[36]=6607; /* line # 6607 */
    if (Ra.v[3]!=NULL) ((V *)Ra.v[3])[5]=Rv0;
    break;
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 23:Ra.sl[36]=6620; /* line # 6620 */
    if (V_sy_sym.ub[0]==6) Ra.sl[11]=1;
    else Ra.sl[11]=2;
    if (V_sy_sym.ub[0]==23) {
      if (Ra.ub[41]) P_src_error(Rd.s+1090,115,3);
      Ra.sl[36]=6625; /* line # 6625 */
      Ra.ub[82]=28;
    }
    else {
      Ra.ub[82]=V_sy_sym.ub[1];
      if (!Ra.ub[41]) P_src_error(Rd.s+1090,116,3);
    }
    Ra.sl[36]=6631; /* line # 6631 */
    if (Ra.ub[82]==12) Ra.sl[11]=-1;
    memcpy(Ra.s+48,(V_opname.s+Ra.ub[82]*32),32);
    Ra.v[14]=PAS__NEW(32);
    Ra.sl[36]=6636; /* line # 6636 */
    Rv9=(V_opname.s+Ra.ub[82]*32);
    ((UB *)Ra.v[14])[0]=((UB *)Rv9)[0]+2;
    ((C *)Ra.v[14])[1]=79;
    ((C *)Ra.v[14])[2]=95;
    Ra.sl[36]=6641; /* line # 6641 */
    Rv10=1;
    for( Rf0=((UB *)Rv9)[0];Rf0>0;Rf0-- ) {
      ((C *)Ra.v[14])[(2+Rv10)]=((C *)Rv9)[Rv10];
      Rv10++;
    }
    Rv11=V_ope_table.v[Ra.ub[82]];
    if (Rv11!=NULL) Rv12=((SL *)Rv11)[1]==V_curr_lex;
    else {
      Ra.sl[36]=6646; /* line # 6646 */
      Rv12=0;
    }
    if (Rv12) {
      Rv13=Rv11;
      Ra.v[3]=NULL;
      Ra.sl[36]=6651; /* line # 6651 */
      PAS_COMILER_PRC_00000052(((V *)Rv13)[3],((V *)Rv13)[4]);
      PAS_COMILER_PRC_00000050(((V *)Rv13)+3,((V *)Rv13)+4,Ra.v[1],0);
    }
    else {
      Ra.sl[36]=6664; /* line # 6664 */
      Ra.v[3]=NULL;
      PAS_COMILER_PRC_00000052(NULL,NULL);
      if (Ra.v[1]!=NULL) {
        Rv14=PAS__NEW(40);
        Ra.sl[36]=6669; /* line # 6669 */
        Rv15=Rv14;
        ((UB *)Rv15)[0]=Ra.ub[82];
        ((SL *)Rv15)[1]=V_curr_lex;
        ((V *)Rv15)[1]=((V *)Lx[5].v[13])[19];
        Ra.sl[36]=6674; /* line # 6674 */
        ((V *)Rv15)[2]=Rv11;
        ((V *)Rv15)[3]=Ra.v[1];
        ((V *)Rv15)[4]=Ra.v[1];
        if (Rv11==NULL) ((V *)Ra.v[1])[0]=NULL;
        else {
          Ra.sl[36]=6680; /* line # 6680 */
          ((V *)Ra.v[1])[0]=((V *)Rv11)[3];
        }
      }
      ((V *)Lx[5].v[13])[19]=Rv14;
      V_ope_table.v[Ra.ub[82]]=Rv14;
    }
    Ra.sl[36]=6687; /* line # 6687 */
    if (Ra.v[3]!=NULL) ((UB *)Ra.v[3])[32]=Ra.ub[82];
    break;
    default:Ra.sl[36]=6697; /* line # 6697 */
    P_src_error(Rd.s+1090,117,3);
    break;
  }
  if (Ra.ub[0]) PAS_COMILER_PRC_00000053();
  PAS__curr_cntx=Ra.v[15];
  Lx[3]=Lx_Sv;
}


/* Procedure/Function : " gen_assign "  */
V PAS_COMILER_PRC_00000054(V F_target, UB F_bovr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  register V Rv2;
  UB Rv3;
  V Rv4;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1105;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=6727; /* line # 6727 */
  Rv0=V_sy_label_flag;
  V_sy_label_flag=0;
  Rv1=PAS_COMILER_PRC_00000000();
  Ra.sl[6]=6733; /* line # 6733 */
  V_sy_label_flag=Rv0;
  ((V *)F_target)[0]=Rv1;
  if (((UB *)F_target)[40]==8) {
    Rv2=((V *)F_target)[6];
    Ra.sl[6]=6739; /* line # 6739 */
    Rv3=1;
    if (((V *)Rv2)[11]!=NULL) {
      if (((UB *)((V *)Rv2)[11])[92]==24) Rv3=0;
    }
    if (Rv3) P_src_error(Rd.s+1119,175,3);
  }
  Ra.sl[6]=6744; /* line # 6744 */
  Rv4=P_lgt_gen_store(F_target,0, F_bovr);
  Ret=Rv4;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " returnstate "  */
V PAS_COMILER_PRC_00000055(V F_ip){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  V Rv3;
  register V Rv4;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1123;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=6763; /* line # 6763 */
  Rv0=NULL;
  Rv1=PAS_COMILER_PRC_00000023();
  if (Rv1!=NULL) {
    Rv2=Rv1;
    Ra.sl[6]=6769; /* line # 6769 */
    if (((V *)Rv2)[11]==NULL) {
      if (F_ip!=NULL) {
        P_src_error_s(Rd.s+1138,172,3,((V *)F_ip)[0],NULL);
        Ra.sl[6]=6774; /* line # 6774 */
        P_skip_symbol(19,0,0);
      }
      else {
        P_lgt_new(&Rv0,NULL,0,NULL);
        Ra.sl[6]=6779; /* line # 6779 */
        ((UB *)Rv0)[41]=7;
      }
    }
    else {
      Rv3=NULL;
      Ra.sl[6]=6784; /* line # 6784 */
      Lx[5].ub[40]=1;
      if (F_ip!=NULL) {
        if (F_ip!=((V *)Rv2)[5]) {
          Ra.sl[6]=6789; /* line # 6789 */
          P_src_error_s(Rd.s+1138,405,3,((V *)F_ip)[0],NULL);
          P_skip_symbol(19,0,0);
        }
      }
      Ra.sl[6]=6794; /* line # 6794 */
      if (((UB *)((V *)Rv2)[11])[91]) {
        P_lgt_new(&Rv3,((V *)Rv2)[11],12,NULL);
        ((V *)Rv3)[6]=Rv1;
        if (F_ip!=NULL) {
          Ra.sl[6]=6799; /* line # 6799 */
          if (V_sy_sym.ub[0]==23) P_insymbol();
          else P_src_error(Rd.s+1138,32,2);
        }
      }
      else {
        Ra.sl[6]=6804; /* line # 6804 */
        if (F_ip==NULL||V_sy_sym.ub[0]==23) {
          Rv3=P_lgt_new_idref(((V *)Rv2)[8],NULL);
          Rv4=((V *)Rv2)[8];
          if ((((UB *)((V *)Rv4)[4])[89]||((UB *)((V *)Rv4)[4])[90])&&!(16&((UW *)
          Rv4)[46])) {
            Ra.sl[6]=6810; /* line # 6810 */
            P_init_d_varbl(((V *)Rv2)[8]);
          }
          if (F_ip!=NULL) P_insymbol();
        }
        else {
          Ra.sl[6]=6815; /* line # 6815 */
          V_sy_search=((V *)Rv2)[8];
          V_lastsymb=V_sy_sym.ub[0];
          V_sy_sym.ub[0]=0;
          Rv3=PAS_COMILER_PRC_00000000();
          if (V_sy_sym.ub[0]==23) P_insymbol();
          else {
            Ra.sl[6]=6820; /* line # 6820 */
            P_src_error(Rd.s+1138,32,2);
          }
        }
      }
      Ra.sl[6]=6825; /* line # 6825 */
      Rv0=PAS_COMILER_PRC_00000054(Rv3,1);
      if (F_ip==NULL) {
        P_lgt_new(&Rv0,NULL,0, Rv0);
        Ra.sl[6]=6830; /* line # 6830 */
        ((UB *)Rv0)[41]=7;
      }
    }
  }
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " assignmentstate "  */
V PAS_COMILER_PRC_00000056(V F_ip){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  V Rv2;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1142;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=6847; /* line # 6847 */
  V_sy_search=F_ip;
  V_lastsymb=V_sy_sym.ub[0];
  V_sy_sym.ub[0]=0;
  Rv0=PAS_COMILER_PRC_00000000();
  Ra.sl[6]=6852; /* line # 6852 */
  Rv1=Rv0;
  switch (((UB *)Rv1)[40]) {
    case 1:
    case 2:
    case 3:
    case 7:
    case 8:
    case 13:Ra.sl[6]=6864; /* line # 6864 */
    if (((V *)Rv1)[3]==V_typ_std.v[28]&&((UB *)Rv1)[40]==7) Rv2=Rv0;
    else {
      if (!(2&((UW *)Rv1)[10])) {
        Ra.sl[6]=6870; /* line # 6870 */
        P_src_error(Rd.s+1161,173,2);
      }
      if (V_sy_sym.ub[0]!=23) P_src_error(Rd.s+1161,32,2);
      else P_insymbol();
      Rv2=PAS_COMILER_PRC_00000054(Rv0,0);
    }
    break;
    default:Ra.sl[6]=6879; /* line # 6879 */
    P_src_error(Rd.s+1161,174,3);
    P_skip_symbol(19,0,0);
    P_lgt_free_tree(&Rv0);
    Rv2=NULL;
    break;
  }
  Ra.sl[6]=6884; /* line # 6884 */
  Ret=Rv2;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " with_state "  */
V PAS_COMILER_PRC_00000057(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  V Rv1;
  UB Rv2;
  V Rv3;
  UB Rv4;
  UB Rv5;
  V Rv6;
  V Rv7;
  register V Rv8;
  register V Rv9;
  UB Rv10;
  V Rv11;
  register V Rv12;
  register V Rv13;
  register V Rv14;
  V Rv15;
  register V Rv16;
  V Rv17;
  V Rv18;
  register V Rv19;
  UB Rv20;
  register V Rv21;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1165;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=6902; /* line # 6902 */
  Rv0=0;
  Rv1=NULL;
  Rv2=1;
  while (1){
    Ra.sl[6]=6907; /* line # 6907 */
    Rv3=PAS_COMILER_PRC_00000000();
    Rv4=0;
    Rv5=0;
    Rv6=NULL;
    Rv7=((V *)Rv3)[3];
    Ra.sl[6]=6913; /* line # 6913 */
    Rv8=Rv7;
    Rv9=Rv3;
    if (((((UB *)Rv8)[92]==5||((UB *)Rv8)[92]==7)||((UB *)Rv8)[92]==24)&&((V *)Rv8)
    [12]!=NULL) {
      Ra.sl[6]=6920; /* line # 6920 */
      Rv10=1;
      Rv4=1;
      Rv6=Rv7;
      Rv7=((V *)Rv6)[12];
    }
    else {
      Ra.sl[6]=6927; /* line # 6927 */
      Rv10=((UB *)Rv9)[40]!=14&&((UB *)Rv9)[40]!=13;
    }
    if (((UB *)Rv7)[92]!=10) Rv7=NULL;
    Rv2=Rv7==NULL;
    Ra.sl[6]=6933; /* line # 6933 */
    if (Rv2) {
      P_src_error(Rd.s+1179,176,3);
      P_skip_symbol(73,0,0);
    }
    else {
      Ra.sl[6]=6939; /* line # 6939 */
      if (Rv10) {
        if (!Rv4) {
          if (((UB *)Rv3)[40]==2&&((SL *)Rv3)[4]==0) {
            Ra.sl[6]=6944; /* line # 6944 */
            Rv11=((V *)Rv3)[1];
            P_lgt_free(&Rv3);
            Rv6=((V *)Rv11)[3];
            Rv3=Rv11;
          }
          else {
            Ra.sl[6]=6951; /* line # 6951 */
            if (Rv6==NULL) P_ide_new_typ(5, &Rv6);
            Rv12=Rv6;
            memcpy(Rv12+48,V_typ_std.v[13]+48,1);
            Ra.sl[6]=6956; /* line # 6956 */
            ((SL *)Rv12)[11]=V_fptr_size;
            ((V *)Rv12)[12]=Rv7;
            P_lgt_new(&Rv3, Rv6,4, Rv3);
          }
        }
        Ra.sl[6]=6964; /* line # 6964 */
        Rv5=1;
        P_lgt_new(&Rv11, Rv6,13,NULL);
        P_all_new(((V *)Rv11)+7,Rv6,NULL,0);
        Ra.sl[6]=6969; /* line # 6969 */
        ((V *)Rv11)[0]=Rv3;
        Rv3=P_lgt_new_code(3, Rv11);
        ((SL *)Rv3)[4]=0;
        ((V *)Rv3)[0]=Rv1;
        Rv1=Rv3;
      }
      else {
        Ra.sl[6]=6977; /* line # 6977 */
        Rv11=Rv3;
      }
    }
    Ra.sl[6]=6982; /* line # 6982 */
    if (V_curr_disp<64) {
      Rv0=Rv0+1;
      P_new_disp_level(NULL,1);
      Rv13=(V_lex_ident_tree.s+V_curr_disp*64);
      Ra.sl[6]=6988; /* line # 6988 */
      ((V *)Rv13)[2]=Rv11;
      Rv14=Rv7;
      if (((V *)Rv14)[4]!=NULL) {
        Rv15=((V *)Rv14)[4];
        Ra.sl[6]=6993; /* line # 6993 */
        while (Rv15!=NULL){
          ((UB *)Rv15)[64]=3;
          Rv15=((V *)Rv15)[3];
        }
        Ra.sl[6]=6998; /* line # 6998 */
        ((V *)Rv13)[1]=((V *)Rv14)[4];
      }
      else((V *)Rv13)[1]=((V *)Rv14)[12];
      Ra.sl[6]=7003; /* line # 7003 */
      ((SL *)Rv13)[13]=0;
      if (Rv10) {
        if (Rv5) ((UB *)Rv13)[24]=2;
        else((UB *)Rv13)[24]=3;
      }
      else((UB *)Rv13)[24]=1;
      Ra.sl[6]=7008; /* line # 7008 */
      if (((V *)Rv7)[4]!=NULL&&((UB *)Rv7)[92]==10) {
        Rv0=Rv0+1;
        P_new_disp_level(NULL,1);
        Ra.sl[6]=7013; /* line # 7013 */
        memcpy((V_lex_ident_tree.s+V_curr_disp*64),(V_lex_ident_tree.s+(V_curr_disp-
1)*64),60);
        Rv16=(V_lex_ident_tree.s+V_curr_disp*64);
        ((V *)Rv16)[1]=((V *)Rv7)[12];
        ((SL *)Rv16)[13]=-1;
      }
    }
    else {
      Ra.sl[6]=7023; /* line # 7023 */
      P_src_error(Rd.s+1179,1003,4);
    }
    if (V_sy_sym.ub[0]==18) P_insymbol();
    if (V_sy_sym.ub[0]!=0)  break;
  }
  Ra.sl[6]=7028; /* line # 7028 */
  if (V_sy_sym.ub[0]==54) P_insymbol();
  else P_src_error(Rd.s+1179,55,2);
  Rv17=V_cntx_label;
  V_cntx_lblvl=V_cntx_lblvl+1;
  Ra.sl[6]=7033; /* line # 7033 */
  Rv18=PAS_COMILER_PRC_00000037(NULL,1);
  if (Rv18!=NULL) {
    Rv19=Rv18;
    if (((UB *)Rv19)[40]==0) {
      Ra.sl[6]=7038; /* line # 7038 */
      switch (((UB *)Rv19)[41]) {
        case 0:
        case 2:Rv20=1;
        break;
        default:Ra.sl[6]=7043; /* line # 7043 */
        Rv20=0;
        break;
      }
    }
    else Rv20=0;
  }
  else P_lgt_new(&Rv18,NULL,16,NULL);
  Ra.sl[6]=7049; /* line # 7049 */
  P_label_purge(&Rv17);
  while (Rv0>0){
    Ra.sl[6]=7054; /* line # 7054 */
    Rv21=(V_lex_ident_tree.s+V_curr_disp*64);
    if (((SL *)Rv21)[13]>=0) {
      if (((SL *)Rv21)[13]==0) {
        Ra.sl[6]=7059; /* line # 7059 */
        switch (((UB *)Rv21)[24]) {
          case 1:
          case 3:P_lgt_free_tree(((V *)Rv21)+2);
          break;
          case 2:Ra.sl[6]=7066; /* line # 7066 */
          Rv3=Rv1;
          Rv1=((V *)Rv3)[0];
          ((V *)Rv3)[0]=NULL;
          P_all_free(((V *)((V *)Rv21)[2])[7]);
          ((V *)Rv21)[2]=NULL;
          Ra.sl[6]=7071; /* line # 7071 */
          P_lgt_free_tree(&Rv3);
          break;
          default:break;
        }
      }
      else {
        Ra.sl[6]=7077; /* line # 7077 */
        if (((UB *)Rv21)[24]==2) {
          Rv3=Rv1;
          Rv1=((V *)Rv3)[0];
          Ra.sl[6]=7082; /* line # 7082 */
          if (Rv20) {
            ((V *)Rv3)[0]=((V *)Rv18)[1];
            ((V *)Rv18)[1]=Rv3;
          }
          else {
            Ra.sl[6]=7089; /* line # 7089 */
            Rv20=1;
            ((V *)Rv3)[0]=Rv18;
            P_lgt_new(&Rv18,NULL,0, Rv3);
            ((UB *)Rv18)[41]=2;
          }
        }
      }
    }
    Ra.sl[6]=7096; /* line # 7096 */
    Rv15=((V *)Rv21)[1];
    if (((UB *)Rv15)[56]==2) while (Rv15!=NULL){
      Ra.sl[6]=7101; /* line # 7101 */
      ((UB *)Rv15)[64]=0;
      ((V *)Rv15)[10]=NULL;
      Rv15=((V *)Rv15)[3];
    }
    Ra.sl[6]=7106; /* line # 7106 */
    V_curr_disp=V_curr_disp -1;
    Rv0=Rv0-1;
  }
  Ret=Rv18;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " ifstate "  */
V PAS_COMILER_PRC_00000058(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  V Rv3;
  register V Rv4;
  V Rv5;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1183;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=7124; /* line # 7124 */
  Rv0=PAS_COMILER_PRC_00000005(V_typ_std.v[1],0,1,0);
  Rv1=NULL;
  Rv2=NULL;
  Rv3=V_cntx_label;
  Rv4=Rv0;
  Ra.sl[6]=7130; /* line # 7130 */
  if (V_sy_sym.ub[0]==46) P_insymbol();
  else P_src_error(Rd.s+1194,56,2);
  V_cntx_lblvl=V_cntx_lblvl+1;
  Rv1=PAS_COMILER_PRC_00000037(NULL,1);
  P_label_purge(&Rv3);
  Ra.sl[6]=7135; /* line # 7135 */
  if (V_sy_sym.ub[0]!=19) {
    if (V_sy_sym.ub[0]==47) {
      P_insymbol();
      V_cntx_lblvl=V_cntx_lblvl+1;
      Ra.sl[6]=7140; /* line # 7140 */
      Rv2=PAS_COMILER_PRC_00000037(NULL,1);
      P_label_purge(&Rv3);
    }
  }
  if (Rv1==NULL&&Rv2==NULL) {
    Ra.sl[6]=7146; /* line # 7146 */
    P_lgt_free(&Rv0);
    Rv5=NULL;
  }
  else {
    if (((UB *)Rv4)[40]==14) {
      Ra.sl[6]=7152; /* line # 7152 */
      if (((SL *)((V *)Rv4)[7])[13]>0) {
        Rv5=Rv1;
        P_lgt_free_tree(&Rv2);
      }
      else {
        Ra.sl[6]=7159; /* line # 7159 */
        Rv5=Rv2;
        P_lgt_free_tree(&Rv1);
      }
      P_lgt_free(&Rv0);
    }
    else {
      Ra.sl[6]=7167; /* line # 7167 */
      if (Rv1==NULL) {
        Rv0=P_exp_genop(0, Rv0);
        ((V *)Rv0)[0]=Rv2;
      }
      else {
        Ra.sl[6]=7174; /* line # 7174 */
        ((V *)Rv0)[0]=Rv1;
        ((V *)Rv1)[0]=Rv2;
      }
      P_lgt_new(&Rv5,NULL,0, Rv0);
      ((UB *)Rv5)[41]=8;
    }
  }
  Ra.sl[6]=7182; /* line # 7182 */
  Ret=Rv5;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exitstate "  */
V PAS_COMILER_PRC_00000059(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  register V Rv3;
  V Rv4;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1198;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=7196; /* line # 7196 */
  P_lgt_new(&Rv0,NULL,16, Lx[5].v[6]);
  if (Lx[5].v[6]==NULL) P_src_error(Rd.s+1211,244,2);
  Ra.sl[6]=7201; /* line # 7201 */
  P_lgt_new(&Rv1,NULL,0, Rv0);
  ((UB *)Rv1)[41]=6;
  if (V_sy_sym.ub[0]==2) P_ide_int_label();
  if (V_sy_sym.ub[0]==0) {
    Ra.sl[6]=7206; /* line # 7206 */
    Rv2=P_ide_search(8);
    if (Rv2==V_ide_udptr.v[3]) Rv2=NULL;
    if (Rv2!=NULL) {
      Rv3=Rv2;
      Ra.sl[6]=7212; /* line # 7212 */
      Rv4=V_cntx_label;
      while (Rv4!=NULL&&Rv4!=Rv2)
      Rv4=((V *)Rv4)[9];
      if (Rv4==NULL) P_src_error(Rd.s+1211,177,3);
      Ra.sl[6]=7217; /* line # 7217 */
      ((UB *)Rv3)[57]=((UB *)Rv3)[57]|2;
      ((V *)Rv0)[1]=((V *)Rv3)[11];
    }
    Ra.sl[6]=7226; /* line # 7226 */
    P_insymbol();
  }
  if (V_sy_sym.ub[0]==45) {
    Ra.sl[6]=7231; /* line # 7231 */
    P_insymbol();
    ((V *)Rv0)[0]=PAS_COMILER_PRC_00000005(V_typ_std.v[1],0,0,0);
  }
  Ra.sl[6]=7236; /* line # 7236 */
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " loopstate "  */
V PAS_COMILER_PRC_00000060(UB F_symb){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  V Rv3;
  V Rv4;
  V Rv5;
  V Rv6;
  register V Rv7;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1215;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=7252; /* line # 7252 */
  Rv0=Lx[5].v[6];
  P_lgt_new(Lx[5].v+6,NULL,0,NULL);
  ((UB *)Lx[5].v[6])[41]=4;
  Rv1=Lx[5].v[6];
  if (F_symb==48) {
    Ra.sl[6]=7258; /* line # 7258 */
    Rv2=PAS_COMILER_PRC_00000005(V_typ_std.v[1],0,0,0);
    if (V_sy_sym.ub[0]==54) P_insymbol();
    else P_src_error(Rd.s+1228,55,2);
  }
  else {
    Ra.sl[6]=7263; /* line # 7263 */
    P_lgt_new(&Rv2,NULL,16,NULL);
  }
  ((V *)Rv1)[1]=Rv2;
  Ra.sl[6]=7268; /* line # 7268 */
  Rv3=Lx[4].v[0];
  if (Rv3!=NULL) ((V *)Rv3)[11]=Lx[5].v[6];
  Rv4=V_cntx_label;
  Ra.sl[6]=7273; /* line # 7273 */
  V_cntx_lblvl=V_cntx_lblvl+1;
  switch (F_symb) {
    case 48:((V *)Rv2)[0]=PAS_COMILER_PRC_00000037(NULL,1);
    break;
    case 49:Ra.sl[6]=7281; /* line # 7281 */
    Rv5=PAS_COMILER_PRC_00000036(50,0);
    if (V_sy_sym.ub[0]==50) P_insymbol();
    else P_src_error(Rd.s+1228,57,2);
    Ra.sl[6]=7286; /* line # 7286 */
    P_lgt_new(&Rv6,NULL,16,NULL);
    Rv7=Rv6;
    ((V *)Rv7)[0]=PAS_COMILER_PRC_00000005(V_typ_std.v[1],0,0,0);
    ((V *)Rv7)[1]=Lx[5].v[6];
    Ra.sl[6]=7292; /* line # 7292 */
    P_lgt_new(&Rv6,NULL,0, Rv6);
    ((UB *)Rv6)[41]=6;
    if (Rv5!=NULL) {
      ((V *)Lx[5].v[7])[0]=Rv6;
      Ra.sl[6]=7297; /* line # 7297 */
      ((V *)Rv2)[0]=Rv5;
    }
    else((V *)Rv2)[0]=Rv6;
    break;
    case 55:Ra.sl[6]=7305; /* line # 7305 */
    ((V *)Rv2)[0]=PAS_COMILER_PRC_00000036(73,0);
    if (V_sy_sym.ub[0]!=73) P_src_error(Rd.s+1228,54,2);
    else P_insymbol();
    if (V_sy_sym.ub[0]==0) {
      if (Rv3==P_ide_search(8)) {
        Ra.sl[6]=7310; /* line # 7310 */
        P_insymbol();
      }
      else P_src_error_s(Rd.s+1228,179,2, V_sy_ident.s,NULL);
    }
    break;
  }
  Ra.sl[6]=7315; /* line # 7315 */
  P_label_purge(&Rv4);
  Lx[5].v[6]=Rv0;
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " forstate "  */
V PAS_COMILER_PRC_00000061(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  SL Rv3;
  V Rv4;
  V Rv5;
  UB Rv6;
  V Rv7;
  V Rv8;
  V Rv9;
  V Rv10;
  register V Rv11;
  V Rv12;
  register V Rv13;
  register V Ret;

  /* Code of procedure/function */
  Rv0=NULL;
  Rv1=NULL;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1232;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=7337; /* line # 7337 */
  Rv2=Lx[5].v[6];
  Rv3=V_curr_disp;
  Rv4=V_cntx_label;
  P_new_disp_level(Lx[5].v[13],0);
  Ra.sl[6]=7342; /* line # 7342 */
  if (V_sy_sym.ub[0]!=0) P_src_error(Rd.s+1244,168,2);
  else {
    P_ide_new(5,NULL,&Rv5);
    P_insymbol();
    Ra.sl[6]=7347; /* line # 7347 */
    if (V_sy_sym.ub[0]==23) P_insymbol();
    else P_src_error(Rd.s+1244,32,2);
    V_sy_fix_range_ctl=0;
    Rv0=PAS_COMILER_PRC_00000005(V_typ_std.v[15],0,1,0);
    Ra.sl[6]=7352; /* line # 7352 */
    switch (V_sy_sym.ub[0]) {
      case 52:P_insymbol();
      Rv6=38;
      break;
      case 53:Ra.sl[6]=7361; /* line # 7361 */
      P_insymbol();
      Rv6=39;
      break;
      default:Ra.sl[6]=7366; /* line # 7366 */
      P_src_error(Rd.s+1244,59,2);
      Rv6=38;
      break;
    }
    Rv7=PAS_COMILER_PRC_00000005(((V *)Rv0)[3],0,1,0);
    Ra.sl[6]=7372; /* line # 7372 */
    if (V_sy_sym.ub[0]==54) P_insymbol();
    else P_src_error(Rd.s+1244,55,2);
    P_lgt_new(Lx[5].v+6,V_typ_std.v[2],0,NULL);
    ((UB *)Lx[5].v[6])[41]=5;
    Ra.sl[6]=7378; /* line # 7378 */
    if (Rv6==39) {
      Rv8=Rv7;
      if (((UB *)Rv0)[40]==14) P_lgt_new_copy(Rv0, &Rv7);
      else {
        Ra.sl[6]=7383; /* line # 7383 */
        Rv7=Rv0;
      }
    }
    else {
      if (((UB *)Rv0)[40]==14) P_lgt_new_copy(Rv0, &Rv8);
      else {
        Ra.sl[6]=7388; /* line # 7388 */
        Rv8=Rv0;
      }
    }
    if (((UB *)Rv8)[40]==14) {
      Rv9=Rv7;
      Ra.sl[6]=7393; /* line # 7393 */
      Rv10=P_lgt_new_econst(((V *)Rv8)[3],((SL *)((V *)Rv8)[7])[13]-1);
    }
    else {
      Rv10=Rv8;
      Ra.sl[6]=7398; /* line # 7398 */
      if (((UB *)Rv7)[40]==14) Rv9=P_lgt_new_econst(((V *)Rv7)[3],((SL *)((V *)Rv7)
      [7])[13]+1);
      else {
        ((V *)Rv7)[0]=P_lgt_new_econst(V_typ_std.v[2],1);
        Ra.sl[6]=7403; /* line # 7403 */
        Rv9=P_lgt_new_code(49, Rv7);
      }
    }
    Rv7=P_lgt_new_addsub(1,1, Rv9, Rv10);
    Ra.sl[6]=7410; /* line # 7410 */
    ((V *)Lx[5].v[6])[1]=Rv7;
    V_sy_fix_range_ctl=1;
    Rv11=Rv5;
    Ra.sl[6]=7416; /* line # 7416 */
    ((V *)Rv11)[4]=((V *)Rv8)[3];
    ((UW *)Rv11)[46]=32;
    ((UB *)Rv11)[94]=1;
    Ra.sl[6]=7421; /* line # 7421 */
    Rv12=Lx[4].v[0];
    if (Rv12!=NULL) {
      Rv13=Rv12;
      ((V *)Rv13)[9]=V_cntx_label;
      Ra.sl[6]=7426; /* line # 7426 */
      V_cntx_label=Rv12;
      ((V *)Rv13)[11]=Lx[5].v[6];
    }
    V_cntx_lblvl=V_cntx_lblvl+1;
    Ra.sl[6]=7433; /* line # 7433 */
    Rv8=PAS_COMILER_PRC_00000037(NULL,1);
    ((V *)Rv7)[0]=Rv8;
    if (1&((UW *)Rv5)[46]) {
      Ra.sl[6]=7441; /* line # 7441 */
      Rv0=P_lgt_link(Rv0);
      Rv0=P_lgt_new_idref(Rv5, Rv0);
      Rv0=P_lgt_new_code(3, Rv0);
      ((V *)Rv0)[0]=Lx[5].v[6];
      Ra.sl[6]=7446; /* line # 7446 */
      P_lgt_new(Lx[5].v+6,NULL,0, Rv0);
      ((UB *)Lx[5].v[6])[41]=2;
      Rv0=P_lgt_new_idref(Rv5,NULL);
      Ra.sl[6]=7451; /* line # 7451 */
      Rv0=P_lgt_new_code(Rv6, Rv0);
      ((V *)Rv0)[3]=Rv1;
      if (Rv8!=NULL) ((V *)Rv8)[0]=Rv0;
      else((V *)Rv7)[0]=Rv0;
    }
    else {
      Ra.sl[6]=7458; /* line # 7458 */
      if (((UB *)Rv0)[40]==14) P_lgt_free(&Rv0);
    }
    Rv0=Lx[5].v[6];
  }
  Ra.sl[6]=7463; /* line # 7463 */
  Lx[5].v[6]=Rv2;
  if (V_curr_disp>Rv3) P_ide_reserve_disp(Rv3);
  Ra.sl[6]=7468; /* line # 7468 */
  P_label_purge(&Rv4);
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " gotostate "  */
V PAS_COMILER_PRC_00000062(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  register V Rv4;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1248;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=7482; /* line # 7482 */
  Rv0=NULL;
  if (V_sy_sym.ub[0]==2) P_ide_int_label();
  if (V_sy_sym.ub[0]!=0) P_src_error(Rd.s+1261,69,3);
  V_err_prt=0;
  Rv1=P_ide_search(8);
  Ra.sl[6]=7487; /* line # 7487 */
  V_err_prt=1;
  if (Rv1==NULL) {
    P_ide_new(3,NULL,&Rv1);
    Ra.sl[6]=7492; /* line # 7492 */
    Rv2=Lx[5].v[13];
    if (((V *)Rv2)[20]==NULL) ((V *)Rv2)[20]=Rv1;
    else((V *)Lx[5].v[4])[8]=Rv1;
    Lx[5].v[4]=Rv1;
  }
  Ra.sl[6]=7497; /* line # 7497 */
  P_lgt_new(&Rv0,NULL,0,NULL);
  Rv3=Rv0;
  Rv4=Rv1;
  if (((SL *)Rv4)[10]!=V_curr_lex) {
    Ra.sl[6]=7502; /* line # 7502 */
    ((UB *)Rv3)[41]=10;
    ((UB *)Rv4)[57]=((UB *)Rv4)[57]|12;
  }
  else {
    Ra.sl[6]=7508; /* line # 7508 */
    ((UB *)Rv4)[57]=((UB *)Rv4)[57]|4;
    if (32&((UB *)Rv4)[57]) P_src_error(Rd.s+1261,70,2);
    else {
      Ra.sl[6]=7513; /* line # 7513 */
      ((SL *)Rv4)[24]=V_cntx_lblvl;
    }
    ((UB *)Rv3)[41]=9;
  }
  ((V *)Rv3)[6]=Rv1;
  Ra.sl[6]=7518; /* line # 7518 */
  P_insymbol();
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " beginstate "  */
V PAS_COMILER_PRC_00000063(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1265;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=7532; /* line # 7532 */
  Rv0=V_cntx_label;
  V_cntx_lblvl=V_cntx_lblvl+1;
  Rv1=PAS_COMILER_PRC_00000036(73,1);
  if (V_sy_sym.ub[0]==73) P_insymbol();
  else P_src_error(Rd.s+1279,54,2);
  Ra.sl[6]=7537; /* line # 7537 */
  P_label_purge(&Rv0);
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " label_attach "  */
void PAS_COMILER_PRC_00000064(V F_lab_list, V F_trg){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1283;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=7544; /* line # 7544 */
  if (F_lab_list!=NULL&&F_trg!=NULL) ((V *)F_trg)[4]=F_lab_list;
  Ra.sl[6]=7553; /* line # 7553 */
  while (F_lab_list!=NULL){
    Rv0=F_lab_list;
    ((V *)Rv0)[11]=F_trg;
    F_lab_list=((V *)Rv0)[10];
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " statement "  */
V PAS_COMILER_PRC_00000037(V F_lgp, UB F_bsequ){
  /* Define the automatic variable space. */
  Blk( Ra, 40 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  V Rv3;
  V Rv4;
  register V Rv5;
  register V Rv6;
  register V Rv7;
  register V Ret;
  register P Lx_Sv;
  Lx_Sv=Lx[4];
  Lx[4].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[1]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+8;
  Ra.v[2]=Rd.s+1297;
  Ra.v[3]=Rd.s+17;
  Ra.sl[8]=7563; /* line # 7563 */
  Rv0=NULL;
  Rv1=NULL;
  Ra.v[0]=NULL;
  Rv2=V_wildtmp_stk;
  Ra.sl[8]=7568; /* line # 7568 */
  Rv3=NULL;
  if (V_sy_sym.ub[0]==1) while (1){
    Ra.sl[8]=7573; /* line # 7573 */
    V_err_prt=0;
    Rv4=P_ide_search(8);
    V_err_prt=1;
    if (Rv4!=NULL) {
      Ra.sl[8]=7579; /* line # 7579 */
      if (((SL *)Rv4)[10]!=V_curr_lex) Rv4=NULL;
      else {
        if (16&((UB *)Rv4)[57]) P_src_error_s(Rd.s+1310,75,3, V_sy_ident.s,NULL);
      }
    }
    Ra.sl[8]=7585; /* line # 7585 */
    if (Rv4==NULL) {
      P_ide_new(3,NULL,&Rv4);
      Rv5=Lx[5].v[13];
      if (((V *)Rv5)[20]==NULL) ((V *)Rv5)[20]=Rv4;
      else {
        Ra.sl[8]=7590; /* line # 7590 */
        ((V *)Lx[5].v[4])[8]=Rv4;
      }
      Lx[5].v[4]=Rv4;
    }
    Rv6=Rv4;
    Ra.sl[8]=7596; /* line # 7596 */
    ((V *)Rv6)[9]=V_cntx_label;
    V_cntx_label=Rv4;
    ((UB *)Rv6)[57]=((UB *)Rv6)[57]|16;
    if (4&((UB *)Rv6)[57]) {
      if (((SL *)Rv6)[24]<V_cntx_lblvl) {
        Ra.sl[8]=7601; /* line # 7601 */
        P_src_error_s(Rd.s+1310,70,2, V_sy_ident.s,NULL);
      }
    }
    if (Rv3==NULL) Rv3=Rv4;
    ((V *)Rv4)[10]=Ra.v[0];
    Ra.v[0]=Rv4;
    Ra.sl[8]=7606; /* line # 7606 */
    P_insymbol();
    if (V_sy_sym.ub[0]!=1)  break;
  }
  if (V_cmp_trace>0) switch (V_sy_sym.ub[0]) {
    case 19:
    case 49:
    case 55:
    case 72:break;
    default:Ra.sl[8]=7615; /* line # 7615 */
    if (Lx[5].sl[28]<2) {
      if (Ra.v[0]!=NULL) {
        if (8&((UB *)Ra.v[0])[57]) Lx[5].sl[28]=2;
        else Lx[5].sl[28]=1;
      }
    }
    Ra.sl[8]=7620; /* line # 7620 */
    Rv1=P_lgt_new_line(Lx[5].v[13],F_lgp, Lx[5].sl[28]);
    if (Ra.v[0]!=NULL) {
      if (Rv1==NULL) {
        Ra.sl[8]=7626; /* line # 7626 */
        if (F_lgp!=NULL) ((V *)Rv3)[10]=((V *)F_lgp)[4];
        PAS_COMILER_PRC_00000064(Ra.v[0],F_lgp);
      }
      else {
        Ra.sl[8]=7631; /* line # 7631 */
        PAS_COMILER_PRC_00000064(Ra.v[0],Rv1);
      }
      Ra.v[0]=NULL;
    }
    Lx[5].sl[28]=0;
    break;
  }
  Ra.sl[8]=7638; /* line # 7638 */
  memcpy(Ra.s+36,V_sy_sym.s,2);
  if ((((Ra.ub[36]!=73&&Ra.ub[36]!=89)&&Ra.ub[36]!=50)&&Ra.ub[36]!=0)&&Ra.ub[36]
  !=19) P_insymbol();
  Ra.sl[8]=7643; /* line # 7643 */
  switch (Ra.ub[36]) {
    case 89:break;
    case 0:Rv4=P_ide_search(2016);
    Ra.sl[8]=7656; /* line # 7656 */
    Rv7=Rv4;
    P_insymbol();
    switch (((UB *)Rv7)[56]) {
      case 10:Ra.sl[8]=7661; /* line # 7661 */
      Rv0=PAS_COMILER_PRC_00000014(Rv4);
      break;
      case 7:Rv0=PAS_COMILER_PRC_00000009(Rv4,0);
      Ra.sl[8]=7666; /* line # 7666 */
      if (Rv0!=NULL) ((V *)Rv0)[3]=NULL;
      break;
      case 8:
      case 9:Ra.sl[8]=7671; /* line # 7671 */
      switch (V_sy_sym.ub[0]) {
        case 16:
        case 20:
        case 23:Rv0=PAS_COMILER_PRC_00000055(Rv4);
        break;
        default:Ra.sl[8]=7678; /* line # 7678 */
        if (((UB *)Rv7)[56]==9) Rv0=PAS_COMILER_PRC_00000011(Rv4,0);
        else Rv0=PAS_COMILER_PRC_00000009(Rv4,0);
        if (Rv0!=NULL) ((V *)Rv0)[3]=NULL;
        break;
      }
      break;
      default:Ra.sl[8]=7684; /* line # 7684 */
      Rv0=PAS_COMILER_PRC_00000056(Rv4);
      break;
    }
    break;
    case 72:Ra.sl[8]=7689; /* line # 7689 */
    Rv0=PAS_COMILER_PRC_00000063();
    break;
    case 45:Rv0=PAS_COMILER_PRC_00000058();
    break;
    case 48:
    case 49:
    case 55:Rv0=PAS_COMILER_PRC_00000060(Ra.ub[36]);
    break;
    case 51:Ra.sl[8]=7694; /* line # 7694 */
    Rv0=PAS_COMILER_PRC_00000061();
    break;
    case 56:Rv0=PAS_COMILER_PRC_00000059();
    break;
    case 58:Rv0=PAS_COMILER_PRC_00000057();
    break;
    case 57:Rv0=PAS_COMILER_PRC_00000004(57,NULL);
    break;
    case 34:Rv0=PAS_COMILER_PRC_00000062();
    break;
    case 59:Ra.sl[8]=7700; /* line # 7700 */
    Rv0=PAS_COMILER_PRC_00000016(V_new_entry_proc);
    break;
    case 60:Rv0=PAS_COMILER_PRC_00000016(V_newh_entry_proc);
    break;
    case 61:Rv0=PAS_COMILER_PRC_00000017(V_dispose_entry_proc);
    break;
    case 62:Rv0=PAS_COMILER_PRC_00000012(0);
    break;
    case 63:Ra.sl[8]=7705; /* line # 7705 */
    Rv0=PAS_COMILER_PRC_00000012(1);
    break;
    case 64:Rv0=PAS_COMILER_PRC_00000012(2);
    break;
    case 65:Rv0=PAS_COMILER_PRC_00000012(3);
    break;
    case 66:Ra.sl[8]=7710; /* line # 7710 */
    Rv0=PAS_COMILER_PRC_00000013(V_std_inp_file, V_inp_std_sel, V_inp_std_gene, V_inp_std_bin,
    NULL);
    break;
    case 67:Rv0=PAS_COMILER_PRC_00000013(V_std_inp_file, V_inp_std_sel, V_inp_std_gene,
    V_inp_std_bin, V_inp_std_eoln);
    break;
    case 68:Ra.sl[8]=7716; /* line # 7716 */
    Rv0=PAS_COMILER_PRC_00000013(NULL,V_inp_std_sel, V_inp_std_gene,NULL,V_inp_std_eoln);
    break;
    case 69:Rv0=PAS_COMILER_PRC_00000013(V_std_out_file, V_out_std_sel, V_out_std_gene,
    V_out_std_bin,NULL);
    break;
    case 70:Ra.sl[8]=7722; /* line # 7722 */
    Rv0=PAS_COMILER_PRC_00000013(V_std_out_file, V_out_std_sel, V_out_std_gene, V_out_std_bin,
    V_out_std_eoln);
    break;
    case 71:Rv0=PAS_COMILER_PRC_00000013(NULL,V_out_std_sel, V_out_std_gene,NULL,
    V_out_std_eoln);
    break;
    case 79:Ra.sl[8]=7729; /* line # 7729 */
    Rv0=PAS_COMILER_PRC_00000055(NULL);
    break;
    default:break;
  }
  if (Ra.v[0]!=NULL) {
    Ra.sl[8]=7735; /* line # 7735 */
    if (Rv0==NULL) P_lgt_new(&Rv0,NULL,17,NULL);
    PAS_COMILER_PRC_00000064(Ra.v[0],Rv0);
  }
  Ra.sl[8]=7740; /* line # 7740 */
  if (Rv0!=NULL) {
    if (Rv1!=NULL) {
      ((V *)Rv1)[0]=Rv0;
      Ra.sl[8]=7745; /* line # 7745 */
      if (F_bsequ) {
        P_lgt_new(&Rv0,NULL,0, Rv1);
        ((UB *)Rv0)[41]=2;
        Lx[5].v[8]=Rv0;
      }
      else {
        Ra.sl[8]=7753; /* line # 7753 */
        Lx[5].v[8]=Rv0;
        Rv0=Rv1;
      }
    }
    else {
      Ra.sl[8]=7758; /* line # 7758 */
      Lx[5].v[8]=Rv0;
    }
  }
  else {
    if (Rv1!=NULL) Rv0=Rv1;
    Ra.sl[8]=7763; /* line # 7763 */
    Lx[5].v[8]=Rv0;
  }
  P_tmpstk_free(Rv2);
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[1];
  Lx[4]=Lx_Sv;
  return(Ret);
}


/* Procedure/Function : " statelist "  */
V PAS_COMILER_PRC_00000036(UB F_stopper, UB F_seq_flg){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  V Rv3;
  register V Rv4;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1314;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=7782; /* line # 7782 */
  Rv0=V_src_control;
  ((SL *)Rv0)[6]=((SL *)Rv0)[6]+1;
  Rv1=NULL;
  Rv2=NULL;
  Ra.sl[6]=7787; /* line # 7787 */
  while (V_sy_sym.ub[0]==19)
  P_insymbol();
  if (((V_sy_sym.ub[0]!=F_stopper&&V_sy_sym.ub[0]!=89)&&V_sy_sym.ub[0]!=73)&&!V_emergency_stop)
   {
    Rv1=PAS_COMILER_PRC_00000037(NULL,0);
    Ra.sl[6]=7792; /* line # 7792 */
    Rv2=Lx[5].v[8];
    while (((V_sy_sym.ub[0]!=F_stopper&&V_sy_sym.ub[0]!=89)&&V_sy_sym.ub[0]!=73)
    &&!V_emergency_stop){
      Ra.sl[6]=7797; /* line # 7797 */
      if (V_sy_sym.ub[0]==19) while (V_sy_sym.ub[0]==19)
      P_insymbol();
      else P_src_error(Rd.s+1327,21,2);
      if (((V_sy_sym.ub[0]!=F_stopper&&V_sy_sym.ub[0]!=89)&&V_sy_sym.ub[0]!=73)&&
      !V_emergency_stop) {
        Ra.sl[6]=7803; /* line # 7803 */
        Rv3=PAS_COMILER_PRC_00000037(Rv2,0);
        if (Rv3!=NULL) {
          if (Rv1==NULL) Rv1=Rv3;
          else((V *)Rv2)[0]=Rv3;
          Ra.sl[6]=7808; /* line # 7808 */
          Rv2=Lx[5].v[8];
        }
      }
    }
  }
  Ra.sl[6]=7814; /* line # 7814 */
  Rv4=V_src_control;
  ((SL *)Rv4)[6]=((SL *)Rv4)[6]-1;
  Lx[5].v[7]=Rv2;
  if (F_seq_flg&&Rv1!=Rv2) {
    P_lgt_new(&Rv2,NULL,0, Rv1);
    Ra.sl[6]=7819; /* line # 7819 */
    ((UB *)Rv2)[41]=2;
    Ret=Rv2;
  }
  else Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " cmp_block "  */
void P_cmp_block(V F_owner, UB F_bproc, SL F_glicd){
  /* Define the automatic variable space. */
  Blk( Ra, 120 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  V Rv4;
  register V Rv5;
  V Rv6;
  register V Rv7;
  register P Lx_Sv;
  Lx_Sv=Lx[5];
  Lx[5].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[13]=F_owner;
  Ra.sl[28]=F_glicd;
  Ra.v[9]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+72;
  Ra.v[10]=Rd.s+1331;
  Ra.v[11]=Rd.s+17;
  Ra.sl[24]=7830; /* line # 7830 */
  if (V_curr_lex>0) P_new_disp_level(Ra.v[13],4);
  Ra.sl[24]=7836; /* line # 7836 */
  Ra.ub[40]=0;
  Ra.v[6]=NULL;
  Ra.v[1]=NULL;
  Rv0=NULL;
  Rv1=V_cntx_label;
  Ra.sl[24]=7841; /* line # 7841 */
  V_cntx_label=NULL;
  Rv2=Ra.v[13];
  ((V *)Rv2)[19]=NULL;
  ((V *)Rv2)[23]=NULL;
  Ra.sl[24]=7846; /* line # 7846 */
  ((V *)Rv2)[24]=NULL;
  P_compile_set_sbttl(Ra.v[13]);
  Ra.sl[24]=7851; /* line # 7851 */
  Ra.ub[16]=1;
  Ra.v[3]=NULL;
  while (1){
    Ra.sl[24]=7856; /* line # 7856 */
    V_pro_current=Ra.v[13];
    V_cprc_disp=V_curr_disp;
    if (V_sy_sym.ub[0]==16) PAS_COMILER_PRC_00000044();
    Ra.sl[24]=7861; /* line # 7861 */
    switch (V_sy_sym.ub[0]) {
      case 29:P_insymbol();
      Ra.sl[24]=7866; /* line # 7866 */
      PAS_COMILER_PRC_00000045();
      break;
      case 30:Ra.sl[24]=7871; /* line # 7871 */
      P_insymbol();
      PAS_COMILER_PRC_00000046();
      break;
      case 31:Ra.sl[24]=7877; /* line # 7877 */
      if (V_sy_init_mod) V_sy_var_init_mod=1;
      P_insymbol();
      PAS_COMILER_PRC_00000047();
      if (V_sy_init_mod) {
        Ra.sl[24]=7882; /* line # 7882 */
        V_sy_var_init_mod=0;
      }
      break;
      case 33:PAS_COMILER_PRC_00000048();
      break;
      case 32:Ra.sl[24]=7887; /* line # 7887 */
      PAS_COMILER_PRC_00000049();
      break;
      case 77:
      case 78:Ra.sl[24]=7892; /* line # 7892 */
      PAS_COMILER_PRC_00000051();
      P_compile_set_sbttl(Ra.v[13]);
      V_cntx_varbl=((V *)Ra.v[13])[22];
      break;
      case 72:
      case 73:
      case 89:break;
      default:Ra.sl[24]=7900; /* line # 7900 */
      P_src_error(Rd.s+1344,91,2);
      P_insymbol();
      break;
    }
    if ((V_sy_sym.ub[0]==89||V_sy_sym.ub[0]==72)||V_sy_sym.ub[0]==73)  break;
  }
  Ra.sl[24]=7906; /* line # 7906 */
  if (V_curr_lex>0) {
    if (V_sy_sym.ub[0]==72) {
      P_ide_create_name(Rd.s+1348);
      Ra.sl[24]=7911; /* line # 7911 */
      P_ide_new_typ(21, &V_wildtmp_typ);
      ((SL *)V_wildtmp_typ)[11]=0;
      P_ide_new(5, V_wildtmp_typ, &V_wildtmp_ide);
      ((UW *)V_wildtmp_ide)[46]=96;
      Ra.sl[24]=7916; /* line # 7916 */
      V_wildtmp_psz=0;
      V_wildtmp_pal.ub[0]=0;
      V_wildtmp_stk=NULL;
      V_cntx_lblvl=0;
      Ra.sl[24]=7921; /* line # 7921 */
      V_cprc_disp=V_curr_disp;
      V_pro_current=Ra.v[13];
      P_compile_set_sbttl(Ra.v[13]);
      if (Ra.v[1]!=NULL) {
        Ra.sl[24]=7927; /* line # 7927 */
        if (Rv0!=NULL) ((V *)Rv0)[3]=Ra.v[1];
        else((V *)Ra.v[13])[23]=Ra.v[1];
        P_src_error(Rd.s+1344,92,3);
      }
      Ra.sl[24]=7933; /* line # 7933 */
      V_sy_label_flag=1;
      P_insymbol();
      Rv3=Ra.v[13];
      Ra.sl[24]=7940; /* line # 7940 */
      ((V *)Rv3)[16]=PAS_COMILER_PRC_00000036(73,0);
      if (((V *)Rv3)[11]!=NULL) {
        if (!Ra.ub[40]) P_src_error(Rd.s+1344,74,3);
      }
      Ra.sl[24]=7946; /* line # 7946 */
      if (((V *)Rv3)[18]!=NULL) {
        ((V *)((V *)Rv3)[17])[0]=((V *)Rv3)[16];
        ((V *)Rv3)[16]=((V *)Rv3)[18];
      }
      Ra.sl[24]=7951; /* line # 7951 */
      ((V *)Rv3)[17]=Ra.v[7];
      Rv4=((V *)Ra.v[13])[19];
      Ra.sl[24]=7956; /* line # 7956 */
      while (Rv4!=NULL){
        Rv5=Rv4;
        V_ope_table.v[((UB *)Rv5)[0]]=((V *)Rv5)[2];
        Ra.sl[24]=7964; /* line # 7964 */
        Rv6=((V *)Rv5)[1];
        PAS__DISPOSE(&Rv4);
        Rv4=Rv6;
      }
      Ra.sl[24]=7971; /* line # 7971 */
      V_sy_label_flag=0;
    }
  }
  Ra.sl[24]=7976; /* line # 7976 */
  if (((UB *)Ra.v[13])[104]>=4) {
    V_cntx_label=((V *)Ra.v[13])[20];
    while (V_cntx_label!=Rv1&&V_cntx_label!=NULL){
      Rv7=V_cntx_label;
      Ra.sl[24]=7982; /* line # 7982 */
      if (4&((UB *)Rv7)[57]) {
        if (!(16&((UB *)Rv7)[57])) P_src_error(Rd.s+1344,66,3);
      }
      V_cntx_label=((V *)Rv7)[8];
    }
  }
  Ra.sl[24]=7989; /* line # 7989 */
  V_cntx_label=Rv1;
  PAS__curr_cntx=Ra.v[9];
  Lx[5]=Lx_Sv;
}


/* Procedure/Function : " cmp_init "  */
void P_cmp_init(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1355;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=8009; /* line # 8009 */
  V_emergency_stop=0;
  P_insy_init();
  if (V_emergency_stop) PAS__EXIT(2);
  Ra.sl[6]=8015; /* line # 8015 */
  V_opt_exec=0;
  V_cmp_cmpdbg=0;
  V_cmp_range=0;
  Ra.sl[6]=8020; /* line # 8020 */
  V_cmp_dynamic=0;
  V_cmp_genenv=0;
  V_cmp_listlvl=1;
  V_cmp_igenv=-1;
  Ra.sl[6]=8025; /* line # 8025 */
  V_cmp_macf=0;
  V_cmp_cobj=0;
  V_cmp_objf=0;
  V_cmp_bltt=0;
  V_cmp_opt=1;
  Ra.sl[6]=8030; /* line # 8030 */
  V_cmp_debugopt=0;
  V_cmp_debug=0;
  V_cmp_traceopt=5;
  V_cmp_trace=-1;
  V_cmp_tracecount=0;
  Ra.sl[6]=8035; /* line # 8035 */
  V_cmp_twicedclon=0;
  V_sy_init_mod=1;
  V_sy_generic_qmod=1;
  V_sy_var_init_mod=0;
  Ra.sl[6]=8041; /* line # 8041 */
  V_sy_casedef=0;
  P_insymbol();
  P_compile_set_title();
  Ra.sl[6]=8046; /* line # 8046 */
  P_compile_set_sbttl(V_lex_ident_tree.v[0]);
  P_generation_setting();
  Ra.sl[6]=8051; /* line # 8051 */
  P_cmp_block(V_lex_ident_tree.v[0],1,0);
  if (V_error_result!=0) V_emergency_stop=1;
  Ra.sl[6]=8056; /* line # 8056 */
  if (V_emergency_stop) PAS__EXIT(2);
  Ra.sl[6]=8080; /* line # 8080 */
  V_cntx_procname=V_fptr_size;
  V_cntx_srcfname=V_cntx_procname+V_fptr_size;
  V_cntx_linenbr=V_cntx_srcfname+V_fptr_size;
  V_cntx_size=V_cntx_linenbr+V_inte_size;
  P_ide_new_typ(10, &V_cntx_typ);
  Ra.sl[6]=8085; /* line # 8085 */
  Rv0=V_cntx_typ;
  ((UB *)Rv0)[48]=((UB *)V_typ_std.v[5])[48];
  ((SL *)Rv0)[11]=V_cntx_size;
  ((V *)Rv0)[12]=NULL;
  Ra.sl[6]=8090; /* line # 8090 */
  ((V *)Rv0)[13]=NULL;
  ((V *)Rv0)[14]=NULL;
  if (V_cmp_trace>0) V_cmp_tracecount=0;
  V_sy_init_mod=0;
  Ra.sl[6]=8095; /* line # 8095 */
  V_sy_generic_qmod=0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " cmp_pass2 "  */
void PAS_COMILER_cmp_pass2(V F_pr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1365;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=8103; /* line # 8103 */
  Rv0=F_pr;
  Ra.sl[6]=8112; /* line # 8112 */
  P_lgt_pass1_complet(F_pr);
  if (V_cmp_macf) {
    P_lgt_dump_proc(F_pr);
    Ra.sl[6]=8117; /* line # 8117 */
    P_lst_page();
  }
  Ra.sl[6]=8122; /* line # 8122 */
  switch (((UB *)Rv0)[104]) {
    case 5:
    case 8:
    case 9:Ra.sl[6]=8128; /* line # 8128 */
    P_generate_code_p1(F_pr);
    break;
    default:break;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " cmp_compile "  */
UB P_cmp_compile(UB F_interactive){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  V Rv2;
  V Rv3;
  register UB Rv4;
  register V Rv5;
  V Rv6;
  SL Rv7;
  register V Rv8;
  register V Rv9;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1376;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=8152; /* line # 8152 */
  V_emergency_stop=0;
  Rv0=0;
  V_env_file=NULL;
  V_env_first=NULL;
  Ra.sl[6]=8157; /* line # 8157 */
  V_env_last=NULL;
  if (!V_emergency_stop) {
    Ra.sl[6]=8163; /* line # 8163 */
    P_compile_set_title();
    Ra.sl[6]=8169; /* line # 8169 */
    Rv1=V_src_control;
    ((SL *)Rv1)[7]=1;
    ((SL *)Rv1)[8]=V_cmp_listlvl;
    Ra.sl[6]=8176; /* line # 8176 */
    V_sy_ch=32;
    P_insymbol();
    V_sy_fix_range_ctl=1;
    Ra.sl[6]=8181; /* line # 8181 */
    PAS__DISPOSE(((V *)V_lst_current)+5);
    Rv2=PAS__NEW(245);
    V_pro_current=Rv2;
    Ra.sl[6]=8186; /* line # 8186 */
    if (V_sy_sym.ub[0]==74) {
      V_sy_sym.ub[0]=18;
      while (1){
        P_insymbol();
        Ra.sl[6]=8191; /* line # 8191 */
        if (V_sy_sym.ub[0]==5&&V_sy_string.ub[1]>0) P_set_env_file_spc(NULL);
        else P_src_error(Rd.s+1391,58,3);
        P_insymbol();
        if (V_sy_sym.ub[0]!=18)  break;
      }
      Ra.sl[6]=8197; /* line # 8197 */
      if (V_sy_sym.ub[0]==19) P_insymbol();
      else P_src_error(Rd.s+1391,21,2);
    }
    else {
      if (V_sy_sym.ub[0]==16) {
        Ra.sl[6]=8203; /* line # 8203 */
        V_sy_sym.ub[0]=18;
        while (1){
          P_insymbol();
          if (V_sy_sym.ub[0]==0) {
            Ra.sl[6]=8208; /* line # 8208 */
            Rv3=P_level_search(V_attr_list);
            if (Rv3!=NULL) while (1){
              P_insymbol();
              switch (((UB *)Rv3)[57]) {
                case 18:Ra.sl[6]=8215; /* line # 8215 */
                if (V_sy_sym.ub[0]!=14) P_src_error(Rd.s+1391,22,2);
                V_sy_sym.ub[0]=18;
                while (1){
                  P_insymbol();
                  if (V_sy_sym.ub[0]==5&&V_sy_string.ub[1]>0) {
                    Ra.sl[6]=8220; /* line # 8220 */
                    P_set_env_file_spc(NULL);
                  }
                  else P_src_error(Rd.s+1391,58,3);
                  P_insymbol();
                  if (V_sy_sym.ub[0]!=18)  break;
                }
                Ra.sl[6]=8225; /* line # 8225 */
                if (V_sy_sym.ub[0]==15) P_insymbol();
                else P_src_error(Rd.s+1391,23,2);
                break;
                case 19:Ra.sl[6]=8231; /* line # 8231 */
                if (V_sy_sym.ub[0]==14) P_insymbol();
                else P_src_error(Rd.s+1391,22,2);
                if (V_sy_sym.ub[0]==5&&V_sy_string.ub[1]>0) {
                  Rv4=V_sy_string.ub[1];
                  V_env_file=PAS__NEW((SL)Rv4+2);
                  ((UB *)V_env_file)[0]=Rv4;
                  Ra.sl[6]=8236; /* line # 8236 */
                  PAS__STR_TO_STR(V_env_file,V_sy_string.s);
                  V_cmp_genenv=1;
                  V_cmp_igenv=0;
                  P_insymbol();
                }
                else {
                  Ra.sl[6]=8243; /* line # 8243 */
                  V_cmp_genenv=0;
                  V_cmp_igenv=-1;
                }
                if (V_sy_sym.ub[0]==15) P_insymbol();
                else P_src_error(Rd.s+1391,23,2);
                break;
                default:Ra.sl[6]=8250; /* line # 8250 */
                P_src_error_s(Rd.s+1391,3,1, V_sy_ident.s,NULL);
                break;
              }
              if ((V_sy_sym.ub[0]==89||V_sy_sym.ub[0]==18)||V_sy_sym.ub[0]==17)  break;
            }
          }
          else P_src_error(Rd.s+1391,2,3);
          if (V_sy_sym.ub[0]!=18)  break;
        }
        Ra.sl[6]=8256; /* line # 8256 */
        if (V_sy_sym.ub[0]==17) P_insymbol();
        else P_src_error(Rd.s+1391,26,2);
      }
    }
    if (V_cmp_igenv>=0) V_cmp_genenv=1;
    else {
      Ra.sl[6]=8261; /* line # 8261 */
      V_cmp_genenv=0;
    }
    if (V_sy_sym.ub[0]==75) {
      P_insymbol();
      Ra.sl[6]=8266; /* line # 8266 */
      Rv0=1;
      if (V_sy_sym.ub[0]!=0) {
        P_src_error(Rd.s+1391,93,4);
        V_emergency_stop=1;
      }
    }
    else {
      Ra.sl[6]=8274; /* line # 8274 */
      if (V_sy_sym.ub[0]==76) {
        P_insymbol();
        if (V_sy_sym.ub[0]!=0) {
          Ra.sl[6]=8279; /* line # 8279 */
          P_src_error(Rd.s+1391,93,4);
          V_emergency_stop=1;
        }
      }
      else {
        Ra.sl[6]=8284; /* line # 8284 */
        P_src_error(Rd.s+1391,94,4);
      }
    }
  }
  if (!V_emergency_stop) {
    Ra.sl[6]=8289; /* line # 8289 */
    Rv5=Rv2;
    V_curr_lex=V_curr_lex+1;
    P_new_disp_level(Rv2,4);
    Ra.sl[6]=8296; /* line # 8296 */
    V_lex_ident_level.sl[V_curr_lex]=V_curr_disp;
    P_ide_new(9,NULL,&Rv6);
    ((V *)Rv5)[0]=NULL;
    Ra.sl[6]=8301; /* line # 8301 */
    ((V *)Rv5)[1]=NULL;
    ((UW *)Rv5)[8]=128;
    ((V *)Rv5)[3]=((V *)Rv6)[0];
    ((UB *)Rv5)[32]=29;
    ((V *)Rv5)[5]=Rv6;
    Ra.sl[6]=8306; /* line # 8306 */
    ((V *)Rv5)[6]=NULL;
    ((V *)Rv5)[7]=NULL;
    ((V *)Rv5)[8]=NULL;
    ((SL *)Rv5)[18]=0;
    ((SL *)Rv5)[19]=0;
    Ra.sl[6]=8311; /* line # 8311 */
    ((SL *)Rv5)[20]=0;
    ((V *)Rv5)[11]=NULL;
    ((V *)Rv5)[12]=NULL;
    if (Rv0) ((UB *)Rv5)[104]=6;
    else((UB *)Rv5)[104]=5;
    Ra.sl[6]=8317; /* line # 8317 */
    ((V *)Rv5)[14]=NULL;
    ((V *)Rv5)[15]=NULL;
    ((V *)Rv5)[16]=NULL;
    ((V *)Rv5)[17]=NULL;
    ((V *)Rv5)[18]=NULL;
    Ra.sl[6]=8322; /* line # 8322 */
    ((V *)Rv5)[19]=NULL;
    ((V *)Rv5)[20]=NULL;
    ((V *)Rv5)[21]=NULL;
    ((V *)Rv5)[22]=NULL;
    ((V *)Rv5)[23]=NULL;
    Ra.sl[6]=8327; /* line # 8327 */
    ((V *)Rv5)[24]=NULL;
    ((V *)Rv5)[25]=NULL;
    ((V *)Rv5)[26]=NULL;
    ((V *)Rv5)[27]=NULL;
    Ra.sl[6]=8332; /* line # 8332 */
    ((SL *)Rv5)[56]=-1;
    ((SL *)Rv5)[57]=0;
    ((SL *)Rv5)[58]=0;
    ((SL *)Rv5)[59]=0;
    ((SL *)Rv5)[60]=0;
    Ra.sl[6]=8337; /* line # 8337 */
    ((UB *)Rv5)[244]=0;
    V_pas_main=Rv2;
    P_insymbol();
    Ra.sl[6]=8342; /* line # 8342 */
    if (V_sy_sym.ub[0]==14) {
      V_sy_sym.ub[0]=18;
      while (V_sy_sym.ub[0]==18){
        Ra.sl[6]=8347; /* line # 8347 */
        P_insymbol();
        if (V_sy_sym.ub[0]==0) P_insymbol();
        else P_src_error(Rd.s+1391,95,1);
      }
      if (V_sy_sym.ub[0]==15) P_insymbol();
      else {
        Ra.sl[6]=8352; /* line # 8352 */
        P_src_error(Rd.s+1391,23,2);
      }
    }
    if (V_sy_sym.ub[0]==19) P_insymbol();
    else P_src_error(Rd.s+1391,21,2);
    Ra.sl[6]=8359; /* line # 8359 */
    if (V_env_first!=NULL) P_pas_read_env_file();
    if (V_cmp_debugopt) {
      V_cmp_debug=1;
      Ra.sl[6]=8364; /* line # 8364 */
      V_cmp_traceopt=1;
    }
    if (V_cmp_traceopt>0) {
      Ra.sl[6]=8369; /* line # 8369 */
      P_gen_cntxvar(Rv2,((V *)Rv6)[0]);
      V_cmp_trace=V_cmp_traceopt;
      Rv7=5;
    }
    else Rv7=0;
    Ra.sl[6]=8375; /* line # 8375 */
    P_cmp_block(Rv2,1, Rv7);
    if (V_cmp_trace>0&&!Rv0) {
      Rv8=Rv2;
      Ra.sl[6]=8380; /* line # 8380 */
      P_gen_linetrace(Rv2,((V *)Rv8)+16,((V *)Rv8)+17,6);
    }
    if (V_sy_sym.ub[0]==73) P_insymbol();
    else P_src_error(Rd.s+1391,54,2);
    if (V_sy_sym.ub[0]==0) {
      Ra.sl[6]=8386; /* line # 8386 */
      if (V_sy_sym.ub[0]==0&&P_match(((V *)Rv6)[0],V_sy_ident.s)==0) P_insymbol();
      else P_src_error_s(Rd.s+1391,96,1, V_sy_ident.s,NULL);
    }
    Ra.sl[6]=8391; /* line # 8391 */
    if (V_sy_sym.ub[0]==20) P_insymbol();
    else P_src_error(Rd.s+1391,21,1);
    if (V_sy_sym.ub[0]!=89) {
      P_src_error(Rd.s+1391,991,1);
      Ra.sl[6]=8396; /* line # 8396 */
      while (V_sy_sym.ub[0]!=89)
      P_insymbol();
    }
    else P_src_end_of_line();
    if (V_pro_last==NULL) V_pro_first=Rv2;
    else((V *)V_pro_last)[0]=Rv2;
    Ra.sl[6]=8401; /* line # 8401 */
    V_pro_last=Rv2;
    if (V_error_result>1) V_emergency_stop=1;
    else {
      Ra.sl[6]=8408; /* line # 8408 */
      Rv9=Rv2;
      if (((V *)Rv9)[16]!=((V *)Rv9)[17]) {
        P_lgt_new(((V *)Rv9)+16,NULL,0,((V *)Rv9)[16]);
        ((UB *)((V *)Rv9)[16])[41]=2;
        Ra.sl[6]=8413; /* line # 8413 */
        ((V *)Rv9)[17]=((V *)Rv9)[16];
      }
      PAS_COMILER_cmp_pass2(Rv2);
    }
    Ra.sl[6]=8418; /* line # 8418 */
    if (V_cmp_macf) {
      P_lgt_dump_static(Rv2);
      P_lst_page();
    }
    Ra.sl[6]=8424; /* line # 8424 */
    if (V_error_result>1) V_emergency_stop=1;
    else {
      P_pas_write_env_file();
      P_generate_code_p2();
    }
  }
  Ra.sl[6]=8432; /* line # 8432 */
  Ret=V_error_result;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}
