/*  P A S - P. WOLFERS SOFTWARE: V3.1-A1 OF 30-NOV-2014 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long long int

/* Include the PAS environment file. */
#include <cpas_defs.h>
static P Lx[1];

/* Define the local data section. */
static Blk( Rd, 768 ) = {
  9,   9, 115, 101, 116, 115, 121, 109, 108, 115, 116,  46,  46,  47, 104, 111,
109, 101,  47, 112, 105, 101, 114, 114, 101,  47,  83, 111, 102, 116,  47,  99,
112, 115, 104,  95, 107, 105, 116, 115,  47, 109, 120, 100,  95, 115, 114,  99,
 47, 103, 101, 110, 104, 107, 108,  46, 112,  97, 115,  27,  27,  32,  76,  73,
 83,  84,  32,  79,  70,  32,  83,  89,  77,  84,  82,  89,  32,  79,  80,  69,
 82,  65,  84,  79,  82,  83,  32,  58,  14,  14,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,   6,   6, 109, 117, 108, 115, 121, 109,
  8,   8, 103, 101, 110, 115, 112,  97,  99, 101,  14,  14,  32,  78,  69,  87,
 32,  79,  80,  69,  82,  65,  84,  79,  82,  32,  14,  14,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  14,  14,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  84,  72,  69,
 32,  80,  79,  78,  67,  84,  85,  65,  76,  32,  71,  82,  79,  85,  80,  32,
 73,  83,  32,  67,  69,  78,  84,  69,  82,  69,  68,  46,  30,  30,  32,  84,
 72,  69,  32,  80,  79,  78,  67,  84,  85,  65,  76,  32,  71,  82,  79,  85,
 80,  32,  79,  82,  68,  69,  82,  32,  72,  65,  83,  32,  11,  11,  32,  79,
 80,  69,  82,  65,  84,  79,  82,  83,  46,   4,   4, 114, 109,  97, 120,   4,
  4, 114, 109, 105, 110,   5,   5, 108, 105, 109, 105, 116,   4,   4, 102, 108,
 97, 103,   4,   4, 115, 111, 114, 116,   7,   7,  99, 111, 109, 112, 117, 116,
101,  10,  10, 101, 105, 103, 101, 110, 118,  97, 108, 117, 101,   8,   8,  99,
101, 108, 108, 115, 105, 122, 101,  12,  12, 109, 117, 108, 116, 105, 112, 108,
105,  99, 105, 116, 121,   4,   4, 100, 105, 115, 116,  10,  10, 111, 117, 116,
116, 114, 105, 112, 108, 101, 116,  10,  10,  42,  42,  42,  42,  42,  42,  42,
 42,  42,  42,   6,   6, 103, 101, 110, 104, 107, 108,   7,   7,  80,  65,  66,
 67,  73,  82,  70,  20,  20,  32,  83,  89,  77,  84,  82,  89,  32,  70,  73,
 76,  69,  32,  78,  65,  77,  69,  32,  61,  32,  20,  20,  32,  79,  85,  84,
 80,  85,  84,  32,  70,  73,  76,  69,  32,  78,  65,  77,  69,  32,  61,  32,
 53,  53,  32,  71,  73,  86,  69,  32,  84,  72,  69,  32,  85,  78,  73,  84,
 32,  67,  69,  76,  76,  40,  65,  78,  71,  83,  84,  82,  79,  69,  77,  32,
 65,  78,  68,  32,  68,  69,  71,  82,  69,  69,  83,  32,  79,  82,  32,  67,
 79,  83,  73,  78,  85,  83,  41,  39,  39,  32,  71,  73,  86,  69,  32,  84,
 72,  69,  32,  76,  65,  84,  84,  73,  67,  69,  32,  78,  65,  77,  69,  32,
 40,  80,  44,  65,  44,  66,  44,  67,  44,  73,  44,  82,  44,  70,  41,  32,
 19,  19,  32,  85,  78,  68,  69,  70,  73,  78,  69,  68,  32,  76,  65,  84,
 84,  73,  67,  69,  46,  35,  35,  32,  71,  73,  86,  69,  32,  84,  72,  69,
 32,  87,  65,  86,  69,  32,  86,  69,  67,  84,  79,  82,  32,  67,  79,  77,
 80,  79,  78,  69,  78,  84,  83,  32,  58,  32,  50,  50,  32,  71,  73,  86,
 69,  32,  84,  72,  69,  32,  77,  73,  78,  73,  77,  65,  88,  73,  32,  70,
 79,  82,  32,  78,  81,  32,  70,  65,  67,  84,  79,  82,  32,  40, 104,  32,
 61,  32,  72,  32,  43,  32,  81,  42,  78,  81,  41,  32,  58,  32,  33,  33,
 32,  71,  73,  86,  69,  32,  84,  72,  69,  32,  78,  42,  40,  61,  49,  47,
 68,  41,  32,  85,  80,  80,  69,  82,  32,  76,  73,  77,  73,  84,  32,  58,
 32,  43,  43,  32,  71,  73,  86,  69,  32,  84,  72,  69,  32,  87,  65,  86,
 69,  76,  69,  78,  71,  84,  72,  32,  40,  65,  78,  71,  83,  84,  82,  79,
 77,  41,  32,  91,  79,  82,  32,  48,  46,  48,  93,  32,  58,  32,   6,   6,
 32,  72,  77,  32,  61,  32,   7,   7,  44,  32,  75,  77,  32,  61,  32,   7,
  7,  44,  32,  76,  77,  32,  61,  32,  11,  11,  32,  84,  72,  69,  82,  69,
 32,  65,  82,  69,  32,  19,  19,  32,  83,  79,  82,  84,  69,  68,  32,  82,
 69,  70,  76,  69,  88,  73,  79,  78,  83,  46,   0,   0,   0,   0,   0,   0
};

/* Define the local static Initialized section. */
static Blk( Ri, 32 ) = {
  0,   0,   0,   0,  16,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   7,   0,   0,   0,   0,   0,   0,   0,   0,   0
};

/* Define the local static section. */
static Blk( Rs, 80 );

/* Declaration of external variables. */
extern V PAS__f_output;
extern V PAS__f_input;




/* Procedure/Function : " setsymlst "  */
void GENHKL_setsymlst(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  SL Rv3;
  SL Rv4;
  register int Rf1, Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+11;
  Ra.sl[3]=86; /* line # 86 */
  Rs.f[0]=(F)1.000000E-05;
  Rs.ub[4]=0;
  Rv0=NULL;
  PAS__OPEN(Ri.v,0, Ri.s+4,1,0,-1);
  while (!PAS__EOF(Ri.v[0])){
    Ra.sl[3]=92; /* line # 92 */
    if (Rs.v[2]==NULL) {
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_EOLN();
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+59,-1,-1,32);
      PAS__WRITE_EOLN();
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_EOLN();
    }
    Rv1=PAS__NEW(40);
    Ra.sl[3]=97; /* line # 97 */
    if (Rv0==NULL) Rs.v[2]=Rv1;
    else((V *)Rv0)[0]=Rv1;
    Rv0=Rv1;
    Rv2=Rv1;
    Ra.sl[3]=102; /* line # 102 */
    ((V *)Rv2)[0]=NULL;
    Rv3=1;
    for( Rf1=3;Rf1>0;Rf1-- ) {
      Rv4=1;
      for( Rf0=3;Rf0>0;Rf0-- ) {
        PAS__SELECT_INP(Ri.v[0]);
        PAS__READ_SL((((SL *)Rv2)+Rv4*3+Rv3-3),0);
        Rv4++;
      }
      Ra.sl[3]=107; /* line # 107 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+88,-1,-1,32);
      PAS__WRITE_INT(((SL *)Rv2)[Rv3],4,0);
      PAS__WRITE_INT(((SL *)Rv2)[Rv3+3],4,0);
      PAS__WRITE_INT(((SL *)Rv2)[Rv3+6],4,0);
      PAS__WRITE_EOLN();
      Rv3++;
    }
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_EOLN();
    PAS__SELECT_INP(Ri.v[0]);
    PAS__READ_EOLN();
  }
  Ra.sl[3]=113; /* line # 113 */
  PAS__CLOSE(Ri.v,0);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mulsym "  */
void GENHKL_mulsym(V F_p1, V F_p2, V F_p3){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;
  SL Rv2;
  register int Rf1, Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+104;
  Ra.v[2]=Rd.s+11;
  Ra.sl[3]=119; /* line # 119 */
  Rv0=F_p1;
  Rv1=1;
  for( Rf1=3;Rf1>0;Rf1-- ) {
    Rv2=1;
    for( Rf0=3;Rf0>0;Rf0-- ) {
      ((SL *)Rv0)[Rv1*3+Rv2-3]=(((SL *)F_p2)[Rv1*3-2]*((SL *)F_p3)[Rv2]+((SL *)F_p2)
      [Rv1*3-1]*((SL *)F_p3)[Rv2+3])+((SL *)F_p2)[Rv1*3]*((SL *)F_p3)[Rv2+6];
      Rv2++;
    }
    Rv1++;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " genspace "  */
void GENHKL_genspace(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  V Rv1;
  V Rv2;
  V Rv3;
  V Rv4;
  UB Rv5;
  SL Rv6;
  SL Rv7;
  V Rv8;
  register V Rv9;
  register V Rv10;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+112;
  Ra.v[2]=Rd.s+11;
  Ra.sl[3]=136; /* line # 136 */
  Rv0=0;
  Rv1=PAS__NEW(40);
  Rv2=Rs.v[2];
  while (Rv2!=NULL){
    Ra.sl[3]=141; /* line # 141 */
    Rv0=Rv0+1;
    Rv3=Rv2;
    while (Rv3!=NULL){
      GENHKL_mulsym(Rv1, Rv2, Rv3);
      Ra.sl[3]=146; /* line # 146 */
      Rv4=Rs.v[2];
      Rv5=0;
      while (Rv4!=NULL&&!Rv5){
        Rv5=1;
        Rv6=1;
        while (Rv6<4&&Rv5){
          Ra.sl[3]=152; /* line # 152 */
          Rv7=1;
          while (Rv7<4&&Rv5){
            Rv5=((SL *)Rv1)[Rv6*3+Rv7-3]==((SL *)Rv4)[Rv6*3+Rv7-3];
            Rv7=Rv7+1;
          }
          Ra.sl[3]=158; /* line # 158 */
          Rv6=Rv6+1;
        }
        Rv8=Rv4;
        Rv4=((V *)Rv4)[0];
      }
      Ra.sl[3]=163; /* line # 163 */
      if (!Rv5) {
        ((V *)Rv8)[0]=PAS__NEW(40);
        Rv4=((V *)Rv8)[0];
        ((V *)Rv4)[0]=NULL;
        Rv9=Rv1;
        Ra.sl[3]=168; /* line # 168 */
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_STR(Rd.s+122,-1,-1,32);
        PAS__WRITE_INT(((SL *)Rv9)[1],4,0);
        PAS__WRITE_INT(((SL *)Rv9)[4],4,0);
        PAS__WRITE_INT(((SL *)Rv9)[7],4,0);
        PAS__WRITE_EOLN();
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_STR(Rd.s+138,-1,-1,32);
        PAS__WRITE_INT(((SL *)Rv9)[2],4,0);
        PAS__WRITE_INT(((SL *)Rv9)[5],4,0);
        PAS__WRITE_INT(((SL *)Rv9)[8],4,0);
        PAS__WRITE_EOLN();
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_STR(Rd.s+154,-1,-1,32);
        PAS__WRITE_INT(((SL *)Rv9)[3],4,0);
        PAS__WRITE_INT(((SL *)Rv9)[6],4,0);
        PAS__WRITE_INT(((SL *)Rv9)[9],4,0);
        PAS__WRITE_EOLN();
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_EOLN();
        Ra.sl[3]=173; /* line # 173 */
        memcpy(Rv4+4,Rv1+4,36);
      }
      Rv3=((V *)Rv3)[0];
    }
    Rv2=((V *)Rv2)[0];
  }
  Ra.sl[3]=179; /* line # 179 */
  Rs.ub[4]=0;
  Rv2=Rs.v[2];
  while (Rv2!=NULL&&!Rs.ub[4]){
    Rv10=Rv2;
    Ra.sl[3]=184; /* line # 184 */
    Rs.ub[4]=(((((((((SL *)Rv10)[1]==-1&&((SL *)Rv10)[5]==-1)&&((SL *)Rv10)[9]==
-1)&&((SL *)Rv10)[2]==0)&&((SL *)Rv10)[3]==0)&&((SL *)Rv10)[4]==0)&&((SL *)Rv10)
    [6]==0)&&((SL *)Rv10)[7]==0)&&((SL *)Rv10)[8]==0;
    Rv2=((V *)Rv2)[0];
  }
  Ra.sl[3]=189; /* line # 189 */
  if (Rs.ub[4]) {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+170,-1,-1,32);
    PAS__WRITE_EOLN();
  }
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+204,-1,-1,32);
  PAS__WRITE_INT(Rv0,3,0);
  PAS__WRITE_STR(Rd.s+236,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " rmax "  */
F GENHKL_rmax(F F_v1, F F_v2, F F_v3){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  register F Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+249;
  Ra.v[2]=Rd.s+11;
  Ra.sl[3]=195; /* line # 195 */
  if (F_v1>F_v2) {
    if (F_v1>F_v3) Ret=F_v1;
    else Ret=F_v3;
  }
  else {
    if (F_v2>F_v3) Ret=F_v2;
    else Ret=F_v3;
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " rmin "  */
F GENHKL_rmin(F F_v1, F F_v2, F F_v3){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  register F Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+255;
  Ra.v[2]=Rd.s+11;
  Ra.sl[3]=203; /* line # 203 */
  if (F_v1<F_v2) {
    if (F_v1<F_v3) Ret=F_v1;
    else Ret=F_v3;
  }
  else {
    if (F_v2<F_v3) Ret=F_v2;
    else Ret=F_v3;
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " limit "  */
UB GENHKL_PRC_00000001(SL *F_indi, SL F_lim){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+261;
  Ra.v[2]=Rd.s+11;
  Ra.sl[3]=229; /* line # 229 */
  Ret=(*F_indi)==F_lim;
  if ((*F_indi)!=F_lim) (*F_indi)=(*F_indi)+1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " flag "  */
UB GENHKL_PRC_00000002(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+268;
  Ra.v[2]=Rd.s+11;
  Ra.sl[3]=235; /* line # 235 */
  Ret=Lx[0].sl[0]!=1;
  if (Lx[0].sl[0]==1) Lx[0].sl[0]=0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " sort "  */
void GENHKL_PRC_00000003(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  register int Rf2, Rf1, Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+274;
  Ra.v[2]=Rd.s+11;
  Ra.sl[3]=241; /* line # 241 */
  Rv0=1;
  for( Rf2=Lx[0].sl[10];Rf2>0;Rf2-- ) {
    Rv1=1;
    for( Rf1=Lx[0].sl[10];Rf1>0;Rf1-- ) {
      if (Rv0>Rv1) Lx[0].p[8].f[Rv0*3+Rv1-4]=(F)0.000000E-01;
      if (Lx[0].p[8].f[Rv0*3+Rv0-4]>Lx[0].p[8].f[Rv1*3+Rv1-4]) {
        Ra.sl[3]=247; /* line # 247 */
        Lx[0].f[1]=Lx[0].p[8].f[Rv0*3+Rv0-4];
        Lx[0].p[8].f[Rv0*3+Rv0-4]=Lx[0].p[8].f[Rv1*3+Rv1-4];
        Lx[0].p[8].f[Rv1*3+Rv1-4]=Lx[0].f[1];
        Rv2=1;
        for( Rf0=Lx[0].sl[10];Rf0>0;Rf0-- ) {
          Lx[0].f[1]=Lx[0].p[9].f[Rv2*3+Rv0-4];
          Lx[0].p[9].f[Rv2*3+Rv0-4]=Lx[0].p[9].f[Rv2*3+Rv1-4];
          Lx[0].p[9].f[Rv2*3+Rv1-4]=Lx[0].f[1];
          Rv2++;
        }
      }
      Rv1++;
    }
    Rv0++;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " compute "  */
void GENHKL_PRC_00000004(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  F Rv0;
  F Rv1;
  F Rv2;
  F Rv3;
  F Rv4;
  F Rv5;
  F Rv6;
  SL Rv7;
  SL Rv8;
  SL Rv9;
  SL Rv10;
  SL Rv11;
  register F Rgf;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+280;
  Ra.v[2]=Rd.s+11;
  Ra.sl[3]=262; /* line # 262 */
  Lx[0].sl[0]=1;
  Rv0=(F)5.000000E-01*(Lx[0].p[8].f[Lx[0].sl[2]*3+Lx[0].sl[2]-4]-Lx[0].p[8].f[Lx[0]
  .sl[3]*3+Lx[0].sl[3]-4]);
  Rv1= -Lx[0].p[8].f[Lx[0].sl[2]*3+Lx[0].sl[3]-4]/sqrt(PAS__F_SQR(Lx[0].p[8].f[Lx[0]
  .sl[2]*3+Lx[0].sl[3]-4]+Rv0*Rv0));
  if (Rv0<(F)0.000000E-01) Rv1= -Rv1;
  Rv2=Rv1/sqrt((F)2.000000E+00*((F)1.000000E+00+sqrt(fabs((F)1.000000E+00-Rv1*Rv1)
  )));
  Rv3=Rv2*Rv2;
  Rv4=(F)1.000000E+00-Rv3;
  Rv5=sqrt(Rv4);
  Ra.sl[3]=267; /* line # 267 */
  Rv6=Rv2*Rv5;
  Rv7=1;
  for( Rf0=Lx[0].sl[10];Rf0>0;Rf0-- ) {
    if (Rv7!=Lx[0].sl[2]&&Rv7!=Lx[0].sl[3]) {
      Ra.sl[3]=272; /* line # 272 */
      if (Rv7>Lx[0].sl[3]) {
        Rv8=Rv7;
        Rv9=Lx[0].sl[3];
      }
      else {
        Rv8=Lx[0].sl[3];
        Rv9=Rv7;
      }
      if (Rv7<Lx[0].sl[2]) {
        Ra.sl[3]=277; /* line # 277 */
        Rv10=Rv7;
        Rv11=Lx[0].sl[2];
      }
      else {
        Rv10=Lx[0].sl[2];
        Rv11=Rv7;
      }
      Rv0=Lx[0].p[8].f[Rv10*3+Rv11-4]*Rv5-Lx[0].p[8].f[Rv8*3+Rv9-4]*Rv2;
      Lx[0].p[8].f[Rv8*3+Rv9-4]=Lx[0].p[8].f[Rv10*3+Rv11-4]*Rv2+Lx[0].p[8].f[Rv8*
3+Rv9-4]*Rv5;
      Ra.sl[3]=282; /* line # 282 */
      Lx[0].p[8].f[Rv10*3+Rv11-4]=Rv0;
    }
    Rv0=Lx[0].p[9].f[Rv7*3+Lx[0].sl[2]-4]*Rv5-Lx[0].p[9].f[Rv7*3+Lx[0].sl[3]-4]*
    Rv2;
    Lx[0].p[9].f[Rv7*3+Lx[0].sl[3]-4]=Lx[0].p[9].f[Rv7*3+Lx[0].sl[2]-4]*Rv2+Lx[0]
    .p[9].f[Rv7*3+Lx[0].sl[3]-4]*Rv5;
    Lx[0].p[9].f[Rv7*3+Lx[0].sl[2]-4]=Rv0;
    Rv7++;
  }
  Ra.sl[3]=288; /* line # 288 */
  Rv0=((F)2.000000E+00*Lx[0].p[8].f[Lx[0].sl[2]*3+Lx[0].sl[3]-4])*Rv6;
  Rv1=(Lx[0].p[8].f[Lx[0].sl[2]*3+Lx[0].sl[2]-4]*Rv4+Lx[0].p[8].f[Lx[0].sl[3]*3+
  Lx[0].sl[3]-4]*Rv3)-Rv0;
  Rv0=(Lx[0].p[8].f[Lx[0].sl[2]*3+Lx[0].sl[2]-4]*Rv3+Lx[0].p[8].f[Lx[0].sl[3]*3+
  Lx[0].sl[3]-4]*Rv4)+Rv0;
  Lx[0].p[8].f[Lx[0].sl[2]*3+Lx[0].sl[3]-4]=(Lx[0].p[8].f[Lx[0].sl[2]*3+Lx[0].sl[
2]-4]-Lx[0].p[8].f[Lx[0].sl[3]*3+Lx[0].sl[3]-4])*Rv6+Lx[0].p[8].f[Lx[0].sl[2]*3+
  Lx[0].sl[3]-4]*(Rv4-Rv3);
  Lx[0].p[8].f[Lx[0].sl[2]*3+Lx[0].sl[2]-4]=Rv1;
  Lx[0].p[8].f[Lx[0].sl[3]*3+Lx[0].sl[3]-4]=Rv0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " eigenvalue "  */
void GENHKL_PRC_00000000(V F_mat, V F_hv, SL F_n){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );

  /* Local variable stored in C variable */
  F Rv0;
  SL Rv1;
  SL Rv2;
  F Rv3;
  F Rv4;
  register F Rgf;
  register int Rf1, Rf0;
  register P Lx_Sv;
  Lx_Sv=Lx[0];
  Lx[0].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[8]=F_mat;
  Ra.v[9]=F_hv;
  Ra.sl[10]=F_n;
  Ra.v[4]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+16;
  Ra.v[5]=Rd.s+289;
  Ra.v[6]=Rd.s+11;
  Ra.sl[7]=296; /* line # 296 */
  Rv0=(F)0.000000E-01;
  Rv1=1;
  for( Rf1=Ra.sl[10];Rf1>0;Rf1-- ) {
    Rv2=1;
    for( Rf0=Ra.sl[10];Rf0>0;Rf0-- ) {
      if (Rv1==Rv2) Ra.p[9].f[Rv1*3+Rv2-4]=(F)1.000000E+00;
      else {
        Ra.sl[7]=301; /* line # 301 */
        Ra.p[9].f[Rv1*3+Rv2-4]=(F)0.000000E-01;
        Rv0=Rv0+PAS__F_SQR(Ra.p[8].f[Rv1*3+Rv2-4]);
      }
      Rv2++;
    }
    Rv1++;
  }
  if (Rv0>(F)0.000000E-01) {
    Rv0=sqrt(fabs((F)2.000000E+00*Rv0));
    Ra.sl[7]=306; /* line # 306 */
    Rv3=(Rv0*(F)1.000000E-04)/(F)3.000000E+00;
    Ra.sl[0]=0;
    Rv4=Rv0;
    while (1){
      Rv4=Rv4/(float)Ra.sl[10];
      while (1){
        Ra.sl[7]=311; /* line # 311 */
        Ra.sl[2]=1;
        while (1){
          Ra.sl[3]=Ra.sl[2]+1;
          while (1){
            if (fabs(Ra.p[8].f[Ra.sl[2]*3+Ra.sl[3]-4])>=Rv4) GENHKL_PRC_00000004();
            if (GENHKL_PRC_00000001(Ra.sl+3,Ra.sl[10]))  break;
          }
          if (GENHKL_PRC_00000001(Ra.sl+2,Ra.sl[10]-1))  break;
        }
        if (GENHKL_PRC_00000002())  break;
      }
      if (Rv4<=Rv3)  break;
    }
  }
  Ra.sl[7]=321; /* line # 321 */
  GENHKL_PRC_00000003();
  PAS__curr_cntx=Ra.v[4];
  Lx[0]=Lx_Sv;
}


/* Procedure/Function : " cellsize "  */
void GENHKL_cellsize(SL *F_ia, SL *F_ib, SL *F_ic, F F_maxdist, F F_pa, F F_pb, 
F F_pc, F F_pal, F F_pbe, F F_pga){
  /* Define the automatic variable space. */
  Blk( Ra, 88 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  register F Rgf;
  register int Rf1, Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+301;
  Ra.v[2]=Rd.s+11;
  Ra.sl[3]=326; /* line # 326 */
  Ra.f[4]=F_pa*F_pa;
  Ra.f[8]=F_pb*F_pb;
  Ra.f[12]=F_pc*F_pc;
  Ra.f[9]=(F_pb*F_pc)*F_pal;
  Ra.f[11]=Ra.f[9];
  Ra.f[6]=(F_pc*F_pa)*F_pbe;
  Ra.f[10]=Ra.f[6];
  Ra.f[5]=(F_pa*F_pb)*F_pga;
  Ra.f[7]=Ra.f[5];
  GENHKL_PRC_00000000(Ra.s+16,Ra.s+52,3);
  Ra.sl[3]=332; /* line # 332 */
  Rv0=1;
  for( Rf1=3;Rf1>0;Rf1-- ) {
    Rv1=1;
    for( Rf0=3;Rf0>0;Rf0-- ) {
      Ra.f[Rv1*3+Rv0+9]=(Ra.f[Rv1*3+Rv0+9]*F_maxdist)/sqrt(Ra.f[Rv0*3+Rv0]);
      Rv1++;
    }
    Rv0++;
  }
  (*F_ia)=PAS__F_ROUND(GENHKL_rmax(fabs(Ra.f[13]),fabs(Ra.f[14]),fabs(Ra.f[15]))+
  (F)5.000000E-01);
  (*F_ib)=PAS__F_ROUND(GENHKL_rmax(fabs(Ra.f[16]),fabs(Ra.f[17]),fabs(Ra.f[18]))+
  (F)5.000000E-01);
  (*F_ic)=PAS__F_ROUND(GENHKL_rmax(fabs(Ra.f[19]),fabs(Ra.f[20]),fabs(Ra.f[21]))+
  (F)5.000000E-01);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " multiplicity "  */
SL GENHKL_multiplicity(SL F_ih, SL F_ik, SL F_il, SL F_nq, V *F_eqhkl){
  /* Define the automatic variable space. */
  Blk( Ra, 592 );

  /* Local variable stored in C variable */
  F Rv0;
  F Rv1;
  F Rv2;
  SL Rv3;
  SL Rv4;
  SL Rv5;
  SL Rv6;
  V Rv7;
  SL Rv8;
  register V Rv9;
  F Rv10;
  F Rv11;
  F Rv12;
  SL Rv13;
  UB Rv14;
  V Rv15;
  register V Rv16;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+311;
  Ra.v[2]=Rd.s+11;
  Ra.sl[3]=349; /* line # 349 */
  Rv0=(float)F_ih+(float)F_nq*Rs.f[3];
  Rv1=(float)F_ik+(float)F_nq*Rs.f[4];
  Rv2=(float)F_il+(float)F_nq*Rs.f[5];
  Rv3=F_ih;
  Rv4=F_ik;
  Rv5=F_il;
  Rv6=F_nq;
  Rv7=Rs.v[2];
  (*F_eqhkl)=NULL;
  if (Rv7==NULL) Ret=1;
  else {
    Ra.sl[3]=355; /* line # 355 */
    Rv8=0;
    while (1){
      Rv9=Rv7;
      Rv10=(Rv0*(float)((SL *)Rv9)[1]+Rv1*(float)((SL *)Rv9)[2])+Rv2*(float)((SL
       *)Rv9)[3];
      Ra.sl[3]=360; /* line # 360 */
      Rv11=(Rv0*(float)((SL *)Rv9)[4]+Rv1*(float)((SL *)Rv9)[5])+Rv2*(float)((SL
       *)Rv9)[6];
      Rv12=(Rv0*(float)((SL *)Rv9)[7]+Rv1*(float)((SL *)Rv9)[8])+Rv2*(float)((SL
       *)Rv9)[9];
      Rv13=1;
      Rv14=0;
      while (Rv13<=Rv8&&!Rv14){
        Ra.sl[3]=366; /* line # 366 */
        Rv14=(fabs(Ra.f[Rv13+3]-Rv10)+fabs(Ra.f[Rv13+51]-Rv11))+fabs(Ra.f[Rv13+99]
        -Rv12)<(F)1.000000E-05;
        Rv13=Rv13+1;
      }
      if (!Rv14) {
        Ra.sl[3]=372; /* line # 372 */
        Rv8=Rv8+1;
        Ra.f[Rv8+3]=Rv10;
        Ra.f[Rv8+51]=Rv11;
        Ra.f[Rv8+99]=Rv12;
        Rv15=PAS__NEW(16);
        Rv16=Rv15;
        ((F *)Rv16)[1]=Rv10;
        ((F *)Rv16)[2]=Rv11;
        ((F *)Rv16)[3]=Rv12;
        Ra.sl[3]=377; /* line # 377 */
        ((V *)Rv16)[0]=(*F_eqhkl);
        (*F_eqhkl)=Rv15;
      }
      Rv7=((V *)Rv7)[0];
      if (Rv7==NULL)  break;
    }
    Ra.sl[3]=382; /* line # 382 */
    Ret=Rv8;
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " dist "  */
F GENHKL_dist(SL F_h, SL F_k, SL F_l, SL F_nq){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  register F Rgf;
  register F Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+325;
  Ra.v[2]=Rd.s+11;
  Ra.sl[3]=388; /* line # 388 */
  Rs.f[6]=(float)F_h+(float)F_nq*Rs.f[3];
  Rs.f[7]=(float)F_k+(float)F_nq*Rs.f[4];
  Rs.f[8]=(float)F_l+(float)F_nq*Rs.f[5];
  Ret=sqrt(((PAS__F_SQR(Rs.f[9]*Rs.f[6])+PAS__F_SQR(Rs.f[10]*Rs.f[7]))+PAS__F_SQR
  (Rs.f[11]*Rs.f[8]))+(F)2.000000E+00*(((((Rs.f[12]*Rs.f[10])*Rs.f[11])*Rs.f[7])
  *Rs.f[8]+(((Rs.f[13]*Rs.f[11])*Rs.f[9])*Rs.f[8])*Rs.f[6])+(((Rs.f[14]*Rs.f[9])
  *Rs.f[10])*Rs.f[6])*Rs.f[7]));
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " outtriplet "  */
void GENHKL_outtriplet(V F_pt){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  F Rv1;
  register F Rgf;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+331;
  Ra.v[2]=Rd.s+11;
  Ra.sl[3]=397; /* line # 397 */
  Rv0=F_pt;
  if (((V *)Rv0)[1]!=NULL) GENHKL_outtriplet(((V *)Rv0)[1]);
  PAS__SELECT_OUT(Ri.v[0]);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_INT(((SL *)Rv0)[3],4,0);
  PAS__WRITE_INT(((SL *)Rv0)[4],4,0);
  PAS__WRITE_INT(((SL *)Rv0)[5],4,0);
  PAS__WRITE_INT(((SL *)Rv0)[6],4,0);
  PAS__WRITE_INT(((SL *)Rv0)[7],4,0);
  PAS__WRITE_SNGL(((F *)Rv0)[8],12,4,0);
  if (Rs.f[15]!=(F)0.000000E-01) {
    Ra.sl[3]=403; /* line # 403 */
    Rv1=(Rs.f[15]*((F *)Rv0)[8])*(F)5.000000E-01;
    if (fabs(Rv1)>(F)9.990000E-01) {
      PAS__SELECT_OUT(Ri.v[0]);
      PAS__WRITE_STR(Rd.s+343,-1,-1,32);
      PAS__WRITE_EOLN();
    }
    else {
      Rv1=Rv1/sqrt((F)1.000000E+00-Rv1*Rv1);
      PAS__SELECT_OUT(Ri.v[0]);
      PAS__WRITE_DBLE(5.729577957855228E+001*(double)atan(Rv1),10,3,0);
      PAS__WRITE_EOLN();
    }
  }
  else {
    Ra.sl[3]=409; /* line # 409 */
    PAS__SELECT_OUT(Ri.v[0]);
    PAS__WRITE_EOLN();
  }
  if (((V *)Rv0)[2]!=NULL) GENHKL_outtriplet(((V *)Rv0)[2]);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " genhkl "  */
main( int argc, C * argv[], C * env[] ) {
  /* Local variable stored in C variable */
  F Rv0;
  F Rv1;
  F Rv2;
  F Rv3;
  F Rv4;
  F Rv5;
  UB Rv6;
  C Rv7;
  SL Rv8;
  SL Rv9;
  SL Rv10;
  UB Rv11;
  SL Rv12;
  F Rv13;
  F Rv14;
  F Rv15;
  F Rv16;
  F Rv17;
  SL Rv18;
  SL Rv19;
  SL Rv20;
  V Rv21;
  SL Rv22;
  SL Rv23;
  SL Rv24;
  SL Rv25;
  SL Rv26;
  F Rv27;
  V Rv28;
  V Rv29;
  V Rv30;
  register V Rv31;
  SL Rv32;
  V Rv33;
  register V Rv34;
  register int Rgi;
  register int Rgj;
  register F Rgf;
  register int Rf3, Rf2, Rf1, Rf0;

  /* Code of procedure/function */
  PAS__INIT( argc, argv, env );
  Rs.v[16]=PAS__curr_cntx;
  PAS__curr_cntx=Rs.s+64;
  Rs.v[17]=Rd.s+355;
  Rs.v[18]=Rd.s+11;
  Rs.sl[19]=415; /* line # 415 */
  PAS__STR_TO_STR(Ri.s+22,Rd.s+363);
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+372,-1,-1,32);
  PAS__SELECT_INP(PAS__f_input);
  PAS__READ_STR(Ri.s+4,0,0);
  PAS__READ_EOLN();
  GENHKL_setsymlst();
  Rs.sl[19]=420; /* line # 420 */
  GENHKL_genspace();
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+394,-1,-1,32);
  PAS__SELECT_INP(PAS__f_input);
  PAS__READ_STR(Ri.s+4,0,0);
  PAS__READ_EOLN();
  PAS__OPEN(Ri.v,0, Ri.s+4,2,0,-1);
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+416,-1,-1,32);
  PAS__WRITE_EOLN();
  Rs.sl[19]=425; /* line # 425 */
  PAS__SELECT_INP(PAS__f_input);
  PAS__READ_SNGL(&Rv0,0);
  PAS__READ_SNGL(&Rv1,0);
  PAS__READ_SNGL(&Rv2,0);
  PAS__READ_SNGL(&Rv3,0);
  PAS__READ_SNGL(&Rv4,0);
  PAS__READ_SNGL(&Rv5,0);
  PAS__READ_EOLN();
  Rv6=0;
  while (1){
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_EOLN();
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+471,-1,-1,32);
    PAS__WRITE_EOLN();
    PAS__SELECT_INP(PAS__f_input);
    PAS__READ_CHAR(&Rv7);
    PAS__READ_EOLN();
    Rs.sl[19]=430; /* line # 430 */
    Rv8=1;
    while (!Rv6&&Rv8<8){
      Rv6=Ri.c[Rv8+23]==Rv7;
      Rv8=Rv8+1;
    }
    if (Rv8>8) {
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+512,-1,-1,32);
      PAS__WRITE_EOLN();
    }
    Rv8=Rv8-1;
    if (Rv6)  break;
  }
  Rs.sl[19]=436; /* line # 436 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+533,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_INP(PAS__f_input);
  PAS__READ_SNGL(Rs.f+3,0);
  PAS__READ_SNGL(Rs.f+4,0);
  PAS__READ_SNGL(Rs.f+5,0);
  PAS__READ_EOLN();
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+570,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_INP(PAS__f_input);
  PAS__READ_SL(&Rv9,0);
  PAS__READ_SL(&Rv10,0);
  PAS__READ_EOLN();
  Rs.sl[19]=441; /* line # 441 */
  if (Rv10<Rv9) {
    Rv11=1;
    Rv12=Rv10;
    Rv10=Rv9;
    Rv9=Rv12;
  }
  else Rv11=0;
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+622,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_INP(PAS__f_input);
  PAS__READ_SNGL(&Rv13,0);
  PAS__READ_EOLN();
  Rs.sl[19]=446; /* line # 446 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+657,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_INP(PAS__f_input);
  PAS__READ_SNGL(Rs.f+15,0);
  PAS__READ_EOLN();
  if (Rv3>(F)1.000000E+00) Rv3=(float)cos(1.745329310000000E-002*(double)Rv3);
  if (Rv4>(F)1.000000E+00) Rv4=(float)cos(1.745329310000000E-002*(double)Rv4);
  Rs.sl[19]=451; /* line # 451 */
  if (Rv5>(F)1.000000E+00) Rv5=(float)cos(1.745329310000000E-002*(double)Rv5);
  Rv14=Rv3*Rv3;
  Rv15=Rv4*Rv4;
  Rv16=Rv5*Rv5;
  Rv17=((Rv0*Rv1)*Rv2)*sqrt(((((F)1.000000E+00+(((F)2.000000E+00*Rv3)*Rv4)*Rv5)-
  Rv14)-Rv15)-Rv16);
  Rs.sl[19]=456; /* line # 456 */
  Rv14=sqrt((F)1.000000E+00-Rv14);
  Rv15=sqrt((F)1.000000E+00-Rv15);
  Rv16=sqrt((F)1.000000E+00-Rv16);
  Rs.f[12]=(Rv4*Rv5-Rv3)/(Rv15*Rv16);
  Rs.f[13]=(Rv5*Rv3-Rv4)/(Rv16*Rv14);
  Rs.f[14]=(Rv3*Rv4-Rv5)/(Rv14*Rv15);
  Rs.f[9]=((Rv1*Rv2)*Rv14)/Rv17;
  Rs.f[10]=((Rv2*Rv0)*Rv15)/Rv17;
  Rs.f[11]=((Rv0*Rv1)*Rv16)/Rv17;
  Rs.sl[19]=462; /* line # 462 */
  GENHKL_cellsize(&Rv18, &Rv19, &Rv20, Rv13, Rs.f[9],Rs.f[10],Rs.f[11],Rs.f[12],
  Rs.f[13],Rs.f[14]);
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+702,-1,-1,32);
  PAS__WRITE_INT(Rv18,3,0);
  PAS__WRITE_STR(Rd.s+710,-1,-1,32);
  PAS__WRITE_INT(Rv19,3,0);
  PAS__WRITE_STR(Rd.s+719,-1,-1,32);
  PAS__WRITE_INT(Rv20,3,0);
  PAS__WRITE_EOLN();
  Rv21=NULL;
  Rv22=0;
  Rv23=Rv18;
  for( Rf3=(Rv18+1)+Rv18;Rf3>0;Rf3-- ) {
    Rs.sl[19]=467; /* line # 467 */
    Rv24=Rv19;
    for( Rf2=(Rv19+1)+Rv19;Rf2>0;Rf2-- ) {
      Rv25=Rv20;
      for( Rf1=(Rv20+1)+Rv20;Rf1>0;Rf1-- ) {
        Rv26=Rv9;
        for( Rf0=(Rv10+1)-Rv9;Rf0>0;Rf0-- ) {
          if (!Rv11||Rv26!=0) {
            Rs.sl[19]=473; /* line # 473 */
            switch (Rv8) {
              case 1:Rv6=1;
              break;
              case 2:Rv6=(Rv24+Rv25&1)==0;
              break;
              case 3:Rv6=(Rv25+Rv23&1)==0;
              break;
              case 4:Rv6=(Rv23+Rv24&1)==0;
              break;
              case 5:Rs.sl[19]=478; /* line # 478 */
              Rv6=((Rv23+Rv24)+Rv25&1)==0;
              break;
              case 6:Rv6=PAS__I_MOD(( -Rv23+Rv24)+Rv25,3)==0;
              break;
              case 7:Rv6=(Rv23+Rv24&1)==0&&(Rv24+Rv25&1)==0;
              break;
            }
            if (Rv6) {
              Rs.sl[19]=484; /* line # 484 */
              Rv27=GENHKL_dist(Rv23, Rv24, Rv25, Rv26);
              Rv6=Rv27<=Rv13&&Rv27>=Rs.f[0];
            }
            if (Rv6) {
              Rs.sl[19]=490; /* line # 490 */
              Rv28=Rv21;
              Rv29=NULL;
              while (Rv28!=NULL&&Rv6){
                if (fabs(Rv27-((F *)Rv28)[8])<(F)1.000000E-05) {
                  Rs.sl[19]=496; /* line # 496 */
                  Rv30=((V *)Rv28)[0];
                  while (Rv30!=NULL&&Rv6){
                    Rv31=Rv30;
                    Rs.sl[19]=501; /* line # 501 */
                    Rv6=(fabs(Rs.f[6]-((F *)Rv31)[1])>(F)1.000000E-05||fabs(Rs.f[
7]-((F *)Rv31)[2])>(F)1.000000E-05)||fabs(Rs.f[8]-((F *)Rv31)[3])>(F)1.000000E-05;
                    if (Rv6) Rv30=((V *)Rv30)[0];
                    else Rv30=NULL;
                  }
                }
                Rs.sl[19]=506; /* line # 506 */
                if (Rv6) {
                  Rv32=(SL)(Rv27!=((F *)Rv28)[8]);
                  Rv29=Rv28;
                  if (Rv32!=0) {
                    Rs.sl[19]=511; /* line # 511 */
                    if (Rv27<((F *)Rv28)[8]) Rv32=-1;
                  }
                  if (Rv32<0) Rv28=((V *)Rv28)[1];
                  else Rv28=((V *)Rv28)[2];
                }
              }
              if (Rv6) {
                Rs.sl[19]=517; /* line # 517 */
                Rv22=Rv22+1;
                Rv33=PAS__NEW(36);
                Rv34=Rv33;
                ((V *)Rv34)[1]=NULL;
                ((V *)Rv34)[2]=NULL;
                Rs.sl[19]=522; /* line # 522 */
                ((SL *)Rv34)[3]=Rv23;
                ((SL *)Rv34)[4]=Rv24;
                ((SL *)Rv34)[5]=Rv25;
                ((SL *)Rv34)[6]=Rv26;
                ((SL *)Rv34)[7]=GENHKL_multiplicity(Rv23, Rv24, Rv25,((SL *)Rv34)
                [6],((V *)Rv34));
                ((F *)Rv34)[8]=Rv27;
                if (Rv29==NULL) Rv21=Rv33;
                else {
                  Rs.sl[19]=528; /* line # 528 */
                  if (Rv32<0) ((V *)Rv29)[1]=Rv33;
                  else((V *)Rv29)[2]=Rv33;
                }
              }
            }
          }
          Rv26++;
        }
        Rv25--;
      }
      Rv24--;
    }
    Rv23--;
  }
  if (Rv21!=NULL) {
    Rs.sl[19]=533; /* line # 533 */
    GENHKL_outtriplet(Rv21);
  }
  PAS__CLOSE(Ri.v,0);
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+728,-1,-1,32);
  PAS__WRITE_INT(Rv22,12,0);
  PAS__WRITE_STR(Rd.s+741,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Rs.v[16];
  PAS__EXIT( 0 );
}
