/*  P A S - P. WOLFERS SOFTWARE: V3.1-B4 OF 30-SEP-2016 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ long long int

/* Include the PAS environment file. */
#include <cpas_defs.h>

/* Define the local data section. */
static Blk( Rd, 256 ) = {{
 14,  14, 101, 114, 114,  95, 112, 117, 116,  95, 115, 121, 109,  98, 111, 108,
 73,  73,  47,  68,  47,  80, 105, 101, 114, 114, 101,  45,  68, 111,  99, 117,
109, 101, 110, 116, 115,  47, 115, 111, 102, 116,  47,  99, 112, 115, 104,  95,
115, 114,  99,  95, 107, 105, 116, 115,  47,  99, 112,  97, 115,  99,  97, 108,
 95, 115, 114,  99,  95,  86,  51,  46,  50,  65,  49,  47,  99, 112,  97, 115,
 95,  98,  95,  95, 101, 114, 114,  46, 112,  97, 115,  15,  15, 101, 114, 114,
 95,  99, 108, 114,  95, 115, 121, 109,  98, 116,  97,  98,  10,  10, 101, 114,
114,  95, 103, 101, 116, 109, 115, 103,  11,  11, 101, 114, 114,  95, 100, 105,
115, 112, 108,  97, 121,   2,   2,  32,  40,   5,   5,  41,  32,  45,  32,  65,
  8,   8,  32, 119,  97, 114, 110, 105, 110, 103,   7,   7, 110,  32, 101, 114,
114, 111, 114,  13,  13,  32, 115, 101, 118, 101, 114, 101,  32, 101, 114, 114,
111, 114,  12,  12,  32, 102,  97, 116,  97, 108,  32, 101, 114, 114, 111, 114,
  3,   3,  32,  35,  32,  20,  20,  32, 105, 115,  32, 100, 101, 116, 101,  99,
116, 101, 100,  32,  98, 121,  32, 116, 104, 101,  32,   8,   8,  32, 109, 111,
100, 117, 108, 101,  46,   8,   8,  32,  37,  42,  43,  42,  43,  42,  32,   8,
  8, 101, 114, 114,  95, 105, 110, 105, 116,   0,   0,   0,   0,   0,   0,   0
}};
/* Declaration of global variables. */
UB V_usr_err_flg;
Blk(V_usr_err_file_spc, 136 ) = {{
128,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0 }};
Blk(V_msg_err_file_spc, 136 ) = {{
128,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0 }};
UB V_error_result;
Blk(V_error_cnt, 24 );
Blk(V_errsymb_tab, 136 );
UL V_errsymb_cnt;

/* Function/procedure prototypes. */
void PAS__ERROR_GETMSG(SL F_n, V F_msgstr, V F_msgfil);


/* Procedure/Function : " err_put_symbol "  */
void P_err_put_symbol(V F_symb, SL F_len){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=126; /* line # 126 */
  if (V_errsymb_cnt<4&&F_len>0) {
    V_errsymb_cnt=V_errsymb_cnt+1;
    Rv0=F_len;
    if (Rv0>32) Rv0=32;
    Ra.sl[3]=131; /* line # 131 */
    V_errsymb_tab.c[V_errsymb_cnt*33-33]=(C)Rv0;
    Rv1=1;
    for( Rf0=Rv0;Rf0>0;Rf0-- ) {
      V_errsymb_tab.c[V_errsymb_cnt*33+Rv1-33]=((C *)F_symb)[Rv1-1];
      Rv1++;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " err_clr_symbtab "  */
void P_err_clr_symbtab(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+91;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=142; /* line # 142 */
  V_errsymb_cnt=0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " err_getmsg "  */
void P_err_getmsg(V F_erren){
  /* Define the automatic variable space. */
  Blk( Ra, 536 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  C Rv4;
  SL Rv5;
  register UB Rv6;
  register int Rf0;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.ub[257]=255;
  Ra.v[129]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+516;
  Ra.v[130]=Rd.s+108;
  Ra.v[131]=Rd.s+16;
  Ra.sl[132]=160; /* line # 160 */
  Rv0=((SL *)F_erren)[1];
  if (V_errsymb_cnt>0) {
    if (V_usr_err_flg) PAS__ERROR_GETMSG(Rv0, Ra.s,V_usr_err_file_spc.s);
    else {
      Ra.sl[132]=165; /* line # 165 */
      PAS__ERROR_GETMSG(Rv0, Ra.s,V_msg_err_file_spc.s);
    }
    Rv1=0;
    if (Ra.ub[1]>0) {
      Ra.sl[132]=171; /* line # 171 */
      Rv2=0;
      Rv3=0;
      while (Rv2<Ra.ub[1]&&Rv1<Ra.ub[257]){
        Rv2=Rv2+1;
        Rv4=Ra.c[Rv2+1];
        if (Rv4==96) {
          Ra.sl[132]=177; /* line # 177 */
          Rv3=Rv3+1;
          if (Rv3<=V_errsymb_cnt) {
            Rv5=1;
            for( Rf0=(SL)V_errsymb_tab.c[Rv3*33-33];Rf0>0;Rf0-- ) {
              if (Rv1<Ra.ub[257]) {
                Ra.sl[132]=182; /* line # 182 */
                Rv1=Rv1+1;
                Ra.c[Rv1+258]=V_errsymb_tab.c[Rv3*33+Rv5-33];
              }
              Rv5++;
            }
          }
        }
        else {
          Ra.sl[132]=187; /* line # 187 */
          Rv1=Rv1+1;
          Ra.c[Rv1+258]=Rv4;
        }
      }
    }
    Ra.ub[258]=Rv1;
    Ra.sl[132]=192; /* line # 192 */
    V_errsymb_cnt=0;
  }
  else {
    if (V_usr_err_flg) PAS__ERROR_GETMSG(Rv0, Ra.s+257,V_usr_err_file_spc.s);
    else {
      Ra.sl[132]=197; /* line # 197 */
      PAS__ERROR_GETMSG(Rv0, Ra.s+257,V_msg_err_file_spc.s);
    }
  }
  if (Ra.ub[258]>0) {
    Ra.sl[132]=203; /* line # 203 */
    if (((V *)F_erren)[4]!=NULL) PAS__DISPOSE(((V *)F_erren)+4);
    Rv6=Ra.ub[258];
    ((V *)F_erren)[4]=PAS__NEW((SL)Rv6+2);
    ((UB *)((V *)F_erren)[4])[0]=Rv6;
    PAS__STR_TO_STR(((V *)F_erren)[4],Ra.s+257);
  }
  PAS__curr_cntx=Ra.v[129];
}


/* Procedure/Function : " err_display "  */
void P_err_display(V *F_f, SL F_ie, V F_erren){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+120;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=218; /* line # 218 */
  PAS__SELECT_OUT((*F_f));
  PAS__WRITE_STR(Rd.s+133,-1,-1,32);
  PAS__WRITE_INT(F_ie,1,0);
  PAS__WRITE_STR(Rd.s+137,-1,-1,32);
  switch (((UB *)F_erren)[8]) {
    case 0:break;
    case 1:Ra.sl[3]=223; /* line # 223 */
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_STR(Rd.s+144,-1,-1,32);
    break;
    case 2:PAS__SELECT_OUT((*F_f));
    PAS__WRITE_STR(Rd.s+154,-1,-1,32);
    break;
    case 3:PAS__SELECT_OUT((*F_f));
    PAS__WRITE_STR(Rd.s+163,-1,-1,32);
    break;
    case 4:PAS__SELECT_OUT((*F_f));
    PAS__WRITE_STR(Rd.s+178,-1,-1,32);
    break;
  }
  Ra.sl[3]=228; /* line # 228 */
  PAS__SELECT_OUT((*F_f));
  PAS__WRITE_STR(Rd.s+192,-1,-1,32);
  PAS__WRITE_INT(((SL *)F_erren)[1],5,0);
  PAS__WRITE_STR(Rd.s+197,-1,-1,32);
  PAS__WRITE_CHT(F_erren+9,4,-1,-1,32);
  PAS__WRITE_STR(Rd.s+219,-1,-1,32);
  PAS__WRITE_EOLN();
  if (((V *)F_erren)[4]!=NULL) {
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_STR(Rd.s+229,-1,-1,32);
    PAS__WRITE_STR(((V *)F_erren)[4],-1,-1,32);
    PAS__WRITE_EOLN();
  }
  else {
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_EOLN();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " err_init "  */
void P_err_init(V F_errf_str){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+239;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=253; /* line # 253 */
  PAS__STR_TO_STR(V_msg_err_file_spc.s,F_errf_str);
  PAS__STR_TO_STR(V_usr_err_file_spc.s,Rd.s+249);
  V_usr_err_flg=0;
  V_errsymb_cnt=0;
  Ra.sl[3]=258; /* line # 258 */
  Rv0=0;
  for( Rf0=5;Rf0>0;Rf0-- ) {
    V_error_cnt.sl[Rv0]=0;
    Rv0++;
  }
  V_error_result=0;
  PAS__curr_cntx=Ra.v[0];
}
