/*  P A S - P. WOLFERS SOFTWARE: V3.1-B4 OF 30-SEP-2016 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ long long int
#define _FILE_DUPLICATE(fdst,fsrc) fdst = fsrc
#define _FILE_CLEAR(fdst) fdst = NULL

/* Include the PAS environment file. */
#include <cpas_defs.h>

/* Define the local data section. */
static Blk( Rd, 576 ) = {{
 12,  12, 115, 116, 114,  95,  99, 111, 112, 121,  95, 108, 105, 109,  62,  62,
 47, 104, 111, 109, 101,  47, 112, 105, 101, 114, 114, 101,  47,  83, 111, 102,
116,  47,  99, 112, 115, 104,  95, 107, 105, 116, 115,  47,  99, 112,  97, 115,
 99,  97, 108,  95, 115, 114,  99,  95,  86,  51,  46,  49,  66,  53,  47,  99,
112,  97, 115,  95,  98,  95,  95, 108, 115, 116,  46, 112,  97, 115,   8,   8,
108, 115, 116,  95, 105, 110, 105, 116,  12,  12, 108, 115, 116,  95,  97, 108,
108, 111,  99,  97, 116, 101,   8,   8, 108, 115, 116,  95, 102, 114, 101, 101,
  9,   9, 108, 115, 116,  95,  99, 108, 111, 115, 101,  18,  18, 108, 115, 116,
 95,  99, 104,  97, 110, 103, 101,  95, 104, 101,  97, 100, 105, 110, 103,   8,
  8,  82, 117, 110,  32, 116, 104, 101,  32,   4,   4,  32,  97, 116,  32,   2,
  2,  27,  92,   8,   8,  72,  69,  65,  68,  73,  78,  71,  32,   3,   3,  32,
 45,  32,   8,   8,  72,  69,  65,  68,  73,  78,  71,  32,  16,  16, 108, 115,
116,  95,  99, 104,  97, 110, 103, 101,  95, 116, 105, 116, 108, 101,   6,   6,
 84,  73,  84,  76,  69,  32,   7,   7,  84,  73,  84,  76,  69,  32,  48,  19,
 19, 108, 115, 116,  95,  99, 104,  97, 110, 103, 101,  95, 115, 117,  98, 116,
105, 116, 108, 101,   9,   9,  83,  85,  66,  84,  73,  84,  76,  69,  32,  10,
 10,  83,  85,  66,  84,  73,  84,  76,  69,  32,  48,   8,   8, 108, 115, 116,
 95, 111, 112, 101, 110,   0,   0,   0,   0,   0,   0,  11,  11, 108, 115, 116,
 95, 110, 101, 119, 108, 105, 110, 101,   5,   5,  80,  97, 103, 101,  32,   8,
  8, 108, 115, 116,  95, 101, 111, 108, 110,  15,  15, 108, 115, 116,  95,  98,
114, 101,  97, 107, 111, 117, 116, 112, 117, 116,   8,   8, 108, 115, 116,  95,
112,  97, 103, 101,  14,  14, 108, 115, 116,  95, 115, 101, 116,  95,  99, 111,
108, 117, 109, 110,  14,  14, 108, 115, 116,  95, 115, 101, 116,  95, 109,  97,
114, 103, 105, 110,  13,  13, 108, 115, 116,  95, 115, 107, 105, 112,  95, 108,
105, 110, 101,  10,  10,  92,  83,  75,  73,  80,  76,  73,  78,  69,  32,  17,
 17, 108, 115, 116,  95, 115, 101, 116,  95,  99, 104,  97, 114,  95,  97, 116,
116, 114,   3,   3,  78,  78,  78,   3,   3,  78,  78,  78,  11,  11,  92,  67,
 72,  65,  82,  95,  65,  84,  84,  82,  32,  13,  13, 108, 115, 116,  95, 116,
101, 115, 116,  95, 108, 105, 110, 101,  10,  10,  84,  69,  83,  84,  95,  76,
 73,  78,  69,  32,  12,  12, 108, 115, 116,  95, 112, 117, 116,  95,  99, 104,
 97, 114,  13,  13, 108, 115, 116,  95, 112, 117, 116,  95, 109,  99, 104,  97,
114,  14,  14, 108, 115, 116,  95, 112, 117, 116,  95, 115, 116, 114, 105, 110,
103,  11,  11, 108, 115, 116,  95, 112, 117, 116,  95, 105, 110, 116,  13,  13,
108, 115, 116,  95, 112, 117, 116,  95, 102, 108, 111,  97, 116,  13,  13, 108,
115, 116,  95, 112, 117, 116,  95, 102, 105, 120, 101, 100,  10,  10, 108, 115,
116,  95, 103,  95, 105, 110, 105, 116,   0,   0,   0,   0,   0,   0,   0,   0
}};

/* Declaration of external variables. */
extern V PAS__f_output;
extern SL PAS__iostatus;

/* Declaration of global variables. */
V V_lst_current = NULL;
V V_lst_hde = NULL;
UL V_lst_spc_mode = 0;
Blk(V_lst_date, 16 ) = {{
 14,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0 }};
Blk(V_lst_time, 16 ) = {{
 14,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0 }};

/* Function/procedure prototypes. */
void P_vls_nextstring();


/* Procedure/Function : " str_copy_lim "  */
void P_str_copy_lim(V *F_trg, V F_src, SL F_lim){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  register UB Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=146; /* line # 146 */
  Rv0=((UB *)F_src)[1];
  if (F_lim==0) F_lim=Rv0;
  else {
    if (Rv0>F_lim) Rv0=F_lim;
  }
  if ((*F_trg)!=NULL) PAS__DISPOSE(F_trg);
  if (Rv0>0) {
    Ra.sl[3]=152; /* line # 152 */
    Rv1=Rv0;
    (*F_trg)=PAS__NEW((SL)Rv1+2);
    ((UB *)(*F_trg))[0]=Rv1;
    PAS__STR_TO_STR((*F_trg),F_src);
  }
  else (*F_trg)=NULL;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_init "  */
void P_lst_init(V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+78;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=163; /* line # 163 */
  Rv0=F_p;
  ((V *)Rv0)[1]=NULL;
  ((V *)Rv0)[2]=NULL;
  Ra.sl[3]=168; /* line # 168 */
  ((V *)Rv0)[4]=NULL;
  ((V *)Rv0)[5]=NULL;
  ((SL *)Rv0)[6]=0;
  ((SL *)Rv0)[7]=0;
  ((SL *)Rv0)[8]=0;
  Ra.sl[3]=173; /* line # 173 */
  ((SL *)Rv0)[9]=0;
  ((SL *)Rv0)[10]=0;
  ((SL *)Rv0)[11]=0;
  ((UB *)Rv0)[48]=0;
  _FILE_CLEAR(((V *)Rv0)[13]);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_allocate "  */
V P_lst_allocate(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+88;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=188; /* line # 188 */
  Rv0=PAS__NEW(56);
  ((V *)Rv0)[0]=V_lst_hde;
  V_lst_hde=Rv0;
  ((V *)Rv0)[3]=PAS__NEW(34);
  ((UB *)((V *)Rv0)[3])[0]=32;
  P_lst_init(Rv0);
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lst_free "  */
void P_lst_free(V *F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+102;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=204; /* line # 204 */
  Rv0=NULL;
  if ((*F_p)!=NULL) {
    Rv1=V_lst_hde;
    while (Rv1!=(*F_p)&&Rv1!=NULL){
      Ra.sl[3]=210; /* line # 210 */
      Rv0=Rv1;
      Rv1=((V *)Rv1)[0];
    }
  }
  else Rv1=NULL;
  if (Rv1!=NULL) {
    Rv2=(*F_p);
    Ra.sl[3]=216; /* line # 216 */
    if (((V *)Rv2)[1]!=NULL) PAS__DISPOSE(((V *)Rv2)+1);
    if (((V *)Rv2)[3]!=NULL) PAS__DISPOSE(((V *)Rv2)+3);
    if (((V *)Rv2)[2]!=NULL) PAS__DISPOSE(((V *)Rv2)+2);
    if (((V *)Rv2)[4]!=NULL) PAS__DISPOSE(((V *)Rv2)+4);
    if (((V *)Rv2)[5]!=NULL) PAS__DISPOSE(((V *)Rv2)+5);
    Ra.sl[3]=221; /* line # 221 */
    if (Rv0==NULL) V_lst_hde=((V *)Rv2)[0];
    else((V *)Rv0)[0]=((V *)Rv2)[0];
    PAS__DISPOSE(F_p);
    (*F_p)=NULL;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_close "  */
void P_lst_close(V *F_p, UB F_bfree){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  UL Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+112;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=236; /* line # 236 */
  if ((*F_p)!=NULL) {
    Rv0=(*F_p);
    if (1&((UB *)Rv0)[48]) Rv1=1024;
    else {
      Ra.sl[3]=241; /* line # 241 */
      Rv1=0;
    }
    if ((68&((UB *)Rv0)[48])==0) PAS__CLOSE(((V *)Rv0)+13,Rv1);
    PAS__DISPOSE(((V *)Rv0)+1);
    ((V *)Rv0)[1]=NULL;
    if (((V *)Rv0)[2]!=NULL) {
      PAS__DISPOSE(((V *)Rv0)+2);
      ((V *)Rv0)[2]=NULL;
    }
    Ra.sl[3]=246; /* line # 246 */
    if (((V *)Rv0)[4]!=NULL) {
      PAS__DISPOSE(((V *)Rv0)+4);
      ((V *)Rv0)[4]=NULL;
    }
    if (((V *)Rv0)[5]!=NULL) {
      PAS__DISPOSE(((V *)Rv0)+5);
      ((V *)Rv0)[5]=NULL;
    }
    if (F_bfree) P_lst_free(F_p);
    else P_lst_init((*F_p));
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_change_heading "  */
void P_lst_change_heading(V F_str, UB F_bskp){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+123;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=262; /* line # 262 */
  Rv0=V_lst_current;
  Rv1=((((SL *)Rv0)[10]-32)-4)-12;
  Ra.sl[3]=267; /* line # 267 */
  if (Rv1<60) Rv1=60;
  P_str_copy_lim(((V *)Rv0)+2,F_str,Rv1);
  PAS__DATE_STR(V_lst_date.s);
  PAS__TIME_STR(V_lst_time.s);
  PAS__VWRITE_INIT(((V *)Rv0)[3],1);
  PAS__WRITE_STR(Rd.s+143,-1,-1,32);
  PAS__WRITE_STR(V_lst_date.s,-1,-1,32);
  PAS__WRITE_STR(Rd.s+153,-1,-1,32);
  PAS__WRITE_STR(V_lst_time.s,-1,-1,32);
  PAS__WRITE_EOLN();
  if (((SL *)Rv0)[11]<0) {
    Ra.sl[3]=273; /* line # 273 */
    if (((V *)Rv0)[2]!=NULL) {
      PAS__SELECT_OUT(((V *)Rv0)[13]);
      PAS__WRITE_STR(Rd.s+159,-1,-1,32);
      PAS__WRITE_STR(Rd.s+163,-1,-1,32);
      PAS__WRITE_INT(((UB *)((V *)Rv0)[2])[1]+((UB *)((V *)Rv0)[3])[1],0,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_STR(((V *)Rv0)[2],-1,-1,32);
      PAS__WRITE_STR(Rd.s+173,-1,-1,32);
      PAS__WRITE_STR(((V *)Rv0)[3],-1,-1,32);
      PAS__WRITE_EOLN();
    }
    else {
      PAS__SELECT_OUT(((V *)Rv0)[13]);
      PAS__WRITE_STR(Rd.s+159,-1,-1,32);
      PAS__WRITE_STR(Rd.s+178,-1,-1,32);
      PAS__WRITE_INT(((UB *)((V *)Rv0)[3])[1],0,0);
      PAS__WRITE_STR(((V *)Rv0)[3],-1,-1,32);
      PAS__WRITE_EOLN();
    }
    Ra.sl[3]=278; /* line # 278 */
    if (F_bskp) {
      PAS__SELECT_OUT(((V *)Rv0)[13]);
      PAS__WRITE_EOLN();
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_change_title "  */
void P_lst_change_title(V F_str, UB F_bskp){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+188;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=288; /* line # 288 */
  Rv0=V_lst_current;
  P_str_copy_lim(((V *)Rv0)+4,F_str,((SL *)Rv0)[10]-1);
  if (((SL *)Rv0)[11]<0) {
    Ra.sl[3]=293; /* line # 293 */
    if (((V *)Rv0)[4]!=NULL) {
      PAS__SELECT_OUT(((V *)Rv0)[13]);
      PAS__WRITE_STR(Rd.s+159,-1,-1,32);
      PAS__WRITE_STR(Rd.s+206,-1,-1,32);
      PAS__WRITE_INT(((UB *)((V *)Rv0)[4])[1],0,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_STR(((V *)Rv0)[4],-1,-1,32);
      PAS__WRITE_EOLN();
    }
    else {
      PAS__SELECT_OUT(((V *)Rv0)[13]);
      PAS__WRITE_STR(Rd.s+159,-1,-1,32);
      PAS__WRITE_STR(Rd.s+214,-1,-1,32);
      PAS__WRITE_EOLN();
    }
    if (F_bskp) {
      PAS__SELECT_OUT(((V *)Rv0)[13]);
      PAS__WRITE_EOLN();
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_change_subtitle "  */
void P_lst_change_subtitle(V F_str, UB F_bskp){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+223;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=305; /* line # 305 */
  Rv0=V_lst_current;
  P_str_copy_lim(((V *)Rv0)+5,F_str,((SL *)Rv0)[10]-1);
  if (((SL *)Rv0)[11]<0) {
    Ra.sl[3]=310; /* line # 310 */
    if (((V *)Rv0)[5]!=NULL) {
      PAS__SELECT_OUT(((V *)Rv0)[13]);
      PAS__WRITE_STR(Rd.s+159,-1,-1,32);
      PAS__WRITE_STR(Rd.s+244,-1,-1,32);
      PAS__WRITE_INT(((UB *)((V *)Rv0)[5])[1],0,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_STR(((V *)Rv0)[5],-1,-1,32);
      PAS__WRITE_EOLN();
    }
    else {
      PAS__SELECT_OUT(((V *)Rv0)[13]);
      PAS__WRITE_STR(Rd.s+159,-1,-1,32);
      PAS__WRITE_STR(Rd.s+255,-1,-1,32);
      PAS__WRITE_EOLN();
    }
    if (F_bskp) {
      PAS__SELECT_OUT(((V *)Rv0)[13]);
      PAS__WRITE_EOLN();
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_open "  */
void P_lst_open(V *F_p, V F_fspc, V F_heading, V F_title, V F_sbttl, SL F_lnsize
, SL F_pgsize, UB F_bunknown, UB F_bprint, UB F_bappend, SL *F_ierr){
  /* Define the automatic variable space. */
  Blk( Ra, 792 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  UL Rv2;
  register UB Rv3;
  SL Rv4;
  UB Rv5;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.ub[257]=255;
  Ra.ub[514]=255;
  Ra.v[193]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+772;
  Ra.v[194]=Rd.s+267;
  Ra.v[195]=Rd.s+14;
  Ra.sl[196]=352; /* line # 352 */
  if (F_heading!=NULL) PAS__STR_TO_STR(Ra.s,F_heading);
  else PAS__STR_TO_STR(Ra.s,Rd.s+277);
  if (F_title!=NULL) PAS__STR_TO_STR(Ra.s+257,F_title);
  else PAS__STR_TO_STR(Ra.s+257,Rd.s+279);
  if (F_sbttl!=NULL) PAS__STR_TO_STR(Ra.s+514,F_sbttl);
  else PAS__STR_TO_STR(Ra.s+514,Rd.s+281);
  Ra.sl[196]=357; /* line # 357 */
  Rv0=(*F_p)!=NULL;
  if ((*F_p)==NULL) (*F_p)=P_lst_allocate();
  else P_lst_close(F_p,0);
  Rv1=(*F_p);
  Ra.sl[196]=362; /* line # 362 */
  if (((UB *)F_fspc)[1]==0) {
    _FILE_DUPLICATE(((V *)Rv1)[13],PAS__f_output);
    ((UB *)Rv1)[48]=4;
    PAS__iostatus=0;
  }
  else {
    Ra.sl[196]=370; /* line # 370 */
    Rv2=4098|V_lst_spc_mode;
    if (F_bprint) ((UB *)Rv1)[48]=1;
    if (F_bappend) Rv2=Rv2|4;
    if (F_bunknown) Rv2=Rv2|64;
    PAS__OPEN(((V *)Rv1)+13,0, F_fspc,Rv2,0,-1);
  }
  Ra.sl[196]=377; /* line # 377 */
  if (PAS__iostatus==0) {
    if (PAS__TTY_FILE(((V *)Rv1)[13])) {
      ((UB *)Rv1)[48]=((UB *)Rv1)[48]|2;
      Ra.sl[196]=382; /* line # 382 */
      ((UB *)Rv1)[48]=((UB *)Rv1)[48]&~1;
      if (F_lnsize<0) F_lnsize=80;
      if (F_pgsize<0) F_pgsize=0;
    }
    else {
      Ra.sl[196]=388; /* line # 388 */
      if (F_lnsize<0) F_lnsize=132;
      if (F_pgsize==0) F_pgsize=-1;
      else {
        if (F_pgsize<0) F_pgsize=60;
      }
    }
    Ra.sl[196]=393; /* line # 393 */
    Rv3=F_lnsize;
    ((V *)Rv1)[1]=PAS__NEW((SL)Rv3+2);
    ((UB *)((V *)Rv1)[1])[0]=Rv3;
    ((UB *)((V *)Rv1)[1])[1]=0;
    Rv4=F_lnsize-1;
    ((SL *)Rv1)[11]=F_pgsize;
    ((SL *)Rv1)[10]=F_lnsize;
    Ra.sl[196]=398; /* line # 398 */
    ((SL *)Rv1)[9]=((SL *)Rv1)[10];
    ((SL *)Rv1)[6]=((SL *)Rv1)[11];
    Rv5=0;
    if (Ra.ub[1]>0) {
      Rv5=1;
      P_lst_change_heading(Ra.s,0);
    }
    Ra.sl[196]=403; /* line # 403 */
    if (Ra.ub[258]>0) {
      Rv5=1;
      P_lst_change_title(Ra.s+257,0);
    }
    if (Ra.ub[515]>0) {
      Rv5=1;
      P_lst_change_subtitle(Ra.s+514,1);
    }
    if (Rv5&&((SL *)Rv1)[11]<0) {
      PAS__SELECT_OUT(((V *)Rv1)[13]);
      PAS__WRITE_EOLN();
    }
    (*F_ierr)=0;
  }
  else {
    Ra.sl[196]=408; /* line # 408 */
    (*F_ierr)=2000+PAS__iostatus;
  }
  if ((*F_ierr)!=0) {
    if (!Rv0) P_lst_free(F_p);
  }
  PAS__curr_cntx=Ra.v[193];
}


/* Procedure/Function : " lst_newline "  */
void P_lst_newline(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+283;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=420; /* line # 420 */
  Rv0=V_lst_current;
  if (!(64&((UB *)Rv0)[48])) {
    if (((SL *)Rv0)[11]>=10) {
      ((SL *)Rv0)[6]=((SL *)Rv0)[6]+1;
      Ra.sl[3]=425; /* line # 425 */
      if (((SL *)Rv0)[6]>=((SL *)Rv0)[11]) {
        ((SL *)Rv0)[6]=0;
        ((SL *)Rv0)[7]=((SL *)Rv0)[7]+1;
        PAS__PAGE(((V *)Rv0)[13]);
        Ra.sl[3]=430; /* line # 430 */
        if (((V *)Rv0)[2]!=NULL) {
          PAS__SELECT_OUT(((V *)Rv0)[13]);
          PAS__WRITE_CHAR(32);
          PAS__WRITE_STR(((V *)Rv0)[2],-1,-1,32);
          if (((SL *)Rv0)[10]<110) {
            ((SL *)Rv0)[6]=1;
            PAS__SELECT_OUT(((V *)Rv0)[13]);
            PAS__WRITE_EOLN();
          }
          else {
            PAS__SELECT_OUT(((V *)Rv0)[13]);
            PAS__WRITE_STR(Rd.s+173,-1,-1,32);
          }
          Ra.sl[3]=435; /* line # 435 */
          PAS__DATE_STR(V_lst_date.s);
          PAS__TIME_STR(V_lst_time.s);
          PAS__SELECT_OUT(((V *)Rv0)[13]);
          PAS__WRITE_STR(((V *)Rv0)[3],-1,-1,32);
          PAS__WRITE_FCHAR(32,4,-1,1,32);
          PAS__WRITE_STR(Rd.s+296,-1,-1,32);
          PAS__WRITE_INT(((SL *)Rv0)[7],3,0);
          PAS__WRITE_EOLN();
        }
        if (((V *)Rv0)[4]!=NULL) {
          PAS__SELECT_OUT(((V *)Rv0)[13]);
          PAS__WRITE_STR(((V *)Rv0)[4],-1,-1,32);
        }
        PAS__SELECT_OUT(((V *)Rv0)[13]);
        PAS__WRITE_EOLN();
        Ra.sl[3]=440; /* line # 440 */
        if (((V *)Rv0)[5]!=NULL) {
          PAS__SELECT_OUT(((V *)Rv0)[13]);
          PAS__WRITE_EOLN();
          PAS__SELECT_OUT(((V *)Rv0)[13]);
          PAS__WRITE_STR(((V *)Rv0)[5],-1,-1,32);
          PAS__WRITE_EOLN();
          ((SL *)Rv0)[6]=((SL *)Rv0)[6]+2;
        }
        Ra.sl[3]=446; /* line # 446 */
        PAS__SELECT_OUT(((V *)Rv0)[13]);
        PAS__WRITE_EOLN();
        ((SL *)Rv0)[6]=((SL *)Rv0)[6]+3;
      }
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_eoln "  */
void P_lst_eoln(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+303;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=459; /* line # 459 */
  P_lst_newline();
  Rv0=V_lst_current;
  Rv1=((V *)Rv0)[1];
  if (64&((UB *)Rv0)[48]) {
    Ra.sl[3]=464; /* line # 464 */
    P_vls_nextstring();
    ((UB *)Rv0)[48]=((UB *)Rv0)[48]&~8;
  }
  else {
    Ra.sl[3]=469; /* line # 469 */
    if (((UB *)Rv1)[1]>0) {
      PAS__SELECT_OUT(((V *)Rv0)[13]);
      PAS__WRITE_STR(((V *)Rv0)[1],-1,-1,32);
      ((UB *)Rv1)[1]=0;
    }
    Ra.sl[3]=474; /* line # 474 */
    if (8&((UB *)Rv0)[48]) ((UB *)Rv0)[48]=((UB *)Rv0)[48]&~8;
    else {
      PAS__SELECT_OUT(((V *)Rv0)[13]);
      PAS__WRITE_EOLN();
    }
  }
  while (((UB *)Rv1)[1]<((SL *)Rv0)[8]){
    Ra.sl[3]=479; /* line # 479 */
    ((UB *)Rv1)[1]=((UB *)Rv1)[1]+1;
    ((C *)Rv1)[((UB *)Rv1)[1]+1]=32;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_breakoutput "  */
void P_lst_breakoutput(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+313;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=491; /* line # 491 */
  Rv0=V_lst_current;
  ((UB *)Rv0)[48]=((UB *)Rv0)[48]|8;
  P_lst_eoln();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_page "  */
void P_lst_page(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+330;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=503; /* line # 503 */
  P_lst_eoln();
  Rv0=V_lst_current;
  if (((SL *)Rv0)[11]>=10) ((SL *)Rv0)[6]=((SL *)Rv0)[11];
  else {
    if (!(64&((UB *)Rv0)[48])) PAS__PAGE(((V *)Rv0)[13]);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_set_column "  */
void P_lst_set_column(SL F_col){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+340;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=515; /* line # 515 */
  Rv0=V_lst_current;
  Rv1=((V *)Rv0)[1];
  if (F_col>((SL *)Rv0)[9]) P_lst_eoln();
  else {
    Ra.sl[3]=520; /* line # 520 */
    F_col=F_col-1;
    if (((UB *)Rv1)[1]>F_col) P_lst_eoln();
    while (((UB *)Rv1)[1]<F_col){
      ((UB *)Rv1)[1]=((UB *)Rv1)[1]+1;
      Ra.sl[3]=525; /* line # 525 */
      ((C *)Rv1)[((UB *)Rv1)[1]+1]=32;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_set_margin "  */
void P_lst_set_margin(SL F_lm, SL F_rm){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  SL Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+356;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=538; /* line # 538 */
  Rv0=V_lst_current;
  Rv1=((V *)Rv0)[1];
  if ((F_lm>=0&&F_rm>F_lm)&&F_rm<=((SL *)Rv0)[10]) {
    Rv2=((SL *)Rv0)[8];
    ((SL *)Rv0)[8]=F_lm;
    Ra.sl[3]=543; /* line # 543 */
    ((SL *)Rv0)[9]=F_rm;
    if (((UB *)Rv1)[1]>Rv2) P_lst_eoln();
    else while (((UB *)Rv1)[1]<F_lm){
      Ra.sl[3]=549; /* line # 549 */
      ((UB *)Rv1)[1]=((UB *)Rv1)[1]+1;
      ((C *)Rv1)[((UB *)Rv1)[1]+1]=32;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_skip_line "  */
void P_lst_skip_line(SL F_nli){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+372;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=560; /* line # 560 */
  if (((SL *)V_lst_current)[11]<0) {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+387,-1,-1,32);
    PAS__WRITE_INT(F_nli,0,0);
    PAS__WRITE_EOLN();
  }
  else while (F_nli>0){
    Ra.sl[3]=565; /* line # 565 */
    P_lst_eoln();
    F_nli=F_nli-1;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_set_char_attr "  */
void P_lst_set_char_attr(V F_sattr){
  /* Define the automatic variable space. */
  Blk( Ra, 24 );

  /* Local variable stored in C variable */
  register V Rv0;
  UB Rv1;
  SL Rv2;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+399;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=578; /* line # 578 */
  Rv0=V_lst_current;
  if (((SL *)Rv0)[11]<0) {
    Rv1=1;
    PAS__CHT_TO_CHT(Ra.s+16,3, Rd.s+420,3);
    Ra.sl[3]=583; /* line # 583 */
    Rv2=1;
    for( Rf0=((UB *)F_sattr)[1];Rf0>0;Rf0-- ) {
      switch (((C *)F_sattr)[Rv2+1]) {
        case 43:Rv1=1;
        break;
        case 45:Rv1=0;
        break;
        case 66:
        case 71:
        case 98:
        case 103:Ra.sl[3]=590; /* line # 590 */
        if (Rv1) Ra.c[16]=66;
        else Ra.c[16]=78;
        break;
        case 73:
        case 105:if (Rv1) Ra.c[17]=73;
        else Ra.c[17]=78;
        break;
        case 83:
        case 85:
        case 115:
        case 117:Ra.sl[3]=597; /* line # 597 */
        if (Rv1) Ra.c[18]=83;
        else Ra.c[18]=78;
        break;
        case 78:
        case 110:Rv1=1;
        PAS__CHT_TO_CHT(Ra.s+16,3, Rd.s+425,3);
        break;
        default:break;
      }
      Rv2++;
    }
    Ra.sl[3]=604; /* line # 604 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+428,-1,-1,32);
    PAS__WRITE_STR(F_sattr,-1,-1,32);
    PAS__WRITE_EOLN();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_test_line "  */
void P_lst_test_line(SL F_iskip, SL F_tstli){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+441;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=613; /* line # 613 */
  Rv0=V_lst_current;
  if (((SL *)Rv0)[11]>10) {
    if (F_tstli>((SL *)Rv0)[11]/2) F_tstli=((SL *)Rv0)[11]/2;
    if (F_iskip>F_tstli) F_iskip=F_tstli;
    Ra.sl[3]=618; /* line # 618 */
    if (((SL *)Rv0)[11]-((SL *)Rv0)[6]>=F_tstli) P_lst_skip_line(F_iskip);
    else((SL *)Rv0)[6]=((SL *)Rv0)[11]+1;
  }
  else {
    if (((SL *)Rv0)[11]<0) {
      PAS__SELECT_OUT(((V *)Rv0)[13]);
      PAS__WRITE_STR(Rd.s+159,-1,-1,32);
      PAS__WRITE_STR(Rd.s+456,-1,-1,32);
      PAS__WRITE_INT(F_iskip,0,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_INT(F_tstli,0,0);
      PAS__WRITE_EOLN();
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_put_char "  */
void P_lst_put_char(C F_ch){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+468;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=633; /* line # 633 */
  Rv0=V_lst_current;
  Rv1=((V *)Rv0)[1];
  if (((UB *)Rv1)[1]>=((SL *)Rv0)[9]) P_lst_eoln();
  ((UB *)Rv1)[1]=((UB *)Rv1)[1]+1;
  ((C *)Rv1)[((UB *)Rv1)[1]+1]=F_ch;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_put_mchar "  */
void P_lst_put_mchar(C F_ch, SL F_m){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+482;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=645; /* line # 645 */
  Rv0=V_lst_current;
  if (F_m>0) while (F_m>0){
    Ra.sl[3]=650; /* line # 650 */
    P_lst_put_char(F_ch);
    F_m=F_m-1;
  }
  else {
    Rv1=((V *)Rv0)[1];
    Ra.sl[3]=656; /* line # 656 */
    F_m= -F_m-1;
    if (F_m>=((UB *)Rv1)[0]) F_m=0;
    if (((UB *)Rv1)[1]>F_m) P_lst_eoln();
    while (((UB *)Rv1)[1]<F_m){
      Ra.sl[3]=661; /* line # 661 */
      ((UB *)Rv1)[1]=((UB *)Rv1)[1]+1;
      ((C *)Rv1)[((UB *)Rv1)[1]+1]=F_ch;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_put_string "  */
void P_lst_put_string(V F_str){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+497;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=678; /* line # 678 */
  Rv0=V_lst_current;
  Rv1=((V *)Rv0)[1];
  if (((UB *)F_str)[1]>0) {
    Rv2=((SL *)Rv0)[9]-((SL *)Rv0)[8];
    Ra.sl[3]=683; /* line # 683 */
    if (Rv2>=((UB *)F_str)[1]) {
      if (((SL *)Rv0)[9]-((UB *)Rv1)[1]<((UB *)F_str)[1]) P_lst_eoln();
      Ra.sl[3]=688; /* line # 688 */
      Rv3=1;
      for( Rf0=((UB *)F_str)[1];Rf0>0;Rf0-- ) {
        P_lst_put_char(((C *)F_str)[Rv3+1]);
        Rv3++;
      }
    }
    else {
      Rv4=1;
      for( Rf0=((UB *)F_str)[1];Rf0>0;Rf0-- ) {
        Ra.sl[3]=693; /* line # 693 */
        P_lst_put_char(((C *)F_str)[Rv4+1]);
        Rv4++;
      }
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_put_int "  */
void P_lst_put_int(SL F_int, SL F_size, SL F_base){
  /* Define the automatic variable space. */
  Blk( Ra, 56 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.ub[0]=34;
  Ra.v[9]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+36;
  Ra.v[10]=Rd.s+513;
  Ra.v[11]=Rd.s+14;
  Ra.sl[12]=705; /* line # 705 */
  Rv0=V_lst_current;
  Rv1=((V *)Rv0)[1];
  if (((SL *)Rv0)[9]-((UB *)Rv1)[1]<abs(F_size)) P_lst_eoln();
  PAS__VWRITE_INIT(Ra.s,1);
  PAS__WRITE_INT(F_int, F_size, F_base);
  PAS__WRITE_EOLN();
  P_lst_put_string(Ra.s);
  PAS__curr_cntx=Ra.v[9];
}


/* Procedure/Function : " lst_put_float "  */
void P_lst_put_float(G F_dv, SL F_fs, SL F_dcsz, SL F_es){
  /* Define the automatic variable space. */
  Blk( Ra, 56 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.ub[0]=32;
  Ra.v[9]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+36;
  Ra.v[10]=Rd.s+526;
  Ra.v[11]=Rd.s+14;
  Ra.sl[12]=721; /* line # 721 */
  Rv0=V_lst_current;
  Rv1=((V *)Rv0)[1];
  if (((SL *)Rv0)[9]-((UB *)Rv1)[1]<F_fs) P_lst_eoln();
  PAS__VWRITE_INIT(Ra.s,1);
  PAS__WRITE_DBLE(F_dv, F_fs, F_dcsz, F_es);
  PAS__WRITE_EOLN();
  P_lst_put_string(Ra.s);
  PAS__curr_cntx=Ra.v[9];
}


/* Procedure/Function : " lst_put_fixed "  */
void P_lst_put_fixed(G F_dv, SL F_fs, SL F_dcsz, SL F_dcmin){
  /* Define the automatic variable space. */
  Blk( Ra, 56 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.ub[0]=32;
  Ra.v[9]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+36;
  Ra.v[10]=Rd.s+541;
  Ra.v[11]=Rd.s+14;
  Ra.sl[12]=737; /* line # 737 */
  Rv0=V_lst_current;
  Rv1=((V *)Rv0)[1];
  if (((SL *)Rv0)[9]-((UB *)Rv1)[1]<F_fs) P_lst_eoln();
  PAS__VWRITE_INIT(Ra.s,1);
  PAS__WRITE_DBLE(F_dv, F_fs, F_dcsz, F_dcmin);
  PAS__WRITE_EOLN();
  P_lst_put_string(Ra.s);
  PAS__curr_cntx=Ra.v[9];
}


/* Procedure/Function : " lst_g_init "  */
void P_lst_g_init(V F_def_lst, V F_def_heading, SL *F_ierr){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+556;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=759; /* line # 759 */
  V_lst_hde=NULL;
  V_lst_current=NULL;
  P_lst_open(&V_lst_current, F_def_lst,F_def_heading,Rd.s+568,Rd.s+568,132,0,0,0,0,
  F_ierr);
  PAS__curr_cntx=Ra.v[0];
}
