/*  P A S - P. WOLFERS SOFTWARE: V3.1-B4 OF 30-SEP-2016 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ long long int

/* Include the PAS environment file. */
#include <cpas_defs.h>

/* Define the local data section. */
static Blk( Rd, 8 ) = {{
  4,   4,  58,  47,  93,  92,   0,   0
}};




/* Procedure/Function : " get_phy_fspc "  */
V CPAS__PYSIC_PRC_00000000(V Ret, V F_fsp, SL F_irep, SL *F_ierr){
  /* Define the automatic variable space. */
  Blk( Ra, 1032 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.ub[257]=255;
  ((UB *)Ret)[0]=255;
  if (F_irep<=10) {
    PAS__STR_TO_STR(Ra.s,F_fsp);
    Rv0=Ra.ub[1];
    Rv1=PAS__INDEX_CHA(Ra.s+2,(SL)Ra.ub[1],58);
    if (Rv1>0) Ra.ub[1]=Rv1-1;
    else Rv1=Ra.ub[1];
    (*F_ierr)=PAS__GETENV(Ra.s+257,Ra.s);
    Ra.ub[1]=Rv0;
    if ((*F_ierr)!=0) Ra.ub[258]=0;
    if ((*F_ierr)==-1) (*F_ierr)=0;
    if (Ra.ub[258]==0) PAS__STR_TO_STR(Ret,Ra.s);
    else {
      Rv2=PAS__INDEX_CHA(Rd.s+2,4, Ra.c[(Rv1+1)+1]);
      Rv3=PAS__INDEX_CHA(Rd.s+2,4, Ra.c[Ra.ub[258]+258]);
      if (Rv2>0||Rv3>0) {
        if (Rv2==Rv3) Rv1=Rv1+1;
        Rv0=Ra.ub[1]-Rv1;
        if (((UB *)Ret)[0]<Ra.ub[258]+Rv0) (*F_ierr)=-2;
        if (Rv0>0) PAS__STR_TO_STR(Ra.s,PAS__CON_STR_STR(Ra.s+771,Ra.s+257,PAS__SUBSTR_STR(
        Ra.s+514,Ra.s,Rv1+1,0)));
        else PAS__STR_TO_STR(Ra.s,Ra.s+257);
      }
      else PAS__STR_TO_STR(Ra.s,Ra.s+257);
      if ((*F_ierr)==0) PAS__STR_TO_STR(Ret,CPAS__PYSIC_PRC_00000000(Ra.s+514,Ra.
      s,F_irep+1, F_ierr));
      else PAS__STR_TO_STR(Ret,Ra.s);
    }
  }
  else (*F_ierr)=-100;
  return(Ret);
}


/* Procedure/Function : " get_physic_fspc "  */
SL PAS__GETPHYSIC(V F_trg, V F_spc){
  /* Define the automatic variable space. */
  Blk( Ra, 264 );

  /* Local variable stored in C variable */
  SL Rv0;
  register SL Ret;

  /* Code of procedure/function */
  PAS__STR_TO_STR(F_trg,CPAS__PYSIC_PRC_00000000(Ra.s,F_spc,1, &Rv0));
  Ret=Rv0;
  return(Ret);
}
