/*  P A S - P. WOLFERS SOFTWARE: V3.1-B4 OF 30-SEP-2016 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ long long int

/* Include the PAS environment file. */
#include <cpas_defs.h>

/* Define the local data section. */
static Blk( Rd, 72 ) = {
  5,   5, 105, 105, 112, 111, 119,  63,  63,  47, 104, 111, 109, 101,  47, 112,
105, 101, 114, 114, 101,  47,  83, 111, 102, 116,  47,  99, 112, 115, 104,  95,
107, 105, 116, 115,  47,  47,  99, 112,  97, 115,  99,  97, 108,  95, 115, 114,
 99,  95,  86,  51,  46,  49,  66,  52,  47,  99, 112,  97, 115,  95,  95, 105,
105, 112, 111, 119,  46, 112,  97, 115
};




/* Procedure/Function : " iipow "  */
SL PAS__IIPOWER(SL F_z, SL F_n){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  register int Rgi;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+7;
  Ra.sl[3]=60; /* line # 60 */
  if (F_n<0) {
    if (F_z==1) Rv0=1;
    else Rv0=0;
  }
  else {
    Rv0=1;
    Ra.sl[3]=65; /* line # 65 */
    while (F_n>0)
    if (F_n&1) {
      F_n=F_n-1;
      Rv0=Rv0*F_z;
    }
    else {
      Ra.sl[3]=72; /* line # 72 */
      F_n=F_n/2;
      F_z=F_z*F_z;
    }
  }
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}
