/*  P A S - P. WOLFERS SOFTWARE: V3.1-B2 OF 30-JUN-2016 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ long long int
#define _FILE_DUPLICATE(fdst,fsrc) fdst = fsrc
#define _FILE_CLEAR(fdst) fdst = NULL

/* Include the PAS environment file. */
#include <cpas_defs.h>

/* Define the local data section. */
static Blk( Rd, 584 ) = {
 10,  10, 115, 114,  99,  95, 114,  95, 105, 110, 105, 116,  63,  63,  47, 104,
111, 109, 101,  47, 112, 105, 101, 114, 114, 101,  47,  83, 111, 102, 116,  47,
 99, 112, 115, 104,  95, 107, 105, 116, 115,  47,  47,  99, 112,  97, 115,  99,
 97, 108,  95, 115, 114,  99,  95,  86,  51,  46,  49,  66,  50,  47,  99, 112,
 97, 115,  95,  98,  95,  95, 115, 114,  99,  46, 112,  97, 115,  12,  12, 115,
114,  99,  95,  97, 108, 108, 111,  99,  97, 116, 101,   8,   8, 115, 114,  99,
 95, 102, 114, 101, 101,   9,   9, 115, 114,  99,  95,  99, 108, 111, 115, 101,
  8,   8, 115, 114,  99,  95, 111, 112, 101, 110,  17,  17, 115, 114,  99,  95,
 97,  99, 116, 105, 118, 101,  95, 115, 111, 117, 114,  99, 101,  14,  14, 115,
114,  99,  95, 109,  97,  99, 114, 111,  95, 111, 112, 101, 110,  10,  10, 115,
114,  99,  95, 114, 101, 116, 117, 114, 110,  17,  17, 115, 114,  99,  95, 111,
117, 116,  95, 116, 101, 120, 116,  95, 108, 105, 110, 101,  11,  11, 115, 114,
 99,  95, 111, 117, 116, 108, 105, 110, 101,  17,  17, 115, 114,  99,  95, 111,
117, 116, 101, 114, 114,  95,  98,  97, 110, 110, 101, 114,  40,  40,  32,  37,
 42,  43,  42,  43,  42,  32, 101, 114, 114, 111, 114,  40, 115,  41,  32, 119,
 97, 115,  32, 100, 101, 116, 101,  99, 116, 101, 100,  32,  97, 116,  32, 108,
105, 110, 101,  32,  35,  32,  16,  16,  32, 105, 110,  32, 116, 104, 101,  32,
102, 105, 108, 101,  32,  58,  32,  34,  13,  13, 115, 114,  99,  95, 111, 117,
116,  95, 101, 114, 114, 111, 114,  34,  34,  32,  60,  60,  60,  32,  42,  42,
 42,  32,  77,  97, 120, 105, 109, 117, 109,  32, 110, 117, 109,  98, 101, 114,
 32, 111, 102,  32, 101, 114, 114, 111, 114,  32,  40,  52,  52,  41,  32, 105,
115,  32, 114, 101,  97,  99, 104, 101, 100,  46,  32,  83,  82,  67,  95,  76,
105,  98, 114,  97, 114, 121,  32, 115, 116, 111, 112,  32, 111, 117, 114,  32,
 83, 111, 102, 116, 119,  97, 114, 101,  46,  32,  42,  42,  42,  32,  62,  62,
 62,  17,  17, 115, 114,  99,  95, 111, 117, 116,  95, 109,  97,  99,  95, 101,
114, 114, 111, 114,   9,   9, 115, 114,  99,  95, 101, 114, 114, 111, 114,  17,
 17, 115, 114,  99,  95, 103, 101, 116,  95, 105, 110, 112, 117, 116, 108, 105,
110, 101,  14,  14, 115, 114,  99,  95, 112, 117, 116,  95, 112, 114, 111, 109,
112, 116,  12,  12, 115, 114,  99,  95, 103, 101, 116,  95, 108, 105, 110, 101,
 15,  15, 115, 114,  99,  95, 101, 110, 100,  95, 111, 102,  95, 108, 105, 110,
101,   4,   4,  83,  95,  71,  76,  12,  12, 115, 114,  99,  95, 103, 101, 116,
 95,  99, 104,  97, 114,  12,  12, 115, 107, 105, 112,  95,  99, 111, 109, 109,
101, 110, 116,  10,  10, 115, 114,  99,  95, 105, 110,  99, 104,  97, 114,  13,
 13, 115, 114,  99,  95, 110, 101, 120, 116,  95,  99, 104,  97, 114,  15,  15,
115, 114,  99,  95, 115, 101,  97, 114,  99, 104,  95,  99, 104,  97, 114,  13,
 13, 115, 114,  99,  95, 115, 101, 116,  95, 102, 108,  97, 103, 115,   8,   8,
115, 114,  99,  95, 105, 110, 105, 116
};

/* Define the local static section. */
static Blk( Rs, 8 );

/* Declaration of external variables. */
extern V PAS__f_input;
extern SL PAS__iostatus;
extern UL V_lst_spc_mode;
extern V PAS__f_output;
extern V V_lst_current;
extern Blk(V_error_cnt, 24 );
extern UB V_error_result;

/* Declaration of global variables. */
V V_def_prompt = NULL;
SL V_src_maxerror;
SL V_src_lstinsnb;
V V_src_control;
V V_src_cont_base;
V V_src_hde;
V V_src_listing;

/* Function/procedure prototypes. */
void P_str_copy_lim(V *F_trg, V F_src, SL F_lim);
void P_lst_newline();
void P_lst_eoln();
void P_lst_put_string(V F_str);
void P_err_getmsg(V F_erren);
void P_err_display(V *F_f, SL F_ie, V F_erren);
void P_vsr_nextstring();


/* Procedure/Function : " src_r_init "  */
void BASIC_SRC_src_r_init(V F_p, UB F_macflg){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=121; /* line # 121 */
  if (F_p!=NULL) {
    Rv0=F_p;
    ((V *)Rv0)[0]=V_src_hde;
    Ra.sl[3]=126; /* line # 126 */
    ((V *)Rv0)[1]=NULL;
    ((SL *)Rv0)[2]=0;
    ((SL *)Rv0)[3]=0;
    ((SL *)Rv0)[4]=0;
    ((SL *)Rv0)[5]=0;
    Ra.sl[3]=131; /* line # 131 */
    ((SL *)Rv0)[6]=0;
    ((SL *)Rv0)[7]=0;
    ((SL *)Rv0)[8]=0;
    ((SL *)Rv0)[9]=1;
    ((SL *)Rv0)[10]=255;
    Ra.sl[3]=136; /* line # 136 */
    ((C *)Rv0)[44]=0;
    ((C *)Rv0)[45]=1;
    if (F_macflg) ((C *)Rv0)[46]=77;
    else((C *)Rv0)[46]=32;
    ((C *)Rv0)[47]=32;
    Ra.sl[3]=141; /* line # 141 */
    Rv1=1;
    for( Rf0=8;Rf0>0;Rf0-- ) {
      ((V *)Rv0)[Rv1*5+11]=NULL;
      Rv1++;
    }
    if (!F_macflg) {
      Ra.sl[3]=146; /* line # 146 */
      if (32768&((UL *)Rv0)[52]) {
        ((V *)Rv0)[54]=NULL;
        ((V *)Rv0)[55]=NULL;
        ((V *)Rv0)[56]=NULL;
        Ra.sl[3]=151; /* line # 151 */
        ((V *)Rv0)[57]=NULL;
      }
      ((UL *)Rv0)[52]=2120;
      ((UB *)Rv0)[212]=0;
      if (((V *)Rv0)[54]==NULL) {
        ((V *)Rv0)[54]=PAS__NEW(257);
        ((UB *)((V *)Rv0)[54])[0]=255;
      }
      Ra.sl[3]=156; /* line # 156 */
      ((UB *)((V *)Rv0)[54])[1]=0;
      if (((V *)Rv0)[55]!=NULL) {
        PAS__DISPOSE(((V *)Rv0)+55);
        ((V *)Rv0)[55]=NULL;
      }
    }
    else {
      Ra.sl[3]=162; /* line # 162 */
      if (!(32768&((UL *)Rv0)[52])) {
        if (((V *)Rv0)[54]!=NULL) PAS__DISPOSE(((V *)Rv0)+54);
        if (((V *)Rv0)[55]!=NULL) PAS__DISPOSE(((V *)Rv0)+55);
      }
      Ra.sl[3]=167; /* line # 167 */
      ((UL *)Rv0)[52]=34880;
      ((UB *)Rv0)[212]=4;
      ((V *)Rv0)[54]=NULL;
      ((V *)Rv0)[55]=NULL;
      ((V *)Rv0)[56]=NULL;
      Ra.sl[3]=172; /* line # 172 */
      ((V *)Rv0)[57]=NULL;
    }
  }
  V_src_hde=F_p;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_allocate "  */
V BASIC_SRC_src_allocate(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+77;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=187; /* line # 187 */
  Rv0=PAS__NEW(232);
  Rv1=Rv0;
  ((UL *)Rv1)[52]=32768;
  ((V *)Rv1)[54]=NULL;
  Ra.sl[3]=192; /* line # 192 */
  ((V *)Rv1)[55]=NULL;
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " src_free "  */
void P_src_free(V *F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+91;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=206; /* line # 206 */
  Rv0=NULL;
  if ((*F_p)!=NULL) {
    Rv1=V_src_hde;
    while (Rv1!=(*F_p)&&Rv1!=NULL){
      Ra.sl[3]=212; /* line # 212 */
      Rv0=Rv1;
      Rv1=((V *)Rv1)[0];
    }
  }
  else Rv1=NULL;
  if (Rv1!=NULL) {
    Ra.sl[3]=217; /* line # 217 */
    Rv2=(*F_p);
    if (!(32768&((UL *)Rv2)[52])) {
      if (((V *)Rv2)[54]!=NULL) PAS__DISPOSE(((V *)Rv2)+54);
      Ra.sl[3]=222; /* line # 222 */
      if (((V *)Rv2)[55]!=NULL) PAS__DISPOSE(((V *)Rv2)+55);
    }
    if (Rv0==NULL) V_src_hde=((V *)Rv2)[0];
    else((V *)Rv0)[0]=((V *)Rv2)[0];
    Ra.sl[3]=228; /* line # 228 */
    PAS__DISPOSE(F_p);
    (*F_p)=NULL;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_close "  */
void P_src_close(V *F_p, UB F_bfree){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  UL Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+101;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=242; /* line # 242 */
  if ((*F_p)!=NULL) {
    Rv0=(*F_p);
    if (16384&((UL *)Rv0)[52]) {
      Ra.sl[3]=248; /* line # 248 */
      if (32768&((UL *)Rv0)[52]) {
        ((V *)Rv0)[54]=NULL;
        ((V *)Rv0)[55]=NULL;
        ((V *)Rv0)[56]=NULL;
        Ra.sl[3]=253; /* line # 253 */
        ((V *)Rv0)[57]=NULL;
      }
      else {
        if (128&((UL *)Rv0)[52]) Rv1=2048;
        else {
          Ra.sl[3]=258; /* line # 258 */
          Rv1=0;
        }
        PAS__CLOSE(((V *)Rv0)+57,Rv1);
        if (8&((UL *)Rv0)[52]) PAS__CLOSE(((V *)Rv0)+56,0);
        if (((V *)Rv0)[55]!=NULL) {
          Ra.sl[3]=263; /* line # 263 */
          PAS__DISPOSE(((V *)Rv0)+55);
          ((V *)Rv0)[55]=NULL;
        }
      }
      if (((V *)Rv0)[1]!=NULL&&V_src_control==(*F_p)) {
        Ra.sl[3]=268; /* line # 268 */
        V_src_control=((V *)Rv0)[1];
      }
      ((UL *)Rv0)[52]=((UL *)Rv0)[52]&~16384;
    }
    Ra.sl[3]=273; /* line # 273 */
    if (F_bfree) P_src_free(F_p);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_open "  */
void P_src_open(V *F_p, V F_fspc, UB F_bdelete, SL *F_ierr){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+112;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=292; /* line # 292 */
  (*F_ierr)=0;
  if ((*F_p)==NULL) {
    Rv0=0;
    (*F_p)=BASIC_SRC_src_allocate();
  }
  else {
    Ra.sl[3]=300; /* line # 300 */
    Rv0=1;
    P_src_close(F_p,0);
  }
  BASIC_SRC_src_r_init((*F_p),0);
  Ra.sl[3]=305; /* line # 305 */
  Rv1=(*F_p);
  if (((UB *)F_fspc)[1]==0) {
    _FILE_DUPLICATE(((V *)Rv1)[57],PAS__f_input);
    Ra.sl[3]=310; /* line # 310 */
    ((UL *)Rv1)[52]=((UL *)Rv1)[52]|16;
    PAS__iostatus=0;
  }
  else PAS__OPEN(((V *)Rv1)+57,0, F_fspc,4097|V_lst_spc_mode,0,-1);
  Ra.sl[3]=315; /* line # 315 */
  if (PAS__iostatus==0) {
    ((UL *)Rv1)[52]=((UL *)Rv1)[52]&~8;
    if (PAS__TTY_FILE(((V *)Rv1)[57])) {
      Ra.sl[3]=321; /* line # 321 */
      if (((UB *)F_fspc)[1]==0) {
        _FILE_DUPLICATE(((V *)Rv1)[56],PAS__f_output);
        PAS__iostatus=0;
      }
      else {
        Ra.sl[3]=326; /* line # 326 */
        PAS__OPEN(((V *)Rv1)+56,0, F_fspc,4098,0,-1);
      }
      if (PAS__iostatus!=0) {
        (*F_ierr)=PAS__iostatus;
        PAS__CLOSE(((V *)Rv1)+57,0);
      }
      else {
        Ra.sl[3]=333; /* line # 333 */
        ((V *)Rv1)[55]=PAS__NEW(65);
        ((UB *)((V *)Rv1)[55])[0]=63;
        PAS__STR_TO_STR(((V *)Rv1)[55],V_def_prompt);
        ((UL *)Rv1)[52]=((UL *)Rv1)[52]|16392;
      }
    }
    else {
      Ra.sl[3]=340; /* line # 340 */
      if (F_bdelete) ((UL *)Rv1)[52]=((UL *)Rv1)[52]|128;
      ((UL *)Rv1)[52]=((UL *)Rv1)[52]|16384;
    }
  }
  else (*F_ierr)=PAS__iostatus;
  Ra.sl[3]=345; /* line # 345 */
  if ((*F_ierr)!=0) {
    if (Rv0) BASIC_SRC_src_r_init((*F_p),0);
    else P_src_free(F_p);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_active_source "  */
void P_src_active_source(V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+122;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=360; /* line # 360 */
  if (F_p!=NULL&&V_src_control!=NULL) {
    Rv0=V_src_control;
    Ra.sl[3]=367; /* line # 367 */
    ((UL *)Rv0)[52]=((UL *)Rv0)[52]|262144;
    Rv1=F_p;
    ((V *)Rv1)[1]=V_src_control;
    Ra.sl[3]=372; /* line # 372 */
    ((SL *)Rv1)[4]=((SL *)V_src_control)[4];
    ((SL *)Rv1)[5]=((SL *)V_src_control)[5];
    ((SL *)Rv1)[6]=((SL *)Rv1)[5];
    ((C *)Rv1)[44]=0;
    ((C *)Rv1)[45]=((C *)V_src_control)[44];
    Ra.sl[3]=377; /* line # 377 */
    ((UL *)Rv1)[52]=((UL *)Rv1)[52]|65536;
    V_src_control=F_p;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_macro_open "  */
void P_src_macro_open(V *F_p, V F_txt, V F_p0, V F_p1, V F_p2, UB F_fact){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+141;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=405; /* line # 405 */
  if ((*F_p)==NULL) {
    Rv0=0;
    (*F_p)=BASIC_SRC_src_allocate();
  }
  else {
    Ra.sl[3]=412; /* line # 412 */
    Rv0=1;
    P_src_close(F_p,0);
  }
  BASIC_SRC_src_r_init((*F_p),1);
  Rv1=(*F_p);
  Ra.sl[3]=418; /* line # 418 */
  if (F_txt!=NULL) {
    ((V *)Rv1)[54]=F_txt;
    ((SL *)Rv1)[10]=((UB *)F_txt)[1];
    if (((SL *)Rv1)[10]>0) {
      Ra.sl[3]=424; /* line # 424 */
      ((C *)Rv1)[45]=0;
      ((UL *)Rv1)[52]=((UL *)Rv1)[52]&~2048;
    }
  }
  ((V *)Rv1)[55]=F_p0;
  Ra.sl[3]=429; /* line # 429 */
  ((V *)Rv1)[56]=F_p1;
  ((V *)Rv1)[57]=F_p2;
  ((UL *)Rv1)[52]=((UL *)Rv1)[52]|16384;
  if (F_fact&&V_src_control!=NULL) P_src_active_source((*F_p));
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_return "  */
C P_src_return(UB F_bfree){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  register C Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+157;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=449; /* line # 449 */
  Rv0=V_src_control;
  if (Rv0!=NULL) Rv1=((V *)Rv0)[1];
  if (Rv0!=NULL&&Rv1!=NULL) {
    Ra.sl[3]=459; /* line # 459 */
    Rv2=Rv0;
    ((UL *)Rv2)[52]=((UL *)Rv2)[52]&~65536;
    Rv3=Rv1;
    ((C *)Rv3)[44]=((C *)Rv0)[44];
    Ra.sl[3]=464; /* line # 464 */
    V_src_control=Rv1;
    P_src_close(&Rv0, F_bfree);
    Ret=((C *)Rv3)[45];
  }
  else {
    Ra.sl[3]=469; /* line # 469 */
    Ret=0;
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " src_out_text_line "  */
void BASIC_SRC_src_out_text_line(V *F_f, V F_st, UB F_bterm){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  register V Rv1;
  SL Rv2;
  SL Rv3;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+169;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=481; /* line # 481 */
  PAS__SELECT_OUT((*F_f));
  PAS__WRITE_FCHAR(32,20,-1,1,32);
  Rv0=20;
  Rv1=V_lst_current;
  if (F_bterm) Rv2=80;
  else Rv2=((SL *)Rv1)[10];
  Ra.sl[3]=486; /* line # 486 */
  Rv3=1;
  for( Rf0=((UB *)F_st)[1];Rf0>0;Rf0-- ) {
    Rv0=Rv0+1;
    if (Rv0>Rv2) {
      Ra.sl[3]=491; /* line # 491 */
      PAS__SELECT_OUT((*F_f));
      PAS__WRITE_EOLN();
      if (!F_bterm) ((SL *)Rv1)[6]=((SL *)Rv1)[6]+1;
      Rv0=20;
      PAS__SELECT_OUT((*F_f));
      PAS__WRITE_FCHAR(32,20,-1,1,32);
    }
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_CHAR(((C *)F_st)[Rv3+1]);
    Rv3++;
  }
  Ra.sl[3]=497; /* line # 497 */
  PAS__SELECT_OUT((*F_f));
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_outline "  */
void BASIC_SRC_src_outline(V *F_f, UB F_bterm){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register V Rv2;
  SL Rv3;
  SL Rv4;
  SL Rv5;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+188;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=509; /* line # 509 */
  Rv0=V_src_control;
  if (V_src_lstinsnb!=((SL *)Rv0)[4]) {
    V_src_lstinsnb=((SL *)Rv0)[4];
    Ra.sl[3]=514; /* line # 514 */
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_CHAR(32);
    PAS__WRITE_INT(((SL *)Rv0)[4],5,0);
  }
  else {
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_FCHAR(32,6,-1,1,32);
  }
  PAS__SELECT_OUT((*F_f));
  PAS__WRITE_CHAR(32);
  PAS__WRITE_CHAR(((C *)Rv0)[46]);
  PAS__WRITE_CHAR(((C *)Rv0)[47]);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_INT(((SL *)Rv0)[5],3,0);
  PAS__WRITE_CHAR(32);
  Ra.sl[3]=519; /* line # 519 */
  Rv1=((V *)Rv0)[54];
  Rv2=V_lst_current;
  if (F_bterm) Rv3=80;
  else Rv3=((SL *)Rv2)[10];
  PAS__SELECT_OUT((*F_f));
  PAS__WRITE_INT(((SL *)Rv0)[8],4,0);
  PAS__WRITE_FCHAR(32,2,-1,1,32);
  Ra.sl[3]=524; /* line # 524 */
  if (((UB *)Rv1)[1]>Rv3-20) {
    Rv4=20;
    Rv5=1;
    for( Rf0=((UB *)Rv1)[1];Rf0>0;Rf0-- ) {
      Ra.sl[3]=529; /* line # 529 */
      Rv4=Rv4+1;
      if (Rv4>Rv3) {
        PAS__SELECT_OUT((*F_f));
        PAS__WRITE_EOLN();
        if (!F_bterm) ((SL *)Rv2)[6]=((SL *)Rv2)[6]+1;
        Ra.sl[3]=534; /* line # 534 */
        Rv4=20;
        PAS__SELECT_OUT((*F_f));
        PAS__WRITE_FCHAR(32,20,-1,1,32);
      }
      PAS__SELECT_OUT((*F_f));
      PAS__WRITE_CHAR(((C *)Rv1)[Rv5+1]);
      Rv5++;
    }
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_EOLN();
  }
  else {
    Ra.sl[3]=540; /* line # 540 */
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_STR(((V *)Rv0)[54],-1,-1,32);
    PAS__WRITE_EOLN();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_outerr_banner "  */
void BASIC_SRC_src_outerr_banner(V *F_f, UB F_bterm){
  /* Define the automatic variable space. */
  Blk( Ra, 536 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;
  register V Rv5;
  SL Rv6;
  register int Rf0;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[65]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+260;
  Ra.v[66]=Rd.s+201;
  Ra.v[67]=Rd.s+12;
  Ra.sl[68]=559; /* line # 559 */
  Rv0=V_src_control;
  Rv1=V_lst_current;
  Ra.ub[1]=Ra.ub[0];
  Rv2=1;
  for( Rf0=Ra.ub[1];Rf0>0;Rf0-- ) {
    Ra.c[Rv2+1]=95;
    Rv2++;
  }
  Ra.sl[68]=565; /* line # 565 */
  Rv3=1;
  for( Rf0=((SL *)Rv0)[9]-1;Rf0>0;Rf0-- ) {
    Ra.c[Rv3+1]=92;
    Rv3++;
  }
  Rv4=1;
  for( Rf0=((SL *)Rv0)[7];Rf0>0;Rf0-- ) {
    Rv5=(((S *)Rv0)+Rv4*20+28);
    Ra.c[((SL *)Rv5)[0]+1]=(C)(48+Rv4);
    Rv4++;
  }
  if (((UB *)((V *)Rv0)[54])[1]>((SL *)Rv0)[10]) {
    Ra.sl[68]=572; /* line # 572 */
    Rv6=((SL *)Rv0)[10]+1;
    for( Rf0=(((UB *)((V *)Rv0)[54])[1]+1)-(((SL *)Rv0)[10]+1);Rf0>0;Rf0-- ) {
      Ra.c[Rv6+1]=92;
      Rv6++;
    }
    Ra.ub[1]=((UB *)((V *)Rv0)[54])[1];
  }
  else Ra.ub[1]=((SL *)Rv0)[((SL *)Rv0)[7]*5+7];
  Ra.sl[68]=577; /* line # 577 */
  BASIC_SRC_src_out_text_line(F_f,Ra.s,F_bterm);
  if (F_bterm) {
    P_lst_newline();
    ((SL *)Rv1)[6]=((SL *)Rv1)[6]+1;
  }
  Ra.sl[68]=583; /* line # 583 */
  PAS__SELECT_OUT((*F_f));
  PAS__WRITE_STR(Rd.s+220,-1,-1,32);
  PAS__WRITE_INT(((SL *)Rv0)[8],5,0);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT((*F_f));
  PAS__WRITE_STR(Rd.s+262,-1,-1,32);
  PAS__WRITE_STR(PAS__FILE_SPC(Ra.s+276,((V *)Rv0)[57]),-1,-1,32);
  PAS__WRITE_CHAR(34);
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Ra.v[65];
}


/* Procedure/Function : " src_out_error "  */
void BASIC_SRC_src_out_error(UB F_bmac){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+280;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=592; /* line # 592 */
  Rv0=V_src_control;
  Rv1=V_lst_current;
  if ((1&((UL *)Rv0)[52]&&((SL *)Rv0)[6]>=((SL *)Rv0)[5])&&!(64&((UB *)Rv1)[48])
  ) {
    Ra.sl[3]=597; /* line # 597 */
    ((SL *)Rv1)[6]=((SL *)Rv1)[6]+1;
    BASIC_SRC_src_outerr_banner(((V *)Rv1)+13,0);
    Rv2=1;
    for( Rf0=((SL *)Rv0)[7];Rf0>0;Rf0-- ) {
      Ra.sl[3]=602; /* line # 602 */
      P_lst_newline();
      ((SL *)Rv1)[6]=((SL *)Rv1)[6]+1;
      P_err_display(((V *)Rv1)+13,Rv2,(((S *)Rv0)+Rv2*20+28));
      Rv2++;
    }
    P_lst_newline();
    PAS__SELECT_OUT(((V *)Rv1)[13]);
    PAS__WRITE_EOLN();
  }
  Ra.sl[3]=608; /* line # 608 */
  if (64&((UL *)Rv0)[52]||64&((UB *)Rv1)[48]) {
    if (!F_bmac) BASIC_SRC_src_outline(&PAS__f_output,1);
    BASIC_SRC_src_outerr_banner(&PAS__f_output,1);
    Rv3=1;
    for( Rf0=((SL *)Rv0)[7];Rf0>0;Rf0-- ) {
      Ra.sl[3]=613; /* line # 613 */
      P_err_display(&PAS__f_output, Rv3,(((S *)Rv0)+Rv3*20+28));
      Rv3++;
    }
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_EOLN();
  }
  Rv4=1;
  for( Rf0=((SL *)Rv0)[7];Rf0>0;Rf0-- ) {
    Ra.sl[3]=618; /* line # 618 */
    PAS__DISPOSE((((V *)Rv0)+Rv4*5+11));
    Rv4++;
  }
  if (Rs.sl[0]>V_src_maxerror) {
    Ra.sl[3]=623; /* line # 623 */
    P_lst_newline();
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+295,-1,-1,32);
    PAS__WRITE_INT(V_src_maxerror,0,0);
    PAS__WRITE_STR(Rd.s+331,-1,-1,32);
    PAS__WRITE_EOLN();
    PAS__EXIT(4);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_out_mac_error "  */
void P_src_out_mac_error(void F_out_mac_line(V *F_f, UB F_btt)){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+385;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=634; /* line # 634 */
  Rv0=V_src_control;
  Rv1=V_lst_current;
  if (((SL *)Rv0)[7]>0) {
    if (64&((UL *)Rv0)[52]||64&((UB *)Rv1)[48]) (*F_out_mac_line)(&PAS__f_output,1);
    BASIC_SRC_src_out_error(1);
    Ra.sl[3]=639; /* line # 639 */
    ((SL *)Rv0)[7]=0;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_error "  */
void P_src_error(V F_modulesy, SL F_number, UB F_severity){
  /* Define the automatic variable space. */
  Blk( Ra, 24 );

  /* Local variable stored in C variable */
  register V Rv0;
  UB Rv1;
  SL Rv2;
  register V Rv3;
  register int Rf0;

  /* Code of procedure/function */
  memcpy( Ra.s+16,F_modulesy,4);
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+404;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=655; /* line # 655 */
  Rv0=V_src_control;
  if (((SL *)Rv0)[2]<((SL *)Rv0)[9]) ((SL *)Rv0)[2]=((SL *)Rv0)[9];
  else {
    if (((SL *)Rv0)[2]>((SL *)Rv0)[10]) ((SL *)Rv0)[2]=((SL *)Rv0)[10];
  }
  Ra.sl[3]=661; /* line # 661 */
  if (((SL *)Rv0)[7]>=8) {
    ((SL *)Rv0)[7]=8;
    Rv1=0;
  }
  else {
    Ra.sl[3]=667; /* line # 667 */
    Rv1=1;
    Rv2=1;
    for( Rf0=((SL *)Rv0)[7];Rf0>0;Rf0-- ) {
      if (((SL *)Rv0)[2]==((SL *)Rv0)[Rv2*5+7]) Rv1=0;
      Rv2++;
    }
    if (Rv1) ((SL *)Rv0)[7]=((SL *)Rv0)[7]+1;
  }
  Ra.sl[3]=673; /* line # 673 */
  if (Rv1) {
    Rv3=(((S *)Rv0)+((SL *)Rv0)[7]*20+28);
    ((SL *)Rv3)[0]=((SL *)Rv0)[2];
    if (((SL *)Rv3)[0]<1) ((SL *)Rv3)[0]=1;
    Ra.sl[3]=678; /* line # 678 */
    ((SL *)Rv3)[1]=F_number;
    ((UB *)Rv3)[8]=F_severity;
    memcpy(Rv3+9,Ra.s+16,4);
    P_err_getmsg((((S *)Rv0)+((SL *)Rv0)[7]*20+28));
  }
  else {
    Ra.sl[3]=685; /* line # 685 */
    if (((UB *)Rv0)[((SL *)Rv0)[7]*20+36]<F_severity) ((UB *)Rv0)[((SL *)Rv0)[7]
    *20+36]=F_severity;
  }
  if (!(32768&((UL *)Rv0)[52]||PAS__TTY_FILE(((V *)Rv0)[57]))) {
    if (PAS__EOF(((V *)Rv0)[57])) BASIC_SRC_src_out_error(0);
  }
  Ra.sl[3]=690; /* line # 690 */
  V_error_cnt.sl[F_severity]=V_error_cnt.sl[F_severity]+1;
  if (F_severity>1) Rs.sl[0]=Rs.sl[0]+1;
  if (V_error_result<F_severity) V_error_result=F_severity;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_get_inputline "  */
void P_src_get_inputline(V *F_f, V *F_pstr){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  C Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+415;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=714; /* line # 714 */
  if (((UB *)((V *)V_lst_current)[1])[1]>0) P_lst_eoln();
  if ((*F_pstr)==NULL) {
    (*F_pstr)=PAS__NEW(257);
    ((UB *)(*F_pstr))[0]=255;
  }
  Rv0=(*F_pstr);
  Rv1=V_src_control;
  Ra.sl[3]=719; /* line # 719 */
  ((UB *)Rv0)[1]=0;
  while (!PAS__EOLN((*F_f))&&!PAS__EOF((*F_f))){
    PAS__SELECT_INP((*F_f));
    PAS__READ_CHAR(&Rv2);
    if (Rv2==9) while (1){
      Ra.sl[3]=725; /* line # 725 */
      if (((UB *)Rv0)[1]<255) ((UB *)Rv0)[1]=((UB *)Rv0)[1]+1;
      ((C *)Rv0)[((UB *)Rv0)[1]+1]=32;
      if (((UB *)Rv0)[1]>=255||(((UB *)Rv0)[1]&7)==0)  break;
    }
    else {
      if (Rv2>=32) {
        Ra.sl[3]=730; /* line # 730 */
        if (((UB *)Rv0)[1]<255) {
          ((UB *)Rv0)[1]=((UB *)Rv0)[1]+1;
          ((C *)Rv0)[((UB *)Rv0)[1]+1]=Rv2;
        }
        else {
          Ra.sl[3]=735; /* line # 735 */
          ((UL *)Rv1)[52]=((UL *)Rv1)[52]|256;
        }
      }
    }
  }
  if (PAS__EOF((*F_f))) ((UL *)Rv1)[52]=((UL *)Rv1)[52]|8192;
  else {
    PAS__SELECT_INP((*F_f));
    PAS__READ_EOLN();
  }
  ((SL *)Rv1)[8]=((SL *)Rv1)[8]+1;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_put_prompt "  */
void P_src_put_prompt(V F_pstr){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+434;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=749; /* line # 749 */
  if (F_pstr!=NULL) {
    Rv0=V_src_control;
    if (8&((UL *)Rv0)[52]) {
      Ra.sl[3]=754; /* line # 754 */
      PAS__SELECT_OUT(((V *)Rv0)[56]);
      PAS__WRITE_STR(F_pstr,-1,-1,32);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_get_line "  */
void BASIC_SRC_src_get_line(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+450;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=765; /* line # 765 */
  Rv0=V_src_control;
  ((SL *)Rv0)[3]=((SL *)Rv0)[9]-1;
  ((SL *)Rv0)[7]=0;
  Ra.sl[3]=770; /* line # 770 */
  if (32768&((UL *)Rv0)[52]) {
    P_vsr_nextstring();
    ((SL *)Rv0)[8]=((SL *)Rv0)[8]+1;
  }
  else {
    Ra.sl[3]=778; /* line # 778 */
    if (8&((UL *)Rv0)[52]) P_src_put_prompt(((V *)Rv0)[55]);
    P_src_get_inputline(((V *)Rv0)+57,((V *)Rv0)+54);
    if (32&((UL *)Rv0)[52]) {
      Ra.sl[3]=783; /* line # 783 */
      if (8&((UL *)Rv0)[52]) P_lst_put_string(((V *)Rv0)[55]);
      P_lst_put_string(((V *)Rv0)[54]);
      P_lst_eoln();
    }
  }
  Ra.sl[3]=788; /* line # 788 */
  ((SL *)Rv0)[2]=((SL *)Rv0)[9];
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_end_of_line "  */
void P_src_end_of_line(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+464;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=799; /* line # 799 */
  Rv0=V_src_control;
  Rv1=V_lst_current;
  if (256&((UL *)Rv0)[52]) {
    Ra.sl[3]=804; /* line # 804 */
    ((SL *)Rv0)[2]=((SL *)Rv0)[10]-1;
    P_src_error(Rd.s+483,1,2);
    ((UL *)Rv0)[52]=((UL *)Rv0)[52]&~256;
  }
  if (1&((UL *)Rv0)[52]&&((SL *)Rv0)[6]>=((SL *)Rv0)[5]) {
    if (!(64&((UB *)Rv1)[48])) {
      Ra.sl[3]=811; /* line # 811 */
      P_lst_newline();
      BASIC_SRC_src_outline(((V *)Rv1)+13,0);
    }
  }
  if (((SL *)Rv0)[7]>0) BASIC_SRC_src_out_error(0);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_get_char "  */
C BASIC_SRC_src_get_char(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  C Rv2;
  register C Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+487;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=825; /* line # 825 */
  Rv0=V_src_control;
  Rv1=((V *)Rv0)[54];
  while (!(8192&((UL *)Rv0)[52])&&2048&((UL *)Rv0)[52]){
    Ra.sl[3]=832; /* line # 832 */
    if (((SL *)Rv0)[8]>0&&!(1048576&((UL *)Rv0)[52])) P_src_end_of_line();
    ((UL *)Rv0)[52]=((UL *)Rv0)[52]&~1050624;
    BASIC_SRC_src_get_line();
    Ra.sl[3]=838; /* line # 838 */
    ((UL *)Rv0)[52]=((UL *)Rv0)[52]|512;
    if (((C *)Rv0)[46]!=67) {
      Rs.c[4]=((C *)Rv0)[46];
      ((C *)Rv0)[46]=67;
    }
  }
  if (!(8192&((UL *)Rv0)[52])) {
    Ra.sl[3]=843; /* line # 843 */
    if (((SL *)Rv0)[3]>=((SL *)Rv0)[10]||((SL *)Rv0)[3]>=((UB *)Rv1)[1]) {
      if (1048576&((UL *)Rv0)[52]&&((SL *)Rv0)[8]>0) P_src_end_of_line();
      if ((525312&((UL *)Rv0)[52])!=0) {
        Ra.sl[3]=848; /* line # 848 */
        Rv2=1;
      }
      else Rv2=32;
      ((UL *)Rv0)[52]=((UL *)Rv0)[52]|2048;
    }
    else {
      Ra.sl[3]=853; /* line # 853 */
      ((SL *)Rv0)[3]=((SL *)Rv0)[3]+1;
      Rv2=((C *)Rv1)[((SL *)Rv0)[3]+1];
    }
  }
  else {
    Ra.sl[3]=861; /* line # 861 */
    if (65536&((UL *)Rv0)[52]&&((V *)Rv0)[1]!=NULL) Rv2=P_src_return(!(131072&((
    UL *)Rv0)[52]));
    else {
      Ra.sl[3]=873; /* line # 873 */
      Rv2=4;
      ((UL *)Rv0)[52]=((UL *)Rv0)[52]|4096;
    }
  }
  Ra.sl[3]=878; /* line # 878 */
  Ret=Rv2;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " skip_comment "  */
C BASIC_SRC_skip_comment(C F_stp, UB F_nlmd){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  UB Rv2;
  C Rv3;
  register C Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+501;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=890; /* line # 890 */
  Rv0=0;
  Rv1=V_src_control;
  if (F_nlmd) ((UL *)Rv1)[52]=((UL *)Rv1)[52]|1024;
  Ra.sl[3]=895; /* line # 895 */
  Rv2=((UB *)Rv1)[212];
  ((UB *)Rv1)[212]=4;
  while (1){
    while (1){
      Rv3=BASIC_SRC_src_get_char();
      if ((Rv3==4||Rv3==F_stp)||F_nlmd&&Rv3==1)  break;
    }
    Ra.sl[3]=901; /* line # 901 */
    switch (Rv2) {
      case 0:Rv0=F_stp==125&&Rv3==F_stp||Rv3==4;
      if (F_stp==42&&Rv3!=4) {
        Ra.sl[3]=907; /* line # 907 */
        if (((SL *)Rv1)[3]<((UB *)((V *)Rv1)[54])[1]) {
          Rv0=((C *)((V *)Rv1)[54])[(((SL *)Rv1)[3]+1)+1]==41;
          if (Rv0) Rv3=BASIC_SRC_src_get_char();
        }
      }
      break;
      case 1:Ra.sl[3]=916; /* line # 916 */
      if (Rv3!=4) {
        if (((SL *)Rv1)[3]<((UB *)((V *)Rv1)[54])[1]) Rv3=BASIC_SRC_src_get_char();
        Rv0=Rv3==47;
      }
      else Rv0=1;
      break;
      case 2:
      case 3:
      case 4:Ra.sl[3]=925; /* line # 925 */
      Rv0=1;
      break;
    }
    if (Rv0)  break;
  }
  Ra.sl[3]=930; /* line # 930 */
  if (F_nlmd) ((UL *)Rv1)[52]=((UL *)Rv1)[52]&~1024;
  ((UB *)Rv1)[212]=Rv2;
  if (Rv3!=4) {
    if (Rv3==1&&!(524288&((UL *)Rv1)[52])||Rv3>1) {
      Ra.sl[3]=935; /* line # 935 */
      Rv3=32;
    }
  }
  Ret=Rv3;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " src_inchar "  */
C P_src_inchar(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  C Rv2;
  register C Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+515;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=951; /* line # 951 */
  Rv0=V_src_control;
  Rv1=((V *)Rv0)[54];
  Rv2=BASIC_SRC_src_get_char();
  switch (((UB *)Rv0)[212]) {
    case 0:Ra.sl[3]=957; /* line # 957 */
    if (Rv2==123) Rv2=BASIC_SRC_skip_comment(125,0);
    else {
      if (((SL *)Rv0)[3]<((UB *)Rv1)[1]) {
        if (Rv2==40&&((C *)Rv1)[(((SL *)Rv0)[3]+1)+1]==42) {
          Rv2=BASIC_SRC_src_get_char();
          Ra.sl[3]=962; /* line # 962 */
          Rv2=BASIC_SRC_skip_comment(42,0);
        }
      }
    }
    break;
    case 1:if (((SL *)Rv0)[3]<((UB *)Rv1)[1]) {
      Ra.sl[3]=967; /* line # 967 */
      if (Rv2==47&&((C *)Rv1)[(((SL *)Rv0)[3]+1)+1]==42) {
        Rv2=BASIC_SRC_src_get_char();
        Rv2=BASIC_SRC_skip_comment(42,0);
      }
    }
    break;
    case 3:Ra.sl[3]=974; /* line # 974 */
    if (Rv2==59) Rv2=BASIC_SRC_skip_comment(59,1);
    break;
    case 2:if (((SL *)Rv0)[3]<((UB *)Rv1)[1]) {
      if (Rv2==45&&((C *)Rv1)[(((SL *)Rv0)[3]+1)+1]==45) {
        Ra.sl[3]=979; /* line # 979 */
        Rv2=BASIC_SRC_skip_comment(1,1);
      }
    }
    break;
    case 4:Ra.sl[3]=984; /* line # 984 */
    break;
  }
  if (512&((UL *)Rv0)[52]) {
    if (Rv2!=32&&Rv2>1) {
      Ra.sl[3]=989; /* line # 989 */
      ((UL *)Rv0)[52]=((UL *)Rv0)[52]&~512;
      if (((C *)Rv0)[46]==67) ((C *)Rv0)[46]=Rs.c[4];
    }
  }
  ((C *)Rv0)[44]=((C *)Rv0)[45];
  Ra.sl[3]=994; /* line # 994 */
  ((C *)Rv0)[45]=Rv2;
  Ret=Rv2;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " src_next_char "  */
C P_src_next_char(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register C Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+527;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=1009; /* line # 1009 */
  Rv0=V_src_control;
  Rv1=((V *)Rv0)[54];
  if (((SL *)Rv0)[3]>=((UB *)Rv1)[1]||((SL *)Rv0)[3]>=((SL *)Rv0)[10]) Ret=32;
  else Ret=((C *)Rv1)[(((SL *)Rv0)[3]+1)+1];
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " src_search_char "  */
C P_src_search_char(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  SL Rv2;
  UB Rv3;
  C Rv4;
  register C Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+542;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=1028; /* line # 1028 */
  Rv0=V_src_control;
  Rv1=((V *)Rv0)[54];
  Rv2=((SL *)Rv0)[3];
  Rv3=1;
  while (Rv3){
    Ra.sl[3]=1033; /* line # 1033 */
    if (Rv2<=((UB *)Rv1)[1]&&Rv2<=((SL *)Rv0)[10]) {
      Rv4=((C *)Rv1)[Rv2+1];
      if (Rv4==32) Rv2=Rv2+1;
      else Rv3=0;
    }
    else {
      Ra.sl[3]=1041; /* line # 1041 */
      Rv3=0;
      Rv4=32;
    }
  }
  Ret=Rv4;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " src_set_flags "  */
void P_src_set_flags(UL F_flg, UB F_fclr){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+559;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=1058; /* line # 1058 */
  Rv0=V_src_control;
  if (F_fclr) ((UL *)Rv0)[52]=((UL *)Rv0)[52]&~F_flg;
  else((UL *)Rv0)[52]=((UL *)Rv0)[52]|F_flg;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_init "  */
void P_src_init(V F_def_prt, V F_def_src){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  UB Rv1;
  register V Rv2;
  register int Rf0;

  /* Code of procedure/function */
  Rv0=-1;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+574;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=1079; /* line # 1079 */
  P_str_copy_lim(&V_def_prompt, F_def_prt,64);
  Rv1=0;
  for( Rf0=5;Rf0>0;Rf0-- ) {
    V_error_cnt.sl[Rv1]=0;
    Rv1++;
  }
  V_error_result=0;
  Ra.sl[3]=1084; /* line # 1084 */
  V_src_control=NULL;
  if (((UB *)F_def_src)[1]>0) P_src_open(&V_src_control, F_def_src,0, &Rv0);
  if (Rv0==0) {
    Rv2=V_src_control;
    Ra.sl[3]=1090; /* line # 1090 */
    ((SL *)Rv2)[5]=1;
    ((SL *)Rv2)[6]=1;
  }
  else V_src_control=NULL;
  V_src_hde=V_src_control;
  Ra.sl[3]=1095; /* line # 1095 */
  V_src_cont_base=V_src_control;
  V_src_maxerror=31;
  PAS__curr_cntx=Ra.v[0];
}
