program test_fpu_error;

var
  a, b, c:        real;
  i, j, k:     integer;
  op:           string;

label ET_ERR;

function FPU_Handler( ierr: cc__int): cc__int;
var
  msg: string;

begin
  msg.length := 0;
  GET_RTL_MESSAGE( ierr, msg );
  WRITELN( ' Error # ', ierr:0, ' detected !' );
  WRITELN( ' Run Time Library message is : <', msg, '>' );
  goto ET_ERR;
  FPU_Handler := 0
end FPU_Handler;


begin
  ESTABLISH( FPU_Handler );

RECOM:
  repeat
    WRITE( ' ope, a, b = ' ); READLN( op::true, a, b );
  until op.length > 0;

  WRITELN( ' Perform the operation ', a, ' ', op, ' ', b );
  case op[1] of
    '+': begin  c := a + b; WRITELN( a, ' ', op, ' ', b, ' = ', c )  end;
    '-': begin  c := a - b; WRITELN( a, ' ', op, ' ', b, ' = ', c )  end;
    '*': begin  c := a * b; WRITELN( a, ' ', op, ' ', b, ' = ', c )  end;
    '/': begin  c := a / b; WRITELN( a, ' ', op, ' ', b, ' = ', c )  end;
    'S',
    's': begin  c := SQRT( a )*b; WRITELN( ' SQRT( ', a, ' )*', b, ' = ', c )  end;
    'L',
    'l': begin  c := LN( a )*b; WRITELN( ' LN( ', a, ' )*', b, ' = ', c )  end;
    'D',
    'd': begin
           i := ROUND( a ); j := ROUND( b ); k := i div j;
           WRITELN( ' ',  i:0, ' div ', j:0, ' = ', k:0 )
         end;
    'M',
    'm': begin
           i := ROUND( a ); j := ROUND( b ); k := i * j;
           WRITELN( ' ',  i:0, ' * ', j:0, ' = ', k:0 )
         end;
  otherwise
    WRITELN( ' Unknown operation !!!' )
  end;
  goto ET_CONT;
ET_ERR:
  WRITELN( ' Handler as detected an Error !' );

ET_CONT:
  if a <> -1.0 then goto RECOM
end test_fpu_error.
