#
#       Makefile for CPascal_library and basic CPascal Utilities
#       from the pcmp C resulting files (do not use specific CPascal environment files).
#
BIN_DIR =       .
LIB_DIR =       .
INC_DIR	=	.
PAS_INC =       .
PAS_DIR =       .
PAS_LIB	=	.
#
include $(PAS_DIR)/system.make
#
OBJS =	cpas__crtl.o \
	cpas__signal.o \
	cpas__std.o \
	cpas__dir.o \
	cpas__error.o \
	cpas__rtl_msg.o \
	cpas__string.o \
	cpas__physic.o \
	cpas__iipow.o \
	cpas__lipow.o \
	cpas__ifpow.o \
	cpas__igpow.o \
	cpas__iostr.o \
	cpas__ionum.o \
	cpas__iolgnum.o \
	cpas__ioenm.o \
	cpas__timstr.o \
	cpas__timcht.o \
	cpas__setope.o \
	cpas__random.o \
	cpas__hyp_f.o \
	cpas__hyp_g.o \
	cpas_b__lst.o \
	cpas_b__err.o \
	cpas_b__src.o \
	cpas_b__vls.o \
	cpas_b__vsr.o \
	cpas_d__sdir1.o\
	cpas_d__sdir2.o
#
all:	$(LIB_DIR)/libcpas.a \
	$(PAS_DIR)/test_check_env \
	$(PAS_DIR)/test_cp2b \
	$(PAS_DIR)/test_es_arg \
	$(PAS_DIR)/test_es_run \
	$(PAS_DIR)/test_fpe\
	$(PAS_DIR)/test_exa_msg \
	$(PAS_DIR)/test_incl_msg \
	$(PAS_DIR)/test_std_files \
	$(PAS_DIR)/gen_msgfile \
	$(BIN_DIR)/cpsh
#
$(LIB_DIR)/libcpas.a:$(OBJS)
	ar -r $@ $(OBJS)
#
%.o:	%.c
	$(CC) $(CFLAGS) $(INC) -c $<
#
#	Small test programs
#
$(PAS_DIR)/test_check_env: test_check_env.c
	$(CC) $(CFLAGS) $(INC) $< $(LIB) -o $@
#
$(PAS_DIR)/test_cp2b: test_cp2b.c
	$(CC) $(CFLAGS) $(INC) $< $(LIB) -o $@
#
$(PAS_DIR)/test_es_arg: test_es_arg.c
	$(CC) $(CFLAGS) $(INC) $< $(LIB) -o $@
#
$(PAS_DIR)/test_es_run: test_es_run.c
	$(CC) $(CFLAGS) $(INC) $< $(LIB) -o $@
#
$(PAS_DIR)/test_exa_msg: test_exa_msg.c
	$(CC) $(CFLAGS) $(INC) $< $(LIB) -o $@
#
$(PAS_DIR)/test_fpe: test_fpe.c
	$(CC) $(CFLAGS) $(INC) $< $(LIB) -o $@
#
$(PAS_DIR)/test_incl_msg: test_incl_msg.c
	$(CC) $(CFLAGS) $(INC) $< $(LIB) -o $@
#
$(PAS_DIR)/test_std_files: test_std_files.c
	$(CC) $(CFLAGS) $(INC) $< $(LIB) -o $@
#
#	Utilities program (Specialy cpsh the CPAS SHELL)
#
$(PAS_DIR)/gen_msgfile: gen_msgfile.c
	$(CC) $(CFLAGS) $(INC) $< $(LIB) -o $@
#
$(BIN_DIR)/cpsh: cpsh_shell.c
	$(CC) $(CFLAGS) $(INC) $< $(LIB) -o $@
#
clean:
	rm *.o $(LIB_DIR)/libcpas.a
#
end:
