/*  P A S - P. WOLFERS SOFTWARE: V3.1-A1 OF 30-NOV-2014 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long long int

/* Include the PAS environment file. */
#include "cpas_defs.h"

/* Define the local static Initialized section. */
static Blk( Ri, 8 ) = {
  1,   3,   7,  15,  31,  63, 127,   0
};

/* Define the local static section. */
static Blk( Rs, 8 );


/* Function/procedure prototypes. */
void PAS__ERROR(SL F_nerr);


/* Procedure/Function : " lset_assign "  */
void PAS__ASSIGN_LSET(V F_dst, SL F_cad, V F_src, SL F_szs){
  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  register int Rf0;

  /* Code of procedure/function */
  Rv0=(F_cad+7)/8;
  if (F_szs!=Rv0) {
    if (F_szs>Rv0) {
      Rv1=Rv0+1;
      for( Rf0=(F_szs+1)-(Rv0+1);Rf0>0;Rf0-- ) {
        if (((UB *)F_src)[Rv1-1]!=0) PAS__ERROR(72);
        Rv1++;
      }
      F_szs=Rv0;
    }
    else {
      Rv2=F_szs+1;
      for( Rf0=(Rv0+1)-(F_szs+1);Rf0>0;Rf0-- ) {
        ((UB *)F_dst)[Rv2-1]=0;
        Rv2++;
      }
    }
  }
  Rv3=1;
  for( Rf0=F_szs;Rf0>0;Rf0-- ) {
    ((UB *)F_dst)[Rv3-1]=((UB *)F_src)[Rv3-1];
    Rv3++;
  }
  F_cad=F_cad%8;
  if (F_cad!=0) {
    if (((UB *)F_dst)[F_szs-1]>Ri.ub[F_cad-1]) PAS__ERROR(72);
  }
}


/* Procedure/Function : " lset_gen "  */
V PAS__SET_GENERATOR(V F_lsetp, SL F_card, SL F_lval){
  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  UL Rv2;
  SL Rv3;
  register V Rv4;
  register int Rf0;
  register V Ret;

  /* Code of procedure/function */
  if (F_lval>=0&&F_lval<=F_card-1) {
    Rv0=(F_card+31)/32;
    Rv1=F_lval/32;
    Rv2=F_lval%32;
    Rv3=1;
    for( Rf0=Rv0;Rf0>0;Rf0-- ) {
      Rv4=(((S *)F_lsetp)+Rv3*4-4);
      if (Rv3==Rv1) ((UL *)Rv4)[0]=1<<Rv2;
      else((SL *)Rv4)[0]=0;
      Rv3++;
    }
  }
  else PAS__ERROR(71);
  Ret=F_lsetp;
  return(Ret);
}


/* Procedure/Function : " enlarge_sset "  */
void CPAS__LTOPE_enlarge_sset(V F_sd1, V *F_src, SL *F_sz){
  /* Local variable stored in C variable */
  SL Rv0;
  register int Rf0;

  /* Code of procedure/function */
  Rv0=1;
  for( Rf0=4;Rf0>0;Rf0-- ) {
    if (Rv0<=(*F_sz)) ((UB *)F_sd1)[Rv0-1]=((UB *)(*F_src))[Rv0-1];
    else((UB *)F_sd1)[Rv0-1]=0;
    Rv0++;
  }
  (*F_sz)=4;
  (*F_src)=F_sd1;
}


/* Procedure/Function : " lset_union "  */
V PAS__BIS_LSET(V F_dst, V F_s1, SL F_s1_sz, V F_s2, SL F_s2_sz){
  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;
  SL Rv5;
  register int Rf0;
  register V Ret;

  /* Code of procedure/function */
  if (F_s1_sz<4) CPAS__LTOPE_enlarge_sset(Rs.s,&F_s1, &F_s1_sz);
  if (F_s2_sz<4) CPAS__LTOPE_enlarge_sset(Rs.s+4,&F_s2, &F_s2_sz);
  Rv0=F_s1_sz/4;
  Rv1=F_s2_sz/4;
  if (Rv0>Rv1) Rv2=Rv1;
  else Rv2=Rv0;
  Rv3=1;
  for( Rf0=Rv2;Rf0>0;Rf0-- ) {
    ((UL *)F_dst)[Rv3-1]=((UL *)F_s1)[Rv3-1]|((UL *)F_s2)[Rv3-1];
    Rv3++;
  }
  if (Rv0>Rv2) {
    Rv4=Rv2+1;
    for( Rf0=(Rv0+1)-(Rv2+1);Rf0>0;Rf0-- ) {
      ((SL *)F_dst)[Rv4-1]=((SL *)F_s1)[Rv4-1];
      Rv4++;
    }
  }
  else {
    Rv5=Rv2+1;
    for( Rf0=(Rv1+1)-(Rv2+1);Rf0>0;Rf0-- ) {
      ((SL *)F_dst)[Rv5-1]=((SL *)F_s2)[Rv5-1];
      Rv5++;
    }
  }
  Ret=F_dst;
  return(Ret);
}


/* Procedure/Function : " lset_inter "  */
V PAS__BAND_LSET(V F_dst, V F_s1, SL F_s1_sz, V F_s2, SL F_s2_sz){
  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;
  SL Rv5;
  register int Rf0;
  register V Ret;

  /* Code of procedure/function */
  if (F_s1_sz<4) CPAS__LTOPE_enlarge_sset(Rs.s,&F_s1, &F_s1_sz);
  if (F_s2_sz<4) CPAS__LTOPE_enlarge_sset(Rs.s+4,&F_s2, &F_s2_sz);
  Rv0=F_s1_sz/4;
  Rv1=F_s2_sz/4;
  if (Rv0>Rv1) {
    Rv2=Rv1;
    Rv3=Rv0;
  }
  else {
    Rv2=Rv0;
    Rv3=Rv1;
  }
  Rv4=1;
  for( Rf0=Rv2;Rf0>0;Rf0-- ) {
    ((UL *)F_dst)[Rv4-1]=((UL *)F_s1)[Rv4-1]&((UL *)F_s2)[Rv4-1];
    Rv4++;
  }
  Rv5=Rv2+1;
  for( Rf0=(Rv3+1)-(Rv2+1);Rf0>0;Rf0-- ) {
    ((SL *)F_dst)[Rv5-1]=0;
    Rv5++;
  }
  Ret=F_dst;
  return(Ret);
}


/* Procedure/Function : " lset_diff "  */
V PAS__BIC_LSET(V F_dst, V F_s1, SL F_s1_sz, V F_s2, SL F_s2_sz){
  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;
  SL Rv5;
  register int Rf0;
  register V Ret;

  /* Code of procedure/function */
  if (F_s1_sz<4) CPAS__LTOPE_enlarge_sset(Rs.s,&F_s1, &F_s1_sz);
  if (F_s2_sz<4) CPAS__LTOPE_enlarge_sset(Rs.s+4,&F_s2, &F_s2_sz);
  Rv0=F_s1_sz/4;
  Rv1=F_s2_sz/4;
  if (Rv0>Rv1) Rv2=Rv1;
  else Rv2=Rv0;
  Rv3=0;
  for( Rf0=Rv2+1;Rf0>0;Rf0-- ) {
    ((UL *)F_dst)[Rv3-1]=((UL *)F_s1)[Rv3-1]&~((UL *)F_s2)[Rv3-1];
    Rv3++;
  }
  if (Rv0>Rv2) {
    Rv4=Rv2+1;
    for( Rf0=(Rv0+1)-(Rv2+1);Rf0>0;Rf0-- ) {
      ((SL *)F_dst)[Rv4-1]=((SL *)F_s1)[Rv4-1];
      Rv4++;
    }
  }
  else {
    if (Rv1>Rv2) {
      Rv5=Rv2+1;
      for( Rf0=(Rv1+1)-(Rv2+1);Rf0>0;Rf0-- ) {
        ((SL *)F_dst)[Rv5-1]=0;
        Rv5++;
      }
    }
  }
  Ret=F_dst;
  return(Ret);
}


/* Procedure/Function : " lset_compl "  */
V PAS__COM_LSET(V F_dst, V F_src, SL F_cad){
  /* Define the automatic variable space. */
  Blk( Ra, 8 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  register int Rf0;
  register V Ret;

  /* Code of procedure/function */
  Rv0=(F_cad+31)/32;
  Rv1=1;
  for( Rf0=Rv0;Rf0>0;Rf0-- ) {
    ((UL *)F_dst)[Rv1-1]=~((UL *)F_src)[Rv1-1];
    Rv1++;
  }
  F_cad=F_cad%32;
  if (F_cad>0) {
    if (F_cad==31) Ra.sl[0]=2147483647;
    else Ra.sl[0]=PAS__IIPOWER(2,F_cad)-1;
    ((UL *)F_dst)[Rv0-1]=((UL *)F_dst)[Rv0-1]&Ra.ul[0];
  }
  Ret=F_dst;
  return(Ret);
}


/* Procedure/Function : " lset_ge "  */
UB PAS__RINCL_LSET(V F_s1, SL F_sz1, V F_s2, SL F_sz2){
  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  register int Rgi;
  register int Rf0;
  register UB Ret;

  /* Code of procedure/function */
  if (F_sz2>F_sz1) {
    Rv0=F_sz1;
    Rv1=F_sz1;
    for( Rf0=((F_sz2-1)+1)-F_sz1;Rf0>0;Rf0-- ) {
      if (((SL *)F_s2)[Rv1-1]!=0) {
        Ret=0;
        goto Ret_Label;
      }
      Rv1++;
    }
  }
  else Rv0=F_sz2;
  Rv2=1;
  for( Rf0=Rv0;Rf0>0;Rf0-- ) {
    if (!PAS__SET_LE(((UL *)F_s2)[Rv2-1],((UL *)F_s1)[Rv2-1])) {
      Ret=0;
      goto Ret_Label;
    }
    Rv2++;
  }
  Ret=1;
  goto Ret_Label;
  Ret_Label: ;
  return(Ret);
}


/* Procedure/Function : " lset_le "  */
UB PAS__INCL_LSET(V F_s1, SL F_sz1, V F_s2, SL F_sz2){
  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  register int Rgi;
  register int Rf0;
  register UB Ret;

  /* Code of procedure/function */
  if (F_sz1>F_sz2) {
    Rv0=F_sz2;
    Rv1=F_sz2;
    for( Rf0=((F_sz1-1)+1)-F_sz2;Rf0>0;Rf0-- ) {
      if (((SL *)F_s1)[Rv1-1]!=0) {
        Ret=0;
        goto Ret_Label;
      }
      Rv1++;
    }
  }
  else Rv0=F_sz1;
  Rv2=0;
  for( Rf0=(Rv0-1)+1;Rf0>0;Rf0-- ) {
    if (!PAS__SET_LE(((UL *)F_s1)[Rv2-1],((UL *)F_s2)[Rv2-1])) {
      Ret=0;
      goto Ret_Label;
    }
    Rv2++;
  }
  Ret=1;
  goto Ret_Label;
  Ret_Label: ;
  return(Ret);
}


/* Procedure/Function : " lset_ne "  */
UB PAS__NEQ_LSET(V F_s1, SL F_sz1, V F_s2, SL F_sz2){
  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  register int Rf0;
  register UB Ret;

  /* Code of procedure/function */
  if (F_sz1!=F_sz2) {
    if (F_sz1>F_sz2) {
      Rv0=F_sz2;
      Rv1=F_sz2;
      for( Rf0=((F_sz1-1)+1)-F_sz2;Rf0>0;Rf0-- ) {
        if (((SL *)F_s1)[Rv1-1]!=0) {
          Ret=1;
          goto Ret_Label;
        }
        Rv1++;
      }
    }
    else {
      Rv0=F_sz1;
      Rv2=F_sz1;
      for( Rf0=((F_sz2-1)+1)-F_sz1;Rf0>0;Rf0-- ) {
        if (((SL *)F_s2)[Rv2-1]!=0) {
          Ret=1;
          goto Ret_Label;
        }
        Rv2++;
      }
    }
  }
  else Rv0=F_sz1;
  Rv3=0;
  for( Rf0=(Rv0-1)+1;Rf0>0;Rf0-- ) {
    if (((SL *)F_s1)[Rv3-1]!=((SL *)F_s2)[Rv3-1]) {
      Ret=1;
      goto Ret_Label;
    }
    Rv3++;
  }
  Ret=0;
  goto Ret_Label;
  Ret_Label: ;
  return(Ret);
}


/* Procedure/Function : " lset_eq "  */
UB PAS__EQU_LSET(V F_s1, SL F_sz1, V F_s2, SL F_sz2){
  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  register int Rf0;
  register UB Ret;

  /* Code of procedure/function */
  if (F_sz1!=F_sz2) {
    if (F_sz1>F_sz2) {
      Rv0=F_sz2;
      Rv1=F_sz2;
      for( Rf0=((F_sz1-1)+1)-F_sz2;Rf0>0;Rf0-- ) {
        if (((SL *)F_s1)[Rv1-1]!=0) {
          Ret=0;
          goto Ret_Label;
        }
        Rv1++;
      }
    }
    else {
      Rv0=F_sz1;
      Rv2=F_sz1;
      for( Rf0=((F_sz2-1)+1)-F_sz1;Rf0>0;Rf0-- ) {
        if (((SL *)F_s2)[Rv2-1]!=0) {
          Ret=0;
          goto Ret_Label;
        }
        Rv2++;
      }
    }
  }
  else Rv0=F_sz1;
  Rv3=0;
  for( Rf0=(Rv0-1)+1;Rf0>0;Rf0-- ) {
    if (((SL *)F_s1)[Rv3-1]!=((SL *)F_s2)[Rv3-1]) {
      Ret=0;
      goto Ret_Label;
    }
    Rv3++;
  }
  Ret=1;
  goto Ret_Label;
  Ret_Label: ;
  return(Ret);
}


/* Procedure/Function : " lset_in "  */
UB PAS__INOP_LSET(SL F_elem, V F_s, SL F_s_card){
  register UB Ret;

  /* Code of procedure/function */
  if (F_elem<0||F_elem>=F_s_card) {
    Ret=0;
    goto Ret_Label;
  }
  Ret=(1<<F_elem%32&((UL *)F_s)[(F_elem/32)-1])!=0;
  goto Ret_Label;
  Ret_Label: ;
  return(Ret);
}
