/*  P A S - P. WOLFERS SOFTWARE: V3.1-B5 OF 31-JAN-2022 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ long long

/* Include the PAS environment file. */
#include <cpas_defs.h>
static P Lx[1];

/* Define the local data section. */
static Blk( Rd, 3064 ) = {{
 14,  14, 115, 101, 116,  95, 112,  97, 114,  97, 109, 101, 116, 101, 114, 115,
 79,  79,  47, 114, 117, 110,  47, 109, 101, 100, 105,  97,  47, 112, 105, 101,
114, 114, 101,  47,  83,  83,  68,  95,  83,  97, 118, 101,  45,  49,  47,  99,
112, 115, 104,  95, 107, 105, 116, 115,  47,  99, 112,  97, 115,  99,  97, 108,
 95, 115, 114,  99,  95,  86,  51,  46,  49,  66,  54,  47, 103, 101, 110,  95,
 99, 112,  97, 115,  95, 105, 110,  99, 108,  95, 109, 115, 103,  46, 112,  97,
115,  14,  14,  32,  73, 110, 112, 117, 116,  32,  70, 105, 108, 101,  32,  61,
 32,  15,  15,  32,  79, 117, 116, 112, 117, 116,  32,  70, 105, 108, 101,  32,
 61,  32,   4,   4,  46, 112,  97, 115,  18,  18,  32,  80, 114, 111,  99, 101,
100, 117, 114, 101,  32,  78,  97, 109, 101,  32,  61,  32,  43,  43,  71,  69,
 78,  95,  67,  80,  65,  83,  95,  82,  84,  76,  95,  77,  83,  71,  32,  58,
 32,  73, 108, 108, 101, 103,  97, 108,  32, 112, 114, 111,  99, 101, 100, 117,
114, 101,  32, 110,  97, 109, 101,  32,  34,  13,  13, 114, 101,  97, 100,  95,
109, 101, 115, 115,  97, 103, 101, 115,  29,  29,  32,  67,  97, 110, 110, 111,
116,  32,  79, 112, 101, 110,  32, 116, 104, 101,  32, 105, 110, 112, 117, 116,
 32, 102, 105, 108, 101,  32,  34,   2,   2,  34,  46,  55,  55,  32,  71,  69,
 78,  95,  67,  80,  65,  83,  95,  82,  84,  76,  95,  77,  83,  71,  32,  58,
 32,  65, 110, 121,  32, 109, 101, 115, 115,  97, 103, 101,  32, 119,  97, 115,
 32, 102, 111, 117, 110, 100,  32, 105, 110,  32, 116, 104, 101,  32, 102, 105,
108, 101,  32,  34,  10,  10,  34,  32,  61,  62,  32,  83, 116, 111, 112,  46,
 22,  22, 109,  97, 107, 101,  95, 115, 111, 114, 116, 105, 110, 103,  95,  97,
110, 100,  95, 105, 110, 100, 101, 120,  16,  16, 111, 117, 116,  95, 108, 105,
110, 101,  95, 111, 102,  95,  98, 121, 116, 101,   4,   4,  32, 123,  32,  47,
  3,   3,  32,  58,  32,   2,   2,  32,  39,   2,   2,  32, 125,  14,  14, 112,
117, 116,  95, 109, 115, 103,  95, 108, 101, 110, 103, 116, 104,  12,  12, 112,
117, 116,  95, 109, 115, 103,  95,  99, 104,  97, 114,  14,  14, 119, 114, 105,
116, 101,  95, 112,  97, 115,  95,  99, 111, 100, 101,  30,  30,  32,  67,  97,
110, 110, 111, 116,  32,  79, 112, 101, 110,  32, 116, 104, 101,  32, 111, 117,
116, 112, 117, 116,  32, 102, 105, 108, 101,  32,  34,   2,   2,  34,  46,  84,
 84,  32,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,
 42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,
 42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,
 42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,
 42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,
 42,  42,  42,  42,  42,  84,  84,  32,  42,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  42,  84,  84,  32,  42,  32,
 32,  84, 104, 105, 115,  32, 102, 105, 108, 101,  32, 105, 115,  32,  97, 117,
116, 111, 109,  97, 116, 105,  99,  97, 108, 108, 121,  32, 103, 101, 110, 101,
114,  97, 116, 101, 100,  32, 102, 114, 111, 109,  32,  97,  32, 115, 112, 101,
 99, 105, 102, 105, 101, 100,  32, 100,  97, 116,  97,  32, 101, 114, 114, 111,
114,  32, 109, 101, 115, 115,  97, 103, 101,  32, 102, 105, 108, 101,  32,  32,
 42,  84,  84,  32,  42,  32,  32,  98, 121,  32, 116, 104, 101,  32,  32,  67,
 80,  65,  83,  32,  32,  85, 116, 105, 108, 105, 116, 105, 101, 115,  32, 112,
114, 111, 103, 114,  97, 109,  32,  32,  71,  69,  78,  95,  67,  80,  65,  83,
 95,  73,  78,  67,  76,  95,  77,  83,  71,  46,  32,  32,  84, 104, 101,  32,
 32, 105, 110,  99, 108, 117, 100, 101, 100,  32,  32, 112, 114, 111,  99, 101,
100, 117, 114, 101,  32,  32,  42,  84,  84,  32,  42,  32,  32,  80,  65,  83,
 95,  95,  71,  69,  84,  95,  73,  78,  67,  76,  95,  77,  83,  71,  32, 116,
 97, 107, 101,  32, 116, 104, 101,  32, 101, 114, 114, 111, 114,  32, 110, 117,
109,  98, 101, 114,  32,  60, 110, 101, 114, 114,  62,  44,  32, 108, 111,  99,
 97, 116, 101, 115,  32, 105, 110,  32, 105, 116, 115,  32, 105, 110, 116, 101,
114, 110,  97, 108,  32, 116,  97,  98, 108, 101,  32,  32,  42,  84,  84,  32,
 42,  32,  32, 116, 104, 101,  32, 114, 101, 108,  97, 116, 101, 100,  32, 109,
101, 115, 115,  97, 103, 101,  44,  32,  97, 110, 100,  32, 111, 110,  32, 115,
117,  99,  99, 101, 115, 115,  32, 114, 101, 116, 117, 114, 110,  32, 105, 116,
 32, 105, 110,  32, 116, 104, 101,  32, 102, 111, 114, 109,  97, 108,  32,  97,
114, 103, 117, 109, 101, 110, 116,  32,  60, 109, 115, 103,  62,  46,  32,  32,
 32,  32,  42,  84,  84,  32,  42,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  42,  84,  84,  32,  42,  32,  32,  84,
104, 105, 115,  32,  80,  97, 115,  99,  97, 108,  32,  99, 111, 100, 101,  32,
105, 115,  32,  97,  32, 112,  97, 114, 116,  32,  67,  80,  65,  83,  67,  65,
 76,  32, 107, 105, 116,  44,  32,  97, 110, 100,  32,  32,  97, 115,  32, 102,
111, 114,  32, 105, 116, 115,  32,  32, 111, 116, 104, 101, 114,  32, 102, 105,
108, 101, 115,  32, 111, 102,  32,  99, 111, 100, 101, 115,  32,  32,  42,  84,
 84,  32,  42,  32,  32, 116, 104, 105, 115,  32, 100, 111,  99, 117, 109, 101,
110, 116,  32, 105, 115,  32, 112, 114, 111, 116, 101,  99, 116, 101, 100,  32,
 98, 121,  32, 116, 104, 101,  32,  71,  78,  85,  32,  71, 108, 111,  98,  97,
108,  32,  80, 117,  98, 108, 105,  99,  32,  76, 105,  99, 101, 110, 115, 101,
 32,  76, 105,  99, 101, 110, 115, 101,  32,  40,  71,  80,  76,  41,  46,  32,
 32,  32,  32,  32,  42,  84,  84,  32,  42,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  42,  84,  84,  32,  42,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 42,  84,  84,  32,  42,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  42,  84,  84,  32,  42,  42,  42,  42,  42,  42,
 42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,
 42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,
 42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,
 42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,
 42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  13,  13, 109,
111, 100, 117, 108, 101,  32,  71,  73,  77,  83,  71,  95,   9,   9,  91, 103,
108, 111,  98,  97, 108,  32,  39,   2,   2,  39,  93,  10,  10, 112, 114, 111,
 99, 101, 100, 117, 114, 101,  32,  35,  35,  40,  32, 110, 101, 114, 114,  58,
 32, 105, 110, 116, 101, 103, 101, 114,  59,  32, 118,  97, 114,  32, 109, 115,
103,  58,  32, 115, 116, 114, 105, 110, 103,  32,  41,  59,   5,   5,  99, 111,
110, 115, 116,  13,  13,  32,  32, 100, 105, 114,  95, 115, 105, 122, 101,  32,
 61,  32,   4,   4, 116, 121, 112, 101,  20,  20,  32,  32, 101, 114, 114,  95,
101, 110, 116, 114, 121,  32,  61,  32, 114, 101,  99, 111, 114, 100,  12,  12,
 32,  32,  32,  32, 101, 114, 114,  95,  99, 111, 100,  44,  27,  27,  32,  32,
 32,  32, 101, 114, 114,  95, 109,  97, 100,  58,  32, 115, 104, 111, 114, 116,
 95, 105, 110, 116, 101, 103, 101, 114,  32,   6,   6,  32,  32, 101, 110, 100,
 59,  12,  12,  91, 115, 116,  97, 116, 105,  99,  93,  32, 118,  97, 114,  18,
 18,  32,  32, 105, 114,  44,  32, 115, 122,  58,  32, 105, 110, 116, 101, 103,
101, 114,  59,  20,  20,  32,  32, 109, 115, 103,  95, 116,  97,  98,  58,  32,
 97, 114, 114,  97, 121,  91,  49,  46,  46,  14,  14,  93,  32, 111, 102,  32,
 98, 121, 116, 101,  32,  58,  61,  32,  91,   4,   4,  32,  32,  93,  59,  47,
 47,  32,  32, 109, 115, 103,  95, 100, 105, 114,  58,  32,  97, 114, 114,  97,
121,  91,  49,  46,  46, 100, 105, 114,  95, 115, 105, 122, 101,  93,  32, 111,
102,  32, 101, 114, 114,  95, 101, 110, 116, 114, 121,  32,  58,  61,  32,  91,
  2,   2,  91,  32,   2,   2,  44,  32,   2,   2,  44,  32,   4,   4,  32,  32,
 93,  59,  55,  55,  32,  32, 102, 117, 110,  99, 116, 105, 111, 110,  32,  76,
 79,  67,  65,  84,  69,  95,  77,  83,  71,  40,  32, 110, 101, 114,  44,  32,
105,  49,  44,  32, 105,  50,  58,  32, 105, 110, 116, 101, 103, 101, 114,  32,
 41,  58,  32, 105, 110, 116, 101, 103, 101, 114,  59,   5,   5,  32,  32, 118,
 97, 114,  20,  20,  32,  32,  32,  32, 105, 109,  44,  32, 101, 109,  58,  32,
105, 110, 116, 101, 103, 101, 114,  59,   7,   7,  32,  32,  98, 101, 103, 105,
110,  24,  24,  32,  32,  32,  32, 105, 102,  32, 105,  50,  32,  45,  32, 105,
 49,  32,  60,  61,  32,  49,  32, 116, 104, 101, 110,  21,  21,  32,  32,  32,
 32,  32,  32, 105, 102,  32, 105,  50,  32,  61,  32, 105,  49,  32, 116, 104,
101, 110,  58,  58,  32,  32,  32,  32,  32,  32,  32,  32, 105, 102,  32, 110,
101, 114,  32,  61,  32, 109, 115, 103,  95, 100, 105, 114,  91, 105,  49,  93,
 46, 101, 114, 114,  95,  99, 111, 100,  32, 116, 104, 101, 110,  32,  76,  79,
 67,  65,  84,  69,  95,  77,  83,  71,  32,  58,  61,  32, 105,  49,  58,  58,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32, 101, 108, 115, 101,  32,  76,  79,  67,  65,  84,  69,
 95,  77,  83,  71,  32,  58,  61,  32,  32,  48,  10,  10,  32,  32,  32,  32,
 32,  32, 101, 108, 115, 101,  58,  58,  32,  32,  32,  32,  32,  32,  32,  32,
105, 102,  32, 110, 101, 114,  32,  61,  32, 109, 115, 103,  95, 100, 105, 114,
 91, 105,  49,  93,  46, 101, 114, 114,  95,  99, 111, 100,  32, 116, 104, 101,
110,  32,  76,  79,  67,  65,  84,  69,  95,  77,  83,  71,  32,  58,  61,  32,
105,  49,  63,  63,  32,  32,  32,  32,  32,  32,  32,  32, 101, 108, 115, 101,
 32, 105, 102,  32, 110, 101, 114,  32,  61,  32, 109, 115, 103,  95, 100, 105,
114,  91, 105,  50,  93,  46, 101, 114, 114,  95,  99, 111, 100,  32, 116, 104,
101, 110,  32,  76,  79,  67,  65,  84,  69,  95,  77,  83,  71,  32,  58,  61,
 32, 105,  50,  63,  63,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32, 101,
108, 115, 101,  32,  76,  79,  67,  65,  84,  69,  95,  77,  83,  71,  32,  58,
 61,  32,  32,  48,   8,   8,  32,  32,  32,  32, 101, 108, 115, 101,   9,   9,
 32,  32,  32,  32,  98, 101, 103, 105, 110,  55,  55,  32,  32,  32,  32,  32,
 32, 105, 109,  32,  58,  61,  32,  40, 105,  49,  32,  43,  32, 105,  50,  41,
 32, 100, 105, 118,  32,  50,  59,  32, 101, 109,  32,  58,  61,  32, 109, 115,
103,  95, 100, 105, 114,  91, 105, 109,  93,  46, 101, 114, 114,  95,  99, 111,
100,  59,  39,  39,  32,  32,  32,  32,  32,  32, 105, 102,  32, 110, 101, 114,
 32,  61,  32, 101, 109,  32, 116, 104, 101, 110,  32,  76,  79,  67,  65,  84,
 69,  95,  77,  83,  71,  32,  58,  61,  32, 105, 109,  10,  10,  32,  32,  32,
 32,  32,  32, 101, 108, 115, 101,  64,  64,  32,  32,  32,  32,  32,  32,  32,
 32, 105, 102,  32, 110, 101, 114,  32,  60,  32, 101, 109,  32, 116, 104, 101,
110,  32,  76,  79,  67,  65,  84,  69,  95,  77,  83,  71,  32,  58,  61,  32,
 76,  79,  67,  65,  84,  69,  95,  77,  83,  71,  40,  32, 110, 101, 114,  44,
 32, 105,  49,  44,  32, 105, 109,  32,  41,  64,  64,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32, 101,
108, 115, 101,  32,  76,  79,  67,  65,  84,  69,  95,  77,  83,  71,  32,  58,
 61,  32,  76,  79,  67,  65,  84,  69,  95,  77,  83,  71,  40,  32, 110, 101,
114,  44,  32, 105, 109,  44,  32, 105,  50,  32,  41,   7,   7,  32,  32,  32,
 32, 101, 110, 100,  17,  17,  32,  32, 101, 110, 100,  32,  76,  79,  67,  65,
 84,  69,  95,  77,  83,  71,  59,   8,   8,  98, 101, 103, 105, 110,  32, 123,
 32,   2,   2,  32, 125,  41,  41,  32,  32, 105, 114,  32,  32,  58,  61,  32,
 76,  79,  67,  65,  84,  69,  95,  77,  83,  71,  40,  32, 110, 101, 114, 114,
 44,  32,  49,  44,  32, 100, 105, 114,  95, 115, 105, 122, 101,  32,  41,  59,
 16,  16,  32,  32, 105, 102,  32, 105, 114,  32,  62,  32,  48,  32, 116, 104,
101, 110,  21,  21,  32,  32, 119, 105, 116, 104,  32, 109, 115, 103,  95, 100,
105, 114,  91, 105, 114,  93,  32, 100, 111,   7,   7,  32,  32,  98, 101, 103,
105, 110,  27,  27,  32,  32,  32,  32, 115, 122,  32,  58,  61,  32, 109, 115,
103,  95, 116,  97,  98,  91, 101, 114, 114,  95, 109,  97, 100,  93,  59,  49,
 49,  32,  32,  32,  32, 105, 102,  32, 115, 122,  32,  62,  32, 109, 115, 103,
 46,  99,  97, 112,  97,  99, 105, 116, 121,  32, 116, 104, 101, 110,  32, 115,
122,  32,  58,  61,  32, 109, 115, 103,  46,  99,  97, 112,  97,  99, 105, 116,
121,  59,  64,  64,  32,  32,  32,  32, 102, 111, 114,  32, 105, 105,  32,  58,
 61,  32,  49,  32, 116, 111,  32, 115, 122,  32, 100, 111,  32,  32, 109, 115,
103,  91, 105, 105,  93,  32,  58,  61,  32,  67,  72,  82,  40,  32, 109, 115,
103,  95, 116,  97,  98,  91, 101, 114, 114,  95, 109,  97, 100,  43, 105, 105,
 93,  32,  41,  59,  20,  20,  32,  32,  32,  32, 109, 115, 103,  46, 108, 101,
110, 103, 116, 104,  32,  58,  61,  32, 115, 122,   5,   5,  32,  32, 101, 110,
100,  22,  22,  32,  32, 101, 108, 115, 101,  32, 109, 115, 103,  46, 108, 101,
110, 103, 116, 104,  32,  58,  61,  32,  48,   4,   4, 101, 110, 100,  32,  10,
 10, 101, 110, 100,  32,  71,  73,  77,  83,  71,  95,  16,  16, 103, 101, 110,
 95,  99, 112,  97, 115,  95, 114, 116, 108,  95, 109, 115, 103,  50,  50,  32,
 71,  69,  78,  95,  67,  80,  65,  83,  95,  73,  78,  67,  76,  95,  77,  83,
 71,  32,  32, 104,  97, 115,  32,  99, 114, 101,  97, 116, 101, 100,  32, 116,
104, 101,  32, 109, 111, 100, 117, 108, 101,  32,  34,  71,  73,  77,  83,  71,
 95,   2,   2,  34,  46,   0,   0,   0
}};

/* Define the local static Initialized section. */
static Blk( Ri, 816 ) = {{
255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
}};

/* Define the local static section. */
static Blk( Rs, 40 );

/* Declaration of external variables. */
extern SL PAS__argc;
extern Blk(PAS__argv, 1032 );
extern V PAS__f_output;
extern V PAS__f_input;
extern SL PAS__iostatus;




/* Procedure/Function : " set_parameters "  */
void GEN_CPA_MSG_set_parameters(){
  /* Define the automatic variable space. */
  Blk( Ra, 288 );

  /* Local variable stored in C variable */
  UB Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  register int Rf0;

  /* Code of procedure/function */
  Rv0=0;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=106; /* line # 106 */
  if (PAS__argc>1) {
    PAS__STR_TO_STR(Ri.s,PAS__argv.v[1]);
    if (PAS__argc>2) PAS__STR_TO_STR(Ri.s+257,PAS__argv.v[2]);
    if (PAS__argc>3) PAS__STR_TO_STR(Ri.s+514,PAS__argv.v[3]);
  }
  Ra.sl[6]=112; /* line # 112 */
  if (Ri.ub[1]==0) {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_EOLN();
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+97,-1,-1,32);
    PAS__SELECT_INP(PAS__f_input);
    PAS__READ_STR(Ri.s,0,0);
    PAS__READ_EOLN();
  }
  if (Ri.ub[258]==0) {
    Ra.sl[6]=118; /* line # 118 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_EOLN();
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+113,-1,-1,32);
    PAS__SELECT_INP(PAS__f_input);
    PAS__READ_STR(Ri.s+257,0,0);
    PAS__READ_EOLN();
    Rv1=PAS__NINDEX_CHA(Ri.s+259,(SL)Ri.ub[258],47,-1,-1,1);
    Rv2=PAS__NINDEX_CHA(Ri.s+259,(SL)Ri.ub[258],46,-1,-1,1);
    if (Rv2<=Rv1) PAS__STR_TO_STR(Ri.s+257,PAS__CON_STR_STR(Ra.s+28,Ri.s+257,Rd.
    s+130));
  }
  Ra.sl[6]=123; /* line # 123 */
  if (Ri.ub[515]==0) {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_EOLN();
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+136,-1,-1,32);
    PAS__SELECT_INP(PAS__f_input);
    PAS__READ_STR(Ri.s+514,0,0);
    PAS__READ_EOLN();
    Rv3=1;
    for( Rf0=Ri.ub[515];Rf0>0;Rf0-- ) {
      switch (Ri.c[Rv3+515]) {
        case 35:
        case 36:
        case 37:
        case 65:
        case 66:
        case 67:
        case 68:
        case 69:
        case 70:
        case 71:
        case 72:
        case 73:
        case 74:
        case 75:
        case 76:
        case 77:
        case 78:
        case 79:
        case 80:
        case 81:
        case 82:
        case 83:
        case 84:
        case 85:
        case 86:
        case 87:
        case 88:
        case 89:
        case 90:
        case 95:
        case 97:
        case 98:
        case 99:
        case 100:
        case 101:
        case 102:
        case 103:
        case 104:
        case 105:
        case 106:
        case 107:
        case 108:
        case 109:
        case 110:
        case 111:
        case 112:
        case 113:
        case 114:
        case 115:
        case 116:
        case 117:
        case 118:
        case 119:
        case 120:
        case 121:
        case 122:break;
        case 48:
        case 49:
        case 50:
        case 51:
        case 52:
        case 53:
        case 54:
        case 55:
        case 56:
        case 57:Ra.sl[6]=129; /* line # 129 */
        if (Rv3==1) Rv0=1;
        break;
        default:Rv0=1;
        break;
      }
      Rv3++;
    }
    if (Rv0) {
      Ra.sl[6]=135; /* line # 135 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+156,-1,-1,32);
      PAS__WRITE_STR(Ri.s+514,-1,-1,32);
      PAS__WRITE_CHAR(34);
      PAS__WRITE_EOLN();
      PAS__EXIT(2);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " read_messages "  */
void GEN_CPA_MSG_read_messages(){
  /* Define the automatic variable space. */
  Blk( Ra, 296 );

  /* Local variable stored in C variable */
  V Rv0;
  SL Rv1;
  C Rv2;
  register UB Rv3;
  V Rv4;
  register V Rv5;

  /* Code of procedure/function */
  Rv0=NULL;
  Ra.ub[0]=255;
  Ra.v[33]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+264;
  Ra.v[34]=Rd.s+201;
  Ra.v[35]=Rd.s+16;
  Ra.sl[72]=152; /* line # 152 */
  PAS__OPEN(&Rv0,0, Ri.s,4097,0,-1);
  if (PAS__iostatus!=0) {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+216,-1,-1,32);
    PAS__WRITE_STR(Ri.s,-1,-1,32);
    PAS__WRITE_STR(Rd.s+247,-1,-1,32);
    PAS__WRITE_EOLN();
    Ra.sl[72]=157; /* line # 157 */
    PAS__EXIT(2);
  }
  while (!PAS__EOF(Rv0)){
    PAS__SELECT_INP(Rv0);
    PAS__READ_SL(&Rv1,0);
    Ra.sl[72]=163; /* line # 163 */
    Rv2=32;
    while (!PAS__EOLN(Rv0)&&Rv2!=59){
      PAS__SELECT_INP(Rv0);
      PAS__READ_CHAR(&Rv2);
    }
    PAS__SELECT_INP(Rv0);
    PAS__READ_CHAR(&Rv2);
    PAS__READ_STR(Ra.s,0,0);
    PAS__READ_EOLN();
    if (Ra.ub[1]>0) {
      Ra.sl[72]=168; /* line # 168 */
      if (Ri.sl[193]<Rv1) Ri.sl[193]=Rv1;
      Rv3=Ra.ub[1];
      Rv4=PAS__NEW(((SL)Rv3+2)+24);
      ((UB *)Rv4)[0]=Rv3;
      ((UB *)Rv4)[24]=Rv3;
      Rv5=Rv4;
      ((V *)Rv5)[1]=NULL;
      Ra.sl[72]=173; /* line # 173 */
      ((SL *)Rv5)[4]=Rv1;
      ((SL *)Rv5)[5]=Ri.sl[194];
      PAS__STR_TO_STR(Rv5+24,Ra.s);
      if (Ri.v[98]==NULL) Ri.v[98]=Rv4;
      else {
        Ra.sl[72]=178; /* line # 178 */
        ((V *)Ri.v[99])[1]=Rv4;
      }
      Ri.v[99]=Rv4;
      Ri.sl[194]=(Ri.sl[194]+Ra.ub[1])+1;
      Ri.sl[200]=Ri.sl[200]+1;
    }
  }
  Ra.sl[72]=184; /* line # 184 */
  PAS__CLOSE(&Rv0,0);
  if (Ri.v[98]==NULL) {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+251,-1,-1,32);
    PAS__WRITE_STR(Ri.s,-1,-1,32);
    PAS__WRITE_STR(Rd.s+308,-1,-1,32);
    PAS__WRITE_EOLN();
    PAS__EXIT(2);
  }
  PAS__curr_cntx=Ra.v[33];
}


/* Procedure/Function : " make_sorting_and_index "  */
void GEN_CPA_MSG_make_sorting_anndex(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register SL Rv0;
  V Rv1;
  SL Rv2;
  V Rv3;
  register V Rv4;
  register SL Rv5;
  SL Rv6;
  SL Rv7;
  register V Rv8;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+320;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=201; /* line # 201 */
  Rv0=Ri.sl[193];
  Rv1=PAS__NEW(Rv0*8+8);
  ((SL *)Rv1)[0]=Rv0;
  Rv2=1;
  for( Rf0=Ri.sl[193];Rf0>0;Rf0-- ) {
    ((V *)Rv1)[Rv2]=NULL;
    Rv2++;
  }
  Rv3=Ri.v[98];
  while (Rv3!=NULL){
    Rv4=Rv3;
    Ra.sl[6]=207; /* line # 207 */
    ((V *)Rv1)[((SL *)Rv4)[4]]=Rv3;
    Rv3=((V *)Rv4)[1];
  }
  Rv5=Ri.sl[200];
  Rs.v[0]=PAS__NEW(Rv5*16+8);
  ((SL *)Rs.v[0])[0]=Rv5;
  Rv6=0;
  Ra.sl[6]=212; /* line # 212 */
  Rv7=1;
  for( Rf0=Ri.sl[193];Rf0>0;Rf0-- ) {
    if (((V *)Rv1)[Rv7]!=NULL) {
      Rv6=Rv6+1;
      Rv8=(((S *)Rs.v[0])+Rv6*16-8);
      Ra.sl[6]=218; /* line # 218 */
      ((SL *)Rv8)[0]=Rv7;
      ((SL *)Rv8)[1]=0;
      ((V *)Rv8)[1]=((V *)Rv1)[Rv7];
    }
    Rv7++;
  }
  Ra.sl[6]=223; /* line # 223 */
  PAS__DISPOSE(&Rv1);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " out_line_of_byte "  */
void GEN_CPA_MSG_PRC_00000000(UB F_bce){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+344;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=237; /* line # 237 */
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_FCHAR(32,4,-1,1,32);
  Rv0=0;
  for( Rf0=Lx[0].sl[0]+1;Rf0>0;Rf0-- ) {
    PAS__SELECT_OUT(Ri.v[101]);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_INT(Lx[0].ub[Rv0+4],-3,0);
    if (F_bce||Rv0<Lx[0].sl[0]) {
      PAS__SELECT_OUT(Ri.v[101]);
      PAS__WRITE_CHAR(44);
    }
    else {
      Ra.sl[6]=242; /* line # 242 */
      PAS__SELECT_OUT(Ri.v[101]);
      PAS__WRITE_CHAR(32);
    }
    Rv0++;
  }
  if (Lx[0].sl[0]<15) for( Rf0=16-(Lx[0].sl[0]+1);Rf0>0;Rf0-- ) {
    PAS__SELECT_OUT(Ri.v[101]);
    PAS__WRITE_FCHAR(32,5,-1,1,32);
  }
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+362,-1,-1,32);
  PAS__WRITE_INT(Lx[0].sl[5],-5,0);
  PAS__WRITE_STR(Rd.s+368,-1,-1,32);
  Rv1=0;
  for( Rf0=Lx[0].sl[0]+1;Rf0>0;Rf0-- ) {
    Ra.sl[6]=248; /* line # 248 */
    if (Lx[0].ub[Rv1+24]) {
      PAS__SELECT_OUT(Ri.v[101]);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_INT(Lx[0].ub[Rv1+4],-3,0);
    }
    else {
      PAS__SELECT_OUT(Ri.v[101]);
      PAS__WRITE_STR(Rd.s+373,-1,-1,32);
      PAS__WRITE_CHAR(Lx[0].c[Rv1+4]);
      PAS__WRITE_CHAR(39);
    }
    if (F_bce||Rv1<Lx[0].sl[0]) {
      PAS__SELECT_OUT(Ri.v[101]);
      PAS__WRITE_CHAR(44);
    }
    else {
      PAS__SELECT_OUT(Ri.v[101]);
      PAS__WRITE_CHAR(32);
    }
    Rv1++;
  }
  Ra.sl[6]=253; /* line # 253 */
  if (Lx[0].sl[0]<15) for( Rf0=16-(Lx[0].sl[0]+1);Rf0>0;Rf0-- ) {
    PAS__SELECT_OUT(Ri.v[101]);
    PAS__WRITE_FCHAR(32,5,-1,1,32);
  }
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+377,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " put_msg_length "  */
void GEN_CPA_MSG_PRC_00000001(SL F_len){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+381;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=261; /* line # 261 */
  Lx[0].sl[0]=Lx[0].sl[10]&15;
  if (Lx[0].sl[0]==0) Lx[0].sl[5]=Lx[0].sl[10]+1;
  Lx[0].ub[Lx[0].sl[0]+4]=F_len;
  Lx[0].ub[Lx[0].sl[0]+24]=1;
  if (Lx[0].sl[0]==15) GEN_CPA_MSG_PRC_00000000(Lx[0].sl[10]<Ri.sl[194]);
  Lx[0].sl[10]=Lx[0].sl[10]+1;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " put_msg_char "  */
void GEN_CPA_MSG_PRC_00000002(C F_ch){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+397;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=272; /* line # 272 */
  Lx[0].sl[0]=Lx[0].sl[10]&15;
  if (Lx[0].sl[0]==0) Lx[0].sl[5]=Lx[0].sl[10]+1;
  Lx[0].ub[Lx[0].sl[0]+4]=(SL)F_ch;
  Lx[0].ub[Lx[0].sl[0]+24]=0;
  if (Lx[0].sl[0]==15) GEN_CPA_MSG_PRC_00000000(Lx[0].sl[10]<Ri.sl[194]);
  Lx[0].sl[10]=Lx[0].sl[10]+1;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " write_pas_code "  */
void GEN_CPA_MSG_write_pas_code(){
  /* Define the automatic variable space. */
  Blk( Ra, 80 );

  /* Local variable stored in C variable */
  SL Rv0;
  register V Rv1;
  register V Rv2;
  SL Rv3;
  SL Rv4;
  register V Rv5;
  register int Rf1, Rf0;
  register P Lx_Sv;
  Lx_Sv=Lx[0];
  Lx[0].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[6]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+48;
  Ra.v[7]=Rd.s+411;
  Ra.v[8]=Rd.s+16;
  Ra.sl[18]=282; /* line # 282 */
  PAS__OPEN(Ri.v+101,0, Ri.s+257,4098,0,-1);
  if (PAS__iostatus!=0) {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+427,-1,-1,32);
    PAS__WRITE_STR(Ri.s+257,-1,-1,32);
    PAS__WRITE_STR(Rd.s+459,-1,-1,32);
    PAS__WRITE_EOLN();
    Ra.sl[18]=287; /* line # 287 */
    PAS__EXIT(2);
  }
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_CHAR(123);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+463,-1,-1,32);
  PAS__WRITE_EOLN();
  Ra.sl[18]=292; /* line # 292 */
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+549,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+635,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+721,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+807,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+893,-1,-1,32);
  PAS__WRITE_EOLN();
  Ra.sl[18]=297; /* line # 297 */
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+979,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+1065,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+1151,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+1237,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+1323,-1,-1,32);
  PAS__WRITE_EOLN();
  Ra.sl[18]=302; /* line # 302 */
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+1409,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+1495,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_CHAR(125);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+1581,-1,-1,32);
  PAS__WRITE_STR(Ri.s+514,-1,-1,32);
  PAS__WRITE_CHAR(59);
  PAS__WRITE_EOLN();
  Ra.sl[18]=307; /* line # 307 */
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+1596,-1,-1,32);
  PAS__WRITE_STR(Ri.s+514,-1,-1,32);
  PAS__WRITE_STR(Rd.s+1607,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+1611,-1,-1,32);
  PAS__WRITE_STR(Ri.s+514,-1,-1,32);
  PAS__WRITE_STR(Rd.s+1623,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+1660,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+1667,-1,-1,32);
  PAS__WRITE_INT(Ri.sl[200],3,0);
  PAS__WRITE_CHAR(59);
  PAS__WRITE_EOLN();
  Ra.sl[18]=312; /* line # 312 */
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+1682,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+1688,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+1710,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+1724,-1,-1,32);
  PAS__WRITE_EOLN();
  Ra.sl[18]=317; /* line # 317 */
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+1753,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+1761,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+1775,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_EOLN();
  Ra.sl[18]=322; /* line # 322 */
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+1795,-1,-1,32);
  PAS__WRITE_INT(Ri.sl[194],0,0);
  PAS__WRITE_STR(Rd.s+1817,-1,-1,32);
  PAS__WRITE_EOLN();
  Ra.sl[0]=0;
  Ra.sl[10]=0;
  Rv0=1;
  for( Rf1=Ri.sl[200];Rf1>0;Rf1-- ) {
    Rv1=(((S *)Rs.v[0])+Rv0*16-8);
    Rv2=((V *)Rv1)[1];
    Ra.sl[18]=328; /* line # 328 */
    ((SL *)Rv1)[1]=Ra.sl[10]+1;
    GEN_CPA_MSG_PRC_00000001(((UB *)Rv2)[25]);
    Rv3=1;
    for( Rf0=((UB *)Rv2)[25];Rf0>0;Rf0-- ) {
      GEN_CPA_MSG_PRC_00000002(((C *)Rv2)[Rv3+25]);
      Rv3++;
    }
    Rv0++;
  }
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_EOLN();
  Ra.sl[18]=333; /* line # 333 */
  if ((Ra.sl[0]&15)!=15) GEN_CPA_MSG_PRC_00000000(0);
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+1833,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+1839,-1,-1,32);
  PAS__WRITE_EOLN();
  Ra.sl[18]=338; /* line # 338 */
  Ra.sl[0]=0;
  Rv4=1;
  for( Rf1=Ri.sl[200];Rf1>0;Rf1-- ) {
    Rv5=(((S *)Rs.v[0])+Rv4*16-8);
    Ra.sl[0]=Ra.sl[0]+1;
    Ra.sl[18]=343; /* line # 343 */
    if (Ra.sl[0]==1) {
      PAS__SELECT_OUT(Ri.v[101]);
      PAS__WRITE_FCHAR(32,4,-1,1,32);
    }
    PAS__SELECT_OUT(Ri.v[101]);
    PAS__WRITE_STR(Rd.s+1888,-1,-1,32);
    PAS__WRITE_INT(((SL *)Rv5)[0],4,0);
    PAS__WRITE_STR(Rd.s+1892,-1,-1,32);
    PAS__WRITE_INT(((SL *)Rv5)[1],4,0);
    PAS__WRITE_CHAR(93);
    if (Rv4==Ri.sl[200]) {
      PAS__SELECT_OUT(Ri.v[101]);
      PAS__WRITE_EOLN();
    }
    else {
      Ra.sl[18]=348; /* line # 348 */
      if (Ra.sl[0]==8) {
        PAS__SELECT_OUT(Ri.v[101]);
        PAS__WRITE_CHAR(44);
        PAS__WRITE_EOLN();
        Ra.sl[0]=0;
      }
      else {
        PAS__SELECT_OUT(Ri.v[101]);
        PAS__WRITE_STR(Rd.s+1896,-1,-1,32);
      }
    }
    Rv4++;
  }
  if (Ra.sl[0]!=0) {
    PAS__SELECT_OUT(Ri.v[101]);
    PAS__WRITE_EOLN();
  }
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+1900,-1,-1,32);
  PAS__WRITE_EOLN();
  Ra.sl[18]=353; /* line # 353 */
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+1906,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+1963,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+1970,-1,-1,32);
  PAS__WRITE_EOLN();
  Ra.sl[18]=358; /* line # 358 */
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+1992,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+2001,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+2027,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+2050,-1,-1,32);
  PAS__WRITE_EOLN();
  Ra.sl[18]=363; /* line # 363 */
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+2110,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+2170,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+2182,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+2242,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+2307,-1,-1,32);
  PAS__WRITE_EOLN();
  Ra.sl[18]=368; /* line # 368 */
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+2372,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+2382,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+2393,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+2450,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+2491,-1,-1,32);
  PAS__WRITE_EOLN();
  Ra.sl[18]=373; /* line # 373 */
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+2503,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+2569,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+2635,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+2644,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_EOLN();
  Ra.sl[18]=378; /* line # 378 */
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+2663,-1,-1,32);
  PAS__WRITE_STR(Ri.s+514,-1,-1,32);
  PAS__WRITE_STR(Rd.s+2673,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+2677,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+2720,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+2738,-1,-1,32);
  PAS__WRITE_EOLN();
  Ra.sl[18]=383; /* line # 383 */
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+2761,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+2770,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+2799,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+2850,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+2916,-1,-1,32);
  PAS__WRITE_EOLN();
  Ra.sl[18]=388; /* line # 388 */
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+2938,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+2945,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+2969,-1,-1,32);
  PAS__WRITE_STR(Ri.s+514,-1,-1,32);
  PAS__WRITE_CHAR(59);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(Ri.v[101]);
  PAS__WRITE_STR(Rd.s+2975,-1,-1,32);
  PAS__WRITE_STR(Ri.s+514,-1,-1,32);
  PAS__WRITE_CHAR(46);
  PAS__WRITE_EOLN();
  Ra.sl[18]=393; /* line # 393 */
  PAS__CLOSE(Ri.v+101,0);
  PAS__curr_cntx=Ra.v[6];
  Lx[0]=Lx_Sv;
}


/* Procedure/Function : " gen_cpas_rtl_msg "  */
int main( int argc, C * argv[], C * env[] ) {

  /* Code of procedure/function */
  PAS__INIT( argc, argv, env );
  Rs.v[1]=PAS__curr_cntx;
  PAS__curr_cntx=Rs.s+8;
  Rs.v[2]=Rd.s+2987;
  Rs.v[3]=Rd.s+16;
  Rs.sl[8]=398; /* line # 398 */
  GEN_CPA_MSG_set_parameters();
  GEN_CPA_MSG_read_messages();
  GEN_CPA_MSG_make_sorting_anndex();
  GEN_CPA_MSG_write_pas_code();
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+3005,-1,-1,32);
  PAS__WRITE_STR(Ri.s+514,-1,-1,32);
  PAS__WRITE_STR(Rd.s+3057,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Rs.v[1];
  PAS__EXIT( 0 );
}
