/*  P A S - P. WOLFERS SOFTWARE: V3.1-B5 OF 31-JAN-2022 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ long long int

/* Include the PAS environment file. */
#include <cpas_defs.h>

/* Define the local data section. */
static Blk( Rd, 328 ) = {{
 15,  15, 112,  97, 115,  95,  95, 103, 101, 116,  95, 100, 111, 117,  98, 108,
101,  73,  73,  47, 114, 117, 110,  47, 109, 101, 100, 105,  97,  47, 112, 105,
101, 114, 114, 101,  47,  83,  83,  68,  95,  83,  97, 118, 101,  45,  49,  47,
 99, 112, 115, 104,  95, 107, 105, 116, 115,  47,  99, 112,  97, 115,  99,  97,
108,  95, 115, 114,  99,  95,  86,  51,  46,  49,  66,  54,  47,  99, 112,  97,
115,  95,  95, 105, 111, 110, 117, 109,  46, 112,  97, 115,  11,  11, 114, 101,
 97, 100,  95, 100, 111, 117,  98, 108, 101,  11,  11, 114, 101,  97, 100,  95,
115, 105, 110, 103, 108, 101,   8,   8, 114, 101,  97, 100,  95, 105, 110, 116,
  7,   7, 114, 101,  97, 100,  95, 117, 108,   7,   7, 114, 101,  97, 100,  95,
115, 119,   7,   7, 114, 101,  97, 100,  95, 117, 119,   7,   7, 114, 101,  97,
100,  95, 115,  98,   7,   7, 114, 101,  97, 100,  95, 117,  98,   9,   9, 119,
114, 105, 116, 101,  95, 117, 110, 115,   9,   9, 119, 114, 105, 116, 101,  95,
105, 110, 116,  11,  11, 112, 117, 116,  95, 100, 101,  99, 105, 109,  97, 108,
 11,  11, 115, 105, 122, 101,  95, 100, 111, 117,  98, 108, 101,  15,  15, 112,
 97, 115,  95,  95, 112, 117, 116,  95, 101,  95, 100,  98, 108, 101,  15,  15,
112,  97, 115,  95,  95, 112, 117, 116,  95, 102,  95, 100,  98, 108, 101,  19,
 19, 119, 114, 105, 116, 101,  95, 101, 120,  99, 101, 112, 116,  95, 110, 117,
109,  98, 101, 114,   5,   5,  32,  63,  63,  63,  32,   3,   3,  78,  97, 110,
  4,   4,  43,  73, 110, 102,   4,   4,  45,  73, 110, 102,  10,  10, 119, 114,
105, 116, 101,  95, 100,  98, 108, 101,  10,  10, 119, 114, 105, 116, 101,  95,
115, 110, 103, 108,   0,   0,   0,   0
}};

/* Declaration of external variables. */
extern V PAS__curr_iptr;


/* Function/procedure prototypes. */
UB Pas__FpClassify_F(F F_v);
UB Pas__FpClassify_D(G F_v);
void Pas__Float_Trap();
void PAS__ERROR(SL F_nerr);


/* Procedure/Function : " pas__get_double "  */
void P_pas__get_double(G *F_fl, SL F_fld){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  G Rv0;
  G Rv1;
  SL Rv2;
  UB Rv3;
  UB Rv4;
  UB Rv5;
  C Rv6;
  SL Rv7;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=99; /* line # 99 */
  Rv0=0.000000000000000E-001;
  Ra.sl[3]=100; /* line # 100 */
  Rv1=1.000000000000000E-001;
  Ra.sl[3]=101; /* line # 101 */
  Rv2=0;
  Ra.sl[3]=102; /* line # 102 */
  Rv3=0;
  Ra.sl[3]=103; /* line # 103 */
  Rv4=0;
  Ra.sl[3]=104; /* line # 104 */
  Rv5=0;
  while (1){
    Ra.sl[3]=107; /* line # 107 */
    if (PAS__UFB(PAS__curr_iptr)) PAS__GET(PAS__curr_iptr);
    Ra.sl[3]=108; /* line # 108 */
    if (PAS__CURR_EOF()||Rv5>0&&PAS__CURR_EOLN())  break;
    Ra.sl[3]=110; /* line # 110 */
    if (F_fld>=0) F_fld=F_fld-1;
    Ra.sl[3]=111; /* line # 111 */
    Rv6=((C *)((V *)PAS__curr_iptr)[0])[0];
    Ra.sl[3]=115; /* line # 115 */
    switch (Rv6) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
      case 7:
      case 8:
      case 9:
      case 10:
      case 11:
      case 12:
      case 13:
      case 14:
      case 15:
      case 16:
      case 17:
      case 18:
      case 19:
      case 20:
      case 21:
      case 22:
      case 23:
      case 24:
      case 25:
      case 26:
      case 27:
      case 28:
      case 29:
      case 30:
      case 31:
      case 32:Ra.sl[3]=116; /* line # 116 */
      if (Rv5>0) goto L_l_0;
      break;
      case 43:
      case 45:Ra.sl[3]=119; /* line # 119 */
      switch (Rv5) {
        case 0:Ra.sl[3]=120; /* line # 120 */
        Rv5=1;
        if (Rv6==45) Rv3=1;
        break;
        case 4:Ra.sl[3]=121; /* line # 121 */
        Rv5=5;
        if (Rv6==45) Rv4=1;
        break;
        default:Ra.sl[3]=123; /* line # 123 */
        goto L_l_0;
        break;
      }
      break;
      case 48:
      case 49:
      case 50:
      case 51:
      case 52:
      case 53:
      case 54:
      case 55:
      case 56:
      case 57:Ra.sl[3]=128; /* line # 128 */
      Rv7=(SL)Rv6-48;
      Ra.sl[3]=129; /* line # 129 */
      switch (Rv5) {
        case 0:
        case 1:
        case 2:Ra.sl[3]=132; /* line # 132 */
        Rv0=Rv0*1.000000000000000E+001+(double)Rv7;
        Ra.sl[3]=133; /* line # 133 */
        if (Rv5<2) Rv5=2;
        break;
        case 3:Ra.sl[3]=135; /* line # 135 */
        Rv0=Rv0+Rv1*(double)Rv7;
        Rv1=Rv1*1.000000000000000E-001;
        break;
        case 4:
        case 5:Ra.sl[3]=138; /* line # 138 */
        Rv2=Rv2*10+Rv7;
        Ra.sl[3]=139; /* line # 139 */
        if (Rv5<5) Rv5=5;
        break;
        default:break;
      }
      break;
      case 46:Ra.sl[3]=145; /* line # 145 */
      if (Rv5<3) Rv5=3;
      else goto L_l_0;
      break;
      case 68:
      case 69:
      case 100:
      case 101:Ra.sl[3]=148; /* line # 148 */
      if (Rv5<4) {
        Ra.sl[3]=149; /* line # 149 */
        if (Rv5<2) Rv0=1.000000000000000E+000;
        Rv5=4;
      }
      else {
        Ra.sl[3]=150; /* line # 150 */
        goto L_l_0;
      }
      break;
      default:Ra.sl[3]=153; /* line # 153 */
      if (Rv5>0) goto L_l_0;
      Ra.sl[3]=154; /* line # 154 */
      PAS__ERROR(51);
      break;
    }
    Ra.sl[3]=156; /* line # 156 */
    PAS__GET(PAS__curr_iptr);
    if (F_fld==0)  break;
  }
L_l_0: ;
  Ra.sl[3]=159; /* line # 159 */
  if (Rv5==0) PAS__ERROR(51);
  Ra.sl[3]=162; /* line # 162 */
  if (Rv2!=0) {
    Ra.sl[3]=164; /* line # 164 */
    if (Rv4) Rv2= -Rv2;
    Ra.sl[3]=165; /* line # 165 */
    Rv0=Rv0*PAS__IGPOWER(1.000000000000000E+001,Rv2);
  }
  Ra.sl[3]=167; /* line # 167 */
  if (Rv3) Rv0=-Rv0;
  Ra.sl[3]=168; /* line # 168 */
  (*F_fl)=Rv0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " read_double "  */
void PAS__READ_DBLE(G *F_fl, SL F_f){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+92;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=176; /* line # 176 */
  P_pas__get_double(F_fl,F_f);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " read_single "  */
void PAS__READ_SNGL(F *F_fl, SL F_f){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  G Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+105;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=184; /* line # 184 */
  P_pas__get_double(&Rv0, F_f);
  Ra.sl[3]=185; /* line # 185 */
  (*F_fl)=(float)Rv0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " read_int "  */
void PAS__READ_SL(SL *F_iv, SL F_f){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  G Rv0;
  register G Rgg;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+118;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=199; /* line # 199 */
  P_pas__get_double(&Rv0, F_f);
  Ra.sl[3]=200; /* line # 200 */
  (*F_iv)=(Rv0>0.0?(SL)(Rv0+0.5):(SL)(Rv0-0.5));
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " read_ul "  */
void PAS__READ_UL(UL *F_iv, SL F_f){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+128;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=208; /* line # 208 */
  PAS__READ_SL(&Rv0, F_f);
  (*F_iv)=Rv0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " read_sw "  */
void PAS__READ_SW(SW *F_iv, SL F_f){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+137;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=216; /* line # 216 */
  PAS__READ_SL(&Rv0, F_f);
  (*F_iv)=Rv0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " read_uw "  */
void PAS__READ_UW(UW *F_iv, SL F_f){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+146;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=224; /* line # 224 */
  PAS__READ_SL(&Rv0, F_f);
  (*F_iv)=Rv0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " read_sb "  */
void PAS__READ_SB(SB *F_iv, SL F_f){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+155;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=232; /* line # 232 */
  PAS__READ_SL(&Rv0, F_f);
  (*F_iv)=Rv0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " read_ub "  */
void PAS__READ_UB(UB *F_iv, SL F_f){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+164;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=240; /* line # 240 */
  PAS__READ_SL(&Rv0, F_f);
  (*F_iv)=Rv0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " write_uns "  */
void PAS__WRITE_UNS(UL F_iv, SL F_f, SL F_b){
  /* Define the automatic variable space. */
  Blk( Ra, 88 );

  /* Local variable stored in C variable */
  C Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+173;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=257; /* line # 257 */
  Rv0=32;
  Ra.sl[3]=258; /* line # 258 */
  if (F_iv==0) {
    Ra.sl[3]=260; /* line # 260 */
    Ra.c[16]=48;
    Rv1=1;
  }
  else {
    Ra.sl[3]=264; /* line # 264 */
    if (F_b<2||F_b>16) F_b=10;
    Ra.sl[3]=265; /* line # 265 */
    Rv1=0;
    Ra.sl[3]=266; /* line # 266 */
    while (F_iv!=0){
      Ra.sl[3]=268; /* line # 268 */
      Rv1=Rv1+1;
      Ra.sl[3]=269; /* line # 269 */
      Rv2=F_iv%F_b;
      Ra.sl[3]=270; /* line # 270 */
      if (Rv2>9) {
        Ra.sl[3]=271; /* line # 271 */
        Ra.c[Rv1+15]=(C)((Rv2+65)-10);
      }
      else {
        Ra.sl[3]=273; /* line # 273 */
        Ra.c[Rv1+15]=(C)(Rv2+48);
      }
      Ra.sl[3]=274; /* line # 274 */
      F_iv=F_iv/F_b;
    }
  }
  Ra.sl[3]=277; /* line # 277 */
  if (F_f==0) F_f=Rv1;
  else {
    Ra.sl[3]=279; /* line # 279 */
    if (F_f<0) {
      Ra.sl[3]=281; /* line # 281 */
      Rv0=48;
      F_f= -F_f;
    }
  }
  Ra.sl[3]=283; /* line # 283 */
  Rv3=F_f-Rv1;
  Ra.sl[3]=284; /* line # 284 */
  if (Rv3>=0) {
    Ra.sl[3]=286; /* line # 286 */
    for( Rf0=Rv3;Rf0>0;Rf0-- )
    PAS__WRITE_CHAR(Rv0);
    Ra.sl[3]=287; /* line # 287 */
    while (Rv1>0){
      Ra.sl[3]=289; /* line # 289 */
      PAS__WRITE_CHAR(Ra.c[Rv1+15]);
      Rv1=Rv1-1;
    }
  }
  else {
    Ra.sl[3]=293; /* line # 293 */
    for( Rf0=F_f;Rf0>0;Rf0-- )
    PAS__WRITE_CHAR(42);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " write_int "  */
void PAS__WRITE_INT(SL F_iv, SL F_f, SL F_b){
  /* Define the automatic variable space. */
  Blk( Ra, 88 );

  /* Local variable stored in C variable */
  C Rv0;
  SL Rv1;
  UB Rv2;
  SL Rv3;
  SL Rv4;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+184;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=309; /* line # 309 */
  Rv0=32;
  Ra.sl[3]=310; /* line # 310 */
  if (F_iv==0) {
    Ra.sl[3]=312; /* line # 312 */
    Ra.c[16]=48;
    Rv1=1;
    Rv2=0;
  }
  else {
    Ra.sl[3]=316; /* line # 316 */
    Rv2=F_iv<0;
    Ra.sl[3]=317; /* line # 317 */
    if (F_b<2||F_b>16) F_b=10;
    Ra.sl[3]=318; /* line # 318 */
    Rv1=0;
    Ra.sl[3]=319; /* line # 319 */
    while (F_iv!=0){
      Ra.sl[3]=321; /* line # 321 */
      Rv1=Rv1+1;
      Ra.sl[3]=322; /* line # 322 */
      Rv3=abs(F_iv%F_b);
      Ra.sl[3]=323; /* line # 323 */
      if (Rv3>9) {
        Ra.sl[3]=324; /* line # 324 */
        Ra.c[Rv1+15]=(C)((Rv3+65)-10);
      }
      else {
        Ra.sl[3]=326; /* line # 326 */
        Ra.c[Rv1+15]=(C)(Rv3+48);
      }
      Ra.sl[3]=327; /* line # 327 */
      F_iv=F_iv/F_b;
    }
  }
  Ra.sl[3]=330; /* line # 330 */
  if (F_f==0) {
    Ra.sl[3]=331; /* line # 331 */
    F_f=Rv1+(SL)Rv2;
  }
  else {
    Ra.sl[3]=333; /* line # 333 */
    if (F_f<0) {
      Ra.sl[3]=335; /* line # 335 */
      Rv0=48;
      F_f= -F_f;
    }
  }
  Ra.sl[3]=337; /* line # 337 */
  Rv4=F_f-Rv1;
  Ra.sl[3]=338; /* line # 338 */
  if (Rv2) Rv4=Rv4-1;
  Ra.sl[3]=339; /* line # 339 */
  if (Rv4>=0) {
    Ra.sl[3]=341; /* line # 341 */
    if (Rv2&&Rv0==48) PAS__WRITE_CHAR(45);
    Ra.sl[3]=342; /* line # 342 */
    for( Rf0=Rv4;Rf0>0;Rf0-- )
    PAS__WRITE_CHAR(Rv0);
    Ra.sl[3]=343; /* line # 343 */
    if (Rv2&&Rv0==32) PAS__WRITE_CHAR(45);
    Ra.sl[3]=344; /* line # 344 */
    while (Rv1>0){
      Ra.sl[3]=346; /* line # 346 */
      PAS__WRITE_CHAR(Ra.c[Rv1+15]);
      Rv1=Rv1-1;
    }
  }
  else {
    Ra.sl[3]=350; /* line # 350 */
    for( Rf0=F_f;Rf0>0;Rf0-- )
    PAS__WRITE_CHAR(42);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " put_decimal "  */
void CPAS__RWNUM_put_decimal(G F_dv, SL F_ndig, SL F_pent, UB F_bneg){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;
  SL Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+195;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=369; /* line # 369 */
  Rv0=1;
  Ra.sl[3]=370; /* line # 370 */
  while (F_ndig>0){
    Ra.sl[3]=372; /* line # 372 */
    Rv1=(int)(F_dv*1.000000000000000E+001);
    Ra.sl[3]=373; /* line # 373 */
    F_dv=F_dv*1.000000000000000E+001-(double)Rv1;
    Ra.sl[3]=374; /* line # 374 */
    if (Rv0) {
      Ra.sl[3]=375; /* line # 375 */
      if (Rv1==0&&F_pent>1) {
        Ra.sl[3]=376; /* line # 376 */
        PAS__WRITE_CHAR(32);
      }
      else {
        Ra.sl[3]=379; /* line # 379 */
        Rv0=0;
        Ra.sl[3]=380; /* line # 380 */
        if (F_bneg) PAS__WRITE_CHAR(45);
      }
    }
    Ra.sl[3]=384; /* line # 384 */
    if (!Rv0) PAS__WRITE_CHAR((C)(Rv1+48));
    Ra.sl[3]=385; /* line # 385 */
    F_ndig=F_ndig-1;
    Ra.sl[3]=386; /* line # 386 */
    F_pent=F_pent-1;
    Ra.sl[3]=388; /* line # 388 */
    if (F_pent==0&&F_ndig>0) PAS__WRITE_CHAR(46);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " size_double "  */
void CPAS__RWNUM_size_double(G *F_dv, SL *F_iexp, UB *F_bneg, UB F_bfix){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  G Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+208;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=402; /* line # 402 */
  if ((*F_dv)<0.000000000000000E-001) {
    Ra.sl[3]=404; /* line # 404 */
    (*F_dv)=-(*F_dv);
    Ra.sl[3]=405; /* line # 405 */
    (*F_bneg)=1;
  }
  else {
    Ra.sl[3]=407; /* line # 407 */
    (*F_bneg)=0;
  }
  Ra.sl[3]=408; /* line # 408 */
  if ((*F_dv)>0.000000000000000E-001) {
    Ra.sl[3]=410; /* line # 410 */
    (*F_iexp)=0;
    Rv0=(*F_dv);
    Ra.sl[3]=411; /* line # 411 */
    if ((*F_dv)>0.000000000000000E-001) {
      Ra.sl[3]=412; /* line # 412 */
      if ((*F_dv)>=1.000000000000000E+000) {
        Ra.sl[3]=413; /* line # 413 */
        while (Rv0>1.000000000000000E+000){
          Rv0=Rv0/1.000000000000000E+001;
          (*F_iexp)=(*F_iexp)+1;
        }
      }
      else {
        Ra.sl[3]=415; /* line # 415 */
        while (Rv0<1.000000000000000E-001){
          Rv0=Rv0*1.000000000000000E+001;
          (*F_iexp)=(*F_iexp)-1;
        }
      }
    }
    Ra.sl[3]=422; /* line # 422 */
    if (Rv0>=1.000000000000000E+000) {
      Ra.sl[3]=424; /* line # 424 */
      Rv0=Rv0*1.000000000000000E-001;
      (*F_iexp)=(*F_iexp)+1;
    }
    else {
      Ra.sl[3]=427; /* line # 427 */
      if (Rv0<1.000000000000000E-001) {
        Ra.sl[3]=429; /* line # 429 */
        Rv0=Rv0*1.000000000000000E+001;
        (*F_iexp)=(*F_iexp)-1;
      }
    }
    Ra.sl[3]=431; /* line # 431 */
    if (F_bfix&&(*F_iexp)<=0) (*F_dv)=(*F_dv)*1.000000000000000E-001;
    else {
      Ra.sl[3]=432; /* line # 432 */
      (*F_dv)=Rv0;
    }
  }
  else {
    Ra.sl[3]=434; /* line # 434 */
    (*F_iexp)=0;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " pas__put_e_dble "  */
void P_pas__put_e_dble(G F_dv, SL F_fs, SL F_intsz, SL F_dcsz, SL F_es){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;
  SL Rv1;
  UB Rv2;
  C Rv3;
  SL Rv4;
  UB Rv5;
  SL Rv6;
  SL Rv7;
  SL Rv8;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+221;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=450; /* line # 450 */
  F_es=abs(F_es);
  Ra.sl[3]=452; /* line # 452 */
  if (F_dcsz==-1) F_dcsz=7;
  else F_dcsz=abs(F_dcsz);
  Ra.sl[3]=453; /* line # 453 */
  if (F_dcsz>20) F_dcsz=20;
  Ra.sl[3]=454; /* line # 454 */
  if (F_fs<0) {
    Rv0=1;
    F_fs=abs(F_fs);
  }
  else {
    Ra.sl[3]=455; /* line # 455 */
    Rv0=0;
  }
  Ra.sl[3]=456; /* line # 456 */
  if (F_fs==0) F_fs=22;
  Ra.sl[3]=457; /* line # 457 */
  if (F_intsz<1) F_intsz=1;
  Ra.sl[3]=459; /* line # 459 */
  CPAS__RWNUM_size_double(&F_dv, &Rv1, &Rv2,0);
  Ra.sl[3]=463; /* line # 463 */
  Rv1=Rv1-F_intsz;
  Ra.sl[3]=465; /* line # 465 */
  if (Rv1>=0) Rv3=43;
  else {
    Ra.sl[3]=468; /* line # 468 */
    Rv1= -Rv1;
    Rv3=45;
  }
  Ra.sl[3]=471; /* line # 471 */
  if (Rv1<10) Rv4=2;
  else {
    Ra.sl[3]=472; /* line # 472 */
    if (Rv1<100) Rv4=3;
    else Rv4=4;
  }
  Ra.sl[3]=474; /* line # 474 */
  if (Rv4>F_es) F_es=Rv4;
  Ra.sl[3]=476; /* line # 476 */
  Rv5=F_dcsz>0;
  Ra.sl[3]=477; /* line # 477 */
  Rv6=(((((F_fs-F_dcsz)-F_es)-F_intsz)-(SL)Rv2)-2)-(SL)Rv5;
  Ra.sl[3]=478; /* line # 478 */
  if (Rv6<0) {
    Ra.sl[3]=481; /* line # 481 */
    if (Rv6<0&&Rv3==43) {
      Ra.sl[3]=483; /* line # 483 */
      Rv6=Rv6+1;
      Rv3=32;
    }
    Ra.sl[3]=486; /* line # 486 */
    while (F_es>Rv4&&Rv6<0){
      Ra.sl[3]=488; /* line # 488 */
      F_es=F_es-1;
      Rv6=Rv6+1;
    }
    Ra.sl[3]=491; /* line # 491 */
    if (Rv6<0&&F_dcsz>0) {
      Ra.sl[3]=493; /* line # 493 */
      Rv7=Rv6+F_dcsz;
      Ra.sl[3]=494; /* line # 494 */
      if (Rv7>0) {
        Ra.sl[3]=496; /* line # 496 */
        F_dcsz=Rv7;
        Rv6=0;
      }
      else {
        Ra.sl[3]=499; /* line # 499 */
        if (Rv7==-1&&Rv5) {
          Ra.sl[3]=501; /* line # 501 */
          F_dcsz=0;
          Rv6=0;
          Ra.sl[3]=502; /* line # 502 */
          Rv5=0;
        }
      }
    }
  }
  Ra.sl[3]=507; /* line # 507 */
  Rv8=F_dcsz+F_intsz;
  Ra.sl[3]=508; /* line # 508 */
  F_dv=F_dv+5.000000000000000E-001*PAS__IGPOWER(1.000000000000000E+001, -Rv8);
  Ra.sl[3]=509; /* line # 509 */
  if (F_dv>=1.000000000000000E+000) {
    Ra.sl[3]=511; /* line # 511 */
    F_dv=F_dv*1.000000000000000E-001;
    Ra.sl[3]=512; /* line # 512 */
    if (Rv3==45) {
      Ra.sl[3]=514; /* line # 514 */
      Rv1=Rv1-1;
      Ra.sl[3]=515; /* line # 515 */
      if (Rv1==0) Rv3=43;
    }
    else {
      Ra.sl[3]=519; /* line # 519 */
      Rv1=Rv1+1;
      Ra.sl[3]=520; /* line # 520 */
      if (Rv1>=10) {
        Ra.sl[3]=522; /* line # 522 */
        if (Rv3==43) {
          Ra.sl[3]=524; /* line # 524 */
          Rv3=32;
          Rv6=Rv6+1;
        }
        Ra.sl[3]=526; /* line # 526 */
        if (Rv1==10&&F_es==1) {
          Ra.sl[3]=527; /* line # 527 */
          F_es=2;
          Rv6=Rv6-1;
        }
        else {
          Ra.sl[3]=529; /* line # 529 */
          if (Rv1==100&&F_es==2) {
            Ra.sl[3]=530; /* line # 530 */
            F_es=3;
            Rv6=Rv6-1;
          }
        }
      }
      Ra.sl[3]=533; /* line # 533 */
      if (Rv6<0) {
        Ra.sl[3]=535; /* line # 535 */
        if (Rv8>1) {
          Ra.sl[3]=537; /* line # 537 */
          Rv8=Rv8-1;
          Ra.sl[3]=538; /* line # 538 */
          if (F_intsz<=Rv8) {
            Ra.sl[3]=540; /* line # 540 */
            if (Rv8==F_intsz) {
              Ra.sl[3]=542; /* line # 542 */
              Rv5=0;
              Rv6=Rv6+1;
            }
          }
          else {
            Ra.sl[3]=547; /* line # 547 */
            F_intsz=F_intsz-1;
            Ra.sl[3]=548; /* line # 548 */
            Rv1=Rv1+1;
          }
          Ra.sl[3]=550; /* line # 550 */
          Rv6=Rv6+1;
        }
      }
    }
  }
  Ra.sl[3]=556; /* line # 556 */
  if (Rv6<0) {
    Ra.sl[3]=557; /* line # 557 */
    for( Rf0=F_fs;Rf0>0;Rf0-- )
    PAS__WRITE_CHAR(42);
  }
  else {
    Ra.sl[3]=560; /* line # 560 */
    if (Rv0) Rv6=0;
    Ra.sl[3]=561; /* line # 561 */
    if (Rv6>0) {
      Ra.sl[3]=562; /* line # 562 */
      for( Rf0=Rv6;Rf0>0;Rf0-- )
      PAS__WRITE_CHAR(32);
    }
    Ra.sl[3]=564; /* line # 564 */
    CPAS__RWNUM_put_decimal(F_dv, Rv8, F_intsz, Rv2);
    Ra.sl[3]=566; /* line # 566 */
    PAS__WRITE_CHAR(69);
    Ra.sl[3]=568; /* line # 568 */
    if (Rv3!=32) PAS__WRITE_CHAR(Rv3);
    Ra.sl[3]=570; /* line # 570 */
    PAS__WRITE_INT(Rv1, -F_es,10);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " pas__put_f_dble "  */
void P_pas__put_f_dble(G F_dv, SL F_fs, SL F_dcsz, SL F_dcmin){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  G Rv0;
  SL Rv1;
  UB Rv2;
  SL Rv3;
  UB Rv4;
  SL Rv5;
  SL Rv6;
  SL Rv7;
  SL Rv8;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+238;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=587; /* line # 587 */
  if (F_dcsz==-1) F_dcsz=7;
  else {
    Ra.sl[3]=588; /* line # 588 */
    F_dcsz=abs(F_dcsz);
  }
  Ra.sl[3]=589; /* line # 589 */
  if (F_dcsz>20) F_dcsz=20;
  Ra.sl[3]=590; /* line # 590 */
  if (F_fs<0) F_fs=abs(F_fs);
  Ra.sl[3]=591; /* line # 591 */
  if (F_fs==0) F_fs=20;
  Ra.sl[3]=592; /* line # 592 */
  if (F_dcmin<0) F_dcmin=abs(F_dcmin);
  Ra.sl[3]=595; /* line # 595 */
  Rv0=F_dv;
  Ra.sl[3]=596; /* line # 596 */
  CPAS__RWNUM_size_double(&Rv0, &Rv1, &Rv2,1);
  Ra.sl[3]=599; /* line # 599 */
  if (Rv1>1) Rv3=Rv1;
  else {
    Ra.sl[3]=600; /* line # 600 */
    Rv3=1;
  }
  Ra.sl[3]=601; /* line # 601 */
  Rv4=F_dcsz>0;
  Ra.sl[3]=604; /* line # 604 */
  Rv5=(((F_fs-(SL)Rv2)-F_dcsz)-Rv3)-(SL)Rv4;
  Ra.sl[3]=606; /* line # 606 */
  Rv6=F_dcsz+Rv1;
  Ra.sl[3]=607; /* line # 607 */
  Rv7=F_dcsz;
  Ra.sl[3]=608; /* line # 608 */
  if ((Rv1<=0&&Rv6<F_dcmin)&&F_dcmin>0) {
    Ra.sl[3]=610; /* line # 610 */
    Rv7= -Rv1+F_dcmin;
    Ra.sl[3]=611; /* line # 611 */
    Rv5=((F_fs-Rv7)-2)-(SL)Rv2;
    Ra.sl[3]=612; /* line # 612 */
    if (!Rv4&&Rv7>0) {
      Ra.sl[3]=613; /* line # 613 */
      Rv5=Rv5-1;
      Rv4=1;
    }
  }
  else {
    Ra.sl[3]=617; /* line # 617 */
    if (Rv5<0) {
      Ra.sl[3]=619; /* line # 619 */
      Rv6=Rv5+Rv7;
      Ra.sl[3]=620; /* line # 620 */
      if (Rv6>=0) {
        Ra.sl[3]=622; /* line # 622 */
        Rv7=Rv6;
        Ra.sl[3]=623; /* line # 623 */
        if (Rv7>0) Rv5=0;
        else {
          Ra.sl[3]=625; /* line # 625 */
          Rv4=0;
          Rv5=1;
        }
      }
      else {
        Ra.sl[3]=628; /* line # 628 */
        if (Rv6==-1&&Rv4) {
          Ra.sl[3]=630; /* line # 630 */
          Rv7=0;
          Rv5=0;
          Ra.sl[3]=631; /* line # 631 */
          Rv4=0;
        }
      }
    }
  }
  Ra.sl[3]=636; /* line # 636 */
  if (Rv5>=0) {
    Ra.sl[3]=638; /* line # 638 */
    Rv8=Rv3+Rv7;
    Ra.sl[3]=639; /* line # 639 */
    Rv0=Rv0+5.000000000000000E-001*PAS__IGPOWER(1.000000000000000E+001, -Rv8);
    Ra.sl[3]=640; /* line # 640 */
    if (Rv0>=1.000000000000000E+000) {
      Ra.sl[3]=642; /* line # 642 */
      Rv0=Rv0*1.000000000000000E-001;
      Ra.sl[3]=643; /* line # 643 */
      Rv3=Rv3+1;
      Ra.sl[3]=644; /* line # 644 */
      Rv5=Rv5-1;
      Rv8=Rv8+1;
    }
  }
  Ra.sl[3]=649; /* line # 649 */
  if (Rv5<0) {
    Ra.sl[3]=650; /* line # 650 */
    P_pas__put_e_dble(F_dv, F_fs,1, F_dcsz,0);
  }
  else {
    Ra.sl[3]=654; /* line # 654 */
    for( Rf0=Rv5;Rf0>0;Rf0-- )
    PAS__WRITE_CHAR(32);
    Ra.sl[3]=656; /* line # 656 */
    CPAS__RWNUM_put_decimal(Rv0, Rv8, Rv3, Rv2);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " write_except_number "  */
void CPAS__RWNUM_write_except_number(UB F_cl, SL F_f){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+255;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=664; /* line # 664 */
  switch (F_cl) {
    case 4:Ra.sl[3]=665; /* line # 665 */
    PAS__WRITE_STR(Rd.s+283,F_f,0,32);
    break;
    case 2:Ra.sl[3]=666; /* line # 666 */
    PAS__WRITE_STR(Rd.s+288,F_f,0,32);
    break;
    case 3:Ra.sl[3]=667; /* line # 667 */
    PAS__WRITE_STR(Rd.s+294,F_f,0,32);
    break;
    default:Ra.sl[3]=669; /* line # 669 */
    PAS__WRITE_STR(Rd.s+276,F_f,0,32);
    break;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " write_dble "  */
void PAS__WRITE_DBLE(G F_fl, SL F_f, SL F_d, SL F_e){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+300;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=681; /* line # 681 */
  Pas__Float_Trap();
  Ra.sl[3]=682; /* line # 682 */
  if (F_f==0) F_f=-22;
  Ra.sl[3]=683; /* line # 683 */
  Rv0=Pas__FpClassify_D(F_fl);
  Ra.sl[3]=684; /* line # 684 */
  if (1<<Rv0&28) {
    Ra.sl[3]=685; /* line # 685 */
    CPAS__RWNUM_write_except_number(Rv0, F_f);
    goto Ret_Label;
  }
  Ra.sl[3]=686; /* line # 686 */
  if (F_d<0||F_f<0) {
    Ra.sl[3]=687; /* line # 687 */
    P_pas__put_e_dble(F_fl, F_f,1, F_d,3);
  }
  else {
    Ra.sl[3]=688; /* line # 688 */
    P_pas__put_f_dble(F_fl, F_f, F_d, F_e);
  }
  Ret_Label: ;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " write_sngl "  */
void PAS__WRITE_SNGL(F F_fl, SL F_f, SL F_d, SL F_e){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+312;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=698; /* line # 698 */
  Pas__Float_Trap();
  Ra.sl[3]=699; /* line # 699 */
  if (F_f==0) F_f=-16;
  Ra.sl[3]=700; /* line # 700 */
  Rv0=Pas__FpClassify_F(F_fl);
  Ra.sl[3]=701; /* line # 701 */
  if (1<<Rv0&28) {
    Ra.sl[3]=702; /* line # 702 */
    CPAS__RWNUM_write_except_number(Rv0, F_f);
    goto Ret_Label;
  }
  Ra.sl[3]=703; /* line # 703 */
  if (F_d<0||F_f<0) {
    Ra.sl[3]=704; /* line # 704 */
    P_pas__put_e_dble((double)F_fl, F_f,1, F_d,2);
  }
  else {
    Ra.sl[3]=705; /* line # 705 */
    P_pas__put_f_dble((double)F_fl, F_f, F_d, F_e);
  }
  Ret_Label: ;
  PAS__curr_cntx=Ra.v[0];
}
