/*
*************************************************************************
*                                                                       *
*                                                                       *
*                   *  C P A S  *  S Y S T E M  *                       *
*                                                                       *
*                                                                       *
*          * * *   S t a n d a r d   L i b r a r y   * * *              *
*                                                                       *
*                                                                       *
*                     ---  RUN-TIME KERNEL  ---                         *
*               ---  C Library Link Definitions  ---                    *
*               --- Version  3.1-B5 - 31-07-2019 ---                    *
*                                                                       *
*         by :                                                          *
*                                                                       *
*             P. Wolfers                                                *
*                 www.pierre.wolfers.fr                                 *
*                                             FRANCE.                   *
*                                                                       *
*************************************************************************


/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////

*/



#include <fenv.h>
#include <math.h>



int CC__FloatClassify_D( double vl )
{
    int cl = fpclassify( vl );
#if defined( __WIN32 )&&!( __CYGWIN__ )
    // Use some if to do not allocate a too large switch table ...
    // ... because FP_NAN is 0x0100, FP_NORMAL is 0x400, ...
    // ... FP_INFINITE is 0x0500 == FP_NAN | FP_NORMAL, ...
    // ... FP_ZERO is 0x4000 and FP_SUBNORMAL is 0x4400 == FP_ZERO | FP_NORMAL.
    if (cl == FP_NAN) return 4;
    if (cl == FP_INFINITE) return (isinf( vl ) < 0)? 3: 2; // FP_INFINITE
    if (cl == FP_SUBNORMAL) return 1; // FP_SUBNORMAL = FP_NORMAL | FP_ZERO
    if (cl & FP_SUBNORMAL) return 0;
#else
    switch (cl) {
        case FP_NAN: return 4;
        case FP_INFINITE: return (isinf( vl )<0)? 3 : 2;
        case FP_SUBNORMAL: return 1;
        case FP_NORMAL: case FP_ZERO: return 0;
    }
#endif
} // int CC__FloatClassify_D( double vl ).


int CC__FloatClassify_F( float vl )
{
    int cl = fpclassify( vl );
#if defined( __WIN32 )&&!( __CYGWIN__ )
    // Use some if to do not allocate a large switch table.
    if (cl == FP_NAN) return 4;
    if (cl == FP_INFINITE) return (isinf( vl ) < 0)? 3: 2;
    if (cl == FP_SUBNORMAL) return 1;
    if (cl & FP_SUBNORMAL) return 0;
#else
    switch (cl) {
        case FP_NAN: return 4;
        case FP_INFINITE: return (isinf( vl )<0)? 3 : 2;
        case FP_SUBNORMAL: return 1;
        case FP_NORMAL: case FP_ZERO: return 0;
    }
#endif
} // int CC__FloatClassify_D( single vl ).


int CC__GetFloatExcept()
{
    int ret = 0,
        exr = 0;

    exr = fetestexcept( FE_ALL_EXCEPT );
    if (FE_INEXACT   & exr) ret =   1;
    if (FE_DIVBYZERO & exr) ret |=  2;
    if (FE_OVERFLOW  & exr) ret |=  4;
    if (FE_INVALID   & exr) ret |=  8;
    if (FE_UNDERFLOW & exr) ret |= 16;
    feclearexcept( FE_ALL_EXCEPT );
    return ret;
} // int CC__GetFloatExcept().


