/*  P A S - P. WOLFERS SOFTWARE: V3.1-B4 OF 30-SEP-2016 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long long int

/* Include the PAS environment file. */
#include <cpas_defs.h>

/* Define the local data section. */
static Blk( Rd, 456 ) = {
 10,  10, 109,  97, 106, 111, 114,  95,  99, 104,  97, 114,  63,  63,  47, 104,
111, 109, 101,  47, 112, 105, 101, 114, 114, 101,  47,  83, 111, 102, 116,  47,
 99, 112, 115, 104,  95, 107, 105, 116, 115,  47,  99, 112,  97, 115,  99,  97,
108,  95, 115, 114,  99,  95,  86,  51,  46,  50,  65,  49,  47,  99, 112,  97,
115,  95,  95, 115, 116, 114, 105, 110, 103,  46, 112,  97, 115,  10,  10, 109,
105, 110, 111, 114,  95,  99, 104,  97, 114,  11,  11,  99, 104,  97, 114,  95,
105, 110,  95, 115, 116, 114,   7,   7,  99, 104,  97,  95,  99, 112, 121,  10,
 10,  99, 104, 116,  95, 116, 111,  95,  99, 104, 116,  10,  10,  99, 104, 116,
 95, 116, 111,  95, 115, 116, 114,   7,   7, 115, 116, 114,  95,  99, 112, 121,
  8,   8, 115, 101, 116,  95,  99,  97, 115, 101,   9,   9,  99, 111, 110,  99,
 97, 116,  95,  99,  99,   9,   9,  99, 111, 110,  99,  97, 116,  95, 115,  99,
  9,   9,  99, 111, 110,  99,  97, 116,  95,  99, 115,   9,   9,  99, 111, 110,
 99,  97, 116,  95, 115, 115,   9,   9,  99, 111, 110,  99,  97, 116,  95, 116,
 99,   9,   9,  99, 111, 110,  99,  97, 116,  95,  99, 116,   9,   9,  99, 111,
110,  99,  97, 116,  95, 115, 116,   9,   9,  99, 111, 110,  99,  97, 116,  95,
116, 115,   9,   9,  99, 111, 110,  99,  97, 116,  95, 116, 116,   6,   6, 115,
117,  98, 115, 116, 114,   6,   6, 115, 117,  98, 115, 116, 114,   9,   9, 105,
110, 100, 101, 120,  95,  99, 104,  97,   9,   9, 105, 110, 100, 101, 120,  95,
115, 116, 114,  10,  10, 110, 105, 110, 100, 101, 120,  95,  99, 104,  97,  10,
 10, 110, 105, 110, 100, 101, 120,  95, 115, 116, 114,   7,   7, 115, 116, 114,
 95, 108, 101, 110,   9,   9, 115, 116, 114,  95, 109,  97, 116,  99, 104,   9,
  9,  99, 104, 116,  95, 109,  97, 116,  99, 104,  17,  17, 115, 116, 114, 105,
110, 103,  95, 108, 111,  99,  97, 116, 101,  95, 115, 101, 112,   6,   6, 115,
116, 114,  95, 108, 116,   6,   6, 115, 116, 114,  95, 108, 101,   6,   6, 115,
116, 114,  95, 103, 101,   6,   6, 115, 116, 114,  95, 103, 116,   6,   6, 115,
116, 114,  95, 101, 113,   6,   6, 115, 116, 114,  95, 110, 101,   6,   6, 115,
116, 114,  95, 108, 101,   6,   6, 115, 116, 114,  95, 103, 101,   6,   6, 115,
116, 114,  95, 103, 116,   6,   6, 115, 116, 114,  95, 101, 113,   6,   6, 115,
116, 114,  95, 110, 101,   0,   0,   0
};




/* Procedure/Function : " major_char "  */
C PAS__MAJOR_CHAR(C F_ch){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  register C Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=68; /* line # 68 */
  if (F_ch>=97&&F_ch<=122) Ret=(C)((SL)F_ch-32);
  else Ret=F_ch;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " minor_char "  */
C PAS__MINOR_CHAR(C F_ch){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  register C Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+77;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=76; /* line # 76 */
  if (F_ch>=65&&F_ch<=90) Ret=(C)((SL)F_ch+32);
  else Ret=F_ch;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " char_in_str "  */
V PAS__CHAR_IN_STR(V Ret, C F_ch){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  ((UB *)Ret)[0]=1;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+89;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=84; /* line # 84 */
  ((C *)Ret)[2]=F_ch;
  ((UB *)Ret)[1]=1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " cha_cpy "  */
void PAS__CHA_TO_STR(V F_dst, C F_ch){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+102;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=95; /* line # 95 */
  ((UB *)F_dst)[1]=1;
  ((C *)F_dst)[2]=F_ch;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " cht_to_cht "  */
void PAS__CHT_TO_CHT(V F_dst, SL F_sd, V F_src, SL F_ss){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;
  SL Rv1;
  SL Rv2;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+111;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=107; /* line # 107 */
  if (F_ss>F_sd) Rv0=F_sd;
  else Rv0=F_ss;
  Rv1=1;
  for( Rf0=Rv0;Rf0>0;Rf0-- ) {
    ((C *)F_dst)[Rv1-1]=((C *)F_src)[Rv1-1];
    Rv1++;
  }
  if (F_ss<F_sd) {
    Rv2=Rv0+1;
    for( Rf0=(F_sd+1)-(Rv0+1);Rf0>0;Rf0-- ) {
      ((C *)F_dst)[Rv2-1]=32;
      Rv2++;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " cht_to_str "  */
void PAS__CHT_TO_STR(V F_dst, V F_src, SL F_sz){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;
  SL Rv1;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+123;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=122; /* line # 122 */
  if (F_sz>((UB *)F_dst)[0]) Rv0=((UB *)F_dst)[0];
  else Rv0=F_sz;
  ((UB *)F_dst)[1]=Rv0;
  Ra.sl[3]=127; /* line # 127 */
  Rv1=1;
  for( Rf0=Rv0;Rf0>0;Rf0-- ) {
    ((C *)F_dst)[Rv1+1]=((C *)F_src)[Rv1-1];
    Rv1++;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " str_cpy "  */
void PAS__STR_TO_STR(V F_dst, V F_src){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  UB Rv1;
  SL Rv2;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+135;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=138; /* line # 138 */
  if (F_src!=F_dst&&F_dst!=NULL) {
    Rv0=F_dst;
    if (F_src!=NULL) {
      Rv1=((UB *)F_src)[1];
      Ra.sl[3]=143; /* line # 143 */
      if (Rv1>((UB *)Rv0)[0]) Rv1=((UB *)Rv0)[0];
      ((UB *)Rv0)[1]=Rv1;
      Rv2=1;
      for( Rf0=Rv1;Rf0>0;Rf0-- ) {
        ((C *)Rv0)[Rv2+1]=((C *)F_src)[Rv2+1];
        Rv2++;
      }
    }
    else((UB *)Rv0)[1]=0;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " set_case "  */
void PAS__SET_CASE(V F_s, UB F_maj){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+144;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=154; /* line # 154 */
  if (F_maj) {
    Rv0=1;
    for( Rf0=((UB *)F_s)[1];Rf0>0;Rf0-- ) {
      if (((C *)F_s)[Rv0+1]>=97&&((C *)F_s)[Rv0+1]<=122) ((C *)F_s)[Rv0+1]=(C)((
      SL)((C *)F_s)[Rv0+1]-32);
      Rv0++;
    }
  }
  else {
    Ra.sl[3]=161; /* line # 161 */
    Rv1=1;
    for( Rf0=((UB *)F_s)[1];Rf0>0;Rf0-- ) {
      if (((C *)F_s)[Rv1+1]>=65&&((C *)F_s)[Rv1+1]<=90) ((C *)F_s)[Rv1+1]=(C)((SL)
      ((C *)F_s)[Rv1+1]+32);
      Rv1++;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " concat_cc "  */
V PAS__CON_CHA_CHA(V Ret, C F_c1, C F_c2){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  ((UB *)Ret)[0]=2;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+154;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=170; /* line # 170 */
  ((UB *)Ret)[1]=2;
  ((C *)Ret)[2]=F_c1;
  ((C *)Ret)[3]=F_c2;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " concat_sc "  */
V PAS__CON_STR_CHA(V Ret, V F_s1, C F_c2){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  register int Rf0;

  /* Code of procedure/function */
  ((UB *)Ret)[0]=255;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+165;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=182; /* line # 182 */
  Rv0=((UB *)F_s1)[1];
  if (Rv0>=((UB *)Ret)[0]) Rv0=((UB *)Ret)[0]-1;
  Rv1=1;
  for( Rf0=Rv0;Rf0>0;Rf0-- ) {
    ((C *)Ret)[Rv1+1]=((C *)F_s1)[Rv1+1];
    Rv1++;
  }
  ((C *)Ret)[(Rv0+1)+1]=F_c2;
  ((UB *)Ret)[1]=Rv0+1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " concat_cs "  */
V PAS__CON_CHA_STR(V Ret, C F_c1, V F_s2){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  register int Rf0;

  /* Code of procedure/function */
  ((UB *)Ret)[0]=255;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+176;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=197; /* line # 197 */
  Rv0=((UB *)F_s2)[1];
  if (Rv0>=((UB *)Ret)[0]) Rv0=((UB *)Ret)[0]-1;
  ((C *)Ret)[2]=F_c1;
  Rv1=1;
  for( Rf0=Rv0;Rf0>0;Rf0-- ) {
    ((C *)Ret)[(Rv1+1)+1]=((C *)F_s2)[Rv1+1];
    Rv1++;
  }
  ((UB *)Ret)[1]=Rv0+1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " concat_ss "  */
V PAS__CON_STR_STR(V Ret, V F_s1, V F_s2){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  register int Rf0;

  /* Code of procedure/function */
  ((UB *)Ret)[0]=255;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+187;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=211; /* line # 211 */
  if (((UB *)F_s1)[1]>((UB *)Ret)[0]) Rv0=((UB *)Ret)[0];
  else Rv0=((UB *)F_s1)[1];
  Rv1=1;
  for( Rf0=Rv0;Rf0>0;Rf0-- ) {
    ((C *)Ret)[Rv1+1]=((C *)F_s1)[Rv1+1];
    Rv1++;
  }
  Rv2=((UB *)Ret)[0]-Rv0;
  if (Rv2>((UB *)F_s2)[1]) Rv2=((UB *)F_s2)[1];
  Ra.sl[3]=216; /* line # 216 */
  Rv3=1;
  for( Rf0=Rv2;Rf0>0;Rf0-- ) {
    Rv0=Rv0+1;
    ((C *)Ret)[Rv0+1]=((C *)F_s2)[Rv3+1];
    Rv3++;
  }
  Ra.sl[3]=221; /* line # 221 */
  ((UB *)Ret)[1]=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " concat_tc "  */
V PAS__CON_CHT_CHA(V Ret, V F_s1, SL F_l1, C F_c2){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  register int Rf0;

  /* Code of procedure/function */
  ((UB *)Ret)[0]=255;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+198;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=232; /* line # 232 */
  Rv0=((UB *)Ret)[0];
  if (F_l1>=((UB *)Ret)[0]) {
    Rv1=1;
    for( Rf0=Rv0;Rf0>0;Rf0-- ) {
      ((C *)Ret)[Rv1+1]=((C *)F_s1)[Rv1-1];
      Rv1++;
    }
    ((UB *)Ret)[1]=Rv0;
  }
  else {
    Ra.sl[3]=240; /* line # 240 */
    Rv2=1;
    for( Rf0=F_l1;Rf0>0;Rf0-- ) {
      ((C *)Ret)[Rv2+1]=((C *)F_s1)[Rv2-1];
      Rv2++;
    }
    ((C *)Ret)[(F_l1+1)+1]=F_c2;
    ((UB *)Ret)[1]=F_l1+1;
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " concat_ct "  */
V PAS__CON_CHA_CHT(V Ret, C F_c1, V F_s2, SL F_l2){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  register int Rf0;

  /* Code of procedure/function */
  ((UB *)Ret)[0]=255;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+209;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=254; /* line # 254 */
  Rv0=F_l2;
  if (Rv0>=((UB *)Ret)[0]) Rv0=((UB *)Ret)[0]-1;
  ((C *)Ret)[2]=F_c1;
  Rv1=1;
  for( Rf0=Rv0;Rf0>0;Rf0-- ) {
    ((C *)Ret)[(Rv1+1)+1]=((C *)F_s2)[Rv1-1];
    Rv1++;
  }
  ((UB *)Ret)[1]=Rv0+1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " concat_st "  */
V PAS__CON_STR_CHT(V Ret, V F_s1, V F_s2, SL F_l2){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  register int Rf0;

  /* Code of procedure/function */
  ((UB *)Ret)[0]=255;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+220;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=269; /* line # 269 */
  if (((UB *)F_s1)[1]>((UB *)Ret)[0]) Rv0=((UB *)Ret)[0];
  else Rv0=((UB *)F_s1)[1];
  Rv1=1;
  for( Rf0=Rv0;Rf0>0;Rf0-- ) {
    ((C *)Ret)[Rv1+1]=((C *)F_s1)[Rv1+1];
    Rv1++;
  }
  Rv2=((UB *)Ret)[0]-Rv0;
  if (Rv2>F_l2) Rv2=F_l2;
  Ra.sl[3]=274; /* line # 274 */
  Rv3=1;
  for( Rf0=Rv2;Rf0>0;Rf0-- ) {
    Rv0=Rv0+1;
    ((C *)Ret)[Rv0+1]=((C *)F_s2)[Rv3-1];
    Rv3++;
  }
  Ra.sl[3]=279; /* line # 279 */
  ((UB *)Ret)[1]=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " concat_ts "  */
V PAS__CON_CHT_STR(V Ret, V F_s1, SL F_l1, V F_s2){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  register int Rf0;

  /* Code of procedure/function */
  ((UB *)Ret)[0]=255;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+231;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=290; /* line # 290 */
  if (F_l1>((UB *)Ret)[0]) Rv0=((UB *)Ret)[0];
  else Rv0=F_l1;
  Rv1=1;
  for( Rf0=Rv0;Rf0>0;Rf0-- ) {
    ((C *)Ret)[Rv1+1]=((C *)F_s1)[Rv1-1];
    Rv1++;
  }
  Rv2=((UB *)Ret)[0]-Rv0;
  if (Rv2>((UB *)F_s2)[1]) Rv2=((UB *)F_s2)[1];
  Ra.sl[3]=295; /* line # 295 */
  Rv3=1;
  for( Rf0=Rv2;Rf0>0;Rf0-- ) {
    Rv0=Rv0+1;
    ((C *)Ret)[Rv0+1]=((C *)F_s2)[Rv3+1];
    Rv3++;
  }
  Ra.sl[3]=300; /* line # 300 */
  ((UB *)Ret)[1]=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " concat_tt "  */
V PAS__CON_CHT_CHT(V Ret, V F_s1, SL F_l1, V F_s2, SL F_l2){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  register int Rf0;

  /* Code of procedure/function */
  ((UB *)Ret)[0]=255;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+242;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=311; /* line # 311 */
  if (F_l1>((UB *)Ret)[0]) Rv0=((UB *)Ret)[0];
  else Rv0=F_l1;
  Rv1=1;
  for( Rf0=Rv0;Rf0>0;Rf0-- ) {
    ((C *)Ret)[Rv1+1]=((C *)F_s1)[Rv1-1];
    Rv1++;
  }
  Rv2=((UB *)Ret)[0]-Rv0;
  if (Rv2>F_l2) Rv2=F_l2;
  Ra.sl[3]=316; /* line # 316 */
  Rv3=1;
  for( Rf0=Rv2;Rf0>0;Rf0-- ) {
    Rv0=Rv0+1;
    ((C *)Ret)[Rv0+1]=((C *)F_s2)[Rv3-1];
    Rv3++;
  }
  Ra.sl[3]=321; /* line # 321 */
  ((UB *)Ret)[1]=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " substr "  */
V PAS__SUBSTR_STR(V Ret, V F_s, SL F_i, SL F_j){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  register int Rf0;

  /* Code of procedure/function */
  ((UB *)Ret)[0]=255;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+253;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=331; /* line # 331 */
  if (F_i<1) F_i=1;
  else {
    if (F_i>((UB *)F_s)[1]) {
      F_j=0;
      goto L_l_0;
    }
  }
  if (F_j<=0) F_j=(((UB *)F_s)[1]-F_i)+1;
  else {
    Ra.sl[3]=336; /* line # 336 */
    if ((F_j+F_i)-1>((UB *)F_s)[1]) F_j=(((UB *)F_s)[1]-F_i)+1;
  }
  if (F_j>((UB *)Ret)[0]) F_j=((UB *)Ret)[0];
  Rv0=1;
  for( Rf0=F_j;Rf0>0;Rf0-- ) {
    ((C *)Ret)[Rv0+1]=((C *)F_s)[((Rv0+F_i)-1)+1];
    Rv0++;
  }
L_l_0:
  Ra.sl[3]=342; /* line # 342 */
  ((UB *)Ret)[1]=F_j;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " substr "  */
V PAS__SUBSTR_CHT(V Ret, V F_s, SL F_sz, SL F_i, SL F_j){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  register int Rf0;

  /* Code of procedure/function */
  ((UB *)Ret)[0]=255;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+261;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=351; /* line # 351 */
  if (F_i<1) F_i=1;
  else {
    if (F_i>F_sz) {
      F_j=0;
      goto L_l_0;
    }
  }
  if (F_j<=0) F_j=(F_sz-F_i)+1;
  else {
    Ra.sl[3]=356; /* line # 356 */
    if ((F_j+F_i)-1>F_sz) F_j=(F_sz-F_i)+1;
  }
  if (F_j>((UB *)Ret)[0]) F_j=((UB *)Ret)[0];
  Rv0=1;
  for( Rf0=F_j;Rf0>0;Rf0-- ) {
    ((C *)Ret)[Rv0+1]=((C *)F_s)[((Rv0+F_i)-1)-1];
    Rv0++;
  }
L_l_0:
  Ra.sl[3]=362; /* line # 362 */
  ((UB *)Ret)[1]=F_j;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " index_cha "  */
SL PAS__INDEX_CHA(V F_s1, SL F_l1, C F_ch){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  UB Rv1;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+269;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=375; /* line # 375 */
  Rv0=0;
  Rv1=0;
  while (Rv0<F_l1&&!Rv1){
    Rv0=Rv0+1;
    Ra.sl[3]=380; /* line # 380 */
    Rv1=F_ch==((C *)F_s1)[Rv0-1];
  }
  if (!Rv1) Rv0=0;
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " index_str "  */
SL PAS__INDEX_STR(V F_s1, SL F_l1, V F_s2, SL F_l2){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  UB Rv1;
  C Rv2;
  SL Rv3;
  SL Rv4;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+280;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=396; /* line # 396 */
  if (F_s1==F_s2) Rv0=1;
  else {
    Rv1=0;
    Rv0=0;
    Ra.sl[3]=401; /* line # 401 */
    if (F_l2>0&&F_l1>=F_l2) {
      Rv2=((C *)F_s2)[0];
      while (Rv0<=F_l1-F_l2&&!Rv1){
        Ra.sl[3]=406; /* line # 406 */
        Rv0=Rv0+1;
        if (Rv2==((C *)F_s1)[Rv0-1]) {
          Rv3=Rv0+1;
          Rv4=2;
          Ra.sl[3]=411; /* line # 411 */
          while (Rv4<=F_l2&&((C *)F_s1)[Rv3-1]==((C *)F_s2)[Rv4-1]){
            Rv4=Rv4+1;
            Rv3=Rv3+1;
          }
          Ra.sl[3]=416; /* line # 416 */
          Rv1=Rv4>F_l2;
        }
      }
    }
    if (!Rv1) Rv0=0;
  }
  Ra.sl[3]=422; /* line # 422 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " nindex_cha "  */
SL PAS__NINDEX_CHA(V F_s, SL F_l, C F_c, SL F_nb, SL F_ip, UB F_nc){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;
  C Rv1;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+291;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=438; /* line # 438 */
  Rv0=0;
  if (F_nb==0) F_nb=1;
  if (!F_nc) F_c=PAS__MAJOR_CHAR(F_c);
  if (F_l>0) {
    if (F_nb>0) {
      Ra.sl[3]=444; /* line # 444 */
      if (F_ip<=0) F_ip=1;
      while (F_ip<=F_l&&!Rv0){
        if (F_nc) Rv1=((C *)F_s)[F_ip-1];
        else Rv1=PAS__MAJOR_CHAR(((C *)F_s)[F_ip-1]);
        Ra.sl[3]=449; /* line # 449 */
        if (F_c==Rv1) {
          F_nb=F_nb -1;
          Rv0=F_nb==0;
        }
        Ra.sl[3]=454; /* line # 454 */
        if (!Rv0) F_ip=F_ip+1;
      }
    }
    else {
      Ra.sl[3]=459; /* line # 459 */
      F_nb= -F_nb;
      if (F_ip<0||F_ip>F_l) F_ip=F_l;
      while (F_ip>1&&!Rv0){
        if (F_nc) Rv1=((C *)F_s)[F_ip-1];
        else {
          Ra.sl[3]=464; /* line # 464 */
          Rv1=PAS__MAJOR_CHAR(((C *)F_s)[F_ip-1]);
        }
        if (F_c==Rv1) {
          F_nb=F_nb -1;
          Rv0=F_nb==0;
        }
        Ra.sl[3]=470; /* line # 470 */
        if (!Rv0) F_ip=F_ip-1;
      }
    }
  }
  if (!Rv0) F_ip=0;
  Ra.sl[3]=475; /* line # 475 */
  Ret=F_ip;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " nindex_str "  */
SL PAS__NINDEX_STR(V F_s1, SL F_l1, V F_s2, SL F_l2, SL F_nb, SL F_ip, UB F_nc){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;
  SL Rv1;
  C Rv2;
  C Rv3;
  SL Rv4;
  SL Rv5;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+303;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=492; /* line # 492 */
  Rv0=0;
  if (F_nb==0) F_nb=1;
  if (F_l2>0&&F_l1>=F_l2) {
    Rv1=(F_l1-F_l2)+1;
    Ra.sl[3]=497; /* line # 497 */
    if (F_nb>0) {
      if (F_ip<=0) F_ip=1;
      if (F_nc) Rv2=((C *)F_s2)[0];
      else Rv2=PAS__MAJOR_CHAR(((C *)F_s2)[0]);
      Ra.sl[3]=502; /* line # 502 */
      while (F_ip<=Rv1&&!Rv0){
        if (F_nc) Rv3=((C *)F_s1)[F_ip-1];
        else Rv3=PAS__MAJOR_CHAR(((C *)F_s1)[F_ip-1]);
        if (Rv2==Rv3) {
          Ra.sl[3]=508; /* line # 508 */
          Rv4=F_ip+1;
          Rv5=2;
          Rv0=1;
          while (Rv5<=F_l2&&Rv0){
            Ra.sl[3]=513; /* line # 513 */
            if (F_nc) Rv0=((C *)F_s1)[Rv4-1]==((C *)F_s2)[Rv5-1];
            else Rv0=PAS__MAJOR_CHAR(((C *)F_s1)[Rv4-1])==PAS__MAJOR_CHAR(((C *)
            F_s2)[Rv5-1]);
            Rv4=Rv4+1;
            Rv5=Rv5+1;
          }
          if (Rv0) {
            F_nb=F_nb -1;
            Rv0=F_nb==0;
          }
        }
        Ra.sl[3]=519; /* line # 519 */
        if (!Rv0) F_ip=F_ip+1;
      }
    }
    else {
      Ra.sl[3]=524; /* line # 524 */
      F_nb= -F_nb;
      if (F_ip<0||F_ip>Rv1) F_ip=Rv1;
      if (F_nc) Rv2=((C *)F_s2)[0];
      else Rv2=PAS__MAJOR_CHAR(((C *)F_s2)[0]);
      while (F_ip>0&&!Rv0){
        Ra.sl[3]=530; /* line # 530 */
        if (F_nc) Rv3=((C *)F_s1)[F_ip-1];
        else Rv3=PAS__MAJOR_CHAR(((C *)F_s1)[F_ip-1]);
        if (Rv2==Rv3) {
          Rv4=F_ip+1;
          Ra.sl[3]=535; /* line # 535 */
          Rv5=2;
          Rv0=1;
          while (Rv5<=F_l2&&Rv0){
            if (F_nc) Rv0=((C *)F_s1)[Rv4-1]==((C *)F_s2)[Rv5-1];
            else {
              Ra.sl[3]=540; /* line # 540 */
              Rv0=PAS__MAJOR_CHAR(((C *)F_s1)[Rv4-1])==PAS__MAJOR_CHAR(((C *)F_s2)
              [Rv5-1]);
            }
            Rv4=Rv4+1;
            Rv5=Rv5+1;
          }
          if (Rv0) {
            F_nb=F_nb -1;
            Rv0=F_nb==0;
          }
        }
        Ra.sl[3]=545; /* line # 545 */
        if (!Rv0) F_ip=F_ip-1;
      }
    }
  }
  if (!Rv0) F_ip=0;
  Ra.sl[3]=550; /* line # 550 */
  Ret=F_ip;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " str_len "  */
SL PAS__LENGTH_STR(V F_s){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+315;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=558; /* line # 558 */
  Ret=((UB *)F_s)[1];
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " str_match "  */
SL PAS__MATCH_STR(V F_s1, V F_s2){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+324;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=569; /* line # 569 */
  if (((UB *)F_s1)[1]<((UB *)F_s2)[1]) Rv0=((UB *)F_s1)[1];
  else Rv0=((UB *)F_s2)[1];
  Rv1=1;
  while (Rv1<=Rv0&&((C *)F_s1)[Rv1+1]==((C *)F_s2)[Rv1+1])
  Rv1=Rv1+1;
  if (Rv1>Rv0) {
    Ra.sl[3]=574; /* line # 574 */
    Rv2=((UB *)F_s1)[1]-((UB *)F_s2)[1];
  }
  else Rv2=(SL)((C *)F_s1)[Rv1+1]-(SL)((C *)F_s2)[Rv1+1];
  Ret=Rv2;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " cht_match "  */
SL PAS__MATCH_CHT(V F_s1, SL F_cap1, SL F_l1, V F_s2, SL F_cap2, SL F_l2){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+335;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=590; /* line # 590 */
  if (F_l1<=0) F_l1=F_cap1;
  if (F_l2<=0) F_l2=F_cap2;
  if (F_l1<F_l2) Rv0=11;
  else Rv0=F_l2;
  Rv1=1;
  Ra.sl[3]=595; /* line # 595 */
  while (Rv1<=Rv0&&((C *)F_s1)[Rv1-1]==((C *)F_s2)[Rv1-1])
  Rv1=Rv1+1;
  if (Rv1>Rv0) Rv2=F_l1-F_l2;
  else Rv2=(SL)((C *)F_s1)[Rv1-1]-(SL)((C *)F_s2)[Rv1-1];
  Ra.sl[3]=600; /* line # 600 */
  Ret=Rv2;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " string_locate_sep "  */
void PAS__STR_LSEP(V F_st, SL F_l, V F_sp, SL F_n, V F_tp, SL F_nsp, SL *F_ie){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+346;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=614; /* line # 614 */
  (*F_ie)=0;
  Rv0=1;
  for( Rf0=F_l;Rf0>0;Rf0-- ) {
    Rv1=1;
    while (Rv1<=F_n&&((C *)F_sp)[Rv1-1]!=((C *)F_st)[Rv0-1])
    Rv1=Rv1+1;
    Ra.sl[3]=619; /* line # 619 */
    if (Rv1<=F_n) {
      (*F_ie)=(*F_ie)+1;
      if ((*F_ie)>=F_nsp) {
        (*F_ie)= -((*F_ie) -1);
        goto L_l_0;
      }
      ((UB *)F_tp)[(*F_ie)-1]=Rv1;
      (*F_ie)=(*F_ie)+1;
      ((UB *)F_tp)[(*F_ie)-1]=Rv0;
    }
    Rv0++;
  }
L_l_0:
  Ra.sl[3]=627; /* line # 627 */
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " str_lt "  */
UB PAS__LT_CHT(V F_s1, SL F_l1, V F_s2, SL F_l2){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+365;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=635; /* line # 635 */
  Ret=PAS__MATCH_CHT(F_s1,F_l1, F_l1, F_s2,F_l2, F_l2)<0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " str_le "  */
UB PAS__LE_CHT(V F_s1, SL F_l1, V F_s2, SL F_l2){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+373;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=642; /* line # 642 */
  Ret=PAS__MATCH_CHT(F_s1,F_l1, F_l1, F_s2,F_l2, F_l2)<=0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " str_ge "  */
UB PAS__GE_CHT(V F_s1, SL F_l1, V F_s2, SL F_l2){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+381;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=649; /* line # 649 */
  Ret=PAS__MATCH_CHT(F_s1,F_l1, F_l1, F_s2,F_l2, F_l2)>=0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " str_gt "  */
UB PAS__GT_CHT(V F_s1, SL F_l1, V F_s2, SL F_l2){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+389;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=656; /* line # 656 */
  Ret=PAS__MATCH_CHT(F_s1,F_l1, F_l1, F_s2,F_l2, F_l2)>0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " str_eq "  */
UB PAS__EQ_CHT(V F_s1, SL F_l1, V F_s2, SL F_l2){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+397;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=663; /* line # 663 */
  Ret=PAS__MATCH_CHT(F_s1,F_l1, F_l1, F_s2,F_l2, F_l2)==0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " str_ne "  */
UB PAS__NE_CHT(V F_s1, SL F_l1, V F_s2, SL F_l2){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+405;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=670; /* line # 670 */
  Ret=PAS__MATCH_CHT(F_s1,F_l1, F_l1, F_s2,F_l2, F_l2)!=0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " str_le "  */
UB PAS__LE_STR(V F_s1, V F_s2){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+413;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=675; /* line # 675 */
  Ret=PAS__MATCH_STR(F_s1,F_s2)<=0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " str_ge "  */
UB PAS__GE_STR(V F_s1, V F_s2){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+421;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=680; /* line # 680 */
  Ret=PAS__MATCH_STR(F_s1,F_s2)>=0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " str_gt "  */
UB PAS__GT_STR(V F_s1, V F_s2){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+429;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=685; /* line # 685 */
  Ret=PAS__MATCH_STR(F_s1,F_s2)>0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " str_eq "  */
UB PAS__EQ_STR(V F_s1, V F_s2){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+437;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=690; /* line # 690 */
  Ret=PAS__MATCH_STR(F_s1,F_s2)==0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " str_ne "  */
UB PAS__NE_STR(V F_s1, V F_s2){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+445;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=695; /* line # 695 */
  Ret=PAS__MATCH_STR(F_s1,F_s2)!=0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}
