/*
*************************************************************************
*                                                                       *
*                                                                       *
*                   *  C P A S  *  S Y S T E M  *                       *
*                                                                       *
*                                                                       *
*          * * *   S t a n d a r d   L i b r a r y   * * *              *
*                                                                       *
*                                                                       *
*        ---  RUN-TIME KERNEL Exception Module (C-Part)  ---            *
*                                                                       *
*               --- Version  3.1-B5 - 31-07-2019 ---                    *
*                                                                       *
*         by :                                                          *
*                                                                       *
*             P. Wolfers                                                *
*                 www.pierre.wolfers.fr                                 *
*                                             FRANCE.                   *
*                                                                       *
*************************************************************************


/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////

*/

/* * * * * * * * * * * *     Version  2.2--A   * * * * * * * * * * * * */
/* * * * * * * * * * * * *     3O-Sep-2010   * * * * * * * * * * * * * */




void PAS__ERROR( int nerr );



/* Floatting point interrupt manager */

#if defined( WIN32 )&&!( __CYGWIN__ )

 /************************************************************
 *                                                           *
 *                    Windows with Cygwin                    *
 *                                                           *
 ************************************************************/

#  include <windows.h>
#  include <signal.h> 


#ifdef SIGFPE
#  if (!defined( FPE_INTOVF ) && !defined( FPE_INTOVF_TRAP ))
#    define FPE_INTOVF_TRAP -1001
#    define FPE_INTOVF      -1001
#  else
#    if (!defined( FPE_INTOVF ) && defined( FPE_INTOVF_TRAP ))
#      define FPE_INTOVF FPE_INTOVF_TRAP
#    endif
#    if (defined( FPE_INTOVF ) && !defined( FPE_INTOVF_TRAP ))
#      define FPE_INTOVF_TRAP FPE_INTOVF
#    endif
#  endif

#  if (!defined( FPE_INTDIV ) && !defined( FPE_INTDIV_TRAP ))
#    define FPE_INTDIV_TRAP -1002
#    define FPE_INTDIV      -1002
#  else
#    if (!defined( FPE_INTDIV ) && defined( FPE_INTDIV_TRAP ))
#      define FPE_INTDIV FPE_INTDIV_TRAP
#    endif
#    if (defined( FPE_INTDIV ) && !defined( FPE_INTDIV_TRAP ))
#      define FPE_INTDIV_TRAP FPE_INTDIV
#    endif
#  endif

#  if (!defined( FPE_FLTOVF ) && !defined( FPE_FLTOVF_TRAP ))
#    define FPE_FLTOVF_TRAP -1003
#    define FPE_FLTOVF      -1003
#  else
#    if (!defined( FPE_FLTOVF ) && defined( FPE_FLTOVF_TRAP ))
#      define FPE_FLTOVF FPE_FLTOVF_TRAP
#    endif
#    if (defined( FPE_FLTOVF ) && !defined( FPE_FLTOVF_TRAP ))
#      define FPE_FLTOVF_TRAP FPE_FLTOVF
#    endif
#  endif

#  if (!defined( FPE_FLTDIV ) && !defined( FPE_FLTDIV_TRAP ))
#    define FPE_FLTDIV_TRAP -1004
#    define FPE_FLTDIV      -1004
#  else
#    if (!defined( FPE_FLTDIV ) && defined( FPE_FLTDIV_TRAP ))
#      define FPE_FLTDIV FPE_FLTDIV_TRAP
#    endif
#    if (defined( FPE_FLTDIV ) && !defined( FPE_FLTDIV_TRAP ))
#      define FPE_FLTDIV_TRAP FPE_FLTDIV
#    endif
#  endif

#  if (!defined( FPE_FLTUND ) && !defined( FPE_FLTUND_TRAP ))
#    define FPE_FLTUND_TRAP -1005
#    define FPE_FLTUND      -1005
#  else
#    if (!defined( FPE_FLTUND ) && defined( FPE_FLTUND_TRAP ))
#      define FPE_FLTUND FPE_FLTUND_TRAP
#    endif
#    if (defined( FPE_FLTUND ) && !defined( FPE_FLTUND_TRAP ))
#      define FPE_FLTUND_TRAP FPE_FLTUND
#    endif
#  endif

#  if (!defined( FPE_FLTRES ) && !defined( FPE_FLTRES_TRAP ))
#    define FPE_FLTRES_TRAP -1006
#    define FPE_FLTRES      -1006
#  else
#    if (!defined( FPE_FLTRES ) && defined( FPE_FLTRES_TRAP ))
#      define FPE_FLTRES FPE_FLTRES_TRAP
#    endif
#    if (defined( FPE_FLTRES ) && !defined( FPE_FLTRES_TRAP ))
#      define FPE_FLTRES_TRAP FPE_FLTRES
#    endif
#  endif

#  if (!defined( FPE_FLTINV ) && !defined( FPE_FLTINV_TRAP ))
#    define FPE_FLTINV_TRAP -1007
#    define FPE_FLTINV      -1007
#  else
#    if (!defined( FPE_FLTINV ) && defined( FPE_FLTINV_TRAP ))
#      define FPE_FLTINV FPE_FLTINV_TRAP
#    endif
#    if (defined( FPE_FLTINV ) && !defined( FPE_FLTINV_TRAP ))
#      define FPE_FLTINV_TRAP FPE_FLTINV
#    endif
#  endif

#  if (!defined( FPE_FLTSUB ) && !defined( FPE_FLTSUB_TRAP ))
#    define FPE_FLTSUB_TRAP -1008
#    define FPE_FLTSUB      -1008
#  else
#    if (!defined( FPE_FLTSUB ) && defined( FPE_FLTSUB_TRAP ))
#      define FPE_FLTSUB FPE_FLTSUB_TRAP
#    endif
#    if (defined( FPE_FLTSUB ) && !defined( FPE_FLTSUB_TRAP ))
#      define FPE_FLTSUB_TRAP FPE_FLTSUB
#    endif
#  endif
#endif




/* Masking of interrupts */
#  define _FPU_MASK_IM  0x01
#  define _FPU_MASK_DM  0x02
#  define _FPU_MASK_ZM  0x04
#  define _FPU_MASK_OM  0x08
#  define _FPU_MASK_UM  0x10
#  define _FPU_MASK_PM  0x20

#  define _FPU_IT_MASK (_FPU_MASK_IM | _FPU_MASK_ZM | _FPU_MASK_OM)

   /* Macros for accessing the hardware control word.  */
#  define _FPU_GETCW(cw) __asm__ ("fnstcw %0" : "=m" (cw))
#  define _FPU_SETCW(cw) __asm__ ("fldcw  %0" : : "m" (cw))
#  define _FPU_CLEAR     __asm__ ("fnclex")
#  define _FPU_GETSW(cw) __asm__ ("fnstsw %0" : "=m" (cw))


   /* Define the CYGWIN interrupt manager */
void fpu_int_enable()
{ unsigned int imsk = 0;
  _FPU_CLEAR;
  _FPU_GETCW( imsk );
  imsk = imsk &~ _FPU_IT_MASK;
  _FPU_SETCW( imsk );
}


int fpu_state_reset()
{ int status;
  _FPU_GETSW( status );     /* Get the fpu status word */
  _FPU_CLEAR;               /* Clear the fpu error status */
  if (status & _FPU_MASK_IM) status = FPE_FLTINV_TRAP;
  else if (status & _FPU_MASK_ZM) status = FPE_FLTDIV_TRAP;
       else if (status & _FPU_MASK_OM) status = FPE_FLTOVF_TRAP;
            else status = 0;
  return status;
}


static void PAS__it_handler( int signum, siginfo_t * info, void * p )
{
  int ierr;

  ierr = 0;
  switch (signum)
  {
#  ifdef SIGBUS
    case SIGBUS:  ierr = -11;  break;
#  endif

#  ifdef SIGSEGV
    case SIGSEGV: ierr = -12;  break;
#  endif

#  ifdef SIGILL
    case SIGILL:  ierr = -13;  break;
#  endif

#  ifdef SIGFPE
    case SIGFPE:
      ierr = fpu_state_reset();
      switch (info->si_code)
      {
        case FPE_INTOVF: ierr = 21; break;
        case FPE_INTDIV: ierr = 22; break;
        case FPE_FLTOVF: ierr = 24; break;
        case FPE_FLTDIV: ierr = 25; break;
        case FPE_FLTUND: ierr = 26; break;
        case FPE_FLTRES: ierr = 27; break;
        case FPE_FLTINV: ierr = 28; break;
        case FPE_FLTSUB: ierr = 29; break;
        default:  ierr = 20;
      }
    break;
#  endif

    default:
      ierr = 10;
  }
  PAS__ERROR( ierr );
}


void CC_TRAP_INIT()
{ /* Rev. of 02-JUN-2010 */
  struct sigaction action;

  action.sa_sigaction = PAS__it_handler;
  sigemptyset( &action.sa_mask );
  action.sa_flags = SA_SIGINFO;

  fpu_int_enable();

#  ifdef SIGFPE
  sigaction( SIGFPE, &action, NULL );
#  endif

#  ifdef SIGBUS
  sigaction( SIGBUS, &action, NULL );
#  endif

#  ifdef SIGSEGV
  sigaction( SIGSEGV, &action, NULL );
#  endif

#  ifdef SIGILL
  sigaction( SIGILL, &action, NULL );
#  endif
}


#elif (defined( __WIN32 )) // Native Windows.


 /************************************************************
 *                                                           *
 *                   Windows without Cygwin                  *
 *            ( native windows or mingwin (GNUC) )           *
 *                                                           *
 ************************************************************/



#  include <signal.h> 
#  include <float.h>
#  include <windows.h>


static PVOID except_hdl_ptr;             /* Exception Handler Pointer */
static         errno_t imsk;



static void PAS__it_handler( int signum )
{
  LONG ierr, fp_code;

  ierr = 0;
  switch (signum)
  {
#  ifdef SIGBUS
    case SIGBUS:  ierr = -11;  break;
#  endif

#  ifdef SIGSEGV
    case SIGSEGV: ierr = -12;  break;
#  endif

#  ifdef SIGILL
    case SIGILL:  ierr = -13;  break;
#  endif

#  ifdef SIGFPE
    case SIGFPE:
      fp_code = _statusfp();
      _clearfp();
      switch (fp_code)
      {
	/*
        case FPE_INTOVF: ierr = 21; break;
        case FPE_INTDIV: ierr = 22; break;
	*/
        case _FPE_OVERFLOW:   ierr = 24; break;
        case _FPE_ZERODIVIDE: ierr = 25; break;
        case _FPE_UNDERFLOW:  ierr = 26; break;
        case _FPE_INEXACT:    ierr = 27; break;
        case _FPE_INVALID:    ierr = 28; break;
	case _FPE_SQRTNEG:    ierr = 29; break;

        default:
	  ierr = 20;
      }
    break;
#  endif

    default:
      ierr = 10;
  }
  PAS__ERROR( ierr );
}

/* Perhaps it is possible to use the windows native evectored exceptions * /
LONG WINAPI PAS__it_handler( PEXCEPTION_POINTERS Except_Info )
{
  int ierr;

  /* Get the Exception information */ /*
  PEXCEPTION_RECORD except = Except_Info->ExceptionRecord;
  PCONTEXT          contxt = Except_Info->ContextRecord;

  switch (except->ExceptionCode) {
    case EXCEPTION_IN_PAGE_ERROR:           ierr =  99; break;

    case EXCEPTION_ACCESS_VIOLATION:        ierr = -12; break;

    case EXCEPTION_STACK_OVERFLOW:
    case EXCEPTION_FLT_STACK_CHECK:         ierr =  99; break;

    case EXCEPTION_PRIV_INSTRUCTION:        ierr =  99; break;

    case EXCEPTION_ILLEGAL_INSTRUCTION:     ierr = -13; break;
 
    case EXCEPTION_INT_OVERFLOW:            ierr =  21; break;
    case EXCEPTION_INT_DIVIDE_BY_ZERO:      ierr =  22; break;

    case EXCEPTION_FLT_OVERFLOW:            ierr =  24; break;
    case EXCEPTION_FLT_DIVIDE_BY_ZERO:      ierr =  25; break;
    case EXCEPTION_FLT_UNDERFLOW:           ierr =  26; break;
    case EXCEPTION_FLT_INEXACT_RESULT:      ierr =  27; break;
    case EXCEPTION_FLT_DENORMAL_OPERAND:    ierr =  28; break;

    case EXCEPTION_ARRAY_BOUNDS_EXCEEDED:   ierr =  29; break;

    case EXCEPTION_FLT_INVALID_OPERATION:   ierr =  20; break;
      
    default:
      ierr = 10;
  }
  PAS_ERROR( ierr );

  /* When the execution point is here, The rror must be corrected */ /*
  return EXCEPTION_CONTINUE_EXECUTION;
  /* return EXCEPTION_CONTINUE_SEARCH;  */ /*
}
*/


void CC_TRAP_INIT()
{ /* Rev. of 30-JUN-2016 */
  /* except_hdl_ptr = AddVectoredExceptionHandler( 1, PAS__it_handler ); */

  /* imsk = _controlfp_s( 0, _EM_INVALID  | _EM_ZERODIVIDE |  _EM_OVERFLOW, _MCW_EM ); */


  imsk = _controlfp( _EM_INVALID  | _EM_ZERODIVIDE |  _EM_OVERFLOW, _MCW_EM );

#  ifdef SIGFPE
  signal( SIGFPE, &PAS__it_handler );
#  endif

#  ifdef SIGBUS
  signal( SIGBUS, &PAS__it_handler );
#  endif

#  ifdef SIGSEGV
  signal( SIGSEGV, &PAS__it_handler );
#  endif

#  ifdef SIGILL
  signal( SIGILL, &PAS__it_handler );
#  endif

}



#elif (defined(_ARCH_PPC)&&defined(__APPLE__))

 /************************************************************
 *                                                           *
 *                 Mac OS X (Apple Computer)                 *
 *                                                           *
 ************************************************************/

#include <sys/stat.h>
#include <unistd.h>
#include <signal.h> 
#include <architecture/ppc/fp_regs.h>
#include <mach/mach.h>
#include <mach/mach_error.h>
#include <pthread.h>


struct _PPC_EnableFPEState {
  thread_t         targetThread;
  pthread_mutex_t  mutex;
  pthread_cond_t   condition;
  boolean_t        done;
};



__private_extern__ void *_PPC_EnableFloatingPointExceptions(void *arg)
{
  /* Set the MSR bits on how to handle the FPE exceptions */
  struct ppc_thread_state state;
  unsigned int  stateCount;
  kern_return_t krc;
  struct _PPC_EnableFPEState *q = (struct _PPC_EnableFPEState *)arg;

  stateCount = PPC_THREAD_STATE_COUNT;
  krc = thread_get_state(q->targetThread, PPC_THREAD_STATE, (natural_t *)&state, &stateCount);
  if (krc != KERN_SUCCESS) {
      mach_error("thread_get_state", krc);
      exit( 2 );
  }

#  define FE0_MASK (1<<11)
#  define FE1_MASK (1<<8)

  /* FE0  FE1
  //  0    0    -- Floating-point exceptions disabled
  //  0    1    -- Floating-point imprecise nonrecoverable
  //  1    0    -- Floating-point imprecise recoverable
  //  1    1    -- Floating-point precise mode

  //    fprintf(stderr, "state.srr1 = 0x%08x\n", state.srr1);
  //    fprintf(stderr, "FE0 = %d\n", (state.srr1 & FE0_MASK) != 0);
  //    fprintf(stderr, "FE1 = %d\n", (state.srr1 & FE1_MASK) != 0);
  */

  state.srr1 |= FE0_MASK;
  state.srr1 |= FE1_MASK;

  /*    fprintf(stderr, "state.srr1 = 0x%08x\n", state.srr1);
  //    fprintf(stderr, "FE0 = %d\n", (state.srr1 & FE0_MASK) != 0);
  //    fprintf(stderr, "FE1 = %d\n", (state.srr1 & FE1_MASK) != 0);
  */

  krc = thread_set_state(q->targetThread, PPC_THREAD_STATE, (natural_t *)&state, stateCount);
  if (krc != KERN_SUCCESS) {
    mach_error("thread_set_state", krc);
    exit( 2 );
  }

  if (0) {
    ppc_float_state_t floatState;
    ppc_fp_scr_t *fpscr;

    stateCount = PPC_FLOAT_STATE_COUNT;
    krc = thread_get_state(q->targetThread, PPC_FLOAT_STATE, (natural_t *)&floatState, &stateCount);
    if (krc != KERN_SUCCESS) {
      mach_error("thread_get_state", krc);
      exit( 2 );
    }

    /* Get a pointer through a bitfield type so we don't have to do index goo ourselves */
    fpscr = (ppc_fp_scr_t*)&floatState.fpscr_pad;
    PPC_PrintFPSCR(fpscr);
  }

  pthread_mutex_lock(&q->mutex);
  q->done = TRUE;
  pthread_cond_signal(&q->condition);
  pthread_mutex_unlock(&q->mutex);

  return NULL;
}



__private_extern__ void fpu_int_enable()     /* PPC_EnableFloatingPointExceptions() */
{
  ppc_fp_scr_t fpscr;

  /*  fprintf(stderr, "### Enabling FPU exceptions ###\n"); */
  fpscr = get_fp_scr();

  // Specify which exceptions we want
  fpscr.ve = 1;              /* invalid op exception enable */
  fpscr.oe = 1;              /* overflow exception enable */
  fpscr.ue = 0;              /* underflow exception enable */
  fpscr.ze = 1;              /* divide by zero exception enable */
  fpscr.xe = 0;              /* inexact exception enable */
  fpscr.ni = 1;              /* non-IEEE exception enable */

  /* Clear sticky exception bits so we don't immediately get clobbered with an exception */
  fpscr.fx = 0;              /* exception summary */
  fpscr.vx = 0;              /* invalid op exception summary */
  fpscr.ox = 0;              /* overflow exception */
  fpscr.ux = 0;              /* underflow exception */
  fpscr.zx = 0;              /* divide by zero exception */
  fpscr.xx = 0;              /* inexact exception */
  fpscr.vx_snan = 0;         /* not a number exception */
  fpscr.vx_isi = 0;          /* exception */
  fpscr.vx_idi = 0;          /* exception */
  fpscr.vx_zdz = 0;          /* exception */
  fpscr.vx_imz = 0;          /* exception */
  fpscr.vx_xvc = 0;          /* exception */
  fpscr.vx_soft = 0;         /* software request exception */
  fpscr.vx_cvi = 0;          /* invalid integer convert exception */

  /*
    fprintf(stderr, "FPSCR = 0x%08x : 0x%08x\n",
            ((unsigned int *)&fpscr)[0],
            ((unsigned int *)&fpscr)[1]);
  */

  set_fp_scr(fpscr);
  /*  fpscr = get_fp_scr(); */

  {
     struct _PPC_EnableFPEState state;
     pthread_t thread;

     memset(&state, 0, sizeof(state));
     state.targetThread = mach_thread_self();
     pthread_mutex_init(&state.mutex, NULL);
     pthread_cond_init(&state.condition, NULL);
        /* fprintf(stderr, "state.targetThread = 0x%08x\n", state.targetThread); */

     pthread_create(&thread, NULL, _PPC_EnableFloatingPointExceptions, &state);

     pthread_mutex_lock(&state.mutex);
     while (!state.done)
       pthread_cond_wait(&state.condition, &state.mutex);
     pthread_mutex_unlock(&state.mutex);
  }
}



unsigned int fpu_state_reset()
{
  ppc_fp_scr_t fpscr;
  unsigned r = 0;

  fpscr = get_fp_scr();
/*  PPC_PrintFPSCR( &fpscr ); */

  if (fpscr.ox) r = FPE_FLTOVF_TRAP;
           else if (fpscr.zx) r = FPE_FLTDIV_TRAP;
                         else if (fpscr.vx) r = FPE_FLTINV_TRAP;

  fpscr.fx = 0;              /* exception summary */
  fpscr.vx = 0;              /* invalid op exception summary */
  fpscr.ox = 0;              /* overflow exception */
  fpscr.ux = 0;              /* underflow exception */
  fpscr.zx = 0;              /* divide by zero exception */
  fpscr.xx = 0;              /* inexact exception */
  fpscr.vx_snan = 0;         /* not a number exception */
  fpscr.vx_isi = 0;          /* exception */
  fpscr.vx_idi = 0;          /* exception */
  fpscr.vx_zdz = 0;          /* exception */
  fpscr.vx_imz = 0;          /* exception */
  fpscr.vx_xvc = 0;          /* exception */
  fpscr.vx_soft = 0;         /* software request exception */
  fpscr.vx_cvi = 0;          /* invalid integer convert exception */

  set_fp_scr( fpscr );

  return r;
}



static void PAS__it_handler( int signum, siginfo_t * info, void * p )
{
  int ierr, status;

  ierr = 0;
  switch (signum)
  {
#  ifdef SIGBUS
    case SIGBUS:  ierr = -11;  break;
#  endif

#  ifdef SIGSEGV
    case SIGSEGV: ierr = -12;  break;
#  endif

#  ifdef SIGILL
    case SIGILL:  ierr = -13;  break;
#  endif

#  ifdef SIGFPE
    case SIGFPE:
      ierr = fpu_state_reset();
      switch (info->si_code)
      {
        case FPE_INTOVF: ierr = 21; break;
        case FPE_INTDIV: ierr = 22; break;
        case FPE_FLTOVF: ierr = 24; break;
        case FPE_FLTDIV: ierr = 25; break;
        case FPE_FLTUND: ierr = 26; break;
        case FPE_FLTRES: ierr = 27; break;
        case FPE_FLTINV: ierr = 28; break;
        case FPE_FLTSUB: ierr = 29; break;
        default:  ierr = 20;
      }
    break;
#  endif

    default:
      ierr = 10;
  }
  PAS__ERROR( ierr );
}


void CC_TRAP_INIT()
{ /* Rev. of 02-JUN-2010 */
  struct sigaction action;

  action.sa_sigaction = PAS__it_handler;
  sigemptyset( &action.sa_mask );
  action.sa_flags = SA_SIGINFO;

  fpu_int_enable();

#  ifdef SIGFPE
  sigaction( SIGFPE, &action, NULL );
#  endif

#  ifdef SIGBUS
  sigaction( SIGBUS, &action, NULL );
#  endif

#  ifdef SIGSEGV
  sigaction( SIGSEGV, &action, NULL );
#  endif

#  ifdef SIGILL
  sigaction( SIGILL, &action, NULL );
#  endif
}



#elif (defined(__unix)&&defined(__sgi))

 /************************************************************
 *                                                           *
 *                Silicon Graphic Unix (IRIX)                *
 *                                                           *
 ************************************************************/

#  include <signal.h>
#  include <unistd.h>
#  include <math.h>
#  include <sys/fpu.h>



void fpu_int_enable()
{ union fpc_csr f;
  f.fc_word=get_fpc_csr();
  f.fc_struct.en_divide0   = 1;
  f.fc_struct.en_underflow = 0;
  f.fc_struct.en_overflow  = 1;
  f.fc_struct.en_invalid   = 1;
  set_fpc_csr(f.fc_word);
  return;
}



static void PAS__it_handler( int signum, siginfo_t * info, void * p )
{
  int ierr;

  ierr = 0;
  switch (signum)
  {
#  ifdef SIGBUS
    case SIGBUS:  ierr = -11;  break;
#  endif

#  ifdef SIGSEGV
    case SIGSEGV: ierr = -12;  break;
#  endif

#  ifdef SIGILL
    case SIGILL:  ierr = -13;  break;
#  endif

#  ifdef SIGFPE
    case SIGFPE:
/*    status = feclearexcept( FE_ALL_EXCEPT ); */
      switch (info->si_code)
      {
        case FPE_INTOVF: ierr = 21; break;
        case FPE_INTDIV: ierr = 22; break;
        case FPE_FLTOVF: ierr = 24; break;
        case FPE_FLTDIV: ierr = 25; break;
        case FPE_FLTUND: ierr = 26; break;
        case FPE_FLTRES: ierr = 27; break;
        case FPE_FLTINV: ierr = 28; break;
        case FPE_FLTSUB: ierr = 29; break;
        default:  ierr = 20;
      }
    break;
#  endif

    default:
      ierr = 10;
  }
  PAS__ERROR( ierr );
}


void CC_TRAP_INIT()
{ /* Rev. of 02-JUN-2010 */
  struct sigaction action;

  action.sa_sigaction = PAS__it_handler;
  sigemptyset( &action.sa_mask );
  action.sa_flags = SA_SIGINFO;

  fpu_int_enable();

#  ifdef SIGFPE
  sigaction( SIGFPE, &action, NULL );
#  endif

#  ifdef SIGBUS
  sigaction( SIGBUS, &action, NULL );
#  endif

#  ifdef SIGSEGV
  sigaction( SIGSEGV, &action, NULL );
#  endif

#  ifdef SIGILL
  sigaction( SIGILL, &action, NULL );
#  endif
}



#elif (defined(__linux__)||defined(__linux))||defined(__CYGWIN__)


 /************************************************************
 *                                                           *
 *       Linux  and Windows/Cygwin  Operating Systems        *
 *                                                           *
 ************************************************************/

#define _GNU_SOURCE
#include <sys/stat.h>
#include <signal.h>
#ifndef __USE_GNU 
#  define __USE_GNU
#endif
#include <fenv.h>
#include <unistd.h>
#include <math.h>



void EnableFpu_Exception()
{
  feenableexcept( FE_DIVBYZERO | FE_INVALID | FE_OVERFLOW );
/*
  fexcept_t fpu_exc;
    fegetexceptflag( &fpu_exc,  FE_DIVBYZERO | FE_INVALID | FE_OVERFLOW );
    fesetexceptflag( &fpu_exc,  FE_DIVBYZERO | FE_INVALID | FE_OVERFLOW );
*/
}

/* Revision from of 02-JUN-2010 */
static void PAS__it_handler( int signum, siginfo_t * info, void * p )
{
  int ierr, status;

  ierr = 0;
  switch (signum)
  {
#  ifdef SIGBUS
    case SIGBUS:  ierr = -11;  break;
#  endif

#  ifdef SIGSEGV
    case SIGSEGV: ierr = -12;  break;
#  endif

#  ifdef SIGILL
    case SIGILL:  ierr = -13;  break;
#  endif

#  ifdef SIGFPE
    case SIGFPE:
      EnableFpu_Exception();
      /* feenableexcept( FE_DIVBYZERO | FE_INVALID | FE_OVERFLOW ); */
      switch (info->si_code)
      {
        case FPE_INTOVF: ierr = 21; break;
        case FPE_INTDIV: ierr = 22; break;
        case FPE_FLTOVF: ierr = 24; break;
        case FPE_FLTDIV: ierr = 25; break;
        case FPE_FLTUND: ierr = 26; break;
        case FPE_FLTRES: ierr = 27; break;
        case FPE_FLTINV: ierr = 28; break;
        case FPE_FLTSUB: ierr = 29; break;
        default:  ierr = 20;
      }
    break;
#  endif

    default:
      ierr = 10;
  }
  PAS__ERROR( ierr );
}



void CC_TRAP_INIT()
{ /* Rev. of 02-JUN-2010 */
  struct sigaction action;

  action.sa_sigaction = PAS__it_handler;
  sigemptyset( &action.sa_mask );
  action.sa_flags = SA_SIGINFO;

  EnableFpu_Exception();

#  ifdef SIGFPE
  sigaction( SIGFPE, &action, NULL );
#  endif

#  ifdef SIGBUS
  sigaction( SIGBUS, &action, NULL );
#  endif

#  ifdef SIGSEGV
  sigaction( SIGSEGV, &action, NULL );
#  endif

#  ifdef SIGILL
  sigaction( SIGILL, &action, NULL );
#  endif
}



#endif
