/*  P A S - P. WOLFERS SOFTWARE: V3.1-A1 OF 30-NOV-2014 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long long int

/* Include the PAS environment file. */
#include "cpas_defs.h"
static P Lx[1];

/* Define the local data section. */
static Blk( Rd, 1512 ) = {
 14,  14, 115, 101, 116,  95, 115, 114,  99, 102, 105, 108, 101, 115, 112,  99,
 63,  63,  47, 104, 111, 109, 101,  47, 112, 105, 101, 114, 114, 101,  47,  83,
111, 102, 116,  47,  99, 112, 115, 104,  95, 107, 105, 116, 115,  47,  99, 112,
 97, 115,  99,  97, 108,  95, 115, 114,  99,  95,  86,  51,  45,  49,  45,  65,
 50,  47, 112,  99, 109, 112,  95, 105, 110, 115, 121, 109,  98,  46, 112,  97,
115,   3,   3,  84,  84,  58,  17,  17,  99, 111, 109, 112, 105, 108, 101,  95,
115, 101, 116,  95, 116, 105, 116, 108, 101,   3,   3,  84,  84,  58,  29,  29,
 32,  84, 104, 101,  32,  67, 117, 114, 114, 101, 110, 116,  32,  83, 111, 117,
114,  99, 101,  32,  70, 105, 108, 101,  32, 105, 115,  32,  34,   2,   2,  34,
 46,  17,  17,  99, 111, 109, 112, 105, 108, 101,  95, 115, 101, 116,  95, 115,
 98, 116, 116, 108,  33,  33,  32,  84, 104, 101,  32,  67, 117, 114, 114, 101,
110, 116,  32,  67, 111, 109, 112, 105, 108, 101, 100,  32,  77, 111, 100, 117,
108, 101,  32, 105, 115,  32,  34,   2,   2,  34,  46,  10,  10, 115, 101, 116,
107, 101, 121, 119, 111, 114, 100,  16,  16, 115, 101, 116,  95, 107, 101, 121,
119, 111, 114, 100,  95, 116, 114, 101, 101,   2,   2, 111, 114,   3,   3, 120,
111, 114,   3,   3,  97, 110, 100,   3,   3, 110, 111, 116,   3,   3, 100, 105,
118,   3,   3, 109, 111, 100,   3,   3, 114, 101, 109,   2,   2, 105, 110,   3,
  3, 110, 105, 108,   5,   5, 108,  97,  98, 101, 108,   4,   4, 103, 111, 116,
111,   4,   4, 116, 121, 112, 101,   5,   5,  99, 111, 110, 115, 116,  14,  14,
117, 115, 101, 114,  95, 115, 116,  97, 116, 101, 109, 101, 110, 116,   3,   3,
118,  97, 114,   6,   6, 105, 110,  95, 118,  97, 114,   7,   7, 111, 117, 116,
 95, 118,  97, 114,   7,   7, 112, 114, 105, 118,  97, 116, 101,   6,   6,  97,
 99,  99, 101, 115, 115,   4,   4, 102, 105, 108, 101,   5,   5,  97, 114, 114,
 97, 121,   6,   6, 114, 101,  99, 111, 114, 100,   3,   3, 115, 101, 116,   3,
  3, 117, 115, 101,   3,   3, 110, 101, 119,   4,   4, 110, 101, 119, 104,   7,
  7, 100, 105, 115, 112, 111, 115, 101,   4,   4, 111, 112, 101, 110,   5,   5,
114, 101, 115, 101, 116,   7,   7, 114, 101, 119, 114, 105, 116, 101,   6,   6,
 97, 112, 112, 101, 110, 100,   4,   4, 114, 101,  97, 100,   6,   6, 114, 101,
 97, 100, 108, 110,   5,   5, 114, 101,  97, 100, 118,   5,   5, 119, 114, 105,
116, 101,   7,   7, 119, 114, 105, 116, 101, 108, 110,   6,   6, 119, 114, 105,
116, 101, 118,   7,   7, 112, 114, 111, 103, 114,  97, 109,   6,   6, 109, 111,
100, 117, 108, 101,   9,   9, 112, 114, 111,  99, 101, 100, 117, 114, 101,   8,
  8, 102, 117, 110,  99, 116, 105, 111, 110,   6,   6, 114, 101, 116, 117, 114,
110,   7,   7, 102, 111, 114, 119,  97, 114, 100,   6,   6, 115, 116,  97, 116,
105,  99,   6,   6, 103, 108, 111,  98,  97, 108,   6,   6, 112,  97,  99, 107,
101, 100,   8,   8, 101, 120, 116, 101, 114, 110,  97, 108,   8,   8, 115, 116,
 97, 110, 100,  97, 114, 100,   6,   6, 105, 110, 108, 105, 110, 101,   5,   5,
 98, 101, 103, 105, 110,   2,   2, 105, 102,   4,   4, 116, 104, 101, 110,   4,
  4, 101, 108, 115, 101,   5,   5, 119, 104, 105, 108, 101,   6,   6, 114, 101,
112, 101,  97, 116,   5,   5, 117, 110, 116, 105, 108,   3,   3, 102, 111, 114,
  4,   4, 108, 111, 111, 112,   4,   4, 101, 120, 105, 116,   4,   4,  99,  97,
115, 101,   4,   4, 119, 105, 116, 104,   3,   3, 101, 110, 100,   9,   9, 111,
116, 104, 101, 114, 119, 105, 115, 101,   2,   2, 111, 102,   2,   2, 100, 111,
  2,   2, 116, 111,   6,   6, 100, 111, 119, 110, 116, 111,   7,   7,  37, 100,
101, 102, 105, 110, 101,   9,   9,  37, 117, 110, 100, 101, 102, 105, 110, 101,
  3,   3,  37, 105, 102,   6,   6,  37, 105, 102, 100, 101, 102,   8,   8,  37,
105, 102, 117, 110, 100, 101, 102,   5,   5,  37, 101, 108, 115, 101,   6,   6,
 37, 101, 110, 100, 105, 102,   7,   7,  37,  99, 104,  97, 105, 110, 101,   8,
  8,  37, 105, 110,  99, 108, 117, 100, 101,   7,   7,  37, 112, 114,  97, 103,
109,  97,   4,   4,  37, 101, 111, 102,   6,   6, 110, 101, 120, 116,  99, 104,
  8,   8, 112, 117, 116,  95,  99, 104,  97, 114,   4,   4,  73,  78,  83,  89,
 12,  12, 116, 101, 115, 116,  95, 102, 105, 103, 117, 114, 101, 115,   7,   7,
102, 105, 103, 117, 114, 101, 115,   4,   4,  70,  73,  71,  85,  11,  11, 111,
118, 102,  95, 104,  97, 110, 100, 108, 101, 114,  11,  11,  84, 111, 111,  32,
 79,  86,  72,  32,  69,  82,  82,  12,  12, 105, 110, 115, 121, 109,  98, 111,
108,  95, 115, 114,  99, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,  13,  13, 112, 114,  97, 103, 109,  97,  95, 109,
115, 116,  97, 116, 101,   4,   4,  80,  82,  65,  71,  14,  14, 105, 110,  99,
108, 117, 100, 101,  95, 109, 115, 116,  97, 116, 101,   4,   4,  46, 112,  97,
115,   4,   4,  73,  78,  67,  76,  20,  20,  32,  79, 112, 101, 110,  32,  69,
114, 114, 111, 114,  32,  40,  82,  84,  76,  41,  32,  35,  32,  22,  22,  32,
102, 111, 114,  32, 116, 104, 101,  32,  83, 111, 117, 114,  99, 101,  32, 102,
105, 108, 101,  32,  34,   2,   2,  34,  46,  15,  15,  32,  82,  84,  76,  32,
109, 101, 115, 115,  97, 103, 101,  32,  58,  32,  14,  14, 101, 110, 100, 102,
105, 108, 101,  95, 109, 115, 116,  97, 116, 101,   8,   8, 105, 110, 115, 121,
109,  98, 111, 108,   4,   4,  77,  65,  83,  89,  11,  11, 115, 107, 105, 112,
 95, 115, 121, 109,  98, 111, 108,   9,   9, 105, 110, 115, 121,  95, 105, 110,
105, 116,   0,   0,  53,  53,  32,  80,  32,  65,  32,  83,  32,  45,  32,  80,
 46,  32,  87,  79,  76,  70,  69,  82,  83,  32,  83,  79,  70,  84,  87,  65,
 82,  69,  58,  32,  86,  51,  46,  49,  45,  65,  49,  32,  79,  70,  32,  51,
 48,  45,  78,  79,  86,  45,  50,  48,  49,  52,  32,  19,  19,  67,  80,  65,
 83,  95,  67,  79,  77,  80,  73,  76,  69,  82,  95,  69,  82,  82,  79,  82,
  5,   5,  32,  80,  65,  83,  62,  16,  16,  67,  80,  65,  83,  95,  69,  78,
 86,  73,  82,  79,  78,  77,  69,  78,  84,  22,  22,  32,  80,  65,  83,  32,
 67,  65,  78,  78,  79,  84,  32,  79,  80,  69,  78,  32,  84,  72,  69,  32,
 34,  15,  15,  34,  32,  73,  78,  73,  84,  73,  65,  76,  32,  70,  73,  76,
 69,  46,  22,  22,  32,  80,  65,  83,  32,  67,  65,  78,  78,  79,  84,  32,
 79,  80,  69,  78,  32,  84,  72,  69,  32,  34,  23,  23,  34,  32,  79,  85,
 84,  80,  85,  84,  32,  77,  83,  71,  47,  76,  73,  83,  84,  32,  70,  73,
 76,  69,  46,   0,   0,   0,   0,   0
};

/* Define the local static Initialized section. */
static Blk( Ri, 872 ) = {
  0,   0,   0,   0,   9,  10,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   1,  11,  12,   3,   3,   3,  13,   4,  14,  15,  16,  17,
 18,  19,   8,  20,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   5,  21,
  6,  22,   7,   1,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
  3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,  23,
 24,  25,  26,   3,   1,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
  3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   1,
 11,   1,   1,   0,  13,  21,  25,  29,  12,  20,  14,  29,  15,  29,   8,   6,
  9,  11,  18,  29,   9,  12,   8,   7,  19,  29,  10,  19,  16,  29,   6,   0,
 17,  29,  24,  29,   7, 108, 105, 115, 116,  95, 111, 110,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,   8, 108, 105, 115, 116,  95, 111, 102, 102,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,   7, 101,  99, 104, 111,  95, 111, 110,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,   8, 101,  99, 104, 111,  95, 111, 102, 102,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,   7, 108, 105, 115, 116, 108, 118, 108,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,   6, 102, 111, 114, 109,  97, 116,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  10,  99, 112,  95, 108, 105, 115, 116,  95, 111, 110,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  11,  99, 112,  95, 108, 105, 115, 116,  95, 111, 102, 102,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  13,  99, 112,  95,  98, 105, 110,  95, 101, 120, 101,  95,
111, 110,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  14,  99, 112,  95,  98, 105, 110,  95, 101, 120, 101,  95,
111, 102, 102,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,   9,  99, 112,  95,  98, 105, 110,  95, 111, 110,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  10,  99, 112,  95,  98, 105, 110,  95, 111, 102, 102,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,   9,  99, 112,  95, 101, 120, 101,  95, 111, 110,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  10,  99, 112,  95, 101, 120, 101,  95, 111, 102, 102,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,   5, 116, 114,  97,  99, 101,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,   8, 100, 101,  98, 117, 103,  95, 111, 110,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,   9, 100, 101,  98, 117, 103,  95, 111, 102, 102,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,   8, 114,  97, 110, 103, 101,  95, 111, 110,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,   9, 114,  97, 110, 103, 101,  95, 111, 102, 102,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  11,  99, 111, 100, 101,  95, 111, 112, 116, 105, 111, 110,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  13, 112,  99, 109, 112,  95, 100, 101,  98, 117, 103,  95,
111, 110,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  14, 112,  99, 109, 112,  95, 100, 101,  98, 117, 103,  95,
111, 102, 102,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,   0,   0,   0,   0
};

/* Declaration of external variables. */
extern V V_src_control;
extern V V_srf_list;
extern V V_srf_free;
extern UB V_cntx_srinf;
extern V V_lst_current;
extern V V_keyword_tree;
extern C V_sy_ch;
extern C V_sy_cmin;
extern Blk(V_sy_string, 264 );
extern V PAS__f_output;
extern Blk(V_sy_sym, 8 );
extern SL V_sy_ival;
extern G V_sy_rval;
extern UB V_sy_label_flag;
extern Blk(V_sy_ident, 32 );
extern UB V_sy_init_mod;
extern UB V_cmp_macf;
extern UB V_cmp_cobj;
extern V V_pas_obj;
extern UB V_cmp_objf;
extern UB V_cmp_bltt;
extern SL V_cmp_traceopt;
extern UB V_cmp_debugopt;
extern UB V_cmp_range;
extern UB V_cmp_cmpdbg;
extern SL V_cmp_trace;
extern SL V_cmp_tracecount;
extern UB V_pas_compile;
extern UB V_error_result;
extern UB V_emergency_stop;
extern SL V_proc_seq;


/* Function/procedure prototypes. */
void P_lst_open(V *F_p, V F_fspc, V F_heading, V F_title, V F_sbttl, SL F_lnsize
, SL F_pgsize, UB F_bunknown, UB F_bprint, UB F_bappend, SL *F_ierr);
void P_lst_newline();
void P_lst_eoln();
void P_lst_g_init(V F_def_lst, V F_def_heading, SL *F_ierr);
void P_err_init(V F_errf_str);
void P_src_close(V *F_p, UB F_bfree);
void P_src_open(V *F_p, V F_fspc, UB F_bdelete, SL *F_ierr);
void P_src_error(V F_modnam, SL F_number, UB F_severity);
void P_src_end_of_line();
C P_src_inchar();
C P_src_next_char();
void P_src_init(V F_def_prt, V F_def_src);
void P_src_error_s(V F_modulesy, SL F_number, UB F_severity, V F_id1, V F_id2);
void P_val_new(V *F_p, V F_ty);
void P_val_free(V *F_p);
SL P_match(V F_s1, V F_s2);
void P_ide_int_label();
void P_ide_init();
void P_binary_objf_close();
void P_generation_pragma();


/* Procedure/Function : " set_srcfilespc "  */
void P_set_srcfilespc(SL F_icd){
  /* Define the automatic variable space. */
  Blk( Ra, 536 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  register V Rv3;
  register UB Rv4;
  register V Rv5;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[65]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+260;
  Ra.v[66]=Rd.s;
  Ra.v[67]=Rd.s+16;
  Ra.sl[68]=103; /* line # 103 */
  if (F_icd>=0) {
    PAS__STR_TO_STR(Ra.s,PAS__FILE_SPC(Ra.s+276,((V *)V_src_control)[57]));
    if (Ra.ub[1]==0) PAS__STR_TO_STR(Ra.s,Rd.s+81);
    if (F_icd>0||V_srf_list==NULL) {
      Ra.sl[68]=109; /* line # 109 */
      if (V_srf_free==NULL) Rv0=PAS__NEW(8);
      else {
        Rv0=V_srf_free;
        V_srf_free=((V *)Rv0)[0];
      }
      Rv1=Rv0;
      Ra.sl[68]=115; /* line # 115 */
      ((V *)Rv1)[0]=V_srf_list;
      ((V *)Rv1)[1]=NULL;
      P_val_new(((V *)Rv1)+1,NULL);
      V_srf_list=Rv0;
    }
    else {
      Ra.sl[68]=122; /* line # 122 */
      Rv2=V_srf_list;
      P_val_free(((V *)Rv2)+1);
      P_val_new(((V *)Rv2)+1,NULL);
    }
    Ra.sl[68]=127; /* line # 127 */
    Rv3=((V *)V_srf_list)[1];
    ((UB *)Rv3)[36]=32;
    ((SL *)Rv3)[5]=Ra.ub[1];
    Rv4=Ra.ub[1];
    ((V *)Rv3)[10]=PAS__NEW((SL)Rv4+2);
    ((UB *)((V *)Rv3)[10])[0]=Rv4;
    Ra.sl[68]=132; /* line # 132 */
    PAS__STR_TO_STR(((V *)Rv3)[10],Ra.s);
  }
  else {
    Ra.sl[68]=137; /* line # 137 */
    Rv0=V_srf_list;
    Rv5=Rv0;
    V_srf_list=((V *)Rv5)[0];
    P_val_free(((V *)Rv5)+1);
    Ra.sl[68]=142; /* line # 142 */
    ((V *)Rv5)[0]=V_srf_free;
    V_srf_free=Rv0;
  }
  V_cntx_srinf=1;
  PAS__curr_cntx=Ra.v[65];
}


/* Procedure/Function : " compile_set_title "  */
void P_compile_set_title(){
  /* Define the automatic variable space. */
  Blk( Ra, 792 );

  /* Local variable stored in C variable */
  register V Rv0;
  register UB Rv1;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[65]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+260;
  Ra.v[66]=Rd.s+86;
  Ra.v[67]=Rd.s+16;
  Ra.sl[68]=165; /* line # 165 */
  Rv0=V_lst_current;
  if (((V *)Rv0)[4]!=NULL) PAS__DISPOSE(((V *)Rv0)+4);
  PAS__STR_TO_STR(Ra.s,PAS__FILE_SPC(Ra.s+276,((V *)V_src_control)[57]));
  if (Ra.ub[1]==0) PAS__STR_TO_STR(Ra.s,Rd.s+105);
  Ra.sl[68]=170; /* line # 170 */
  PAS__STR_TO_STR(Ra.s,PAS__CON_STR_STR(Ra.s+533,PAS__CON_STR_STR(Ra.s+276,Rd.s+
110,Ra.s),Rd.s+141));
  Rv1=Ra.ub[1];
  ((V *)Rv0)[4]=PAS__NEW((SL)Rv1+2);
  ((UB *)((V *)Rv0)[4])[0]=Rv1;
  PAS__STR_TO_STR(((V *)Rv0)[4],Ra.s);
  PAS__curr_cntx=Ra.v[65];
}


/* Procedure/Function : " compile_set_sbttl "  */
void P_compile_set_sbttl(V F_prc){
  /* Define the automatic variable space. */
  Blk( Ra, 792 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register UB Rv2;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[65]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+260;
  Ra.v[66]=Rd.s+145;
  Ra.v[67]=Rd.s+16;
  Ra.sl[68]=185; /* line # 185 */
  Rv0=V_lst_current;
  if (((V *)Rv0)[5]!=NULL) PAS__DISPOSE(((V *)Rv0)+5);
  if (((V *)F_prc)[3]!=NULL) {
    Rv1=((V *)F_prc)[3];
    Ra.sl[68]=191; /* line # 191 */
    PAS__STR_TO_STR(Ra.s,PAS__SUBSTR_CHT(Ra.s+276,Rv1+1,31,1,((UB *)Rv1)[0]));
    PAS__STR_TO_STR(Ra.s,PAS__CON_STR_STR(Ra.s+533,PAS__CON_STR_STR(Ra.s+276,Rd.
    s+164,Ra.s),Rd.s+199));
    Rv2=Ra.ub[1];
    ((V *)Rv0)[5]=PAS__NEW((SL)Rv2+2);
    ((UB *)((V *)Rv0)[5])[0]=Rv2;
    PAS__STR_TO_STR(((V *)Rv0)[5],Ra.s);
  }
  PAS__curr_cntx=Ra.v[65];
}


/* Procedure/Function : " setkeyword "  */
void PAS_INSMBOL_PRC_00000000(V F_kname, UB F_skw, UB F_opkw){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  SL Rv2;
  V Rv3;
  V Rv4;
  register V Rv5;
  SL Rv6;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+203;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=216; /* line # 216 */
  Rv0=PAS__NEW(42);
  Rv1=Rv0;
  ((UB *)Rv1)[0]=((UB *)F_kname)[1];
  Rv2=1;
  for( Rf0=((UB *)Rv1)[0];Rf0>0;Rf0-- ) {
    ((C *)Rv1)[Rv2]=((C *)F_kname)[Rv2+1];
    Rv2++;
  }
  Ra.sl[3]=221; /* line # 221 */
  ((V *)Rv1)[8]=NULL;
  ((V *)Rv1)[9]=NULL;
  ((UB *)Rv1)[40]=F_skw;
  ((UB *)Rv1)[41]=F_opkw;
  Rv3=V_keyword_tree;
  if (Rv3!=NULL) {
    while (1){
      Ra.sl[3]=228; /* line # 228 */
      Rv4=Rv3;
      Rv5=Rv3;
      Rv6=P_match(Rv0,Rv5);
      if (Rv6>0) Rv3=((V *)Rv5)[9];
      else {
        Ra.sl[3]=233; /* line # 233 */
        Rv3=((V *)Rv5)[8];
      }
      if (Rv3==NULL)  break;
    }
    if (Rv6>0) ((V *)Rv4)[9]=Rv0;
    else((V *)Rv4)[8]=Rv0;
  }
  else {
    Ra.sl[3]=239; /* line # 239 */
    V_keyword_tree=Rv0;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " set_keyword_tree "  */
void PAS_INSMBOL_set_keyword_tree(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+215;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=243; /* line # 243 */
  V_keyword_tree=NULL;
  PAS_INSMBOL_PRC_00000000(Rd.s+233,13,21);
  Ra.sl[3]=248; /* line # 248 */
  PAS_INSMBOL_PRC_00000000(Rd.s+237,13,22);
  PAS_INSMBOL_PRC_00000000(Rd.s+242,12,20);
  PAS_INSMBOL_PRC_00000000(Rd.s+247,6,0);
  PAS_INSMBOL_PRC_00000000(Rd.s+252,8,8);
  PAS_INSMBOL_PRC_00000000(Rd.s+257,8,9);
  Ra.sl[3]=253; /* line # 253 */
  PAS_INSMBOL_PRC_00000000(Rd.s+262,8,10);
  PAS_INSMBOL_PRC_00000000(Rd.s+267,10,23);
  Ra.sl[3]=258; /* line # 258 */
  PAS_INSMBOL_PRC_00000000(Rd.s+271,28,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+276,33,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+283,34,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+289,30,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+295,29,29);
  Ra.sl[3]=263; /* line # 263 */
  PAS_INSMBOL_PRC_00000000(Rd.s+302,32,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+318,31,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+323,36,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+331,37,29);
  Ra.sl[3]=268; /* line # 268 */
  PAS_INSMBOL_PRC_00000000(Rd.s+340,44,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+349,39,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+357,40,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+363,41,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+370,42,29);
  Ra.sl[3]=273; /* line # 273 */
  PAS_INSMBOL_PRC_00000000(Rd.s+378,43,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+383,74,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+388,59,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+393,60,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+399,61,29);
  Ra.sl[3]=278; /* line # 278 */
  PAS_INSMBOL_PRC_00000000(Rd.s+408,62,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+414,63,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+421,64,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+430,65,29);
  Ra.sl[3]=283; /* line # 283 */
  PAS_INSMBOL_PRC_00000000(Rd.s+438,66,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+444,67,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+452,68,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+459,69,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+466,70,29);
  Ra.sl[3]=288; /* line # 288 */
  PAS_INSMBOL_PRC_00000000(Rd.s+475,71,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+483,76,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+492,75,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+500,77,29);
  Ra.sl[3]=293; /* line # 293 */
  PAS_INSMBOL_PRC_00000000(Rd.s+511,78,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+521,79,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+529,80,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+538,87,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+546,82,29);
  Ra.sl[3]=298; /* line # 298 */
  PAS_INSMBOL_PRC_00000000(Rd.s+554,38,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+562,81,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+572,83,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+582,84,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+590,72,29);
  Ra.sl[3]=303; /* line # 303 */
  PAS_INSMBOL_PRC_00000000(Rd.s+597,45,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+601,46,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+607,47,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+613,48,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+620,49,29);
  Ra.sl[3]=308; /* line # 308 */
  PAS_INSMBOL_PRC_00000000(Rd.s+628,50,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+635,51,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+640,55,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+646,56,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+652,57,29);
  Ra.sl[3]=313; /* line # 313 */
  PAS_INSMBOL_PRC_00000000(Rd.s+658,58,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+664,73,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+669,86,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+680,85,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+684,54,29);
  Ra.sl[3]=318; /* line # 318 */
  PAS_INSMBOL_PRC_00000000(Rd.s+688,52,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+692,53,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+700,90,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+709,91,29);
  Ra.sl[3]=323; /* line # 323 */
  PAS_INSMBOL_PRC_00000000(Rd.s+720,92,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+725,93,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+733,94,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+743,95,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+750,96,29);
  Ra.sl[3]=328; /* line # 328 */
  PAS_INSMBOL_PRC_00000000(Rd.s+758,99,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+767,98,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+777,100,29);
  Ra.sl[3]=335; /* line # 335 */
  PAS_INSMBOL_PRC_00000000(Rd.s+786,101,29);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " nextch "  */
void PAS_INSMBOL_PRC_00000001(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+792;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=424; /* line # 424 */
  V_sy_ch=P_src_inchar();
  V_sy_cmin=V_sy_ch;
  if (V_sy_ch>=65&&V_sy_ch<=90) V_sy_cmin=(C)((SL)V_sy_ch+32);
  if (V_sy_cmin>127) V_sy_cmin=63;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " put_char "  */
void PAS_INSMBOL_PRC_00000002(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+800;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=433; /* line # 433 */
  if (!Lx[0].ub[0]) {
    if (Lx[0].sl[1]<V_sy_string.ub[0]) {
      V_sy_string.c[Lx[0].sl[1]+1]=V_sy_ch;
      Lx[0].sl[1]=Lx[0].sl[1]+1;
    }
    else {
      Ra.sl[3]=441; /* line # 441 */
      P_src_error(Rd.s+812,12,2);
      Lx[0].ub[0]=1;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " test_figures "  */
SL PAS_INSMBOL_PRC_00000003(C F_ch){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+816;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=452; /* line # 452 */
  if (F_ch>=48&&F_ch<=57) Rv0=(SL)F_ch-48;
  else {
    if ((Lx[0].ub[8]&&F_ch>=97)&&F_ch<=102) Rv0=(10+(SL)F_ch)-97;
    else Rv0=-1;
  }
  if (Rv0>=Lx[0].sl[3]) Rv0=-2;
  Ra.sl[3]=457; /* line # 457 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " figures "  */
SL PAS_INSMBOL_PRC_00000004(C F_ch){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+830;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=468; /* line # 468 */
  Rv0=PAS_INSMBOL_PRC_00000003(F_ch);
  if (Rv0==-2) {
    Rv0=0;
    P_src_error(Rd.s+841,16,2);
  }
  Ra.sl[3]=473; /* line # 473 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " ovf_handler "  */
SL PAS_INSMBOL_PRC_00000005(SL F_ierr){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+845;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=483; /* line # 483 */
  Ri.sl[0]=Ri.sl[0]+1;
  if (Ri.sl[0]>10) {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+858,-1,-1,32);
    PAS__WRITE_EOLN();
    PAS__EXIT(2);
  }
  if (F_ierr>=20&&F_ierr<=25) {
    if (!Lx[0].ub[16]) {
      Ra.sl[3]=489; /* line # 489 */
      P_src_error(Rd.s+812,11,2);
      Lx[0].g[3]=1.000000000000000E+000;
      Lx[0].g[4]=1.000000000000000E+000;
      Lx[0].ub[16]=1;
    }
    Ret=1;
  }
  else {
    Ra.sl[3]=496; /* line # 496 */
    Ret=0;
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " insymbol_src "  */
void P_insymbol_src(){
  /* Define the automatic variable space. */
  Blk( Ra, 56 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  G Rv2;
  SL Rv3;
  SL Rv4;
  G Rv5;
  SL Rv6;
  V Rv7;
  register V Rv8;
  SL Rv9;
  register V Rv10;
  UB Rv11;
  UB Rv12;
  SL Rv13;
  register V Rv14;
  C Rv15;
  register G Rgg;
  register P Lx_Sv;
  Lx_Sv=Lx[0];
  Lx[0].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[10]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+40;
  Ra.v[11]=Rd.s+871;
  Ra.v[12]=Rd.s+16;
  Ra.sl[13]=503; /* line # 503 */
  while (V_sy_ch==32)
  PAS_INSMBOL_PRC_00000001();
  Rv0=1;
  Rv1=V_src_control;
  ((SL *)Rv1)[2]=((SL *)Rv1)[3];
  switch (Ri.ub[V_sy_cmin+4]) {
    case 2:
    case 8:Ra.sl[13]=510; /* line # 510 */
    PAS__ESTABLISH(PAS_INSMBOL_PRC_00000005);
    Ra.ub[16]=0;
    V_sy_sym.ub[0]=20;
    V_sy_sym.ub[1]=29;
    Rv2=0.000000000000000E-001;
    Ra.sl[13]=515; /* line # 515 */
    Ra.sl[3]=10;
    Rv3=0;
    Ra.ub[8]=0;
    while (Ri.ub[V_sy_cmin+4]==2){
      Ra.sl[13]=520; /* line # 520 */
      V_sy_sym.ub[0]=2;
      Rv4=(SL)V_sy_cmin-48;
      if (Rv3>0||Rv4>0) Rv3=Rv3+1;
      while (1){
        PAS_INSMBOL_PRC_00000001();
        if (V_sy_cmin!=95)  break;
      }
      if (!Ra.ub[16]) Rv2=Rv2*1.000000000000000E+001+(double)Rv4;
    }
    Ra.sl[13]=527; /* line # 527 */
    if (V_sy_sym.ub[0]==2&&V_sy_ch==35) {
      Rv3=0;
      Ra.sl[3]=(Rv2>0.0?(SL)(Rv2+0.5):(SL)(Rv2-0.5));
      if (Ra.sl[3]<2||Ra.sl[3]>16) {
        Ra.sl[13]=533; /* line # 533 */
        P_src_error(Rd.s+812,14,2);
        Ra.sl[3]=10;
      }
      Ra.ub[8]=1;
      Rv2=0.000000000000000E-001;
      while (1){
        while (1){
          Ra.sl[13]=539; /* line # 539 */
          PAS_INSMBOL_PRC_00000001();
          if (V_sy_cmin!=95)  break;
        }
        Rv4=PAS_INSMBOL_PRC_00000004(V_sy_cmin);
        if ((float)Rv4<(F)0.000000E-01)  break;
        if (!Ra.ub[16]) Rv2=Rv2*(double)Ra.sl[3]+(double)Rv4;
        if (Rv3>0||Rv4>0) Rv3=Rv3+1;
      }
    }
    Ra.sl[13]=548; /* line # 548 */
    Rv5=(double)Ra.sl[3];
    Ra.g[3]=Rv5;
    if (V_sy_ch==46) {
      if (P_src_next_char()==46) {
        Ra.sl[13]=553; /* line # 553 */
        if (V_sy_sym.ub[0]==20) {
          PAS_INSMBOL_PRC_00000001();
          V_sy_sym.ub[0]=21;
        }
        else {
          Ra.sl[13]=558; /* line # 558 */
          Rv0=0;
        }
      }
      else {
        while (1){
          PAS_INSMBOL_PRC_00000001();
          if (V_sy_cmin!=95)  break;
        }
        Rv5=(double)Ra.sl[3];
        Ra.g[3]=Rv5;
        Ra.g[4]=1.000000000000000E+000;
        Ra.sl[13]=563; /* line # 563 */
        if (PAS_INSMBOL_PRC_00000003(V_sy_cmin)<0) Rv0=0;
        else {
          V_sy_sym.ub[0]=4;
          while (1){
            Ra.sl[13]=569; /* line # 569 */
            if (Ra.g[4]!=1.000000000000000E+000) while (1){
              PAS_INSMBOL_PRC_00000001();
              if (V_sy_cmin!=95)  break;
            }
            Rv4=PAS_INSMBOL_PRC_00000004(V_sy_cmin);
            if (Rv4<0)  break;
            Ra.g[4]=Ra.g[4]/Rv5;
            Ra.sl[13]=574; /* line # 574 */
            Rv2=Rv2+Ra.g[4]*(double)Rv4;
            Rv3=Rv3+1;
          }
        }
      }
    }
    Ra.sl[13]=581; /* line # 581 */
    if (V_sy_cmin==35) PAS_INSMBOL_PRC_00000001();
    if (V_sy_sym.ub[0]!=20&&V_sy_sym.ub[0]!=21) {
      if (V_sy_cmin==101) {
        Ra.sl[13]=587; /* line # 587 */
        V_sy_sym.ub[0]=4;
        PAS_INSMBOL_PRC_00000001();
        if (V_sy_ch==43||V_sy_ch==45) {
          if (V_sy_ch==45) Ra.g[3]=1.000000000000000E+000/Ra.g[3];
          Ra.sl[13]=592; /* line # 592 */
          PAS_INSMBOL_PRC_00000001();
        }
        Rv6=0;
        while (Ri.ub[V_sy_cmin+4]==2){
          Ra.sl[13]=598; /* line # 598 */
          Rv6=Rv6*10+((SL)V_sy_ch-48);
          PAS_INSMBOL_PRC_00000001();
        }
        Ra.sl[13]=603; /* line # 603 */
        Ra.g[4]=1.000000000000000E+000;
        while (Rv6!=0&&!Ra.ub[16])
        if (Rv6&1) {
          Ra.sl[13]=608; /* line # 608 */
          Rv6=Rv6-1;
          Ra.g[4]=Ra.g[4]*Ra.g[3];
        }
        else {
          Ra.sl[13]=613; /* line # 613 */
          Rv6=Rv6/2;
          Ra.g[3]=(Rgg=Ra.g[3],Rgg*Rgg);
        }
        if (!Ra.ub[16]) Rv2=Rv2*Ra.g[4];
      }
      Ra.sl[13]=620; /* line # 620 */
      if (Ra.ub[16]) Rv2=0.000000000000000E-001;
      if (V_sy_sym.ub[0]==2) {
        if (Rv2<=4.294967295000001E+009&&Rv2>=-2.147483648000001E+009) {
          Ra.sl[13]=626; /* line # 626 */
          if (Rv2>2.147483647000000E+009) V_sy_ival=(int)(4.294967295000001E+009-
          Rv2)+1;
          else V_sy_ival=(int)(Rv2);
          V_sy_rval=(double)V_sy_ival;
          if ((V_sy_label_flag&&Ri.ub[V_sy_cmin+4]==5)&&P_src_next_char()!=61) {
            Ra.sl[13]=632; /* line # 632 */
            PAS_INSMBOL_PRC_00000001();
            P_ide_int_label();
            V_sy_sym.ub[0]=1;
          }
        }
        else {
          Ra.sl[13]=637; /* line # 637 */
          V_sy_sym.ub[0]=4;
        }
      }
      if (V_sy_sym.ub[0]==4) {
        Ra.sl[13]=642; /* line # 642 */
        V_sy_ival=0;
        if (Rv2>3.402823466385288E+038) V_sy_sym.ub[0]=4;
        else {
          Ra.sl[13]=647; /* line # 647 */
          if (Ra.sl[3]>2) Rv3=Rv3*(int)(log(Rv5)/6.931471805599453E-001)+2;
          else Rv3=Rv3+2;
          if (Rv3>24) V_sy_sym.ub[0]=4;
          else V_sy_sym.ub[0]=3;
        }
      }
      Ra.sl[13]=654; /* line # 654 */
      V_sy_rval=Rv2;
      Rv0=0;
    }
    PAS__REVERT();
    break;
    case 3:Ra.sl[13]=661; /* line # 661 */
    V_sy_ident.ub[0]=0;
    while (1){
      if (V_sy_ident.ub[0]<31) {
        Ra.sl[13]=668; /* line # 668 */
        V_sy_ident.ub[0]=V_sy_ident.ub[0]+1;
        V_sy_ident.c[V_sy_ident.ub[0]]=V_sy_cmin;
      }
      PAS_INSMBOL_PRC_00000001();
      if (Ri.ub[V_sy_cmin+4]!=3&&Ri.ub[V_sy_cmin+4]!=2)  break;
    }
    Ra.sl[13]=674; /* line # 674 */
    Rv7=V_keyword_tree;
    while (1){
      Rv8=Rv7;
      Rv9=P_match(V_sy_ident.s,Rv8);
      Ra.sl[13]=679; /* line # 679 */
      if (Rv9!=0) {
        if (Rv9>0) Rv7=((V *)Rv8)[9];
        else Rv7=((V *)Rv8)[8];
      }
      if (Rv9==0||Rv7==NULL)  break;
    }
    if (Rv7==NULL) {
      Ra.sl[13]=685; /* line # 685 */
      if ((V_sy_label_flag&&Ri.ub[V_sy_cmin+4]==5)&&P_src_next_char()!=61) {
        PAS_INSMBOL_PRC_00000001();
        V_sy_sym.ub[0]=1;
      }
      else {
        Ra.sl[13]=692; /* line # 692 */
        V_sy_sym.ub[0]=0;
      }
      V_sy_sym.ub[1]=29;
    }
    else memcpy(V_sy_sym.s,Rv7+40,2);
    Ra.sl[13]=697; /* line # 697 */
    Rv0=0;
    break;
    case 4:Ra.sl[13]=702; /* line # 702 */
    V_sy_sym.ub[1]=29;
    Rv10=V_src_control;
    Rv11=(1024&((UL *)Rv10)[52])!=0;
    Ra.sl[13]=707; /* line # 707 */
    ((UB *)Rv10)[212]=4;
    ((UL *)Rv10)[52]=((UL *)Rv10)[52]|1024;
    V_sy_sym.ub[0]=5;
    Ra.sl[1]=1;
    Ra.ub[0]=0;
    Ra.sl[13]=712; /* line # 712 */
    Rv12=1;
    while (Rv12){
      PAS_INSMBOL_PRC_00000001();
      while (Ri.ub[V_sy_cmin+4]==10)
      PAS_INSMBOL_PRC_00000001();
      Ra.sl[13]=717; /* line # 717 */
      if (Ri.ub[V_sy_cmin+4]==9) Rv12=0;
      if (V_sy_ch==39) {
        ((UB *)V_src_control)[212]=0;
        PAS_INSMBOL_PRC_00000001();
        Ra.sl[13]=722; /* line # 722 */
        if (V_sy_ch==39) {
          ((UB *)V_src_control)[212]=4;
          PAS_INSMBOL_PRC_00000002();
        }
        else {
          Ra.sl[13]=727; /* line # 727 */
          Rv12=0;
        }
      }
      else {
        if (V_sy_ch==92) {
          PAS_INSMBOL_PRC_00000001();
          Ra.sl[13]=732; /* line # 732 */
          switch (V_sy_cmin) {
            case 34:
            case 39:
            case 92:break;
            case 97:V_sy_ch=7;
            break;
            case 98:V_sy_ch=8;
            break;
            case 101:V_sy_ch=27;
            break;
            case 102:Ra.sl[13]=737; /* line # 737 */
            V_sy_ch=12;
            break;
            case 110:V_sy_ch=10;
            break;
            case 114:V_sy_ch=13;
            break;
            case 116:V_sy_ch=9;
            break;
            case 118:V_sy_ch=11;
            break;
            case 122:Ra.sl[13]=742; /* line # 742 */
            V_sy_ch=0;
            break;
            case 48:
            case 49:
            case 50:
            case 51:
            case 52:
            case 53:
            case 54:
            case 55:
            case 56:
            case 57:Rv9=(SL)V_sy_cmin-48;
            PAS_INSMBOL_PRC_00000001();
            Rv13=3;
            Ra.sl[13]=747; /* line # 747 */
            while ((Rv13>0&&V_sy_cmin>=48)&&V_sy_cmin<=57){
              Rv9=(Rv9*10+(SL)V_sy_cmin)-48;
              PAS_INSMBOL_PRC_00000001();
            }
            Ra.sl[13]=752; /* line # 752 */
            if (Rv9<=255) V_sy_ch=(C)Rv9;
            else {
              V_sy_ch=32;
              P_src_error(Rd.s+812,17,2);
            }
            break;
            default:V_sy_ch=32;
            P_src_error(Rd.s+812,18,2);
            break;
          }
          Ra.sl[13]=758; /* line # 758 */
          PAS_INSMBOL_PRC_00000002();
        }
        else PAS_INSMBOL_PRC_00000002();
      }
    }
    V_sy_string.ub[1]=Ra.sl[1] -1;
    Ra.sl[13]=763; /* line # 763 */
    Rv0=0;
    Rv14=V_src_control;
    if (!Rv11) {
      ((UL *)Rv14)[52]=((UL *)Rv14)[52]&~1024;
      Ra.sl[13]=768; /* line # 768 */
      if (Ri.ub[V_sy_cmin+4]==10) V_sy_ch=32;
    }
    break;
    case 5:Ra.sl[13]=774; /* line # 774 */
    PAS_INSMBOL_PRC_00000001();
    V_sy_sym.ub[1]=29;
    if (V_sy_ch==61) V_sy_sym.ub[0]=23;
    else {
      Ra.sl[13]=779; /* line # 779 */
      V_sy_sym.ub[0]=22;
      Rv0=0;
    }
    break;
    case 6:Ra.sl[13]=786; /* line # 786 */
    PAS_INSMBOL_PRC_00000001();
    V_sy_sym.ub[0]=10;
    if (V_sy_ch==61) V_sy_sym.ub[1]=15;
    else {
      if (V_sy_ch==62) V_sy_sym.ub[1]=18;
      else {
        Ra.sl[13]=793; /* line # 793 */
        V_sy_sym.ub[1]=14;
        Rv0=0;
      }
    }
    break;
    case 7:Ra.sl[13]=800; /* line # 800 */
    PAS_INSMBOL_PRC_00000001();
    V_sy_sym.ub[0]=10;
    if (V_sy_ch==61) V_sy_sym.ub[1]=16;
    else {
      Ra.sl[13]=805; /* line # 805 */
      V_sy_sym.ub[1]=17;
      Rv0=0;
    }
    break;
    case 11:Ra.sl[13]=812; /* line # 812 */
    Rv15=V_sy_ch;
    PAS_INSMBOL_PRC_00000001();
    if (V_sy_ch==Rv15) {
      V_sy_sym.ub[0]=9;
      Ra.sl[13]=817; /* line # 817 */
      V_sy_sym.ub[1]=13;
    }
    else {
      V_sy_sym.ub[0]=13;
      Ra.sl[13]=822; /* line # 822 */
      V_sy_sym.ub[1]=21;
      Rv0=0;
    }
    break;
    case 12:
    case 13:
    case 14:
    case 15:
    case 17:
    case 18:
    case 19:
    case 20:
    case 21:
    case 23:
    case 24:
    case 25:
    case 26:Ra.sl[13]=828; /* line # 828 */
    memcpy(V_sy_sym.s,(Ri.s+Ri.ub[V_sy_cmin+4]*2+110),2);
    break;
    case 16:PAS_INSMBOL_PRC_00000001();
    Ra.sl[13]=833; /* line # 833 */
    if (V_sy_ch==42) {
      V_sy_sym.ub[0]=7;
      V_sy_sym.ub[1]=5;
    }
    else {
      Ra.sl[13]=840; /* line # 840 */
      memcpy(V_sy_sym.s,Ri.s+142,2);
      Rv0=0;
    }
    break;
    case 22:Ra.sl[13]=847; /* line # 847 */
    PAS_INSMBOL_PRC_00000001();
    if (V_sy_ch==62) {
      V_sy_sym.ub[0]=26;
      V_sy_sym.ub[1]=29;
    }
    else {
      Ra.sl[13]=855; /* line # 855 */
      memcpy(V_sy_sym.s,Ri.s+154,2);
      Rv0=0;
    }
    break;
    case 9:Ra.sl[13]=862; /* line # 862 */
    V_sy_sym.ub[0]=101;
    V_sy_sym.ub[1]=29;
    break;
    case 10:Ra.sl[13]=868; /* line # 868 */
    V_sy_sym.ub[0]=88;
    V_sy_sym.ub[1]=29;
    Rv0=0;
    V_sy_ch=32;
    break;
    default:Ra.sl[13]=875; /* line # 875 */
    V_sy_sym.ub[0]=102;
    V_sy_sym.ub[1]=29;
    Rv0=0;
    if (V_sy_ch!=32) P_src_error(Rd.s+812,13,2);
    V_sy_ch=32;
    break;
  }
  Ra.sl[13]=882; /* line # 882 */
  if (Rv0) PAS_INSMBOL_PRC_00000001();
  PAS__curr_cntx=Ra.v[10];
  Lx[0]=Lx_Sv;
}


/* Procedure/Function : " m_expression "  */
void PAS_INSMBOL_m_expression(){

  /* Code of procedure/function */
}


/* Procedure/Function : " pragma_mstate "  */
void PAS_INSMBOL_PRC_00000006(V F_p_src){
  /* Define the automatic variable space. */
  Blk( Ra, 1048 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  UL Rv2;
  UB Rv3;
  UB Rv4;
  register V Rv5;
  SL Rv6;
  register UB Rv7;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  PAS__STR_TO_STR(Ra.s,Rd.s+885);
  Ra.ub[257]=255;
  PAS__STR_TO_STR(Ra.s+257,Rd.s+885);
  Ra.ub[514]=255;
  PAS__STR_TO_STR(Ra.s+514,Rd.s+885);
  Ra.ub[771]=255;
  PAS__STR_TO_STR(Ra.s+771,Rd.s+885);
  Ra.v[257]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+1028;
  Ra.v[258]=Rd.s+1142;
  Ra.v[259]=Rd.s+16;
  Ra.sl[260]=976; /* line # 976 */
  Rv0=V_sy_label_flag;
  V_sy_label_flag=0;
  Rv1=F_p_src;
  Rv2=((UL *)Rv1)[52];
  Ra.sl[260]=981; /* line # 981 */
  while (V_sy_sym.ub[0]==0){
    Rv3=0;
    Rv4=0;
    while (1){
      Ra.sl[260]=986; /* line # 986 */
      Rv3=P_match(V_sy_ident.s,(Ri.s+Rv4*32+164))==0;
      if (Rv3||Rv4==21)  break;
      Rv4=Rv4+1;
    }
    P_insymbol_src();
    Ra.sl[260]=991; /* line # 991 */
    switch (Rv4) {
      case 0:if (V_sy_sym.ub[0]==5) {
        if (V_sy_ident.ub[0]>0) {
          Ra.sl[260]=996; /* line # 996 */
          Rv5=V_lst_current;
          if (((UB *)((V *)Rv5)[1])[1]>0) P_lst_eoln();
          Ra.sl[260]=1001; /* line # 1001 */
          PAS__STR_TO_STR(Ra.s,V_sy_string.s);
          P_insymbol_src();
          if (((V *)Rv5)[2]!=NULL) PAS__STR_TO_STR(Ra.s+257,((V *)Rv5)[2]);
          if (((V *)Rv5)[4]!=NULL) PAS__STR_TO_STR(Ra.s+514,((V *)Rv5)[4]);
          if (((V *)Rv5)[5]!=NULL) PAS__STR_TO_STR(Ra.s+771,((V *)Rv5)[5]);
          Ra.sl[260]=1007; /* line # 1007 */
          P_lst_open(&V_lst_current, Ra.s,Ra.s+257,Ra.s+514,Ra.s+771,132,-1,0,0,0,
          &Rv6);
          Ra.sl[260]=1019; /* line # 1019 */
          if (Rv6!=0) {
            if (!V_sy_init_mod) P_src_error(Rd.s+1159,905,2);
            else {
              Ra.sl[260]=1024; /* line # 1024 */
              Rv2=Rv2&~1;
            }
          }
          else {
            if (((SL *)Rv1)[6]<((SL *)Rv1)[5]) ((SL *)Rv1)[6]=((SL *)Rv1)[5];
            Rv2=Rv2|1;
          }
        }
        else {
          Ra.sl[260]=1032; /* line # 1032 */
          Rv2=Rv2&~1;
        }
      }
      else {
        if (((SL *)Rv1)[6]<((SL *)Rv1)[5]) ((SL *)Rv1)[6]=((SL *)Rv1)[5];
        Rv2=Rv2|1;
      }
      break;
      case 1:Ra.sl[260]=1040; /* line # 1040 */
      Rv2=Rv2&~1;
      break;
      case 2:Rv2=Rv2|32;
      break;
      case 3:Rv2=Rv2&~32;
      break;
      case 4:Ra.sl[260]=1047; /* line # 1047 */
      if (V_sy_sym.ub[0]==22) P_insymbol_src();
      if (V_sy_sym.ub[0]==2) {
        ((SL *)Rv1)[6]=V_sy_ival;
        P_insymbol_src();
      }
      else {
        Ra.sl[260]=1053; /* line # 1053 */
        ((SL *)Rv1)[6]=1;
      }
      break;
      case 5:Ra.sl[260]=1058; /* line # 1058 */
      if (V_sy_sym.ub[0]==22) P_insymbol_src();
      if (V_sy_sym.ub[0]==2) {
        ((SL *)Rv1)[9]=V_sy_ival;
        P_insymbol_src();
      }
      else {
        Ra.sl[260]=1064; /* line # 1064 */
        ((SL *)Rv1)[9]=1;
      }
      if (V_sy_sym.ub[0]==22) P_insymbol_src();
      if (V_sy_sym.ub[0]==2) {
        ((SL *)Rv1)[10]=V_sy_ival;
        P_insymbol_src();
      }
      else((SL *)Rv1)[10]=255;
      break;
      case 6:Ra.sl[260]=1071; /* line # 1071 */
      V_cmp_macf=1;
      break;
      case 7:V_cmp_macf=0;
      break;
      case 8:V_cmp_cobj=1;
      break;
      case 9:V_cmp_cobj=0;
      break;
      case 10:Ra.sl[260]=1078; /* line # 1078 */
      if (V_sy_sym.ub[0]==5) {
        if (V_sy_ident.ub[0]>0) {
          if (V_pas_obj!=NULL) P_binary_objf_close();
          Rv7=V_sy_string.ub[1];
          V_pas_obj=PAS__NEW((SL)Rv7+2);
          ((UB *)V_pas_obj)[0]=Rv7;
          Ra.sl[260]=1083; /* line # 1083 */
          PAS__STR_TO_STR(V_pas_obj,V_sy_string.s);
          P_insymbol_src();
          V_cmp_objf=1;
        }
        else P_src_error(Rd.s+1159,904,4);
      }
      else {
        Ra.sl[260]=1089; /* line # 1089 */
        if (V_cmp_objf) P_binary_objf_close();
        V_cmp_objf=0;
      }
      break;
      case 11:if (V_cmp_objf) {
        Ra.sl[260]=1095; /* line # 1095 */
        P_binary_objf_close();
        V_cmp_objf=0;
      }
      break;
      case 12:V_cmp_bltt=1;
      break;
      case 13:V_cmp_bltt=0;
      break;
      case 14:Ra.sl[260]=1102; /* line # 1102 */
      if (V_sy_sym.ub[0]==2) {
        V_cmp_traceopt=V_sy_ival;
        Ra.sl[260]=1107; /* line # 1107 */
        P_insymbol_src();
      }
      else P_src_error(Rd.s+1159,906,3);
      break;
      case 15:V_cmp_debugopt=1;
      break;
      case 16:Ra.sl[260]=1112; /* line # 1112 */
      V_cmp_debugopt=0;
      break;
      case 17:V_cmp_range=1;
      break;
      case 18:V_cmp_range=0;
      break;
      case 19:Ra.sl[260]=1117; /* line # 1117 */
      P_generation_pragma();
      break;
      case 20:V_cmp_cmpdbg=1;
      break;
      case 21:V_cmp_cmpdbg=0;
      break;
      default:Ra.sl[260]=1123; /* line # 1123 */
      P_src_error_s(Rd.s+1159,901,1, V_sy_ident.s,NULL);
      break;
    }
    if (V_sy_sym.ub[0]==18) P_insymbol_src();
  }
  if (V_sy_sym.ub[0]!=19) P_src_error(Rd.s+1159,21,2);
  Ra.sl[260]=1128; /* line # 1128 */
  ((UL *)Rv1)[52]=Rv2;
  V_sy_label_flag=Rv0;
  PAS__curr_cntx=Ra.v[257];
}


/* Procedure/Function : " include_mstate "  */
void PAS_INSMBOL_PRC_00000007(UB F_bincl, UB F_bnsferr){
  /* Define the automatic variable space. */
  Blk( Ra, 536 );

  /* Local variable stored in C variable */
  V Rv0;
  SL Rv1;
  SL Rv2;
  register V Rv3;
  register V Rv4;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[65]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+260;
  Ra.v[66]=Rd.s+1163;
  Ra.v[67]=Rd.s+16;
  Ra.sl[68]=1146; /* line # 1146 */
  if (V_sy_sym.ub[0]==5) {
    Rv0=NULL;
    PAS__STR_TO_STR(Ra.s,V_sy_string.s);
    Ra.sl[68]=1151; /* line # 1151 */
    Rv1=PAS__NINDEX_CHA(Ra.s+2,(SL)Ra.ub[1],46,-1,-1,1);
    if (Rv1==0) PAS__STR_TO_STR(Ra.s,PAS__CON_STR_STR(Ra.s+276,Ra.s,Rd.s+1179));
    P_insymbol_src();
    P_src_open(&Rv0, Ra.s,0, &Rv2);
    if (Rv2==0) {
      Ra.sl[68]=1157; /* line # 1157 */
      Rv3=Rv0;
      ((V *)Rv3)[1]=V_src_control;
      ((SL *)Rv3)[5]=((SL *)V_src_control)[5];
      if (F_bincl) ((SL *)Rv3)[5]=((SL *)Rv3)[5]+1;
      Ra.sl[68]=1162; /* line # 1162 */
      ((SL *)Rv3)[6]=((SL *)V_src_control)[6];
      ((SL *)Rv3)[4]=((SL *)V_src_control)[4];
      ((SL *)Rv3)[9]=((SL *)V_src_control)[9];
      ((SL *)Rv3)[10]=((SL *)V_src_control)[10];
      ((UL *)Rv3)[52]=((UL *)Rv3)[52]|((UL *)V_src_control)[52]&103;
      Ra.sl[68]=1170; /* line # 1170 */
      if (V_sy_sym.ub[0]==18) {
        P_insymbol_src();
        PAS_INSMBOL_PRC_00000006(Rv0);
      }
      else {
        Ra.sl[68]=1176; /* line # 1176 */
        if (V_sy_sym.ub[0]!=19) P_src_error(Rd.s+1187,21,2);
      }
      if (!F_bincl) P_src_end_of_line();
      V_src_control=Rv0;
      if (V_cmp_trace>0) V_cmp_tracecount=0;
      P_compile_set_title();
      Ra.sl[68]=1181; /* line # 1181 */
      P_set_srcfilespc((SL)F_bincl);
      V_sy_ch=32;
      V_sy_sym.ub[0]=99;
      if (!F_bincl) {
        Ra.sl[68]=1186; /* line # 1186 */
        Rv4=V_src_control;
        Rv0=((V *)Rv4)[1];
        ((V *)Rv4)[1]=((V *)Rv0)[1];
        Ra.sl[68]=1191; /* line # 1191 */
        P_src_close(&Rv0,1);
      }
    }
    else {
      P_lst_newline();
      Ra.sl[68]=1196; /* line # 1196 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+1191,-1,-1,32);
      PAS__WRITE_INT(Rv2,3,0);
      PAS__WRITE_EOLN();
      P_lst_newline();
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+1213,-1,-1,32);
      PAS__WRITE_STR(Ra.s,-1,-1,32);
      PAS__WRITE_STR(Rd.s+1237,-1,-1,32);
      PAS__WRITE_EOLN();
      PAS__GET_RTLMSG(Rv2, Ra.s);
      P_lst_newline();
      Ra.sl[68]=1201; /* line # 1201 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+1241,-1,-1,32);
      PAS__WRITE_STR(Ra.s,-1,-1,32);
      PAS__WRITE_EOLN();
      while ((V_sy_sym.ub[0]!=19&&V_sy_sym.ub[0]!=89)&&V_sy_sym.ub[0]!=101)
      P_insymbol_src();
      if (F_bnsferr) {
        Ra.sl[68]=1206; /* line # 1206 */
        P_src_error(Rd.s+1187,902,4);
      }
      else P_src_error(Rd.s+1187,902,3);
    }
  }
  else {
    Ra.sl[68]=1211; /* line # 1211 */
    P_src_error(Rd.s+1187,903,4);
  }
  PAS__curr_cntx=Ra.v[65];
}


/* Procedure/Function : " endfile_mstate "  */
void PAS_INSMBOL_PRC_00000008(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1258;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=1220; /* line # 1220 */
  P_set_srcfilespc(-1);
  Rv0=V_src_control;
  if (((V *)Rv0)[1]==NULL) V_sy_sym.ub[0]=89;
  else {
    Ra.sl[3]=1226; /* line # 1226 */
    Rv1=V_src_control;
    V_src_control=((V *)Rv1)[1];
    P_src_close(&Rv1,1);
    V_sy_ch=32;
    P_compile_set_title();
  }
  Ra.sl[3]=1232; /* line # 1232 */
  if (V_cmp_trace>0) V_cmp_tracecount=0;
  if (V_sy_sym.ub[0]==89) V_pas_compile=0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " insymbol "  */
void P_insymbol(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1274;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=1259; /* line # 1259 */
  P_insymbol_src();
  while (V_sy_sym.ub[0]>=98){
    Rv0=V_sy_sym.ub[0];
    if (V_sy_sym.ub[0]!=101) {
      Ra.sl[3]=1264; /* line # 1264 */
      P_insymbol_src();
    }
    switch (Rv0) {
      case 98:
      case 99:PAS_INSMBOL_PRC_00000007(Rv0==98, V_sy_init_mod);
      break;
      case 101:Ra.sl[3]=1269; /* line # 1269 */
      PAS_INSMBOL_PRC_00000008();
      break;
      case 100:PAS_INSMBOL_PRC_00000006(V_src_control);
      break;
      default:Ra.sl[3]=1283; /* line # 1283 */
      P_src_error(Rd.s+1286,997,3);
      break;
    }
    if (V_sy_sym.ub[0]!=89) P_insymbol_src();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " skip_symbol "  */
void P_skip_symbol(UB F_tosymbol, UB F_errflg){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1290;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=1293; /* line # 1293 */
  while (V_sy_sym.ub[0]!=F_tosymbol&&V_sy_sym.ub[0]!=89){
    P_insymbol();
    switch (V_sy_sym.ub[0]) {
      case 42:
      case 55:
      case 57:
      case 72:Ra.sl[3]=1300; /* line # 1300 */
      P_skip_symbol(73,0);
      P_insymbol();
      break;
      case 14:P_skip_symbol(15,0);
      P_insymbol();
      break;
      case 16:Ra.sl[3]=1308; /* line # 1308 */
      P_skip_symbol(17,0);
      P_insymbol();
      break;
      case 49:P_skip_symbol(50,0);
      P_insymbol();
      break;
      case 73:Ra.sl[3]=1315; /* line # 1315 */
      if (F_tosymbol==47||F_errflg) goto L_l_0;
      break;
      default:break;
    }
  }
L_l_0: ;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " insy_init "  */
void P_insy_init(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1303;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=1329; /* line # 1329 */
  P_lst_g_init(Rd.s+1314,Rd.s+1316,&Rv0);
  if (Rv0==0) {
    Ra.sl[3]=1334; /* line # 1334 */
    P_err_init(Rd.s+1371);
    P_src_init(Rd.s+1392,Rd.s+1399);
    Ra.sl[3]=1339; /* line # 1339 */
    if (V_src_control==NULL) {
      V_error_result=4;
      V_emergency_stop=1;
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+1417,-1,-1,32);
      PAS__WRITE_STR(Rd.s+1399,-1,-1,32);
      PAS__WRITE_STR(Rd.s+1441,-1,-1,32);
      PAS__WRITE_EOLN();
    }
    else {
      Ra.sl[3]=1350; /* line # 1350 */
      PAS_INSMBOL_set_keyword_tree();
      V_proc_seq=0;
      V_srf_free=NULL;
      V_srf_list=NULL;
      Ra.sl[3]=1357; /* line # 1357 */
      P_ide_init();
      P_set_srcfilespc(1);
      Ra.sl[3]=1363; /* line # 1363 */
      V_sy_ch=32;
      V_sy_label_flag=0;
    }
  }
  else {
    Ra.sl[3]=1371; /* line # 1371 */
    V_error_result=4;
    V_emergency_stop=1;
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+1458,-1,-1,32);
    PAS__WRITE_STR(Rd.s+1314,-1,-1,32);
    PAS__WRITE_STR(Rd.s+1482,-1,-1,32);
    PAS__WRITE_EOLN();
  }
  PAS__curr_cntx=Ra.v[0];
}
