#
#       Makefile for cpas_lib.
#
#
include $(PAS_DIR)/system.make
#
OBJS = cpas__error.o cpas__crtl.o cpas__signal.o cpas__ifpow.o cpas__igpow.o\
cpas__iipow.o cpas__ionum.o cpas__iostr.o cpas__physic.o cpas__string.o\
cpas__std.o cpas__timcht.o cpas__timstr.o cpas__ioenm.o cpas__setope.o\
cpas__dir.o cpas__random.o  cpas__hyp_f.o cpas__hyp_g.o\
cpas_b__lst.o cpas_b__err.o cpas_b__src.o cpas_b__vls.o cpas_b__vsr.o \
cpas_d__sdir1.o cpas_d__sdir2.o
#
all:	$(LIB_DIR)/libcpas.a \
	$(PAS_DIR)/gen_msgfile $(PAS_DIR)/check_env $(PAS_DIR)/exa_msg \
	$(PAS_DIR)/std_files $(PAS_DIR)/es_run $(PAS_DIR)/es_arg \
	$(PAS_DIR)/cp2b $(BIN_DIR)/cpsh
#
$(LIB_DIR)/libcpas.a:$(OBJS)
	ar -r $(LIB_DIR)/libcpas.a $(OBJS)
#
$(PAS_DIR)/gen_msgfile: gen_msgfile.c
	$(CC) $(CFLAGS) $(INC) gen_msgfile.c $(LIB) -o $(PAS_DIR)/gen_msgfile
#
$(PAS_DIR)/exa_msg: exa_msg.c
	$(CC) $(CFLAGS) $(INC) exa_msg.c $(LIB) -o $(PAS_DIR)/exa_msg
#
$(PAS_DIR)/check_env: cpas_check_env.c
	$(CC) $(CFLAGS) $(INC) cpas_check_env.c $(LIB) -o $(PAS_DIR)/check_env
#
$(PAS_DIR)/std_files: std_files.c
	$(CC) $(CFLAGS) $(INC) std_files.c $(LIB) -o $(PAS_DIR)/std_files
#
$(PAS_DIR)/es_run: es_run.c
	$(CC) $(CFLAGS) $(INC) es_run.c $(LIB) -o $(PAS_DIR)/es_run
#
$(PAS_DIR)/es_arg: es_arg.c
	$(CC) $(CFLAGS) $(INC) es_arg.c $(LIB) -o $(PAS_DIR)/es_arg
#
$(PAS_DIR)/cp2b: cp2b.c
	$(CC) $(CFLAGS) $(INC) cp2b.c $(LIB) -o $(PAS_DIR)/cp2b
#
$(BIN_DIR)/cpsh: cpsh_shell.c
	$(CC) $(CFLAGS) $(INC) cpsh_shell.c $(LIB) -o $(BIN_DIR)/cpsh
#
clean:
	rm *.o $(LIB_DIR)/libcpas.a
#
end:
