/*  P A S - P. WOLFERS SOFTWARE: V3.1-A1 OF 30-NOV-2014 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long long int

/* Include the PAS environment file. */
#include "cpas_defs.h"

/* Define the local data section. */
static Blk( Rd, 152 ) = {
 19,  19,  80,  65,  83,  69,  78,  86,  58,  99, 112,  97, 115,  95, 114, 116,
108,  46, 101, 114, 114,   5,   5,  32,  42,  42,  42,  32,   9,   9,  32,  68,
101, 116, 101,  99, 116, 101, 100,   9,   9,  32,  32,  32,  99,  97, 108, 108,
101, 100,  11,  11,  32,  97, 116,  32, 108, 105, 110, 101,  32,  35,  32,   4,
  4,  32, 111, 102,  32,   9,   9,  32, 105, 110,  32, 102, 105, 108, 101,  32,
 36,  36,  32,  83, 116, 111, 112,  32, 111, 110,  32,  66,  97, 100,  32,  66,
 65,  67,  75,  95,  84,  82,  65,  67,  73,  78,  71,  32,  83,  84,  65,  67,
 75,  32,  42,  42,  42,  42,  27,  27,  32,  42,  42,  42,  32,  67,  80,  65,
 83,  32,  82, 117, 110,  32,  84, 105, 109, 101,  32,  69, 114, 114, 111, 114,
 32,  35,  32,   0,   0,   0,   0,   0
};

/* Define the local static Initialized section. */
static Blk( Ri, 8 ) = {
  0,   0,   0,   0,   0,   0,   0,   0
};

/* Declaration of external variables. */
extern SL PAS__iostatus;
extern V PAS__f_error;

/* Declaration of global variables. */
V PAS__curr_cntx = NULL;



/* Procedure/Function : " pas__error_getmsg "  */
void PAS__ERROR_GETMSG(SL F_n, V F_msgstr, V F_msgfil){
  /* Define the automatic variable space. */
  Blk( Ra, 80 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;

  /* Code of procedure/function */
  ((UB *)F_msgstr)[1]=0;
  PAS__OPEN(Ri.v,80, F_msgfil,4105,0,-1);
  if (PAS__iostatus==0) {
    PAS__SELECT_INP(Ri.v[0]);
    PAS__READ_BIN(Ra.s);
    Rv0=Ra.uw[0];
    Rv1=Rv0;
    Rv2=1;
    Rv3=2;
    while (1){
      while (1){
        Rv1=Rv1+1;
        Rv4=Ra.uw[Rv3-1];
        if (F_n==Rv4||Rv4<=0) goto L_l_1;
        Rv3=Rv3+1;
        if (Rv3>40)  break;
      }
      Rv3=1;
      Rv2=Rv2+1;
      if (Rv2>Rv0) goto L_l_0;
      PAS__SELECT_INP(Ri.v[0]);
      PAS__READ_BIN(Ra.s);
    }
L_l_1: ;
    if (Rv4>0) {
      PAS__SEEK(Ri.v[0],Rv1);
      PAS__SELECT_INP(Ri.v[0]);
      PAS__READ_BIN(Ra.s);
      Rv2=80;
      while (Ra.c[Rv2-1]<=32)
      Rv2=Rv2-1;
      if (Rv2>0) {
        ((UB *)F_msgstr)[1]=Rv2;
        while (Rv2>0){
          ((C *)F_msgstr)[Rv2+1]=Ra.c[Rv2-1];
          Rv2=Rv2-1;
        }
      }
    }
L_l_0:
    PAS__CLOSE(Ri.v,0);
  }
}


/* Procedure/Function : " pas__get_rtlmsg "  */
void PAS__GET_RTLMSG(SL F_n, V F_msg){

  /* Code of procedure/function */
  PAS__ERROR_GETMSG(F_n, F_msg,Rd.s);
}


/* Procedure/Function : " pas__error_outmsg "  */
void PAS__ERROR_OUTMSG(V *F_f, SL F_n, V F_msgfil){
  /* Define the automatic variable space. */
  Blk( Ra, 88 );


  /* Code of procedure/function */
  Ra.ub[0]=80;
  PAS__ERROR_GETMSG(F_n, Ra.s,F_msgfil);
  if (Ra.ub[1]>0) {
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_STR(Rd.s+21,-1,-1,32);
    PAS__WRITE_STR(Ra.s,-1,-1,32);
    PAS__WRITE_EOLN();
  }
}


/* Procedure/Function : " pas__back_tracing "  */
void PAS__BACK_TRACING(V *F_f){
  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  register V Rv2;

  /* Code of procedure/function */
  Rv0=1;
  Rv1=PAS__curr_cntx;
  while (Rv1!=NULL){
    Rv2=Rv1;
    if (Rv0) {
      PAS__SELECT_OUT((*F_f));
      PAS__WRITE_STR(Rd.s+28,-1,-1,32);
    }
    else {
      PAS__SELECT_OUT((*F_f));
      PAS__WRITE_STR(Rd.s+39,-1,-1,32);
    }
    Rv0=0;
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_STR(Rd.s+50,-1,-1,32);
    PAS__WRITE_INT(((SL *)Rv2)[3],6,0);
    PAS__WRITE_STR(Rd.s+63,-1,-1,32);
    PAS__WRITE_STR(((V *)Rv2)[1],18,-1,32);
    PAS__WRITE_STR(Rd.s+69,-1,-1,32);
    PAS__WRITE_STR(((V *)Rv2)[2],-1,-1,32);
    PAS__WRITE_EOLN();
    if (Rv1==((V *)Rv2)[0]) {
      PAS__SELECT_OUT((*F_f));
      PAS__WRITE_STR(Rd.s+80,-1,-1,32);
      PAS__WRITE_EOLN();
      PAS__EXIT(4);
    }
    Rv1=((V *)Rv2)[0];
  }
}


/* Procedure/Function : " pas__gen_error_msg "  */
void PAS__GEN_ERROR_MSG(SL F_nerr){

  /* Code of procedure/function */
  PAS__SELECT_OUT(PAS__f_error);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(PAS__f_error);
  PAS__WRITE_STR(Rd.s+118,-1,-1,32);
  PAS__WRITE_INT(F_nerr,4,0);
  PAS__WRITE_EOLN();
  PAS__ERROR_OUTMSG(&PAS__f_error, F_nerr, Rd.s);
  PAS__BACK_TRACING(&PAS__f_error);
  PAS__SELECT_OUT(PAS__f_error);
  PAS__WRITE_EOLN();
}
