/*  P A S - P. WOLFERS SOFTWARE: V3.1-A1 OF 30-NOV-2014 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long long int
#define BASIC_IO   0
#include <dirent.h>
#define Dir_fnm Dir_ptr->d_name
static struct dirent * Dir_ptr;
#include <sys/stat.h>
#define incr_ptr(p,inc) p += inc;
#define cc_wild_pointer( p ) ((V) p)
#define _Open(fn,fl,md) open((char *)(fn),fl,md)
#define _Openr(fn,fl,md) open((char *)(fn),fl,md,"rat=cr","rfm=var")
#define _Remove(fn) remove((char *)(fn))
#define _Getenv(lg) (C *)getenv((char *)(lg))
#define _Setenv(lg,vl,isp) setenv((char *)(lg),(char *)(vl),isp)
#define _UnSetenv(lg) unsetenv((char *)(lg))
#define _Putenv(lgl) putenv((char *)(lgl))
#define _Chdir(dir) chdir((char *)dir)
#define _Getdir(dir,sz) (C *)getcwd((char *)(dir),(size_t)(sz))
#define _Execv(f,p) execv((char *)(f),(char **)(p))
#define _Execvp(f,p) execvp((char *)(f),(char **)(p))
#define _Execve(f,p,e) execve((char *)(f),(char **)(p),(char **)(e))
#define _System(cm) system((char *)(cm))
#define _Pipe(chan) pipe((int *)(chan))
#define _Wait(proc) wait((int *)(proc))
#define _GetUid getuid
#define _GetGid getgid
#define _Access(f,acc) access((char *)(f),acc)
#define _Rename(o,n) rename((char *)(o),(char *)(n))
#define _Opendir( dn ) (void *) opendir( (char *)(dn))
#define _Closedir( df ) closedir( (DIR *) df )
#define _Readdir( df ) (void *) readdir( (DIR *)(df))
#define _ReadLink( l, t, s ) readlink( (char*) l, (char*) t, s )
#define _MakeDir( d, m ) mkdir( (char*) d, m )
#define _RemoveDir( d ) rmdir( (char*) d )
#define _Ttyname( df ) (C *)ttyname( df )

/* Include the PAS environment file. */
#include "cpas_defs.h"

/* Declaration of external variables. */
extern SL PAS__iostatus;

/* Declaration of global variables. */
Blk(PAS__dspc, 264 ) = {
255,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0 };

/* Function/procedure prototypes. */
SL CC_ERROR();
void PAS__ERROR(SL F_ierr);
UB PAS__SET_FILESPC(V F_trg, V F_src, UL F_imod);


/* Procedure/Function : " make_dir "  */
void PAS__MAKE_DIR(V F_dspc, UL F_umsk, SL F_iprot){

  /* Code of procedure/function */
  if (!PAS__SET_FILESPC(PAS__dspc.s,F_dspc,F_umsk)) {
    PAS__iostatus=121;
    if (!(4096&F_umsk)) PAS__ERROR(121);
  }
  else {
    if (_MakeDir(PAS__dspc.s+2,F_iprot)!=0) {
      PAS__iostatus=CC_ERROR();
      if (!(4096&F_umsk)) PAS__ERROR(PAS__iostatus);
    }
  }
}


/* Procedure/Function : " remove_dir "  */
void PAS__REMOVE_DIR(V F_dspc, UL F_umsk){

  /* Code of procedure/function */
  if (!PAS__SET_FILESPC(PAS__dspc.s,F_dspc,F_umsk)) {
    PAS__iostatus=121;
    if (!(4096&F_umsk)) PAS__ERROR(121);
  }
  else {
    if (_RemoveDir(PAS__dspc.s+2)!=0) {
      PAS__iostatus=CC_ERROR();
      if (!(4096&F_umsk)) PAS__ERROR(PAS__iostatus);
    }
  }
}


/* Procedure/Function : " open_dir "  */
void PAS__OPEN_DIR(V *F_df, V F_dspc, UL F_umsk){

  /* Code of procedure/function */
  if (!PAS__SET_FILESPC(PAS__dspc.s,F_dspc,F_umsk)) {
    PAS__iostatus=121;
    if (!(4096&F_umsk)) PAS__ERROR(121);
  }
  else {
    (*F_df)=_Opendir(PAS__dspc.s+2);
    if ((*F_df)==NULL) {
      PAS__iostatus=CC_ERROR();
      if (!(4096&F_umsk)) PAS__ERROR(PAS__iostatus);
    }
    else PAS__iostatus=0;
  }
}


/* Procedure/Function : " close_dir "  */
void PAS__CLOSE_DIR(V *F_df){

  /* Code of procedure/function */
  PAS__iostatus=_Closedir((*F_df));
  if (PAS__iostatus<0) PAS__ERROR(CC_ERROR());
}


/* Procedure/Function : " read_dir "  */
void PAS__READ_DIR(V F_df, V F_str, SL *F_ierr){
  /* Local variable stored in C variable */
  SL Rv0;
  C Rv1;

  /* Code of procedure/function */
  Dir_ptr=_Readdir(F_df);
  if (Dir_ptr==NULL) (*F_ierr)=-1;
  else {
    (*F_ierr)=0;
    Rv0=0;
    while (1){
      Rv1=((C *)Dir_fnm)[Rv0];
      if ((SL)Rv1==0||Rv0>=((UB *)F_str)[0])  break;
      Rv0=Rv0+1;
      ((C *)F_str)[Rv0+1]=Rv1;
    }
    ((UB *)F_str)[1]=Rv0;
    (*F_ierr)=(SL)(Rv0>=((UB *)F_str)[0]);
  }
}
