/*  P A S - P. WOLFERS SOFTWARE: V3.0-A OF 31-OCT-2014 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long long int

/* Include the PAS environment file. */
#include "cpas_defs.h"
static P Lx[1];

/* Define the local data section. */
static Blk( Rd, 1480 ) = {
 14,  14, 115, 101, 116,  95, 115, 114,  99, 102, 105, 108, 101, 115, 112,  99,
 60,  60,  47, 104, 111, 109, 101,  47, 112, 105, 101, 114, 114, 101,  47,  83,
111, 102, 116,  47,  99, 112, 115, 104,  95, 107, 105, 116, 115,  47,  99, 112,
 97, 115,  99,  97, 108,  95,  86,  51,  95,  65,  95, 115, 114,  99,  47, 112,
 99, 109, 112,  95, 105, 110, 115, 121, 109,  98,  46, 112,  97, 115,   3,   3,
 84,  84,  58,  17,  17,  99, 111, 109, 112, 105, 108, 101,  95, 115, 101, 116,
 95, 116, 105, 116, 108, 101,   3,   3,  84,  84,  58,  29,  29,  32,  84, 104,
101,  32,  67, 117, 114, 114, 101, 110, 116,  32,  83, 111, 117, 114,  99, 101,
 32,  70, 105, 108, 101,  32, 105, 115,  32,  34,   2,   2,  34,  46,  17,  17,
 99, 111, 109, 112, 105, 108, 101,  95, 115, 101, 116,  95, 115,  98, 116, 116,
108,  33,  33,  32,  84, 104, 101,  32,  67, 117, 114, 114, 101, 110, 116,  32,
 67, 111, 109, 112, 105, 108, 101, 100,  32,  77, 111, 100, 117, 108, 101,  32,
105, 115,  32,  34,   2,   2,  34,  46,  10,  10, 115, 101, 116, 107, 101, 121,
119, 111, 114, 100,  16,  16, 115, 101, 116,  95, 107, 101, 121, 119, 111, 114,
100,  95, 116, 114, 101, 101,   2,   2, 111, 114,   3,   3, 120, 111, 114,   3,
  3,  97, 110, 100,   3,   3, 110, 111, 116,   3,   3, 100, 105, 118,   3,   3,
109, 111, 100,   3,   3, 114, 101, 109,   2,   2, 105, 110,   3,   3, 110, 105,
108,   5,   5, 108,  97,  98, 101, 108,   4,   4, 103, 111, 116, 111,   4,   4,
116, 121, 112, 101,   5,   5,  99, 111, 110, 115, 116,  14,  14, 117, 115, 101,
114,  95, 115, 116,  97, 116, 101, 109, 101, 110, 116,   3,   3, 118,  97, 114,
  6,   6, 105, 110,  95, 118,  97, 114,   7,   7, 111, 117, 116,  95, 118,  97,
114,   7,   7, 112, 114, 105, 118,  97, 116, 101,   6,   6,  97,  99,  99, 101,
115, 115,   4,   4, 102, 105, 108, 101,   5,   5,  97, 114, 114,  97, 121,   6,
  6, 114, 101,  99, 111, 114, 100,   3,   3, 115, 101, 116,   3,   3, 117, 115,
101,   3,   3, 110, 101, 119,   4,   4, 110, 101, 119, 104,   7,   7, 100, 105,
115, 112, 111, 115, 101,   4,   4, 111, 112, 101, 110,   5,   5, 114, 101, 115,
101, 116,   7,   7, 114, 101, 119, 114, 105, 116, 101,   6,   6,  97, 112, 112,
101, 110, 100,   4,   4, 114, 101,  97, 100,   6,   6, 114, 101,  97, 100, 108,
110,   5,   5, 114, 101,  97, 100, 118,   5,   5, 119, 114, 105, 116, 101,   7,
  7, 119, 114, 105, 116, 101, 108, 110,   6,   6, 119, 114, 105, 116, 101, 118,
  7,   7, 112, 114, 111, 103, 114,  97, 109,   6,   6, 109, 111, 100, 117, 108,
101,   9,   9, 112, 114, 111,  99, 101, 100, 117, 114, 101,   8,   8, 102, 117,
110,  99, 116, 105, 111, 110,   6,   6, 114, 101, 116, 117, 114, 110,   7,   7,
102, 111, 114, 119,  97, 114, 100,   6,   6, 115, 116,  97, 116, 105,  99,   6,
  6, 103, 108, 111,  98,  97, 108,   6,   6, 112,  97,  99, 107, 101, 100,   8,
  8, 101, 120, 116, 101, 114, 110,  97, 108,   8,   8, 115, 116,  97, 110, 100,
 97, 114, 100,   6,   6, 105, 110, 108, 105, 110, 101,   5,   5,  98, 101, 103,
105, 110,   2,   2, 105, 102,   4,   4, 116, 104, 101, 110,   4,   4, 101, 108,
115, 101,   5,   5, 119, 104, 105, 108, 101,   6,   6, 114, 101, 112, 101,  97,
116,   5,   5, 117, 110, 116, 105, 108,   3,   3, 102, 111, 114,   4,   4, 108,
111, 111, 112,   4,   4, 101, 120, 105, 116,   4,   4,  99,  97, 115, 101,   4,
  4, 119, 105, 116, 104,   3,   3, 101, 110, 100,   9,   9, 111, 116, 104, 101,
114, 119, 105, 115, 101,   2,   2, 111, 102,   2,   2, 100, 111,   2,   2, 116,
111,   6,   6, 100, 111, 119, 110, 116, 111,   7,   7,  37, 100, 101, 102, 105,
110, 101,   9,   9,  37, 117, 110, 100, 101, 102, 105, 110, 101,   3,   3,  37,
105, 102,   6,   6,  37, 105, 102, 100, 101, 102,   8,   8,  37, 105, 102, 117,
110, 100, 101, 102,   5,   5,  37, 101, 108, 115, 101,   6,   6,  37, 101, 110,
100, 105, 102,   7,   7,  37,  99, 104,  97, 105, 110, 101,   8,   8,  37, 105,
110,  99, 108, 117, 100, 101,   7,   7,  37, 112, 114,  97, 103, 109,  97,   4,
  4,  37, 101, 111, 102,   6,   6, 110, 101, 120, 116,  99, 104,   8,   8, 112,
117, 116,  95,  99, 104,  97, 114,   4,   4,  73,  78,  83,  89,  12,  12, 116,
101, 115, 116,  95, 102, 105, 103, 117, 114, 101, 115,   7,   7, 102, 105, 103,
117, 114, 101, 115,   4,   4,  70,  73,  71,  85,  12,  12, 105, 110, 115, 121,
109,  98, 111, 108,  95, 115, 114,  99, 255,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,  13,  13, 112, 114,  97, 103, 109,
 97,  95, 109, 115, 116,  97, 116, 101,   4,   4,  80,  82,  65,  71,  14,  14,
105, 110,  99, 108, 117, 100, 101,  95, 109, 115, 116,  97, 116, 101,   4,   4,
 46, 112,  97, 115,   4,   4,  73,  78,  67,  76,  20,  20,  32,  79, 112, 101,
110,  32,  69, 114, 114, 111, 114,  32,  40,  82,  84,  76,  41,  32,  35,  32,
 22,  22,  32, 102, 111, 114,  32, 116, 104, 101,  32,  83, 111, 117, 114,  99,
101,  32, 102, 105, 108, 101,  32,  34,   2,   2,  34,  46,  15,  15,  32,  82,
 84,  76,  32, 109, 101, 115, 115,  97, 103, 101,  32,  58,  32,  14,  14, 101,
110, 100, 102, 105, 108, 101,  95, 109, 115, 116,  97, 116, 101,   8,   8, 105,
110, 115, 121, 109,  98, 111, 108,   4,   4,  77,  65,  83,  89,  11,  11, 115,
107, 105, 112,  95, 115, 121, 109,  98, 111, 108,   9,   9, 105, 110, 115, 121,
 95, 105, 110, 105, 116,   0,   0,  52,  52,  32,  80,  32,  65,  32,  83,  32,
 45,  32,  80,  46,  32,  87,  79,  76,  70,  69,  82,  83,  32,  83,  79,  70,
 84,  87,  65,  82,  69,  58,  32,  86,  51,  46,  48,  45,  65,  32,  79,  70,
 32,  51,  49,  45,  79,  67,  84,  45,  50,  48,  49,  52,  32,  19,  19,  67,
 80,  65,  83,  95,  67,  79,  77,  80,  73,  76,  69,  82,  95,  69,  82,  82,
 79,  82,   5,   5,  32,  80,  65,  83,  62,  16,  16,  67,  80,  65,  83,  95,
 69,  78,  86,  73,  82,  79,  78,  77,  69,  78,  84,  22,  22,  32,  80,  65,
 83,  32,  67,  65,  78,  78,  79,  84,  32,  79,  80,  69,  78,  32,  84,  72,
 69,  32,  34,  15,  15,  34,  32,  73,  78,  73,  84,  73,  65,  76,  32,  70,
 73,  76,  69,  46,  22,  22,  32,  80,  65,  83,  32,  67,  65,  78,  78,  79,
 84,  32,  79,  80,  69,  78,  32,  84,  72,  69,  32,  34,  23,  23,  34,  32,
 79,  85,  84,  80,  85,  84,  32,  77,  83,  71,  47,  76,  73,  83,  84,  32,
 70,  73,  76,  69,  46,   0,   0,   0
};

/* Define the local static Initialized section. */
static Blk( Ri, 864 ) = {
  9,  10,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  1,  11,  12,   3,   3,   3,  13,   4,  14,  15,  16,  17,  18,  19,   8,  20,
  2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   5,  21,   6,  22,   7,   1,
  3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
  3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,  23,  24,  25,  26,   3,
  1,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
  3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   1,  11,   1,   1,   0,
 13,  21,  25,  29,  12,  20,  14,  29,  15,  29,   8,   6,   9,  11,  18,  29,
  9,  12,   8,   7,  19,  29,  10,  19,  16,  29,   6,   0,  17,  29,  24,  29,
  7, 108, 105, 115, 116,  95, 111, 110,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  8, 108, 105, 115, 116,  95, 111, 102, 102,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  7, 101,  99, 104, 111,  95, 111, 110,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  8, 101,  99, 104, 111,  95, 111, 102, 102,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  7, 108, 105, 115, 116, 108, 118, 108,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  6, 102, 111, 114, 109,  97, 116,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 10,  99, 112,  95, 108, 105, 115, 116,  95, 111, 110,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 11,  99, 112,  95, 108, 105, 115, 116,  95, 111, 102, 102,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 13,  99, 112,  95,  98, 105, 110,  95, 101, 120, 101,  95, 111, 110,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 14,  99, 112,  95,  98, 105, 110,  95, 101, 120, 101,  95, 111, 102, 102,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  9,  99, 112,  95,  98, 105, 110,  95, 111, 110,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 10,  99, 112,  95,  98, 105, 110,  95, 111, 102, 102,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  9,  99, 112,  95, 101, 120, 101,  95, 111, 110,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 10,  99, 112,  95, 101, 120, 101,  95, 111, 102, 102,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  5, 116, 114,  97,  99, 101,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  8, 100, 101,  98, 117, 103,  95, 111, 110,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  9, 100, 101,  98, 117, 103,  95, 111, 102, 102,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  8, 114,  97, 110, 103, 101,  95, 111, 110,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  9, 114,  97, 110, 103, 101,  95, 111, 102, 102,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 11,  99, 111, 100, 101,  95, 111, 112, 116, 105, 111, 110,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 13, 112,  99, 109, 112,  95, 100, 101,  98, 117, 103,  95, 111, 110,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 14, 112,  99, 109, 112,  95, 100, 101,  98, 117, 103,  95, 111, 102, 102,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32
};

/* Declaration of external variables. */
extern V V_src_control;
extern V V_srf_list;
extern V V_srf_free;
extern UB V_cntx_srinf;
extern V V_lst_current;
extern V V_keyword_tree;
extern C V_sy_ch;
extern C V_sy_cmin;
extern Blk(V_sy_string, 264 );
extern Blk(V_sy_sym, 8 );
extern SL V_sy_ival;
extern G V_sy_rval;
extern UB V_sy_label_flag;
extern Blk(V_sy_ident, 32 );
extern UB V_sy_init_mod;
extern UB V_cmp_macf;
extern UB V_cmp_cobj;
extern V V_pas_obj;
extern UB V_cmp_objf;
extern UB V_cmp_bltt;
extern SL V_cmp_traceopt;
extern UB V_cmp_debugopt;
extern UB V_cmp_range;
extern UB V_cmp_cmpdbg;
extern SL V_cmp_trace;
extern SL V_cmp_tracecount;
extern V PAS__f_output;
extern UB V_pas_compile;
extern UB V_error_result;
extern UB V_emergency_stop;
extern SL V_proc_seq;


/* Function/procedure prototypes. */
void P_lst_open(V *F_p, V F_fspc, V F_heading, V F_title, V F_sbttl, SL F_lnsize
, SL F_pgsize, UB F_bunknown, UB F_bprint, UB F_bappend, SL *F_ierr);
void P_lst_newline();
void P_lst_eoln();
void P_lst_g_init(V F_def_lst, V F_def_heading, SL *F_ierr);
void P_err_init(V F_errf_str);
void P_src_close(V *F_p, UB F_bfree);
void P_src_open(V *F_p, V F_fspc, UB F_bdelete, SL *F_ierr);
void P_src_error(V F_modnam, SL F_number, UB F_severity);
void P_src_end_of_line();
C P_src_inchar();
C P_src_next_char();
void P_src_init(V F_def_prt, V F_def_src);
void P_src_error_s(V F_modulesy, SL F_number, UB F_severity, V F_id1, V F_id2);
void P_val_new(V *F_p, V F_ty);
void P_val_free(V *F_p);
SL P_match(V F_s1, V F_s2);
void P_ide_int_label();
void P_ide_init();
void P_binary_objf_close();
void P_generation_pragma();


/* Procedure/Function : " set_srcfilespc "  */
void P_set_srcfilespc(SL F_icd){
  /* Define the automatic variable space. */
  Blk( Ra, 536 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  register V Rv3;
  register UB Rv4;
  register V Rv5;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[65]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+260;
  Ra.v[66]=Rd.s;
  Ra.v[67]=Rd.s+16;
  Ra.sl[68]=103; /* line # 103 */
  if (F_icd>=0) {
    PAS__STR_TO_STR(Ra.s,PAS__FILE_SPC(Ra.s+276,((V *)V_src_control)[57]));
    if (Ra.ub[1]==0) PAS__STR_TO_STR(Ra.s,Rd.s+78);
    if (F_icd>0||V_srf_list==NULL) {
      Ra.sl[68]=109; /* line # 109 */
      if (V_srf_free==NULL) Rv0=PAS__NEW(8);
      else {
        Rv0=V_srf_free;
        V_srf_free=((V *)Rv0)[0];
      }
      Rv1=Rv0;
      Ra.sl[68]=115; /* line # 115 */
      ((V *)Rv1)[0]=V_srf_list;
      ((V *)Rv1)[1]=NULL;
      P_val_new(((V *)Rv1)+1,NULL);
      V_srf_list=Rv0;
    }
    else {
      Ra.sl[68]=122; /* line # 122 */
      Rv2=V_srf_list;
      P_val_free(((V *)Rv2)+1);
      P_val_new(((V *)Rv2)+1,NULL);
    }
    Ra.sl[68]=127; /* line # 127 */
    Rv3=((V *)V_srf_list)[1];
    ((UB *)Rv3)[36]=32;
    ((SL *)Rv3)[5]=Ra.ub[1];
    Rv4=Ra.ub[1];
    ((V *)Rv3)[10]=PAS__NEW((SL)Rv4+2);
    ((UB *)((V *)Rv3)[10])[0]=Rv4;
    Ra.sl[68]=132; /* line # 132 */
    PAS__STR_TO_STR(((V *)Rv3)[10],Ra.s);
  }
  else {
    Ra.sl[68]=137; /* line # 137 */
    Rv0=V_srf_list;
    Rv5=Rv0;
    V_srf_list=((V *)Rv5)[0];
    P_val_free(((V *)Rv5)+1);
    Ra.sl[68]=142; /* line # 142 */
    ((V *)Rv5)[0]=V_srf_free;
    V_srf_free=Rv0;
  }
  V_cntx_srinf=1;
  PAS__curr_cntx=Ra.v[65];
}


/* Procedure/Function : " compile_set_title "  */
void P_compile_set_title(){
  /* Define the automatic variable space. */
  Blk( Ra, 792 );

  /* Local variable stored in C variable */
  register V Rv0;
  register UB Rv1;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[65]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+260;
  Ra.v[66]=Rd.s+83;
  Ra.v[67]=Rd.s+16;
  Ra.sl[68]=165; /* line # 165 */
  Rv0=V_lst_current;
  if (((V *)Rv0)[4]!=NULL) PAS__DISPOSE(((V *)Rv0)+4);
  PAS__STR_TO_STR(Ra.s,PAS__FILE_SPC(Ra.s+276,((V *)V_src_control)[57]));
  if (Ra.ub[1]==0) PAS__STR_TO_STR(Ra.s,Rd.s+102);
  Ra.sl[68]=170; /* line # 170 */
  PAS__STR_TO_STR(Ra.s,PAS__CON_STR_STR(Ra.s+533,PAS__CON_STR_STR(Ra.s+276,Rd.s+
107,Ra.s),Rd.s+138));
  Rv1=Ra.ub[1];
  ((V *)Rv0)[4]=PAS__NEW((SL)Rv1+2);
  ((UB *)((V *)Rv0)[4])[0]=Rv1;
  PAS__STR_TO_STR(((V *)Rv0)[4],Ra.s);
  PAS__curr_cntx=Ra.v[65];
}


/* Procedure/Function : " compile_set_sbttl "  */
void P_compile_set_sbttl(V F_prc){
  /* Define the automatic variable space. */
  Blk( Ra, 792 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register UB Rv2;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[65]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+260;
  Ra.v[66]=Rd.s+142;
  Ra.v[67]=Rd.s+16;
  Ra.sl[68]=185; /* line # 185 */
  Rv0=V_lst_current;
  if (((V *)Rv0)[5]!=NULL) PAS__DISPOSE(((V *)Rv0)+5);
  if (((V *)F_prc)[3]!=NULL) {
    Rv1=((V *)F_prc)[3];
    Ra.sl[68]=191; /* line # 191 */
    PAS__STR_TO_STR(Ra.s,PAS__SUBSTR_CHT(Ra.s+276,Rv1+1,31,1,((UB *)Rv1)[0]));
    PAS__STR_TO_STR(Ra.s,PAS__CON_STR_STR(Ra.s+533,PAS__CON_STR_STR(Ra.s+276,Rd.
    s+161,Ra.s),Rd.s+196));
    Rv2=Ra.ub[1];
    ((V *)Rv0)[5]=PAS__NEW((SL)Rv2+2);
    ((UB *)((V *)Rv0)[5])[0]=Rv2;
    PAS__STR_TO_STR(((V *)Rv0)[5],Ra.s);
  }
  PAS__curr_cntx=Ra.v[65];
}


/* Procedure/Function : " setkeyword "  */
void PAS_INSMBOL_PRC_00000000(V F_kname, UB F_skw, UB F_opkw){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  SL Rv2;
  V Rv3;
  V Rv4;
  register V Rv5;
  SL Rv6;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+200;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=216; /* line # 216 */
  Rv0=PAS__NEW(42);
  Rv1=Rv0;
  ((UB *)Rv1)[0]=((UB *)F_kname)[1];
  Rv2=1;
  for( Rf0=((UB *)Rv1)[0];Rf0>0;Rf0-- ) {
    ((C *)Rv1)[Rv2]=((C *)F_kname)[Rv2+1];
    Rv2++;
  }
  Ra.sl[3]=221; /* line # 221 */
  ((V *)Rv1)[8]=NULL;
  ((V *)Rv1)[9]=NULL;
  ((UB *)Rv1)[40]=F_skw;
  ((UB *)Rv1)[41]=F_opkw;
  Rv3=V_keyword_tree;
  if (Rv3!=NULL) {
    while (1){
      Ra.sl[3]=228; /* line # 228 */
      Rv4=Rv3;
      Rv5=Rv3;
      Rv6=P_match(Rv0,Rv5);
      if (Rv6>0) Rv3=((V *)Rv5)[9];
      else {
        Ra.sl[3]=233; /* line # 233 */
        Rv3=((V *)Rv5)[8];
      }
      if (Rv3==NULL)  break;
    }
    if (Rv6>0) ((V *)Rv4)[9]=Rv0;
    else((V *)Rv4)[8]=Rv0;
  }
  else {
    Ra.sl[3]=239; /* line # 239 */
    V_keyword_tree=Rv0;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " set_keyword_tree "  */
void PAS_INSMBOL_set_keyword_tree(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+212;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=243; /* line # 243 */
  V_keyword_tree=NULL;
  PAS_INSMBOL_PRC_00000000(Rd.s+230,13,21);
  Ra.sl[3]=248; /* line # 248 */
  PAS_INSMBOL_PRC_00000000(Rd.s+234,13,22);
  PAS_INSMBOL_PRC_00000000(Rd.s+239,12,20);
  PAS_INSMBOL_PRC_00000000(Rd.s+244,6,0);
  PAS_INSMBOL_PRC_00000000(Rd.s+249,8,8);
  PAS_INSMBOL_PRC_00000000(Rd.s+254,8,9);
  Ra.sl[3]=253; /* line # 253 */
  PAS_INSMBOL_PRC_00000000(Rd.s+259,8,10);
  PAS_INSMBOL_PRC_00000000(Rd.s+264,10,23);
  Ra.sl[3]=258; /* line # 258 */
  PAS_INSMBOL_PRC_00000000(Rd.s+268,28,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+273,33,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+280,34,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+286,30,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+292,29,29);
  Ra.sl[3]=263; /* line # 263 */
  PAS_INSMBOL_PRC_00000000(Rd.s+299,32,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+315,31,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+320,36,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+328,37,29);
  Ra.sl[3]=268; /* line # 268 */
  PAS_INSMBOL_PRC_00000000(Rd.s+337,44,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+346,39,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+354,40,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+360,41,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+367,42,29);
  Ra.sl[3]=273; /* line # 273 */
  PAS_INSMBOL_PRC_00000000(Rd.s+375,43,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+380,74,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+385,59,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+390,60,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+396,61,29);
  Ra.sl[3]=278; /* line # 278 */
  PAS_INSMBOL_PRC_00000000(Rd.s+405,62,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+411,63,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+418,64,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+427,65,29);
  Ra.sl[3]=283; /* line # 283 */
  PAS_INSMBOL_PRC_00000000(Rd.s+435,66,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+441,67,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+449,68,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+456,69,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+463,70,29);
  Ra.sl[3]=288; /* line # 288 */
  PAS_INSMBOL_PRC_00000000(Rd.s+472,71,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+480,76,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+489,75,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+497,77,29);
  Ra.sl[3]=293; /* line # 293 */
  PAS_INSMBOL_PRC_00000000(Rd.s+508,78,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+518,79,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+526,80,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+535,87,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+543,82,29);
  Ra.sl[3]=298; /* line # 298 */
  PAS_INSMBOL_PRC_00000000(Rd.s+551,38,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+559,81,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+569,83,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+579,84,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+587,72,29);
  Ra.sl[3]=303; /* line # 303 */
  PAS_INSMBOL_PRC_00000000(Rd.s+594,45,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+598,46,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+604,47,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+610,48,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+617,49,29);
  Ra.sl[3]=308; /* line # 308 */
  PAS_INSMBOL_PRC_00000000(Rd.s+625,50,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+632,51,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+637,55,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+643,56,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+649,57,29);
  Ra.sl[3]=313; /* line # 313 */
  PAS_INSMBOL_PRC_00000000(Rd.s+655,58,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+661,73,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+666,86,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+677,85,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+681,54,29);
  Ra.sl[3]=318; /* line # 318 */
  PAS_INSMBOL_PRC_00000000(Rd.s+685,52,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+689,53,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+697,90,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+706,91,29);
  Ra.sl[3]=323; /* line # 323 */
  PAS_INSMBOL_PRC_00000000(Rd.s+717,92,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+722,93,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+730,94,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+740,95,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+747,96,29);
  Ra.sl[3]=328; /* line # 328 */
  PAS_INSMBOL_PRC_00000000(Rd.s+755,99,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+764,98,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+774,100,29);
  Ra.sl[3]=335; /* line # 335 */
  PAS_INSMBOL_PRC_00000000(Rd.s+783,101,29);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " nextch "  */
void PAS_INSMBOL_PRC_00000001(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+789;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=422; /* line # 422 */
  V_sy_ch=P_src_inchar();
  V_sy_cmin=V_sy_ch;
  if (V_sy_ch>=65&&V_sy_ch<=90) V_sy_cmin=(C)((SL)V_sy_ch+32);
  if (V_sy_cmin>127) V_sy_cmin=63;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " put_char "  */
void PAS_INSMBOL_PRC_00000002(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+797;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=431; /* line # 431 */
  if (!Lx[0].ub[0]) {
    if (Lx[0].sl[1]<V_sy_string.ub[0]) {
      V_sy_string.c[Lx[0].sl[1]+1]=V_sy_ch;
      Lx[0].sl[1]=Lx[0].sl[1]+1;
    }
    else {
      Ra.sl[3]=439; /* line # 439 */
      P_src_error(Rd.s+809,12,2);
      Lx[0].ub[0]=1;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " test_figures "  */
SL PAS_INSMBOL_PRC_00000003(C F_ch){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+813;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=450; /* line # 450 */
  if (F_ch>=48&&F_ch<=57) Rv0=(SL)F_ch-48;
  else {
    if ((Lx[0].ub[8]&&F_ch>=97)&&F_ch<=102) Rv0=(10+(SL)F_ch)-97;
    else Rv0=-1;
  }
  if ((double)Rv0>=Lx[0].g[2]) Rv0=-2;
  Ra.sl[3]=455; /* line # 455 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " figures "  */
SL PAS_INSMBOL_PRC_00000004(C F_ch){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+827;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=466; /* line # 466 */
  Rv0=PAS_INSMBOL_PRC_00000003(F_ch);
  if (Rv0==-2) {
    Rv0=0;
    P_src_error(Rd.s+838,16,2);
  }
  Ra.sl[3]=471; /* line # 471 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " insymbol_src "  */
void P_insymbol_src(){
  /* Define the automatic variable space. */
  Blk( Ra, 40 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  SL Rv2;
  G Rv3;
  G Rv4;
  G Rv5;
  G Rv6;
  SL Rv7;
  SL Rv8;
  V Rv9;
  register V Rv10;
  SL Rv11;
  register V Rv12;
  UB Rv13;
  UB Rv14;
  SL Rv15;
  register V Rv16;
  C Rv17;
  register G Rgg;
  register P Lx_Sv;
  Lx_Sv=Lx[0];
  Lx[0].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[6]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+24;
  Ra.v[7]=Rd.s+842;
  Ra.v[8]=Rd.s+16;
  Ra.sl[9]=477; /* line # 477 */
  while (V_sy_ch==32)
  PAS_INSMBOL_PRC_00000001();
  Rv0=1;
  Rv1=V_src_control;
  ((SL *)Rv1)[2]=((SL *)Rv1)[3];
  switch (Ri.ub[V_sy_cmin]) {
    case 2:
    case 8:Ra.sl[9]=484; /* line # 484 */
    V_sy_sym.ub[0]=20;
    V_sy_sym.ub[1]=29;
    Rv2=0;
    Rv3=0.000000000000000E-001;
    Rv4=1.000000000000000E+001;
    Rv5=1.000000000000000E+000;
    Ra.g[2]=1.000000000000000E+001;
    Ra.ub[8]=0;
    Ra.sl[9]=489; /* line # 489 */
    while (Ri.ub[V_sy_cmin]==2){
      V_sy_sym.ub[0]=2;
      Rv6=(double)((SL)V_sy_cmin-48);
      PAS_INSMBOL_PRC_00000001();
      Ra.sl[9]=494; /* line # 494 */
      Rv3=Rv3*1.000000000000000E+001+Rv6;
      Rv2=Rv2+1;
    }
    if (V_sy_sym.ub[0]==2&&V_sy_ch==35) {
      Ra.sl[9]=500; /* line # 500 */
      PAS_INSMBOL_PRC_00000001();
      Rv7=(Rv3>0.0?(SL)(Rv3+0.5):(SL)(Rv3-0.5));
      Rv3=0.000000000000000E-001;
      if (Rv7<2||Rv7>16) {
        Ra.sl[9]=505; /* line # 505 */
        P_src_error(Rd.s+809,14,2);
        Rv7=10;
      }
      else Ra.g[2]=(double)Rv7;
      Ra.ub[8]=1;
      while (1){
        Ra.sl[9]=511; /* line # 511 */
        Rv6=(double)PAS_INSMBOL_PRC_00000004(V_sy_cmin);
        if (Rv6<0.000000000000000E-001)  break;
        Rv3=Rv3*Ra.g[2]+Rv6;
        PAS_INSMBOL_PRC_00000001();
      }
    }
    Ra.sl[9]=518; /* line # 518 */
    if (V_sy_ch==46) {
      if (P_src_next_char()==46) {
        if (V_sy_sym.ub[0]==20) {
          Ra.sl[9]=523; /* line # 523 */
          PAS_INSMBOL_PRC_00000001();
          V_sy_sym.ub[0]=21;
        }
        else Rv0=0;
      }
      else {
        Ra.sl[9]=529; /* line # 529 */
        PAS_INSMBOL_PRC_00000001();
        if (PAS_INSMBOL_PRC_00000003(V_sy_cmin)<0) Rv0=0;
        else {
          Ra.sl[9]=534; /* line # 534 */
          V_sy_sym.ub[0]=4;
          while (1){
            Rv6=(double)PAS_INSMBOL_PRC_00000004(V_sy_cmin);
            if (Rv6<0.000000000000000E-001)  break;
            PAS_INSMBOL_PRC_00000001();
            Ra.sl[9]=539; /* line # 539 */
            Rv5=Rv5/Ra.g[2];
            Rv3=Rv3+Rv5*Rv6;
            Rv2=Rv2+1;
          }
        }
      }
    }
    Ra.sl[9]=547; /* line # 547 */
    if (V_sy_sym.ub[0]!=20&&V_sy_sym.ub[0]!=21) {
      if (V_sy_cmin==101||Ra.ub[8]&&V_sy_cmin==36) {
        V_sy_sym.ub[0]=4;
        Ra.sl[9]=552; /* line # 552 */
        PAS_INSMBOL_PRC_00000001();
        if (V_sy_ch==43||V_sy_ch==45) {
          if (V_sy_ch==45) Rv4=1.000000000000000E+000/Rv4;
          PAS_INSMBOL_PRC_00000001();
        }
        Ra.sl[9]=558; /* line # 558 */
        Rv8=0;
        while (Ri.ub[V_sy_cmin]==2){
          Rv8=Rv8*10+((SL)V_sy_ch-48);
          PAS_INSMBOL_PRC_00000001();
        }
        Ra.sl[9]=564; /* line # 564 */
        if (Rv8>307) {
          P_src_error(Rd.s+809,11,2);
          Rv8=307;
          Rv3=1.000000000000000E+000;
        }
        else {
          Ra.sl[9]=571; /* line # 571 */
          if (Rv8>38) Rv2=8;
        }
        Rv5=1.000000000000000E+000;
        while (Rv8!=0)
        if (Rv8&1) {
          Ra.sl[9]=577; /* line # 577 */
          Rv8=Rv8-1;
          Rv5=Rv5*Rv4;
        }
        else {
          Ra.sl[9]=582; /* line # 582 */
          Rv8=Rv8/2;
          Rv4=Rv4*Rv4;
        }
        Rv3=Rv3*Rv5;
      }
      Ra.sl[9]=589; /* line # 589 */
      if (V_sy_sym.ub[0]==2) {
        if (Rv3<=4.294967295000001E+009&&Rv3>=-2.147483648000000E+009) {
          if (Rv3>2.147483647000000E+009) V_sy_ival=(int)(4.294967295000001E+009-
          Rv3)+1;
          else V_sy_ival=(int)(Rv3);
          Ra.sl[9]=594; /* line # 594 */
          V_sy_rval=(double)V_sy_ival;
          if ((V_sy_label_flag&&Ri.ub[V_sy_cmin]==5)&&P_src_next_char()!=61) {
            PAS_INSMBOL_PRC_00000001();
            Ra.sl[9]=599; /* line # 599 */
            P_ide_int_label();
            V_sy_sym.ub[0]=1;
          }
        }
        else {
          Ra.sl[9]=605; /* line # 605 */
          V_sy_ival=0;
          if (Rv2>7) V_sy_sym.ub[0]=4;
          else V_sy_sym.ub[0]=3;
        }
      }
      else {
        Ra.sl[9]=610; /* line # 610 */
        if (Rv2<=7) V_sy_sym.ub[0]=3;
      }
      V_sy_rval=Rv3;
      Rv0=0;
    }
    break;
    case 3:Ra.sl[9]=618; /* line # 618 */
    V_sy_ident.ub[0]=0;
    while (1){
      if (V_sy_ident.ub[0]<31) {
        Ra.sl[9]=625; /* line # 625 */
        V_sy_ident.ub[0]=V_sy_ident.ub[0]+1;
        V_sy_ident.c[V_sy_ident.ub[0]]=V_sy_cmin;
      }
      PAS_INSMBOL_PRC_00000001();
      if (Ri.ub[V_sy_cmin]!=3&&Ri.ub[V_sy_cmin]!=2)  break;
    }
    Ra.sl[9]=631; /* line # 631 */
    Rv9=V_keyword_tree;
    while (1){
      Rv10=Rv9;
      Rv11=P_match(V_sy_ident.s,Rv10);
      Ra.sl[9]=636; /* line # 636 */
      if (Rv11!=0) {
        if (Rv11>0) Rv9=((V *)Rv10)[9];
        else Rv9=((V *)Rv10)[8];
      }
      if (Rv11==0||Rv9==NULL)  break;
    }
    if (Rv9==NULL) {
      Ra.sl[9]=642; /* line # 642 */
      if ((V_sy_label_flag&&Ri.ub[V_sy_cmin]==5)&&P_src_next_char()!=61) {
        PAS_INSMBOL_PRC_00000001();
        V_sy_sym.ub[0]=1;
      }
      else {
        Ra.sl[9]=649; /* line # 649 */
        V_sy_sym.ub[0]=0;
      }
      V_sy_sym.ub[1]=29;
    }
    else memcpy(V_sy_sym.s,Rv9+40,2);
    Ra.sl[9]=654; /* line # 654 */
    Rv0=0;
    break;
    case 4:Ra.sl[9]=659; /* line # 659 */
    V_sy_sym.ub[1]=29;
    Rv12=V_src_control;
    Rv13=(1024&((UL *)Rv12)[52])!=0;
    Ra.sl[9]=664; /* line # 664 */
    ((UB *)Rv12)[212]=4;
    ((UL *)Rv12)[52]=((UL *)Rv12)[52]|1024;
    V_sy_sym.ub[0]=5;
    Ra.sl[1]=1;
    Ra.ub[0]=0;
    Ra.sl[9]=669; /* line # 669 */
    Rv14=1;
    while (Rv14){
      PAS_INSMBOL_PRC_00000001();
      while (Ri.ub[V_sy_cmin]==10)
      PAS_INSMBOL_PRC_00000001();
      Ra.sl[9]=674; /* line # 674 */
      if (Ri.ub[V_sy_cmin]==9) Rv14=0;
      if (V_sy_ch==39) {
        ((UB *)V_src_control)[212]=0;
        PAS_INSMBOL_PRC_00000001();
        Ra.sl[9]=679; /* line # 679 */
        if (V_sy_ch==39) {
          ((UB *)V_src_control)[212]=4;
          PAS_INSMBOL_PRC_00000002();
        }
        else {
          Ra.sl[9]=684; /* line # 684 */
          Rv14=0;
        }
      }
      else {
        if (V_sy_ch==92) {
          PAS_INSMBOL_PRC_00000001();
          Ra.sl[9]=689; /* line # 689 */
          switch (V_sy_cmin) {
            case 34:
            case 39:
            case 92:break;
            case 97:V_sy_ch=7;
            break;
            case 98:V_sy_ch=8;
            break;
            case 101:V_sy_ch=27;
            break;
            case 102:Ra.sl[9]=694; /* line # 694 */
            V_sy_ch=12;
            break;
            case 110:V_sy_ch=10;
            break;
            case 114:V_sy_ch=13;
            break;
            case 116:V_sy_ch=9;
            break;
            case 118:V_sy_ch=11;
            break;
            case 122:Ra.sl[9]=699; /* line # 699 */
            V_sy_ch=0;
            break;
            case 48:
            case 49:
            case 50:
            case 51:
            case 52:
            case 53:
            case 54:
            case 55:
            case 56:
            case 57:Rv11=(SL)V_sy_cmin-48;
            PAS_INSMBOL_PRC_00000001();
            Rv15=3;
            Ra.sl[9]=704; /* line # 704 */
            while ((Rv15>0&&V_sy_cmin>=48)&&V_sy_cmin<=57){
              Rv11=(Rv11*10+(SL)V_sy_cmin)-48;
              PAS_INSMBOL_PRC_00000001();
            }
            Ra.sl[9]=709; /* line # 709 */
            if (Rv11<=255) V_sy_ch=(C)Rv11;
            else {
              V_sy_ch=32;
              P_src_error(Rd.s+809,17,2);
            }
            break;
            default:V_sy_ch=32;
            P_src_error(Rd.s+809,18,2);
            break;
          }
          Ra.sl[9]=715; /* line # 715 */
          PAS_INSMBOL_PRC_00000002();
        }
        else PAS_INSMBOL_PRC_00000002();
      }
    }
    V_sy_string.ub[1]=Ra.sl[1] -1;
    Ra.sl[9]=720; /* line # 720 */
    Rv0=0;
    Rv16=V_src_control;
    if (!Rv13) {
      ((UL *)Rv16)[52]=((UL *)Rv16)[52]&~1024;
      Ra.sl[9]=725; /* line # 725 */
      if (Ri.ub[V_sy_cmin]==10) V_sy_ch=32;
    }
    break;
    case 5:Ra.sl[9]=731; /* line # 731 */
    PAS_INSMBOL_PRC_00000001();
    V_sy_sym.ub[1]=29;
    if (V_sy_ch==61) V_sy_sym.ub[0]=23;
    else {
      Ra.sl[9]=736; /* line # 736 */
      V_sy_sym.ub[0]=22;
      Rv0=0;
    }
    break;
    case 6:Ra.sl[9]=743; /* line # 743 */
    PAS_INSMBOL_PRC_00000001();
    V_sy_sym.ub[0]=10;
    if (V_sy_ch==61) V_sy_sym.ub[1]=15;
    else {
      if (V_sy_ch==62) V_sy_sym.ub[1]=18;
      else {
        Ra.sl[9]=750; /* line # 750 */
        V_sy_sym.ub[1]=14;
        Rv0=0;
      }
    }
    break;
    case 7:Ra.sl[9]=757; /* line # 757 */
    PAS_INSMBOL_PRC_00000001();
    V_sy_sym.ub[0]=10;
    if (V_sy_ch==61) V_sy_sym.ub[1]=16;
    else {
      Ra.sl[9]=762; /* line # 762 */
      V_sy_sym.ub[1]=17;
      Rv0=0;
    }
    break;
    case 11:Ra.sl[9]=769; /* line # 769 */
    Rv17=V_sy_ch;
    PAS_INSMBOL_PRC_00000001();
    if (V_sy_ch==Rv17) {
      V_sy_sym.ub[0]=9;
      Ra.sl[9]=774; /* line # 774 */
      V_sy_sym.ub[1]=13;
    }
    else {
      V_sy_sym.ub[0]=13;
      Ra.sl[9]=779; /* line # 779 */
      V_sy_sym.ub[1]=21;
      Rv0=0;
    }
    break;
    case 12:
    case 13:
    case 14:
    case 15:
    case 17:
    case 18:
    case 19:
    case 20:
    case 21:
    case 23:
    case 24:
    case 25:
    case 26:Ra.sl[9]=785; /* line # 785 */
    memcpy(V_sy_sym.s,(Ri.s+Ri.ub[V_sy_cmin]*2+106),2);
    break;
    case 16:PAS_INSMBOL_PRC_00000001();
    Ra.sl[9]=790; /* line # 790 */
    if (V_sy_ch==42) {
      V_sy_sym.ub[0]=7;
      V_sy_sym.ub[1]=5;
    }
    else {
      Ra.sl[9]=797; /* line # 797 */
      memcpy(V_sy_sym.s,Ri.s+138,2);
      Rv0=0;
    }
    break;
    case 22:Ra.sl[9]=804; /* line # 804 */
    PAS_INSMBOL_PRC_00000001();
    if (V_sy_ch==62) {
      V_sy_sym.ub[0]=26;
      V_sy_sym.ub[1]=29;
    }
    else {
      Ra.sl[9]=812; /* line # 812 */
      memcpy(V_sy_sym.s,Ri.s+150,2);
      Rv0=0;
    }
    break;
    case 9:Ra.sl[9]=819; /* line # 819 */
    V_sy_sym.ub[0]=101;
    V_sy_sym.ub[1]=29;
    break;
    case 10:Ra.sl[9]=825; /* line # 825 */
    V_sy_sym.ub[0]=88;
    V_sy_sym.ub[1]=29;
    Rv0=0;
    V_sy_ch=32;
    break;
    default:Ra.sl[9]=832; /* line # 832 */
    V_sy_sym.ub[0]=102;
    V_sy_sym.ub[1]=29;
    Rv0=0;
    if (V_sy_ch!=32) P_src_error(Rd.s+809,13,2);
    V_sy_ch=32;
    break;
  }
  Ra.sl[9]=839; /* line # 839 */
  if (Rv0) PAS_INSMBOL_PRC_00000001();
  PAS__curr_cntx=Ra.v[6];
  Lx[0]=Lx_Sv;
}


/* Procedure/Function : " m_expression "  */
void PAS_INSMBOL_m_expression(){

  /* Code of procedure/function */
}


/* Procedure/Function : " pragma_mstate "  */
void PAS_INSMBOL_PRC_00000005(V F_p_src){
  /* Define the automatic variable space. */
  Blk( Ra, 1048 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  UL Rv2;
  UB Rv3;
  UB Rv4;
  register V Rv5;
  SL Rv6;
  register UB Rv7;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  PAS__STR_TO_STR(Ra.s,Rd.s+856);
  Ra.ub[257]=255;
  PAS__STR_TO_STR(Ra.s+257,Rd.s+856);
  Ra.ub[514]=255;
  PAS__STR_TO_STR(Ra.s+514,Rd.s+856);
  Ra.ub[771]=255;
  PAS__STR_TO_STR(Ra.s+771,Rd.s+856);
  Ra.v[257]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+1028;
  Ra.v[258]=Rd.s+1113;
  Ra.v[259]=Rd.s+16;
  Ra.sl[260]=933; /* line # 933 */
  Rv0=V_sy_label_flag;
  V_sy_label_flag=0;
  Rv1=F_p_src;
  Rv2=((UL *)Rv1)[52];
  Ra.sl[260]=938; /* line # 938 */
  while (V_sy_sym.ub[0]==0){
    Rv3=0;
    Rv4=0;
    while (1){
      Ra.sl[260]=943; /* line # 943 */
      Rv3=P_match(V_sy_ident.s,(Ri.s+Rv4*32+160))==0;
      if (Rv3||Rv4==21)  break;
      Rv4=Rv4+1;
    }
    P_insymbol_src();
    Ra.sl[260]=948; /* line # 948 */
    switch (Rv4) {
      case 0:if (V_sy_sym.ub[0]==5) {
        if (V_sy_ident.ub[0]>0) {
          Ra.sl[260]=953; /* line # 953 */
          Rv5=V_lst_current;
          if (((UB *)((V *)Rv5)[1])[1]>0) P_lst_eoln();
          Ra.sl[260]=958; /* line # 958 */
          PAS__STR_TO_STR(Ra.s,V_sy_string.s);
          P_insymbol_src();
          if (((V *)Rv5)[2]!=NULL) PAS__STR_TO_STR(Ra.s+257,((V *)Rv5)[2]);
          if (((V *)Rv5)[4]!=NULL) PAS__STR_TO_STR(Ra.s+514,((V *)Rv5)[4]);
          if (((V *)Rv5)[5]!=NULL) PAS__STR_TO_STR(Ra.s+771,((V *)Rv5)[5]);
          Ra.sl[260]=964; /* line # 964 */
          P_lst_open(&V_lst_current, Ra.s,Ra.s+257,Ra.s+514,Ra.s+771,132,-1,0,0,0,
          &Rv6);
          Ra.sl[260]=976; /* line # 976 */
          if (Rv6!=0) {
            if (!V_sy_init_mod) P_src_error(Rd.s+1130,905,2);
            else {
              Ra.sl[260]=981; /* line # 981 */
              Rv2=Rv2&~1;
            }
          }
          else {
            if (((SL *)Rv1)[6]<((SL *)Rv1)[5]) ((SL *)Rv1)[6]=((SL *)Rv1)[5];
            Rv2=Rv2|1;
          }
        }
        else {
          Ra.sl[260]=989; /* line # 989 */
          Rv2=Rv2&~1;
        }
      }
      else {
        if (((SL *)Rv1)[6]<((SL *)Rv1)[5]) ((SL *)Rv1)[6]=((SL *)Rv1)[5];
        Rv2=Rv2|1;
      }
      break;
      case 1:Ra.sl[260]=997; /* line # 997 */
      Rv2=Rv2&~1;
      break;
      case 2:Rv2=Rv2|32;
      break;
      case 3:Rv2=Rv2&~32;
      break;
      case 4:Ra.sl[260]=1004; /* line # 1004 */
      if (V_sy_sym.ub[0]==22) P_insymbol_src();
      if (V_sy_sym.ub[0]==2) {
        ((SL *)Rv1)[6]=V_sy_ival;
        P_insymbol_src();
      }
      else {
        Ra.sl[260]=1010; /* line # 1010 */
        ((SL *)Rv1)[6]=1;
      }
      break;
      case 5:Ra.sl[260]=1015; /* line # 1015 */
      if (V_sy_sym.ub[0]==22) P_insymbol_src();
      if (V_sy_sym.ub[0]==2) {
        ((SL *)Rv1)[9]=V_sy_ival;
        P_insymbol_src();
      }
      else {
        Ra.sl[260]=1021; /* line # 1021 */
        ((SL *)Rv1)[9]=1;
      }
      if (V_sy_sym.ub[0]==22) P_insymbol_src();
      if (V_sy_sym.ub[0]==2) {
        ((SL *)Rv1)[10]=V_sy_ival;
        P_insymbol_src();
      }
      else((SL *)Rv1)[10]=255;
      break;
      case 6:Ra.sl[260]=1028; /* line # 1028 */
      V_cmp_macf=1;
      break;
      case 7:V_cmp_macf=0;
      break;
      case 8:V_cmp_cobj=1;
      break;
      case 9:V_cmp_cobj=0;
      break;
      case 10:Ra.sl[260]=1035; /* line # 1035 */
      if (V_sy_sym.ub[0]==5) {
        if (V_sy_ident.ub[0]>0) {
          if (V_pas_obj!=NULL) P_binary_objf_close();
          Rv7=V_sy_string.ub[1];
          V_pas_obj=PAS__NEW((SL)Rv7+2);
          ((UB *)V_pas_obj)[0]=Rv7;
          Ra.sl[260]=1040; /* line # 1040 */
          PAS__STR_TO_STR(V_pas_obj,V_sy_string.s);
          P_insymbol_src();
          V_cmp_objf=1;
        }
        else P_src_error(Rd.s+1130,904,4);
      }
      else {
        Ra.sl[260]=1046; /* line # 1046 */
        if (V_cmp_objf) P_binary_objf_close();
        V_cmp_objf=0;
      }
      break;
      case 11:if (V_cmp_objf) {
        Ra.sl[260]=1052; /* line # 1052 */
        P_binary_objf_close();
        V_cmp_objf=0;
      }
      break;
      case 12:V_cmp_bltt=1;
      break;
      case 13:V_cmp_bltt=0;
      break;
      case 14:Ra.sl[260]=1059; /* line # 1059 */
      if (V_sy_sym.ub[0]==2) {
        V_cmp_traceopt=V_sy_ival;
        Ra.sl[260]=1064; /* line # 1064 */
        P_insymbol_src();
      }
      else P_src_error(Rd.s+1130,906,3);
      break;
      case 15:V_cmp_debugopt=1;
      break;
      case 16:Ra.sl[260]=1069; /* line # 1069 */
      V_cmp_debugopt=0;
      break;
      case 17:V_cmp_range=1;
      break;
      case 18:V_cmp_range=0;
      break;
      case 19:Ra.sl[260]=1074; /* line # 1074 */
      P_generation_pragma();
      break;
      case 20:V_cmp_cmpdbg=1;
      break;
      case 21:V_cmp_cmpdbg=0;
      break;
      default:Ra.sl[260]=1080; /* line # 1080 */
      P_src_error_s(Rd.s+1130,901,1, V_sy_ident.s,NULL);
      break;
    }
    if (V_sy_sym.ub[0]==18) P_insymbol_src();
  }
  if (V_sy_sym.ub[0]!=19) P_src_error(Rd.s+1130,21,2);
  Ra.sl[260]=1085; /* line # 1085 */
  ((UL *)Rv1)[52]=Rv2;
  V_sy_label_flag=Rv0;
  PAS__curr_cntx=Ra.v[257];
}


/* Procedure/Function : " include_mstate "  */
void PAS_INSMBOL_PRC_00000006(UB F_bincl, UB F_bnsferr){
  /* Define the automatic variable space. */
  Blk( Ra, 536 );

  /* Local variable stored in C variable */
  V Rv0;
  SL Rv1;
  SL Rv2;
  register V Rv3;
  register V Rv4;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[65]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+260;
  Ra.v[66]=Rd.s+1134;
  Ra.v[67]=Rd.s+16;
  Ra.sl[68]=1103; /* line # 1103 */
  if (V_sy_sym.ub[0]==5) {
    Rv0=NULL;
    PAS__STR_TO_STR(Ra.s,V_sy_string.s);
    Ra.sl[68]=1108; /* line # 1108 */
    Rv1=PAS__NINDEX_CHA(Ra.s+2,(SL)Ra.ub[1],46,-1,-1,1);
    if (Rv1==0) PAS__STR_TO_STR(Ra.s,PAS__CON_STR_STR(Ra.s+276,Ra.s,Rd.s+1150));
    P_insymbol_src();
    P_src_open(&Rv0, Ra.s,0, &Rv2);
    if (Rv2==0) {
      Ra.sl[68]=1114; /* line # 1114 */
      Rv3=Rv0;
      ((V *)Rv3)[1]=V_src_control;
      ((SL *)Rv3)[5]=((SL *)V_src_control)[5];
      if (F_bincl) ((SL *)Rv3)[5]=((SL *)Rv3)[5]+1;
      Ra.sl[68]=1119; /* line # 1119 */
      ((SL *)Rv3)[6]=((SL *)V_src_control)[6];
      ((SL *)Rv3)[4]=((SL *)V_src_control)[4];
      ((SL *)Rv3)[9]=((SL *)V_src_control)[9];
      ((SL *)Rv3)[10]=((SL *)V_src_control)[10];
      ((UL *)Rv3)[52]=((UL *)Rv3)[52]|((UL *)V_src_control)[52]&103;
      Ra.sl[68]=1127; /* line # 1127 */
      if (V_sy_sym.ub[0]==18) {
        P_insymbol_src();
        PAS_INSMBOL_PRC_00000005(Rv0);
      }
      else {
        Ra.sl[68]=1133; /* line # 1133 */
        if (V_sy_sym.ub[0]!=19) P_src_error(Rd.s+1158,21,2);
      }
      if (!F_bincl) P_src_end_of_line();
      V_src_control=Rv0;
      if (V_cmp_trace>0) V_cmp_tracecount=0;
      P_compile_set_title();
      Ra.sl[68]=1138; /* line # 1138 */
      P_set_srcfilespc((SL)F_bincl);
      V_sy_ch=32;
      V_sy_sym.ub[0]=99;
      if (!F_bincl) {
        Ra.sl[68]=1143; /* line # 1143 */
        Rv4=V_src_control;
        Rv0=((V *)Rv4)[1];
        ((V *)Rv4)[1]=((V *)Rv0)[1];
        Ra.sl[68]=1148; /* line # 1148 */
        P_src_close(&Rv0,1);
      }
    }
    else {
      P_lst_newline();
      Ra.sl[68]=1153; /* line # 1153 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+1162,-1,-1,32);
      PAS__WRITE_INT(Rv2,3,0);
      PAS__WRITE_EOLN();
      P_lst_newline();
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+1184,-1,-1,32);
      PAS__WRITE_STR(Ra.s,-1,-1,32);
      PAS__WRITE_STR(Rd.s+1208,-1,-1,32);
      PAS__WRITE_EOLN();
      PAS__GET_RTLMSG(Rv2, Ra.s);
      P_lst_newline();
      Ra.sl[68]=1158; /* line # 1158 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+1212,-1,-1,32);
      PAS__WRITE_STR(Ra.s,-1,-1,32);
      PAS__WRITE_EOLN();
      while ((V_sy_sym.ub[0]!=19&&V_sy_sym.ub[0]!=89)&&V_sy_sym.ub[0]!=101)
      P_insymbol_src();
      if (F_bnsferr) {
        Ra.sl[68]=1163; /* line # 1163 */
        P_src_error(Rd.s+1158,902,4);
      }
      else P_src_error(Rd.s+1158,902,3);
    }
  }
  else {
    Ra.sl[68]=1168; /* line # 1168 */
    P_src_error(Rd.s+1158,903,4);
  }
  PAS__curr_cntx=Ra.v[65];
}


/* Procedure/Function : " endfile_mstate "  */
void PAS_INSMBOL_PRC_00000007(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1229;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=1177; /* line # 1177 */
  P_set_srcfilespc(-1);
  Rv0=V_src_control;
  if (((V *)Rv0)[1]==NULL) V_sy_sym.ub[0]=89;
  else {
    Ra.sl[3]=1183; /* line # 1183 */
    Rv1=V_src_control;
    V_src_control=((V *)Rv1)[1];
    P_src_close(&Rv1,1);
    V_sy_ch=32;
    P_compile_set_title();
  }
  Ra.sl[3]=1189; /* line # 1189 */
  if (V_cmp_trace>0) V_cmp_tracecount=0;
  if (V_sy_sym.ub[0]==89) V_pas_compile=0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " insymbol "  */
void P_insymbol(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1245;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=1216; /* line # 1216 */
  P_insymbol_src();
  while (V_sy_sym.ub[0]>=98){
    Rv0=V_sy_sym.ub[0];
    if (V_sy_sym.ub[0]!=101) {
      Ra.sl[3]=1221; /* line # 1221 */
      P_insymbol_src();
    }
    switch (Rv0) {
      case 98:
      case 99:PAS_INSMBOL_PRC_00000006(Rv0==98, V_sy_init_mod);
      break;
      case 101:Ra.sl[3]=1226; /* line # 1226 */
      PAS_INSMBOL_PRC_00000007();
      break;
      case 100:PAS_INSMBOL_PRC_00000005(V_src_control);
      break;
      default:Ra.sl[3]=1240; /* line # 1240 */
      P_src_error(Rd.s+1257,997,3);
      break;
    }
    if (V_sy_sym.ub[0]!=89) P_insymbol_src();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " skip_symbol "  */
void P_skip_symbol(UB F_tosymbol, UB F_errflg){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1261;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=1250; /* line # 1250 */
  while (V_sy_sym.ub[0]!=F_tosymbol&&V_sy_sym.ub[0]!=89){
    P_insymbol();
    switch (V_sy_sym.ub[0]) {
      case 42:
      case 55:
      case 57:
      case 72:Ra.sl[3]=1257; /* line # 1257 */
      P_skip_symbol(73,0);
      P_insymbol();
      break;
      case 14:P_skip_symbol(15,0);
      P_insymbol();
      break;
      case 16:Ra.sl[3]=1265; /* line # 1265 */
      P_skip_symbol(17,0);
      P_insymbol();
      break;
      case 49:P_skip_symbol(50,0);
      P_insymbol();
      break;
      case 73:Ra.sl[3]=1272; /* line # 1272 */
      if (F_tosymbol==47||F_errflg) goto L_l_0;
      break;
      default:break;
    }
  }
L_l_0: ;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " insy_init "  */
void P_insy_init(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1274;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=1286; /* line # 1286 */
  P_lst_g_init(Rd.s+1285,Rd.s+1287,&Rv0);
  if (Rv0==0) {
    Ra.sl[3]=1291; /* line # 1291 */
    P_err_init(Rd.s+1341);
    P_src_init(Rd.s+1362,Rd.s+1369);
    Ra.sl[3]=1296; /* line # 1296 */
    if (V_src_control==NULL) {
      V_error_result=4;
      V_emergency_stop=1;
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+1387,-1,-1,32);
      PAS__WRITE_STR(Rd.s+1369,-1,-1,32);
      PAS__WRITE_STR(Rd.s+1411,-1,-1,32);
      PAS__WRITE_EOLN();
    }
    else {
      Ra.sl[3]=1307; /* line # 1307 */
      PAS_INSMBOL_set_keyword_tree();
      V_proc_seq=0;
      V_srf_free=NULL;
      V_srf_list=NULL;
      Ra.sl[3]=1314; /* line # 1314 */
      P_ide_init();
      P_set_srcfilespc(1);
      Ra.sl[3]=1320; /* line # 1320 */
      V_sy_ch=32;
      V_sy_label_flag=0;
    }
  }
  else {
    Ra.sl[3]=1328; /* line # 1328 */
    V_error_result=4;
    V_emergency_stop=1;
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+1428,-1,-1,32);
    PAS__WRITE_STR(Rd.s+1285,-1,-1,32);
    PAS__WRITE_STR(Rd.s+1452,-1,-1,32);
    PAS__WRITE_EOLN();
  }
  PAS__curr_cntx=Ra.v[0];
}
