/*  P A S - P. WOLFERS SOFTWARE: V3.0-A OF 31-OCT-2014 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long long int

/* Include the PAS environment file. */
#include "cpas_defs.h"

/* Declaration of external variables. */
extern V PAS__curr_iptr;


/* Function/procedure prototypes. */
void PAS__ERROR(SL F_nerr);


/* Procedure/Function : " pas__get_double "  */
void P_pas__get_double(G *F_fl, SL F_fld){
  /* Local variable stored in C variable */
  G Rv0;
  G Rv1;
  SL Rv2;
  UB Rv3;
  UB Rv4;
  UB Rv5;
  C Rv6;
  SL Rv7;

  /* Code of procedure/function */
  Rv0=0.000000000000000E-001;
  Rv1=1.000000000000000E-001;
  Rv2=0;
  Rv3=0;
  Rv4=0;
  Rv5=0;
  while (1){
    if (PAS__UFB(PAS__curr_iptr)) PAS__GET(PAS__curr_iptr);
    if (PAS__CURR_EOF()||Rv5>0&&PAS__CURR_EOLN())  break;
    if (F_fld>=0) F_fld=F_fld-1;
    Rv6=((C *)((V *)PAS__curr_iptr)[0])[0];
    switch (Rv6) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
      case 7:
      case 8:
      case 9:
      case 10:
      case 11:
      case 12:
      case 13:
      case 14:
      case 15:
      case 16:
      case 17:
      case 18:
      case 19:
      case 20:
      case 21:
      case 22:
      case 23:
      case 24:
      case 25:
      case 26:
      case 27:
      case 28:
      case 29:
      case 30:
      case 31:
      case 32:if (Rv5>0) goto L_l_0;
      break;
      case 43:
      case 45:switch (Rv5) {
        case 0:Rv5=1;
        if (Rv6==45) Rv3=1;
        break;
        case 4:Rv5=5;
        if (Rv6==45) Rv4=1;
        break;
        default:goto L_l_0;
        break;
      }
      break;
      case 48:
      case 49:
      case 50:
      case 51:
      case 52:
      case 53:
      case 54:
      case 55:
      case 56:
      case 57:Rv7=(SL)Rv6-48;
      switch (Rv5) {
        case 0:
        case 1:
        case 2:Rv0=Rv0*1.000000000000000E+001+(double)Rv7;
        if (Rv5<2) Rv5=2;
        break;
        case 3:Rv0=Rv0+Rv1*(double)Rv7;
        Rv1=Rv1*1.000000000000000E-001;
        break;
        case 4:
        case 5:Rv2=Rv2*10+Rv7;
        if (Rv5<5) Rv5=5;
        break;
        default:break;
      }
      break;
      case 46:if (Rv5<3) Rv5=3;
      else goto L_l_0;
      break;
      case 68:
      case 69:
      case 100:
      case 101:if (Rv5<4) {
        if (Rv5<2) Rv0=1.000000000000000E+000;
        Rv5=4;
      }
      else goto L_l_0;
      break;
      default:if (Rv5>0) goto L_l_0;
      PAS__ERROR(51);
      break;
    }
    PAS__GET(PAS__curr_iptr);
    if (F_fld==0)  break;
  }
L_l_0: ;
  if (Rv5==0) PAS__ERROR(51);
  if (Rv2!=0) {
    if (Rv4) Rv2= -Rv2;
    Rv0=Rv0*PAS__IGPOWER(1.000000000000000E+001,Rv2);
  }
  if (Rv3) Rv0=-Rv0;
  (*F_fl)=Rv0;
}


/* Procedure/Function : " read_double "  */
void PAS__READ_DBLE(G *F_fl, SL F_f){

  /* Code of procedure/function */
  P_pas__get_double(F_fl,F_f);
}


/* Procedure/Function : " read_single "  */
void PAS__READ_SNGL(F *F_fl, SL F_f){
  /* Local variable stored in C variable */
  G Rv0;

  /* Code of procedure/function */
  P_pas__get_double(&Rv0, F_f);
  (*F_fl)=(float)Rv0;
}


/* Procedure/Function : " read_int "  */
void PAS__READ_SL(SL *F_iv, SL F_f){
  /* Local variable stored in C variable */
  G Rv0;
  register G Rgg;

  /* Code of procedure/function */
  P_pas__get_double(&Rv0, F_f);
  (*F_iv)=(Rv0>0.0?(SL)(Rv0+0.5):(SL)(Rv0-0.5));
}


/* Procedure/Function : " read_ul "  */
void PAS__READ_UL(UL *F_iv, SL F_f){
  /* Local variable stored in C variable */
  SL Rv0;

  /* Code of procedure/function */
  PAS__READ_SL(&Rv0, F_f);
  (*F_iv)=Rv0;
}


/* Procedure/Function : " read_sw "  */
void PAS__READ_SW(SW *F_iv, SL F_f){
  /* Local variable stored in C variable */
  SL Rv0;

  /* Code of procedure/function */
  PAS__READ_SL(&Rv0, F_f);
  (*F_iv)=Rv0;
}


/* Procedure/Function : " read_uw "  */
void PAS__READ_UW(UW *F_iv, SL F_f){
  /* Local variable stored in C variable */
  SL Rv0;

  /* Code of procedure/function */
  PAS__READ_SL(&Rv0, F_f);
  (*F_iv)=Rv0;
}


/* Procedure/Function : " read_sb "  */
void PAS__READ_SB(SB *F_iv, SL F_f){
  /* Local variable stored in C variable */
  SL Rv0;

  /* Code of procedure/function */
  PAS__READ_SL(&Rv0, F_f);
  (*F_iv)=Rv0;
}


/* Procedure/Function : " read_ub "  */
void PAS__READ_UB(UB *F_iv, SL F_f){
  /* Local variable stored in C variable */
  SL Rv0;

  /* Code of procedure/function */
  PAS__READ_SL(&Rv0, F_f);
  (*F_iv)=Rv0;
}


/* Procedure/Function : " write_uns "  */
void PAS__WRITE_UNS(UL F_iv, SL F_f, SL F_b){
  /* Define the automatic variable space. */
  Blk( Ra, 72 );

  /* Local variable stored in C variable */
  C Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  register int Rf0;

  /* Code of procedure/function */
  Rv0=32;
  if (F_iv==0) {
    Ra.c[0]=48;
    Rv1=1;
  }
  else {
    if (F_b<2||F_b>16) F_b=10;
    Rv1=0;
    while (F_iv!=0){
      Rv1=Rv1+1;
      Rv2=F_iv%F_b;
      if (Rv2>9) Ra.c[Rv1-1]=(C)((Rv2+65)-10);
      else Ra.c[Rv1-1]=(C)(Rv2+48);
      F_iv=F_iv/F_b;
    }
  }
  if (F_f==0) F_f=Rv1;
  else {
    if (F_f<0) {
      Rv0=48;
      F_f= -F_f;
    }
  }
  Rv3=F_f-Rv1;
  if (Rv3>=0) {
    for( Rf0=Rv3;Rf0>0;Rf0-- )
    PAS__WRITE_CHAR(Rv0);
    while (Rv1>0){
      PAS__WRITE_CHAR(Ra.c[Rv1-1]);
      Rv1=Rv1-1;
    }
  }
  else for( Rf0=F_f;Rf0>0;Rf0-- )
  PAS__WRITE_CHAR(42);
}


/* Procedure/Function : " write_int "  */
void PAS__WRITE_INT(SL F_iv, SL F_f, SL F_b){
  /* Define the automatic variable space. */
  Blk( Ra, 72 );

  /* Local variable stored in C variable */
  C Rv0;
  SL Rv1;
  UB Rv2;
  SL Rv3;
  SL Rv4;
  register int Rf0;

  /* Code of procedure/function */
  Rv0=32;
  if (F_iv==0) {
    Ra.c[0]=48;
    Rv1=1;
    Rv2=0;
  }
  else {
    Rv2=F_iv<0;
    if (F_b<2||F_b>16) F_b=10;
    Rv1=0;
    while (F_iv!=0){
      Rv1=Rv1+1;
      Rv3=abs(F_iv%F_b);
      if (Rv3>9) Ra.c[Rv1-1]=(C)((Rv3+65)-10);
      else Ra.c[Rv1-1]=(C)(Rv3+48);
      F_iv=F_iv/F_b;
    }
  }
  if (F_f==0) F_f=Rv1+(SL)Rv2;
  else {
    if (F_f<0) {
      Rv0=48;
      F_f= -F_f;
    }
  }
  Rv4=F_f-Rv1;
  if (Rv2) Rv4=Rv4-1;
  if (Rv4>=0) {
    if (Rv2&&Rv0==48) PAS__WRITE_CHAR(45);
    for( Rf0=Rv4;Rf0>0;Rf0-- )
    PAS__WRITE_CHAR(Rv0);
    if (Rv2&&Rv0==32) PAS__WRITE_CHAR(45);
    while (Rv1>0){
      PAS__WRITE_CHAR(Ra.c[Rv1-1]);
      Rv1=Rv1-1;
    }
  }
  else for( Rf0=F_f;Rf0>0;Rf0-- )
  PAS__WRITE_CHAR(42);
}


/* Procedure/Function : " put_decimal "  */
void CPAS__RWNUM_put_decimal(G F_dv, SL F_ndig, SL F_pent, UB F_bneg){
  /* Local variable stored in C variable */
  UB Rv0;
  SL Rv1;

  /* Code of procedure/function */
  Rv0=1;
  while (F_ndig>0){
    Rv1=(int)(F_dv*1.000000000000000E+001);
    F_dv=F_dv*1.000000000000000E+001-(double)Rv1;
    if (Rv0) {
      if (Rv1==0&&F_pent>1) PAS__WRITE_CHAR(32);
      else {
        Rv0=0;
        if (F_bneg) PAS__WRITE_CHAR(45);
      }
    }
    if (!Rv0) PAS__WRITE_CHAR((C)(Rv1+48));
    F_ndig=F_ndig-1;
    F_pent=F_pent-1;
    if (F_pent==0&&F_ndig>0) PAS__WRITE_CHAR(46);
  }
}


/* Procedure/Function : " size_double "  */
void CPAS__RWNUM_size_double(G *F_dv, SL *F_iexp, UB *F_bneg, UB F_bfix){
  /* Local variable stored in C variable */
  G Rv0;
  register G Rgg;

  /* Code of procedure/function */
  if ((*F_dv)<0.000000000000000E-001) {
    (*F_dv)=-(*F_dv);
    (*F_bneg)=1;
  }
  else (*F_bneg)=0;
  if ((*F_dv)>0.000000000000000E-001) {
    (*F_iexp)=(Rgg=log((*F_dv))/2.302585124969499E+000+5.000000000000000E-001,Rgg
    >0.0?(SL)(Rgg+0.5):(SL)(Rgg-0.5));
    Rv0=(*F_dv)/PAS__IGPOWER(1.000000000000000E+001,(*F_iexp));
    if (Rv0>=1.000000000000000E+000) {
      Rv0=Rv0*1.000000000000000E-001;
      (*F_iexp)=(*F_iexp)+1;
    }
    else {
      if (Rv0<1.000000000000000E-001) {
        Rv0=Rv0*1.000000000000000E+001;
        (*F_iexp)=(*F_iexp)-1;
      }
    }
    if (F_bfix&&(*F_iexp)<=0) (*F_dv)=(*F_dv)*1.000000000000000E-001;
    else (*F_dv)=Rv0;
  }
  else (*F_iexp)=0;
}


/* Procedure/Function : " pas__put_e_dble "  */
void P_pas__put_e_dble(G F_dv, SL F_fs, SL F_intsz, SL F_dcsz, SL F_es){
  /* Local variable stored in C variable */
  UB Rv0;
  SL Rv1;
  UB Rv2;
  C Rv3;
  SL Rv4;
  UB Rv5;
  SL Rv6;
  SL Rv7;
  SL Rv8;
  register int Rf0;

  /* Code of procedure/function */
  F_es=abs(F_es);
  if (F_dcsz==-1) F_dcsz=7;
  else F_dcsz=abs(F_dcsz);
  if (F_dcsz>20) F_dcsz=20;
  if (F_fs<0) {
    Rv0=1;
    F_fs=abs(F_fs);
  }
  else Rv0=0;
  if (F_fs==0) F_fs=22;
  if (F_intsz<1) F_intsz=1;
  CPAS__RWNUM_size_double(&F_dv, &Rv1, &Rv2,0);
  Rv1=Rv1-F_intsz;
  if (Rv1>=0) Rv3=43;
  else {
    Rv1= -Rv1;
    Rv3=45;
  }
  if (Rv1<10) Rv4=2;
  else {
    if (Rv1<100) Rv4=3;
    else Rv4=4;
  }
  if (Rv4>F_es) F_es=Rv4;
  Rv5=F_dcsz>0;
  Rv6=(((((F_fs-F_dcsz)-F_es)-F_intsz)-(SL)Rv2)-2)-(SL)Rv5;
  if (Rv6<0) {
    if (Rv6<0&&Rv3==43) {
      Rv6=Rv6+1;
      Rv3=32;
    }
    while (F_es>Rv4&&Rv6<0){
      F_es=F_es-1;
      Rv6=Rv6+1;
    }
    if (Rv6<0&&F_dcsz>0) {
      Rv7=Rv6+F_dcsz;
      if (Rv7>0) {
        F_dcsz=Rv7;
        Rv6=0;
      }
      else {
        if (Rv7==-1&&Rv5) {
          F_dcsz=0;
          Rv6=0;
          Rv5=0;
        }
      }
    }
  }
  Rv8=F_dcsz+F_intsz;
  F_dv=F_dv+5.000000000000000E-001*PAS__IGPOWER(1.000000000000000E+001, -Rv8);
  if (F_dv>=1.000000000000000E+000) {
    F_dv=F_dv*1.000000000000000E-001;
    if (Rv3==45) {
      Rv1=Rv1-1;
      if (Rv1==0) Rv3=43;
    }
    else {
      Rv1=Rv1+1;
      if (Rv1>=10) {
        if (Rv3==43) {
          Rv3=32;
          Rv6=Rv6+1;
        }
        if (Rv1==10&&F_es==1) {
          F_es=2;
          Rv6=Rv6-1;
        }
        else {
          if (Rv1==100&&F_es==2) {
            F_es=3;
            Rv6=Rv6-1;
          }
        }
      }
      if (Rv6<0) {
        if (Rv8>1) {
          Rv8=Rv8-1;
          if (F_intsz<=Rv8) {
            if (Rv8==F_intsz) {
              Rv5=0;
              Rv6=Rv6+1;
            }
          }
          else {
            F_intsz=F_intsz-1;
            Rv1=Rv1+1;
          }
          Rv6=Rv6+1;
        }
      }
    }
  }
  if (Rv6<0) for( Rf0=F_fs;Rf0>0;Rf0-- )
  PAS__WRITE_CHAR(42);
  else {
    if (Rv0) Rv6=0;
    if (Rv6>0) for( Rf0=Rv6;Rf0>0;Rf0-- )
    PAS__WRITE_CHAR(32);
    CPAS__RWNUM_put_decimal(F_dv, Rv8, F_intsz, Rv2);
    PAS__WRITE_CHAR(69);
    if (Rv3!=32) PAS__WRITE_CHAR(Rv3);
    PAS__WRITE_INT(Rv1, -F_es,10);
  }
}


/* Procedure/Function : " pas__put_f_dble "  */
void P_pas__put_f_dble(G F_dv, SL F_fs, SL F_dcsz, SL F_dcmin){
  /* Local variable stored in C variable */
  G Rv0;
  SL Rv1;
  UB Rv2;
  SL Rv3;
  UB Rv4;
  SL Rv5;
  SL Rv6;
  SL Rv7;
  SL Rv8;
  register int Rf0;

  /* Code of procedure/function */
  if (F_dcsz==-1) F_dcsz=7;
  else F_dcsz=abs(F_dcsz);
  if (F_dcsz>20) F_dcsz=20;
  if (F_fs<0) F_fs=abs(F_fs);
  if (F_fs==0) F_fs=20;
  if (F_dcmin<0) F_dcmin=abs(F_dcmin);
  Rv0=F_dv;
  CPAS__RWNUM_size_double(&Rv0, &Rv1, &Rv2,1);
  if (Rv1>1) Rv3=Rv1;
  else Rv3=1;
  Rv4=F_dcsz>0;
  Rv5=(((F_fs-(SL)Rv2)-F_dcsz)-Rv3)-(SL)Rv4;
  Rv6=F_dcsz+Rv1;
  Rv7=F_dcsz;
  if ((Rv1<=0&&Rv6<F_dcmin)&&F_dcmin>0) {
    Rv7= -Rv1+F_dcmin;
    Rv5=((F_fs-Rv7)-2)-(SL)Rv2;
    if (!Rv4&&Rv7>0) {
      Rv5=Rv5-1;
      Rv4=1;
    }
  }
  else {
    if (Rv5<0) {
      Rv6=Rv5+Rv7;
      if (Rv6>=0) {
        Rv7=Rv6;
        if (Rv7>0) Rv5=0;
        else {
          Rv4=0;
          Rv5=1;
        }
      }
      else {
        if (Rv6==-1&&Rv4) {
          Rv7=0;
          Rv5=0;
          Rv4=0;
        }
      }
    }
  }
  if (Rv5>=0) {
    Rv8=Rv3+Rv7;
    Rv0=Rv0+5.000000000000000E-001*PAS__IGPOWER(1.000000000000000E+001, -Rv8);
    if (Rv0>=1.000000000000000E+000) {
      Rv0=Rv0*1.000000000000000E-001;
      Rv3=Rv3+1;
      Rv5=Rv5-1;
      Rv8=Rv8+1;
    }
  }
  if (Rv5<0) P_pas__put_e_dble(F_dv, F_fs,1, F_dcsz,0);
  else {
    for( Rf0=Rv5;Rf0>0;Rf0-- )
    PAS__WRITE_CHAR(32);
    CPAS__RWNUM_put_decimal(Rv0, Rv8, Rv3, Rv2);
  }
}


/* Procedure/Function : " write_dble "  */
void PAS__WRITE_DBLE(G F_fl, SL F_f, SL F_d, SL F_s){

  /* Code of procedure/function */
  if (F_f==0) F_f=-22;
  if (F_d<0||F_f<0) P_pas__put_e_dble(F_fl, F_f,1, F_d,3);
  else P_pas__put_f_dble(F_fl, F_f, F_d, F_s);
}


/* Procedure/Function : " write_sngl "  */
void PAS__WRITE_SNGL(F F_fl, SL F_f, SL F_d, SL F_s){

  /* Code of procedure/function */
  if (F_f==0) F_f=-16;
  if (F_d<0||F_f<0) P_pas__put_e_dble((double)F_fl, F_f,1, F_d,2);
  else P_pas__put_f_dble((double)F_fl, F_f, F_d, F_s);
}
